/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.uitools.controls.FloatTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;

public class OptionsSubDialog
extends BaseSubDialog
implements ItemListener {
    public static final String EXCLUDE_CASES_LISTWISE_RADIO = "IDS_OPT_SUBDLG_EX_CASES_LISTWISE_RADIO";
    public static final String EXCLUDE_CASES_VAR_BY_VAR_RADIO = "IDS_OPT_SUBDLG_EX_CASES_VAR_BY_VAR_RADIO";
    public static final String DISPLAY_GROUPS_CHECK = "IDS_OPT_SUBDLG_DISPLAY_GROUPS_CHECK";
    public static final String DISPLAY_CHART_CHECK = "IDS_OPT_SUBDLG_DISPLAY_CHART_CHECK";
    public static final String DISPLAY_ERROR_BARS_CHECK = "IDS_OPT_SUBDLG_DISPLAY_ERROR_BARS_CHECK";
    public static final String CONF_INTERVALS_RADIO = "IDS_OPT_SUBDLG_CONF_INTERVALS_RADIO";
    public static final String STD_ERROR_RADIO = "IDS_OPT_SUBDLG_STD_ERROR_RADIO";
    public static final String STD_DEVIATION_RADIO = "IDS_OPT_SUBDLG_STD_DEVIATION_RADIO";
    public static final String CONF_INTERVAL_LEVEL_PCT_EDIT = "IDS_CONF_INTERVAL_LEVEL_PCT_EDIT";
    public static final String STD_DEVIATION_MULTIPLIER_EDIT = "IDS_STD_DEVIATION_MULTIPLIER_EDIT";
    public static final String STD_ERROR_MULTIPLIER_EDIT = "IDS_STD_ERROR_MULTIPLIER_EDIT";
    public static final int ENABLE_EXCLUDE_RADIOS = 1;
    public static final int ENABLE_DISPLAY_GROUPS_CHECK = 2;
    public static final int ENABLE_DISPLAY_CHART_CHECK = 4;
    public static final int ENABLE_DISPLAY_ERROR_BARS_CHECK = 8;
    public static final int DISABLE_ERROR_BARS_PANEL = 16;
    public static final int CONFIDENCE_INTERVALS_DEPENDS_ON_DISPLAY_ERROR_BARS_CHECK = 32;
    public static final int ERROR_BARS_PANEL_RADIOS_DEPEND_ON_DISPLAY_ERROR_BARS_CHECK = 64;
    public static final int SELECT_DISPLAY_GROUPS_CHECK = 128;
    public static final int SELECT_DISPLAY_CHART_CHECK = 256;
    public static final int SELECT_DISPLAY_ERROR_BARS_CHECK = 512;
    public static final int NO_DEFAULT_EDIT_VALUES = 1024;
    public static final int ENABLE_EXCLUDE_CASES_LISTWISE_RADIO = 2048;
    private static final int CONFIDENCE_LEVEL_PCT_EDIT_DEFAULT = 95;
    private static final int STD_ERROR_MULT_EDIT_DEFAULT = 2;
    private static final int STD_DEV_MULT_EDIT_DEFAULT = 2;
    private JRadioButton mExCasesListwiseRadio;
    private JRadioButton mExCasesVarByVarRadio;
    private JCheckBox mDisplayGroupsCheck;
    private JCheckBox mDisplayChartCheck;
    private JCheckBox mDisplayErrorBarsCheck;
    private JRadioButton mConfidenceRadio;
    private JLabel mLevelLabel;
    private FloatTextField mLevelPctEdit;
    private JRadioButton mStdErrorRadio;
    private JLabel mStdErrorMultLabel;
    private FloatTextField mStdErrorMultEdit;
    private JRadioButton mStdDevRadio;
    private JLabel mStdDevMultLabel;
    private FloatTextField mStdDevMultEdit;
    private int mDisplayRule;
    private JPanel mErrorRepresentsPanel;
    private SpssButtonGroup mExcludeCasesRadioGroup;
    private SpssButtonGroup mErrorBarRadioGroup;

    public OptionsSubDialog(BaseProcedureDialog baseProcedureDialog, int n) {
        this(baseProcedureDialog, null, true, n, 95.0f, 2.0f, 2.0f);
    }

    public OptionsSubDialog(BaseProcedureDialog baseProcedureDialog, int n, float f, float f2, float f3) {
        this(baseProcedureDialog, null, true, n, f, f2, f3);
    }

    public OptionsSubDialog(BaseProcedureDialog baseProcedureDialog, String string, boolean bl, int n, float f, float f2, float f3) {
        super(baseProcedureDialog, string, bl, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.mDisplayRule = n;
        this.setupDisplay(n);
        this.setupListeners(n);
        if (string == null) {
            this.setTitle(this.getResString("IDS_OPT_SUBDLG_OPTIONS_CAPTION"));
        }
        this.setDefaultValues(f, f2, f3);
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        if (this.mConfidenceRadio.isEnabled()) {
            if (!this.mStdErrorRadio.isEnabled() && this.mStdErrorRadio.isSelected()) {
                this.mConfidenceRadio.setSelected(true);
            }
            if (!this.mStdDevRadio.isEnabled() && this.mStdDevRadio.isSelected()) {
                this.mConfidenceRadio.setSelected(true);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mDisplayErrorBarsCheck) {
            boolean bl = this.mDisplayErrorBarsCheck.isSelected();
            if ((this.mDisplayRule & 0x20) == 32) {
                this.mConfidenceRadio.setEnabled(bl);
                this.mLevelLabel.setEnabled(bl);
                this.mLevelPctEdit.setEnabled(bl);
                this.mLevelPctEdit.setOpaque(bl);
            } else if ((this.mDisplayRule & 0x40) == 64) {
                this.mConfidenceRadio.setEnabled(bl);
                this.mLevelLabel.setEnabled(bl && this.mConfidenceRadio.isSelected());
                this.mLevelPctEdit.setEnabled(bl && this.mConfidenceRadio.isSelected());
                this.mLevelPctEdit.setOpaque(bl && this.mConfidenceRadio.isSelected());
                this.mStdErrorRadio.setEnabled(bl);
                this.mStdErrorMultLabel.setEnabled(bl && this.mStdErrorRadio.isSelected());
                this.mStdErrorMultEdit.setEnabled(bl && this.mStdErrorRadio.isSelected());
                this.mStdErrorMultEdit.setOpaque(bl && this.mStdErrorRadio.isSelected());
                this.mStdDevRadio.setEnabled(bl);
                this.mStdDevMultLabel.setEnabled(bl && this.mStdDevRadio.isSelected());
                this.mStdDevMultEdit.setEnabled(bl && this.mStdDevRadio.isSelected());
                this.mStdDevMultEdit.setOpaque(bl && this.mStdDevRadio.isSelected());
            }
        } else if (object == this.mConfidenceRadio) {
            boolean bl = this.mConfidenceRadio.isSelected();
            this.mLevelLabel.setEnabled(bl);
            this.mLevelPctEdit.setEnabled(bl);
            this.mLevelPctEdit.setOpaque(bl);
        } else if (object == this.mStdErrorRadio) {
            boolean bl = this.mStdErrorRadio.isSelected();
            this.mStdErrorMultLabel.setEnabled(bl);
            this.mStdErrorMultEdit.setEnabled(bl);
            this.mStdErrorMultEdit.setOpaque(bl);
        } else if (object == this.mStdDevRadio) {
            boolean bl = this.mStdDevRadio.isSelected();
            this.mStdDevMultLabel.setEnabled(bl);
            this.mStdDevMultEdit.setEnabled(bl);
            this.mStdDevMultEdit.setOpaque(bl);
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_grop";
    }

    @Override
    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setUpUI(jPanel);
        this.setTabTraversalOrder();
        this.pack();
    }

    private void setupListeners(int n) {
        if ((n & 0x40) == 64) {
            this.mDisplayErrorBarsCheck.addItemListener(this);
            this.mConfidenceRadio.addItemListener(this);
            this.mStdErrorRadio.addItemListener(this);
            this.mStdDevRadio.addItemListener(this);
        } else if ((n & 0x20) == 32) {
            this.mDisplayErrorBarsCheck.addItemListener(this);
            this.mConfidenceRadio.addItemListener(this);
        }
    }

    private void setupDisplay(int n) {
        if ((n & 0x800) == 2048) {
            this.mExCasesListwiseRadio.setEnabled(true);
        } else {
            this.mExCasesListwiseRadio.setEnabled((n & 1) == 1);
        }
        this.mExCasesVarByVarRadio.setEnabled((n & 1) == 1);
        this.mDisplayGroupsCheck.setEnabled((n & 2) == 2);
        this.mDisplayGroupsCheck.setSelected((n & 0x80) == 128);
        this.mDisplayChartCheck.setEnabled((n & 4) == 4);
        this.mDisplayChartCheck.setSelected((n & 0x100) == 256);
        this.mDisplayErrorBarsCheck.setEnabled((n & 8) == 8);
        this.mDisplayErrorBarsCheck.setSelected((n & 0x200) == 512);
        this.enableTitledBorder(this.mErrorRepresentsPanel, (n & 0x10) != 16);
    }

    private void setTabTraversalOrder() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mExcludeCasesRadioGroup);
        vector.add(this.mDisplayGroupsCheck);
        vector.add(this.mDisplayChartCheck);
        vector.add(this.mDisplayErrorBarsCheck);
        vector.add(this.mErrorBarRadioGroup);
        vector.add(this.mLevelPctEdit);
        vector.add(this.mStdErrorMultEdit);
        vector.add(this.mStdDevMultEdit);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setUpUI(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = this.setupMissingValuesPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 23, null);
        JPanel jPanel3 = this.setupDisplayPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(n, DialogUtil.getStandardControlInsets().left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, 23, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mErrorRepresentsPanel, gridBagConstraints, 0, 3, 1, 1, 23, insets);
    }

    private JPanel setupMissingValuesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OPT_SUBDLG_MISSING_VALUES_CAPTION")));
        JSeparator jSeparator = new JSeparator(0);
        jSeparator.setEnabled(true);
        jSeparator.setSize(1, 1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(n, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mExCasesListwiseRadio, gridBagConstraints, 0, 0, 1, 1, 23, insets);
        Insets insets2 = DialogUtil.getStandardControlInsets();
        insets.set(insets2.top, n, n, n);
        DialogUtil.addUsingGBL(jPanel, this.mExCasesVarByVarRadio, gridBagConstraints, 0, 1, 1, 1, 23, insets);
        DialogUtil.addUsingGBL(jPanel, jSeparator, gridBagConstraints, 0, 2, 1, 1, 23, null);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mDisplayGroupsCheck, gridBagConstraints, 0, 3, 1, 1, 23, insets2);
        return jPanel;
    }

    private JPanel setupDisplayPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JSeparator jSeparator = new JSeparator(0);
        jSeparator.setEnabled(true);
        jSeparator.setSize(1, 1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(0, n, DialogUtil.getComponentGroupGap(), n);
        DialogUtil.addUsingGBL(jPanel, this.mDisplayChartCheck, gridBagConstraints, 0, 0, 1, 1, 23, insets2);
        DialogUtil.addUsingGBL(jPanel, jSeparator, gridBagConstraints, 0, 1, 1, 1, 10, null);
        insets2.set(DialogUtil.getComponentGroupGap(), n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mDisplayErrorBarsCheck, gridBagConstraints, 0, 2, 1, 1, 23, insets2);
        return jPanel;
    }

    private void initVars() {
        this.mExCasesListwiseRadio = DialogUtil.createRadioButton(this, EXCLUDE_CASES_LISTWISE_RADIO, null);
        this.mExCasesVarByVarRadio = DialogUtil.createRadioButton(this, EXCLUDE_CASES_VAR_BY_VAR_RADIO, null);
        this.mDisplayGroupsCheck = DialogUtil.createCheckBox(this, DISPLAY_GROUPS_CHECK, null);
        this.mDisplayChartCheck = DialogUtil.createCheckBox(this, DISPLAY_CHART_CHECK, null);
        this.mDisplayErrorBarsCheck = DialogUtil.createCheckBox(this, DISPLAY_ERROR_BARS_CHECK, null);
        this.mConfidenceRadio = DialogUtil.createRadioButton(this, CONF_INTERVALS_RADIO, null);
        this.mStdErrorRadio = DialogUtil.createRadioButton(this, STD_ERROR_RADIO, null);
        this.mStdDevRadio = DialogUtil.createRadioButton(this, STD_DEVIATION_RADIO, null);
        this.mLevelPctEdit = new FloatTextField(50.0, 99.9, 2, true);
        this.mLevelPctEdit.setAction((Action)new TextFieldAction(this, CONF_INTERVAL_LEVEL_PCT_EDIT));
        this.mLevelPctEdit.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                OptionsSubDialog.this.mLevelPctEdit.selectAll();
            }
        });
        this.mStdErrorMultEdit = new FloatTextField(1.0, 99999.0, 2, true);
        this.mStdErrorMultEdit.setAction((Action)new TextFieldAction(this, STD_ERROR_MULTIPLIER_EDIT));
        this.mStdErrorMultEdit.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                OptionsSubDialog.this.mStdErrorMultEdit.selectAll();
            }
        });
        this.mStdDevMultEdit = new FloatTextField(1.0, 99999.0, 2, true);
        this.mStdDevMultEdit.setAction((Action)new TextFieldAction(this, STD_DEVIATION_MULTIPLIER_EDIT));
        this.mStdDevMultEdit.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                OptionsSubDialog.this.mStdDevMultEdit.selectAll();
            }
        });
        this.mLevelLabel = DialogUtil.createLabel(this, "IDS_OPT_SUBDLG_LEVEL_PCT");
        this.mLevelLabel.setLabelFor((Component)this.mLevelPctEdit);
        this.mStdErrorMultLabel = DialogUtil.createLabel(this, "IDS_OPT_SUBDLG_MULTIPLIER1");
        this.mStdErrorMultLabel.setLabelFor((Component)this.mStdErrorMultEdit);
        this.mStdDevMultLabel = DialogUtil.createLabel(this, "IDS_OPT_SUBDLG_MULTIPLIER2");
        this.mStdDevMultLabel.setLabelFor((Component)this.mStdDevMultEdit);
        this.mErrorRepresentsPanel = this.setupErrorsRepresentPanel();
        this.mExcludeCasesRadioGroup = new SpssButtonGroup();
        this.mExcludeCasesRadioGroup.add(this.mExCasesListwiseRadio);
        this.mExcludeCasesRadioGroup.add(this.mExCasesVarByVarRadio);
        this.mExcludeCasesRadioGroup.setSelected(this.mExCasesListwiseRadio.getModel(), true);
        this.mErrorBarRadioGroup = new SpssButtonGroup();
        this.mErrorBarRadioGroup.add(this.mConfidenceRadio);
        this.mErrorBarRadioGroup.add(this.mStdErrorRadio);
        this.mErrorBarRadioGroup.add(this.mStdDevRadio);
        this.mErrorBarRadioGroup.setSelected(this.mConfidenceRadio.getModel(), true);
        this.mConfidenceRadio.setEnabled(false);
        this.mStdErrorRadio.setEnabled(false);
        this.mStdDevRadio.setEnabled(false);
        this.mLevelLabel.setEnabled(false);
        this.mStdErrorMultLabel.setEnabled(false);
        this.mStdDevMultLabel.setEnabled(false);
        this.mLevelPctEdit.setEnabled(false);
        this.mLevelPctEdit.setOpaque(false);
        this.mStdErrorMultEdit.setEnabled(false);
        this.mStdErrorMultEdit.setOpaque(false);
        this.mStdDevMultEdit.setEnabled(false);
        this.mStdDevMultEdit.setOpaque(false);
    }

    private void setDefaultValues(float f, float f2, float f3) {
        if ((this.mDisplayRule & 0x400) == 1024) {
            this.mLevelPctEdit.setText("");
            this.mStdErrorMultEdit.setText("");
            this.mStdDevMultEdit.setText("");
        } else {
            this.mLevelPctEdit.setText(Float.toString(f));
            this.mStdErrorMultEdit.setText(Float.toString(f2));
            this.mStdDevMultEdit.setText(Float.toString(f3));
        }
    }

    private JPanel setupErrorsRepresentPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OPT_SUBDLG_ERROR_BARS_REPRESENT_CAPTION")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(n, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mConfidenceRadio, gridBagConstraints, 0, 0, 2, 1, 23, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mLevelLabel, gridBagConstraints, 0, 1, 1, 1, 23, new Insets(0, 25, 5, 3));
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(insets.top, insets.left, 0, n);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mLevelPctEdit, gridBagConstraints, 1, 1, 1, 1, 23, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets2.set(n, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mStdErrorRadio, gridBagConstraints, 0, 2, 2, 1, 23, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mStdErrorMultLabel, gridBagConstraints, 0, 3, 1, 1, 23, new Insets(0, 25, 5, 3));
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(insets.top, insets.left, 0, n);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mStdErrorMultEdit, gridBagConstraints, 1, 3, 1, 1, 23, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets2.set(n, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mStdDevRadio, gridBagConstraints, 0, 4, 2, 1, 23, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mStdDevMultLabel, gridBagConstraints, 0, 5, 1, 1, 23, new Insets(0, 25, 5, 3));
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets2.set(DialogUtil.getStandardControlInsets().top, DialogUtil.getStandardControlInsets().left, DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mStdDevMultEdit, gridBagConstraints, 1, 5, 1, 1, 23, insets2);
        return jPanel;
    }
}

