/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs;

import com.spss.java_client.ui.dialogs.base.graphs.MatrixImage;
import java.awt.Color;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class MatrixImagesGroup
extends JComponent {
    private HashMap<MatrixImage, Boolean> mImageLabelGroupHashMap = new HashMap();
    private Vector<MatrixImage> mImageLabelVector = new Vector();
    private Vector<MatrixImage> mAllImages = new Vector();
    private MatrixImage mSelectedImageLabel;

    public void setSelected(MatrixImage matrixImage, boolean bl) {
        if (bl) {
            this.resetImageLabelObjects();
            this.mImageLabelGroupHashMap.remove(matrixImage);
            this.mImageLabelGroupHashMap.put(matrixImage, true);
            this.mImageLabelVector.add(matrixImage);
            Border border = BorderFactory.createLineBorder(Color.BLACK, 2);
            Border border2 = BorderFactory.createLineBorder(Color.BLACK, 1);
            Border border3 = BorderFactory.createLineBorder(Color.WHITE, 1);
            matrixImage.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createCompoundBorder(border2, border3)));
            this.mSelectedImageLabel = matrixImage;
        }
    }

    public MatrixImage getSelectedMatrixImage() {
        return this.mSelectedImageLabel;
    }

    public boolean isSelected(MatrixImage matrixImage) {
        if (this.notSelected()) {
            return false;
        }
        return this.mImageLabelGroupHashMap.get(matrixImage) != null && this.mImageLabelGroupHashMap.get(matrixImage) != false;
    }

    public int getMatrixImageIndex(MatrixImage matrixImage) {
        for (int i = 0; i < this.mAllImages.size(); ++i) {
            if (!this.mAllImages.get(i).equals(matrixImage)) continue;
            return i;
        }
        return -1;
    }

    public void addMatrixImageItem(MatrixImage matrixImage) {
        if (!this.mAllImages.contains(matrixImage)) {
            this.mAllImages.add(matrixImage);
        }
    }

    private void resetImageLabelObjects() {
        for (MatrixImage matrixImage : this.mImageLabelVector) {
            if (this.mImageLabelGroupHashMap.get(matrixImage) == null || !this.mImageLabelGroupHashMap.get(matrixImage).booleanValue()) continue;
            Border border = BorderFactory.createBevelBorder(1);
            matrixImage.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createLineBorder(Color.WHITE, 2)));
        }
        this.mImageLabelGroupHashMap.clear();
        for (MatrixImage matrixImage : this.mImageLabelVector) {
            this.mImageLabelGroupHashMap.put(matrixImage, false);
        }
        this.mImageLabelVector.clear();
    }

    private boolean notSelected() {
        for (MatrixImage matrixImage : this.mImageLabelGroupHashMap.keySet()) {
            if (!this.mImageLabelGroupHashMap.get(matrixImage).booleanValue()) continue;
            return false;
        }
        return true;
    }
}

