/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs;

import com.spss.java_client.ui.dialogs.base.graphs.IMatrixListener;
import com.spss.java_client.ui.dialogs.base.graphs.MatrixImagesGroup;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class MatrixImage
extends JLabel {
    private Icon mImageLabelIcon;
    private MatrixImagesGroup mILGroup;
    private Vector<IMatrixListener> mListeners = new Vector();

    public MatrixImage(URL uRL) {
        this.mImageLabelIcon = new ImageIcon(uRL);
        this.setIcon(this.mImageLabelIcon);
        Border border = BorderFactory.createLineBorder(Color.WHITE, 2);
        Border border2 = BorderFactory.createLineBorder(Color.WHITE, 2);
        this.setBorder(BorderFactory.createCompoundBorder(border, border2));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MatrixImage matrixImage = (MatrixImage)mouseEvent.getSource();
                matrixImage.setSelected(true);
                Border border = BorderFactory.createLineBorder(Color.BLACK, 2);
                Border border2 = BorderFactory.createLineBorder(Color.BLACK, 1);
                Border border3 = BorderFactory.createLineBorder(Color.WHITE, 1);
                matrixImage.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createCompoundBorder(border2, border3)));
                matrixImage.requestFocusInWindow();
                if (!mouseEvent.isPopupTrigger() && mouseEvent.getClickCount() > 1) {
                    MatrixImage.this.fireMatrixEvent(IMatrixListener.EventType.doubleClick, MatrixImage.this.getImagesGroup().getMatrixImageIndex(MatrixImage.this));
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                Border border = BorderFactory.createLineBorder(Color.BLACK, 2);
                Border border2 = BorderFactory.createLineBorder(Color.BLACK, 1);
                Border border3 = BorderFactory.createLineBorder(Color.WHITE, 1);
                MatrixImage.this.getImagesGroup().getSelectedMatrixImage().setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createCompoundBorder(border2, border3)));
                MatrixImage matrixImage = MatrixImage.this.getImagesGroup().getSelectedMatrixImage();
                if (matrixImage.accessibleContext != null) {
                    String string = MatrixImage.this.accessibleContext.getAccessibleDescription();
                    if (string != null && !string.equals("")) {
                        matrixImage = (MatrixImage)focusEvent.getSource();
                        matrixImage.getAccessibleContext().setAccessibleName(string);
                    } else {
                        JLabel jLabel = (JLabel)matrixImage.getClientProperty("labeledBy");
                        if (jLabel != null && (string = jLabel.getText()) != null && !string.equals("")) {
                            matrixImage = (MatrixImage)focusEvent.getSource();
                            matrixImage.getAccessibleContext().setAccessibleName(string);
                        }
                    }
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Border border = BorderFactory.createLineBorder(Color.BLACK, 2);
                Border border2 = BorderFactory.createLineBorder(Color.WHITE, 2);
                MatrixImage.this.getImagesGroup().getSelectedMatrixImage().setBorder(BorderFactory.createCompoundBorder(border, border2));
            }
        });
    }

    public void setSelected(boolean bl) {
        if (bl != this.isSelected()) {
            this.getImagesGroup().setSelected(this, bl);
            if (bl) {
                this.fireMatrixEvent(IMatrixListener.EventType.selectionChange, this.getImagesGroup().getMatrixImageIndex(this));
                AccessibleContext accessibleContext = this.getAccessibleContext();
                if (accessibleContext != null) {
                    String string = accessibleContext.getAccessibleDescription();
                    if (string != null && !string.equals("")) {
                        accessibleContext.setAccessibleName("");
                        accessibleContext.setAccessibleName(string);
                    } else {
                        JLabel jLabel = (JLabel)this.getClientProperty("labeledBy");
                        if (jLabel != null && (string = jLabel.getText()) != null && !string.equals("")) {
                            accessibleContext.setAccessibleName("");
                            accessibleContext.setAccessibleName(string);
                        }
                    }
                }
            }
        }
    }

    public boolean isSelected() {
        return this.getImagesGroup().isSelected(this);
    }

    public void setImageLabelGroup(MatrixImagesGroup matrixImagesGroup) {
        if (matrixImagesGroup == null) {
            return;
        }
        this.mILGroup = matrixImagesGroup;
        this.mILGroup.addMatrixImageItem(this);
    }

    public MatrixImagesGroup getImagesGroup() {
        if (this.mILGroup == null) {
            this.mILGroup = new MatrixImagesGroup();
        }
        return this.mILGroup;
    }

    public void addMatrixListener(IMatrixListener iMatrixListener) {
        if (!this.mListeners.contains(iMatrixListener)) {
            this.mListeners.add(iMatrixListener);
        }
    }

    public void removeMatrixListener(IMatrixListener iMatrixListener) {
        this.mListeners.remove(iMatrixListener);
    }

    public void setDefaultSelectedImage(boolean bl) {
        if (bl) {
            this.getImagesGroup().setSelected(this, bl);
            Border border = BorderFactory.createLineBorder(Color.BLACK, 2);
            Border border2 = BorderFactory.createLineBorder(Color.WHITE, 2);
            this.setBorder(BorderFactory.createCompoundBorder(border, border2));
        } else {
            Border border = BorderFactory.createBevelBorder(1);
            this.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createLineBorder(Color.WHITE, 2)));
        }
    }

    public void fireMatrixEvent(IMatrixListener.EventType eventType, int n) {
        for (IMatrixListener iMatrixListener : this.mListeners) {
            iMatrixListener.matrixImageEvent(eventType, n);
        }
    }
}

