/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;

public class GraphsRemoteFileChooser
extends RemoteFileChooser {
    private BaseDialog mParent;
    private static final String XML_HEADER1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String XML_HEADER2 = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>";

    public GraphsRemoteFileChooser(BaseDialog baseDialog) {
        super(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
        this.setDialogTitle(ResUtil.getCommonDlgString("IDS_CHART_TEMPLATE_FILE_DIALOG_TITLE"));
        this.mParent = baseDialog;
        RefFileFilter refFileFilter = new RefFileFilter(ResUtil.getCommonDlgString("IDS_CHART_TEMPLATE_FILE_FILTER_DESC"), ResUtil.getCommonDlgString("IDS_CHART_TEMPLATE_FILE_FILTER_EXTENSION"));
        this.addChoosableFileFilter((FileFilter)refFileFilter);
        this.setAcceptAllFileFilterUsed(true);
        this.setFileFilter((FileFilter)refFileFilter, true);
    }

    @Override
    public void approveSelection() {
        File file = this.getSelectedFile();
        if (this.isFileExists(file) && this.isValidChartTemplate(file)) {
            super.approveSelection();
        }
    }

    public boolean isFileExists(File file) {
        boolean bl;
        PesFile pesFile = PES_Repository.getPesFile((String)file.getAbsolutePath());
        String string = file.getAbsolutePath();
        if (pesFile != null) {
            bl = pesFile.existsInPES();
            string = pesFile.getUri();
        } else {
            bl = file.exists();
        }
        if (!bl) {
            String string2 = string + "\n" + CoreResUtil.getString((String)"ERR_FILE_DOESNT_EXIST_WARNING_MESSAGE");
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, string2, VersionInfo.getAppVersionString());
        }
        return bl;
    }

    @Override
    public boolean canProceed(Component component) {
        boolean bl = super.canProceed(component);
        if (bl) {
            FileLocationsUtil.setOtherFilesDirectoryPath((String)this.getCurrentDirectory().getAbsolutePath());
        }
        return bl;
    }

    private boolean isValidChartTemplate(File file) {
        Object object;
        boolean bl = false;
        String string = null;
        try {
            char[] cArray;
            FileReader fileReader;
            int n;
            object = PES_Repository.getPesFile((String)file.getAbsolutePath());
            if (object != null && PES_Repository.RetrieveFromPES((PesFile)object) == null) {
                file = object.getCacheFile();
            }
            if ((n = (fileReader = new FileReader(file)).read(cArray = new char[2000], 0, 2000)) > 0) {
                StringBuffer stringBuffer = new StringBuffer(n);
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(cArray[i]);
                }
                string = stringBuffer.toString();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            ComponentState.trace1((String)fileNotFoundException.getMessage(), (int)15);
        }
        catch (IOException iOException) {
            ComponentState.trace1((String)iOException.getMessage(), (int)15);
        }
        if (string != null && string.length() > 0) {
            boolean bl2 = bl = !(!string.contains(XML_HEADER1) && !string.contains(XML_HEADER2) || !string.contains("http://www.ibm.com/software/analytics/spss/xml/visualization") && !string.contains("http://www.ibm.com/software/analytics/spss/xml/visualization/vizml-template-3.5.xsd"));
        }
        if (!bl) {
            object = this.mParent.getResString("ERR_NOT_CHART_TEMPLATE_WARNING_MSG");
            SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParent, (String)object, VersionInfo.getAppVersionString());
        }
        return bl;
    }
}

