/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.SpssTemplateSource;
import com.spss.java_client.core.documents.output.VizCache;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.base.graphs.GBLicInfoProvider;
import com.spss.java_client.ui.dialogs.base.graphs.GBTemplateOptionPanel;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.output.model_editor.GraphboardModel;
import com.spss.java_client.ui.doc_types.output.model_editor.ModelViewerFrame;
import com.spss.pes.help.HelpFileMap;
import com.spss.pes.help.Helper;
import com.spss.pes.jaxws.PESBrowser;
import com.spss.pes.ui.dialog.RepositoryPathInfoListener;
import com.spss.pes.ui.dialog.jaxws.RepositoryPathInfo;
import com.spss.repository.client.application.jaxws.Repository;
import com.spss.repository.client.application.jaxws.RepositoryFolder;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.CharacterUtil;
import com.spss.uitools.util.IOptionConstants;
import com.spss.vis.Source;
import com.spss.vis.exception.InappropriateSummaryException;
import com.spss.vis.exception.VisualizationException;
import com.spss.vis.graphboard.Graphboard;
import com.spss.vis.graphboard.GraphboardInternationalization;
import com.spss.vis.graphboard.VisRepository;
import com.spss.vis.graphboard.map.MapInfo;
import com.spss.vis.graphboard.permission.LicenseInfoProvider;
import com.spss.vis.graphboard.styleSheet.StyleSheetFactory;
import com.spss.vis.graphboard.styleSheet.StyleSheetLoaderException;
import com.spss.vis.graphboard.styleSheet.StylesheetLoader;
import com.spss.vis.graphboard.template.MapInfo;
import com.spss.vis.graphboard.template.TemplateBuilder;
import com.spss.vis.graphboard.template.TemplateDetailPanel;
import com.spss.vis.graphboard.template.TemplateStateListener;
import com.spss.vis.graphboard.template.VariableSorter;
import com.spss.vis.model.data.source.VariableType;
import com.spss.vis.specification.LabelPurposeType;
import com.spss.vis.specification.VisualizationSpecification;
import com.spss.vis.specification.data.MeasurementLevel;
import com.spss.vis.specification.data.SourceVariableSpecification;
import com.spss.vis.specification.element.AttachSpecification;
import com.spss.vis.specification.facet.FacetingSpecification;
import com.spss.vis.specification.facet.VariableReferenceSpecification;
import com.spss.vis.specification.statistic.SummaryType;
import com.spss.vis.template.BaseTemplateInternationalization;
import com.spss.vis.template.Template;
import com.spss.vis.template.TemplateFactory;
import com.spss.vis.template.TemplateVariable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GraphboardTemplateChooser
extends BaseProcedureDialog
implements ActionListener,
ChangeListener,
RepositoryPathInfoListener,
TemplateStateListener {
    private static String GRAPHDATASET = "graphdataset";
    private static String DATASET_STRINNG = "[DATASET=\"graphdataset\"]";
    private static String SUMMARY = "Summary";
    private static String FACET = "facet";
    private static String PANELING = "Paneling";
    private static String ANIMATION = "Animation";
    private static String PANEL_ACROSS = "Panel_across";
    private static String PANEL_DOWN = "Panel_down";
    protected TemplateBuilder mBuilder;
    protected Graphboard mGraphboard;
    private JLabel mPathLabel = new JLabel();
    private GBTemplateOptionPanel mOptionTab;
    private boolean mIsDefault = false;
    private static final String kSTYLE_SHEET = "stylesheet_name";
    private static final String kDEFAULT_ENABLED = "is_default_enabled";
    private static final String kOUT_LABEL = "out_label";
    private static LocallyUniqueId sPrevDataSet;
    private RepositoryPathInfo mRpi;
    private StyleSheetFactory mStylesheetFactory;
    private static final String kSELECTED_TEMPLATE = "Selected_template";
    private static final String kOPTIONAL_AESTHTIC = "Optional_aesthetic";
    private static final String kOPTIONAL_AESTHTIC_STATISTIC = "Optional_aesthetic_statistic";
    private static final String kANIMATION = "Animation";
    private static final String kPANELING_VARIABLES = "Paneling_variables";
    private static final String kSUMMARY_VARIABLE = "Summary_variable";
    private static final String kREQUIRED_MAPPING = "Required_variable_mapping";
    private static final String kCUSTOM_TITLE = "Custom_title";
    private static final String kCUSTOM_SUBTITLE = "Custom_subtitle";
    private static final String kCUSTOM_FOOTNOTE = "Custom_footnote";
    private static final String kUSE_CUSTOM = "Use_custom";
    private static final String kVAR_NAMES = "var_names";
    private static final String kVAR_TYPES = "var_types";
    private static final String kMAIN_MAPS = "main_maps";
    private static final String kREF_MAPS = "ref_maps";
    private static final String kRPI_CACHE = "Rpi_cache";
    protected VariableSorter.Order mSortOrder = null;
    private ModelViewerFrame mModelFrame;
    protected Source mTemplateSource;

    public GraphboardTemplateChooser(JFrame jFrame) throws HeadlessException {
        super(jFrame, false, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        try {
            this.secondInit();
            this.enableOkPaste(false);
            this.loadDataSet();
            LocallyUniqueId locallyUniqueId = this.getDataSetId();
            if (sPrevDataSet == null || !sPrevDataSet.equals((Object)locallyUniqueId)) {
                sPrevDataSet = locallyUniqueId;
            }
            this.reset();
            this.addWindowListener(new ChooserWindowHandler());
            this.centerLocation();
            this.setVisible(true);
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
    }

    public GraphboardTemplateChooser(JFrame jFrame, Source source) throws HeadlessException {
        super(jFrame, false, GraphsResBundle.getDefaultResourceBundleName(), GraphsResBundle.getImageFolder());
        this.mTemplateSource = source;
        try {
            this.secondInit();
            this.enableOkPaste(false);
            this.loadDataSet();
            LocallyUniqueId locallyUniqueId = this.getDataSetId();
            if (sPrevDataSet == null || !sPrevDataSet.equals((Object)locallyUniqueId)) {
                sPrevDataSet = locallyUniqueId;
            }
            this.reset();
            this.addWindowListener(new ChooserWindowHandler());
            this.centerLocation();
            this.setVisible(true);
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
    }

    public void loadDataSet() {
        try {
            if (this.mTemplateSource == null) {
                this.mTemplateSource = new SpssTemplateSource();
            }
            this.mBuilder.showSource(this.mTemplateSource);
            this.mBuilder.addTemplateStateListener((TemplateStateListener)this);
            VariableSorter variableSorter = this.mBuilder.getVariableSorter();
            if (this.mSortOrder == null) {
                Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options");
                Preferences preferences2 = preferences.node("general");
                String string = preferences2.get("var_list_sort", PrefDefaults.DEF_VAR_LIST_SORT_ORDER_FILE);
                if (string.equals(IOptionConstants.VAR_LIST_SORT_VALUES[1])) {
                    variableSorter.setSort(VariableSorter.Order.NATURAL);
                } else if (string.equals(IOptionConstants.VAR_LIST_SORT_VALUES[2])) {
                    variableSorter.setSort(VariableSorter.Order.TYPE);
                } else {
                    variableSorter.setSort(VariableSorter.Order.NAME);
                }
                String string2 = preferences2.get("var_list_display", PrefDefaults.DEF_VAR_LIST_DISPLAY_LABELS);
                if (string2.equals(IOptionConstants.VAR_LIST_DISPLAY_VALUES[0])) {
                    this.mBuilder.setShowVariableLabels(true);
                } else if (string2.equals(IOptionConstants.VAR_LIST_DISPLAY_VALUES[1])) {
                    this.mBuilder.setShowVariableLabels(false);
                }
            } else {
                variableSorter.setSort(this.mSortOrder);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public String generateSyntax() {
        List list;
        Set<String> set;
        Object object;
        String string;
        Template template = this.mBuilder.getSelectedTemplate();
        Set<String> set2 = this.getSelectedVariableNames();
        Map<String, String> map2 = this.getVariableMapping();
        Map<String, String> map3 = this.getSummaryMapping();
        Map<String, MeasurementLevel> map4 = this.getMeasureLevels();
        VizCache.getCache().setGraphSource(this.mTemplateSource);
        if (set2 == null || map2 == null) {
            return "";
        }
        if (this.mModelFrame != null) {
            this.mPasteExecuteSyntax = false;
            GraphboardModel graphboardModel = new GraphboardModel(template, set2, map2, map3, map4, this.getTitlesMapping(), this.mOptionTab.getSelectSheetId(this.mStylesheetFactory, this.isLocalStore()), this.mOptionTab.getOutputLabel(), this.mTemplateSource, this.mRpi, this.mBuilder);
            this.mModelFrame.graphboardCallback(graphboardModel);
            return "no syntax needed";
        }
        String string2 = "  ";
        String string3 = "LOCAL";
        if (!this.isLocalStore() && (string = this.mRpi.getSelectFolderPath()) != null && string.length() > 0) {
            string3 = "\"" + string + "\"";
        }
        string = "GGRAPH\n";
        string = string + string2;
        string = string + "/GRAPHDATASET NAME=\"";
        string = string + GRAPHDATASET;
        string = string + "\"\n";
        string = string + string2 + string2;
        string = string + "VARIABLES=";
        HashSet<String> hashSet = new HashSet<String>();
        for (String map5 : set2) {
            if (map5 == null) continue;
            String[] stringArray = map5.split(",");
            object = stringArray;
            int n = ((String[])object).length;
            for (int i = 0; i < n; ++i) {
                String string4 = object[i];
                Object object2 = map4.get(string4);
                if (object2 != null) {
                    if (object2 == MeasurementLevel.interval || object2 == MeasurementLevel.ratio) {
                        hashSet.add(string4 + "[LEVEL=scale]");
                        continue;
                    }
                    hashSet.add(string4 + "[LEVEL=" + object2.toString() + "]");
                    continue;
                }
                hashSet.add(string4);
            }
        }
        if (map2.size() > 0) {
            set = map2.values();
            for (String string5 : set) {
                if (string5 == null) continue;
                object = string5.split(",");
                for (Object object2 : object) {
                    MeasurementLevel measurementLevel = map4.get(object2);
                    if (measurementLevel == null) continue;
                    if (measurementLevel == MeasurementLevel.interval || measurementLevel == MeasurementLevel.ratio) {
                        hashSet.add((String)object2 + "[LEVEL=scale]");
                        continue;
                    }
                    hashSet.add((String)object2 + "[LEVEL=" + measurementLevel.toString() + "]");
                }
            }
        }
        for (String string6 : hashSet) {
            string = string + string6 + " ";
        }
        string = string + "\n";
        string = string + string2 + string2;
        string = string + "MISSING=";
        string = this.mOptionTab.isVariablewise() ? string + "VARIABLEWISE" : string + "LISTWISE";
        string = string + " REPORTMISSING=";
        string = this.mOptionTab.isMissingInclude() ? string + "YES" : string + "NO";
        string = string + "\n";
        string = string + string2;
        string = string + "/GRAPHSPEC SOURCE=VIZTEMPLATE(NAME=\"";
        string = string + template.getName();
        string = string + "\"";
        string = string + "[LOCATION=";
        string = string + string3;
        string = string + "]\n";
        string = string + string2 + string2;
        string = string + "MAPPING(";
        set = map2.keySet();
        for (String string7 : set) {
            String[] stringArray;
            object = map2.get(string7);
            if (object == null || ((String)object).length() <= 0) continue;
            for (String string8 : stringArray = ((String)object).split(",")) {
                string = string + " \"" + string7 + "\"=\"" + string8 + "\"" + DATASET_STRINNG;
            }
        }
        set = map3.keySet();
        for (String string9 : set) {
            object = map3.get(string9);
            if (object == null || ((String)object).length() <= 0) continue;
            string = string + " \"" + string9 + "\"=\"" + (String)object + "\"";
        }
        Map<String, String> map = this.getTitlesMapping();
        if (map.size() > 0) {
            Set<String> set3 = map.keySet();
            object = set3.iterator();
            while (object.hasNext()) {
                String string10 = (String)object.next();
                String string11 = map.get(string10);
                if (string11 == null || string11.length() <= 0) continue;
                string11 = string11.replace("\n", "\\n");
                string = string + " \"" + string10 + "\"=" + CharacterUtil.smartQuote((String)string11);
            }
        }
        string = string + "))\n";
        String string12 = this.mOptionTab.getSelectSheetId(this.mStylesheetFactory, this.isLocalStore());
        if (string12 != null && string12.length() > 0) {
            string = string + string2 + string2;
            string = string + "VIZSTYLESHEET=\"";
            string = string + string12;
            string = string + "\"";
            string = string + "[LOCATION=";
            string = string + string3;
            string = string + "]\n";
        }
        if ((object = this.mOptionTab.getOutputLabel()) == null || ((String)object).length() == 0) {
            object = this.getDefaultLabel();
        }
        if (object != null && ((String)object).length() > 0) {
            string = string + string2 + string2;
            string = string + "LABEL=";
            string = string + CharacterUtil.smartQuote((String)object);
            string = string + "\n";
        }
        string = string + string2 + string2;
        string = string + "DEFAULTTEMPLATE=";
        string = this.mIsDefault ? string + "YES" : string + "NO";
        string = string + "\n";
        List list2 = this.mBuilder.getMainMaps();
        if (list2 != null && list2.size() > 0) {
            for (MapInfo.MainMap mainMap : list2) {
                MapInfo.MapIdentifier mapIdentifier = mainMap.getMapIdentifier();
                if (!(mapIdentifier instanceof MapInfo.FileMapIdentifier)) continue;
                string = string + string2 + string2;
                string = string + "VIZMAP=\"";
                string = string + this.getMapName(((MapInfo.FileMapIdentifier)mapIdentifier).getFilePath());
                string = string + "\"";
                string = string + "[LOCATION=";
                string = string + string3;
                string = string + " TYPE=DATA ";
                string = string + "mapkey=\"";
                string = string + mainMap.getMapKey();
                string = string + "\"";
                string = string + " SHOWALLFEATURES=";
                string = mainMap.isShowAll() != false ? string + "YES" : string + "NO";
                string = string + "]";
                string = string + "\n";
            }
        }
        if ((list = this.mBuilder.getReferenceMaps()) != null && list.size() > 0) {
            for (MapInfo.ReferenceMap referenceMap : list) {
                MapInfo.MapIdentifier mapIdentifier = referenceMap.getMapIdentifier();
                if (!(mapIdentifier instanceof MapInfo.FileMapIdentifier)) continue;
                string = string + string2 + string2;
                string = string + "VIZMAP=\"";
                string = string + this.getMapName(((MapInfo.FileMapIdentifier)mapIdentifier).getFilePath());
                string = string + "\"";
                string = string + "[LOCATION=";
                string = string + string3;
                string = string + " TYPE=REFERENCE ";
                string = string + "]";
                string = string + "\n";
            }
        }
        string = string.trim();
        string = string + SyntaxUtil.terminateSyntax();
        return string;
    }

    @Override
    public String getIActionKey() {
        return "graphs_graphboard_template_chooser";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_graphboard_template_chooser";
    }

    public void centerLocation() {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        Dimension dimension = this.getToolkit().getScreenSize();
        int n3 = (dimension.width - n) / 2;
        int n4 = (dimension.height - n2) / 2;
        this.setLocation(n3, n4);
    }

    public void setModelFrame(ModelViewerFrame modelViewerFrame) {
        this.mModelFrame = modelViewerFrame;
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        try {
            List list;
            Template template;
            DialogDataModel dialogDataModel = this.getDialogDataModel();
            String string = this.mOptionTab.getSelectSheetName();
            if (string != null && string.length() > 0) {
                dialogDataModel.putString(kSTYLE_SHEET, string);
            }
            if ((template = this.mBuilder.getSelectedTemplate()) != null) {
                dialogDataModel.putString(kSELECTED_TEMPLATE, template.getName());
            }
            Map map = this.mBuilder.getRequiredVariables();
            dialogDataModel.putObject(kREQUIRED_MAPPING, map);
            HashMap<String, SourceVariableSpecification> hashMap = new HashMap<String, SourceVariableSpecification>();
            hashMap.put("Color", this.mBuilder.getOptionalAesthetic(TemplateBuilder.COLOR));
            hashMap.put("Size", this.mBuilder.getOptionalAesthetic(TemplateBuilder.SIZE));
            hashMap.put("Shape", this.mBuilder.getOptionalAesthetic(TemplateBuilder.SHAPE));
            hashMap.put("Label", this.mBuilder.getOptionalAesthetic(TemplateBuilder.LABEL));
            hashMap.put("Transparency", this.mBuilder.getOptionalAesthetic(TemplateBuilder.TRANSPARENCY));
            dialogDataModel.putObject(kOPTIONAL_AESTHTIC, hashMap);
            HashMap<String, SummaryType> hashMap2 = new HashMap<String, SummaryType>();
            hashMap2.put("Color", this.mBuilder.getOptionalAestheticStatistic(TemplateBuilder.COLOR));
            hashMap2.put("Size", this.mBuilder.getOptionalAestheticStatistic(TemplateBuilder.SIZE));
            hashMap2.put("Shape", this.mBuilder.getOptionalAestheticStatistic(TemplateBuilder.SHAPE));
            hashMap2.put("Label", this.mBuilder.getOptionalAestheticStatistic(TemplateBuilder.LABEL));
            hashMap2.put("Transparency", this.mBuilder.getOptionalAestheticStatistic(TemplateBuilder.TRANSPARENCY));
            dialogDataModel.putObject(kOPTIONAL_AESTHTIC_STATISTIC, hashMap2);
            dialogDataModel.putObject(kANIMATION, this.mBuilder.getAnimation());
            dialogDataModel.putObject(kPANELING_VARIABLES, this.mBuilder.getPaneling());
            SummaryType summaryType = this.mBuilder.getSummaryStatistic();
            dialogDataModel.putObject(kSUMMARY_VARIABLE, summaryType);
            boolean bl = this.mBuilder.isUseCustomTitles();
            if (bl) {
                dialogDataModel.putString(kUSE_CUSTOM, "true");
            } else {
                dialogDataModel.putString(kUSE_CUSTOM, "false");
            }
            dialogDataModel.putString(kCUSTOM_TITLE, this.mBuilder.getCustomTitle(LabelPurposeType.TITLE));
            dialogDataModel.putString(kCUSTOM_SUBTITLE, this.mBuilder.getCustomTitle(LabelPurposeType.SUB_TITLE));
            dialogDataModel.putString(kCUSTOM_FOOTNOTE, this.mBuilder.getCustomTitle(LabelPurposeType.FOOTNOTE));
            dialogDataModel.putBoolean(kDEFAULT_ENABLED, this.mOptionTab.isDefaultBtnEnabled());
            dialogDataModel.putString(kOUT_LABEL, this.mOptionTab.getOutputLabel());
            dialogDataModel.putObject(kRPI_CACHE, this.mRpi);
            int n = 0;
            Map map2 = this.mBuilder.getVariableTypesForSource();
            Object[] objectArray = new String[map2.size()];
            Object[] objectArray2 = new String[map2.size()];
            for (Map.Entry object2 : map2.entrySet()) {
                objectArray[n] = (String)object2.getKey();
                objectArray2[n] = ((VariableType)object2.getValue()).toString();
                ++n;
            }
            dialogDataModel.putArray(kVAR_NAMES, objectArray);
            dialogDataModel.putArray(kVAR_TYPES, objectArray2);
            List list2 = this.mBuilder.getMainMaps();
            if (list2 != null && list2.size() > 0) {
                dialogDataModel.putObject(kMAIN_MAPS, list2);
            }
            if ((list = this.mBuilder.getReferenceMaps()) != null && list.size() > 0) {
                dialogDataModel.putObject(kREF_MAPS, list);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public StyleSheetFactory getStyleSheetFactory() {
        return this.mStylesheetFactory;
    }

    @Override
    protected void loadDialogState() {
        super.loadDialogState();
        try {
            List list;
            List list2;
            RepositoryPathInfo repositoryPathInfo;
            String string;
            Object object;
            SummaryType summaryType;
            DialogDataModel dialogDataModel = this.getDialogDataModel();
            String string2 = dialogDataModel.getString(kSTYLE_SHEET);
            if (string2 != null && string2.length() > 0) {
                this.mOptionTab.setSelectSheetName(string2);
            }
            String string3 = dialogDataModel.getString(kSELECTED_TEMPLATE);
            Object object2 = dialogDataModel.getObject(kREQUIRED_MAPPING);
            if (string3 != null && object2 != null) {
                summaryType = (SummaryType)object2;
                this.mBuilder.setSelectedTemplate(string3, (Map)summaryType);
            }
            if ((object2 = dialogDataModel.getObject(kOPTIONAL_AESTHTIC)) != null) {
                object = (Map)object2;
                summaryType = (SourceVariableSpecification)object.get("Color");
                if (summaryType != null) {
                    this.mBuilder.setOptionalAesthetic(TemplateBuilder.COLOR, (SourceVariableSpecification)summaryType);
                }
                if ((summaryType = (SourceVariableSpecification)object.get("Size")) != null) {
                    this.mBuilder.setOptionalAesthetic(TemplateBuilder.SIZE, (SourceVariableSpecification)summaryType);
                }
                if ((summaryType = (SourceVariableSpecification)object.get("Shape")) != null) {
                    this.mBuilder.setOptionalAesthetic(TemplateBuilder.SHAPE, (SourceVariableSpecification)summaryType);
                }
                if ((summaryType = (SourceVariableSpecification)object.get("Label")) != null) {
                    this.mBuilder.setOptionalAesthetic(TemplateBuilder.LABEL, (SourceVariableSpecification)summaryType);
                }
                if ((summaryType = (SourceVariableSpecification)object.get("Transparency")) != null) {
                    this.mBuilder.setOptionalAesthetic(TemplateBuilder.TRANSPARENCY, (SourceVariableSpecification)summaryType);
                }
            }
            if ((object2 = dialogDataModel.getObject(kOPTIONAL_AESTHTIC_STATISTIC)) != null) {
                object = (Map)object2;
                summaryType = (SummaryType)object.get("Color");
                if (summaryType != null) {
                    this.mBuilder.setOptionalAestheticSummaryStatistic(TemplateBuilder.COLOR, summaryType);
                }
                if ((summaryType = (SummaryType)object.get("Size")) != null) {
                    this.mBuilder.setOptionalAestheticSummaryStatistic(TemplateBuilder.SIZE, summaryType);
                }
                if ((summaryType = (SummaryType)object.get("Shape")) != null) {
                    this.mBuilder.setOptionalAestheticSummaryStatistic(TemplateBuilder.SHAPE, summaryType);
                }
                if ((summaryType = (SummaryType)object.get("Label")) != null) {
                    this.mBuilder.setOptionalAestheticSummaryStatistic(TemplateBuilder.LABEL, summaryType);
                }
                if ((summaryType = (SummaryType)object.get("Transparency")) != null) {
                    this.mBuilder.setOptionalAestheticSummaryStatistic(TemplateBuilder.TRANSPARENCY, summaryType);
                }
            }
            if ((object2 = dialogDataModel.getObject(kANIMATION)) != null) {
                this.mBuilder.setAnimation((SourceVariableSpecification)object2);
            }
            if ((object2 = dialogDataModel.getObject(kPANELING_VARIABLES)) != null && ((SourceVariableSpecification[])(summaryType = (SummaryType)object2)).length == 2 && summaryType[0] != null && summaryType[1] != null) {
                this.mBuilder.setPanelingVariables((SourceVariableSpecification)summaryType[0], (SourceVariableSpecification)summaryType[1]);
            }
            object2 = dialogDataModel.getObject(kSUMMARY_VARIABLE);
            try {
                if (object2 != null) {
                    this.mBuilder.setSummaryStatisistic((SummaryType)object2);
                }
            }
            catch (InappropriateSummaryException inappropriateSummaryException) {
                // empty catch block
            }
            boolean bl = false;
            object = dialogDataModel.getString(kUSE_CUSTOM);
            if ("true".equals(object)) {
                bl = true;
            }
            this.mBuilder.setCustomTitles(dialogDataModel.getString(kCUSTOM_TITLE), dialogDataModel.getString(kCUSTOM_SUBTITLE), dialogDataModel.getString(kCUSTOM_FOOTNOTE), bl);
            Boolean bl2 = dialogDataModel.getBoolean(kDEFAULT_ENABLED);
            if (bl2 != null) {
                this.mOptionTab.setDefaultBtnEnabled(bl2);
            }
            if ((string = dialogDataModel.getString(kOUT_LABEL)) != null && string.length() > 0 && this.mOptionTab.isDefaultBtnEnabled()) {
                this.mOptionTab.setOutputLabel(string, true);
            }
            if ((repositoryPathInfo = (RepositoryPathInfo)dialogDataModel.getObject(kRPI_CACHE)) != null) {
                this.mRpi.setLocal(repositoryPathInfo.isLocal());
                this.mRpi.setRemoteFolder(repositoryPathInfo.getRemoteFolder());
                this.mRpi.setSelectedFileName(repositoryPathInfo.getSelectedFileName());
                this.mRpi.setSelectFolderPath(repositoryPathInfo.getSelectFolderPath());
                repositoryPathInfo.setSpecifiedLabel(repositoryPathInfo.getSpecifiedLabel());
                this.repositoryInfoChanged();
            }
            if ((list2 = (List)dialogDataModel.getObject(kMAIN_MAPS)) != null) {
                this.mBuilder.setMainMaps(list2);
            }
            if ((list = (List)dialogDataModel.getObject(kREF_MAPS)) != null) {
                this.mBuilder.setReferenceMaps(list);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void secondInit() throws VisualizationException {
        Object object;
        this.mGraphboard = new Graphboard();
        this.mGraphboard.getPermissionModel().setLicenseInfoProvider((LicenseInfoProvider)new GBLicInfoProvider());
        this.mGraphboard.setInputLocale(UIToolResUtil.getSPSSLocale());
        this.mGraphboard.setOutputLocale(ComponentState.getOLangLocale());
        Helper helper = new Helper(){

            public void setHelpFile(String string, String string2) {
            }

            public void handleHelp(String string) {
                StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, string);
            }
        };
        this.mGraphboard.setHelpHandler(helper);
        this.registerHelpActionListenerForPES();
        this.setTitle(this.getResString("IDS_GRAPHBOARD_TEMPLATE_WINDOW_TITLE"));
        this.mRpi = this.mGraphboard.getRepositoryPathInfo();
        this.mRpi.addListener((RepositoryPathInfoListener)this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel.add((Component)jTabbedPane, "Center");
        jTabbedPane.addChangeListener(this);
        this.mBuilder = new TemplateBuilder(this.mGraphboard.getTemplateDirectory(), this.mGraphboard.getMapDirectory(), this.mGraphboard.getCredentials(), this.mGraphboard.getCredentialHelper(), Locale.getDefault());
        this.mGraphboard.setTemplateBuilder(this.mBuilder);
        jTabbedPane.addTab(this.getResString("IDS_GRAPHBOARD_TEMPLATE_BASIC_TITLE"), this.mBuilder.getTemplateComponent());
        JComponent jComponent = this.mBuilder.getDetailTemplateComponent(this.mGraphboard.getHelpHander());
        if (jComponent instanceof TemplateDetailPanel) {
            object = (TemplateDetailPanel)jComponent;
            object.addMapResourceChangeActionListener((ActionListener)this);
        }
        jTabbedPane.addTab(this.getResString("IDS_GRAPHBOARD_TEMPLATE_DETAILED_TITLE"), jComponent);
        jTabbedPane.addTab(this.getResString("IDS_GRAPHBOARD_TEMPLATE_TITLES_TITLE"), this.mBuilder.getTitleComponent());
        this.mOptionTab = new GBTemplateOptionPanel(this);
        jTabbedPane.addTab(this.getResString("IDS_GRAPHBOARD_TEMPLATE_OPTIONS_TITLE"), this.mOptionTab);
        object = new JPanel();
        ((Container)object).setLayout(new FlowLayout(0));
        JButton jButton = new JButton(this.getResString("IDS_GB_TEMPLATE_IMPORT"));
        jButton.setMnemonic(this.getResInt("IDS_GB_TEMPLATE_IMPORT_KEY"));
        jButton.addActionListener(new ManageAction(this.mGraphboard.getSwingActions().TEMPLATE_AND_STYLESHEET_MANAGER));
        ((Container)object).add(jButton);
        DialogUtil.normalizeButtonWidths((JPanel)object);
        jPanel.add((Component)object, "South");
        this.getContentPane().add(jPanel);
        this.pack();
    }

    @Override
    public void reset() {
        this.mBuilder.reset(true);
        this.mOptionTab.reset();
        this.loadDataSet();
        DialogDataModel dialogDataModel = this.getDialogDataModel();
        dialogDataModel.clear();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent == null) {
            this.stateChanged();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.mBuilder.ready()) {
            String string = this.getDefaultLabel();
            if (string != null) {
                this.mOptionTab.setOutputLabel(string, !this.mOptionTab.isDefaultBtnEnabled());
            }
        } else if (this.mOptionTab != null && this.getDefaultLabel() == null) {
            this.mOptionTab.setOutputLabel(null, !this.mOptionTab.isDefaultBtnEnabled());
        }
    }

    String getDefaultLabel() {
        String string = null;
        Template template = this.mBuilder.getSelectedTemplate();
        Locale locale = ComponentState.getOLangLocale();
        Set<String> set = this.getSelectedVariableNames();
        if (set == null) {
            return "";
        }
        int n = set.size();
        if (template != null && n > 0) {
            String string2 = template.getName();
            if (string2 != null) {
                String string3 = BaseTemplateInternationalization.getLocalizedMessage((String)((String)BaseTemplateInternationalization.templates.get(string2.toLowerCase())), (Locale)this.convertToGraphboardRecognizedLocale(locale));
                string = string3 != null ? string3 + ": " : string2 + ": ";
            }
            boolean bl = true;
            for (String string4 : set) {
                if (bl) {
                    string = string + string4;
                    bl = false;
                    continue;
                }
                string = string + "-" + string4;
            }
        }
        return string;
    }

    TemplateBuilder getTemplateBuilder() {
        return this.mBuilder;
    }

    Graphboard getGraphBoard() {
        return this.mGraphboard;
    }

    private Set<String> getSelectedVariableNames() {
        HashSet<String> hashSet = new HashSet<String>();
        Template template = this.mBuilder.getSelectedTemplate();
        if (template != null) {
            Map map = this.mBuilder.getRequiredVariables();
            if (map == null) {
                return null;
            }
            Set set = map.keySet();
            for (String string : set) {
                SourceVariableSpecification[] sourceVariableSpecificationArray;
                Object v = map.get(string);
                if (v instanceof SourceVariableSpecification) {
                    sourceVariableSpecificationArray = (SourceVariableSpecification[])v;
                    hashSet.add(sourceVariableSpecificationArray.getId());
                    continue;
                }
                if (!(v instanceof SourceVariableSpecification[])) continue;
                for (SourceVariableSpecification sourceVariableSpecification : sourceVariableSpecificationArray = (SourceVariableSpecification[])v) {
                    hashSet.add(sourceVariableSpecification.getId());
                }
            }
        }
        return hashSet;
    }

    private Map<String, String> getVariableMapping() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Template template = this.mBuilder.getSelectedTemplate();
        if (template == null) {
            return hashMap;
        }
        if (this.getSelectedVariableNames() == null) {
            return null;
        }
        try {
            List list;
            VisualizationSpecification visualizationSpecification = this.mBuilder.getSpecification();
            Map map = TemplateFactory.extractMappings((Template)template, (VisualizationSpecification)visualizationSpecification);
            SourceVariableSpecification sourceVariableSpecification = template.getRequiredVariables();
            if (sourceVariableSpecification != null) {
                for (FacetingSpecification[] facetingSpecificationArray2 : sourceVariableSpecification) {
                    list = (List)map.get(facetingSpecificationArray2.getName());
                    if (list == null || list.size() <= 0) continue;
                    String string = "";
                    int n = 1;
                    for (String string2 : list) {
                        if (n != 0) {
                            string = string + string2;
                            n = 0;
                            continue;
                        }
                        string = string + "," + string2;
                    }
                    hashMap.put(facetingSpecificationArray2.getName(), string);
                }
            }
            SourceVariableSpecification sourceVariableSpecification2 = null;
            SummaryType summaryType = null;
            FacetingSpecification[] facetingSpecificationArray = template.getAestheticTypes();
            if (facetingSpecificationArray != null) {
                for (TemplateVariable templateVariable : facetingSpecificationArray) {
                    if ("Color".equalsIgnoreCase((String)templateVariable)) {
                        sourceVariableSpecification2 = this.mBuilder.getOptionalAesthetic(TemplateBuilder.COLOR);
                        if (sourceVariableSpecification2 == null) {
                            summaryType = this.mBuilder.getOptionalAestheticStatistic(TemplateBuilder.COLOR);
                        }
                    } else if ("Size".equalsIgnoreCase((String)templateVariable)) {
                        sourceVariableSpecification2 = this.mBuilder.getOptionalAesthetic(TemplateBuilder.SIZE);
                        if (sourceVariableSpecification2 == null) {
                            summaryType = this.mBuilder.getOptionalAestheticStatistic(TemplateBuilder.SIZE);
                        }
                    } else if ("Shape".equalsIgnoreCase((String)templateVariable)) {
                        sourceVariableSpecification2 = this.mBuilder.getOptionalAesthetic(TemplateBuilder.SHAPE);
                        if (sourceVariableSpecification2 == null) {
                            summaryType = this.mBuilder.getOptionalAestheticStatistic(TemplateBuilder.SHAPE);
                        }
                    } else if ("Label".equalsIgnoreCase((String)templateVariable)) {
                        sourceVariableSpecification2 = this.mBuilder.getOptionalAesthetic(TemplateBuilder.LABEL);
                        if (sourceVariableSpecification2 == null) {
                            summaryType = this.mBuilder.getOptionalAestheticStatistic(TemplateBuilder.LABEL);
                        }
                    } else if ("Transparency".equalsIgnoreCase((String)templateVariable) && (sourceVariableSpecification2 = this.mBuilder.getOptionalAesthetic(TemplateBuilder.TRANSPARENCY)) == null) {
                        summaryType = this.mBuilder.getOptionalAestheticStatistic(TemplateBuilder.TRANSPARENCY);
                    }
                    if (sourceVariableSpecification2 != null) {
                        hashMap.put((String)templateVariable, sourceVariableSpecification2.getSourceName());
                        sourceVariableSpecification2 = null;
                    }
                    if (summaryType == null) continue;
                    hashMap.put((String)templateVariable, summaryType.toString());
                    summaryType = null;
                }
            }
            if ((list = (List)map.get(FACET)) != null && list.size() > 0) {
                FacetingSpecification[] facetingSpecificationArray2;
                facetingSpecificationArray2 = (FacetingSpecification[])visualizationSpecification.findDescendantsOfType(FacetingSpecification.class);
                boolean bl = false;
                for (FacetingSpecification facetingSpecification : facetingSpecificationArray2) {
                    if (((AttachSpecification[])facetingSpecification.findDescendantsOfType(AttachSpecification.class)).length <= 0) continue;
                    bl = true;
                    break;
                }
                if (hashMap.get(PANELING) == null && !bl) {
                    boolean bl2 = false;
                    block6: for (FacetingSpecification facetingSpecification : facetingSpecificationArray2) {
                        VariableReferenceSpecification[] variableReferenceSpecificationArray = (VariableReferenceSpecification[])facetingSpecification.findDescendantsOfType(VariableReferenceSpecification.class);
                        if (variableReferenceSpecificationArray == null || variableReferenceSpecificationArray.length <= 0) continue;
                        for (VariableReferenceSpecification variableReferenceSpecification : variableReferenceSpecificationArray) {
                            if (!"panelacross".equalsIgnoreCase(variableReferenceSpecification.getAttribute("ref").toString())) continue;
                            bl2 = true;
                            continue block6;
                        }
                    }
                    if (bl2) {
                        hashMap.put(PANEL_ACROSS, (String)list.get(0));
                    }
                    if (list.size() > 1) {
                        hashMap.put(PANEL_DOWN, (String)list.get(1));
                    }
                }
            }
            if ((list = (List)map.get(ANIMATION.toLowerCase())) != null && list.size() > 0) {
                hashMap.put(ANIMATION, (String)list.get(0));
            }
        }
        catch (VisualizationException visualizationException) {
            visualizationException.printStackTrace();
        }
        return hashMap;
    }

    private Map<String, String> getSummaryMapping() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Template template = this.mBuilder.getSelectedTemplate();
        if (template == null) {
            return hashMap;
        }
        SummaryType summaryType = this.mBuilder.getSummaryStatistic();
        if (summaryType != null) {
            hashMap.put(SUMMARY, summaryType.toString());
        }
        return hashMap;
    }

    private void setPathLabel() {
        if (this.isLocalStore()) {
            this.mPathLabel.setText(GraphboardInternationalization.getLocalizedMessage((String)"localRepository"));
        } else {
            this.mPathLabel.setText(this.mRpi.getSelectFolderPath());
        }
    }

    private boolean isLocalStore() {
        return this.mRpi.isLocal();
    }

    private LocallyUniqueId getDataSetId() {
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            return ((DataFrame)spssFrame).getDatasetId();
        }
        return null;
    }

    private Map<String, MeasurementLevel> getMeasureLevels() {
        HashMap<String, MeasurementLevel> hashMap = new HashMap<String, MeasurementLevel>();
        Map map = this.mBuilder.getVariableTypesForSource();
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            VariableType variableType = (VariableType)entry.getValue();
            if (variableType == null || variableType.getMeasurementLevel() == null) continue;
            hashMap.put(string, variableType.getMeasurementLevel());
        }
        return hashMap;
    }

    private Map<String, String> getTitlesMapping() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = this.mBuilder.getCustomTitle(LabelPurposeType.TITLE);
        String string2 = this.mBuilder.getCustomTitle(LabelPurposeType.SUB_TITLE);
        String string3 = this.mBuilder.getCustomTitle(LabelPurposeType.FOOTNOTE);
        if (string != null && string.length() > 0) {
            hashMap.put("Title", string);
        }
        if (string2 != null && string2.length() > 0) {
            hashMap.put("Subtitle", string2);
        }
        if (string3 != null && string3.length() > 0) {
            hashMap.put("Footnote", string3);
        }
        return hashMap;
    }

    public void repositoryInfoChanged() {
        this.setPathLabel();
        try {
            TemplateFactory templateFactory;
            if (this.isLocalStore()) {
                templateFactory = TemplateFactory.getLocalDirectoryInstance((File)this.mGraphboard.getTemplateDirectory());
                this.mStylesheetFactory = StyleSheetFactory.getLocalDirectoryInstance((File)this.mGraphboard.getStylesheetDirectory());
            } else {
                RepositoryFolder repositoryFolder = this.mRpi.getRemoteFolder();
                String string = repositoryFolder.getFullPathName();
                templateFactory = TemplateFactory.getRepositoryInstance((Repository)PESBrowser.getRepository(), (String)string, (String)this.mRpi.getSpecifiedLabel(), (String)this.mRpi.getSelectedFileName());
                this.mStylesheetFactory = StyleSheetFactory.getRepositoryInstance((Repository)PESBrowser.getRepository(), (String)string, (String)this.mRpi.getSpecifiedLabel(), (String)this.mRpi.getSelectedFileName());
            }
            this.mBuilder.setUserTemplateFactory(templateFactory);
        }
        catch (Exception exception) {
            this.mGraphboard.getErrorHandler().handleThrowable((Throwable)exception);
        }
    }

    public void stateChanged() {
        if (this.mBuilder.ready()) {
            this.enableOkPaste(true);
            this.enablePaste(this.mModelFrame == null);
            if (this.isMapSelected()) {
                this.enableOkPaste(this.isMapFileExist());
            }
        } else {
            this.enableOkPaste(false);
        }
    }

    public static String getSubDirectory(String string) {
        String string2 = System.getProperty("file.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append("lang");
        stringBuffer.append(string2);
        stringBuffer.append(string);
        stringBuffer.append(string2).append("help").append(string2);
        stringBuffer.append("main").append(string2);
        return stringBuffer.toString();
    }

    private void registerHelpActionListenerForPES() {
        PESBrowser.registerHelpActionListener((ActionListener)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Component component;
                Window window;
                if (actionEvent.getSource() instanceof Component && (window = SwingUtilities.getWindowAncestor(component = (Component)actionEvent.getSource())) instanceof HelpFileMap) {
                    String string = ((HelpFileMap)window).getDialogHelpID();
                    GraphboardTemplateChooser.this.mGraphboard.getHelpHander().handleHelp(string);
                }
            }
        });
    }

    @Override
    public void dispose() {
        this.mSortOrder = this.mBuilder.getVariableSorter().getSortOrder();
        super.dispose();
    }

    private String getMapName(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        try {
            URI uRI = URI.create(string);
            File file = new File(uRI.getPath());
            return MapInfo.removeExtension((String)file.getName());
        }
        catch (Exception exception) {
            return MapInfo.removeExtension((String)string);
        }
    }

    protected boolean isMapSelected() {
        boolean bl = false;
        List list = this.mBuilder.getMainMaps();
        List list2 = this.mBuilder.getReferenceMaps();
        if (list != null && list.size() > 0 || list2 != null && list2.size() > 0) {
            bl = true;
        }
        return bl;
    }

    protected boolean isMapFileExist() {
        Object object;
        MapInfo.MapIdentifier mapIdentifier;
        MapInfo.MainMap mainMap;
        Object object2;
        List list = this.mBuilder.getMainMaps();
        if (list != null && list.size() > 0) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                mainMap = (MapInfo.MainMap)object2.next();
                mapIdentifier = mainMap.getMapIdentifier();
                if (!(mapIdentifier instanceof MapInfo.FileMapIdentifier) || (object = ((MapInfo.FileMapIdentifier)mapIdentifier).getFilePath()) == null || ((String)object).length() <= 0) continue;
                return true;
            }
        }
        if ((object2 = this.mBuilder.getReferenceMaps()) != null && object2.size() > 0) {
            mainMap = object2.iterator();
            while (mainMap.hasNext()) {
                String string;
                mapIdentifier = (MapInfo.ReferenceMap)mainMap.next();
                object = mapIdentifier.getMapIdentifier();
                if (!(object instanceof MapInfo.FileMapIdentifier) || (string = ((MapInfo.FileMapIdentifier)object).getFilePath()) == null || string.length() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private Locale convertToGraphboardRecognizedLocale(Locale locale) {
        if (locale == null) {
            return null;
        }
        if (locale.getLanguage().equals("en")) {
            return new Locale("en", "US", "shout");
        }
        return locale;
    }

    private class ManageAction
    extends AbstractAction {
        public Action graphboardAction;

        ManageAction(Action action) {
            this.graphboardAction = action;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.graphboardAction.actionPerformed(actionEvent);
            VisRepository visRepository = GraphboardTemplateChooser.this.getGraphBoard().getRepository();
            File file = visRepository.getStylesheetDirectory();
            try {
                StylesheetLoader stylesheetLoader = new StylesheetLoader(file);
                Collection collection = stylesheetLoader.getAllStyleSheets();
                GraphboardTemplateChooser.this.mOptionTab.validateSelectSheetName(collection);
            }
            catch (StyleSheetLoaderException styleSheetLoaderException) {
                GraphboardTemplateChooser.this.mGraphboard.getErrorHandler().handleThrowable((Throwable)styleSheetLoaderException);
            }
        }
    }

    public static class VariableTypeHolder
    implements SerializableObject {
        public String getClassName() {
            return null;
        }

        public boolean readVersionedObject(ObjectInputStream objectInputStream, int n) throws Exception {
            return false;
        }

        public boolean writeVersionedObject(ObjectOutputStream objectOutputStream, int n) throws Exception {
            return false;
        }
    }

    class ChooserWindowHandler
    extends WindowAdapter {
        ChooserWindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            GraphboardTemplateChooser.this.dispose();
        }
    }
}

