/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.dialogs.base.graphs.GraphboardTemplateChooser;
import com.spss.java_client.ui.dialogs.base.graphs.SelectStyleDialog;
import com.spss.java_client.ui.dialogs.base.graphs.res.GraphsResBundle;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.WindowsButtonGroup;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.vis.graphboard.styleSheet.StyleSheet;
import com.spss.vis.graphboard.styleSheet.StyleSheetFactory;
import com.spss.vis.graphboard.styleSheet.StyleSheetLoaderException;
import com.spss.vis.graphboard.styleSheet.StylesheetLoader;
import com.spss.vis.graphboard.util.BuildGraphboardDirectories;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.font.TextAttribute;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class GBTemplateOptionPanel
extends JPanel
implements ActionListener {
    private GraphboardTemplateChooser mChooser;
    private ResourceBundle mResourceBundle;
    private JTextField mOutputLabelText;
    private JButton mDefaultBtn;
    private JButton mSelectBtn;
    private JRadioButton mExcludeBtn;
    private JRadioButton mIncludeBtn;
    private JRadioButton mExcludeListwiseBtn;
    private JRadioButton mExcludeVariablesBtn;
    private WindowsButtonGroup mBreakVarGroup = new WindowsButtonGroup();
    private WindowsButtonGroup mSummaryGroup = new WindowsButtonGroup();
    private JLabel mStylkeSheetSelected = new JLabel();
    private String mBaseLabel = "";
    private String mDefaultStyleSheetDisplayName;

    public GBTemplateOptionPanel(GraphboardTemplateChooser graphboardTemplateChooser) {
        this.mChooser = graphboardTemplateChooser;
        this.mResourceBundle = ResUtil.getBundle(GraphsResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, 0, 0);
        JPanel jPanel = this.getOutputLabelPanel();
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel2 = this.getStyleSheetPanel();
        gridBagConstraints.weightx = 1.0;
        jPanel2.setMinimumSize(new Dimension(jPanel.getPreferredSize().width / 2, jPanel.getPreferredSize().height));
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(this, this.getUserMissingValuesPanel(), gridBagConstraints, 0, 1, 2, 1, n, insets);
        this.mDefaultStyleSheetDisplayName = this.getDefaultStyleSheetInternationalName();
        this.mStylkeSheetSelected.setText(this.mDefaultStyleSheetDisplayName);
    }

    private JPanel getOutputLabelPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(UIToolResUtil.getString((ResourceBundle)this.mResourceBundle, (String)"IDS_GBT_OUTPUT_LABEL")));
        JLabel jLabel = new JLabel(UIToolResUtil.getString((ResourceBundle)this.mResourceBundle, (String)"IDS_GBT_LABEL"));
        this.mOutputLabelText = new JTextField(20);
        if (ComponentState.isBtdRtlOrLtr()) {
            if (ComponentState.getBTD() == 1) {
                this.mOutputLabelText.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
            } else {
                this.mOutputLabelText.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
            }
        }
        this.mOutputLabelText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (ComponentState.getBTD() == 0 && GBTemplateOptionPanel.this.mOutputLabelText.getText() != null && GBTemplateOptionPanel.this.mOutputLabelText.getText().length() == 0) {
                    if (ComponentState.isBidiLetter((char)keyEvent.getKeyChar()) && GBTemplateOptionPanel.this.mOutputLabelText.getDocument().getProperty(TextAttribute.RUN_DIRECTION) == TextAttribute.RUN_DIRECTION_LTR) {
                        GBTemplateOptionPanel.this.mOutputLabelText.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_RTL);
                    } else if (!ComponentState.isBidiLetter((char)keyEvent.getKeyChar()) && GBTemplateOptionPanel.this.mOutputLabelText.getDocument().getProperty(TextAttribute.RUN_DIRECTION) == TextAttribute.RUN_DIRECTION_RTL) {
                        GBTemplateOptionPanel.this.mOutputLabelText.getDocument().putProperty(TextAttribute.RUN_DIRECTION, TextAttribute.RUN_DIRECTION_LTR);
                    }
                }
                GBTemplateOptionPanel.this.mDefaultBtn.setEnabled(true);
            }
        });
        this.mDefaultBtn = DialogUtil.createButton(this.mChooser, "IDS_GBT_DEFAULT", this);
        this.mDefaultBtn.addActionListener(this);
        this.mDefaultBtn.setEnabled(false);
        JLabel jLabel2 = new JLabel(UIToolResUtil.getString((ResourceBundle)this.mResourceBundle, (String)"IDS_GBT_LABEL_NOTE"));
        jLabel.setDisplayedMnemonic((Integer)UIToolResUtil.getObject((String)"IDS_GBT_LABEL_KEY", (ResourceBundle)this.mResourceBundle));
        jLabel.setLabelFor(this.mOutputLabelText);
        this.mDefaultBtn.setMnemonic((Integer)UIToolResUtil.getObject((String)"IDS_GBT_DEFAULT_KEY", (ResourceBundle)this.mResourceBundle));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mOutputLabelText, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 3, 1, n, new Insets(n2, n2, n2, n2));
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mDefaultBtn, gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel getStyleSheetPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(UIToolResUtil.getString((ResourceBundle)this.mResourceBundle, (String)"IDS_GBT_STYLESHEET")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(2, n2, n2, 0);
        this.mSelectBtn = DialogUtil.createButton(this.mChooser, "IDS_GBT_SELECT", this);
        this.mSelectBtn.setMnemonic((Integer)UIToolResUtil.getObject((String)"IDS_GBT_SELECT_KEY", (ResourceBundle)this.mResourceBundle));
        DialogUtil.addUsingGBL(jPanel, this.mSelectBtn, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mStylkeSheetSelected.setFocusable(true);
        DialogUtil.addUsingGBL(jPanel, this.mStylkeSheetSelected, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel getUserMissingValuesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(UIToolResUtil.getString((ResourceBundle)this.mResourceBundle, (String)"IDS_GBT_USER_MISSING_VALUES")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 2, 0, 0);
        String string = GraphsResBundle.getImageFolder();
        String string2 = UIToolResUtil.getString((ResourceBundle)this.mResourceBundle, (String)"IDS_GBT_WARNING");
        URL uRL = UIToolResUtil.getImageResourceFullPath((String)(string + string2));
        ImageIcon imageIcon = new ImageIcon(uRL);
        JLabel jLabel = new JLabel(UIToolResUtil.getString((ResourceBundle)this.mResourceBundle, (String)"IDS_GBT_USER_MISSING_WARNING"), imageIcon, 2);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 2, 1, n, new Insets(n2, 2, 0, n2));
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.getSummaryStatPanel(), gridBagConstraints, 1, 1, 1, 1, n, new Insets(n2, 0, 0, 0));
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.getBreakVariablesPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel getBreakVariablesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(UIToolResUtil.getString((ResourceBundle)this.mResourceBundle, (String)"IDS_GBT_BREAK_VARIABLES")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        this.mExcludeBtn = DialogUtil.createRadioButton(this.mChooser, "IDS_GBT_EXCLUDE", (ActionListener)this);
        this.mIncludeBtn = DialogUtil.createRadioButton(this.mChooser, "IDS_GBT_INCLUDE", (ActionListener)this);
        this.mBreakVarGroup.add((AbstractButton)this.mExcludeBtn);
        this.mBreakVarGroup.add((AbstractButton)this.mIncludeBtn);
        this.mBreakVarGroup.setIndexSelected(0);
        this.mExcludeBtn.setMnemonic((Integer)UIToolResUtil.getObject((String)"IDS_GBT_EXCLUDE_KEY", (ResourceBundle)this.mResourceBundle));
        this.mIncludeBtn.setMnemonic((Integer)UIToolResUtil.getObject((String)"IDS_GBT_INCLUDE_KEY", (ResourceBundle)this.mResourceBundle));
        DialogUtil.addUsingGBL(jPanel, this.mExcludeBtn, gridBagConstraints, 0, 0, 1, 1, n, new Insets(2, n2, 0, 0));
        DialogUtil.addUsingGBL(jPanel, this.mIncludeBtn, gridBagConstraints, 0, 1, 1, 1, n, new Insets(n2, n2, n2, n2));
        return jPanel;
    }

    private JPanel getSummaryStatPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(UIToolResUtil.getString((ResourceBundle)this.mResourceBundle, (String)"IDS_GBT_SUMMARY_STATISTICS")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = 23;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        this.mExcludeListwiseBtn = DialogUtil.createRadioButton(this.mChooser, "IDS_GBT_EXCLUDE_LISTWISE", (ActionListener)this);
        this.mExcludeVariablesBtn = DialogUtil.createRadioButton(this.mChooser, "IDS_GBT_EXCLUDE_VARIABLE", (ActionListener)this);
        this.mSummaryGroup.add((AbstractButton)this.mExcludeListwiseBtn);
        this.mSummaryGroup.add((AbstractButton)this.mExcludeVariablesBtn);
        this.mSummaryGroup.setIndexSelected(0);
        this.mExcludeListwiseBtn.setMnemonic((Integer)UIToolResUtil.getObject((String)"IDS_GBT_EXCLUDE_LISTWISE_KEY", (ResourceBundle)this.mResourceBundle));
        this.mExcludeVariablesBtn.setMnemonic((Integer)UIToolResUtil.getObject((String)"IDS_GBT_EXCLUDE_VARIABLE_KEY", (ResourceBundle)this.mResourceBundle));
        DialogUtil.addUsingGBL(jPanel, this.mExcludeListwiseBtn, gridBagConstraints, 0, 0, 1, 1, n, new Insets(2, n2, 0, 0));
        DialogUtil.addUsingGBL(jPanel, this.mExcludeVariablesBtn, gridBagConstraints, 0, 1, 1, 1, n, new Insets(n2, n2, n2, 20));
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mSelectBtn) {
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window instanceof Frame) {
                new SelectStyleDialog((Frame)window, this.mChooser.getGraphBoard(), this, this.mChooser.getStyleSheetFactory());
            } else if (window instanceof Dialog) {
                new SelectStyleDialog((Dialog)window, this.mChooser.getGraphBoard(), this, this.mChooser.getStyleSheetFactory());
            }
        } else if (object == this.mDefaultBtn) {
            this.mOutputLabelText.setText(this.mBaseLabel);
            this.mOutputLabelText.setSelectionStart(0);
            this.mOutputLabelText.setSelectionEnd(0);
            this.mDefaultBtn.setEnabled(false);
        }
    }

    public void setOutputLabel(String string, boolean bl) {
        this.mBaseLabel = string;
        if (bl) {
            if (ComponentState.isBtdRtlOrLtr() && this.mBaseLabel != null && this.mBaseLabel.length() > 0) {
                if (this.mBaseLabel.indexOf(58) != -1 && this.mBaseLabel.substring(this.mBaseLabel.indexOf(58)).length() > 1 && ComponentState.containsBidiLetter((String)this.mBaseLabel.substring(this.mBaseLabel.indexOf(58) + 1))) {
                    if (ComponentState.getBTD() == 2) {
                        this.mOutputLabelText.setText(ComponentState.prepareStringForBidiRendering((String)this.mBaseLabel.substring(0, this.mBaseLabel.indexOf(58) + 1)) + ComponentState.prepareStringForBidiRendering((String)this.mBaseLabel.substring(this.mBaseLabel.indexOf(58) + 1)));
                    } else {
                        this.mOutputLabelText.setText(ComponentState.prepareStringForBidiRendering((String)this.mBaseLabel.substring(this.mBaseLabel.indexOf(58) + 2)) + " :" + ComponentState.prepareStringForBidiRendering((String)this.mBaseLabel.substring(0, this.mBaseLabel.indexOf(58))));
                    }
                } else {
                    this.mOutputLabelText.setText(ComponentState.prepareStringForBidiRendering((String)this.mBaseLabel));
                }
            } else if (!ComponentState.containsBidiLetter((String)this.mBaseLabel)) {
                this.mOutputLabelText.setText(this.mBaseLabel);
            } else if (this.mBaseLabel.indexOf(58) != -1 && this.mBaseLabel.substring(this.mBaseLabel.indexOf(58)).length() > 2 && ComponentState.isBidiLetter((char)this.mBaseLabel.substring(this.mBaseLabel.indexOf(58) + 1).charAt(1))) {
                this.mOutputLabelText.setText(this.mBaseLabel.substring(0, this.mBaseLabel.indexOf(58) + 2) + '\u202b' + this.mBaseLabel.substring(this.mBaseLabel.indexOf(58) + 2) + '\u202c');
            } else {
                this.mOutputLabelText.setText(this.mBaseLabel);
            }
            this.mOutputLabelText.setSelectionStart(0);
            this.mOutputLabelText.setSelectionEnd(0);
        }
    }

    public String getOutputLabel() {
        if (this.mDefaultBtn.isEnabled()) {
            return this.mOutputLabelText.getText();
        }
        return this.mChooser.getDefaultLabel();
    }

    public boolean isMissingInclude() {
        return this.mIncludeBtn.isSelected();
    }

    public boolean isVariablewise() {
        return this.mExcludeVariablesBtn.isSelected();
    }

    public void setSelectSheetName(String string) {
        this.mStylkeSheetSelected.setText(string);
    }

    public String getSelectSheetName() {
        return this.mStylkeSheetSelected.getText();
    }

    public String getSelectSheetId(StyleSheetFactory styleSheetFactory, boolean bl) {
        String string = null;
        String string2 = this.mStylkeSheetSelected.getText();
        try {
            StylesheetLoader stylesheetLoader = null;
            stylesheetLoader = bl ? new StylesheetLoader(this.mChooser.getGraphBoard().getStylesheetDirectory()) : new StylesheetLoader(this.mChooser.getGraphBoard().getStylesheetDirectory(), styleSheetFactory);
            Collection collection = stylesheetLoader.getAllStyleSheets();
            for (StyleSheet styleSheet : collection) {
                if (string2 == null || !string2.equals(styleSheet.getInternationalizedName())) continue;
                string = styleSheet.getName();
                break;
            }
        }
        catch (StyleSheetLoaderException styleSheetLoaderException) {
            styleSheetLoaderException.printStackTrace();
        }
        return string;
    }

    public void reset() {
        this.mDefaultBtn.doClick();
        this.mExcludeBtn.setSelected(true);
        this.mExcludeListwiseBtn.setSelected(true);
        this.mStylkeSheetSelected.setText(this.mDefaultStyleSheetDisplayName);
    }

    public boolean isDefaultBtnEnabled() {
        return this.mDefaultBtn.isEnabled();
    }

    public void setDefaultBtnEnabled(boolean bl) {
        this.mDefaultBtn.setEnabled(bl);
    }

    public void validateSelectSheetName(Collection<StyleSheet> collection) {
        String string = this.getSelectSheetName();
        if (string == null || string.equals(this.mDefaultStyleSheetDisplayName)) {
            return;
        }
        boolean bl = false;
        for (StyleSheet styleSheet : collection) {
            String string2 = styleSheet.getInternationalizedName();
            if (!string2.equals(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.mStylkeSheetSelected.setText(this.mDefaultStyleSheetDisplayName);
        }
    }

    private String getDefaultStyleSheetInternationalName() {
        String string = null;
        try {
            File file = BuildGraphboardDirectories.getUserDir();
            StylesheetLoader stylesheetLoader = new StylesheetLoader(new File(file, "stylesheets"));
            String string2 = "Traditional";
            Collection collection = stylesheetLoader.getAllStyleSheets();
            for (StyleSheet styleSheet : collection) {
                if (!string2.equals(styleSheet.getName())) continue;
                string = styleSheet.getInternationalizedName();
                break;
            }
        }
        catch (StyleSheetLoaderException styleSheetLoaderException) {
            styleSheetLoaderException.printStackTrace();
        }
        return string;
    }
}

