/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.graphs;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseSubDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class DefineStatisticSubDlg
extends BaseSubDialog
implements ItemListener,
DocumentListener,
FocusListener {
    public static final String CURRENT_STATISTIC_FUNCTION = "IDS_CURRENT_STATISTIC_FUNCTION";
    private JRadioButton mMeanRadio;
    private JRadioButton mModeRadio;
    private JRadioButton mMedianRadio;
    private JRadioButton mStdDeviationRadio;
    private JRadioButton mVarianceRadio;
    private JRadioButton mMinValueRadio;
    private JRadioButton mMaxValueRadio;
    private JRadioButton mNoOfCasesRadio;
    private JRadioButton mSumOfValuesRadio;
    private JRadioButton mCumulativeSumRadio;
    private JRadioButton mPercentageAboveRadio;
    private JRadioButton mPercentageBelowRadio;
    private JRadioButton mPercentileRadio;
    private JRadioButton mNumberAboveRadio;
    private JRadioButton mNumberBelowRadio;
    private JRadioButton mPercentageInsideRadio;
    private JRadioButton mNumberInsideRadio;
    private JCheckBox mValuesCheckBox;
    private ContextEnabledTextField mValueTextField;
    private ContextEnabledTextField mLowTextField;
    private ContextEnabledTextField mHighTextField;
    private JLabel mValueLabel;
    private JLabel mLowLabel;
    private JLabel mHighLabel;

    public DefineStatisticSubDlg(BaseProcedureDialog baseProcedureDialog, String string, boolean bl) {
        super(baseProcedureDialog, string, bl);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_grsf";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableTextField();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableTextField();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableTextField();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof ContextEnabledTextField) {
            ((ContextEnabledTextField)object).selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (object instanceof JRadioButton) {
            if (object.equals(this.mPercentileRadio) || object.equals(this.mMedianRadio)) {
                bl = true;
                bl2 = false;
                bl3 = false;
                if (object.equals(this.mPercentileRadio)) {
                    bl3 = true;
                    this.enableContinue(this.mValueTextField.getText().length() > 0);
                }
            } else if (object.equals(this.mPercentageAboveRadio) || object.equals(this.mPercentageBelowRadio) || object.equals(this.mPercentileRadio) || object.equals(this.mNumberAboveRadio) || object.equals(this.mNumberBelowRadio)) {
                bl = false;
                bl2 = false;
                bl3 = true;
                this.enableContinue(this.mValueTextField.getText().length() > 0);
            } else if (object.equals(this.mPercentageInsideRadio) || object.equals(this.mNumberInsideRadio)) {
                bl = false;
                bl2 = true;
                bl3 = false;
                this.enableContinue(!this.mLowTextField.getText().equals("") && !this.mHighTextField.getText().equals(""));
            } else {
                bl = false;
                bl2 = false;
                bl3 = false;
                this.enableContinue(true);
            }
            this.mValuesCheckBox.setEnabled(bl);
            this.mValueLabel.setEnabled(bl3);
            this.mValueTextField.setEnabled(bl3);
            this.mValueTextField.setOpaque(bl3);
            this.mLowLabel.setEnabled(bl2);
            this.mLowTextField.setEnabled(bl2);
            this.mLowTextField.setOpaque(bl2);
            this.mHighLabel.setEnabled(bl2);
            this.mHighTextField.setEnabled(bl2);
            this.mHighTextField.setOpaque(bl2);
        }
    }

    @Override
    public boolean continuePressed() {
        float f;
        boolean bl = true;
        if (this.mLowTextField.isEnabled() && Float.parseFloat(this.mLowTextField.getText()) > Float.parseFloat(this.mHighTextField.getText())) {
            bl = false;
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_GRAPH_INVALID_VALUE_TEXTFIELD_MSG"), VersionInfo.getAppVersionString());
            this.mLowTextField.requestFocus();
            this.mLowTextField.selectAll();
        }
        if (this.mPercentileRadio.isSelected() && ((double)(f = Float.parseFloat(this.mValueTextField.getText())) < 1.0 || (double)f > 99.0)) {
            bl = false;
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), ResUtil.getCommonDlgString("ERR_OUT_OF_RANGE_ERROR_MSG"), VersionInfo.getAppVersionString());
            this.mValueTextField.requestFocus();
            this.mValueTextField.selectAll();
        }
        return bl;
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        this.setDefaults();
        JPanel jPanel = this.getViewPanel();
        this.setUpUI(jPanel);
        this.setTabTraversalPolicy();
        this.pack();
    }

    @Override
    protected void loadState(DialogDataModel dialogDataModel) {
        super.loadState(dialogDataModel);
        this.loadControlStates(dialogDataModel.getString(CURRENT_STATISTIC_FUNCTION));
    }

    private void loadControlStates(String string) {
        this.mValuesCheckBox.setSelected(false);
        this.mLowTextField.setText("");
        this.mHighTextField.setText("");
        this.mValueTextField.setText("");
        if (string != null && string.length() > 0) {
            int n = string.indexOf("(");
            if (n < 0) {
                if (string.equals("MEAN")) {
                    this.mMeanRadio.setSelected(true);
                } else if (string.equals("GMED")) {
                    this.mMedianRadio.setSelected(true);
                    this.mValuesCheckBox.setSelected(true);
                } else if (string.equals("MED")) {
                    this.mMedianRadio.setSelected(true);
                } else if (string.equals("MODE")) {
                    this.mModeRadio.setSelected(true);
                } else if (string.equals("N")) {
                    this.mNoOfCasesRadio.setSelected(true);
                } else if (string.equals("SUM")) {
                    this.mSumOfValuesRadio.setSelected(true);
                } else if (string.equals("STD")) {
                    this.mStdDeviationRadio.setSelected(true);
                } else if (string.equals("VAR")) {
                    this.mVarianceRadio.setSelected(true);
                } else if (string.equals("MIN")) {
                    this.mMinValueRadio.setSelected(true);
                } else if (string.equals("MAX")) {
                    this.mMaxValueRadio.setSelected(true);
                } else if (string.equals("CUS")) {
                    this.mCumulativeSumRadio.setSelected(true);
                }
            } else {
                int n2;
                String string2 = string;
                int n3 = string2.indexOf("(");
                String[] stringArray = (string2 = string2.substring(n3 + 1, n2 = string2.indexOf(")"))).split(" ");
                if (stringArray.length > 1) {
                    this.mLowTextField.setText(stringArray[0]);
                    this.mHighTextField.setText(stringArray[1]);
                    if (string.contains("PIN")) {
                        this.mPercentageInsideRadio.setSelected(true);
                    } else if (string.contains("NIN")) {
                        this.mNumberInsideRadio.setSelected(true);
                    }
                } else {
                    this.mValueTextField.setText(stringArray[0]);
                    if (string.contains("PGT")) {
                        this.mPercentageAboveRadio.setSelected(true);
                    } else if (string.contains("PLT")) {
                        this.mPercentageBelowRadio.setSelected(true);
                    } else if (string.contains("GPTILE")) {
                        this.mPercentileRadio.setSelected(true);
                        this.mValuesCheckBox.setSelected(true);
                    } else if (string.contains("PTILE")) {
                        this.mPercentileRadio.setSelected(true);
                    } else if (string.contains("NGT")) {
                        this.mNumberAboveRadio.setSelected(true);
                    } else if (string.contains("NLT")) {
                        this.mNumberBelowRadio.setSelected(true);
                    }
                }
            }
        }
    }

    private void setDefaults() {
        this.mValuesCheckBox.setEnabled(false);
        this.mLowTextField.setColumns(9);
        this.mLowLabel.setEnabled(false);
        this.mLowTextField.setEnabled(false);
        this.mLowTextField.setOpaque(false);
        this.mHighLabel.setEnabled(false);
        this.mHighTextField.setColumns(9);
        this.mHighTextField.setEnabled(false);
        this.mHighTextField.setOpaque(false);
        this.mValueTextField.setColumns(9);
        this.mValueTextField.setOpaque(false);
        this.mValueLabel.setEnabled(false);
        this.mValueTextField.setEnabled(false);
        this.mMeanRadio.setSelected(true);
    }

    private void initVars() {
        this.mMeanRadio = this.createRadioButton(this, "IDS_GRAPHS_MEAN_OF_VALUES_RADIO");
        this.mMedianRadio = this.createRadioButton(this, "IDS_GRAPHS_MEDIAN_OF_VALUES_RADIO");
        this.mModeRadio = this.createRadioButton(this, "IDS_GRAPHS_MODE_OF_VALUES_RADIO");
        this.mNoOfCasesRadio = this.createRadioButton(this, "IDS_GRAPHS_NUMBER_OF_CASES_RADIO");
        this.mSumOfValuesRadio = this.createRadioButton(this, "IDS_GRAPHS_SUM_OF_VALUES_RADIO");
        this.mStdDeviationRadio = this.createRadioButton(this, "IDS_GRAPHS_STANDARD_DEVIATION_RADIO");
        this.mVarianceRadio = this.createRadioButton(this, "IDS_GRAPHS_VARIANCE_RADIO");
        this.mMinValueRadio = this.createRadioButton(this, "IDS_GRAPHS_MINIMUM_VALUE_RADIO");
        this.mMaxValueRadio = this.createRadioButton(this, "IDS_GRAPHS_MAXIMUM_VALUE_RADIO");
        this.mCumulativeSumRadio = this.createRadioButton(this, "IDS_GRAPHS_CUMULATIVE_SUM_RADIO");
        this.mPercentageAboveRadio = this.createRadioButton(this, "IDS_GRAPHS_PERCENTAGE_ABOVE_RADIO");
        this.mNumberAboveRadio = this.createRadioButton(this, "IDS_GRAPHS_NUMBER_ABOVE_RADIO");
        this.mPercentageBelowRadio = this.createRadioButton(this, "IDS_GRAPHS_PERCENTAGE_BELOW_RADIO");
        this.mNumberBelowRadio = this.createRadioButton(this, "IDS_GRAPHS_NUMBER_BELOW_RADIO");
        this.mPercentileRadio = this.createRadioButton(this, "IDS_GRAPHS_PERCENTILE_RADIO");
        this.mPercentageInsideRadio = this.createRadioButton(this, "IDS_GRAPHS_PERCENTAGE_INSIDE_RADIO");
        this.mNumberInsideRadio = this.createRadioButton(this, "IDS_GRAPHS_NUMBER_INSIDE_RADIO");
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_GRAPHS_VALUES_ARE_GROUPED_MIDPOINTS_CHECK");
        this.mValuesCheckBox = new JCheckBox(toggleButtonAction);
        this.mValuesCheckBox.addItemListener(this);
        this.mLowLabel = DialogUtil.createLabel(this, "IDS_GRAPHS_LOW_LABEL");
        this.mLowTextField = new ContextEnabledTextField();
        this.mLowTextField.setDocument((Document)new FixedLengthNumericDocument(12, false, true));
        this.mLowTextField.getDocument().addDocumentListener(this);
        this.mLowTextField.addFocusListener((FocusListener)this);
        this.mLowTextField.setAction((Action)new TextFieldAction(this, "IDS_GRAPHS_LOW_LABEL"));
        this.mLowLabel.setLabelFor((Component)this.mLowTextField);
        this.mHighLabel = DialogUtil.createLabel(this, "IDS_GRAPHS_HIGH_LABEL");
        this.mHighTextField = new ContextEnabledTextField();
        this.mHighTextField.setDocument((Document)new FixedLengthNumericDocument(12, false, true));
        this.mHighTextField.getDocument().addDocumentListener(this);
        this.mHighTextField.addFocusListener((FocusListener)this);
        this.mHighTextField.setAction((Action)new TextFieldAction(this, "IDS_GRAPHS_HIGH_LABEL"));
        this.mHighLabel.setLabelFor((Component)this.mHighTextField);
        this.mValueLabel = DialogUtil.createLabel(this, "IDS_GRAPHS_VALUE_LABEL");
        this.mValueTextField = new ContextEnabledTextField();
        this.mValueTextField.setDocument((Document)new FixedLengthNumericDocument(12, false, true));
        this.mValueTextField.getDocument().addDocumentListener(this);
        this.mValueTextField.addFocusListener((FocusListener)this);
        this.mValueTextField.setAction((Action)new TextFieldAction(this, "IDS_GRAPHS_VALUE_LABEL"));
        this.mValueLabel.setLabelFor((Component)this.mValueTextField);
    }

    private JPanel setupLinePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, Color.GRAY));
        return jPanel;
    }

    private void setUpUI(JPanel jPanel) {
        JPanel jPanel2 = this.setupStatisticPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, 23, null);
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mValuesCheckBox, gridBagConstraints, 0, 1, 2, 1, 23, insets);
    }

    private JPanel setupLowAndHighTextFieldPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(n, n, n, 0);
        DialogUtil.addUsingGBL(jPanel, this.mLowLabel, gridBagConstraints, 0, 0, 1, 1, 23, insets2);
        this.mLowTextField.setMinimumSize(new Dimension(30, 20));
        insets2.set(n, insets.left, n, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mLowTextField, gridBagConstraints, 1, 0, 1, 1, 23, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mHighLabel, gridBagConstraints, 2, 0, 1, 1, 23, insets2);
        insets2.set(n, insets.left, n, n);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mHighTextField, gridBagConstraints, 3, 0, 1, 1, 23, insets2);
        return jPanel;
    }

    private JPanel setupStatisticPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_GRAPHS_STATISTIC_FOR_SELECTED_VARIABLES_TITLE_BORDER"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(n, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMeanRadio, gridBagConstraints, 0, 0, 1, 1, 23, insets2);
        insets2.set(insets.top, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mMedianRadio, gridBagConstraints, 0, 1, 1, 1, 23, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mModeRadio, gridBagConstraints, 0, 2, 1, 1, 23, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mNoOfCasesRadio, gridBagConstraints, 0, 3, 1, 1, 23, insets2);
        insets2.set(insets.top, n, n, 0);
        DialogUtil.addUsingGBL(jPanel, this.mSumOfValuesRadio, gridBagConstraints, 0, 4, 1, 1, 23, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.set(n, insets.left, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mStdDeviationRadio, gridBagConstraints, 1, 0, 1, 1, 23, insets2);
        insets2.set(insets.top, insets.left, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mVarianceRadio, gridBagConstraints, 1, 1, 1, 1, 23, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mMinValueRadio, gridBagConstraints, 1, 2, 1, 1, 23, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mMaxValueRadio, gridBagConstraints, 1, 3, 1, 1, 23, insets2);
        insets2.set(insets.top, insets.left, n, n);
        DialogUtil.addUsingGBL(jPanel, this.mCumulativeSumRadio, gridBagConstraints, 1, 4, 1, 1, 23, insets2);
        JPanel jPanel2 = this.setupLinePanel();
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 5, 2, 1, 10, new Insets(0, 3, 5, 3));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        insets2.set(n, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mValueLabel, gridBagConstraints, 0, 6, 1, 1, 24, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.set(n, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mValueTextField, gridBagConstraints, 1, 6, 1, 1, 23, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets2.set(insets.top, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mPercentageAboveRadio, gridBagConstraints, 0, 8, 1, 1, 23, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mPercentageBelowRadio, gridBagConstraints, 0, 9, 1, 1, 23, insets2);
        insets2.set(insets.top, n, n, 0);
        DialogUtil.addUsingGBL(jPanel, this.mPercentileRadio, gridBagConstraints, 0, 10, 1, 1, 23, insets2);
        gridBagConstraints.weightx = 1.0;
        insets2.set(insets.top, insets.left, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mNumberAboveRadio, gridBagConstraints, 1, 8, 1, 1, 23, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mNumberBelowRadio, gridBagConstraints, 1, 9, 1, 1, 23, insets2);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, Color.GRAY));
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 11, 2, 1, 23, new Insets(0, 3, 5, 3));
        gridBagConstraints.fill = 0;
        JPanel jPanel4 = this.setupLowAndHighTextFieldPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 12, 2, 1, 23, null);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        insets2.set(insets.top, n, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mPercentageInsideRadio, gridBagConstraints, 0, 13, 1, 1, 23, insets2);
        gridBagConstraints.weighty = 1.0;
        insets2.set(insets.top, insets.left, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mNumberInsideRadio, gridBagConstraints, 1, 13, 1, 1, 23, insets2);
        return jPanel;
    }

    private void setTabTraversalPolicy() {
        Component[] componentArray;
        Vector<Object> vector = new Vector<Object>();
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mMeanRadio);
        spssButtonGroup.add(this.mMedianRadio);
        spssButtonGroup.add(this.mModeRadio);
        spssButtonGroup.add(this.mNoOfCasesRadio);
        spssButtonGroup.add(this.mSumOfValuesRadio);
        spssButtonGroup.add(this.mStdDeviationRadio);
        spssButtonGroup.add(this.mVarianceRadio);
        spssButtonGroup.add(this.mMinValueRadio);
        spssButtonGroup.add(this.mMaxValueRadio);
        spssButtonGroup.add(this.mCumulativeSumRadio);
        spssButtonGroup.add(this.mPercentageAboveRadio);
        spssButtonGroup.add(this.mPercentageBelowRadio);
        spssButtonGroup.add(this.mPercentileRadio);
        spssButtonGroup.add(this.mNumberAboveRadio);
        spssButtonGroup.add(this.mNumberBelowRadio);
        spssButtonGroup.add(this.mPercentageInsideRadio);
        spssButtonGroup.add(this.mNumberInsideRadio);
        vector.add(spssButtonGroup);
        vector.add(this.mValueTextField);
        vector.add(this.mLowTextField);
        vector.add(this.mHighTextField);
        for (Component component : componentArray = this.mCmdButtonPanel.getComponents()) {
            vector.add(component);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void enableTextField() {
        if (this.mLowTextField.isEnabled()) {
            this.enableContinue(!this.mLowTextField.getText().equals("") && !this.mHighTextField.getText().equals(""));
        } else if (this.mValueTextField.isEnabled()) {
            this.enableContinue(!this.mValueTextField.getText().equals(""));
        }
    }

    private JRadioButton createRadioButton(BaseDialog baseDialog, String string) {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(baseDialog, string);
        JRadioButton jRadioButton = new JRadioButton(toggleButtonAction);
        jRadioButton.addItemListener(this);
        return jRadioButton;
    }
}

