/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.read_text_data;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.data_access.text.CaseDescriptor;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.ReadTextDataWizardDlg;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.TextImportFixedWidthStep4Of6Page;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.TextImportScalePanel;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.TextImportStep5Of6Page;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.TreeSet;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.event.MouseInputAdapter;

public class TextImportTextArea
extends JTextArea {
    private int mDragCount;
    private int mLocationOfX;
    private boolean mReleaseFlag;
    private boolean mCutPointsChanged;
    private ReadTextDataWizardDlg mWizardDialog;
    private TextImportFixedWidthStep4Of6Page mFourthPage;
    protected static ArrayList<Integer> mCutPoints = new ArrayList();
    private Integer mDragLocation = -1;
    public TextImportScalePanel mScalePanel;
    protected boolean mDrawCursor;
    private int mCursorLine;
    private int mColumnWidth;
    private static final Color COLOR_SELECTED = Color.BLUE;

    public TextImportTextArea(String string) {
        super(string);
        MouseAndKeyHandler mouseAndKeyHandler = new MouseAndKeyHandler();
        this.addMouseMotionListener(mouseAndKeyHandler);
        this.addMouseListener(mouseAndKeyHandler);
        this.addKeyListener(mouseAndKeyHandler);
        this.setHighlighter(null);
        mCutPoints.clear();
        this.setAutoscrolls(false);
        this.mColumnWidth = TextImportScalePanel.mCharWidth;
    }

    public ArrayList<Integer> getCutPoints() {
        return mCutPoints;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(2.5f));
        this.paintBreakPoints(graphics2D);
    }

    public void paintBreakPoints(Graphics2D graphics2D) {
        Color color = graphics2D.getColor();
        for (Integer n : mCutPoints) {
            Integer n2 = Integer.parseInt(n.toString());
            if (n2 == this.mCursorLine) {
                Color color2 = FocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == this ? COLOR_SELECTED : Color.GRAY;
                graphics2D.setColor(color2);
            } else {
                graphics2D.setColor(color);
            }
            n2 = n == 0 ? n2 + 1 : n2;
            graphics2D.drawLine(n2, 0, n2, this.getHeight());
        }
        if (this.mDragLocation != -1) {
            graphics2D.setColor(COLOR_SELECTED);
            graphics2D.drawLine(Integer.parseInt(this.mDragLocation.toString()), 0, Integer.parseInt(this.mDragLocation.toString()), this.getHeight());
        } else if (this.mDrawCursor) {
            Color color3 = FocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == this ? COLOR_SELECTED : Color.GRAY;
            graphics2D.setColor(color3);
            graphics2D.drawLine(this.mCursorLine, 0, this.mCursorLine, 15);
        }
        graphics2D.setColor(color);
    }

    public void setScalePanel(TextImportScalePanel textImportScalePanel) {
        this.mScalePanel = textImportScalePanel;
    }

    public void setCurserLocation(int n) {
        this.mCursorLine = n * this.mColumnWidth;
    }

    public void setWizardDialog(BaseWizardDialog baseWizardDialog) {
        this.mWizardDialog = (ReadTextDataWizardDlg)baseWizardDialog;
        this.mFourthPage = (TextImportFixedWidthStep4Of6Page)this.mWizardDialog.getWizardModel().getPage("STEP_FIXED_4_OF_6_PAGE_ID");
    }

    public void setLineLocation(ArrayList<Integer> arrayList) {
        mCutPoints.clear();
        for (int i = 0; i < arrayList.size(); ++i) {
            mCutPoints.add(i, Integer.parseInt(arrayList.get(i).toString()) * this.mColumnWidth);
        }
        this.doRepaint();
    }

    public void doRepaint() {
        this.repaint();
        if (this.mScalePanel != null) {
            this.mScalePanel.repaint();
        }
    }

    public final void setCurrentVariableWidth(int n) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (Integer n2 : mCutPoints) {
            if (n2 >= n) continue;
            treeSet.add(n2);
        }
        Object object = "0";
        if (treeSet.size() >= 1) {
            Integer n2;
            n2 = (n - (Integer)treeSet.last()) / this.mColumnWidth;
            object = n2.toString();
        }
        this.mFourthPage.mCurrentVariableWidthLabel.setText((String)object);
    }

    public int getLastLocationFromCutPoints() {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (Integer n : mCutPoints) {
            treeSet.add(n);
        }
        if (treeSet.size() > 0) {
            return (Integer)treeSet.last();
        }
        return -1;
    }

    public int getCutPointFromColumn(int n) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (Integer n2 : mCutPoints) {
            treeSet.add(n2);
        }
        if (treeSet.size() > 0) {
            Integer[] integerArray = treeSet.toArray(new Integer[0]);
            return integerArray[n];
        }
        return -1;
    }

    public void setColumnNumberTextField(int n) {
        String string = n > 0 ? Integer.toString(n / this.mColumnWidth) : "0";
        this.mFourthPage.mColumnNumberTextField.setText(string);
        String string2 = this.mFourthPage.doesCutPointsContainColumnNum(Integer.parseInt(string)) ? this.mWizardDialog.getResString("IDS_TEXT_WIZ_ACCESSIBLE_COLUMN_NAME") + " " + string + "," + this.mWizardDialog.getResString("IDS_TEXT_WIZ_ACCESSIBLE_BREAK_LINE_SELECTED") : this.mWizardDialog.getResString("IDS_TEXT_WIZ_ACCESSIBLE_COLUMN_NAME") + " " + string;
        if (this.accessibleContext != null) {
            this.accessibleContext.setAccessibleName(string2);
        }
    }

    public String getColumnNumberTextField() {
        String string = this.mFourthPage.mColumnNumberTextField.getText();
        return string == null ? "" : string;
    }

    public boolean getCutPointsChanged() {
        return this.mCutPointsChanged;
    }

    public void doDrawCursor(boolean bl) {
        this.mDrawCursor = bl;
    }

    public int getNumCutPoints() {
        if (mCutPoints != null) {
            return mCutPoints.size();
        }
        return 0;
    }

    public Integer getCutPoint(int n) {
        if (mCutPoints != null) {
            return mCutPoints.get(n);
        }
        return -1;
    }

    public boolean containsCutPoint(Integer n) {
        return mCutPoints != null && mCutPoints.contains(n);
    }

    public boolean removeCutPoints(Integer n) {
        return mCutPoints == null || mCutPoints.remove(n);
    }

    public boolean addCutPoint(int n) {
        boolean bl = true;
        if (this.containsCutPoint(n)) {
            this.doDrawCursor(true);
            this.setCurserLocation(n);
        } else {
            bl = mCutPoints.add(n);
        }
        return bl;
    }

    public boolean isDrawCursor() {
        return this.mDrawCursor;
    }

    public int getCursorLine() {
        return this.mCursorLine;
    }

    public void setCursorLine(int n) {
        this.mCursorLine = n;
    }

    public boolean processKeyEvent(int n) {
        boolean bl = false;
        if (n == 39 || n == 37 && this.mCursorLine > 0) {
            if (n == 39) {
                if (this.mCursorLine / this.mColumnWidth <= this.mScalePanel.getMaxCharsPerLine() - 2) {
                    this.mCursorLine += this.mColumnWidth;
                    bl = true;
                }
            } else {
                this.mCursorLine -= this.mColumnWidth;
                bl = true;
            }
            if (bl) {
                this.doDrawCursor(true);
                this.setColumnNumberTextField(this.mCursorLine);
                this.setCurrentVariableWidth(this.mCursorLine);
                this.doRepaint();
            }
        }
        return bl;
    }

    @Override
    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 500) {
            this.processMouseClicked(mouseEvent);
        } else if (mouseEvent.getID() == 506) {
            this.processMouseDragged(mouseEvent);
        } else if (mouseEvent.getID() == 502) {
            this.processMouseReleased(mouseEvent);
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    public void processMouseReleased(MouseEvent mouseEvent) {
        this.mDragLocation = -1;
        this.mCutPointsChanged = true;
        this.mDragCount = 0;
        if (this.mReleaseFlag) {
            LinkedHashMap linkedHashMap = this.mWizardDialog.getTextDacData().getCaseMap();
            CaseDescriptor caseDescriptor = this.mWizardDialog.getTextDacData().getCaseDescriptor();
            if (linkedHashMap.size() < caseDescriptor.getCaseStartLineNumber()) {
                return;
            }
            this.mLocationOfX = mouseEvent.getX();
            if (this.mLocationOfX < this.getWidth() && mouseEvent.getY() > 0) {
                int n = this.getCharLocationNearestToLocation(this.mLocationOfX);
                int n2 = this.mWizardDialog.getTextDacData().getCaseDescriptor().getNumLinesRepresentCase();
                if (n / this.mColumnWidth > (this.mScalePanel.getMaxCharsPerLine() - 1) * n2) {
                    this.mLocationOfX = (this.mScalePanel.getMaxCharsPerLine() - 1) * n2 * this.mColumnWidth;
                }
                this.checkLocation();
            }
            this.mReleaseFlag = false;
            this.doRepaint();
            this.setStatechangedFlag();
            if (mCutPoints.size() == 0) {
                this.setColumnNumberTextField(0);
                this.setCurrentVariableWidth(0);
            }
        }
    }

    public void processMouseDragged(MouseEvent mouseEvent) {
        boolean bl = true;
        TextImportStep5Of6Page textImportStep5Of6Page = (TextImportStep5Of6Page)this.mWizardDialog.getWizardModel().getPage("STEP_5_OF_6_PAGE_ID");
        if (textImportStep5Of6Page.isStepFiveVisited()) {
            int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_REMOVE_VAR_NAMES_DATA_FORMAT_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
            boolean bl2 = bl = n == 1;
        }
        if (bl) {
            textImportStep5Of6Page.setStepFiveVisited(false);
            LinkedHashMap linkedHashMap = this.mWizardDialog.getTextDacData().getCaseMap();
            CaseDescriptor caseDescriptor = this.mWizardDialog.getTextDacData().getCaseDescriptor();
            if (linkedHashMap.size() < caseDescriptor.getCaseStartLineNumber()) {
                return;
            }
            this.mLocationOfX = mouseEvent.getX();
            int n = this.mLocationOfX % this.mColumnWidth;
            int n2 = this.getLocationSet();
            if (n < n2) {
                if (n != 0) {
                    this.mLocationOfX -= n;
                }
            } else {
                this.mLocationOfX += this.mColumnWidth - n;
            }
            int n3 = this.getCharLocationNearestToLocation(this.mLocationOfX);
            int n4 = this.mWizardDialog.getTextDacData().getCaseDescriptor().getNumLinesRepresentCase();
            if (n3 / this.mColumnWidth > (this.mScalePanel.getMaxCharsPerLine() - 1) * n4) {
                this.mLocationOfX = (this.mScalePanel.getMaxCharsPerLine() - 1) * n4 * this.mColumnWidth;
            }
            this.mCutPointsChanged = true;
            ++this.mDragCount;
            this.mDragLocation = this.mLocationOfX;
            this.mReleaseFlag = true;
            if (this.mDragCount == 1 && mCutPoints.contains(this.mLocationOfX)) {
                this.removeCutPoints(this.mLocationOfX);
            }
            this.doRepaint();
            this.setColumnNumberTextField(this.mLocationOfX);
            this.setCurrentVariableWidth(this.mLocationOfX);
            this.setStatechangedFlag();
        }
    }

    public void processMouseClicked(MouseEvent mouseEvent) {
        boolean bl = true;
        TextImportStep5Of6Page textImportStep5Of6Page = (TextImportStep5Of6Page)this.mWizardDialog.getWizardModel().getPage("STEP_5_OF_6_PAGE_ID");
        if (textImportStep5Of6Page.isStepFiveVisited()) {
            int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_REMOVE_VAR_NAMES_DATA_FORMAT_WARNING"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
            boolean bl2 = bl = n == 1;
        }
        if (bl) {
            LinkedHashMap linkedHashMap = this.mWizardDialog.getTextDacData().getCaseMap();
            CaseDescriptor caseDescriptor = this.mWizardDialog.getTextDacData().getCaseDescriptor();
            if (linkedHashMap.size() < caseDescriptor.getCaseStartLineNumber()) {
                return;
            }
            int n = this.getCharLocationNearestToLocation(mouseEvent.getX());
            int n2 = this.mWizardDialog.getTextDacData().getCaseDescriptor().getNumLinesRepresentCase();
            if (n / this.mColumnWidth > (this.mScalePanel.getMaxCharsPerLine() - 1) * n2) {
                mouseEvent.consume();
            } else {
                textImportStep5Of6Page.setStepFiveVisited(false);
                this.mLocationOfX = mouseEvent.getX();
                this.checkLocation();
                this.mCutPointsChanged = true;
                this.doRepaint();
                this.setStatechangedFlag();
            }
        }
    }

    public boolean checkLocation() {
        this.mLocationOfX = this.getCharLocationNearestToLocation(this.mLocationOfX);
        if (this.mLocationOfX >= 0 && this.mLocationOfX % this.mColumnWidth == 0) {
            this.addCutPoint(this.mLocationOfX);
        }
        this.mCursorLine = this.mLocationOfX;
        this.setColumnNumberTextField(this.mCursorLine);
        this.setCurrentVariableWidth(this.mCursorLine);
        return true;
    }

    private int getCharLocationNearestToLocation(int n) {
        int n2 = n;
        int n3 = n % this.mColumnWidth;
        int n4 = this.getLocationSet();
        n2 = n3 >= n4 ? (n2 += this.mColumnWidth - n3) : (n2 -= n3);
        return n2;
    }

    private int getLocationSet() {
        return TextImportScalePanel.mCharWidth / 2 + TextImportScalePanel.mCharWidth % 2;
    }

    void setStatechangedFlag() {
        this.mWizardDialog.setStateChangedForFinishButton(false);
        this.mWizardDialog.enableFinish(this.mWizardDialog.hasStateChangedForFinishButton());
        this.mWizardDialog.setStateChanged(true);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleTextImportTextArea();
        }
        return this.accessibleContext;
    }

    protected class AccessibleTextImportTextArea
    extends JComponent.AccessibleJComponent {
        protected AccessibleTextImportTextArea() {
            super(TextImportTextArea.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.MULTI_LINE);
            return accessibleStateSet;
        }
    }

    class MouseAndKeyHandler
    extends MouseInputAdapter
    implements KeyListener {
        public MouseAndKeyHandler() {
            TextImportTextArea.this.doRepaint();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            TextImportTextArea.this.processMouseDragged(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TextImportTextArea.this.processMouseClicked(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            TextImportTextArea.this.processMouseReleased(mouseEvent);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!this.processKeyEvent(keyEvent.getKeyCode())) {
                keyEvent.consume();
            }
        }

        public boolean processKeyEvent(int n) {
            boolean bl = false;
            if (n == 39 || n == 37) {
                if (n == 39) {
                    if (TextImportTextArea.this.mCursorLine / TextImportTextArea.this.mColumnWidth <= TextImportTextArea.this.mScalePanel.getMaxCharsPerLine() - 2) {
                        TextImportTextArea.this.mCursorLine += TextImportTextArea.this.mColumnWidth;
                        bl = true;
                    }
                } else {
                    TextImportTextArea.this.mCursorLine -= TextImportTextArea.this.mColumnWidth;
                    bl = true;
                }
                if (bl) {
                    TextImportTextArea.this.doDrawCursor(true);
                    TextImportTextArea.this.setColumnNumberTextField(TextImportTextArea.this.mCursorLine);
                    TextImportTextArea.this.setCurrentVariableWidth(TextImportTextArea.this.mCursorLine);
                    TextImportTextArea.this.doRepaint();
                }
            }
            return bl;
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

