/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.read_text_data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.data.data_access.text.TextDac;
import com.spss.java_client.core.documents.data.data_access.text.VariableDescriptor;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.ReadTextDataWizardDlg;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URL;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class TextImportStep6Of6Page
extends AbstractWizardPage
implements ItemListener,
ActionListener {
    static final String DATA_PREVIEW_PANEL_BORDER = "IDS_RTD_DATA_PREVIEW";
    static final String STEP_SIX_TITLE = "IDS_RTD_STEP_SIX";
    static final String DEFINED_FORMAT_LABEL = "IDS_RTD_DEFINED_THE_FORMAT";
    static final String SAVE_FILE_PANEL_TITLE = "IDS_RTD_SAVE_FILE_QUES";
    static final String PASTE_SYNTAX_PANEL_TITLE = "IDS_RTD_PASTE_SYNTAX_QUES";
    static final String YES_RADIO = "IDS_RTD_YES_RADIO";
    static final String NO_RADIO = "IDS_RTD_NO_RADIO";
    static final String PASTE_YES_RADIO = "IDS_RTD_PASTE_YES_RADIO";
    static final String PASTE_NO_RADIO = "IDS_RTD_PASTE_NO_RADIO";
    static final String SAVE_AS_BUTTON = "IDS_RTD_SAVE_AS";
    static final String CACHE_DATA = "IDS_RTD_CACHE_DATA_CHECK";
    static final String PRESS_FINISH_LABEL = "IDS_RTD_PRESS_FINISH";
    static final String PRESS_DONE_LABEL = "IDS_RTD_PRESS_DONE";
    static final String STEP_6_OF_6_PAGE_ID = "STEP_6_OF_6_PAGE_ID";
    private JRadioButton mYesRadio;
    private JRadioButton mNoRadio;
    private JRadioButton mPasteSyntaxRadio;
    private JRadioButton mDoNotPasteSyntaxRadio;
    private SpssButtonGroup mYesNoRadioButtonGrp;
    private SpssButtonGroup mPasteSyntaxRadioButtonGrp;
    private JCheckBox mCacheDataCheck;
    private FileTextField mFileTextField;
    private JButton mBrowseButton;
    private JTable mDataPreviewTable;
    private JScrollPane mTableScroll;
    private DefaultTableModel mTableModel;
    private int[] mLastSelectedCols;

    TextImportStep6Of6Page(BaseWizardDialog baseWizardDialog) {
        super(STEP_6_OF_6_PAGE_ID, baseWizardDialog.getResString(STEP_SIX_TITLE), baseWizardDialog, true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        Object object = itemEvent.getItem();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (object.equals(this.mYesRadio)) {
            this.mFileTextField.setEnabled(bl);
            this.mFileTextField.setOpaque(bl);
            this.mBrowseButton.setEnabled(bl);
        } else if (object.equals(this.mNoRadio)) {
            this.mFileTextField.setEnabled(!bl);
            this.mFileTextField.setOpaque(!bl);
            this.mFileTextField.setText("");
            this.mBrowseButton.setEnabled(!bl);
        } else if (object.equals(this.mPasteSyntaxRadio) || object.equals(this.mDoNotPasteSyntaxRadio)) {
            TextDac.TextDacData textDacData = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData();
            if (this.mPasteSyntaxRadio.isSelected()) {
                textDacData.setPasteButtonClick(this.mPasteSyntaxRadio.isSelected());
            } else {
                textDacData.setPasteButtonClick(false);
            }
        }
        if (object.equals(this.mCacheDataCheck)) {
            ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getCaseDescriptor().setCacheData(bl);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        if (actionEvent.getSource().equals(this.mBrowseButton) && (string = this.saveTpfFile()) != null) {
            this.mFileTextField.setText(string);
        }
    }

    public boolean isPasteSelected() {
        return this.mPasteSyntaxRadio != null ? this.mPasteSyntaxRadio.isSelected() : false;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_text_wizard_step6";
    }

    @Override
    public boolean validate() {
        if (this.mYesRadio.isSelected()) {
            if (this.mFileTextField.getText().equals("")) {
                return false;
            }
            ((ReadTextDataWizardDlg)this.mWizardDialog).serialize(this.mFileTextField.getText());
        }
        return true;
    }

    @Override
    public void init() {
        this.initVars();
        this.setDefaults();
        this.addComponentsToPage();
    }

    @Override
    public String getNextPage() {
        return null;
    }

    @Override
    public boolean isLastPage() {
        return true;
    }

    @Override
    public boolean hasNextPage() {
        return false;
    }

    @Override
    protected void aboutToShowPanel() {
        TextDac.TextDacData textDacData = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData();
        if (VersionInfo.allowSyntax()) {
            this.mPasteSyntaxRadio.setSelected(textDacData.isPasteButtonClick());
        }
        this.mCacheDataCheck.setSelected(((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getCaseDescriptor().isDataCached());
        this.mCacheDataCheck.requestFocus();
        this.updateTable();
        this.mCacheDataCheck.addItemListener(this);
        ((ReadTextDataWizardDlg)this.mWizardDialog).setStateChangedForFinishButton(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TextImportStep6Of6Page.this.mDataPreviewTable.getModel().getRowCount() != 0) {
                    TextImportStep6Of6Page.this.addColumnSelectionInterval(1, 1);
                    TextImportStep6Of6Page.this.setAnchorCell(1, 0);
                    TextImportStep6Of6Page.this.setLeadCell(1, 0);
                }
            }
        });
        this.setFocusTraversalPolicy();
    }

    private void setAnchorCell(int n, int n2) {
        this.mDataPreviewTable.getColumnModel().getSelectionModel().setAnchorSelectionIndex(n);
        this.mDataPreviewTable.getSelectionModel().setAnchorSelectionIndex(n2);
    }

    private void setLeadCell(int n, int n2) {
        this.mDataPreviewTable.getColumnModel().getSelectionModel().setLeadSelectionIndex(n);
        this.mDataPreviewTable.getSelectionModel().setLeadSelectionIndex(n2);
    }

    protected String saveTpfFile() {
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(this.mWizardDialog.getResString("IDS_RTD_TPF_FILTER"), this.mWizardDialog.getResString("IDS_RTD_TPF_EXT")));
        remoteFileChooser.setAcceptAllFileFilterUsed(false);
        remoteFileChooser.setDialogTitle(this.mWizardDialog.getResString(SAVE_AS_BUTTON));
        int n = remoteFileChooser.showSaveDialog((Component)((Object)this.mWizardDialog));
        if (n == 0) {
            FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            File file = remoteFileChooser.getSelectedFile();
            remoteFileChooser.setCurrentDirectory(file);
            String string = remoteFileChooser.getSelectedFilePath();
            if (!string.endsWith("tpf")) {
                string = string + ".tpf";
            }
            return string;
        }
        return null;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mYesNoRadioButtonGrp);
        vector.add(this.mBrowseButton);
        if (VersionInfo.allowSyntax()) {
            vector.add(this.mPasteSyntaxRadioButtonGrp);
        }
        vector.add(this.mCacheDataCheck);
        vector.add(this.mDataPreviewTable);
        Vector<Object> vector2 = ((ReadTextDataWizardDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mWizardDialog.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector2, false));
    }

    private void updateTable() {
        Vector vector = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getVariableDescriptors(false);
        if (!vector.isEmpty()) {
            int n;
            int n2;
            VariableDescriptor variableDescriptor = (VariableDescriptor)vector.get(0);
            Vector vector2 = variableDescriptor.getVarData();
            this.mTableModel = new DefaultTableModel(){

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            for (n2 = 0; n2 < vector.size(); ++n2) {
                variableDescriptor = (VariableDescriptor)vector.get(n2);
                vector2 = variableDescriptor.getVarData();
                treeSet.add(vector2.size());
            }
            this.mTableModel.setRowCount((Integer)treeSet.last());
            for (n2 = 0; n2 < 1; ++n2) {
                n = 0;
                this.mTableModel.addColumn("     ");
                for (int i = 0; i < this.mTableModel.getRowCount(); ++i) {
                    this.mTableModel.setValueAt(++n, i, n2);
                }
            }
            for (n2 = 0; n2 < vector.size(); ++n2) {
                variableDescriptor = (VariableDescriptor)vector.get(n2);
                this.mTableModel.addColumn(variableDescriptor.getModifiedVarName());
                vector2 = variableDescriptor.getVarData();
                for (n = 0; n < vector2.size(); ++n) {
                    this.mTableModel.setValueAt(vector2.get(n), n, n2 + 1);
                }
            }
            this.mDataPreviewTable.setModel(this.mTableModel);
            this.mDataPreviewTable.getColumnModel().getColumn(0).setMinWidth(0);
            this.mDataPreviewTable.getColumnModel().getColumn(0).setMaxWidth(1000);
            this.mDataPreviewTable.getColumnModel().getColumn(0).setPreferredWidth(0);
            this.mDataPreviewTable.getTableHeader().resizeAndRepaint();
            this.mDataPreviewTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Component component = null;
                    component = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    component.setBackground(jTable.getTableHeader().getBackground());
                    this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                    return component;
                }
            });
        }
    }

    private void initVars() {
        this.mYesRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, YES_RADIO));
        this.mYesRadio.addItemListener(this);
        this.mNoRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, NO_RADIO));
        this.mNoRadio.addItemListener(this);
        this.mYesNoRadioButtonGrp = new SpssButtonGroup();
        this.mYesNoRadioButtonGrp.add(this.mYesRadio);
        this.mYesNoRadioButtonGrp.add(this.mNoRadio);
        this.mFileTextField = new FileTextField();
        this.mFileTextField.setColumns(12);
        this.mFileTextField.setEditable(false);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, SAVE_AS_BUTTON);
        this.mBrowseButton = new JButton(toggleButtonAction);
        this.mBrowseButton.addActionListener(this);
        if (VersionInfo.allowSyntax()) {
            this.mPasteSyntaxRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, PASTE_YES_RADIO));
            this.mPasteSyntaxRadio.addItemListener(this);
            this.mDoNotPasteSyntaxRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, PASTE_NO_RADIO));
            this.mDoNotPasteSyntaxRadio.addItemListener(this);
            this.mPasteSyntaxRadioButtonGrp = new SpssButtonGroup();
            this.mPasteSyntaxRadioButtonGrp.add(this.mPasteSyntaxRadio);
            this.mPasteSyntaxRadioButtonGrp.add(this.mDoNotPasteSyntaxRadio);
        }
        this.mCacheDataCheck = new JCheckBox(new ToggleButtonAction(this.mWizardDialog, CACHE_DATA));
        this.mDataPreviewTable = new JTable();
        this.mDataPreviewTable.setMinimumSize(new Dimension(400, 130));
        this.mDataPreviewTable.setColumnSelectionAllowed(true);
        this.mDataPreviewTable.setRowSelectionAllowed(false);
        this.mDataPreviewTable.setAutoResizeMode(0);
        this.mDataPreviewTable.getTableHeader().setReorderingAllowed(false);
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            this.mDataPreviewTable.setGridColor(this.mDataPreviewTable.getGridColor().darker());
        }
        this.mTableScroll = new JScrollPane(this.mDataPreviewTable);
        this.mTableScroll.setPreferredSize(this.mDataPreviewTable.getMinimumSize());
        if (this.mDataPreviewTable.getModel().getColumnCount() >= 2) {
            this.addColumnSelectionInterval(1, 1);
        }
    }

    public void addColumnSelectionInterval(int n, int n2) {
        this.mDataPreviewTable.addColumnSelectionInterval(n, n2);
        this.mLastSelectedCols = this.mDataPreviewTable.getSelectedColumns();
    }

    private void setDefaults() {
        this.mFileTextField.setEnabled(false);
        this.mFileTextField.setOpaque(false);
        this.mBrowseButton.setEnabled(false);
        this.mNoRadio.setSelected(true);
        if (VersionInfo.allowSyntax()) {
            this.mDoNotPasteSyntaxRadio.removeItemListener(this);
            this.mDoNotPasteSyntaxRadio.setSelected(true);
            this.mDoNotPasteSyntaxRadio.addItemListener(this);
        }
        this.mCacheDataCheck.setSelected(true);
    }

    private void addComponentsToPage() {
        URL uRL = this.mWizardDialog.getResImageURL("IDS_RTD_STEP_SIX_IMAGE");
        JLabel jLabel = new JLabel(" ");
        jLabel.setIcon(new ImageIcon(uRL));
        JLabel jLabel2 = new JLabel(this.mWizardDialog.getResString(DEFINED_FORMAT_LABEL));
        String string = PRESS_FINISH_LABEL;
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            string = PRESS_DONE_LABEL;
        }
        JLabel jLabel3 = new JLabel(this.mWizardDialog.getResString(string));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mWizardPage, jLabel, gridBagConstraints, 0, 0, 1, 4, n, null);
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(0, 5, 0, 0);
        DialogUtil.addUsingGBL(this.mWizardPage, jLabel2, gridBagConstraints, 1, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(DialogUtil.getComponentGroupGap(), 5, 0, 0);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mWizardPage, this.setupSaveFilePanel(), gridBagConstraints, 1, 1, 2, 1, n, insets);
        int n2 = 1;
        if (VersionInfo.allowSyntax()) {
            DialogUtil.addUsingGBL(this.mWizardPage, this.setupPasteSyntaxPanel(), gridBagConstraints, n2, 2, 1, 1, n, insets);
            ++n2;
        }
        insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mWizardPage, this.mCacheDataCheck, gridBagConstraints, n2, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mWizardPage, jLabel3, gridBagConstraints, 1, 3, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(this.mWizardPage, this.setupDataPreviewPanel(), gridBagConstraints, 0, 4, 3, 1, n, insets);
    }

    private JPanel setupSaveFilePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.mWizardDialog.getResString(SAVE_FILE_PANEL_TITLE)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mYesRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mNoRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets2 = new Insets(insets.top + 5, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileTextField), gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(insets.top + 3, DialogUtil.getGroupBoxInnerMargin(), 0, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupPasteSyntaxPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        if (VersionInfo.allowSyntax()) {
            jPanel.setBorder(new TitledBorder(this.mWizardDialog.getResString(PASTE_SYNTAX_PANEL_TITLE)));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            int n = 23;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            Insets insets = DialogUtil.getStandardControlInsets();
            DialogUtil.addUsingGBL(jPanel, this.mPasteSyntaxRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
            gridBagConstraints.weighty = 1.0;
            DialogUtil.addUsingGBL(jPanel, this.mDoNotPasteSyntaxRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        }
        return jPanel;
    }

    private JPanel setupDataPreviewPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.mWizardDialog.getResString(DATA_PREVIEW_PANEL_BORDER)));
        jPanel.setPreferredSize(new Dimension(500, 150));
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n, n, n, n);
        int n2 = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTableScroll, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        return jPanel;
    }
}

