/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.read_text_data;

import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.data_access.DataAccessContainer;
import com.spss.java_client.core.documents.data.data_access.text.CaseDescriptor;
import com.spss.java_client.core.documents.data.data_access.text.TextDac;
import com.spss.java_client.core.documents.data.data_access.text.VariableDescriptor;
import com.spss.java_client.ui.controls.ComboBoxItemWithDisable;
import com.spss.java_client.ui.controls.ComboBoxRendererWithDisable;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.ReadTextDataWizardDlg;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.TextImportDelimitedStep4Of6Page;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.TextImportFixedWidthStep4Of6Page;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ComboboxAction;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.NumberSpinner;
import com.spss.uitools.controls.SyncableComboBox;
import com.spss.uitools.util.TableUtilities;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class TextImportStep5Of6Page
extends AbstractWizardPage
implements ItemListener,
FocusListener,
ListSelectionListener,
DocumentListener {
    private static final int STRING_INDEX = 3;
    private static final int DATE_INDEX = 4;
    public static final int DEFAULT_TABLE_WIDTH = 400;
    static final Integer MINLIMIT = 1;
    static final Integer MAXLIMIT = Short.MAX_VALUE;
    static final Integer INITVAL = 1;
    static final String TEXT_FILE_PANEL_BORDER = "IDS_RTD_DATA_PREVIEW";
    static final String STEP_FIVE_TITLE = "IDS_RTD_STEP_FIVE";
    static final String SPECIFICATION_PANEL_TITLE = "IDS_RTD_SPEC_FOR_SELECTED_VARS";
    static final String ORIGINAL_NAME_LABEL = "IDS_RTD_ORIGINAL_NAME";
    static final String VARIABLE_LABEL = "IDS_RTD_VAR_NAME";
    static final String DATA_FORMAT_LABEL = "IDS_RTD_DATA_FORMAT";
    static final String CHARACTERS_LABEL = "IDS_RTD_CHARACTERS";
    static final String STEP_5_OF_6_PAGE_ID = "STEP_5_OF_6_PAGE_ID";
    private JLabel mOriginalLabel;
    private JLabel mOriginalNameLabel;
    private SyncableComboBox mDataFormatCombo;
    private ArrayList<ComboBoxItemWithDisable> mTypeItems;
    private JList mDateNTimeList;
    private VarNameTextField mVariableNameTextField;
    private JPanel mCardLayoutPanel;
    private TextDacNumberSpinner mStringSpinner;
    private IntTextField mCharSpinnerText;
    private JTable mDataPreviewTable;
    private JScrollPane mTableScroll;
    Vector<VariableDescriptor> mVarDesc;
    private HashMap<String, Integer> mDateTypes;
    private TableHeaderMouseListener mMouseListener;
    private boolean mStepFiveVisited = false;
    private boolean mFirstVisit = true;
    private Vector<Object> normalComponentOrder;
    private Vector<Object> stringComponentOrder;
    private Vector<Object> dateComponentOrder;
    ComboBoxItemWithDisable mAutoComboItem;
    ComboBoxItemWithDisable mDoNotImportComboItem;
    ComboBoxItemWithDisable mNumericComboItem;
    ComboBoxItemWithDisable mStringComboItem;
    ComboBoxItemWithDisable mDateTimeComboItem;
    ComboBoxItemWithDisable mDollarComboItem;
    ComboBoxItemWithDisable mCommaComboItem;
    ComboBoxItemWithDisable mDotComboItem;
    ComboBoxItemWithDisable mBlankComboItem;
    boolean mIgnoreLengthUpdate = false;
    public static final String DATE_TIME_EMTPY_CELL = "              ";
    public int mAnchorIndex = 1;
    private int[] mLastSelectedCols;
    Boolean mBlankComboItemAdded;
    ListSelectionListener mColSelListener;
    ListSelectionListener mRowSelListener;
    JLabel mPercentOfValuesThatDetermineDataTypeLabel;
    protected FloatTextField mPercentOfValuesDetermineDataTypeTextField;
    int mOldColCount = -1;
    private String[] mDateTimeResourceIDList;

    TextImportStep5Of6Page(BaseWizardDialog baseWizardDialog) {
        super(STEP_5_OF_6_PAGE_ID, baseWizardDialog.getResString(STEP_FIVE_TITLE), baseWizardDialog, true);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mStringSpinner.getEditor())) {
            ((JTextField)this.mStringSpinner.getEditor()).selectAll();
            this.mStringSpinner.getEditor().requestFocus();
        } else if (focusEvent.getSource().equals(this.mVariableNameTextField)) {
            this.mVariableNameTextField.selectAll();
            this.mVariableNameTextField.requestFocus();
        }
    }

    private void updateTableHeader(int n) {
        if (n != 0) {
            this.mDataPreviewTable.getColumnModel().getColumn(n).setHeaderValue(this.mVarDesc.get(n - 1).getModifiedVarName());
            this.mDataPreviewTable.getTableHeader().resizeAndRepaint();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.saveVarNameToSelectedVarDescriptors();
    }

    private void saveVarNameToSelectedVarDescriptors() {
        if (this.mLastSelectedCols != null) {
            for (int n : this.mLastSelectedCols) {
                VariableDescriptor variableDescriptor = this.mVarDesc.get(n - 1);
                if (this.isVariableNameValid()) {
                    variableDescriptor.setModifiedVarName(this.mVariableNameTextField.getText());
                }
                this.updateTableHeader(n);
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.isVariableNameValid();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.isVariableNameValid();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        ArrayList<VariableDescriptor> arrayList = this.getSelectedVariableDescriptors();
        String string = (String)this.mDateNTimeList.getSelectedValue();
        for (VariableDescriptor variableDescriptor : arrayList) {
            int n = this.getDateType(string);
            if (n == -1) continue;
            variableDescriptor.setDateVarType(n);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (!this.mDataFormatCombo.isInSelectItemAction()) {
            this.setLayoutBasedOnSelection();
            this.setFocusTraversalOrder();
            ArrayList<VariableDescriptor> arrayList = this.getSelectedVariableDescriptors();
            ComboBoxItemWithDisable comboBoxItemWithDisable = (ComboBoxItemWithDisable)this.mDataFormatCombo.getSelectedItem();
            for (VariableDescriptor variableDescriptor : arrayList) {
                if (comboBoxItemWithDisable == this.mDoNotImportComboItem) {
                    variableDescriptor.setVarType(VariableDescriptor.VarType.eNone);
                    continue;
                }
                if (comboBoxItemWithDisable == this.mAutoComboItem) {
                    variableDescriptor.setVarType(VariableDescriptor.VarType.eAuto);
                    continue;
                }
                if (comboBoxItemWithDisable == this.mNumericComboItem) {
                    variableDescriptor.setVarType(VariableDescriptor.VarType.eNumeric);
                    continue;
                }
                if (comboBoxItemWithDisable == this.mStringComboItem) {
                    variableDescriptor.setVarType(VariableDescriptor.VarType.eString);
                    continue;
                }
                if (comboBoxItemWithDisable == this.mDateTimeComboItem) {
                    variableDescriptor.setVarType(VariableDescriptor.VarType.eDateTime);
                    continue;
                }
                if (comboBoxItemWithDisable == this.mDollarComboItem) {
                    variableDescriptor.setVarType(VariableDescriptor.VarType.eDollar);
                    continue;
                }
                if (comboBoxItemWithDisable == this.mCommaComboItem) {
                    variableDescriptor.setVarType(VariableDescriptor.VarType.eComma);
                    continue;
                }
                if (comboBoxItemWithDisable != this.mDotComboItem) continue;
                variableDescriptor.setVarType(VariableDescriptor.VarType.eDot);
            }
            this.updateDataFormatFieldsBasedOnSelection();
            this.mDataPreviewTable.repaint();
        }
    }

    private void setLayoutBasedOnSelection() {
        CardLayout cardLayout = (CardLayout)this.mCardLayoutPanel.getLayout();
        CaseDescriptor caseDescriptor = this.getTextDacData().getCaseDescriptor();
        if (this.mDataFormatCombo.getSelectedItem() == this.mDateTimeComboItem) {
            cardLayout.show(this.mCardLayoutPanel, "Date/Time");
        } else if (this.mDataFormatCombo.getSelectedItem() == this.mStringComboItem && !caseDescriptor.isFixedWidth()) {
            this.showStringLayout(cardLayout);
        } else {
            cardLayout.show(this.mCardLayoutPanel, "");
        }
    }

    private void showStringLayout(CardLayout cardLayout) {
        cardLayout.show(this.mCardLayoutPanel, "String");
    }

    private void updateSpinnerNoTableUpdate(int n) {
        this.mIgnoreLengthUpdate = true;
        if (n == -1) {
            ((IntTextField)this.mStringSpinner.getEditor()).setText("");
        } else {
            this.mStringSpinner.setValue(n);
        }
        this.mIgnoreLengthUpdate = false;
    }

    private ArrayList<VariableDescriptor> getSelectedVariableDescriptors() {
        int[] nArray;
        ArrayList<VariableDescriptor> arrayList = new ArrayList<VariableDescriptor>();
        for (int n : nArray = this.mDataPreviewTable.getSelectedColumns()) {
            VariableDescriptor variableDescriptor = this.mVarDesc.get(n - 1);
            if (variableDescriptor == null) continue;
            arrayList.add(variableDescriptor);
        }
        return arrayList;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_text_wizard_step5";
    }

    @Override
    public boolean validate() {
        this.getTextDacData().setVariableDescriptors(this.mVarDesc);
        Double d = this.getPercentOfValuesDetermineTypeDoubleValue();
        if (d != null) {
            this.getTextDacData().getCaseDescriptor().setPercentageOfValuesToDetermineType(d.doubleValue());
        }
        return d != null;
    }

    @Override
    public void init() {
        this.initVars();
        this.addListeners();
        this.addComponentsToPage();
        this.mVariableNameTextField.requestFocusInWindow();
    }

    private void createDateTimeMap() {
        this.mDateTimeResourceIDList = new String[]{"IDS_DATE11", "IDS_DATE9", "IDS_ADATE10", "IDS_ADATE8", "IDS_EDATE10", "IDS_EDATE8", "IDS_JDATE5", "IDS_JDATE7", "IDS_SDATE8", "IDS_SDATE10", "IDS_QYR6", "IDS_QYR8", "IDS_MOYR6", "IDS_MOYR8", "IDS_WKYR8", "IDS_WKYR10", "IDS_DAY_OF_WEEK", "IDS_MONTH_OF_YEAR", "IDS_MTIME5", "IDS_MTIME8_2", "IDS_TIME5", "IDS_TIME8", "IDS_TIME11_2", "IDS_DTIME9", "IDS_DTIME12", "IDS_DATETIME17", "IDS_DATETIME20", "IDS_DATETIME23_2", "IDS_YMDHMS16", "IDS_YMDHMS19", "IDS_YMDHMS22_2"};
        this.mDateTypes = new HashMap();
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_DATE11"), 1000);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_DATE9"), 1001);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_ADATE10"), 1002);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_ADATE8"), 1003);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_EDATE10"), 1004);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_EDATE8"), 1005);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_JDATE5"), 1006);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_JDATE7"), 1007);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_SDATE8"), 1008);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_SDATE10"), 1009);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_QYR6"), 1010);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_QYR8"), 1011);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_MOYR6"), 1012);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_MOYR8"), 1013);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_WKYR8"), 1014);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_WKYR10"), 1015);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_DAY_OF_WEEK"), 1016);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_MONTH_OF_YEAR"), 1017);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_TIME5"), 1018);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_MTIME5"), 1116);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_MTIME8_2"), 1031);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_TIME8"), 1019);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_TIME11_2"), 1020);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_DTIME9"), 1021);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_DTIME12"), 1101);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_DATETIME17"), 1023);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_DATETIME20"), 1100);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_DATETIME23_2"), 1024);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_YMDHMS16"), 1113);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_YMDHMS19"), 1028);
        this.mDateTypes.put(this.mWizardDialog.getResString("IDS_YMDHMS22_2"), 1029);
    }

    private void setDefaultTableColWidths() {
        int n;
        int n2 = 0;
        for (n = 1; n < this.mDataPreviewTable.getColumnCount(); ++n) {
            TableColumn tableColumn = this.mDataPreviewTable.getColumnModel().getColumn(n);
            n2 += tableColumn.getWidth();
        }
        int n3 = n = this.mDataPreviewTable.getWidth() != 0 ? this.mDataPreviewTable.getWidth() : 400;
        if (n2 < n) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int[] nArray = TextImportStep5Of6Page.this.calculateMinColumnHeaderSizes(TextImportStep5Of6Page.this.mDataPreviewTable);
                    for (int i = 1; i < nArray.length; ++i) {
                        TableColumn tableColumn = TextImportStep5Of6Page.this.mDataPreviewTable.getColumnModel().getColumn(i);
                        int n = nArray[i];
                        tableColumn.setPreferredWidth(n);
                        tableColumn.setWidth(n);
                    }
                    TextImportStep5Of6Page.this.mDataPreviewTable.getTableHeader().resizeAndRepaint();
                }
            });
        }
    }

    @Override
    public String getNextPage() {
        return "STEP_6_OF_6_PAGE_ID";
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    boolean isStepFiveVisited() {
        return this.mStepFiveVisited;
    }

    void setStepFiveVisited(boolean bl) {
        this.mStepFiveVisited = bl;
    }

    @Override
    protected void aboutToShowPanel() {
        this.removeListeners();
        CaseDescriptor caseDescriptor = this.getCaseDescriptor();
        final TextImportDelimitedStep4Of6Page textImportDelimitedStep4Of6Page = (TextImportDelimitedStep4Of6Page)this.mWizardDialog.getWizardModel().getPage("DELIMITED_STEP_4_OF_6_PAGE_ID");
        final TextImportFixedWidthStep4Of6Page textImportFixedWidthStep4Of6Page = (TextImportFixedWidthStep4Of6Page)this.mWizardDialog.getWizardModel().getPage("STEP_FIXED_4_OF_6_PAGE_ID");
        if (caseDescriptor.isReadFromTPF()) {
            this.mWizardDialog.enableFinish(((ReadTextDataWizardDlg)this.mWizardDialog).hasStateChangedForFinishButton());
            if (this.mFirstVisit) {
                this.updateTable(((ReadTextDataWizardDlg)this.mWizardDialog).hasStateChanged());
                this.mFirstVisit = false;
            } else if (((ReadTextDataWizardDlg)this.mWizardDialog).hasStateChanged()) {
                this.updateTable(true);
            } else {
                this.updateTable(false);
            }
            CaseDescriptor caseDescriptor2 = this.getTextDacData().getCaseDescriptor();
            this.mPercentOfValuesDetermineDataTypeTextField.setText("" + caseDescriptor2.getPercentageOfValuesToDetermineType());
        } else {
            this.mWizardDialog.enableFinish(((ReadTextDataWizardDlg)this.mWizardDialog).hasStateChangedForFinishButton());
            if (this.mFirstVisit) {
                this.updateTable(!textImportDelimitedStep4Of6Page.isVarNamesChanged() && !textImportFixedWidthStep4Of6Page.isVarNamesChanged() && this.mFirstVisit);
                this.mFirstVisit = false;
            } else {
                this.updateTable(false);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextImportStep5Of6Page.this.loadPageFromTextDac();
                TextImportStep5Of6Page.this.setAnchorCell(1, 0);
                TextImportStep5Of6Page.this.setLeadCell(1, 0);
                TextImportStep5Of6Page.this.addListeners();
                if (textImportDelimitedStep4Of6Page.isVarNamesChanged() || textImportFixedWidthStep4Of6Page.isVarNamesChanged()) {
                    TextImportStep5Of6Page.this.showVarChangeMessage();
                    textImportDelimitedStep4Of6Page.setVarNamesChanged(false);
                    textImportFixedWidthStep4Of6Page.setVarNamesChanged(false);
                }
            }
        });
        this.setFocusTraversalPolicy();
        this.mStepFiveVisited = true;
        ((ReadTextDataWizardDlg)this.mWizardDialog).setStateChanged(false);
    }

    private void setAnchorCell(int n, int n2) {
        this.mDataPreviewTable.getColumnModel().getSelectionModel().setAnchorSelectionIndex(n);
        this.mDataPreviewTable.getSelectionModel().setAnchorSelectionIndex(n2);
    }

    private void setLeadCell(int n, int n2) {
        this.mDataPreviewTable.getColumnModel().getSelectionModel().setLeadSelectionIndex(n);
        this.mDataPreviewTable.getSelectionModel().setLeadSelectionIndex(n2);
    }

    private void showVarChangeMessage() {
        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_INVALID_VAR_NAMES_WARNING"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"));
    }

    private CaseDescriptor getCaseDescriptor() {
        return this.getTextDacData().getCaseDescriptor();
    }

    private TextDac.TextDacData getTextDacData() {
        return ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData();
    }

    private DataAccessContainer getDataAccessContainer() {
        return ((ReadTextDataWizardDlg)this.mWizardDialog).getDataAccessContainer();
    }

    private void loadPageFromTextDac() {
        this.validateVarType(this.mVarDesc.get(0));
        this.setDataFormatIntoCombo(this.mVarDesc.get(0).getVarType());
        if (this.mDataFormatCombo.getSelectedItem() == this.mStringComboItem) {
            CardLayout cardLayout = (CardLayout)this.mCardLayoutPanel.getLayout();
            if (!this.getCaseDescriptor().isFixedWidth()) {
                this.showStringLayout(cardLayout);
                this.mStringSpinner.setValue((int)this.mVarDesc.get(0).getVarLength(this.getCaseDescriptor()));
            } else {
                cardLayout.show(this.mCardLayoutPanel, "");
            }
        }
        if (this.getCaseDescriptor().hasVarsAtTopOfFile()) {
            this.mOriginalLabel.setVisible(true);
            this.mOriginalNameLabel.setVisible(true);
            this.mOriginalNameLabel.setText(this.mVarDesc.get(0).getOrigVarName());
        } else {
            this.mOriginalLabel.setVisible(false);
            this.mOriginalNameLabel.setVisible(false);
        }
        this.mDataPreviewTable.setColumnSelectionAllowed(true);
        this.mDataPreviewTable.setSelectionMode(2);
        this.mDataPreviewTable.setColumnSelectionAllowed(true);
        this.mDataPreviewTable.setRowSelectionAllowed(false);
        this.mVariableNameTextField.setText(this.mVarDesc.get(0).getModifiedVarName());
        this.mVariableNameTextField.setCaretPosition(0);
        this.mVariableNameTextField.requestFocus();
        this.mVariableNameTextField.selectAll();
        if (this.mDataPreviewTable.getModel().getRowCount() != 0) {
            this.addColumnSelectionInterval(1, 1);
        }
    }

    private void setFocusTraversalPolicy() {
        this.setFocusTraversalOrder();
    }

    private void initFocusTraversalOptions() {
        this.normalComponentOrder = new Vector();
        this.normalComponentOrder.add(this.mVariableNameTextField);
        this.normalComponentOrder.add(this.mDataFormatCombo);
        this.normalComponentOrder.add(this.mPercentOfValuesDetermineDataTypeTextField);
        this.normalComponentOrder.add(this.mDataPreviewTable);
        this.stringComponentOrder = new Vector();
        this.stringComponentOrder.add(this.mVariableNameTextField);
        this.stringComponentOrder.add(this.mDataFormatCombo);
        if (!this.getCaseDescriptor().isFixedWidth()) {
            this.stringComponentOrder.add(this.mStringSpinner.getEditor());
        }
        this.stringComponentOrder.add(this.mPercentOfValuesDetermineDataTypeTextField);
        this.stringComponentOrder.add(this.mDataPreviewTable);
        this.dateComponentOrder = new Vector();
        this.dateComponentOrder.add(this.mVariableNameTextField);
        this.dateComponentOrder.add(this.mDataFormatCombo);
        this.dateComponentOrder.add(this.mDateNTimeList);
        this.dateComponentOrder.add(this.mPercentOfValuesDetermineDataTypeTextField);
        this.dateComponentOrder.add(this.mDataPreviewTable);
    }

    private void setFocusTraversalOrder() {
        Vector<Object> vector;
        this.initFocusTraversalOptions();
        int n = this.mDataFormatCombo.getSelectedIndex();
        if (this.mBlankComboItemAdded.booleanValue()) {
            --n;
        }
        switch (n) {
            case 3: {
                vector = this.stringComponentOrder;
                break;
            }
            case 4: {
                vector = this.dateComponentOrder;
                break;
            }
            default: {
                vector = this.normalComponentOrder;
            }
        }
        Vector<Object> vector2 = ((ReadTextDataWizardDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mWizardDialog.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector2, false));
    }

    private void updateTable(boolean bl) {
        this.updateTable(bl, false);
    }

    private void updateTable(boolean bl, boolean bl2) {
        int n;
        Vector vector;
        int[] nArray = !bl ? TableUtilities.saveColSizes((JTable)this.mDataPreviewTable) : null;
        int n2 = this.mDataPreviewTable.getSelectedColumn();
        this.mVarDesc = this.getTextDacData().getVariableDescriptors(bl);
        DefaultTableModel defaultTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (VariableDescriptor variableDescriptor : this.mVarDesc) {
            vector = variableDescriptor.getVarData();
            treeSet.add(vector.size());
        }
        defaultTableModel.setRowCount(Math.min(ReadTextDataWizardDlg.getNumDisplayLines(), (Integer)treeSet.last()));
        for (n = 0; n < 1; ++n) {
            int n3 = 0;
            defaultTableModel.addColumn("     ");
            for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                defaultTableModel.setValueAt(++n3, i, n);
            }
        }
        for (n = 0; n < this.mVarDesc.size(); ++n) {
            VariableDescriptor variableDescriptor = this.mVarDesc.get(n);
            defaultTableModel.addColumn(variableDescriptor.getModifiedVarName());
            vector = variableDescriptor.getVarData();
            for (int i = 0; i < Math.min(ReadTextDataWizardDlg.getNumDisplayLines(), vector.size()); ++i) {
                defaultTableModel.setValueAt(vector.get(i), i, n + 1);
            }
        }
        this.mDataPreviewTable.setModel(defaultTableModel);
        this.mDataPreviewTable.getColumnModel().getColumn(0).setMinWidth(0);
        this.mDataPreviewTable.getColumnModel().getColumn(0).setMaxWidth(1000);
        this.mDataPreviewTable.getColumnModel().getColumn(0).setPreferredWidth(0);
        this.mDataPreviewTable.getTableHeader().resizeAndRepaint();
        this.mVariableNameTextField.setText(defaultTableModel.getColumnName(this.mDataPreviewTable.getSelectedColumn()));
        this.mDataPreviewTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                component.setBackground(jTable.getTableHeader().getBackground());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return component;
            }
        });
        this.removeTableColSelectionListener();
        this.addTableColSelectionListener();
        if (!bl) {
            TableUtilities.restoreColSizes((JTable)this.mDataPreviewTable, (int[])nArray);
            if (n2 != -1) {
                this.mDataPreviewTable.getColumnModel().getSelectionModel().setSelectionInterval(n2, n2);
            }
        }
        if (this.mDataPreviewTable.getColumnCount() != this.mOldColCount) {
            this.setDefaultTableColWidths();
        }
        this.mOldColCount = this.mDataPreviewTable.getColumnCount();
    }

    private void addTableHeaderMouseListener() {
        JTableHeader jTableHeader = this.mDataPreviewTable.getTableHeader();
        jTableHeader.addMouseListener(this.mMouseListener);
        this.mDataPreviewTable.addMouseListener(this.mMouseListener);
    }

    private void setDataFormatIntoCombo(VariableDescriptor.VarType varType) {
        if (varType == null) {
            this.mDataFormatCombo.setSelectedItemNoActionEvent((Object)this.mAutoComboItem);
        } else if (varType.equals((Object)VariableDescriptor.VarType.eAuto)) {
            this.mDataFormatCombo.setSelectedItemNoActionEvent((Object)this.mAutoComboItem);
        } else if (varType.equals((Object)VariableDescriptor.VarType.eNumeric)) {
            this.mDataFormatCombo.setSelectedItemNoActionEvent((Object)this.mNumericComboItem);
        } else if (varType.equals((Object)VariableDescriptor.VarType.eString)) {
            this.mDataFormatCombo.setSelectedItemNoActionEvent((Object)this.mStringComboItem);
        } else if (varType.equals((Object)VariableDescriptor.VarType.eDateTime)) {
            this.mDataFormatCombo.setSelectedItemNoActionEvent((Object)this.mDateTimeComboItem);
        } else if (varType.equals((Object)VariableDescriptor.VarType.eDollar)) {
            this.mDataFormatCombo.setSelectedItemNoActionEvent((Object)this.mDollarComboItem);
        } else if (varType.equals((Object)VariableDescriptor.VarType.eComma)) {
            this.mDataFormatCombo.setSelectedItemNoActionEvent((Object)this.mCommaComboItem);
        } else if (varType.equals((Object)VariableDescriptor.VarType.eDot)) {
            this.mDataFormatCombo.setSelectedItemNoActionEvent((Object)this.mDotComboItem);
        }
    }

    private ComboBoxItemWithDisable getComboboxItemForVarType(VariableDescriptor.VarType varType) {
        ComboBoxItemWithDisable comboBoxItemWithDisable = null;
        if (varType.equals((Object)VariableDescriptor.VarType.eNone)) {
            comboBoxItemWithDisable = this.mDoNotImportComboItem;
        } else if (varType.equals((Object)VariableDescriptor.VarType.eAuto)) {
            comboBoxItemWithDisable = this.mAutoComboItem;
        } else if (varType.equals((Object)VariableDescriptor.VarType.eNumeric)) {
            comboBoxItemWithDisable = this.mNumericComboItem;
        } else if (varType.equals((Object)VariableDescriptor.VarType.eString)) {
            comboBoxItemWithDisable = this.mStringComboItem;
        } else if (varType.equals((Object)VariableDescriptor.VarType.eDateTime)) {
            comboBoxItemWithDisable = this.mDateTimeComboItem;
        } else if (varType.equals((Object)VariableDescriptor.VarType.eDollar)) {
            comboBoxItemWithDisable = this.mDollarComboItem;
        } else if (varType.equals((Object)VariableDescriptor.VarType.eComma)) {
            comboBoxItemWithDisable = this.mCommaComboItem;
        } else if (varType.equals((Object)VariableDescriptor.VarType.eDot)) {
            comboBoxItemWithDisable = this.mDotComboItem;
        }
        if (comboBoxItemWithDisable != null) {
            comboBoxItemWithDisable.setEnabled(true);
        }
        return comboBoxItemWithDisable;
    }

    private void addListeners() {
        this.mDateNTimeList.addListSelectionListener(this);
        this.addTableHeaderMouseListener();
        this.mVariableNameTextField.addFocusListener(this);
        this.mStringSpinner.getEditor().addFocusListener(this);
        this.mVariableNameTextField.getDocument().addDocumentListener(this);
        this.addTableColSelectionListener();
    }

    private void removeListeners() {
        this.mDateNTimeList.removeListSelectionListener(this);
        this.mDataPreviewTable.getTableHeader().removeMouseListener(this.mMouseListener);
        this.mVariableNameTextField.removeFocusListener(this);
        this.mVariableNameTextField.getDocument().removeDocumentListener(this);
        this.mDataPreviewTable.removeMouseListener(this.mMouseListener);
        this.removeTableColSelectionListener();
    }

    private void initVars() {
        this.createDateTimeMap();
        this.mDoNotImportComboItem = new ComboBoxItemWithDisable(this.mWizardDialog.getResourceBundle(), "IDS_RTD_DATA_FORMAT_COMBO_DO_NOT_IMPORT");
        this.mAutoComboItem = new ComboBoxItemWithDisable(this.mWizardDialog.getResourceBundle(), "IDS_RTD_DATA_FORMAT_COMBO_AUTO");
        this.mNumericComboItem = new ComboBoxItemWithDisable(this.mWizardDialog.getResourceBundle(), "IDS_RTD_DATA_FORMAT_COMBO_NUMERIC");
        this.mStringComboItem = new ComboBoxItemWithDisable(this.mWizardDialog.getResourceBundle(), "IDS_RTD_DATA_FORMAT_COMBO_STRING");
        this.mDateTimeComboItem = new ComboBoxItemWithDisable(this.mWizardDialog.getResourceBundle(), "IDS_RTD_DATA_FORMAT_COMBO_DATE");
        this.mDollarComboItem = new ComboBoxItemWithDisable(this.mWizardDialog.getResourceBundle(), "IDS_RTD_DATA_FORMAT_COMBO_DOLLAR");
        this.mCommaComboItem = new ComboBoxItemWithDisable(this.mWizardDialog.getResourceBundle(), "IDS_RTD_DATA_FORMAT_COMBO_COMA");
        this.mDotComboItem = new ComboBoxItemWithDisable(this.mWizardDialog.getResourceBundle(), "IDS_RTD_DATA_FORMAT_COMBO_DOT");
        this.mBlankComboItem = new ComboBoxItemWithDisable(this.mWizardDialog.getResourceBundle(), "IDS_RTD_DATA_FORMAT_COMBO_BLANK");
        this.mTypeItems = new ArrayList();
        this.mOriginalLabel = new JLabel("");
        this.mOriginalNameLabel = new JLabel("");
        this.mDataFormatCombo = new SyncableComboBox();
        this.mDataFormatCombo.setRenderer((ListCellRenderer)new ComboBoxRendererWithDisable((JComboBox)this.mDataFormatCombo));
        ComboboxAction comboboxAction = new ComboboxAction(this.mWizardDialog, "IDS_RTD_DATA_FORMAT_COMBO_ACTION");
        this.mDataFormatCombo.setAction((Action)comboboxAction);
        this.mDataFormatCombo.addItemListener((ItemListener)this);
        this.mDataFormatCombo.setMaximumRowCount(4);
        this.mPercentOfValuesThatDetermineDataTypeLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_TEXT_IMPORT_WIZARD_AUTO_FORMAT_TYPES_PERCENT_VALUES_DETERMINE_DATA_TYPE_SPINNER_LABEL");
        this.mPercentOfValuesDetermineDataTypeTextField = new FloatTextField(50.0, 100.0, 6);
        this.mPercentOfValuesDetermineDataTypeTextField.setText("95");
        this.mPercentOfValuesDetermineDataTypeTextField.setIncludeMinRange(false);
        this.mPercentOfValuesThatDetermineDataTypeLabel.setLabelFor((Component)this.mPercentOfValuesDetermineDataTypeTextField);
        this.mPercentOfValuesDetermineDataTypeTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                TextImportStep5Of6Page.this.processPercentOfValuesDetermineDataTypeTextFieldUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                TextImportStep5Of6Page.this.processPercentOfValuesDetermineDataTypeTextFieldUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                TextImportStep5Of6Page.this.processPercentOfValuesDetermineDataTypeTextFieldUpdate();
            }
        });
        this.mDateNTimeList = new JList();
        this.updateDateNTimeList(-1);
        this.mVariableNameTextField = new VarNameTextField(12);
        this.mCardLayoutPanel = new JPanel(new CardLayout());
        int n = 1;
        Integer n2 = INITVAL;
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n2, MINLIMIT, MAXLIMIT, (Number)n);
        this.mCharSpinnerText = new IntTextField(MINLIMIT.intValue(), MAXLIMIT.intValue(), true);
        this.mStringSpinner = new TextDacNumberSpinner(this.mCharSpinnerText, spinnerNumberModel);
        this.mStringSpinner.setPreferredSize(new Dimension(80, 20));
        this.mDataPreviewTable = new JTable();
        this.mDataPreviewTable.setMinimumSize(new Dimension(400, 130));
        this.mDataPreviewTable.setColumnSelectionAllowed(true);
        this.mDataPreviewTable.setAutoResizeMode(0);
        this.mDataPreviewTable.getTableHeader().setReorderingAllowed(false);
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            this.mDataPreviewTable.setGridColor(this.mDataPreviewTable.getGridColor().darker());
        }
        this.mTableScroll = new JScrollPane(this.mDataPreviewTable);
        this.mTableScroll.setPreferredSize(this.mDataPreviewTable.getMinimumSize());
        this.mVarDesc = new Vector();
        this.mMouseListener = new TableHeaderMouseListener();
        this.initFocusTraversalOptions();
        this.updateDataFormatCombobox(null);
        if (this.mDataPreviewTable.getModel().getColumnCount() >= 2) {
            this.addColumnSelectionInterval(1, 1);
        }
    }

    private void processPercentOfValuesDetermineDataTypeTextFieldUpdate() {
        Double d = this.getPercentOfValuesDetermineTypeDoubleValue();
        this.setNextFinishButtonDisable(d != null);
    }

    private Double getPercentOfValuesDetermineTypeDoubleValue() {
        Double d;
        Double d2 = null;
        String string = this.mPercentOfValuesDetermineDataTypeTextField.getText();
        if (string != null && string.length() > 0 && (d = Double.valueOf(Double.parseDouble(this.mPercentOfValuesDetermineDataTypeTextField.getText()))) > 50.0 && d <= 100.0) {
            d2 = d;
        }
        return d2;
    }

    protected void addTableColSelectionListener() {
        ListSelectionModel listSelectionModel = this.mDataPreviewTable.getColumnModel().getSelectionModel();
        this.mColSelListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    TextImportStep5Of6Page.this.updateAllFieldsBasedOnColumnSelection();
                }
            }
        };
        listSelectionModel.addListSelectionListener(this.mColSelListener);
    }

    protected void addTableRowSelectionListener() {
        ListSelectionModel listSelectionModel = this.mDataPreviewTable.getSelectionModel();
        this.mRowSelListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = TextImportStep5Of6Page.this.mDataPreviewTable.getSelectedRow();
                if (n > 0) {
                    // empty if block
                }
            }
        };
        listSelectionModel.addListSelectionListener(this.mRowSelListener);
    }

    protected void removeTableColSelectionListener() {
        ListSelectionModel listSelectionModel = this.mDataPreviewTable.getColumnModel().getSelectionModel();
        listSelectionModel.removeListSelectionListener(this.mColSelListener);
    }

    protected void removeTableRowSelectionListener() {
        ListSelectionModel listSelectionModel = this.mDataPreviewTable.getSelectionModel();
        listSelectionModel.removeListSelectionListener(this.mRowSelListener);
    }

    private void updateDateNTimeList(int n) {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        if (n == -1) {
            defaultListModel.addElement(DATE_TIME_EMTPY_CELL);
        }
        Object object = this.mDateTimeResourceIDList;
        int n2 = ((String[])object).length;
        for (int i = 0; i < n2; ++i) {
            String string = object[i];
            defaultListModel.addElement(this.mWizardDialog.getResString(string));
        }
        this.mDateNTimeList.setModel(defaultListModel);
        Object object2 = object = n == -1 ? DATE_TIME_EMTPY_CELL : this.getDateKey(n);
        if (object != null) {
            this.mDateNTimeList.setSelectedValue(object, true);
        } else {
            this.mDateNTimeList.setSelectedIndex(0);
        }
    }

    private void updateDataFormatCombobox(VariableDescriptor.VarType varType) {
        this.mTypeItems.clear();
        if (varType == null) {
            this.mTypeItems.add(this.mBlankComboItem);
            this.mBlankComboItemAdded = true;
        } else {
            this.mBlankComboItemAdded = false;
        }
        this.mTypeItems.add(this.mAutoComboItem);
        this.mTypeItems.add(this.mDoNotImportComboItem);
        this.mTypeItems.add(this.mNumericComboItem);
        this.mTypeItems.add(this.mStringComboItem);
        this.mTypeItems.add(this.mDateTimeComboItem);
        this.mTypeItems.add(this.mDollarComboItem);
        this.mTypeItems.add(this.mCommaComboItem);
        this.mTypeItems.add(this.mDotComboItem);
        this.mDataFormatCombo.setModel(new DefaultComboBoxModel<ComboBoxItemWithDisable>(this.mTypeItems.toArray(new ComboBoxItemWithDisable[this.mTypeItems.size()])));
        if (varType == null) {
            this.mDataFormatCombo.setSelectedItemNoActionEvent((Object)this.mBlankComboItem);
            CardLayout cardLayout = (CardLayout)this.mCardLayoutPanel.getLayout();
            cardLayout.show(this.mCardLayoutPanel, "");
        } else {
            this.mDataFormatCombo.setSelectedItemNoActionEvent((Object)this.getComboboxItemForVarType(varType));
            this.setLayoutBasedOnSelection();
        }
    }

    private void addComponentsToPage() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this.mWizardPage, this.setupSpecificationsPanel(), gridBagConstraints, 0, 0, 2, 1, n, null);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.mPercentOfValuesThatDetermineDataTypeLabel);
        jPanel.add((Component)this.mPercentOfValuesDetermineDataTypeTextField);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this.mWizardPage, jPanel, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mWizardPage, this.setupDataPreviewPanel(), gridBagConstraints, 0, 2, 2, 1, n, insets);
    }

    private JPanel setupSpecificationsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.mWizardDialog.getResString(SPECIFICATION_PANEL_TITLE)));
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        JPanel jPanel2 = this.createVarNamePanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 2, 1, n, insets);
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, DATA_FORMAT_LABEL);
        jLabel.setLabelFor((Component)this.mDataFormatCombo);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JPanel jPanel3 = this.createDateTimePanel();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createDateTimePanel() {
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, CHARACTERS_LABEL);
        jLabel.setLabelFor(this.mStringSpinner.getEditor());
        JScrollPane jScrollPane = new JScrollPane(this.mDateNTimeList);
        jScrollPane.setPreferredSize(new Dimension(20, 100));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setSize(100, 100);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mStringSpinner), gridBagConstraints, 1, 0, 1, 1, n, insets);
        this.mCardLayoutPanel.add((Component)new JPanel(), "");
        this.mCardLayoutPanel.add((Component)jScrollPane, "Date/Time");
        this.mCardLayoutPanel.add((Component)jPanel, "String");
        gridBagConstraints.fill = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mDataFormatCombo, gridBagConstraints, 0, 3, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, this.mCardLayoutPanel, gridBagConstraints, 1, 3, 1, 1, n, insets);
        return jPanel2;
    }

    private JPanel createVarNamePanel() {
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        gridBagConstraints.fill = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setPreferredSize(new Dimension(450, 50));
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, VARIABLE_LABEL);
        jLabel.setLabelFor((Component)((Object)this.mVariableNameTextField));
        this.mOriginalLabel = DialogUtil.createLabel(this.mWizardDialog, ORIGINAL_NAME_LABEL);
        this.mOriginalLabel.setLabelFor(this.mOriginalNameLabel);
        this.mVariableNameTextField.setMinimumSize(new Dimension(100, 22));
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mVariableNameTextField), gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mOriginalLabel, gridBagConstraints, 1, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mOriginalNameLabel, gridBagConstraints, 1, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupDataPreviewPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.mWizardDialog.getResString(TEXT_FILE_PANEL_BORDER)));
        jPanel.setPreferredSize(new Dimension(500, 133));
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n, n, n, n);
        int n2 = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTableScroll, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        return jPanel;
    }

    public int getDateType(String string) {
        return string != null ? this.mDateTypes.get(string) : -1;
    }

    public String getDateKey(int n) {
        for (String string : this.mDateTypes.keySet()) {
            if (this.mDateTypes.get(string) != n) continue;
            return string;
        }
        return null;
    }

    private void setNextFinishButtonDisable(boolean bl) {
        this.mWizardDialog.enableBack(bl);
        this.mWizardDialog.enableNext(bl);
        CaseDescriptor caseDescriptor = this.getCaseDescriptor();
        if (caseDescriptor.isReadFromTPF()) {
            this.mWizardDialog.enableFinish(true);
        } else {
            this.mWizardDialog.enableFinish(((ReadTextDataWizardDlg)this.mWizardDialog).hasStateChangedForFinishButton());
        }
    }

    private boolean isVariableNameValid() {
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        if (this.mVariableNameTextField.getText().length() > 0) {
            vector.add(this.mVariableNameTextField.getText());
            boolean bl2 = bl = !VarNameValidator.generateSPSSNameForDac(vector, (boolean)false);
            if (bl) {
                this.setNextFinishButtonDisable(true);
            } else {
                this.setNextFinishButtonDisable(false);
            }
        }
        return bl;
    }

    private void allowNumberTypes(boolean bl) {
        this.mNumericComboItem.setEnabled(bl);
        this.mDollarComboItem.setEnabled(bl);
        this.mCommaComboItem.setEnabled(bl);
    }

    private void validateVarType(VariableDescriptor variableDescriptor) {
        ArrayList<VariableDescriptor> arrayList = new ArrayList<VariableDescriptor>();
        arrayList.add(variableDescriptor);
        this.validateVarType(arrayList);
    }

    private void validateVarType(ArrayList<VariableDescriptor> arrayList) {
        boolean bl = true;
        for (VariableDescriptor variableDescriptor : arrayList) {
            if (!VariableDescriptor.isNumberType((VariableDescriptor.VarType)variableDescriptor.getVarType()) || variableDescriptor.isAllowNumberTypes()) continue;
            variableDescriptor.setVarType(VariableDescriptor.VarType.eString);
        }
        this.allowNumberTypes(bl);
    }

    public void addColumnSelectionInterval(int n, int n2) {
        this.mDataPreviewTable.addColumnSelectionInterval(n, n2);
        this.mLastSelectedCols = this.mDataPreviewTable.getSelectedColumns();
    }

    private void updateAllFieldsBasedOnColumnSelection() {
        ArrayList<VariableDescriptor> arrayList = this.getSelectedVariableDescriptors();
        String string = arrayList.size() == 1 ? arrayList.get(0).getModifiedVarName() : "";
        boolean bl = arrayList.size() == 1;
        this.mVariableNameTextField.setText(string);
        this.mVariableNameTextField.setEnabled(bl);
        CaseDescriptor caseDescriptor = this.getCaseDescriptor();
        if (caseDescriptor.hasVarsAtTopOfFile()) {
            string = arrayList.size() == 1 ? arrayList.get(0).getOrigVarName() : "";
            this.mOriginalNameLabel.setText(string);
        }
        VariableDescriptor.VarType varType = this.getCommonVarType(arrayList);
        this.updateDataFormatCombobox(varType);
        this.validateVarType(arrayList);
        this.updateDataFormatFieldsBasedOnSelection();
    }

    private void updateDataFormatFieldsBasedOnSelection() {
        ArrayList<VariableDescriptor> arrayList = this.getSelectedVariableDescriptors();
        VariableDescriptor.VarType varType = this.getCommonVarType(arrayList);
        if (varType != null) {
            if (this.mDataFormatCombo.getSelectedItem() == this.mStringComboItem) {
                CaseDescriptor caseDescriptor = this.getCaseDescriptor();
                if (!caseDescriptor.isFixedWidth()) {
                    int n = this.getCommonVarLength(arrayList);
                    this.updateSpinnerNoTableUpdate(n);
                }
            } else if (this.mDataFormatCombo.getSelectedItem() == this.mDateTimeComboItem) {
                int n = this.getCommonDateVarType(arrayList);
                this.updateDateNTimeList(n);
            }
        }
    }

    private VariableDescriptor.VarType getCommonVarType(ArrayList<VariableDescriptor> arrayList) {
        VariableDescriptor.VarType varType = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            VariableDescriptor.VarType varType2 = arrayList.get(i).getVarType();
            if (varType != null && varType != varType2) {
                varType = null;
                break;
            }
            varType = varType2;
        }
        return varType;
    }

    private int getCommonDateVarType(ArrayList<VariableDescriptor> arrayList) {
        int n = -1;
        for (VariableDescriptor variableDescriptor : arrayList) {
            int n2 = variableDescriptor.getDateVarType();
            if (n == -1 || n == n2) {
                n = n2;
                continue;
            }
            n = -1;
            break;
        }
        return n;
    }

    private int getCommonVarLength(ArrayList<VariableDescriptor> arrayList) {
        int n = -1;
        for (VariableDescriptor variableDescriptor : arrayList) {
            double d = variableDescriptor.getVarLength(this.getCaseDescriptor());
            if (n == -1 || (double)n == d) {
                n = (int)d;
                continue;
            }
            n = -1;
            break;
        }
        return n;
    }

    protected int[] calculateMinColumnHeaderSizes(JTable jTable) {
        int[] nArray = new int[jTable.getColumnCount()];
        if (jTable != null) {
            for (int i = 1; i < jTable.getColumnCount(); ++i) {
                Serializable serializable;
                Component component = (Component)((Object)jTable.getTableHeader().getDefaultRenderer());
                if (component instanceof DefaultTableCellRenderer) {
                    FontMetrics fontMetrics;
                    String string;
                    serializable = ((DefaultTableCellRenderer)component).getTableCellRendererComponent(jTable, jTable.getColumnName(i), false, false, 0, i);
                    Icon icon = ReadTextDataWizardDlg.sVarIcons[ReadTextDataWizardDlg.VarImage.eScaleIdx.ordinal()];
                    if (icon != null) {
                        nArray[i] = icon.getIconWidth();
                    }
                    if ((string = ((JLabel)component).getText()) != null && (fontMetrics = component.getFontMetrics(component.getFont())) != null) {
                        int n = i;
                        nArray[n] = nArray[n] + (fontMetrics.stringWidth(string) + 15);
                    }
                }
                if (nArray[i] != 0 || (serializable = component.getFontMetrics(component.getFont())) == null) continue;
                nArray[i] = ((FontMetrics)serializable).stringWidth(jTable.getColumnName(i)) + 15;
            }
        }
        return nArray;
    }

    static /* synthetic */ int[] access$902(TextImportStep5Of6Page textImportStep5Of6Page, int[] nArray) {
        textImportStep5Of6Page.mLastSelectedCols = nArray;
        return nArray;
    }

    class VarNameTextField
    extends StringTextField {
        VarNameTextField(int n) {
            super(n);
        }

        @Override
        public boolean validateContents() {
            boolean bl = super.validateContents();
            if (bl) {
                TableColumn tableColumn;
                DefaultTableColumnModel defaultTableColumnModel = (DefaultTableColumnModel)TextImportStep5Of6Page.this.mDataPreviewTable.getColumnModel();
                int[] nArray = TextImportStep5Of6Page.this.mDataPreviewTable.getSelectedColumns();
                TableColumn tableColumn2 = tableColumn = nArray.length == 1 ? defaultTableColumnModel.getColumn(nArray[0]) : null;
                if (tableColumn != null) {
                    for (int i = 1; i < defaultTableColumnModel.getColumnCount(); ++i) {
                        if (defaultTableColumnModel.getColumn(i).equals(tableColumn) || !defaultTableColumnModel.getColumn(i).getHeaderValue().toString().trim().toUpperCase().equals(TextImportStep5Of6Page.this.mVariableNameTextField.getText().trim().toUpperCase())) continue;
                        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)TextImportStep5Of6Page.this.mWizardDialog), TextImportStep5Of6Page.this.mWizardDialog.getResString("ERR_RTD_DUPLICAATE_VAR_NAME_WARNING"), TextImportStep5Of6Page.this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"));
                        this.setText(tableColumn.getHeaderValue().toString());
                        this.requestFocus();
                        return false;
                    }
                    if (VarNameValidator.ValidNameCode.SPSSNAME_STANDARD == VarNameValidator.validateSPSSName((String)TextImportStep5Of6Page.this.mVariableNameTextField.getText(), (boolean)true)) {
                        tableColumn.setHeaderValue(TextImportStep5Of6Page.this.mVariableNameTextField.getText());
                        TextImportStep5Of6Page.this.mDataPreviewTable.getTableHeader().resizeAndRepaint();
                        TextImportStep5Of6Page.this.mVarDesc.get(nArray[0] - 1).setModifiedVarName(TextImportStep5Of6Page.this.mVariableNameTextField.getText());
                    } else {
                        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)TextImportStep5Of6Page.this.mWizardDialog), TextImportStep5Of6Page.this.mWizardDialog.getResString("ERR_RTD_INVALID_VAR_NAME_WARNING"), TextImportStep5Of6Page.this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"));
                        TextImportStep5Of6Page.this.mVariableNameTextField.setText(TextImportStep5Of6Page.this.mVarDesc.get(nArray[0] - 1).getModifiedVarName());
                        this.requestFocus();
                        return false;
                    }
                }
            }
            return true;
        }
    }

    class TextDacNumberSpinner
    extends NumberSpinner {
        public TextDacNumberSpinner(IntTextField intTextField, SpinnerNumberModel spinnerNumberModel) {
            super(intTextField, spinnerNumberModel);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            super.insertUpdate(documentEvent);
            if (Integer.parseInt(((IntTextField)TextImportStep5Of6Page.this.mStringSpinner.getEditor()).getText()) <= 0) {
                TextImportStep5Of6Page.this.setNextFinishButtonDisable(false);
                return;
            }
            TextImportStep5Of6Page.this.setNextFinishButtonDisable(true);
            ArrayList arrayList = TextImportStep5Of6Page.this.getSelectedVariableDescriptors();
            if (!TextImportStep5Of6Page.this.mIgnoreLengthUpdate) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    VariableDescriptor variableDescriptor = (VariableDescriptor)arrayList.get(i);
                    variableDescriptor.setVarLength((double)((Integer)TextImportStep5Of6Page.this.mStringSpinner.getValue()).intValue());
                }
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (((IntTextField)TextImportStep5Of6Page.this.mStringSpinner.getEditor()).getText().length() <= 0) {
                TextImportStep5Of6Page.this.setNextFinishButtonDisable(false);
                return;
            }
            TextImportStep5Of6Page.this.setNextFinishButtonDisable(true);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            super.stateChanged(changeEvent);
            TextImportStep5Of6Page.this.mCharSpinnerText.getDocument().addDocumentListener((DocumentListener)((Object)this));
        }
    }

    class TableHeaderMouseListener
    extends MouseAdapter {
        TableHeaderMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            TextImportStep5Of6Page.this.saveVarNameToSelectedVarDescriptors();
            TextImportStep5Of6Page.access$902(TextImportStep5Of6Page.this, null);
            int n = TextImportStep5Of6Page.this.mDataPreviewTable.columnAtPoint(new Point(mouseEvent.getPoint().x, mouseEvent.getPoint().y));
            if (n >= 1) {
                this.addColumnSelectionBasedOnMouseClick(mouseEvent, n);
                TextImportStep5Of6Page.this.updateAllFieldsBasedOnColumnSelection();
            }
        }

        private void addColumnSelectionBasedOnMouseClick(MouseEvent mouseEvent, int n) {
            if (!mouseEvent.isControlDown() && !mouseEvent.isShiftDown()) {
                TextImportStep5Of6Page.this.mAnchorIndex = n;
                TextImportStep5Of6Page.this.mDataPreviewTable.clearSelection();
                TextImportStep5Of6Page.this.mDataPreviewTable.addColumnSelectionInterval(n, n);
            } else if (mouseEvent.isControlDown()) {
                TextImportStep5Of6Page.this.mAnchorIndex = n;
                if (TextImportStep5Of6Page.this.mDataPreviewTable.isColumnSelected(n)) {
                    TextImportStep5Of6Page.this.mDataPreviewTable.removeColumnSelectionInterval(n, n);
                } else {
                    TextImportStep5Of6Page.this.mDataPreviewTable.addColumnSelectionInterval(n, n);
                }
            } else if (mouseEvent.isShiftDown() && TextImportStep5Of6Page.this.mAnchorIndex > 0) {
                int n2;
                int n3;
                TextImportStep5Of6Page.this.mDataPreviewTable.clearSelection();
                if (n > TextImportStep5Of6Page.this.mAnchorIndex) {
                    n3 = TextImportStep5Of6Page.this.mAnchorIndex;
                    n2 = n;
                } else {
                    n3 = n;
                    n2 = TextImportStep5Of6Page.this.mAnchorIndex;
                }
                TextImportStep5Of6Page.this.mDataPreviewTable.addColumnSelectionInterval(n3, n2);
            }
            TextImportStep5Of6Page.access$902(TextImportStep5Of6Page.this, TextImportStep5Of6Page.this.mDataPreviewTable.getSelectedColumns());
        }
    }
}

