/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.read_text_data;

import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.data.data_access.text.CaseDescriptor;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.KeyDoesNotExistsException;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.ReadTextDataWizardDlg;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.SerializeDataReader;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.TextImportScalePanel;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.TextImportStep5Of6Page;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class TextImportStep1Of6Page
extends AbstractWizardPage
implements ItemListener,
ActionListener,
DocumentListener {
    static final String TEXT_FILE_PANEL_BORDER = "IDS_RTD_TEXT_FILE";
    static final String STEP_ONE_TITLE = "IDS_RTD_STEP_ONE";
    static final String WELCOME_LABEL = "IDS_RTD_STEP_WELCOME";
    static final String WIZARD_DESCRIPTION = "IDS_RTD_WELCOME_LABEL";
    static final String TEXT_FILE_MATCH_PANEL_TITLE = "IDS_RTD_TEXTFILE_MATCH_QUES";
    static final String YES_RADIO = "IDS_RTD_YES_RADIO";
    static final String NO_RADIO = "IDS_RTD_NO_RADIO";
    static final String BROWSE_BUTTON = "IDS_RTD_BROWSE";
    static final String STEP_1_OF_6_PAGE_ID = "STEP_1_OF_6_PAGE_ID";
    private JRadioButton mYesRadio;
    private JRadioButton mNoRadio;
    private SpssButtonGroup mButtonGrp;
    private FileTextField mFileTextField;
    private JTextArea mFileTextArea;
    private JList mRowNumbersList;
    private JButton mBrowseButton;
    int rowHeight;
    int mColumnWidth;
    int mMaxNoOfCharsLine;
    private JScrollPane mTextAreaScrollPane;
    TextImportScalePanel mTextImportScalePanel;

    TextImportStep1Of6Page(BaseWizardDialog baseWizardDialog) {
        super(STEP_1_OF_6_PAGE_ID, baseWizardDialog.getResString(STEP_ONE_TITLE), baseWizardDialog, true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        boolean bl = itemEvent.getStateChange() == 1;
        this.mWizardDialog.enableBack(false);
        if (object.equals(this.mYesRadio)) {
            this.mFileTextField.setEnabled(bl);
            this.mFileTextField.setOpaque(bl);
            this.mBrowseButton.setEnabled(bl);
            if (bl) {
                if (this.mFileTextField.getText() == null || this.mFileTextField.getText().equals("")) {
                    this.mWizardDialog.enableNext(false);
                    this.mWizardDialog.enableFinish(false);
                } else {
                    this.mWizardDialog.enableNext(true);
                    this.mWizardDialog.enableFinish(true);
                }
            }
        } else if (object.equals(this.mNoRadio)) {
            this.mFileTextField.setEnabled(!bl);
            this.mFileTextField.setOpaque(!bl);
            this.mFileTextField.setText("");
            this.mBrowseButton.setEnabled(!bl);
            if (bl) {
                this.mWizardDialog.enableNext(true);
                this.mWizardDialog.enableFinish(false);
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mFileTextField.getText().length() > 0) {
            this.mWizardDialog.enableNext(true);
            this.mWizardDialog.enableFinish(true);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.mBrowseButton)) {
            this.openTpfFile();
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_text_wizard_step1";
    }

    @Override
    public boolean validate() {
        TextImportStep5Of6Page textImportStep5Of6Page = (TextImportStep5Of6Page)((ReadTextDataWizardDlg)this.mWizardDialog).getWizardModel().getPage("STEP_5_OF_6_PAGE_ID");
        CaseDescriptor caseDescriptor = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getCaseDescriptor();
        if (this.mYesRadio.isSelected()) {
            if (this.isTpf(this.mFileTextField.getText())) {
                caseDescriptor.setIsReadFromTPF(true);
                ((ReadTextDataWizardDlg)this.mWizardDialog).setStateChangedForFinishButton(true);
                textImportStep5Of6Page.setStepFiveVisited(true);
            } else {
                ((ReadTextDataWizardDlg)this.mWizardDialog).setStateChangedForFinishButton(false);
            }
        } else {
            caseDescriptor.setIsReadFromTPF(false);
            textImportStep5Of6Page.setStepFiveVisited(false);
        }
        return true;
    }

    @Override
    public void init() {
        this.initVars();
        this.setDefaults();
        this.addComponentsToPage();
    }

    public boolean isValidFile() {
        if (this.mYesRadio.isSelected()) {
            return this.isTpf(this.mFileTextField.getText());
        }
        return true;
    }

    @Override
    public String getNextPage() {
        return "STEP_2_OF_6_PAGE_ID";
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    protected void aboutToShowPanel() {
        this.setFocusTraversalPolicy();
        this.updateTextArea();
        this.mNoRadio.requestFocus();
        if (this.mYesRadio.isSelected() && this.mFileTextField.getText().length() > 0) {
            this.mWizardDialog.enableFinish(true);
        } else {
            this.mWizardDialog.enableFinish(((ReadTextDataWizardDlg)this.mWizardDialog).hasStateChangedForFinishButton());
        }
        this.mWizardDialog.enableBack(false);
    }

    private boolean isTpf(String string) {
        boolean bl = true;
        TextImportStep5Of6Page textImportStep5Of6Page = (TextImportStep5Of6Page)((ReadTextDataWizardDlg)this.mWizardDialog).getWizardModel().getPage("STEP_5_OF_6_PAGE_ID");
        CaseDescriptor caseDescriptor = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getCaseDescriptor();
        SerializeDataReader serializeDataReader = new SerializeDataReader(((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData());
        try {
            bl = serializeDataReader.readSerializedData(string);
        }
        catch (KeyDoesNotExistsException keyDoesNotExistsException) {
            bl = false;
            keyDoesNotExistsException.printStackTrace();
        }
        if (!bl) {
            this.mWizardDialog.enableNext(false);
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_NOT_VALID_FILE"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"));
            caseDescriptor.setIsReadFromTPF(false);
            textImportStep5Of6Page.setStepFiveVisited(false);
        }
        return bl;
    }

    public void updateTextArea() {
        ((ReadTextDataWizardDlg)this.mWizardDialog).updateTextArea(this.mFileTextArea, this.mRowNumbersList);
    }

    private void initVars() {
        this.mYesRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, YES_RADIO));
        this.mYesRadio.addItemListener(this);
        this.mNoRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, NO_RADIO));
        this.mNoRadio.addItemListener(this);
        this.mButtonGrp = new SpssButtonGroup();
        this.mButtonGrp.add(this.mYesRadio);
        this.mButtonGrp.add(this.mNoRadio);
        this.mFileTextField = new FileTextField();
        this.mFileTextField.setColumns(12);
        this.mFileTextField.setEditable(true);
        this.mFileTextField.getDocument().addDocumentListener(this);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, BROWSE_BUTTON);
        this.mBrowseButton = new JButton(toggleButtonAction);
        this.mBrowseButton.addActionListener(this);
        this.mFileTextArea = new JTextArea();
        this.mRowNumbersList = new JList();
    }

    private void setDefaults() {
        this.mFileTextField.setEnabled(false);
        this.mFileTextField.setOpaque(false);
        this.mBrowseButton.setEnabled(false);
        this.mNoRadio.setSelected(true);
        this.mWizardDialog.enableBack(false);
        this.mWizardDialog.enableFinish(false);
    }

    private void addComponentsToPage() {
        URL uRL = this.mWizardDialog.getResImageURL("IDS_RTD_STEP_ONE_IMAGE");
        JLabel jLabel = new JLabel(" ");
        jLabel.setIcon(new ImageIcon(uRL));
        JLabel jLabel2 = new JLabel(this.mWizardDialog.getResString(WELCOME_LABEL));
        JTextArea jTextArea = new JTextArea(this.mWizardDialog.getResString(WIZARD_DESCRIPTION));
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFocusable(false);
        jTextArea.setRows(2);
        jTextArea.setMinimumSize(new Dimension(160, 30));
        jTextArea.setPreferredSize(new Dimension(160, 30));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mWizardPage, jLabel, gridBagConstraints, 0, 0, 1, 3, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(0, 6, 0, 0);
        DialogUtil.addUsingGBL(this.mWizardPage, jLabel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.set(DialogUtil.getComponentGroupGap(), 6, 0, 0);
        DialogUtil.addUsingGBL(this.mWizardPage, jTextArea, gridBagConstraints, 1, 1, 1, 1, n, insets);
        insets.set(DialogUtil.getComponentGroupGap() + 40, 5, 0, 0);
        DialogUtil.addUsingGBL(this.mWizardPage, this.setupTextFileMatchPanel(), gridBagConstraints, 1, 2, 1, 1, n, insets);
        insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mWizardPage, this.setupDataPreviewPanel(), gridBagConstraints, 0, 3, 2, 1, n, insets);
    }

    private JPanel setupDataPreviewPanel() {
        Object object2;
        Font font = new Font("Monospaced", 0, 12);
        this.mFileTextArea.setLineWrap(false);
        this.mFileTextArea.setEditable(false);
        this.mFileTextArea.setFocusable(true);
        this.mFileTextArea.setFont(font);
        this.mFileTextArea.setRows(4);
        FontMetrics fontMetrics = this.mFileTextArea.getFontMetrics(this.mFileTextArea.getFont());
        this.rowHeight = fontMetrics.getHeight();
        this.mColumnWidth = fontMetrics.charWidth('0');
        LinkedHashMap linkedHashMap = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getCaseMap();
        for (Object object2 : linkedHashMap.values()) {
            int n = ((String)object2).length();
            if (this.mMaxNoOfCharsLine >= n) continue;
            this.mMaxNoOfCharsLine = n;
        }
        ReadTextDataWizardDlg cfr_ignored_0 = (ReadTextDataWizardDlg)this.mWizardDialog;
        ReadTextDataWizardDlg.initRowNumberList(this.mRowNumbersList, this.mFileTextArea, new ReadTextDataWizardDlg.NumberListCellRenderer(this.mFileTextArea.getFont()));
        object2 = new JPanel(new GridBagLayout());
        ((JComponent)object2).setBorder(new TitledBorder(this.mWizardDialog.getResString(TEXT_FILE_PANEL_BORDER) + " " + ((ReadTextDataWizardDlg)this.mWizardDialog).getFileName()));
        ((JComponent)object2).setPreferredSize(new Dimension(100, 133));
        ((JComponent)object2).setMinimumSize(((JComponent)object2).getPreferredSize());
        this.mTextAreaScrollPane = new JScrollPane(this.mFileTextArea);
        this.mTextImportScalePanel = new TextImportScalePanel(this.mColumnWidth, this.mMaxNoOfCharsLine, this.mFileTextArea);
        this.mTextAreaScrollPane.setPreferredSize(new Dimension(2147482647, 25));
        this.mTextAreaScrollPane.setFocusable(false);
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(true);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setPreferredSize(new Dimension(2147482647, 33));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n, n, n, n);
        int n2 = 23;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel2, this.mTextImportScalePanel, gridBagConstraints, 0, 0, 1, 1, n2, null);
        DialogUtil.addUsingGBL(jPanel2, jPanel, gridBagConstraints, 0, 1, 1, 1, n2, null);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        JPanel jPanel5 = new JPanel();
        jPanel5.setOpaque(true);
        jPanel5.setMinimumSize(new Dimension(15, 125));
        DialogUtil.addUsingGBL(jPanel4, jPanel5, gridBagConstraints, 1, 0, 1, 1, n2, null);
        DialogUtil.addUsingGBL(jPanel4, this.mRowNumbersList, gridBagConstraints, 0, 0, 1, 1, n2, null);
        this.mTextAreaScrollPane = new JScrollPane(this.mFileTextArea);
        this.mTextAreaScrollPane.setHorizontalScrollBarPolicy(32);
        this.mTextAreaScrollPane.setVerticalScrollBarPolicy(22);
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            this.mTextAreaScrollPane.setCorner("UPPER_LEFT_CORNER", new JPanel());
            this.mTextAreaScrollPane.setCorner("LOWER_LEFT_CORNER", new JPanel());
            this.mTextAreaScrollPane.setCorner("UPPER_RIGHT_CORNER", new JPanel());
            this.mTextAreaScrollPane.setCorner("LOWER_RIGHT_CORNER", new JPanel());
        }
        DialogUtil.addUsingGBL(jPanel3, this.mTextAreaScrollPane, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        this.mTextAreaScrollPane.setColumnHeaderView(jPanel2);
        this.mTextAreaScrollPane.setRowHeaderView(jPanel4);
        this.mTextAreaScrollPane.setWheelScrollingEnabled(false);
        this.mTextAreaScrollPane.setViewportBorder(BorderFactory.createLineBorder(Color.BLACK));
        DialogUtil.addUsingGBL((Container)object2, jPanel3, gridBagConstraints, 0, 0, 1, 1, n2, null);
        return object2;
    }

    private JPanel setupTextFileMatchPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.mWizardDialog.getResString(TEXT_FILE_MATCH_PANEL_TITLE)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mYesRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mNoRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets2 = new Insets(insets.top + 5, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileTextField), gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets2.set(insets.top + 3, DialogUtil.getGroupBoxInnerMargin(), 0, DialogUtil.getGroupBoxInnerMargin());
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 2, 0, 1, 1, n, insets2);
        return jPanel;
    }

    private boolean openTpfFile() {
        boolean bl = false;
        RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
        remoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(this.mWizardDialog.getResString("IDS_RTD_TPF_FILTER"), this.mWizardDialog.getResString("IDS_RTD_TPF_EXT")));
        remoteFileChooser.setDialogTitle(this.mWizardDialog.getResString("IDS_RTD_TPF_OPEN"));
        int n = remoteFileChooser.showOpenDialog((Component)((Object)this.mWizardDialog));
        if (n == 0) {
            FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
            File file = remoteFileChooser.getSelectedFile();
            remoteFileChooser.setCurrentDirectory(file);
            String string = remoteFileChooser.getSelectedFilePath();
            if (this.isTpf(string)) {
                this.mFileTextField.setText(string);
                bl = true;
            } else {
                this.mFileTextField.setText("");
            }
        }
        return bl;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mButtonGrp);
        vector.add(this.mBrowseButton);
        vector.add(this.mFileTextArea);
        Vector<Object> vector2 = ((ReadTextDataWizardDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mWizardDialog.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector2, false));
    }
}

