/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.read_text_data;

import com.spss.java_client.ui.dialogs.base.file.read_text_data.TextImportTextArea;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;

public class TextImportScalePanel
extends JTextArea {
    private boolean mReleaseFlag;
    private int mX1 = 0;
    private int mX2 = 0;
    private int mY1 = 20;
    private int mY2 = 20;
    private int mShowString = 0;
    private BasicStroke mBoldStroke = new BasicStroke(1.5f);
    private Stroke mNormalStroke;
    public static int mCharWidth;
    private TextImportTextArea mTextArea;
    private int mMaxLine;
    private int mMaxCharsPerLine;
    private int mDefaultLineCount = 500;

    public TextImportScalePanel(int n, int n2) {
        this(n, n2, null);
    }

    public TextImportScalePanel(int n, int n2, JTextArea jTextArea) {
        mCharWidth = n;
        this.setMaxCharsPerLine(n2);
        this.setMaxNoOfLines(n2);
        this.mTextArea = jTextArea instanceof TextImportTextArea ? (TextImportTextArea)jTextArea : null;
        this.setEditable(false);
        this.setSize(this.mX2, 25);
        MouseAndKeyHandler mouseAndKeyHandler = new MouseAndKeyHandler();
        this.addMouseListener(mouseAndKeyHandler);
        this.addMouseMotionListener(mouseAndKeyHandler);
        this.addKeyListener(mouseAndKeyHandler);
        this.setBackground(UIManager.getColor("Panel.background"));
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.mNormalStroke = graphics2D.getStroke();
        graphics2D.drawLine(this.mX1, this.mY1, this.mX2, this.mY2);
        graphics2D.setStroke(this.mBoldStroke);
        graphics2D.drawLine(this.mX1, this.mY1, this.mX1, this.mY2 - 5);
        graphics2D.setStroke(this.mNormalStroke);
        graphics2D.drawString(Integer.toString(this.mShowString), this.mX1, this.mY2 - 7);
        this.mX1 = 0;
        while (this.mX1 < this.mX2) {
            this.drawShortLine(graphics2D);
            this.drawLongLine(graphics2D);
        }
        this.mX1 = 0;
        this.mY1 = 20;
        this.mX2 = this.mMaxLine;
        this.mY2 = 20;
        this.mShowString = 0;
        graphics2D.setStroke(new BasicStroke(1.5f));
        if (this.mTextArea != null) {
            this.mTextArea.paintBreakPoints(graphics2D);
        }
    }

    public void setMaxNoOfLines(int n) {
        if (this.mDefaultLineCount < n) {
            this.mX2 = n * mCharWidth;
            this.mMaxLine = n * mCharWidth;
        } else {
            this.mX2 = this.mDefaultLineCount * mCharWidth;
            this.mMaxLine = this.mDefaultLineCount * mCharWidth;
        }
        this.repaint();
    }

    private void drawShortLine(Graphics2D graphics2D) {
        for (int i = 1; i < 9; ++i) {
            if (i == 5) {
                graphics2D.setStroke(this.mBoldStroke);
                graphics2D.drawLine(this.mX1 += mCharWidth, this.mY1, this.mX1, this.mY2 - 5);
                graphics2D.setStroke(this.mNormalStroke);
            }
            graphics2D.drawLine(this.mX1 += mCharWidth, this.mY1, this.mX1, this.mY2 - 3);
        }
    }

    private void drawLongLine(Graphics2D graphics2D) {
        graphics2D.setStroke(this.mBoldStroke);
        graphics2D.drawLine(this.mX1 += mCharWidth, this.mY1, this.mX1, this.mY2 - 5);
        graphics2D.setStroke(this.mNormalStroke);
        this.mShowString += 10;
        graphics2D.drawString(Integer.toString(this.mShowString), this.mX1 - 3, this.mY2 - 7);
    }

    public int getMaxCharsPerLine() {
        return this.mMaxCharsPerLine;
    }

    public void setMaxCharsPerLine(int n) {
        this.mMaxCharsPerLine = n;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleTextImportScalePanel();
        }
        return this.accessibleContext;
    }

    protected class AccessibleTextImportScalePanel
    extends JComponent.AccessibleJComponent {
        protected AccessibleTextImportScalePanel() {
            super(TextImportScalePanel.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.SINGLE_LINE);
            return accessibleStateSet;
        }
    }

    class MouseAndKeyHandler
    extends MouseInputAdapter
    implements KeyListener {
        MouseAndKeyHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (TextImportScalePanel.this.mTextArea != null) {
                TextImportScalePanel.this.mTextArea.processMouseEvent(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (TextImportScalePanel.this.mTextArea != null) {
                TextImportScalePanel.this.mTextArea.processMouseEvent(mouseEvent);
                TextImportScalePanel.this.mTextArea.requestFocusInWindow();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (TextImportScalePanel.this.mTextArea != null) {
                TextImportScalePanel.this.mTextArea.processMouseEvent(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (TextImportScalePanel.this.mTextArea != null) {
                TextImportScalePanel.this.mTextArea.processMouseEvent(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (TextImportScalePanel.this.mTextArea != null) {
                TextImportScalePanel.this.mTextArea.processMouseEvent(mouseEvent);
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (TextImportScalePanel.this.mTextArea != null) {
                if (TextImportScalePanel.this.mTextArea.processKeyEvent(keyEvent.getKeyCode())) {
                    try {
                        int n = TextImportScalePanel.this.mTextArea.getCursorLine();
                        int n2 = n % mCharWidth;
                        int n3 = n / mCharWidth - n2;
                        TextImportScalePanel.this.mTextArea.setCaretPosition(n3);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        keyEvent.consume();
                        System.out.println("IllegalArgumentException");
                    }
                } else {
                    keyEvent.consume();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

