/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.read_text_data;

import com.spss.java_client.core.common.Switchboard;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.data_access.text.TextDac;
import com.spss.java_client.core.documents.data.data_access.text.VariableDescriptor;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.ReadTextDataWizardDlg;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.TextImportScalePanel;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.TextImportStep5Of6Page;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.TextImportTextArea;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.IntTextField;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextImportFixedWidthStep4Of6Page
extends AbstractWizardPage
implements ActionListener,
FocusListener,
DocumentListener,
PropertyChangeListener {
    private JLabel mRulerLabel;
    static final String COLUMN_NUMBER_LABEL = "IDS_RTD_COLUMN_NUMBER";
    static final String CURRENT_VARIABLE_LABEL = "IDS_RTD_CURR_VAR_WIDTH";
    static final String TEXT_FILE_PANEL_BORDER = "IDS_RTD_DATA_PREVIEW";
    static final String STEP_FIXED_FOUR_TITLE = "IDS_RTD_FIXED_WIDTH_STEP_FOUR";
    static final String RULER_LABEL = "IDS_RTD_RULER_LABEL";
    static final String VERTICAL_LINES_TITLE = "IDS_RTD_VERT_LINES_REPRESENT_BREAK_PTS";
    static final String DELETE_LABEL = "IDS_RTD_TO_DELETE";
    static final String INSERT_LABEL = "IDS_RTD_TO_INSERT";
    static final String MODIFY_LABEL = "IDS_RTD_TO_MODIFY";
    static final String INSERT_BREAK_BUTTON = "IDS_RTD_INSERT_BREAK";
    static final String DELETE_BREAK_BUTTON = "IDS_RTD_DELETE_BREAK";
    static final int MIN_VALUE = 0;
    static final int MAX_VALUE = 100000;
    static final String SPECIFY_LABEL = "IDS_RTD_SPECIFY_EACH_VAR";
    static final String MOVE_LABEL = "IDS_RTD_TO_MOVE";
    static final String STEP_FIXED_4_OF_6_PAGE_ID = "STEP_FIXED_4_OF_6_PAGE_ID";
    static final String BREAK_LINE_SELECTED = "IDS_TEXT_WIZ_ACCESSIBLE_BREAK_LINE_SELECTED";
    static final String DATA_AREA = "IDS_TEXT_WIZ_ACCESSIBLE_DATA_AREA";
    static final String COLUMN_NAME = "IDS_TEXT_WIZ_ACCESSIBLE_COLUMN_NAME";
    private TextImportTextArea mFileTextArea;
    private JList mRowNumbersList;
    private ArrayList<Integer> mCutPoints;
    private boolean mVarNamesChanged;
    private boolean mFirstVisit = true;
    private JButton mInsertButton;
    private JButton mDeleteButton;
    public IntTextField mColumnNumberTextField;
    public JTextArea mCurrentVariableWidthLabel;
    private int mColumnWidth;
    private int mMaxNoOfCharsLine;
    private TextImportScalePanel mScalePanel;
    private boolean mColumnFlag;
    private boolean mRulerAreaFlag;
    private boolean mDataAreaFlag;
    private boolean mValidateVarNames = true;
    private String mInsertButtonAccessibleText;
    private String mDeleteButtonAccessibleText;
    private GlobalKeyHandler mKeyHandler;

    TextImportFixedWidthStep4Of6Page(BaseWizardDialog baseWizardDialog) {
        super(STEP_FIXED_4_OF_6_PAGE_ID, baseWizardDialog.getResString(STEP_FIXED_FOUR_TITLE), baseWizardDialog, true);
    }

    @Override
    public void init() {
        this.initVars();
        this.addComponentsToPage();
    }

    @Override
    public String getNextPage() {
        return "STEP_5_OF_6_PAGE_ID";
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_text_wizard_step4_fixed";
    }

    public boolean isVarNamesChanged() {
        return this.mVarNamesChanged;
    }

    public void setVarNamesChanged(boolean bl) {
        this.mVarNamesChanged = bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TextImportStep5Of6Page textImportStep5Of6Page = (TextImportStep5Of6Page)this.mWizardDialog.getWizardModel().getPage("STEP_5_OF_6_PAGE_ID");
        if (actionEvent.getSource() == this.mInsertButton) {
            int n = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getCaseDescriptor().getNumLinesRepresentCase();
            int n2 = n * this.mMaxNoOfCharsLine;
            if (this.mColumnNumberTextField.getText().length() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_ENTER_COLUMN_NUMBER"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"));
                this.mColumnNumberTextField.requestFocus();
            } else if (new Integer(this.mColumnNumberTextField.getText()) <= n2) {
                if (!this.mFileTextArea.containsCutPoint(new Integer(this.mColumnNumberTextField.getText()) * TextImportScalePanel.mCharWidth)) {
                    this.processInsert();
                    this.mInsertButton.getAccessibleContext().setAccessibleName(this.mWizardDialog.getResString(COLUMN_NAME) + this.mColumnNumberTextField.getText() + this.mWizardDialog.getResString(BREAK_LINE_SELECTED));
                } else if (this.mFileTextArea.containsCutPoint(new Integer(this.mColumnNumberTextField.getText()) * TextImportScalePanel.mCharWidth)) {
                    boolean bl = true;
                    if (textImportStep5Of6Page.isStepFiveVisited()) {
                        bl = this.getStepFiveVisitedAction();
                    }
                    if (bl) {
                        textImportStep5Of6Page.setStepFiveVisited(false);
                    }
                }
            }
            this.mInsertButton.getAccessibleContext().setAccessibleName(this.mWizardDialog.getResString(COLUMN_NAME) + this.mColumnNumberTextField.getText() + this.mWizardDialog.getResString(BREAK_LINE_SELECTED));
        } else if (this.mColumnNumberTextField.getText().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_ENTER_COLUMN_NUMBER"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"));
            this.mColumnNumberTextField.requestFocus();
            this.mColumnNumberTextField.selectAll();
        } else {
            this.processDelete();
            this.mDeleteButton.getAccessibleContext().setAccessibleName(this.mWizardDialog.getResString(COLUMN_NAME) + this.mColumnNumberTextField.getText());
        }
        this.mFileTextArea.doRepaint();
    }

    private void processInsert() {
        TextImportStep5Of6Page textImportStep5Of6Page = (TextImportStep5Of6Page)this.mWizardDialog.getWizardModel().getPage("STEP_5_OF_6_PAGE_ID");
        boolean bl = true;
        if (textImportStep5Of6Page.isStepFiveVisited()) {
            bl = this.getStepFiveVisitedAction();
        }
        if (bl) {
            textImportStep5Of6Page.setStepFiveVisited(false);
            this.mFileTextArea.addCutPoint(new Integer(this.mColumnNumberTextField.getText()) * TextImportScalePanel.mCharWidth);
            if (this.mDataAreaFlag | this.mRulerAreaFlag) {
                this.mFileTextArea.setCurserLocation(Integer.parseInt(this.mColumnNumberTextField.getText()));
                this.mFileTextArea.setCurrentVariableWidth(Integer.parseInt(this.mColumnNumberTextField.getText()) * TextImportScalePanel.mCharWidth);
                this.mFileTextArea.doRepaint();
            }
            ((ReadTextDataWizardDlg)this.mWizardDialog).setStateChanged(true);
            ((ReadTextDataWizardDlg)this.mWizardDialog).setStateChangedForFinishButton(false);
            this.mWizardDialog.enableFinish(((ReadTextDataWizardDlg)this.mWizardDialog).hasStateChangedForFinishButton());
        }
    }

    private void processDelete() {
        TextImportStep5Of6Page textImportStep5Of6Page = (TextImportStep5Of6Page)this.mWizardDialog.getWizardModel().getPage("STEP_5_OF_6_PAGE_ID");
        boolean bl = true;
        if (textImportStep5Of6Page.isStepFiveVisited()) {
            bl = this.getStepFiveVisitedAction();
        }
        if (bl) {
            textImportStep5Of6Page.setStepFiveVisited(false);
            this.mFileTextArea.removeCutPoints(new Integer(this.mColumnNumberTextField.getText()) * TextImportScalePanel.mCharWidth);
            if (this.mDataAreaFlag | this.mRulerAreaFlag) {
                this.mFileTextArea.setCurserLocation(Integer.parseInt(this.mColumnNumberTextField.getText()));
                this.mFileTextArea.setCurrentVariableWidth(Integer.parseInt(this.mColumnNumberTextField.getText()) * TextImportScalePanel.mCharWidth);
                this.mFileTextArea.doRepaint();
            }
            ((ReadTextDataWizardDlg)this.mWizardDialog).setStateChanged(true);
            ((ReadTextDataWizardDlg)this.mWizardDialog).setStateChangedForFinishButton(false);
            this.mWizardDialog.enableFinish(((ReadTextDataWizardDlg)this.mWizardDialog).hasStateChangedForFinishButton());
        }
        if (this.mFileTextArea.getNumCutPoints() == 0) {
            this.mColumnNumberTextField.setText("0");
            this.mCurrentVariableWidthLabel.setText("0");
        }
        ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getCaseDescriptor().setCutPoints(this.mFileTextArea.getCutPoints());
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        String string = this.mFileTextArea.getColumnNumberTextField();
        if (string.equals("")) {
            string = "0";
        }
        int n = Integer.parseInt(string);
        if (focusEvent.getSource() == this.mFileTextArea) {
            this.mDataAreaFlag = true;
            this.mColumnFlag = false;
            this.mRulerAreaFlag = false;
            this.mFileTextArea.doDrawCursor(true);
            this.mFileTextArea.setCurserLocation(n);
            this.mFileTextArea.setCurrentVariableWidth(n * TextImportScalePanel.mCharWidth);
            this.mFileTextArea.doRepaint();
            String string2 = this.mWizardDialog.getResString(DATA_AREA) + "," + this.mWizardDialog.getResString(COLUMN_NAME) + string;
            if (this.doesCutPointsContainColumnNum(n)) {
                string2 = string2 + "," + this.mWizardDialog.getResString(BREAK_LINE_SELECTED);
            }
            this.mFileTextArea.getAccessibleContext().setAccessibleName(string2);
        } else if (focusEvent.getSource() == this.mScalePanel) {
            this.mRulerAreaFlag = true;
            this.mColumnFlag = false;
            this.mDataAreaFlag = false;
            this.mFileTextArea.doDrawCursor(true);
            this.mFileTextArea.setCurserLocation(n);
            this.mFileTextArea.setCurrentVariableWidth(n * TextImportScalePanel.mCharWidth);
            this.mFileTextArea.doRepaint();
            String string3 = this.mWizardDialog.getResString(RULER_LABEL).replaceFirst(":", "") + "," + this.mWizardDialog.getResString(COLUMN_NAME) + string;
            if (this.doesCutPointsContainColumnNum(n)) {
                string3 = string3 + "," + this.mWizardDialog.getResString(BREAK_LINE_SELECTED);
            }
            this.mScalePanel.getAccessibleContext().setAccessibleName(string3);
            this.mScalePanel.getAccessibleContext().setAccessibleDescription("");
        } else if (focusEvent.getSource() == this.mColumnNumberTextField) {
            this.mColumnFlag = true;
            this.mDataAreaFlag = false;
            this.mRulerAreaFlag = false;
        } else if (focusEvent.getSource() == this.mDeleteButton) {
            this.mColumnFlag = false;
            this.mDataAreaFlag = false;
            this.mRulerAreaFlag = false;
            this.mFileTextArea.doRepaint();
            this.mDeleteButton.getAccessibleContext().setAccessibleName(this.mDeleteButtonAccessibleText + "," + this.mWizardDialog.getResString(COLUMN_NAME) + string);
        } else if (focusEvent.getSource() == this.mInsertButton) {
            this.mColumnFlag = false;
            this.mDataAreaFlag = false;
            this.mRulerAreaFlag = false;
            this.mFileTextArea.doRepaint();
            this.mInsertButton.getAccessibleContext().setAccessibleName(this.mInsertButtonAccessibleText + "," + this.mWizardDialog.getResString(COLUMN_NAME) + string);
        }
    }

    public boolean doesCutPointsContainColumnNum(int n) {
        return this.mFileTextArea.containsCutPoint(n * TextImportScalePanel.mCharWidth);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.mFileTextArea.doRepaint();
        if (focusEvent.getSource() == this.mInsertButton) {
            this.mInsertButton.getAccessibleContext().setAccessibleName(this.mInsertButtonAccessibleText);
        } else if (focusEvent.getSource() == this.mDeleteButton) {
            this.mDeleteButton.getAccessibleContext().setAccessibleName(this.mDeleteButtonAccessibleText);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mColumnNumberTextField.getText().length() > 0) {
            this.setFieldsBasedOnColumnNumber();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mColumnNumberTextField.getText().length() > 0) {
            this.setFieldsBasedOnColumnNumber();
        } else {
            this.mFileTextArea.setCurrentVariableWidth(0);
            this.mFileTextArea.doRepaint();
        }
    }

    private void setFieldsBasedOnColumnNumber() {
        this.mFileTextArea.doDrawCursor(true);
        Integer n = Integer.parseInt(this.mColumnNumberTextField.getText());
        int n2 = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getCaseDescriptor().getNumLinesRepresentCase();
        int n3 = n2 * this.mMaxNoOfCharsLine;
        if (n <= n3) {
            this.mFileTextArea.setCurserLocation(Integer.parseInt(this.mColumnNumberTextField.getText()));
            this.mFileTextArea.setCurrentVariableWidth(Integer.parseInt(this.mColumnNumberTextField.getText()) * TextImportScalePanel.mCharWidth);
            this.mFileTextArea.doRepaint();
        } else {
            String string = this.mWizardDialog.getResString("IDS_TEXT_WIZ_INVALID_COL_NUMBER");
            string = MessageFormat.format(string, n3, n3);
            this.mCurrentVariableWidthLabel.setText(string);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public boolean validate() {
        if (this.mFileTextArea.getNumCutPoints() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_NO_VARS_WARNING"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"));
            return false;
        }
        this.mCutPoints.clear();
        for (int i = 0; i < this.mFileTextArea.getNumCutPoints(); ++i) {
            this.mCutPoints.add(this.mFileTextArea.getCutPoint(i) / TextImportScalePanel.mCharWidth);
        }
        ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getCaseDescriptor().setCutPoints(this.mCutPoints);
        TextImportStep5Of6Page textImportStep5Of6Page = (TextImportStep5Of6Page)this.mWizardDialog.getWizardModel().getPage("STEP_5_OF_6_PAGE_ID");
        textImportStep5Of6Page.setStepFiveVisited(!this.mFileTextArea.getCutPointsChanged());
        this.validateVariableNames();
        return true;
    }

    @Override
    protected void aboutToHidePanel() {
        if (this.mFileTextArea.getNumCutPoints() > 0) {
            this.mCutPoints = new ArrayList();
            int n = this.mColumnWidth;
            int n2 = Integer.parseInt(this.mFileTextArea.getCutPoint(0).toString()) / n;
            this.mCutPoints.add(n2);
            for (int i = 0; i < this.mFileTextArea.getNumCutPoints(); ++i) {
                boolean bl = false;
                for (Integer n3 : this.mCutPoints) {
                    n2 = Integer.parseInt(this.mFileTextArea.getCutPoint(i).toString()) / n;
                    if (n3 != n2) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.mCutPoints.add(n2);
            }
            ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getCaseDescriptor().setCutPoints(this.mCutPoints);
        } else {
            ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getCaseDescriptor().setCutPoints(this.mFileTextArea.getCutPoints());
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.mKeyHandler);
    }

    @Override
    protected void aboutToShowPanel() {
        if (this.mFirstVisit) {
            this.updateTextArea();
            this.mCutPoints = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getCaseDescriptor().getCutPoints();
        } else {
            this.mCutPoints = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getCaseDescriptor().getCutPoints();
            this.updateTextArea();
        }
        this.mFileTextArea.setLineLocation(this.mCutPoints);
        this.mFileTextArea.setWizardDialog(this.mWizardDialog);
        this.mColumnNumberTextField.getDocument().addDocumentListener(this);
        this.mFileTextArea.setColumnNumberTextField(0);
        this.mFileTextArea.setCurrentVariableWidth(0);
        this.mWizardDialog.enableFinish(((ReadTextDataWizardDlg)this.mWizardDialog).hasStateChangedForFinishButton());
        this.setFocusTraversalPolicy();
        Toolkit.getDefaultToolkit().addAWTEventListener(this.mKeyHandler, 8L);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    private void updateTextArea() {
        LinkedHashMap linkedHashMap;
        TextDac.TextDacData textDacData = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData();
        if (this.mFirstVisit) {
            linkedHashMap = textDacData.getFixedWidthModifiedCaseMap(true);
            this.mFirstVisit = false;
        } else {
            linkedHashMap = textDacData.getFixedWidthModifiedCaseMap(((ReadTextDataWizardDlg)this.mWizardDialog).hasStateChanged());
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = linkedHashMap.values().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(string);
            if (!iterator.hasNext()) continue;
            stringBuffer.append("\n");
        }
        this.mFileTextArea.setText(stringBuffer.toString());
        this.mFileTextArea.setCaretPosition(0);
        this.mFileTextArea.setHighlighter(null);
        this.updateRowNumbers(this.mRowNumbersList, textDacData.getCaseMap().size() - textDacData.getCaseDescriptor().getCaseStartLineNumber() + 1);
    }

    private void updateRowNumbers(JList jList, int n) {
        int n2 = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getCaseDescriptor().getNumLinesRepresentCase();
        ((DefaultListModel)jList.getModel()).setSize(0);
        Integer n3 = 1;
        while (n3 <= n) {
            ((DefaultListModel)jList.getModel()).addElement(n3);
            n3 = n3 + n2;
        }
    }

    private boolean getStepFiveVisitedAction() {
        int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_REMOVE_VAR_NAMES_DATA_FORMAT_WARNING"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
        return n == 1;
    }

    private void initVars() {
        this.mKeyHandler = new GlobalKeyHandler();
        this.mFileTextArea = new TextImportTextArea("");
        this.mRowNumbersList = new JList();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, INSERT_BREAK_BUTTON);
        this.mInsertButton = new JButton(toggleButtonAction);
        this.mInsertButtonAccessibleText = this.mInsertButton.getAccessibleContext().getAccessibleName();
        this.mInsertButton.addActionListener(this);
        this.mInsertButton.getAccessibleContext().setAccessibleDescription("");
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, DELETE_BREAK_BUTTON);
        this.mDeleteButton = new JButton(toggleButtonAction);
        this.mDeleteButtonAccessibleText = this.mDeleteButton.getAccessibleContext().getAccessibleName();
        this.mDeleteButton.addActionListener(this);
        this.mColumnNumberTextField = new IntTextField(0, 100000, true){

            protected String getValueOutOfRangeMessage(int n, int n2) {
                return MessageFormat.format(TextImportFixedWidthStep4Of6Page.this.mWizardDialog.getResString("IDS_TEXT_WIZ_INVALID_COL_NUMBER"), n2, n2);
            }
        };
        this.mColumnNumberTextField.setColumns(4);
        this.mColumnNumberTextField.setEditable(true);
        this.mFileTextArea.addFocusListener(this);
        this.mFileTextArea.getAccessibleContext().addPropertyChangeListener(this);
        this.mDeleteButton.addFocusListener(this);
        this.mInsertButton.addFocusListener(this);
        this.mColumnNumberTextField.addFocusListener((FocusListener)this);
    }

    private void addComponentsToPage() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        Insets insets = new Insets(DialogUtil.getStandardControlInsets().top, DialogUtil.getStandardControlInsets().left, DialogUtil.getStandardControlInsets().bottom, DialogUtil.getStandardControlInsets().right);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mWizardPage, this.setupLabelPanel(), gridBagConstraints, 0, 0, 1, 1, n, null);
        JSeparator jSeparator = new JSeparator();
        DialogUtil.addUsingGBL(this.mWizardPage, jSeparator, gridBagConstraints, 0, 1, 2, 1, n, new Insets(0, 4, 0, 0));
        Insets insets2 = new Insets(insets.top + 10, 0, 0, 0);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(this.mWizardPage, this.setupDataPreviewPanel(), gridBagConstraints, 0, 2, 2, 1, n, insets2);
        insets2.set(insets.top + 10, 0, 0, 0);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(this.mWizardPage, this.setupInsertDeleteCutPointsPanel(), gridBagConstraints, 0, 3, 1, 1, n, insets2);
    }

    private JPanel setupDataPreviewPanel() {
        int n;
        Object object2;
        this.mRulerLabel = new JLabel(this.mWizardDialog.getResString(RULER_LABEL));
        this.mRulerLabel.setDisplayedMnemonic(this.mWizardDialog.getDlgAccessKey("IDK_RTD_RULER_LABEL_KEY"));
        this.mRulerLabel.getAccessibleContext().setAccessibleName(this.mRulerLabel.getAccessibleContext().getAccessibleName() + "," + this.mWizardDialog.getResString(COLUMN_NAME) + "0");
        Font font = new Font("SansSerif", 0, 10);
        this.mRulerLabel.setFont(font);
        Font font2 = new Font("monospaced", 0, 12);
        this.mFileTextArea.setLineWrap(false);
        this.mFileTextArea.setEditable(false);
        this.mFileTextArea.setFocusable(true);
        this.mFileTextArea.setFont(font2);
        this.mFileTextArea.setRows(4);
        FontMetrics fontMetrics = this.mFileTextArea.getFontMetrics(this.mFileTextArea.getFont());
        int n2 = fontMetrics.getHeight();
        this.mColumnWidth = fontMetrics.charWidth('0');
        LinkedHashMap linkedHashMap = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getCaseMap();
        for (Object object2 : linkedHashMap.values()) {
            n = ((String)object2).length();
            if (this.mMaxNoOfCharsLine >= n) continue;
            this.mMaxNoOfCharsLine = n;
        }
        ReadTextDataWizardDlg cfr_ignored_0 = (ReadTextDataWizardDlg)this.mWizardDialog;
        ReadTextDataWizardDlg.initRowNumberList(this.mRowNumbersList, this.mFileTextArea, new ReadTextDataWizardDlg.NumberListCellRenderer(this.mFileTextArea.getFont()));
        this.mScalePanel = new TextImportScalePanel(this.mColumnWidth, this.mMaxNoOfCharsLine, this.mFileTextArea);
        this.mRulerLabel.setLabelFor(this.mScalePanel);
        this.mScalePanel.setPreferredSize(new Dimension(2147482647, 25));
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(true);
        object2 = new JPanel(new GridBagLayout());
        ((JComponent)object2).setPreferredSize(new Dimension(2147482647, 33));
        n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n, n, n, n);
        int n3 = 23;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL((Container)object2, this.mScalePanel, gridBagConstraints, 0, 0, 1, 1, n3, null);
        DialogUtil.addUsingGBL((Container)object2, jPanel, gridBagConstraints, 0, 1, 1, 1, n3, null);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setOpaque(true);
        jPanel3.setMinimumSize(new Dimension(15, 125));
        DialogUtil.addUsingGBL(jPanel2, jPanel3, gridBagConstraints, 1, 0, 1, 1, n3, null);
        DialogUtil.addUsingGBL(jPanel2, this.mRowNumbersList, gridBagConstraints, 0, 0, 1, 1, n3, null);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel4, this.mRulerLabel, gridBagConstraints, 0, 0, 1, 1, n3, new Insets(3, 0, 0, 2));
        DialogUtil.addUsingGBL(jPanel4, new JLabel(" "), gridBagConstraints, 0, 1, 1, 1, n3, null);
        JScrollPane jScrollPane = new JScrollPane(this.mFileTextArea);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setCorner("UPPER_LEFT_CORNER", jPanel4);
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            jScrollPane.setCorner("LOWER_LEFT_CORNER", new JPanel());
            jScrollPane.setCorner("UPPER_RIGHT_CORNER", new JPanel());
            jScrollPane.setCorner("LOWER_RIGHT_CORNER", new JPanel());
        }
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        DialogUtil.addUsingGBL(jPanel5, jScrollPane, gridBagConstraints, 1, 1, 1, 1, n3, insets);
        jScrollPane.setColumnHeaderView((Component)object2);
        jScrollPane.setRowHeaderView(jPanel2);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setWheelScrollingEnabled(false);
        JPanel jPanel6 = new JPanel(new GridBagLayout());
        jPanel6.setPreferredSize(new Dimension(100, 133));
        jPanel6.setMinimumSize(jPanel6.getPreferredSize());
        DialogUtil.addUsingGBL(jPanel6, jPanel5, gridBagConstraints, 0, 0, 1, 1, n3, null);
        this.mScalePanel.addFocusListener(this);
        this.mFileTextArea.setScalePanel(this.mScalePanel);
        return jPanel6;
    }

    private JPanel setupInsertDeleteCutPointsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder());
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString(COLUMN_NUMBER_LABEL));
        jLabel.setDisplayedMnemonic(this.mWizardDialog.getDlgAccessKey("IDK_RTD_COLUMN_NUMBER_KEY"));
        jLabel.setLabelFor((Component)this.mColumnNumberTextField);
        JLabel jLabel2 = new JLabel(this.mWizardDialog.getResString(CURRENT_VARIABLE_LABEL));
        jLabel2.setDisplayedMnemonic(this.mWizardDialog.getDlgAccessKey("IDK_RTD_CURR_VAR_WIDTH_KEY"));
        this.mCurrentVariableWidthLabel = new JTextArea();
        this.mCurrentVariableWidthLabel.setOpaque(false);
        this.mCurrentVariableWidthLabel.setLineWrap(true);
        this.mCurrentVariableWidthLabel.setWrapStyleWord(true);
        this.mCurrentVariableWidthLabel.setFocusable(false);
        this.mCurrentVariableWidthLabel.setMinimumSize(new Dimension(300, 40));
        this.mCurrentVariableWidthLabel.setPreferredSize(new Dimension(300, 40));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(DialogUtil.getStandardControlInsets().top, DialogUtil.getStandardControlInsets().left + 25, DialogUtil.getStandardControlInsets().bottom + 10, DialogUtil.getStandardControlInsets().right + 10);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(DialogUtil.getStandardControlInsets().top, DialogUtil.getStandardControlInsets().left + 15, DialogUtil.getStandardControlInsets().bottom + 10, DialogUtil.getStandardControlInsets().right + 10);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mColumnNumberTextField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mInsertButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel2, this.mDeleteButton, gridBagConstraints, 3, 0, 1, 1, n, insets);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(DialogUtil.getStandardControlInsets().top, DialogUtil.getStandardControlInsets().left + 25, DialogUtil.getStandardControlInsets().bottom + 10, DialogUtil.getStandardControlInsets().right + 10);
        DialogUtil.addUsingGBL(jPanel3, jLabel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(DialogUtil.getStandardControlInsets().top, DialogUtil.getStandardControlInsets().left + 20, DialogUtil.getStandardControlInsets().bottom + 10, DialogUtil.getStandardControlInsets().right + 10);
        gridBagConstraints.weightx = 1.0;
        n = 23;
        insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel3, this.mCurrentVariableWidthLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, null);
        return jPanel;
    }

    private JPanel setupLabelPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString(MOVE_LABEL));
        JTextArea jTextArea = new JTextArea(this.mWizardDialog.getResString(INSERT_LABEL));
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFocusable(false);
        jTextArea.setRows(3);
        jTextArea.setMinimumSize(new Dimension(160, 30));
        jTextArea.setPreferredSize(new Dimension(160, 30));
        JTextArea jTextArea2 = new JTextArea(this.mWizardDialog.getResString(DELETE_LABEL));
        jTextArea2.setOpaque(false);
        jTextArea2.setLineWrap(true);
        jTextArea2.setWrapStyleWord(true);
        jTextArea2.setFocusable(false);
        jTextArea2.setRows(3);
        jTextArea2.setMinimumSize(new Dimension(160, 30));
        jTextArea2.setPreferredSize(new Dimension(160, 30));
        JLabel jLabel2 = new JLabel(this.mWizardDialog.getResString(SPECIFY_LABEL));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin() + 15, 0, DialogUtil.getStandardControlInsets().right);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(DialogUtil.getStandardControlInsets().top + 10, DialogUtil.getGroupBoxInnerMargin() + 15, 0, DialogUtil.getStandardControlInsets().right);
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 1, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jTextArea2, gridBagConstraints, 0, 3, 1, 1, n, insets);
        return jPanel;
    }

    private void validateVariableNames() {
        boolean bl = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getCaseDescriptor().isReadFromTPF();
        boolean bl2 = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getCaseDescriptor().isTPFModified();
        if (!bl || bl2) {
            int n;
            Vector vector = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getVariableDescriptors(this.mValidateVarNames || ((ReadTextDataWizardDlg)this.mWizardDialog).hasStateChanged());
            Vector<String> vector2 = new Vector<String>();
            for (n = 0; n < vector.size(); ++n) {
                vector2.add(n, ((VariableDescriptor)vector.get(n)).getModifiedVarName());
            }
            this.mVarNamesChanged = VarNameValidator.generateSPSSNameForDac(vector2, (boolean)true);
            if (this.mVarNamesChanged) {
                for (n = 0; n < vector2.size(); ++n) {
                    ((VariableDescriptor)vector.get(n)).setModifiedVarName((String)vector2.get(n));
                }
            }
            this.mValidateVarNames = false;
        }
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mScalePanel);
        vector.add(this.mFileTextArea);
        vector.add(this.mColumnNumberTextField);
        vector.add(this.mInsertButton);
        vector.add(this.mDeleteButton);
        Vector<Object> vector2 = ((ReadTextDataWizardDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mWizardDialog.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector2, false));
    }

    private class GlobalKeyHandler
    extends KeyAdapter
    implements AWTEventListener {
        private GlobalKeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Component component;
            boolean bl = OSInfo.getOSType() == OSInfo.OSType.MAC;
            final int n = keyEvent.getKeyCode();
            if (!(bl || n != 83 && n != 68 || (component = FocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == null || component != TextImportFixedWidthStep4Of6Page.this.mColumnNumberTextField && component != TextImportFixedWidthStep4Of6Page.this.mScalePanel && component != TextImportFixedWidthStep4Of6Page.this.mFileTextArea)) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        JButton jButton = n == 83 ? TextImportFixedWidthStep4Of6Page.this.mInsertButton : TextImportFixedWidthStep4Of6Page.this.mDeleteButton;
                        try {
                            Switchboard.click((Component)jButton);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        component.requestFocus();
                    }
                };
                SwingUtilities.invokeLater(runnable);
                keyEvent.consume();
            }
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            if (aWTEvent.getID() == 401) {
                this.keyPressed((KeyEvent)aWTEvent);
            }
            if (aWTEvent.getID() == 402) {
                this.keyReleased((KeyEvent)aWTEvent);
            }
            if (aWTEvent.getID() == 400) {
                this.keyTyped((KeyEvent)aWTEvent);
            }
        }
    }
}

