/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.read_text_data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.data_access.text.CaseDescriptor;
import com.spss.java_client.core.documents.data.data_access.text.VariableDescriptor;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.ReadTextDataWizardDlg;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.TextImportStep2Of6Page;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.TextImportStep5Of6Page;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class TextImportDelimitedStep4Of6Page
extends AbstractWizardPage
implements ItemListener,
DocumentListener {
    static final String DATA_PREVIEW_PANEL_BORDER = "IDS_RTD_DATA_PREVIEW";
    static final String DELIMITED_STEP_FOUR_TITLE = "IDS_RTD_DELIMITED_STEP_FOUR";
    static final String WHICH_DELIM_BET_VARS_PANEL_TITLE = "IDS_RTD_WHICH_DELIMITERS_BET_VARS";
    static final String TAB_CHECK = "IDS_RTD_TAB_CHECK";
    static final String COMMA_CHECK = "IDS_RTD_COMMA_CHECK";
    static final String SPACE_CHECK = "IDS_RTD_SPACE_CHECK";
    static final String SEMICOLON_CHECK = "IDS_RTD_SEMICOLON_CHECK";
    static final String OTHER_CHECK = "IDS_RTD_OTHER_CHECK";
    static final String NONE_RADIO = "IDS_RTD_NONE_RADIO";
    static final String SINGLE_QUOTE_RADIO = "IDS_RTD_SINGLE_QUOTE_RADIO";
    static final String DOUBLE_QUOTE_RADIO = "IDS_RTD_DOUBLE_QUOTE_RADIO";
    static final String OTHER_RADIO = "IDS_RTD_OTHER_RADIO";
    static final String WHICH_TEXT_QUALIFIER_PANEL_TITLE = "IDS_RTD_WHICH_TEXT_QUALIFIER";
    static final String DELIMITED_STEP_4_OF_6_PAGE_ID = "DELIMITED_STEP_4_OF_6_PAGE_ID";
    private JCheckBox mTabCheck;
    private JCheckBox mCommaCheck;
    private JCheckBox mRemoveLeadingSpacesCB;
    private JCheckBox mRemoveTrailingSpacesCB;
    private JCheckBox mSpaceCheck;
    private JCheckBox mSemicolonCheck;
    private JCheckBox mOtherCheck;
    private JRadioButton mNoneRadio;
    private JRadioButton mSingleQuoteRadio;
    private JRadioButton mDoubleQuoteRadio;
    private JRadioButton mOtherRadio;
    private SpssButtonGroup mTextQualifierButtonGrp;
    private StringTextField mDelimiterText;
    private StringTextField mQualifierText;
    private JTable mDataPreviewTable;
    private JScrollPane mTableScroll;
    private boolean mVarNamesChanged;
    private boolean mNoneRadioWasSelected;
    private boolean mSingleQuoteRadioWasSelected;
    private boolean mDoubleQuoteRadioWasSelected;
    private boolean mOtherRadioWasSelected;
    private boolean mFirstVisit = true;
    private boolean mDeselectCommaDoneOnce = false;
    private int[] mLastSelectedCols;

    TextImportDelimitedStep4Of6Page(BaseWizardDialog baseWizardDialog) {
        super(DELIMITED_STEP_4_OF_6_PAGE_ID, baseWizardDialog.getResString(DELIMITED_STEP_FOUR_TITLE), baseWizardDialog, true);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        ((ReadTextDataWizardDlg)this.mWizardDialog).setStateChangedForFinishButton(false);
        this.mWizardDialog.enableFinish(((ReadTextDataWizardDlg)this.mWizardDialog).hasStateChangedForFinishButton());
        CaseDescriptor caseDescriptor = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getCaseDescriptor();
        if (documentEvent.getDocument().equals(this.mDelimiterText.getDocument())) {
            if (this.mDelimiterText.getText().length() == 0) {
                caseDescriptor.setOtherDelimiter(null);
            } else {
                caseDescriptor.setOtherDelimiter(this.mDelimiterText.getText());
            }
            this.updateTable(true);
        }
        if (documentEvent.getDocument().equals(this.mQualifierText.getDocument())) {
            if (this.mQualifierText.getText().length() > 1) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_ONLY_ONE_QUALIFIER_WARNING"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TextImportDelimitedStep4Of6Page.this.mQualifierText.getDocument().removeDocumentListener(TextImportDelimitedStep4Of6Page.this);
                        TextImportDelimitedStep4Of6Page.this.mQualifierText.setText("" + TextImportDelimitedStep4Of6Page.this.mQualifierText.getText().toCharArray()[0]);
                        TextImportDelimitedStep4Of6Page.this.mQualifierText.getDocument().addDocumentListener(TextImportDelimitedStep4Of6Page.this);
                    }
                });
            } else if (this.mQualifierText.getText().length() != 0) {
                if (this.mDelimiterText.getText().equals(this.mQualifierText.getText())) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_USED_DELIMITER_WARNING"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TextImportDelimitedStep4Of6Page.this.mQualifierText.getDocument().removeDocumentListener(TextImportDelimitedStep4Of6Page.this);
                            TextImportDelimitedStep4Of6Page.this.mQualifierText.setText("" + TextImportDelimitedStep4Of6Page.this.mQualifierText.getText().toCharArray()[0]);
                            TextImportDelimitedStep4Of6Page.this.mQualifierText.getDocument().addDocumentListener(TextImportDelimitedStep4Of6Page.this);
                            TextImportDelimitedStep4Of6Page.this.mQualifierText.requestFocus();
                            TextImportDelimitedStep4Of6Page.this.mQualifierText.selectAll();
                        }
                    });
                } else if (Character.isSpaceChar(this.mQualifierText.getText().toCharArray()[0])) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_USED_DELIMITER_WARNING"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TextImportDelimitedStep4Of6Page.this.mQualifierText.getDocument().removeDocumentListener(TextImportDelimitedStep4Of6Page.this);
                            TextImportDelimitedStep4Of6Page.this.mQualifierText.setText("");
                            TextImportDelimitedStep4Of6Page.this.mQualifierText.getDocument().addDocumentListener(TextImportDelimitedStep4Of6Page.this);
                            TextImportDelimitedStep4Of6Page.this.mQualifierText.requestFocus();
                            TextImportDelimitedStep4Of6Page.this.mQualifierText.selectAll();
                        }
                    });
                } else {
                    caseDescriptor.setOtherQualifier(this.mQualifierText.getText());
                }
            } else if (this.mQualifierText.getText().length() == 0) {
                caseDescriptor.setOtherQualifier(null);
            }
        }
        this.updateTable(true);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        CaseDescriptor caseDescriptor = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getCaseDescriptor();
        if (documentEvent.equals(this.mDelimiterText)) {
            caseDescriptor.setOtherDelimiter(this.mDelimiterText.getText());
        }
        if (documentEvent.equals(this.mQualifierText)) {
            if (this.mQualifierText.getText().length() > 1) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_ONLY_ONE_QUALIFIER_WARNING"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"));
                this.mQualifierText.setText("");
            }
            caseDescriptor.setOtherQualifier(this.mQualifierText.getText());
        }
        this.updateTable(true);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        boolean bl = itemEvent.getStateChange() == 1;
        CaseDescriptor caseDescriptor = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getCaseDescriptor();
        TextImportStep5Of6Page textImportStep5Of6Page = (TextImportStep5Of6Page)this.mWizardDialog.getWizardModel().getPage("STEP_5_OF_6_PAGE_ID");
        boolean bl2 = true;
        if (object.equals(this.mTabCheck)) {
            if (textImportStep5Of6Page.isStepFiveVisited()) {
                if (1 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_REMOVE_VAR_NAMES_DATA_FORMAT_WARNING"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"), SpssAlertOptionPane.OptionType.YES_NO_OPTION)) {
                    caseDescriptor.setIsTabDelim(bl);
                    textImportStep5Of6Page.setStepFiveVisited(false);
                    this.setStateChangedForFinishButton();
                } else {
                    bl2 = false;
                    this.mTabCheck.removeItemListener(this);
                    this.mTabCheck.setSelected(!bl);
                    this.mTabCheck.addItemListener(this);
                }
            } else {
                caseDescriptor.setIsTabDelim(bl);
            }
        }
        if (object.equals(this.mSpaceCheck)) {
            if (textImportStep5Of6Page.isStepFiveVisited()) {
                if (1 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_REMOVE_VAR_NAMES_DATA_FORMAT_WARNING"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"), SpssAlertOptionPane.OptionType.YES_NO_OPTION)) {
                    caseDescriptor.setIsSpaceDelim(bl);
                    textImportStep5Of6Page.setStepFiveVisited(false);
                    this.setStateChangedForFinishButton();
                } else {
                    bl2 = false;
                    this.mSpaceCheck.removeItemListener(this);
                    this.mSpaceCheck.setSelected(!bl);
                    this.mSpaceCheck.addItemListener(this);
                }
            } else {
                caseDescriptor.setIsSpaceDelim(bl);
            }
        }
        if (object.equals(this.mCommaCheck)) {
            if (textImportStep5Of6Page.isStepFiveVisited()) {
                if (1 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_REMOVE_VAR_NAMES_DATA_FORMAT_WARNING"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"), SpssAlertOptionPane.OptionType.YES_NO_OPTION)) {
                    caseDescriptor.setIsCommaDelim(bl);
                    textImportStep5Of6Page.setStepFiveVisited(false);
                    this.setStateChangedForFinishButton();
                } else {
                    bl2 = false;
                    this.mCommaCheck.removeItemListener(this);
                    this.mCommaCheck.setSelected(!bl);
                    this.mCommaCheck.addItemListener(this);
                }
            } else {
                caseDescriptor.setIsCommaDelim(bl);
            }
        }
        if (object.equals(this.mSemicolonCheck)) {
            if (textImportStep5Of6Page.isStepFiveVisited()) {
                if (1 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_REMOVE_VAR_NAMES_DATA_FORMAT_WARNING"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"), SpssAlertOptionPane.OptionType.YES_NO_OPTION)) {
                    caseDescriptor.setIsSemiColonDelim(bl);
                    textImportStep5Of6Page.setStepFiveVisited(false);
                    this.setStateChangedForFinishButton();
                } else {
                    bl2 = false;
                    this.mSemicolonCheck.removeItemListener(this);
                    this.mSemicolonCheck.setSelected(!bl);
                    this.mSemicolonCheck.addItemListener(this);
                }
            } else {
                caseDescriptor.setIsSemiColonDelim(bl);
            }
        }
        if (object.equals(this.mOtherCheck)) {
            this.mOtherCheck.removeItemListener(this);
            if (textImportStep5Of6Page.isStepFiveVisited()) {
                if (1 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_REMOVE_VAR_NAMES_DATA_FORMAT_WARNING"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"), SpssAlertOptionPane.OptionType.YES_NO_OPTION)) {
                    caseDescriptor.setIsOtherDelim(bl);
                    this.mDelimiterText.setEnabled(bl);
                    this.mDelimiterText.setOpaque(bl);
                    if (!bl) {
                        caseDescriptor.setOtherDelimiter(null);
                        this.mDelimiterText.setText("");
                    }
                    textImportStep5Of6Page.setStepFiveVisited(false);
                    this.mOtherCheck.setSelected(bl);
                } else {
                    bl2 = false;
                    this.mOtherCheck.setSelected(!bl);
                }
            } else {
                caseDescriptor.setIsOtherDelim(bl);
                this.mDelimiterText.setEnabled(bl);
                this.mDelimiterText.setOpaque(bl);
                if (!bl) {
                    caseDescriptor.setOtherDelimiter(null);
                    this.mDelimiterText.setText("");
                }
            }
            this.mOtherCheck.addItemListener(this);
        } else if (object.equals(this.mNoneRadio) && bl) {
            if (textImportStep5Of6Page.isStepFiveVisited()) {
                if (1 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_REMOVE_VAR_NAMES_DATA_FORMAT_WARNING"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"), SpssAlertOptionPane.OptionType.YES_NO_OPTION)) {
                    caseDescriptor.setIsSingleQuoteQualifier(false);
                    caseDescriptor.setIsDoubleQuoteQualifier(false);
                    caseDescriptor.setIsOtherQualifier(false);
                    textImportStep5Of6Page.setStepFiveVisited(false);
                    this.mNoneRadioWasSelected = true;
                    this.mSingleQuoteRadioWasSelected = false;
                    this.mDoubleQuoteRadioWasSelected = false;
                    this.mOtherRadioWasSelected = false;
                    this.setStateChangedForFinishButton();
                } else {
                    this.loadPreviousStateOfRadioButtons();
                    bl2 = false;
                }
            } else {
                caseDescriptor.setIsSingleQuoteQualifier(false);
                caseDescriptor.setIsDoubleQuoteQualifier(false);
                caseDescriptor.setIsOtherQualifier(false);
            }
        } else if (object.equals(this.mSingleQuoteRadio) && bl) {
            if (textImportStep5Of6Page.isStepFiveVisited()) {
                if (1 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_REMOVE_VAR_NAMES_DATA_FORMAT_WARNING"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"), SpssAlertOptionPane.OptionType.YES_NO_OPTION)) {
                    caseDescriptor.setIsSingleQuoteQualifier(bl);
                    caseDescriptor.setIsDoubleQuoteQualifier(!bl);
                    caseDescriptor.setIsOtherQualifier(!bl);
                    textImportStep5Of6Page.setStepFiveVisited(false);
                    this.mNoneRadioWasSelected = false;
                    this.mSingleQuoteRadioWasSelected = true;
                    this.mDoubleQuoteRadioWasSelected = false;
                    this.mOtherRadioWasSelected = false;
                    this.setStateChangedForFinishButton();
                } else {
                    this.loadPreviousStateOfRadioButtons();
                    bl2 = false;
                }
            } else {
                caseDescriptor.setIsSingleQuoteQualifier(bl);
                caseDescriptor.setIsDoubleQuoteQualifier(!bl);
                caseDescriptor.setIsOtherQualifier(!bl);
            }
        } else if (object.equals(this.mDoubleQuoteRadio) && bl) {
            if (textImportStep5Of6Page.isStepFiveVisited()) {
                if (1 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_REMOVE_VAR_NAMES_DATA_FORMAT_WARNING"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"), SpssAlertOptionPane.OptionType.YES_NO_OPTION)) {
                    caseDescriptor.setIsSingleQuoteQualifier(!bl);
                    caseDescriptor.setIsDoubleQuoteQualifier(bl);
                    caseDescriptor.setIsOtherQualifier(!bl);
                    textImportStep5Of6Page.setStepFiveVisited(false);
                    this.mNoneRadioWasSelected = false;
                    this.mSingleQuoteRadioWasSelected = false;
                    this.mDoubleQuoteRadioWasSelected = true;
                    this.mOtherRadioWasSelected = false;
                    this.setStateChangedForFinishButton();
                } else {
                    this.loadPreviousStateOfRadioButtons();
                    bl2 = false;
                }
            } else {
                caseDescriptor.setIsSingleQuoteQualifier(!bl);
                caseDescriptor.setIsDoubleQuoteQualifier(bl);
                caseDescriptor.setIsOtherQualifier(!bl);
            }
        } else if (object.equals(this.mOtherRadio)) {
            if (bl) {
                if (textImportStep5Of6Page.isStepFiveVisited()) {
                    if (1 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_REMOVE_VAR_NAMES_DATA_FORMAT_WARNING"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"), SpssAlertOptionPane.OptionType.YES_NO_OPTION)) {
                        caseDescriptor.setIsSingleQuoteQualifier(!bl);
                        caseDescriptor.setIsDoubleQuoteQualifier(!bl);
                        caseDescriptor.setIsOtherQualifier(bl);
                        this.mQualifierText.setEnabled(bl);
                        this.mQualifierText.setOpaque(bl);
                        textImportStep5Of6Page.setStepFiveVisited(false);
                        this.mNoneRadioWasSelected = false;
                        this.mSingleQuoteRadioWasSelected = false;
                        this.mDoubleQuoteRadioWasSelected = false;
                        this.mOtherRadioWasSelected = true;
                    } else {
                        this.loadPreviousStateOfRadioButtons();
                        bl2 = false;
                    }
                } else {
                    caseDescriptor.setIsSingleQuoteQualifier(!bl);
                    caseDescriptor.setIsDoubleQuoteQualifier(!bl);
                    caseDescriptor.setIsOtherQualifier(bl);
                    this.mQualifierText.setEnabled(bl);
                    this.mQualifierText.setOpaque(bl);
                }
            } else {
                this.mQualifierText.setEnabled(bl);
                this.mQualifierText.setOpaque(bl);
                caseDescriptor.setIsOtherQualifier(false);
                caseDescriptor.setOtherQualifier(null);
                this.mQualifierText.setText("");
            }
        }
        if (!object.equals(this.mOtherCheck) && !object.equals(this.mOtherRadio)) {
            if (object.equals(this.mNoneRadio) || object.equals(this.mSingleQuoteRadio) || object.equals(this.mDoubleQuoteRadio)) {
                if (bl) {
                    this.updateTable(bl2);
                }
            } else {
                this.updateTable(bl2);
            }
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_text_wizard_step4_delimited";
    }

    @Override
    public boolean validate() {
        if (this.mOtherCheck.isSelected() && this.mDelimiterText.getText().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_EMPTY_DELIM_WARNING"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"));
            this.mDelimiterText.requestFocus();
            return false;
        }
        if (this.mOtherRadio.isSelected() && this.mQualifierText.getText().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_EMPTY_QUAL_WARNING"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"));
            this.mQualifierText.requestFocus();
            return false;
        }
        if (this.mOtherCheck.isSelected() && this.mOtherRadio.isSelected() && this.mDelimiterText.getText().equals(this.mQualifierText.getText())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_USED_DELIMITER_WARNING"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"));
            this.mQualifierText.requestFocus();
            return false;
        }
        TextImportStep2Of6Page textImportStep2Of6Page = (TextImportStep2Of6Page)this.mWizardDialog.getWizardModel().getPage("STEP_2_OF_6_PAGE_ID");
        if (this.mCommaCheck.isSelected() && textImportStep2Of6Page.isDecimalSymbolCommaSelected() && 3 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("IDS_RTD_SELECTED_COMMA_AS_BOTH_DECIMAL_AND_DELIMETER_ERROR"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
            this.mCommaCheck.requestFocus();
            return false;
        }
        this.validateVariableNames();
        return true;
    }

    @Override
    public boolean validateOnBack() {
        if (this.mOtherCheck.isSelected() && this.mDelimiterText.getText().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_EMPTY_DELIM_WARNING"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"));
            this.mDelimiterText.requestFocus();
            return false;
        }
        if (this.mOtherRadio.isSelected() && this.mQualifierText.getText().length() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_EMPTY_QUAL_WARNING"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"));
            this.mQualifierText.requestFocus();
            return false;
        }
        if (this.mOtherCheck.isSelected() && this.mOtherRadio.isSelected() && this.mDelimiterText.getText().equals(this.mQualifierText.getText())) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_RTD_USED_DELIMITER_WARNING"), this.mWizardDialog.getResString("IDS_RTD_WARNING_TITLE"));
            this.mQualifierText.requestFocus();
            return false;
        }
        return true;
    }

    @Override
    public void init() {
        this.initVars();
        this.setDefaults();
        this.addListeners();
        this.addComponentsToPage();
    }

    @Override
    public String getNextPage() {
        return "STEP_5_OF_6_PAGE_ID";
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    public boolean isVarNamesChanged() {
        return this.mVarNamesChanged;
    }

    public void setVarNamesChanged(boolean bl) {
        this.mVarNamesChanged = bl;
    }

    @Override
    protected void aboutToShowPanel() {
        this.removeListeners();
        this.setRadioButtonFlags();
        this.loadPageFromTextDacData();
        this.addListeners();
        this.mWizardDialog.enableFinish(((ReadTextDataWizardDlg)this.mWizardDialog).hasStateChangedForFinishButton());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TextImportDelimitedStep4Of6Page.this.mDataPreviewTable.getModel().getRowCount() != 0) {
                    TextImportDelimitedStep4Of6Page.this.addColumnSelectionInterval(1, 1);
                    TextImportDelimitedStep4Of6Page.this.setAnchorCell(1, 0);
                    TextImportDelimitedStep4Of6Page.this.setLeadCell(1, 0);
                }
            }
        });
        this.setFocusTraversalPolicy();
    }

    private void setAnchorCell(int n, int n2) {
        this.mDataPreviewTable.getColumnModel().getSelectionModel().setAnchorSelectionIndex(n);
        this.mDataPreviewTable.getSelectionModel().setAnchorSelectionIndex(n2);
    }

    private void setLeadCell(int n, int n2) {
        this.mDataPreviewTable.getColumnModel().getSelectionModel().setLeadSelectionIndex(n);
        this.mDataPreviewTable.getSelectionModel().setLeadSelectionIndex(n2);
    }

    void setStateChangedForFinishButton() {
        ((ReadTextDataWizardDlg)this.mWizardDialog).setStateChangedForFinishButton(false);
        this.mWizardDialog.enableFinish(((ReadTextDataWizardDlg)this.mWizardDialog).hasStateChangedForFinishButton());
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mTabCheck);
        vector.add(this.mCommaCheck);
        vector.add(this.mSpaceCheck);
        vector.add(this.mSemicolonCheck);
        vector.add(this.mOtherCheck);
        vector.add(this.mRemoveLeadingSpacesCB);
        vector.add(this.mRemoveTrailingSpacesCB);
        vector.add(this.mDelimiterText);
        vector.add(this.mTextQualifierButtonGrp);
        vector.add(this.mQualifierText);
        vector.add(this.mDataPreviewTable);
        Vector<Object> vector2 = ((ReadTextDataWizardDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mWizardDialog.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(vector2, false));
    }

    private void addListeners() {
        this.mTabCheck.addItemListener(this);
        this.mCommaCheck.addItemListener(this);
        this.mSemicolonCheck.addItemListener(this);
        this.mSpaceCheck.addItemListener(this);
        this.mOtherCheck.addItemListener(this);
        this.mNoneRadio.addItemListener(this);
        this.mSingleQuoteRadio.addItemListener(this);
        this.mDoubleQuoteRadio.addItemListener(this);
        this.mOtherRadio.addItemListener(this);
        this.mDelimiterText.getDocument().addDocumentListener(this);
        this.mQualifierText.getDocument().addDocumentListener(this);
    }

    private void removeListeners() {
        this.mTabCheck.removeItemListener(this);
        this.mCommaCheck.removeItemListener(this);
        this.mSemicolonCheck.removeItemListener(this);
        this.mSpaceCheck.removeItemListener(this);
        this.mOtherCheck.removeItemListener(this);
        this.mNoneRadio.removeItemListener(this);
        this.mSingleQuoteRadio.removeItemListener(this);
        this.mDoubleQuoteRadio.removeItemListener(this);
        this.mOtherRadio.removeItemListener(this);
        this.mDelimiterText.getDocument().removeDocumentListener(this);
        this.mQualifierText.getDocument().removeDocumentListener(this);
    }

    private void loadPageFromTextDacData() {
        boolean bl;
        CaseDescriptor caseDescriptor = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getCaseDescriptor();
        TextImportStep2Of6Page textImportStep2Of6Page = (TextImportStep2Of6Page)this.mWizardDialog.getWizardModel().getPage("STEP_2_OF_6_PAGE_ID");
        if (caseDescriptor.isSingleQuoteQualifier()) {
            this.mSingleQuoteRadio.setSelected(true);
        } else if (caseDescriptor.isDoubleQuoteQualifier()) {
            this.mDoubleQuoteRadio.setSelected(true);
        } else if (caseDescriptor.isOtherQualifier()) {
            this.mOtherRadio.setSelected(true);
            this.mQualifierText.setEnabled(true);
            this.mQualifierText.setOpaque(true);
            this.mQualifierText.setText(caseDescriptor.getOtherQualifier());
        } else {
            this.mNoneRadio.setSelected(true);
            this.mQualifierText.setEnabled(false);
            this.mQualifierText.setOpaque(false);
            this.mQualifierText.setText("");
        }
        if (caseDescriptor.isTabDelim()) {
            this.mTabCheck.setSelected(true);
            this.mTabCheck.requestFocus();
        } else {
            this.mTabCheck.setSelected(false);
        }
        if (caseDescriptor.isCommaDelim()) {
            if (this.mFirstVisit && caseDescriptor.isReadFromTPF()) {
                this.mCommaCheck.setSelected(caseDescriptor.isCommaDelim());
            } else if (textImportStep2Of6Page.isDecimalSymbolCommaSelected() && !this.mDeselectCommaDoneOnce) {
                this.mDeselectCommaDoneOnce = true;
                caseDescriptor.setIsCommaDelim(false);
                this.mCommaCheck.setSelected(false);
            } else {
                this.mCommaCheck.setSelected(true);
            }
            this.mCommaCheck.requestFocus();
        } else {
            this.mCommaCheck.setSelected(false);
        }
        if (caseDescriptor.isSpaceDelim()) {
            this.mSpaceCheck.setSelected(true);
            this.mSpaceCheck.requestFocus();
        } else {
            this.mSpaceCheck.setSelected(false);
        }
        if (caseDescriptor.isSemiColonDelim()) {
            this.mSemicolonCheck.setSelected(true);
            this.mSemicolonCheck.requestFocus();
        } else {
            this.mSemicolonCheck.setSelected(false);
        }
        if (caseDescriptor.isOtherDelim()) {
            if (caseDescriptor.getOtherDelimiter() != null && !caseDescriptor.getOtherDelimiter().equals("")) {
                this.mOtherCheck.setSelected(true);
                this.mOtherCheck.requestFocus();
                this.mDelimiterText.setEnabled(true);
                this.mDelimiterText.setOpaque(true);
                this.mDelimiterText.setText(caseDescriptor.getOtherDelimiter());
            }
        } else {
            this.mOtherCheck.setSelected(false);
            this.mDelimiterText.setEnabled(false);
            this.mDelimiterText.setOpaque(false);
            this.mDelimiterText.setText("");
        }
        this.mRemoveLeadingSpacesCB.setSelected(caseDescriptor.isStripLeadingSpaces());
        this.mRemoveTrailingSpacesCB.setSelected(caseDescriptor.isStripTrailingSpaces());
        if (caseDescriptor.isReadFromTPF()) {
            bl = ((ReadTextDataWizardDlg)this.mWizardDialog).hasStateChanged();
        } else if (this.mFirstVisit) {
            this.mFirstVisit = false;
            bl = true;
        } else {
            bl = ((ReadTextDataWizardDlg)this.mWizardDialog).hasStateChanged();
        }
        this.updateTable(bl);
    }

    private void updateTable(boolean bl) {
        int n;
        int n2;
        Vector vector;
        VariableDescriptor variableDescriptor;
        CaseDescriptor caseDescriptor = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getCaseDescriptor();
        Vector vector2 = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getVariableDescriptors(bl);
        DefaultTableModel defaultTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Iterator iterator = vector2.iterator();
        while (iterator.hasNext()) {
            VariableDescriptor variableDescriptor2;
            variableDescriptor = variableDescriptor2 = (VariableDescriptor)iterator.next();
            vector = variableDescriptor.getVarData();
            treeSet.add(vector.size());
        }
        defaultTableModel.setRowCount(Math.min((Integer)treeSet.last(), ReadTextDataWizardDlg.getNumDisplayLines()));
        for (n2 = 0; n2 < 1; ++n2) {
            int n3 = 0;
            defaultTableModel.addColumn("   ");
            for (n = 0; n < defaultTableModel.getRowCount(); ++n) {
                defaultTableModel.setValueAt(++n3, n, n2);
            }
        }
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            String string;
            variableDescriptor = (VariableDescriptor)vector2.get(n2);
            String string2 = string = variableDescriptor.getModifiedVarName().length() == 0 ? " " : variableDescriptor.getModifiedVarName();
            if (!caseDescriptor.isSpaceDelim() && !string.equals(" ")) {
                string = string.trim();
                variableDescriptor.setModifiedVarName(string);
            }
            defaultTableModel.addColumn(string);
            vector = variableDescriptor.getVarData();
            for (n = 0; n < Math.min(vector.size(), 200); ++n) {
                defaultTableModel.setValueAt(vector.get(n), n, n2 + 1);
            }
        }
        this.mDataPreviewTable.setModel(defaultTableModel);
        this.mDataPreviewTable.getColumnModel().getColumn(0).setMinWidth(0);
        this.mDataPreviewTable.getColumnModel().getColumn(0).setMaxWidth(1000);
        this.mDataPreviewTable.getColumnModel().getColumn(0).setPreferredWidth(0);
        this.mDataPreviewTable.getTableHeader().resizeAndRepaint();
        if (caseDescriptor.isLineACase()) {
            caseDescriptor.setNumVarsRepresentCase(vector2.size());
        }
        this.mDataPreviewTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = null;
                component = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                component.setBackground(jTable.getTableHeader().getBackground());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return component;
            }
        });
    }

    private void initVars() {
        this.mTabCheck = new JCheckBox(new ToggleButtonAction(this.mWizardDialog, TAB_CHECK));
        this.mCommaCheck = new JCheckBox(new ToggleButtonAction(this.mWizardDialog, COMMA_CHECK));
        this.mSpaceCheck = new JCheckBox(new ToggleButtonAction(this.mWizardDialog, SPACE_CHECK));
        this.mRemoveLeadingSpacesCB = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_TEXT_IMPORT_WIZARD_STEP_4_REMOVE_LEADING_SPACES_CHECKBOX", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CaseDescriptor caseDescriptor = ((ReadTextDataWizardDlg)TextImportDelimitedStep4Of6Page.this.mWizardDialog).getTextDacData().getCaseDescriptor();
                caseDescriptor.setStripLeadingSpaces(TextImportDelimitedStep4Of6Page.this.mRemoveLeadingSpacesCB.isSelected());
                TextImportDelimitedStep4Of6Page.this.updateTable(true);
            }
        });
        this.mRemoveTrailingSpacesCB = DialogUtil.createCheckBox(this.mWizardDialog, "IDS_TEXT_IMPORT_WIZARD_STEP_4_REMOVE_TRAILING_SPACES_CHECKBOX", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CaseDescriptor caseDescriptor = ((ReadTextDataWizardDlg)TextImportDelimitedStep4Of6Page.this.mWizardDialog).getTextDacData().getCaseDescriptor();
                caseDescriptor.setStripTrailingSpaces(TextImportDelimitedStep4Of6Page.this.mRemoveTrailingSpacesCB.isSelected());
                TextImportDelimitedStep4Of6Page.this.updateTable(true);
            }
        });
        this.mSemicolonCheck = new JCheckBox(new ToggleButtonAction(this.mWizardDialog, SEMICOLON_CHECK));
        this.mOtherCheck = new JCheckBox(new ToggleButtonAction(this.mWizardDialog, OTHER_CHECK));
        this.mNoneRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, NONE_RADIO));
        this.mSingleQuoteRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, SINGLE_QUOTE_RADIO));
        this.mDoubleQuoteRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, DOUBLE_QUOTE_RADIO));
        this.mOtherRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, OTHER_RADIO));
        this.mTextQualifierButtonGrp = new SpssButtonGroup();
        this.mTextQualifierButtonGrp.add(this.mNoneRadio);
        this.mTextQualifierButtonGrp.add(this.mSingleQuoteRadio);
        this.mTextQualifierButtonGrp.add(this.mDoubleQuoteRadio);
        this.mTextQualifierButtonGrp.add(this.mOtherRadio);
        this.mDelimiterText = new StringTextField(5);
        this.mQualifierText = new StringTextField(5);
        DefaultTableModel defaultTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.mDataPreviewTable = new JTable(defaultTableModel);
        this.mDataPreviewTable.setMinimumSize(new Dimension(400, 130));
        this.mDataPreviewTable.setColumnSelectionAllowed(true);
        this.mDataPreviewTable.setRowSelectionAllowed(false);
        this.mDataPreviewTable.setAutoResizeMode(0);
        this.mDataPreviewTable.getTableHeader().setReorderingAllowed(false);
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            this.mDataPreviewTable.setGridColor(this.mDataPreviewTable.getGridColor().darker());
        }
        this.mTableScroll = new JScrollPane(this.mDataPreviewTable);
        this.mTableScroll.setPreferredSize(this.mDataPreviewTable.getMinimumSize());
        if (this.mDataPreviewTable.getModel().getColumnCount() >= 2) {
            this.addColumnSelectionInterval(1, 1);
        }
    }

    public void addColumnSelectionInterval(int n, int n2) {
        this.mDataPreviewTable.addColumnSelectionInterval(n, n2);
        this.mLastSelectedCols = this.mDataPreviewTable.getSelectedColumns();
    }

    private void setDefaults() {
        this.mNoneRadio.setSelected(true);
        this.mDelimiterText.setEnabled(false);
        this.mDelimiterText.setOpaque(false);
        this.mQualifierText.setEnabled(false);
        this.mQualifierText.setOpaque(false);
    }

    private void addComponentsToPage() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(0, 0, 0, DialogUtil.getComponentGroupGap());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mWizardPage, this.setupWhichDelimBetVarsPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(this.mWizardPage, this.setupLeadingTrailingSpacesPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mWizardPage, this.setupWhichTextQualifierPanel(), gridBagConstraints, 1, 0, 1, 2, n, null);
        insets.set(2 * DialogUtil.getComponentGroupGap(), 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(this.mWizardPage, this.setupDataPreviewPanel(), gridBagConstraints, 0, 3, 2, 1, n, insets);
    }

    private JPanel setupWhichDelimBetVarsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.mWizardDialog.getResString(WHICH_DELIM_BET_VARS_PANEL_TITLE)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mTabCheck, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mCommaCheck, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mSpaceCheck, gridBagConstraints, 2, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSemicolonCheck, gridBagConstraints, 2, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mOtherCheck, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mDelimiterText), gridBagConstraints, 1, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupLeadingTrailingSpacesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.mWizardDialog.getResString("IDS_TEXT_IMPORT_WIZARD_STEP_4_REMOVE_LEADING_TRAILING_SPACES_GRPBX")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mRemoveLeadingSpacesCB, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mRemoveTrailingSpacesCB, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupWhichTextQualifierPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        String string = this.mWizardDialog.getResString(WHICH_TEXT_QUALIFIER_PANEL_TITLE);
        jPanel.setBorder(new TitledBorder(string));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mNoneRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mSingleQuoteRadio, gridBagConstraints, 0, 1, 2, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mDoubleQuoteRadio, gridBagConstraints, 0, 2, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mOtherRadio, gridBagConstraints, 0, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mQualifierText), gridBagConstraints, 1, 3, 1, 1, n, insets);
        int n2 = jPanel.getFontMetrics(jPanel.getFont()).stringWidth(string);
        Dimension dimension = jPanel.getPreferredSize();
        if (n2 > dimension.width) {
            jPanel.setPreferredSize(new Dimension(n2, dimension.height));
        }
        return jPanel;
    }

    private JPanel setupDataPreviewPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(this.mWizardDialog.getResString(DATA_PREVIEW_PANEL_BORDER)));
        jPanel.setPreferredSize(new Dimension(500, 150));
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n, n, n, n);
        int n2 = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTableScroll, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        return jPanel;
    }

    private void loadPreviousStateOfRadioButtons() {
        if (this.mNoneRadioWasSelected) {
            this.mNoneRadio.removeItemListener(this);
            this.mNoneRadio.setSelected(true);
            this.mNoneRadio.addItemListener(this);
            this.mNoneRadio.requestFocus();
        } else if (this.mSingleQuoteRadioWasSelected) {
            this.mSingleQuoteRadio.removeItemListener(this);
            this.mSingleQuoteRadio.setSelected(true);
            this.mSingleQuoteRadio.addItemListener(this);
            this.mSingleQuoteRadio.requestFocus();
        } else if (this.mDoubleQuoteRadioWasSelected) {
            this.mDoubleQuoteRadio.removeItemListener(this);
            this.mDoubleQuoteRadio.setSelected(true);
            this.mDoubleQuoteRadio.addItemListener(this);
            this.mDoubleQuoteRadio.requestFocus();
        } else if (this.mOtherRadioWasSelected) {
            this.mOtherRadio.removeItemListener(this);
            this.mOtherRadio.setSelected(true);
            this.mQualifierText.setEnabled(this.mOtherRadioWasSelected);
            this.mQualifierText.setOpaque(this.mOtherRadioWasSelected);
            this.mOtherRadio.addItemListener(this);
            this.mOtherRadio.requestFocus();
        }
    }

    private void setRadioButtonFlags() {
        CaseDescriptor caseDescriptor = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getCaseDescriptor();
        if (caseDescriptor.isSingleQuoteQualifier()) {
            this.mNoneRadioWasSelected = false;
            this.mSingleQuoteRadioWasSelected = true;
            this.mDoubleQuoteRadioWasSelected = false;
            this.mOtherRadioWasSelected = false;
        } else if (caseDescriptor.isDoubleQuoteQualifier()) {
            this.mNoneRadioWasSelected = false;
            this.mSingleQuoteRadioWasSelected = false;
            this.mDoubleQuoteRadioWasSelected = true;
            this.mOtherRadioWasSelected = false;
        } else if (caseDescriptor.isOtherQualifier()) {
            this.mNoneRadioWasSelected = false;
            this.mSingleQuoteRadioWasSelected = false;
            this.mDoubleQuoteRadioWasSelected = false;
            this.mOtherRadioWasSelected = true;
        } else {
            this.mNoneRadioWasSelected = true;
            this.mSingleQuoteRadioWasSelected = false;
            this.mDoubleQuoteRadioWasSelected = false;
            this.mOtherRadioWasSelected = false;
        }
    }

    private void validateVariableNames() {
        int n;
        Vector vector = ((ReadTextDataWizardDlg)this.mWizardDialog).getTextDacData().getVariableDescriptors(((ReadTextDataWizardDlg)this.mWizardDialog).hasStateChanged());
        Vector<String> vector2 = new Vector<String>();
        for (n = 0; n < vector.size(); ++n) {
            vector2.add(n, ((VariableDescriptor)vector.get(n)).getModifiedVarName());
        }
        this.mVarNamesChanged = VarNameValidator.generateSPSSNameForDac(vector2, (boolean)true);
        if (this.mVarNamesChanged) {
            for (n = 0; n < vector2.size(); ++n) {
                ((VariableDescriptor)vector.get(n)).setModifiedVarName((String)vector2.get(n));
            }
        }
    }
}

