/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.read_text_data;

import com.spss.java_client.core.documents.data.data_access.text.CaseDescriptor;
import com.spss.java_client.core.documents.data.data_access.text.TextDac;
import com.spss.java_client.core.documents.data.data_access.text.VariableDescriptor;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.KeyDoesNotExistsException;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.SerializeArchiveData;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.SerializeData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class SerializeDataReader {
    private TextDac.TextDacData mTextDacData;

    public SerializeDataReader(TextDac.TextDacData textDacData) {
        this.mTextDacData = textDacData;
    }

    public TextDac.TextDacData getDacData() {
        return this.mTextDacData;
    }

    public boolean readSerializedData(String string) throws KeyDoesNotExistsException {
        boolean bl = true;
        if (string.length() > 0) {
            SerializeData serializeData = SerializeData.getInstance();
            SerializeArchiveData serializeArchiveData = SerializeArchiveData.getInstance();
            try {
                serializeData.readObject(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                bl = false;
                try {
                    boolean bl2 = SerializeArchiveData.readObject(string);
                    if (!bl2) {
                        return false;
                    }
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                }
            }
            if (bl) {
                this.populateCaseDescByJavaClientTpf(serializeData);
            } else {
                this.populateCaseDescByOldTpf(serializeArchiveData);
            }
            return true;
        }
        return false;
    }

    private void populateCaseDescByJavaClientTpf(SerializeData serializeData) throws KeyDoesNotExistsException {
        CaseDescriptor caseDescriptor = this.mTextDacData.getCaseDescriptor();
        caseDescriptor.setCutPoints((ArrayList)serializeData.getObject("CD_CUT_POINTS"));
        caseDescriptor.setNumVarsRepresentCase(((Integer)serializeData.getObject("CD_VARSLINES")).intValue());
        caseDescriptor.setIsLineACase(((Boolean)serializeData.getObject("CD_CASELINE")).booleanValue());
        String string = (String)serializeData.getObject("CD_DELIMSTR");
        caseDescriptor.setIsCommaDelim(string.contains(","));
        caseDescriptor.setIsSpaceDelim(string.contains(" "));
        caseDescriptor.setIsSemiColonDelim(string.contains(";"));
        caseDescriptor.setIsTabDelim(string.contains("\t"));
        caseDescriptor.setIsOtherDelim(((Boolean)serializeData.getObject("CD_ISOTHRDLM")).booleanValue());
        if (((Boolean)serializeData.getObject("CD_ISOTHRDLM")).booleanValue()) {
            caseDescriptor.setOtherDelimiter((String)serializeData.getObject("CD_OTHRDLM"));
        }
        caseDescriptor.setIsFixedWidth((Boolean)serializeData.getObject("DF_DELIM") == false);
        caseDescriptor.setFirstNumCases(((Integer)serializeData.getObject("DF_NCASES")).intValue());
        caseDescriptor.setRandomPercentageCases(((Integer)serializeData.getObject("DF_PERCNT")).intValue());
        int n = (Integer)serializeData.getObject("DF_NUMIMP");
        if (n == 0) {
            caseDescriptor.setIsAllCases(true);
            caseDescriptor.setIsFirstNumCases(false);
            caseDescriptor.setIsRandomPercentageCases(false);
        } else if (n == 1) {
            caseDescriptor.setIsAllCases(false);
            caseDescriptor.setIsFirstNumCases(true);
            caseDescriptor.setIsRandomPercentageCases(false);
        } else {
            caseDescriptor.setIsAllCases(false);
            caseDescriptor.setIsFirstNumCases(false);
            caseDescriptor.setIsRandomPercentageCases(true);
        }
        if (serializeData.containsKey("CD_IS_DECIMAL_SYMBOL_PERIOD")) {
            caseDescriptor.setIsDecimalSymbolPeriod(serializeData.getBoolean("CD_IS_DECIMAL_SYMBOL_PERIOD"));
        }
        if (serializeData.containsKey("CD_REMOVE_LEADLING_SPACES")) {
            caseDescriptor.setStripLeadingSpaces(serializeData.getBoolean("CD_REMOVE_LEADLING_SPACES"));
        }
        if (serializeData.containsKey("CD_REMOVE_TRAILING_SPACES")) {
            caseDescriptor.setStripTrailingSpaces(serializeData.getBoolean("CD_REMOVE_TRAILING_SPACES"));
        }
        if (serializeData.containsKey("CD_PERCENT_VALUES_DETERMINE_TYPE")) {
            caseDescriptor.setPercentageOfValuesToDetermineType(((Double)serializeData.getObject("CD_PERCENT_VALUES_DETERMINE_TYPE")).doubleValue());
        }
        caseDescriptor.setNumLinesRepresentCase(((Integer)serializeData.getObject("DF_LINESCASE")).intValue());
        caseDescriptor.setCaseStartLineNumber(((Integer)serializeData.getObject("DF_FSTDATA")).intValue());
        caseDescriptor.setVarsAtTopOfFile(((Boolean)serializeData.getObject("DF_VARSTOP")).booleanValue());
        int n2 = caseDescriptor.hasVarsAtTopOfFile() && serializeData.containsKey("DF_VAR_START_LINE_NUM") ? (Integer)serializeData.getObject("DF_VAR_START_LINE_NUM") : 1;
        caseDescriptor.setVarsStartLineNumber(n2);
        caseDescriptor.setNumLinesRepresentCase(((Integer)serializeData.getObject("DF_FIXLINES")).intValue());
        caseDescriptor.setCacheData(((Boolean)serializeData.getObject("DF_CACHE")).booleanValue());
        caseDescriptor.setIsSingleQuoteQualifier(((Boolean)serializeData.getObject("DF_ISSINGLEQUAL")).booleanValue());
        caseDescriptor.setIsDoubleQuoteQualifier(((Boolean)serializeData.getObject("DF_ISDOUBLEQUAL")).booleanValue());
        caseDescriptor.setIsOtherQualifier(((Boolean)serializeData.getObject("DF_ISOTHERQUAL")).booleanValue());
        if (caseDescriptor.isOtherQualifier()) {
            caseDescriptor.setOtherQualifier((String)serializeData.getObject("DF_TQUAL"));
        }
        Vector vector = (Vector)serializeData.getObject("DF_VARDESC");
        Vector<VariableDescriptor> vector2 = new Vector<VariableDescriptor>();
        for (int i = 0; i < vector.size(); ++i) {
            HashMap hashMap = (HashMap)vector.get(i);
            VariableDescriptor variableDescriptor = new VariableDescriptor((String)hashMap.get("VD_ORIGVNAME"));
            Object v = hashMap.get("VD_VARLEN");
            variableDescriptor.setVarLength(v instanceof Integer ? (double)((Integer)v).intValue() : (Double)v);
            variableDescriptor.setVarLine(((Integer)hashMap.get("VD_VARLINE")).intValue());
            variableDescriptor.setVarCol(((Integer)hashMap.get("VD_VARCOL")).intValue());
            variableDescriptor.setVarType((VariableDescriptor.VarType)hashMap.get("VD_VARTYPE"));
            variableDescriptor.setOrigVarName((String)hashMap.get("VD_ORIGVNAME"));
            variableDescriptor.setModifiedVarName((String)hashMap.get("VD_STRVARNAME"));
            Integer n3 = (Integer)hashMap.get("VD_STRDATEF");
            if (n3 != null) {
                variableDescriptor.setDateVarType(n3.intValue());
            }
            vector2.add(variableDescriptor);
        }
        this.mTextDacData.setVariableDescriptors(vector2);
    }

    private void populateCaseDescByOldTpf(SerializeArchiveData serializeArchiveData) throws KeyDoesNotExistsException {
        CaseDescriptor caseDescriptor = this.mTextDacData.getCaseDescriptor();
        caseDescriptor.setNumVarsRepresentCase(((Integer)serializeArchiveData.getObject("CD_VARSLINES")).intValue());
        caseDescriptor.setIsLineACase(((Boolean)serializeArchiveData.getObject("CD_CASELINE")).booleanValue());
        String string = (String)serializeArchiveData.getObject("CD_DELIMSTR");
        caseDescriptor.setIsCommaDelim(string.contains(","));
        caseDescriptor.setIsSpaceDelim(string.contains(" "));
        caseDescriptor.setIsSemiColonDelim(string.contains(";"));
        caseDescriptor.setIsTabDelim(string.contains("\t"));
        caseDescriptor.setIsOtherDelim(((Boolean)serializeArchiveData.getObject("CD_ISOTHRDLM")).booleanValue());
        if (((Boolean)serializeArchiveData.getObject("CD_ISOTHRDLM")).booleanValue()) {
            caseDescriptor.setOtherDelimiter((String)serializeArchiveData.getObject("CD_OTHRDLM"));
        }
        caseDescriptor.setIsFixedWidth((Boolean)serializeArchiveData.getObject("DF_DELIM") == false);
        caseDescriptor.setFirstNumCases(((Integer)serializeArchiveData.getObject("DF_NCASES")).intValue());
        caseDescriptor.setRandomPercentageCases(((Integer)serializeArchiveData.getObject("DF_PERCNT")).intValue());
        int n = (Integer)serializeArchiveData.getObject("DF_NUMIMP");
        if (n == 0) {
            caseDescriptor.setIsAllCases(true);
            caseDescriptor.setIsFirstNumCases(false);
            caseDescriptor.setIsRandomPercentageCases(false);
        } else if (n == 1) {
            caseDescriptor.setIsAllCases(false);
            caseDescriptor.setIsFirstNumCases(true);
            caseDescriptor.setIsRandomPercentageCases(false);
        } else {
            caseDescriptor.setIsAllCases(false);
            caseDescriptor.setIsFirstNumCases(false);
            caseDescriptor.setIsRandomPercentageCases(true);
        }
        caseDescriptor.setNumLinesRepresentCase(((Integer)serializeArchiveData.getObject("DF_LINESCASE")).intValue());
        caseDescriptor.setCaseStartLineNumber(((Integer)serializeArchiveData.getObject("DF_FSTDATA")).intValue());
        caseDescriptor.setVarsAtTopOfFile(((Boolean)serializeArchiveData.getObject("DF_VARSTOP")).booleanValue());
        caseDescriptor.setNumLinesRepresentCase(((Integer)serializeArchiveData.getObject("DF_FIXLINES")).intValue());
        caseDescriptor.setCacheData(((Boolean)serializeArchiveData.getObject("DF_CACHE")).booleanValue());
        caseDescriptor.setIsSingleQuoteQualifier(((Boolean)serializeArchiveData.getObject("DF_ISSINGLEQUAL")).booleanValue());
        caseDescriptor.setIsDoubleQuoteQualifier(((Boolean)serializeArchiveData.getObject("DF_ISDOUBLEQUAL")).booleanValue());
        caseDescriptor.setIsOtherQualifier(((Boolean)serializeArchiveData.getObject("DF_ISOTHERQUAL")).booleanValue());
        if (caseDescriptor.isOtherQualifier()) {
            caseDescriptor.setOtherQualifier((String)serializeArchiveData.getObject("DF_TQUAL"));
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Vector vector = (Vector)serializeArchiveData.getObject("DF_VARDESC");
        Vector<VariableDescriptor> vector2 = new Vector<VariableDescriptor>();
        for (int i = 0; i < vector.size(); ++i) {
            HashMap hashMap = (HashMap)vector.get(i);
            VariableDescriptor variableDescriptor = new VariableDescriptor((String)hashMap.get("VD_ORIGVNAME"));
            variableDescriptor.setVarLength((double)((Integer)hashMap.get("VD_VARLEN")).intValue());
            variableDescriptor.setVarLine(((Integer)hashMap.get("VD_VARLINE")).intValue());
            variableDescriptor.setVarCol(((Integer)hashMap.get("VD_VARCOL")).intValue());
            variableDescriptor.setVarType((VariableDescriptor.VarType)hashMap.get("VD_VARTYPE"));
            variableDescriptor.setOrigVarName((String)hashMap.get("VD_ORIGVNAME"));
            variableDescriptor.setModifiedVarName((String)hashMap.get("VD_STRVARNAME"));
            vector2.add(variableDescriptor);
            arrayList.add(variableDescriptor.getVarCol());
        }
        this.mTextDacData.setVariableDescriptors(vector2);
        caseDescriptor.setCutPoints(arrayList);
    }
}

