/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.read_text_data;

import com.spss.java_client.core.documents.data.data_access.text.VariableDescriptor;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.KeyAlreadyExistsException;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.KeyDoesNotExistsException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class SerializeData {
    public static final int VERSION_1 = 1;
    public static final int CURRENT_VERSION = 1;
    private static SerializeData mInstance;
    private HashMap<String, Object> mSerializeDataMap = new HashMap();

    private SerializeData() {
    }

    public static SerializeData getInstance() {
        if (mInstance == null) {
            mInstance = new SerializeData();
        }
        return mInstance;
    }

    public void putObject(String string, Object object) throws KeyAlreadyExistsException {
        if (this.mSerializeDataMap.containsKey(string)) {
            throw new KeyAlreadyExistsException();
        }
        this.mSerializeDataMap.put(string, object);
    }

    public boolean containsKey(String string) {
        return this.mSerializeDataMap.containsKey(string);
    }

    public Object getObject(String string) throws KeyDoesNotExistsException {
        Object object = this.mSerializeDataMap.get(string);
        if (object == null) {
            throw new KeyDoesNotExistsException();
        }
        return object;
    }

    public boolean getBoolean(String string) throws KeyDoesNotExistsException {
        Object object = this.mSerializeDataMap.get(string);
        if (object == null) {
            throw new KeyDoesNotExistsException();
        }
        return (Boolean)object;
    }

    public void writeObject(String string) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string));
            dataOutputStream.writeInt(1);
            this.writeTo(dataOutputStream);
            dataOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void readObject(String string) throws IOException, ClassNotFoundException {
        this.clearMap();
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
        int n = dataInputStream.readInt();
        if (n > 1 || n < 1) {
            throw new IOException("Bad TPF file version");
        }
        this.readFrom(dataInputStream);
        dataInputStream.close();
    }

    public void clearMap() {
        this.mSerializeDataMap.clear();
    }

    private void writeTo(DataOutputStream dataOutputStream) throws IOException {
        HashMap<String, Class<?>> hashMap = this.buildTypeMap();
        dataOutputStream.writeInt(this.mSerializeDataMap.size());
        for (Map.Entry<String, Object> entry : this.mSerializeDataMap.entrySet()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            if (object == null) {
                dataOutputStream.writeUTF("null");
                continue;
            }
            dataOutputStream.writeUTF(string);
            this.writeValue(dataOutputStream, string, object, hashMap);
        }
    }

    private void writeVarDescriptors(DataOutputStream dataOutputStream, Vector<HashMap<String, Object>> vector, HashMap<String, Class<?>> hashMap) throws IOException {
        int n = vector.size();
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            HashMap<String, Object> hashMap2 = vector.get(i);
            dataOutputStream.writeInt(hashMap2.size());
            for (Map.Entry<String, Object> entry : hashMap2.entrySet()) {
                String string = entry.getKey();
                Object object = entry.getValue();
                if (object == null) {
                    dataOutputStream.writeUTF("null");
                    continue;
                }
                dataOutputStream.writeUTF(string);
                this.writeValue(dataOutputStream, string, object, hashMap);
            }
        }
    }

    private void writeValue(DataOutputStream dataOutputStream, String string, Object object, HashMap<String, Class<?>> hashMap) throws IOException {
        Class<?> clazz = hashMap.get(string);
        if (clazz == null) {
            if (string.equals("CD_CUT_POINTS")) {
                this.writeCutPoints(dataOutputStream, (ArrayList)object);
            } else if (string.equals("DF_VARDESC")) {
                this.writeVarDescriptors(dataOutputStream, (Vector)object, hashMap);
            } else if (string.equals("VD_VARTYPE")) {
                dataOutputStream.writeInt(((VariableDescriptor.VarType)object).ordinal());
            }
        } else if (clazz == Boolean.class) {
            dataOutputStream.writeBoolean((Boolean)object);
        } else if (clazz == Integer.class) {
            dataOutputStream.writeInt((Integer)object);
        } else if (clazz == String.class) {
            dataOutputStream.writeUTF((String)object);
        } else if (clazz == Double.class) {
            dataOutputStream.writeDouble((Double)object);
        }
    }

    private void writeCutPoints(DataOutputStream dataOutputStream, ArrayList<Integer> arrayList) throws IOException {
        dataOutputStream.writeInt(arrayList.size());
        for (Integer n : arrayList) {
            dataOutputStream.writeInt(n);
        }
    }

    private void readFrom(DataInputStream dataInputStream) throws IOException {
        HashMap<String, Class<?>> hashMap = this.buildTypeMap();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            if (string.equals("null")) continue;
            this.readValue(dataInputStream, this.mSerializeDataMap, hashMap, string);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readValue(DataInputStream dataInputStream, HashMap<String, Object> hashMap, HashMap<String, Class<?>> hashMap2, String string) throws IOException {
        Class<?> clazz = hashMap2.get(string);
        if (clazz == null) {
            if (string.equals("CD_CUT_POINTS")) {
                this.readCutPoints(dataInputStream, hashMap);
                return;
            } else if (string.equals("DF_VARDESC")) {
                this.readVarDescriptors(dataInputStream, hashMap, hashMap2);
                return;
            } else {
                if (!string.equals("VD_VARTYPE")) throw new UnsupportedOperationException("Bad TPF key: " + string);
                hashMap.put(string, VariableDescriptor.VarType.fromInt((int)dataInputStream.readInt()));
            }
            return;
        } else if (clazz == Boolean.class) {
            hashMap.put(string, dataInputStream.readBoolean());
            return;
        } else if (clazz == Integer.class) {
            hashMap.put(string, dataInputStream.readInt());
            return;
        } else if (clazz == String.class) {
            hashMap.put(string, dataInputStream.readUTF());
            return;
        } else {
            if (clazz != Double.class) return;
            hashMap.put(string, dataInputStream.readDouble());
        }
    }

    private void readVarDescriptors(DataInputStream dataInputStream, HashMap<String, Object> hashMap, HashMap<String, Class<?>> hashMap2) throws IOException {
        Vector<HashMap<String, Object>> vector = new Vector<HashMap<String, Object>>();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
            int n2 = dataInputStream.readInt();
            for (int j = 0; j < n2; ++j) {
                String string = dataInputStream.readUTF();
                if (string.equals("null")) continue;
                this.readValue(dataInputStream, hashMap3, hashMap2, string);
            }
            vector.add(hashMap3);
        }
        hashMap.put("DF_VARDESC", vector);
    }

    private void readCutPoints(DataInputStream dataInputStream, HashMap<String, Object> hashMap) throws IOException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            arrayList.add(dataInputStream.readInt());
        }
        hashMap.put("CD_CUT_POINTS", arrayList);
    }

    private HashMap<String, Class<?>> buildTypeMap() {
        HashMap hashMap = new HashMap();
        hashMap.put("CD_VARSLINES", Integer.class);
        hashMap.put("CD_MISSVALUS", Integer.class);
        hashMap.put("CD_CASELINE", Boolean.class);
        hashMap.put("CD_DELIMSTR", String.class);
        hashMap.put("CD_ISOTHRDLM", Boolean.class);
        hashMap.put("CD_OTHRDLM", String.class);
        hashMap.put("CD_CUT_POINTS", null);
        hashMap.put("CD_IS_DECIMAL_SYMBOL_PERIOD", Boolean.class);
        hashMap.put("CD_REMOVE_TRAILING_SPACES", Boolean.class);
        hashMap.put("CD_REMOVE_LEADLING_SPACES", Boolean.class);
        hashMap.put("CD_PERCENT_VALUES_DETERMINE_TYPE", Double.class);
        hashMap.put("DF_VAR_START_LINE_NUM", Integer.class);
        hashMap.put("DF_DELIM", Boolean.class);
        hashMap.put("DF_NCASES", Integer.class);
        hashMap.put("DF_PERCNT", Integer.class);
        hashMap.put("DF_NUMIMP", Integer.class);
        hashMap.put("DF_LINESCASE", Integer.class);
        hashMap.put("DF_FSTDATA", Integer.class);
        hashMap.put("DF_VARSTOP", Boolean.class);
        hashMap.put("DF_SAMPLE", Integer.class);
        hashMap.put("DF_FIXLINES", Integer.class);
        hashMap.put("DF_CACHE", Boolean.class);
        hashMap.put("DF_ISSINGLEQUAL", Boolean.class);
        hashMap.put("DF_ISDOUBLEQUAL", Boolean.class);
        hashMap.put("DF_ISOTHERQUAL", Boolean.class);
        hashMap.put("DF_TQUAL", String.class);
        hashMap.put("DF_VARDESC", null);
        hashMap.put("VD_VARLEN", Double.class);
        hashMap.put("VD_VARLINE", Integer.class);
        hashMap.put("VD_VARCOL", Integer.class);
        hashMap.put("VD_FORMWID", Integer.class);
        hashMap.put("VD_DATEFCODE", Integer.class);
        hashMap.put("VD_VARTYPE", null);
        hashMap.put("VD_ISVALLAB", Integer.class);
        hashMap.put("VD_ORIGVNAME", String.class);
        hashMap.put("VD_STRDATEF", Integer.class);
        hashMap.put("VD_STRVARNAME", String.class);
        hashMap.put("VD_DECPOINTS", Integer.class);
        return hashMap;
    }
}

