/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.read_text_data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.data.data_access.DacType;
import com.spss.java_client.core.documents.data.data_access.DataAccessContainer;
import com.spss.java_client.core.documents.data.data_access.excel.BaseExcelDacData;
import com.spss.java_client.core.documents.data.data_access.excel.ExcelDac;
import com.spss.java_client.core.documents.data.data_access.excel.ExcelDataProxy;
import com.spss.java_client.core.documents.data.data_access.excel.ExcelPreviewColInfo;
import com.spss.java_client.core.documents.data.data_access.excel.ExcelSheetInfo;
import com.spss.java_client.core.documents.data.data_access.excel.ExcelXDac;
import com.spss.java_client.core.documents.data.data_access.excel.ExcelXDataProxy;
import com.spss.java_client.core.documents.data.data_access.excel.XlsCellRange;
import com.spss.java_client.core.documents.data.data_access.text.VariableDescriptor;
import com.spss.java_client.ui.DAC.resources.DacResBundle;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.TCM.controls_models.TCMUtilities;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.IPreviewThreadListener;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.IconTableHeaderColumnRenderer;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.ReadTextDataWizardDlg;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.FocusableLabel;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.res.UIToolResUtil;
import com.spss.uitools.util.TableUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class ReadExcelFileDialog
extends BaseDialog
implements ItemListener,
IPreviewThreadListener {
    public static final int DEFAULT_TABLE_WIDTH = 400;
    private static final int PREVIEW_ROW_LIMIT = 199;
    private static final int PREVIEW_COL_LIMIT = 499;
    private boolean mOkToContinue;
    protected boolean mWasPasteSelected = false;
    SpssFrame mParentFrame;
    DataAccessContainer mDac;
    BaseExcelDacData mExcelDacData;
    protected boolean mOldReadVarNamesFRomFirstRow;
    protected boolean mOldPercentOfValuesThatDetermineDataType;
    protected boolean mOldIgnoreHiddenRowsCols;
    protected boolean mOldRemoveLeadingSpaces;
    protected boolean mOldRemoveTrailingSpaces;
    private Vector<ExcelSheetInfo> mSheetInfos = new Vector();
    FocusableLabel mFileTextAreaLabel;
    private JLabel mWorksheetComboLabel = null;
    private JComboBox mWorksheetCombo = null;
    private JLabel mRangeEditLabel = null;
    private StringTextField mRangeEdit = null;
    protected JCheckBox mReadVarNamesFRomFirstRowCB;
    protected JCheckBox mIgnoreHiddenRowsColsCB;
    protected JCheckBox mRemoveLeadingSpacesCB;
    protected JCheckBox mRemoveTrailingSpacesCB;
    private JCheckBox mPercentOfValuesThatDetermineDataTypeCB;
    protected FloatTextField mPercentOfValuesDetermineDataTypeTextField;
    protected JLabel mPreviewLabel;
    protected JTable mPreviewTable;
    private JScrollPane mTableScroll;
    protected JScrollPane mPreviewTableScrollPane;
    FocusableTextArea mInfoText;
    private boolean mFullRangeSelected = false;
    private XlsCellRange mCellRange = new XlsCellRange();
    private String mSelectedSheetName = "";
    int mOldColCount = -1;

    public ReadExcelFileDialog(SpssFrame spssFrame, DataAccessContainer dataAccessContainer, BaseExcelDacData baseExcelDacData, Vector<ExcelSheetInfo> vector) throws ExceptionInInitializerError {
        super((JFrame)spssFrame, true, ResUtil.getBundle(DacResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), DacResBundle.getImageFolder());
        this.mParentFrame = spssFrame;
        this.mDac = dataAccessContainer;
        this.mExcelDacData = baseExcelDacData;
        this.mSheetInfos = vector;
        this.setTitle(this.getResString("IDS_READ_EXCEL_DATA_DIALOG_TITLE"));
        this.myInit();
        this.setDefaults();
    }

    public static boolean runExcelRangeDialog(SpssFrame spssFrame, DataAccessContainer dataAccessContainer, Vector<ExcelSheetInfo> vector) {
        ExcelXDac.ExcelXDacData excelXDacData = null;
        if (dataAccessContainer != null && dataAccessContainer.getDacData() instanceof ExcelXDac.ExcelXDacData) {
            excelXDacData = (ExcelXDac.ExcelXDacData)dataAccessContainer.getDacData();
        }
        if (dataAccessContainer != null && dataAccessContainer.getDacData() instanceof ExcelDac.ExcelDacData) {
            excelXDacData = (ExcelDac.ExcelDacData)dataAccessContainer.getDacData();
        }
        assert (dataAccessContainer != null && dataAccessContainer.getDataSpec() != null);
        try {
            ReadExcelFileDialog readExcelFileDialog = new ReadExcelFileDialog(spssFrame, dataAccessContainer, (BaseExcelDacData)excelXDacData, vector);
            readExcelFileDialog.pack();
            readExcelFileDialog.setLocationRelativeTo(readExcelFileDialog.getParent());
            readExcelFileDialog.setComponentsEnabled(false, readExcelFileDialog.getViewPanel());
            readExcelFileDialog.setComponentsEnabled(false, readExcelFileDialog.getCmdButtonPanel());
            readExcelFileDialog.setComponentsEnabled(true, readExcelFileDialog.mTableScroll);
            GetPreviewDataThread getPreviewDataThread = readExcelFileDialog.GetPreviewDataThread();
            getPreviewDataThread.addListener(readExcelFileDialog);
            new Thread(getPreviewDataThread).start();
            readExcelFileDialog.setVisible(true);
            getPreviewDataThread.removeListener(readExcelFileDialog);
            boolean bl = readExcelFileDialog.isOkToContinue();
            return bl;
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            String string = UIToolResUtil.getString((ResourceBundle)ResUtil.getBundle(DacResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), (String)"ERR_BAD_FILE_ERROR_MSG");
            string = string + "\n\"" + dataAccessContainer.getDataSpec() + "\"";
            SpssAlertOptionPane.showErrorMessageDialog(spssFrame, string, VersionInfo.getAppVersionString());
            return false;
        }
    }

    private GetPreviewDataThread GetPreviewDataThread() {
        return new GetPreviewDataThread();
    }

    private void setComponentsEnabled(boolean bl, Component component) {
        Component[] componentArray;
        component.setEnabled(bl);
        if (component instanceof Container && (componentArray = ((Container)component).getComponents()) != null && componentArray.length > 0) {
            for (Component component2 : componentArray) {
                this.setComponentsEnabled(bl, component2);
            }
        }
    }

    private void showErrorMessage(Component component, String string, String string2) {
        String string3 = this.getResString(string);
        if (string3 != null) {
            String string4 = string3 + "\n\"" + string2 + "\"";
            SpssAlertOptionPane.showErrorMessageDialog((Window)component, string4, VersionInfo.getAppVersionString());
        } else {
            SpssAlertOptionPane.showErrorMessageDialog((Window)component, string, VersionInfo.getAppVersionString());
        }
    }

    private void saveResetOptions() {
        this.mOldReadVarNamesFRomFirstRow = this.mReadVarNamesFRomFirstRowCB.isSelected();
        this.mOldPercentOfValuesThatDetermineDataType = this.mPercentOfValuesThatDetermineDataTypeCB.isSelected();
        if (this.mExcelDacData instanceof ExcelXDac.ExcelXDacData) {
            this.mOldIgnoreHiddenRowsCols = this.mIgnoreHiddenRowsColsCB.isSelected();
        }
        this.mOldRemoveLeadingSpaces = this.mRemoveLeadingSpacesCB.isSelected();
        this.mOldRemoveTrailingSpaces = this.mRemoveTrailingSpacesCB.isSelected();
    }

    private void restoreSaveResetOptions() {
        this.mWorksheetCombo.setSelectedIndex(0);
        this.mReadVarNamesFRomFirstRowCB.setSelected(this.mOldReadVarNamesFRomFirstRow);
        this.mPercentOfValuesThatDetermineDataTypeCB.setSelected(this.mOldPercentOfValuesThatDetermineDataType);
        this.mPercentOfValuesDetermineDataTypeTextField.setText("95");
        if (this.mExcelDacData instanceof ExcelDac.ExcelDacData) {
            this.mIgnoreHiddenRowsColsCB.setSelected(false);
            this.mIgnoreHiddenRowsColsCB.setEnabled(false);
        } else {
            this.mIgnoreHiddenRowsColsCB.setSelected(this.mOldIgnoreHiddenRowsCols);
            this.mIgnoreHiddenRowsColsCB.addItemListener(this);
        }
        this.mRemoveLeadingSpacesCB.setSelected(this.mOldRemoveLeadingSpaces);
        this.mRemoveTrailingSpacesCB.setSelected(this.mOldRemoveTrailingSpaces);
        this.mRangeEdit.setText("");
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, this.getDialogHelpID());
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        OKAction oKAction = new OKAction();
        JButton jButton = new JButton(oKAction);
        JButton jButton2 = new JButton(new PasteAction());
        JButton jButton3 = new JButton(new ResetAction());
        JButton jButton4 = new JButton(new CancelAction());
        JButton jButton5 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton5);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                int n3 = 0;
                DialogUtil.addUsingGBL(jPanel, jButton5, gridBagConstraints, n3, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton4, gridBagConstraints, ++n3, 0, 1, 1, n2, insets2);
                if (VersionInfo.allowSyntax()) {
                    DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, ++n3, 0, 1, 1, n2, insets2);
                }
                DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, ++n3, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, ++n3, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                if (VersionInfo.allowSyntax()) {
                    jPanel.add(jButton2);
                }
                jPanel.add(jButton3);
                jPanel.add(jButton4);
                jPanel.add(jButton5);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton4);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton5);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    public String getDialogHelpID() {
        return "idh_idd_xlscellrange";
    }

    protected void init() {
    }

    protected void myInit() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupMainPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.mFileTextAreaLabel.requestFocusInWindow();
        this.pack();
    }

    private JPanel setupMainPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top + 4, insets.left, insets.bottom, insets.right);
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mFileTextAreaLabel, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        JPanel jPanel2 = this.setupWorksheetRangePanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 2, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mReadVarNamesFRomFirstRowCB, gridBagConstraints, 0, 2, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mPercentOfValuesThatDetermineDataTypeCB, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mPercentOfValuesDetermineDataTypeTextField, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mIgnoreHiddenRowsColsCB, gridBagConstraints, 0, 4, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mRemoveLeadingSpacesCB, gridBagConstraints, 0, 5, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mRemoveTrailingSpacesCB, gridBagConstraints, 0, 6, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mPreviewLabel, gridBagConstraints, 0, 7, 2, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTableScroll, gridBagConstraints, 0, 8, 2, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JPanel jPanel3 = TCMUtilities.createInfoPanel(this.mInfoText);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 9, 2, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupWorksheetRangePanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top + 4, insets.left, insets.bottom, insets.right);
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mWorksheetComboLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mWorksheetCombo, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mRangeEditLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mRangeEdit), gridBagConstraints, 1, 2, 1, 1, n, insets2);
        return jPanel;
    }

    private void initVars() {
        this.mFileTextAreaLabel = new FocusableLabel(this.mDac.getDataSpec());
        this.mWorksheetComboLabel = DialogUtil.createLabel(this, "IDS_READ_EXCEL_DATA_WORKSHEET_CB");
        this.mWorksheetCombo = new JComboBox();
        this.mWorksheetCombo.setEnabled(true);
        this.mWorksheetCombo.setEditable(false);
        this.mWorksheetComboLabel.setLabelFor(this.mWorksheetCombo);
        this.fillWorksheetCombo();
        this.mRangeEditLabel = DialogUtil.createLabel(this, "IDS_READ_EXCEL_DATA_RANGE_TEXT_FIELD");
        this.mRangeEdit = new StringTextField();
        this.mRangeEditLabel.setLabelFor((Component)((Object)this.mRangeEdit));
        this.mReadVarNamesFRomFirstRowCB = DialogUtil.createCheckBox(this, "IDS_READ_EXCEL_DATA_READ_VAR_NAMES_FIRST_ROW_CHECKBOX");
        this.mPercentOfValuesThatDetermineDataTypeCB = DialogUtil.createCheckBox(this, "IDS_READ_EXCEL_DATA_PERCENT_OF_VALUES_DETERMINE_DATA_TYPE_SPINNER");
        this.mPercentOfValuesThatDetermineDataTypeCB.setSelected(true);
        this.mPercentOfValuesDetermineDataTypeTextField = new FloatTextField(50.0, 100.0, 6);
        this.mPercentOfValuesDetermineDataTypeTextField.setText("95");
        this.mPercentOfValuesDetermineDataTypeTextField.setIncludeMinRange(false);
        this.mPercentOfValuesDetermineDataTypeTextField.setPreferredSize(new Dimension(75, 25));
        this.mPercentOfValuesDetermineDataTypeTextField.setMinimumSize(new Dimension(75, 25));
        this.mIgnoreHiddenRowsColsCB = DialogUtil.createCheckBox(this, "IDS_READ_EXCEL_DATA_IGNORE_HIDDEN_ROWS_COLS_CHECKBOX");
        this.mRemoveLeadingSpacesCB = DialogUtil.createCheckBox(this, "IDS_READ_EXCEL_DATA_REMOVE_LEADING_SPACES_CHECKBOX");
        this.mRemoveTrailingSpacesCB = DialogUtil.createCheckBox(this, "IDS_READ_EXCEL_DATA_REMOVE_TRAILING_SPACES_CHECKBOX");
        this.mPreviewLabel = DialogUtil.createLabel(this, "IDS_READ_EXCEL_DATA_PREVIEW_TABLE_LABEL");
        this.mPreviewTable = new JTable();
        this.mPreviewTable.setMinimumSize(new Dimension(400, 130));
        this.mPreviewTable.setColumnSelectionAllowed(true);
        this.mPreviewTable.setAutoResizeMode(0);
        this.mPreviewTable.getTableHeader().setReorderingAllowed(false);
        this.mPreviewLabel.setLabelFor(this.mPreviewTable);
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            this.mPreviewTable.setGridColor(this.mPreviewTable.getGridColor().darker());
        }
        JTextArea jTextArea = new JTextArea("\n\n\n" + this.getResString("IDS_READ_EXCEL_PLEASE_WAIT") + this.mDac.getDataSpec());
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        this.mTableScroll = new JScrollPane(jTextArea);
        this.mTableScroll.setPreferredSize(this.mPreviewTable.getMinimumSize());
        this.mInfoText = new FocusableTextArea(this.getResString("IDS_READ_EXCEL_DATA_PREVIEW_INFO_TEXT"), null);
    }

    public boolean wasOkPressed() {
        return this.mOkToContinue;
    }

    public boolean isOkToContinue() {
        return this.mOkToContinue;
    }

    public boolean isPaste() {
        return this.mWasPasteSelected;
    }

    public boolean isPasteOrRun() {
        return this.mWasPasteSelected || this.mOkToContinue;
    }

    private void saveSelectionsToExcelDac() {
        this.mExcelDacData.setCellRange(this.getCellRange());
        this.mExcelDacData.setFullRangeSelected(this.isFullRangeSelected());
        this.mExcelDacData.setReadVarNames(this.isReadVarNamesSelected());
        this.mExcelDacData.setSheetName(this.getSelectedSheetName());
        this.mExcelDacData.setIsIgnoreHiddenRowsCols(this.mIgnoreHiddenRowsColsCB.isSelected());
        this.mExcelDacData.setDataTypeMinSelected(this.isPercentOfValuesThatDetermineDataTypeSelected());
        if (this.mPercentOfValuesDetermineDataTypeTextField.getText() != null && this.mPercentOfValuesDetermineDataTypeTextField.getText().length() > 0) {
            this.mExcelDacData.setPercentOfValuesThatDetermineDataType(new Double(this.mPercentOfValuesDetermineDataTypeTextField.getText()).doubleValue());
        }
        this.mExcelDacData.getCaseDescriptor().setStripLeadingSpaces(this.mRemoveLeadingSpacesCB.isSelected());
        this.mExcelDacData.getCaseDescriptor().setStripTrailingSpaces(this.mRemoveTrailingSpacesCB.isSelected());
    }

    private XlsCellRange getSelectedSheetRange() {
        int n = this.mWorksheetCombo.getSelectedIndex();
        if (this.mSheetInfos.size() == 0 || n < 0 || n >= this.mSheetInfos.size()) {
            return null;
        }
        return this.mSheetInfos.get(n).getCellRng();
    }

    private void fillWorksheetCombo() {
        this.mWorksheetCombo.removeAllItems();
        if (this.mSheetInfos != null) {
            for (ExcelSheetInfo excelSheetInfo : this.mSheetInfos) {
                String string = excelSheetInfo.getSheetName();
                XlsCellRange xlsCellRange = excelSheetInfo.getCellRng();
                String string2 = String.format("%s [%s]", string, xlsCellRange.toString());
                if (ComponentState.isBtdRtlOrLtr()) {
                    this.mWorksheetCombo.addItem(ComponentState.prepareStringForBidiRendering((String)string2));
                    continue;
                }
                this.mWorksheetCombo.addItem(string2);
            }
        }
    }

    private boolean continuePressed() {
        if (!this.validateRange()) {
            String string = this.getResString("ERR_INVALID_CELL_RANGE_MSG");
            String string2 = String.format(string, this.mRangeEdit.getText());
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string2, VersionInfo.getAppVersionString());
            this.mRangeEdit.selectAll();
            this.mRangeEdit.requestFocus();
            return false;
        }
        XlsCellRange xlsCellRange = this.getSelectedSheetRange();
        if (!(this.mFullRangeSelected || xlsCellRange != null && this.mCellRange.isSubset(xlsCellRange))) {
            String string = this.getResString("ERR_BAD_CELL_RANGE_MSG");
            String string3 = String.format(string, this.mRangeEdit.getText());
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), string3, VersionInfo.getAppVersionString());
            this.mRangeEdit.selectAll();
            this.mRangeEdit.requestFocus();
            return false;
        }
        int n = this.mWorksheetCombo.getSelectedIndex();
        assert (n > -1);
        this.mSelectedSheetName = this.mSheetInfos.get(n).getSheetName();
        return true;
    }

    public boolean isFullRangeSelected() {
        return this.mFullRangeSelected;
    }

    public XlsCellRange getCellRange() {
        return this.mCellRange;
    }

    private boolean validateRange() {
        String string = this.mRangeEdit.getText().toUpperCase();
        this.mCellRange.reset();
        this.mFullRangeSelected = string.length() == 0;
        return string.length() == 0 || this.mCellRange.ExcelCellRngToCellRect(string);
    }

    private void processOkPasteAction(ActionEvent actionEvent, boolean bl) {
        if (actionEvent.getSource() instanceof JButton && !((JButton)actionEvent.getSource()).hasFocus()) {
            if (this.mPercentOfValuesDetermineDataTypeTextField.hasFocus()) {
                this.updatePreviewData();
            } else if (this.mRangeEdit.hasFocus() && this.continuePressed()) {
                this.updatePreviewData();
            }
            return;
        }
        if (this.continuePressed()) {
            this.saveSelectionsToExcelDac();
        }
        this.mOkToContinue = true;
        this.mDac.setIsPaste(bl);
        this.mWasPasteSelected = bl;
        this.dispose();
    }

    private void updatePreviewData() {
        ExcelDataProxy excelDataProxy;
        if (this.mPercentOfValuesDetermineDataTypeTextField.getText() == null) {
            return;
        }
        if (this.mPercentOfValuesDetermineDataTypeTextField.getText().length() < 1) {
            return;
        }
        int n = this.mWorksheetCombo.getSelectedIndex();
        assert (n > -1);
        this.validateRange();
        XlsCellRange xlsCellRange = new XlsCellRange(this.mCellRange.getLeft(), this.mCellRange.getTop(), this.mCellRange.getRight(), this.mCellRange.getBottom());
        boolean bl = this.mFullRangeSelected;
        if (xlsCellRange.getLeft() == 0 && xlsCellRange.getRight() == 0 && xlsCellRange.getBottom() == 0 && xlsCellRange.getTop() == 0) {
            if (this.mSheetInfos.get(n).getCellRng().getRight() - this.mSheetInfos.get(n).getCellRng().getLeft() > 499 || this.mSheetInfos.get(n).getCellRng().getBottom() - this.mSheetInfos.get(n).getCellRng().getTop() > 199) {
                xlsCellRange.setBottom(this.mSheetInfos.get(n).getCellRng().getBottom());
                xlsCellRange.setLeft(this.mSheetInfos.get(n).getCellRng().getLeft());
                xlsCellRange.setRight(this.mSheetInfos.get(n).getCellRng().getRight());
                xlsCellRange.setTop(this.mSheetInfos.get(n).getCellRng().getTop());
                if (this.mSheetInfos.get(n).getCellRng().getRight() - this.mSheetInfos.get(n).getCellRng().getLeft() > 499) {
                    xlsCellRange.setRight(499 + this.mSheetInfos.get(n).getCellRng().getLeft());
                    bl = false;
                }
                if (this.mSheetInfos.get(n).getCellRng().getBottom() - this.mSheetInfos.get(n).getCellRng().getTop() > 199) {
                    xlsCellRange.setBottom(199 + this.mSheetInfos.get(n).getCellRng().getTop());
                    bl = false;
                }
            }
        } else if (xlsCellRange.getRight() - xlsCellRange.getLeft() > 499 || xlsCellRange.getBottom() - xlsCellRange.getTop() > 199) {
            if (xlsCellRange.getRight() - xlsCellRange.getLeft() > 499) {
                xlsCellRange.setRight(499 + xlsCellRange.getLeft());
                bl = false;
            }
            if (xlsCellRange.getBottom() - xlsCellRange.getTop() > 199) {
                xlsCellRange.setBottom(199 + xlsCellRange.getTop());
                bl = false;
            }
        }
        Vector<VariableDescriptor> vector = null;
        Vector vector2 = null;
        boolean bl2 = false;
        if (this.mDac.getDacType().equals((Object)DacType.DAC_XLS)) {
            excelDataProxy = ExcelDataProxy.getExcelProxy();
            bl2 = excelDataProxy.getPreviewRecordsFromFile(this.mDac, this.mSheetInfos.get(n).getSheetName(), this.mSheetInfos.get(n).getSheetIdx(), xlsCellRange, bl, this.isReadVarNamesSelected(), this.mIgnoreHiddenRowsColsCB.isSelected(), this.isPercentOfValuesThatDetermineDataTypeSelected() ? new Double(this.mPercentOfValuesDetermineDataTypeTextField.getText()) : 100.0);
            if (bl2) {
                vector = new Vector<VariableDescriptor>();
                vector2 = excelDataProxy.getPreviewColInfo();
            }
        } else if (this.mDac.getDacType().equals((Object)DacType.DAC_XLSX) && (bl2 = (excelDataProxy = ExcelXDataProxy.getExcelXProxy()).getPreviewRecordsFromFile(this.mDac, this.mSheetInfos.get(n).getSheetName(), this.mSheetInfos.get(n).getSheetIdx(), xlsCellRange, bl, this.isReadVarNamesSelected(), this.mIgnoreHiddenRowsColsCB.isSelected(), this.isPercentOfValuesThatDetermineDataTypeSelected() ? new Double(this.mPercentOfValuesDetermineDataTypeTextField.getText()) : 100.0))) {
            vector = new Vector();
            vector2 = excelDataProxy.getPreviewColInfo();
        }
        if (bl2) {
            for (int i = 0; i < vector2.size(); ++i) {
                VariableDescriptor variableDescriptor = new VariableDescriptor(((ExcelPreviewColInfo)vector2.get(i)).getVarName());
                block0 : switch (((ExcelPreviewColInfo)vector2.get(i)).getVarSPSSType()) {
                    case 0: {
                        switch (((ExcelPreviewColInfo)vector2.get(i)).getVarSPSSFormatType()) {
                            case 3: {
                                variableDescriptor.setVarType(VariableDescriptor.VarType.eComma);
                                break block0;
                            }
                            case 4: {
                                variableDescriptor.setVarType(VariableDescriptor.VarType.eDollar);
                                break block0;
                            }
                            case 20: 
                            case 21: 
                            case 22: 
                            case 23: 
                            case 24: 
                            case 25: 
                            case 26: 
                            case 27: 
                            case 28: 
                            case 29: 
                            case 30: 
                            case 38: 
                            case 39: 
                            case 42: 
                            case 43: 
                            case 85: 
                            case 86: {
                                variableDescriptor.setVarType(VariableDescriptor.VarType.eDateTime);
                                break block0;
                            }
                            case 32: {
                                variableDescriptor.setVarType(VariableDescriptor.VarType.eDot);
                                break block0;
                            }
                        }
                        variableDescriptor.setVarType(VariableDescriptor.VarType.eNumeric);
                        break;
                    }
                    default: {
                        variableDescriptor.setVarType(VariableDescriptor.VarType.eString);
                    }
                }
                vector.add(variableDescriptor);
            }
            this.mExcelDacData.setVariableDescriptors(vector);
            this.updateVarDescriptorData();
            this.mPreviewTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public void updateVarDescriptorData() {
        Object object = this.mExcelDacData instanceof ExcelDac.ExcelDacData ? ExcelDataProxy.getExcelProxy() : ExcelXDataProxy.getExcelXProxy();
        Vector vector = this.mExcelDacData.getVariableDescriptors();
        Vector vector2 = object.getPreviewRawData();
        for (VariableDescriptor variableDescriptor : vector) {
            variableDescriptor.clearData();
        }
        for (int i = 0; i < vector2.size(); ++i) {
            for (int j = 0; j < ((Vector)vector2.get(i)).size(); ++j) {
                String string = (String)((Vector)vector2.get(i)).get(j);
                if (((VariableDescriptor)vector.get(j)).getVarType().equals((Object)VariableDescriptor.VarType.eDateTime)) {
                    try {
                        double d = Double.parseDouble(string);
                        if (d < 1.0) {
                            ((VariableDescriptor)vector.get(j)).addData(this.parseExcelTime(string));
                            continue;
                        }
                        Date date = this.parseExcelDate(d);
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy");
                        ((VariableDescriptor)vector.get(j)).addData(simpleDateFormat.format(date));
                    }
                    catch (NumberFormatException numberFormatException) {
                        ((VariableDescriptor)vector.get(j)).addData(string);
                    }
                    continue;
                }
                if (!((VariableDescriptor)vector.get(j)).getVarType().equals((Object)VariableDescriptor.VarType.eString) && string.length() == 0) {
                    string = ".";
                }
                if (this.mRemoveLeadingSpacesCB.isSelected()) {
                    string = string.replaceAll("^\\s+", "");
                }
                if (this.mRemoveTrailingSpacesCB.isSelected()) {
                    string = string.replaceAll("\\s+$", "");
                }
                ((VariableDescriptor)vector.get(j)).addData(string);
            }
        }
        this.mExcelDacData.setVariableDescriptors(vector);
        this.updateTable(false);
    }

    private Date parseExcelDate(double d) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        if (this.mExcelDacData instanceof ExcelDac.ExcelDacData) {
            d = d / 60.0 / 60.0 / 24.0 - 115860.0;
            int n = (int)Math.floor(d);
            int n2 = 1900;
            int n3 = 0;
            gregorianCalendar.set(n2, 0, n + n3, 0, 0, 0);
        } else {
            int n = 1900;
            int n4 = (int)Math.floor(d);
            int n5 = n4 < 61 ? 0 : -1;
            gregorianCalendar.set(n, 0, n4 + n5, 0, 0, 0);
        }
        return gregorianCalendar.getTime();
    }

    private String parseExcelTime(String string) {
        String string2 = "";
        try {
            double d = Double.parseDouble(string);
            boolean bl = true;
            double d2 = d * 24.0;
            short s = (short)(d2 + 0.5);
            double d3 = (d2 - (double)s) * 60.0;
            DecimalFormat decimalFormat = new DecimalFormat("#.0000");
            d3 = Double.valueOf(decimalFormat.format(d3).toString());
            short s2 = (short)(d3 + 0.5);
            short s3 = (short)((d3 - (double)s2) * 60.0 + 0.5);
            if (s3 < 0) {
                s3 = (short)Math.abs((short)((d3 - (double)s2) * 60.0));
                s2 = (short)(s2 - 1);
            }
            if (s >= 12) {
                s = (short)(s % 12);
            } else {
                bl = false;
            }
            if (s == s2 && s2 == s3 && s3 == 0) {
                s = 12;
            }
            string2 = String.format("%d:%02d:%02d %s", s, s2, s3, bl ? "PM" : "AM");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return string2;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        if (object.equals(this.mReadVarNamesFRomFirstRowCB)) {
            this.updatePreviewData();
        } else if (object.equals(this.mIgnoreHiddenRowsColsCB)) {
            this.updatePreviewData();
        } else if (object.equals(this.mPercentOfValuesThatDetermineDataTypeCB)) {
            this.updatePreviewData();
        } else if (object.equals(this.mRemoveLeadingSpacesCB)) {
            this.updateVarDescriptorData();
        } else if (object.equals(this.mRemoveTrailingSpacesCB)) {
            this.updateVarDescriptorData();
        } else if (itemEvent.getSource().equals(this.mWorksheetCombo) && itemEvent.getStateChange() == 1) {
            this.mRangeEdit.setText("");
            this.updatePreviewData();
        }
    }

    private boolean updateTable(boolean bl) {
        return this.updateTable(bl, false);
    }

    private boolean updateTable(boolean bl, boolean bl2) {
        int n;
        Vector vector;
        int[] nArray = !bl ? TableUtilities.saveColSizes((JTable)this.mPreviewTable) : null;
        int n2 = this.mPreviewTable.getSelectedColumn();
        Vector vector2 = this.mExcelDacData.getVariableDescriptors();
        DefaultTableModel defaultTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (VariableDescriptor variableDescriptor : vector2) {
            vector = variableDescriptor.getVarData();
            treeSet.add(vector.size());
        }
        if (treeSet.size() < 1) {
            defaultTableModel.setColumnCount(0);
            defaultTableModel.setRowCount(0);
            this.mPreviewTable.setModel(defaultTableModel);
            this.mPreviewTable.getTableHeader().resizeAndRepaint();
            defaultTableModel.fireTableDataChanged();
            return true;
        }
        defaultTableModel.setRowCount((Integer)treeSet.last());
        for (n = 0; n < 1; ++n) {
            int n3 = 0;
            defaultTableModel.addColumn("     ");
            for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                defaultTableModel.setValueAt(++n3, i, n);
            }
        }
        for (n = 0; n < vector2.size(); ++n) {
            VariableDescriptor variableDescriptor = (VariableDescriptor)vector2.get(n);
            defaultTableModel.addColumn(variableDescriptor.getModifiedVarName());
            vector = variableDescriptor.getVarData();
            for (int i = 0; i < vector.size(); ++i) {
                defaultTableModel.setValueAt(vector.get(i), i, n + 1);
            }
        }
        this.mPreviewTable.setModel(defaultTableModel);
        this.mPreviewTable.getColumnModel().getColumn(0).setMinWidth(0);
        this.mPreviewTable.getColumnModel().getColumn(0).setMaxWidth(1000);
        this.mPreviewTable.getColumnModel().getColumn(0).setPreferredWidth(0);
        this.mPreviewTable.getTableHeader().resizeAndRepaint();
        this.mPreviewTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                component.setBackground(jTable.getTableHeader().getBackground());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return component;
            }
        });
        defaultTableModel.fireTableDataChanged();
        for (n = 1; n < this.mPreviewTable.getColumnCount(); ++n) {
            TableColumn tableColumn = this.mPreviewTable.getColumnModel().getColumn(n);
            IconTableHeaderColumnRenderer iconTableHeaderColumnRenderer = new IconTableHeaderColumnRenderer(this.mPreviewTable, null, (VariableDescriptor)vector2.get(n - 1));
            tableColumn.setHeaderRenderer(iconTableHeaderColumnRenderer);
        }
        if (!bl) {
            TableUtilities.restoreColSizes((JTable)this.mPreviewTable, (int[])nArray);
            if (n2 != -1) {
                this.mPreviewTable.getColumnModel().getSelectionModel().setSelectionInterval(n2, n2);
            }
        }
        if (this.mPreviewTable.getColumnCount() != this.mOldColCount) {
            this.setDefaultTableColWidths();
        }
        this.mOldColCount = this.mPreviewTable.getColumnCount();
        return true;
    }

    private void setDefaultTableColWidths() {
        int n;
        int n2 = 0;
        for (n = 1; n < this.mPreviewTable.getColumnCount(); ++n) {
            TableColumn tableColumn = this.mPreviewTable.getColumnModel().getColumn(n);
            n2 += tableColumn.getWidth();
        }
        int n3 = n = this.mPreviewTable.getWidth() != 0 ? this.mPreviewTable.getWidth() : 400;
        if (n2 < n) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int[] nArray = ReadExcelFileDialog.this.calculateMinColumnHeaderSizes(ReadExcelFileDialog.this.mPreviewTable);
                    for (int i = 1; i < nArray.length; ++i) {
                        TableColumn tableColumn = ReadExcelFileDialog.this.mPreviewTable.getColumnModel().getColumn(i);
                        int n = nArray[i];
                        tableColumn.setPreferredWidth(n);
                        tableColumn.setWidth(n);
                    }
                    ReadExcelFileDialog.this.mPreviewTable.getTableHeader().resizeAndRepaint();
                }
            });
        }
    }

    protected int[] calculateMinColumnHeaderSizes(JTable jTable) {
        int[] nArray = new int[jTable.getColumnCount()];
        if (jTable != null) {
            for (int i = 1; i < jTable.getColumnCount(); ++i) {
                Serializable serializable;
                Component component = (Component)((Object)jTable.getTableHeader().getDefaultRenderer());
                if (component instanceof DefaultTableCellRenderer) {
                    FontMetrics fontMetrics;
                    String string;
                    serializable = ((DefaultTableCellRenderer)component).getTableCellRendererComponent(jTable, jTable.getColumnName(i), false, false, 0, i);
                    Icon icon = ReadTextDataWizardDlg.sVarIcons[ReadTextDataWizardDlg.VarImage.eScaleIdx.ordinal()];
                    if (icon != null) {
                        nArray[i] = icon.getIconWidth();
                    }
                    if ((string = ((JLabel)component).getText()) != null && (fontMetrics = component.getFontMetrics(component.getFont())) != null) {
                        int n = i;
                        nArray[n] = nArray[n] + (fontMetrics.stringWidth(string) + 15);
                    }
                }
                if (nArray[i] != 0 || (serializable = component.getFontMetrics(component.getFont())) == null) continue;
                nArray[i] = ((FontMetrics)serializable).stringWidth(jTable.getColumnName(i)) + 15;
            }
        }
        return nArray;
    }

    private void setDefaults() {
        this.mWorksheetCombo.setSelectedIndex(0);
        this.mWorksheetCombo.addItemListener(this);
        this.mRangeEdit.setText("");
        this.mPercentOfValuesThatDetermineDataTypeCB.addItemListener(this);
        this.mPercentOfValuesDetermineDataTypeTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReadExcelFileDialog.this.mPercentOfValuesDetermineDataTypeTextField.requestFocus();
                if (ReadExcelFileDialog.this.isPercentOfValuesThatDetermineDataTypeSelected() && ReadExcelFileDialog.this.mPercentOfValuesDetermineDataTypeTextField.checkRange(true)) {
                    ReadExcelFileDialog.this.updatePreviewData();
                }
            }
        });
        this.mPercentOfValuesDetermineDataTypeTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary() && ReadExcelFileDialog.this.isPercentOfValuesThatDetermineDataTypeSelected() && ReadExcelFileDialog.this.mPercentOfValuesDetermineDataTypeTextField.checkRange(true)) {
                    ReadExcelFileDialog.this.updatePreviewData();
                }
            }
        });
        this.mRangeEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReadExcelFileDialog.this.mRangeEdit.requestFocus();
                if (ReadExcelFileDialog.this.continuePressed()) {
                    ReadExcelFileDialog.this.updatePreviewData();
                }
            }
        });
        if (this.mExcelDacData instanceof ExcelDac.ExcelDacData) {
            this.mIgnoreHiddenRowsColsCB.setSelected(false);
            this.mIgnoreHiddenRowsColsCB.setEnabled(false);
        } else {
            this.mIgnoreHiddenRowsColsCB.setSelected(true);
            this.mIgnoreHiddenRowsColsCB.addItemListener(this);
        }
        this.mRemoveLeadingSpacesCB.setSelected(false);
        this.mRemoveLeadingSpacesCB.addItemListener(this);
        this.mRemoveTrailingSpacesCB.setSelected(false);
        this.mRemoveTrailingSpacesCB.addItemListener(this);
    }

    private void setDefaultsPostPreviewData() {
        ExcelDataProxy excelDataProxy;
        String string = null;
        String string2 = null;
        if (this.mExcelDacData instanceof ExcelDac.ExcelDacData) {
            excelDataProxy = ExcelDataProxy.getExcelProxy();
            string = excelDataProxy.getPreviewRecord();
            string2 = excelDataProxy.getPreviewRecord();
        }
        if (this.mExcelDacData instanceof ExcelXDac.ExcelXDacData) {
            excelDataProxy = ExcelXDataProxy.getExcelXProxy();
            string = excelDataProxy.getPreviewRecord();
            string2 = excelDataProxy.getPreviewRecord();
        }
        boolean bl = false;
        if (string != null & string2 != null) {
            bl = ReadTextDataWizardDlg.isFirstLineVariableNames(string, string2);
        }
        this.mReadVarNamesFRomFirstRowCB.setSelected(bl);
        this.mReadVarNamesFRomFirstRowCB.addItemListener(this);
        if (bl) {
            this.updatePreviewData();
        }
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mWorksheetCombo);
        vector.add(this.mRangeEdit);
        vector.add(this.mReadVarNamesFRomFirstRowCB);
        vector.add(this.mPercentOfValuesThatDetermineDataTypeCB);
        vector.add(this.mPercentOfValuesDetermineDataTypeTextField);
        vector.add(this.mIgnoreHiddenRowsColsCB);
        vector.add(this.mRemoveLeadingSpacesCB);
        vector.add(this.mRemoveTrailingSpacesCB);
        vector.add(this.mPreviewTable);
        vector.add(this.mInfoText);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    public boolean isReadVarNamesSelected() {
        return this.mReadVarNamesFRomFirstRowCB.isSelected();
    }

    public boolean isPercentOfValuesThatDetermineDataTypeSelected() {
        return this.mPercentOfValuesThatDetermineDataTypeCB.isSelected();
    }

    public String getSelectedSheetName() {
        return this.mSelectedSheetName;
    }

    @Override
    public void previewThreadComplete(Runnable runnable) {
        while (!this.wasDialogShown()) {
            try {
                Runtime.getRuntime().wait(500L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!ReadExcelFileDialog.this.updateTable(true)) {
                    throw new ExceptionInInitializerError();
                }
                ReadExcelFileDialog.this.setDefaultsPostPreviewData();
                ReadExcelFileDialog.this.saveResetOptions();
                ReadExcelFileDialog.this.mTableScroll.getViewport().removeAll();
                ReadExcelFileDialog.this.mTableScroll.getViewport().add(ReadExcelFileDialog.this.mPreviewTable);
                ReadExcelFileDialog.this.setComponentsEnabled(true, ReadExcelFileDialog.this.getViewPanel());
                ReadExcelFileDialog.this.setComponentsEnabled(true, ReadExcelFileDialog.this.getCmdButtonPanel());
                if (ReadExcelFileDialog.this.mExcelDacData instanceof ExcelDac.ExcelDacData) {
                    ReadExcelFileDialog.this.mIgnoreHiddenRowsColsCB.setSelected(false);
                    ReadExcelFileDialog.this.mIgnoreHiddenRowsColsCB.setEnabled(false);
                } else {
                    ReadExcelFileDialog.this.mIgnoreHiddenRowsColsCB.setSelected(true);
                    ReadExcelFileDialog.this.mIgnoreHiddenRowsColsCB.addItemListener(ReadExcelFileDialog.this);
                }
                ReadExcelFileDialog.this.mWorksheetCombo.requestFocusInWindow();
            }
        });
    }

    public class GetPreviewDataThread
    implements Runnable {
        private List<IPreviewThreadListener> listeners = Collections.synchronizedList(new ArrayList());

        public void doWork() {
            ReadExcelFileDialog.this.updatePreviewData();
        }

        public void addListener(IPreviewThreadListener iPreviewThreadListener) {
            this.listeners.add(iPreviewThreadListener);
        }

        public void removeListener(IPreviewThreadListener iPreviewThreadListener) {
            this.listeners.remove(iPreviewThreadListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void notifyListeners() {
            List<IPreviewThreadListener> list = this.listeners;
            synchronized (list) {
                for (IPreviewThreadListener iPreviewThreadListener : this.listeners) {
                    iPreviewThreadListener.previewThreadComplete(this);
                }
            }
        }

        @Override
        public void run() {
            this.doWork();
            this.notifyListeners();
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ReadExcelFileDialog.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ReadExcelFileDialog.this.mDac.setIsPaste(false);
            ReadExcelFileDialog.this.dispose();
        }
    }

    class ResetAction
    extends AbstractAction {
        ResetAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_RESET"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ReadExcelFileDialog.this.restoreSaveResetOptions();
            ReadExcelFileDialog.this.updatePreviewData();
            ReadExcelFileDialog.this.mDac.setIsPaste(false);
        }
    }

    class PasteAction
    extends AbstractAction {
        PasteAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_PASTE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ReadExcelFileDialog.this.processOkPasteAction(actionEvent, true);
        }
    }

    class OKAction
    extends AbstractAction {
        OKAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ReadExcelFileDialog.this.processOkPasteAction(actionEvent, false);
        }
    }
}

