/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.read_text_data;

import com.ibm.statistics.lighttable.ui.util.FileUtil;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.PES_Repository;
import com.spss.java_client.core.comp_util.PesFile;
import com.spss.java_client.core.documents.MRUMgr;
import com.spss.java_client.core.documents.data.DataDocument;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.data_access.DataAccessContainer;
import com.spss.java_client.core.documents.data.data_access.IDataAccessCallback;
import com.spss.java_client.core.documents.data.data_access.text.CaseDescriptor;
import com.spss.java_client.core.documents.data.data_access.text.TextDac;
import com.spss.java_client.core.documents.data.data_access.text.VariableDescriptor;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.ui.DAC.DacMgrUICallback;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.IPreviewThreadListener;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.ReadTextDataWizardDlg;
import com.spss.java_client.ui.dialogs.base.file.res.FileResBundle;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.controls.FocusableLabel;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class ReadCSVFileDialog
extends BaseDialog
implements IPreviewThreadListener {
    public static final int DELIMITER_COMMA = 0;
    public static final int DELIMITER_SEMICOLON = 1;
    public static final int DELIMITER_TAB = 2;
    public static final int DECIMAL_PERIOD = 0;
    public static final int DECIMAL_COMMA = 1;
    public static final int TEXT_QUALIFIER_DOUBLE_QUOTE = 0;
    public static final int TEXT_QUALIFIER_QUOTE = 1;
    public static final int TEXT_QUALIFIER_NONE = 2;
    private boolean mOkToContinue;
    protected boolean mWasPasteSelected = false;
    protected JCheckBox mFirstLineContainsVarNamesCB;
    protected JCheckBox mRemoveLeadingSpacesCB;
    protected JCheckBox mRemoveTrailingSpacesCB;
    protected JLabel mDelimeterLabel;
    protected JComboBox mDelimeterComboBox;
    protected JLabel mDecimalSymbolLabel;
    protected JComboBox mDecimalSymbolComboBox;
    protected JLabel mTextQualifierLabel;
    protected JComboBox mTextQualifierComboBox;
    SpssFrame mParentFrame;
    DataAccessContainer mDac;
    TextDac.TextDacData mTextDacData;
    FocusableLabel mFileTextAreaLabel;
    private FocusableTextArea mFileTextArea;
    JScrollPane mTextAreaScrollPane;
    protected JLabel mPercentOfValuesDetermineDataTypeSpinnerLabel;
    protected FloatTextField mPercentOfValuesDetermineDataTypeTextField;
    protected JCheckBox mCacheDataLocallyCB;
    protected JButton mAdvancedOptionsButton;
    protected int mfirstDetectedRecordLineNumber = 1;
    protected boolean mOldFirstLineContainsVarNames;
    protected boolean mOldAutoRecognizeDatesTimes;
    protected boolean mOldRemoveLeadingSpaces;
    protected boolean mOldRemoveTrailingSpaces;
    protected int mOldSelectedDelimeterIndex;
    protected int mOldSelectedDecimalSymbolIndex;
    protected int mOldSelectedTextQualifierIndex;
    protected Double mOldPercentOfValuesDetermineDataType = -1.1;

    public ReadCSVFileDialog(SpssFrame spssFrame, DataAccessContainer dataAccessContainer, TextDac.TextDacData textDacData) {
        super((JFrame)spssFrame, "", true, ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), FileResBundle.getImageFolder());
        this.mParentFrame = spssFrame;
        this.mDac = dataAccessContainer;
        this.mTextDacData = textDacData;
        this.setTitle(this.getResString("IDS_READ_CSV_DATA_DIALOG_TITLE"));
        this.myInit();
        this.setLocationRelativeTo(this.getParent());
        this.setComponentsEnabled(false, this.getViewPanel());
        this.setComponentsEnabled(false, this.getCmdButtonPanel());
        this.mFileTextArea.setEnabled(true);
        GetPreviewDataThread getPreviewDataThread = this.GetPreviewDataThread();
        getPreviewDataThread.addListener(this);
        new Thread(getPreviewDataThread).start();
        this.setVisible(true);
        getPreviewDataThread.removeListener(this);
    }

    private GetPreviewDataThread GetPreviewDataThread() {
        return new GetPreviewDataThread();
    }

    private void setComponentsEnabled(boolean bl, Component component) {
        Component[] componentArray;
        component.setEnabled(bl);
        if (component instanceof Container && (componentArray = ((Container)component).getComponents()) != null && componentArray.length > 0) {
            for (Component component2 : componentArray) {
                this.setComponentsEnabled(bl, component2);
            }
        }
    }

    @Override
    public void previewThreadComplete(Runnable runnable) {
        while (!this.wasDialogShown()) {
            try {
                Runtime.getRuntime().wait(500L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReadCSVFileDialog.this.setDefaults();
                ReadCSVFileDialog.this.saveResetOptions();
                ReadCSVFileDialog.this.setComponentsEnabled(true, ReadCSVFileDialog.this.getViewPanel());
                ReadCSVFileDialog.this.setComponentsEnabled(true, ReadCSVFileDialog.this.getCmdButtonPanel());
            }
        });
    }

    private void saveResetOptions() {
        this.mOldFirstLineContainsVarNames = this.mFirstLineContainsVarNamesCB.isSelected();
        this.mOldRemoveLeadingSpaces = this.mRemoveLeadingSpacesCB.isSelected();
        this.mOldRemoveTrailingSpaces = this.mRemoveTrailingSpacesCB.isSelected();
        this.mOldSelectedDelimeterIndex = this.mDelimeterComboBox.getSelectedIndex();
        this.mOldSelectedDecimalSymbolIndex = this.mDecimalSymbolComboBox.getSelectedIndex();
        this.mOldSelectedTextQualifierIndex = this.mTextQualifierComboBox.getSelectedIndex();
        this.mOldPercentOfValuesDetermineDataType = new Double(this.mPercentOfValuesDetermineDataTypeTextField.getText());
    }

    private void restoreSaveResetOptions() {
        this.mFirstLineContainsVarNamesCB.setSelected(this.mOldFirstLineContainsVarNames);
        this.mRemoveLeadingSpacesCB.setSelected(this.mOldRemoveLeadingSpaces);
        this.mRemoveTrailingSpacesCB.setSelected(this.mOldRemoveTrailingSpaces);
        this.mDelimeterComboBox.setSelectedIndex(this.mOldSelectedDelimeterIndex);
        this.mDecimalSymbolComboBox.setSelectedIndex(this.mOldSelectedDecimalSymbolIndex);
        this.mTextQualifierComboBox.setSelectedIndex(this.mOldSelectedTextQualifierIndex);
        this.mPercentOfValuesDetermineDataTypeTextField.setText("" + this.mOldPercentOfValuesDetermineDataType);
        this.mCacheDataLocallyCB.setSelected(true);
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, this.getDialogHelpID());
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        OKAction oKAction = new OKAction();
        JButton jButton = new JButton(oKAction);
        JButton jButton2 = new JButton(new PasteAction());
        JButton jButton3 = new JButton(new ResetAction());
        JButton jButton4 = new JButton(new CancelAction());
        JButton jButton5 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton5);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                int n3 = 0;
                DialogUtil.addUsingGBL(jPanel, jButton5, gridBagConstraints, n3, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton4, gridBagConstraints, ++n3, 0, 1, 1, n2, insets2);
                if (VersionInfo.allowSyntax()) {
                    DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, ++n3, 0, 1, 1, n2, insets2);
                }
                DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, ++n3, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, ++n3, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                if (VersionInfo.allowSyntax()) {
                    jPanel.add(jButton2);
                }
                jPanel.add(jButton3);
                jPanel.add(jButton4);
                jPanel.add(jButton5);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton4);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton5);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    public String getDialogHelpID() {
        return "idh_read_csv_file";
    }

    protected void init() {
    }

    protected void myInit() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        JPanel jPanel2 = this.setupMainPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(this.setTabTraversal(), false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        this.pack();
    }

    private JPanel setupMainPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top + 4, insets.left, insets.bottom, insets.right);
        int n = 23;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mFileTextAreaLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTextAreaScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mFirstLineContainsVarNamesCB, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mRemoveLeadingSpacesCB, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mRemoveTrailingSpacesCB, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        JPanel jPanel2 = this.createComboboxesPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 5, 1, 1, n, insets2);
        JPanel jPanel3 = this.createSpinnersPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 6, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mCacheDataLocallyCB, gridBagConstraints, 0, 7, 1, 1, n, insets2);
        JPanel jPanel4 = new JPanel(new FlowLayout(1));
        jPanel4.add(this.mAdvancedOptionsButton);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 8, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createComboboxesPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top + 4, insets.left, insets.bottom, insets.right);
        Insets insets3 = new Insets(insets.top + 4, insets.left + 10, insets.bottom, insets.right);
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mDelimeterLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mDelimeterComboBox, gridBagConstraints, 1, 0, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mDecimalSymbolLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mDecimalSymbolComboBox, gridBagConstraints, 1, 1, 1, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mTextQualifierLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mTextQualifierComboBox, gridBagConstraints, 1, 2, 1, 1, n, insets3);
        return jPanel;
    }

    private JPanel createSpinnersPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top + 4, insets.left, insets.bottom, insets.right);
        Insets insets3 = new Insets(insets.top + 4, insets.left + 10, insets.bottom, insets.right);
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mPercentOfValuesDetermineDataTypeSpinnerLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mPercentOfValuesDetermineDataTypeTextField, gridBagConstraints, 1, 0, 1, 1, n, insets3);
        return jPanel;
    }

    private void initVars() {
        this.mFileTextArea = new FocusableTextArea("\n\n\n" + this.getResString("IDS_RTD_PLEASE_WAIT") + this.mDac.getDataSpec());
        this.mFileTextArea.setLineWrap(true);
        this.mTextAreaScrollPane = new JScrollPane(this.mFileTextArea);
        this.mTextAreaScrollPane.setPreferredSize(new Dimension(600, 150));
        StringBuffer stringBuffer = new StringBuffer(this.getResString("IDS_READ_CSV_DATA_TEXT_AREA_LABEL"));
        String string = FileUtil.getBaseNameAndExtension((String)this.mDac.getDataSpec());
        stringBuffer.append(" ");
        stringBuffer.append(string);
        this.mFileTextAreaLabel = new FocusableLabel(stringBuffer.toString());
        this.mFirstLineContainsVarNamesCB = DialogUtil.createCheckBox(this, "IDS_READ_CSV_DATA_FIRST_LINE_CONTAINS_VAR_NAMES_CHECKBOX");
        this.mRemoveLeadingSpacesCB = DialogUtil.createCheckBox(this, "IDS_READ_CSV_DATA_REMOVE_LEADING_SPACES_CHECKBOX");
        this.mRemoveTrailingSpacesCB = DialogUtil.createCheckBox(this, "IDS_READ_CSV_DATA_REMOVE_TRAILING_SPACES_CHECKBOX");
        this.mDelimeterLabel = DialogUtil.createLabel(this, "IDS_READ_CSV_DATA_DELIMETER_BETWEEN_VALUES_CB");
        this.mDelimeterComboBox = new JComboBox();
        this.setComboEntries(this.mDelimeterComboBox, new String[]{this.getResString("IDS_READ_CSV_DATA_DELIMETER_BETWEEN_VALUES_COMMA"), this.getResString("IDS_READ_CSV_DATA_DELIMETER_BETWEEN_VALUES_SEMICOLON"), this.getResString("IDS_READ_CSV_DATA_DELIMETER_BETWEEN_VALUES_TAB")});
        this.mDelimeterLabel.setLabelFor(this.mDelimeterComboBox);
        this.mDecimalSymbolLabel = DialogUtil.createLabel(this, "IDS_READ_CSV_DATA_DECIMAL_SYMBOL_CB");
        this.mDecimalSymbolComboBox = new JComboBox();
        this.setComboEntries(this.mDecimalSymbolComboBox, new String[]{this.getResString("IDS_READ_CSV_DATA_DECIMAL_SYMBOL_PERIOD"), this.getResString("IDS_READ_CSV_DATA_DECIMAL_SYMBOL_COMMA")});
        this.mDecimalSymbolLabel.setLabelFor(this.mDecimalSymbolComboBox);
        this.mTextQualifierLabel = DialogUtil.createLabel(this, "IDS_READ_CSV_DATA_TEXT_QUALIFIER_CB");
        this.mTextQualifierComboBox = new JComboBox();
        this.setComboEntries(this.mTextQualifierComboBox, new String[]{this.getResString("IDS_READ_CSV_DATA_TEXT_QUALIFIER_DOUBLE_QUOTE"), this.getResString("IDS_READ_CSV_DATA_TEXT_QUALIFIER_SINGLE_QUOTE"), this.getResString("IDS_READ_CSV_DATA_TEXT_QUALIFIER_NONE")});
        this.mTextQualifierLabel.setLabelFor(this.mTextQualifierComboBox);
        this.mPercentOfValuesDetermineDataTypeSpinnerLabel = DialogUtil.createLabel(this, "IDS_READ_CSV_DATA_PERCENT_OF_VALUES_DETERMINE_DATA_TYPE_SPINNER");
        this.mPercentOfValuesDetermineDataTypeTextField = new FloatTextField(50.0, 100.0, 6);
        this.mPercentOfValuesDetermineDataTypeTextField.setText("95");
        this.mPercentOfValuesDetermineDataTypeTextField.setIncludeMinRange(false);
        this.mPercentOfValuesDetermineDataTypeSpinnerLabel.setLabelFor((Component)this.mPercentOfValuesDetermineDataTypeTextField);
        this.mCacheDataLocallyCB = DialogUtil.createCheckBox(this, "IDS_READ_CSV_DATA_CACHE_DATA_CHECKBOX");
        this.mAdvancedOptionsButton = DialogUtil.createButton(this, "IDS_READ_CSV_DATA_ADVANCED_OPTIONS_CB", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReadCSVFileDialog.this.dispose();
                ReadCSVFileDialog.this.restoreSaveResetOptions();
                DacMgrUICallback.closeFile();
                ReadTextDataWizardDlg.setDacInfo(ReadCSVFileDialog.this.mDac, ReadCSVFileDialog.this.mTextDacData);
                ReadTextDataWizardDlg readTextDataWizardDlg = new ReadTextDataWizardDlg(ReadCSVFileDialog.this.mParentFrame);
                if (readTextDataWizardDlg.isOkToContinue()) {
                    ReadCSVFileDialog.this.mDac.setIsPaste(readTextDataWizardDlg.isPaste());
                    ReadCSVFileDialog.this.mDac.setIsPasteOrRun(readTextDataWizardDlg.isPasteOrRun());
                    DacMgrUICallback dacMgrUICallback = new DacMgrUICallback(ReadCSVFileDialog.this.mParentFrame);
                    ReadCSVFileDialog.this.doFileImport(ReadCSVFileDialog.this.mDac, dacMgrUICallback);
                }
            }
        });
    }

    private boolean doFileImport(DataAccessContainer dataAccessContainer, IDataAccessCallback iDataAccessCallback) {
        String string = dataAccessContainer.getGeneratedSyntax();
        if (string == null) {
            return false;
        }
        if (dataAccessContainer.getIsPasteOrRun()) {
            if (dataAccessContainer.getIsPaste()) {
                boolean bl = true;
                if (iDataAccessCallback.canProcessPasteSyntax()) {
                    iDataAccessCallback.pasteSyntax("\n" + string);
                } else {
                    bl = SyntaxMgr.getSyntaxMgr().pasteSyntax("\n" + string);
                }
                if (bl && dataAccessContainer.getGenerateDatasetName()) {
                    DataDocument.pasteSetDatasetName();
                }
            } else if (iDataAccessCallback.proceedWithNewDataset()) {
                String string2;
                PesFile pesFile;
                if (SyntaxMgr.getSyntaxMgr().executeSyntax(string) && dataAccessContainer.getGenerateDatasetName()) {
                    DataDocument.runSetDatasetName();
                }
                if ((pesFile = PES_Repository.getPesFile((String)(string2 = dataAccessContainer.getDataSpec()))) != null) {
                    string2 = pesFile.getUri();
                }
                MRUMgr.getMRUMgr().addDataDocumentPath(string2);
            }
        }
        return true;
    }

    private void updateTextArea() {
        this.mFileTextArea.setLineWrap(false);
        this.mFileTextArea.setText(null);
        LinkedHashMap linkedHashMap = this.mTextDacData.getCaseMap();
        Iterator iterator = linkedHashMap.values().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        String string2 = null;
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (string2 == null && (string3.equals("\n") || string3.equals("\r\n"))) {
                ++this.mfirstDetectedRecordLineNumber;
                continue;
            }
            if (string2 == null && string3.length() > 0) {
                string2 = string3;
            } else if (string2 != null && string == null) {
                string = string3;
            }
            stringBuffer.append(string3);
            if (!iterator.hasNext()) continue;
            stringBuffer.append("\n");
        }
        this.mTextDacData.getCaseDescriptor().setCaseStartLineNumber(this.mfirstDetectedRecordLineNumber++);
        this.mFileTextArea.setText(stringBuffer.toString());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReadCSVFileDialog.this.mTextAreaScrollPane.getVerticalScrollBar().setValue(0);
            }
        });
        boolean bl = ReadTextDataWizardDlg.isFirstLineVariableNames(this.mTextDacData);
        this.mFirstLineContainsVarNamesCB.setSelected(bl);
        this.mTextDacData.getCaseDescriptor().setVarsAtTopOfFile(bl);
        this.mTextDacData.getCaseDescriptor().setVarsStartLineNumber(this.mfirstDetectedRecordLineNumber - 1);
        this.mDelimeterComboBox.setSelectedItem(this.getResStringForDelimiterInUse(string2));
    }

    private String getResStringForDelimiterInUse(String string) {
        String string2 = null;
        switch (ReadTextDataWizardDlg.getDelimiterInUse(string)) {
            case ',': {
                string2 = this.getResString("IDS_READ_CSV_DATA_DELIMETER_BETWEEN_VALUES_COMMA");
                break;
            }
            case ';': {
                string2 = this.getResString("IDS_READ_CSV_DATA_DELIMETER_BETWEEN_VALUES_SEMICOLON");
                break;
            }
            case '\t': {
                string2 = this.getResString("IDS_READ_CSV_DATA_DELIMETER_BETWEEN_VALUES_TAB");
            }
        }
        return string2;
    }

    protected void setComboEntries(JComboBox jComboBox, String[] stringArray) {
        if (jComboBox != null && stringArray != null) {
            jComboBox.setModel(new DefaultComboBoxModel<String>(stringArray));
        }
    }

    public boolean wasOkPressed() {
        return this.mOkToContinue;
    }

    public boolean isOkToContinue() {
        return this.mOkToContinue;
    }

    public boolean isPaste() {
        return this.mWasPasteSelected;
    }

    public boolean isPasteOrRun() {
        return this.mWasPasteSelected || this.mOkToContinue;
    }

    private void saveSelectionsToTextDac() {
        CaseDescriptor caseDescriptor = this.mTextDacData.getCaseDescriptor();
        caseDescriptor.setIsFixedWidth(false);
        caseDescriptor.setVarsAtTopOfFile(this.mFirstLineContainsVarNamesCB.isSelected());
        caseDescriptor.setCaseStartLineNumber(this.mFirstLineContainsVarNamesCB.isSelected() ? this.mfirstDetectedRecordLineNumber : this.mfirstDetectedRecordLineNumber - 1);
        caseDescriptor.setVarsAtTopOfFile(this.mFirstLineContainsVarNamesCB.isSelected());
        caseDescriptor.setStripLeadingSpaces(this.mRemoveLeadingSpacesCB.isSelected());
        caseDescriptor.setStripTrailingSpaces(this.mRemoveTrailingSpacesCB.isSelected());
        caseDescriptor.setIsDecimalSymbolPeriod(this.mDecimalSymbolComboBox.getSelectedIndex() == 0);
        caseDescriptor.setVarsStartLineNumber(this.mfirstDetectedRecordLineNumber - 1);
        caseDescriptor.setIsCommaDelim(false);
        caseDescriptor.setIsSemiColonDelim(false);
        caseDescriptor.setIsTabDelim(false);
        if (this.mDelimeterComboBox.getSelectedIndex() == 0) {
            caseDescriptor.setIsCommaDelim(true);
        } else if (this.mDelimeterComboBox.getSelectedIndex() == 1) {
            caseDescriptor.setIsSemiColonDelim(true);
        } else if (this.mDelimeterComboBox.getSelectedIndex() == 2) {
            caseDescriptor.setIsTabDelim(true);
        }
        if (this.mTextQualifierComboBox.getSelectedIndex() == 0) {
            caseDescriptor.setIsDoubleQuoteQualifier(true);
        } else if (this.mTextQualifierComboBox.getSelectedIndex() == 1) {
            caseDescriptor.setIsSingleQuoteQualifier(true);
        }
        caseDescriptor.setPercentageOfValuesToDetermineType(new Double(this.mPercentOfValuesDetermineDataTypeTextField.getText()).doubleValue());
        caseDescriptor.setLinesToScanForDataFormat(200);
        caseDescriptor.setCacheDataLocally(this.mCacheDataLocallyCB.isSelected());
        Vector vector = this.mTextDacData.getVariableDescriptors(true);
        this.validateVariableNames(vector);
    }

    private boolean canCloseDialog() {
        boolean bl = true;
        if (this.mDelimeterComboBox.getSelectedIndex() == 0 && this.mDecimalSymbolComboBox.getSelectedIndex() == 1) {
            int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("IDS_READ_CSV_DATA_COMMA_AS_BOTH_DECIMAL_AND_DELIMETER_ERROR"), this.getResString("IDS_READ_CSV_WARNING_DLG_TITLE"), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            if (n == 3) {
                this.mDelimeterComboBox.requestFocus();
                bl = false;
            }
        } else if (this.mPercentOfValuesDetermineDataTypeTextField.getText().trim().length() == 0) {
            SpssAlertOptionPane.showErrorMessageDialog(SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame(), this.getResString("IDS_READ_CSV_PERCENTAGE_OF_VALUES_EMPTY_WARNING"), VersionInfo.getAppVersionString());
            this.mPercentOfValuesDetermineDataTypeTextField.requestFocus();
            bl = false;
        }
        return bl;
    }

    private void validateVariableNames(Vector<VariableDescriptor> vector) {
        int n;
        Vector<String> vector2 = new Vector<String>();
        for (n = 0; n < vector.size(); ++n) {
            vector2.add(n, vector.get(n).getModifiedVarName());
        }
        n = VarNameValidator.generateSPSSNameForDac(vector2, (boolean)true) ? 1 : 0;
        if (n != 0) {
            for (int i = 0; i < vector2.size(); ++i) {
                vector.get(i).setModifiedVarName((String)vector2.get(i));
            }
        }
    }

    private void setDefaults() {
        CaseDescriptor caseDescriptor = this.mTextDacData.getCaseDescriptor();
        if (caseDescriptor.isCommaDelim()) {
            this.mDelimeterComboBox.setSelectedIndex(0);
        } else if (caseDescriptor.isSemiColonDelim()) {
            this.mDelimeterComboBox.setSelectedIndex(1);
        } else if (caseDescriptor.isTabDelim()) {
            this.mDelimeterComboBox.setSelectedIndex(2);
        }
        if (caseDescriptor.isDecimalSymbolPeriod()) {
            this.mDecimalSymbolComboBox.setSelectedIndex(0);
        } else {
            this.mDecimalSymbolComboBox.setSelectedIndex(1);
        }
        this.mTextQualifierComboBox.setSelectedIndex(0);
        this.mCacheDataLocallyCB.setSelected(true);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mFileTextAreaLabel);
        vector.add(this.mFileTextArea);
        vector.add(this.mFirstLineContainsVarNamesCB);
        vector.add(this.mRemoveLeadingSpacesCB);
        vector.add(this.mRemoveTrailingSpacesCB);
        vector.add(this.mDelimeterComboBox);
        vector.add(this.mDecimalSymbolComboBox);
        vector.add(this.mTextQualifierComboBox);
        vector.add(this.mPercentOfValuesDetermineDataTypeTextField);
        vector.add(this.mCacheDataLocallyCB);
        vector.add(this.mAdvancedOptionsButton);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }

    public class GetPreviewDataThread
    implements Runnable {
        private List<IPreviewThreadListener> listeners = Collections.synchronizedList(new ArrayList());

        public void doWork() {
            ResourceBundle resourceBundle;
            int n = DacMgrUICallback.openFileInitTextDacData(ReadCSVFileDialog.this.mDac);
            if (n == -2) {
                resourceBundle = ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
                SpssAlertOptionPane.showWarningMessageDialog(ReadCSVFileDialog.this.getOwner(), UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"ERR_RTD_BLANK_FILE_WARNING"), UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_RTD_WARNING_TITLE"));
            }
            if (n == -3) {
                resourceBundle = ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
                SpssAlertOptionPane.showWarningMessageDialog(ReadCSVFileDialog.this.getOwner(), UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"ERR_RTD_TOOBIG_WARNING"), UIToolResUtil.getString((ResourceBundle)resourceBundle, (String)"IDS_RTD_WARNING_TITLE"));
            } else {
                ReadCSVFileDialog.this.mTextDacData = (TextDac.TextDacData)ReadCSVFileDialog.this.mDac.getDacData();
                ReadCSVFileDialog.this.updateTextArea();
            }
        }

        public void addListener(IPreviewThreadListener iPreviewThreadListener) {
            this.listeners.add(iPreviewThreadListener);
        }

        public void removeListener(IPreviewThreadListener iPreviewThreadListener) {
            this.listeners.remove(iPreviewThreadListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void notifyListeners() {
            List<IPreviewThreadListener> list = this.listeners;
            synchronized (list) {
                for (IPreviewThreadListener iPreviewThreadListener : this.listeners) {
                    iPreviewThreadListener.previewThreadComplete(this);
                }
            }
        }

        @Override
        public void run() {
            this.doWork();
            this.notifyListeners();
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ReadCSVFileDialog.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ReadCSVFileDialog.this.dispose();
        }
    }

    class ResetAction
    extends AbstractAction {
        ResetAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_RESET"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ReadCSVFileDialog.this.restoreSaveResetOptions();
        }
    }

    class PasteAction
    extends AbstractAction {
        PasteAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_PASTE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ReadCSVFileDialog.this.canCloseDialog()) {
                ReadCSVFileDialog.this.saveSelectionsToTextDac();
                ReadCSVFileDialog.this.mOkToContinue = true;
                ReadCSVFileDialog.this.mWasPasteSelected = true;
                ReadCSVFileDialog.this.dispose();
            }
        }
    }

    class OKAction
    extends AbstractAction {
        OKAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ReadCSVFileDialog.this.canCloseDialog()) {
                ReadCSVFileDialog.this.saveSelectionsToTextDac();
                ReadCSVFileDialog.this.mOkToContinue = true;
                ReadCSVFileDialog.this.dispose();
            }
        }
    }
}

