/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.read_text_data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.documents.data.data_access.text.CaseDescriptor;
import com.spss.java_client.core.documents.data.data_access.text.VariableDescriptor;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.controls.VariableList;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.ReadTextDataWizardDlg;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

class IconTableHeaderColumnRenderer
extends DefaultTableCellRenderer {
    protected JTable mTable = null;
    private VariableDescriptor mVariableDescriptor;
    private CaseDescriptor mCaseDescriptor;
    private static int sHighlightColumn = -1;
    private static int sCurrentCol = -1;
    private static Border sDefaultBorder = null;
    private static Border sHighlightBorder = null;
    private static Border sLeadCellBorder = null;

    public IconTableHeaderColumnRenderer(JTable jTable, CaseDescriptor caseDescriptor, VariableDescriptor variableDescriptor) {
        this.init(jTable, caseDescriptor, variableDescriptor);
    }

    private void init(JTable jTable, CaseDescriptor caseDescriptor, VariableDescriptor variableDescriptor) {
        this.mVariableDescriptor = variableDescriptor;
        this.mTable = jTable;
        this.mCaseDescriptor = caseDescriptor;
        this.updateBorders();
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Object object2;
        Object object3;
        boolean bl3 = this.columnIsVisible(jTable, n2);
        if (bl3) {
            if (jTable != null && (object3 = jTable.getTableHeader()) != null) {
                boolean bl4;
                object2 = ((Component)object3).getFont();
                if (this.getFont() != object2) {
                    this.setFont((Font)object2);
                }
                if (bl4 = this.isColumnSelected(n2)) {
                    this.setBackground(jTable.getSelectionBackground());
                } else {
                    this.setBackground(((Component)object3).getBackground());
                }
                if (bl4) {
                    this.setForeground(jTable.getSelectionForeground());
                } else {
                    this.setForeground(((Component)object3).getForeground());
                }
            }
            this.setBorder(n2);
        }
        object2 = object3 = object == null ? "" : object.toString();
        this.setVerticalAlignment(1);
        this.setHorizontalAlignment(0);
        this.setHeaderIcon(n2);
        if (ComponentState.isBtdRtlOrLtr() && object2 != null && ((String)object2).length() > 0) {
            object2 = ComponentState.prepareStringForBidiRendering((String)object2);
        }
        this.setText((String)object2);
        return this;
    }

    private void setHeaderIcon(int n) {
        Icon icon = this.isHeaderBigEnoughForIcon(n) ? this.getMeasurementIcon(n) : null;
        this.setIcon(icon);
    }

    private Icon getMeasurementIcon(int n) {
        VariableDescriptor.VarType varType;
        Icon icon = null;
        if (this.mVariableDescriptor != null && (varType = this.mVariableDescriptor.getVarType()) != null) {
            if (varType == VariableDescriptor.VarType.eNumeric || varType == VariableDescriptor.VarType.eDollar || varType == VariableDescriptor.VarType.eDot || varType == VariableDescriptor.VarType.eComma) {
                icon = ReadTextDataWizardDlg.sVarIcons[ReadTextDataWizardDlg.VarImage.eScaleIdx.ordinal()];
            } else if (varType == VariableDescriptor.VarType.eString) {
                icon = ReadTextDataWizardDlg.sVarIcons[ReadTextDataWizardDlg.VarImage.eStringNominalIdx.ordinal()];
            } else if (varType == VariableDescriptor.VarType.eDateTime) {
                icon = ReadTextDataWizardDlg.sVarIcons[ReadTextDataWizardDlg.VarImage.eDateScaleIdx.ordinal()];
            }
        }
        return icon;
    }

    public Icon getIcon(ISpssVariable iSpssVariable) {
        Icon icon = iSpssVariable.getCustomIcon();
        icon = icon != null ? icon : VariableList.getStandardIcon(iSpssVariable);
        return icon;
    }

    private boolean isColumnSelected(int n) {
        int n2 = this.mTable.getSelectionModel().getMinSelectionIndex();
        int n3 = this.mTable.getSelectionModel().getMaxSelectionIndex();
        return this.mTable.isColumnSelected(n) && n2 == 0 && n3 == this.mTable.getRowCount() - 1;
    }

    public void highlightColumn(JTableHeader jTableHeader, int n, boolean bl) {
        int n2 = n > -1 ? n : sHighlightColumn;
        sHighlightColumn = bl ? n : -1;
        Rectangle rectangle = jTableHeader.getHeaderRect(n2);
        jTableHeader.paintImmediately(rectangle);
    }

    void setCurrentCol(JTableHeader jTableHeader, int n, boolean bl) {
        Rectangle rectangle;
        if (!bl && sCurrentCol == n) {
            return;
        }
        if (sCurrentCol > -1) {
            rectangle = jTableHeader.getHeaderRect(sCurrentCol);
            jTableHeader.repaint(100L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (n > -1) {
            rectangle = jTableHeader.getHeaderRect(n);
            jTableHeader.repaint(100L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (bl) {
            sCurrentCol = n;
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
    }

    protected void setBorder(int n) {
        boolean bl = this.mTable.getColumnModel().getSelectionModel().getLeadSelectionIndex() == n;
        Border border = sDefaultBorder;
        if (sHighlightColumn == n) {
            border = sHighlightBorder;
        } else if (bl) {
            border = sLeadCellBorder;
        }
        this.setBorder(border);
    }

    boolean columnIsVisible(JTable jTable, int n) {
        boolean bl;
        Rectangle rectangle = jTable.getVisibleRect();
        int n2 = jTable.columnAtPoint(rectangle.getLocation());
        int n3 = n < 400 ? jTable.columnAtPoint(new Point((int)rectangle.getMaxX(), (int)rectangle.getMaxY())) : n2 + 48;
        boolean bl2 = bl = n >= (n2 -= 16) && n <= (n3 += 16);
        if (bl) {
            bl = jTable.getColumnModel().getColumn(n).getWidth() > 0;
        }
        return bl;
    }

    protected boolean isHeaderBigEnoughForIcon(int n) {
        boolean bl = false;
        Rectangle rectangle = this.mTable.getTableHeader().getHeaderRect(n);
        Graphics graphics = this.mTable.getTableHeader().getGraphics();
        if (graphics != null) {
            bl = this.isHeaderBigEnoughForIcon(rectangle, this.getMeasurementIcon(n), graphics.getFontMetrics());
        }
        return bl;
    }

    protected boolean isHeaderBigEnoughForIcon(Rectangle rectangle, Icon icon, FontMetrics fontMetrics) {
        boolean bl = false;
        bl = rectangle != null && icon != null && fontMetrics != null ? rectangle.width > icon.getIconWidth() + fontMetrics.stringWidth("W") + 2 : false;
        return bl;
    }

    protected String wrapHeaderText(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Rectangle rectangle = this.mTable.getTableHeader().getHeaderRect(n);
        Graphics graphics = this.mTable.getTableHeader().getGraphics();
        if (graphics == null) {
            return string;
        }
        Icon icon = this.getMeasurementIcon(n);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        boolean bl = this.isHeaderBigEnoughForIcon(rectangle, icon, fontMetrics);
        int n2 = icon != null && bl ? rectangle.width - icon.getIconWidth() - 6 : rectangle.width;
        graphics.dispose();
        stringBuffer.append("<html><center>");
        stringBuffer.append(this.sliceString(fontMetrics, string, n2));
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    private String sliceString(FontMetrics fontMetrics, String string, int n) {
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string3;
            int n2;
            int n3 = 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (n2 = 0; n2 < 3; ++n2) {
                string3 = "";
                boolean bl = false;
                do {
                    int n4;
                    if ((n4 = fontMetrics.stringWidth(string3 = string3 + string.charAt(n3++))) + 2 > n) {
                        if (string3.length() > 1) {
                            --n3;
                            string3 = string3.substring(0, string3.length() - 1);
                            arrayList.add(string3);
                        }
                        bl = true;
                        continue;
                    }
                    if (n3 != string.length()) continue;
                    arrayList.add(string3);
                    bl = true;
                } while (!bl);
                if (n3 >= string.length()) break;
            }
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                string3 = (String)arrayList.get(n2);
                stringBuffer.append(string3);
                if (n2 + 1 == arrayList.size() && n3 < string.length()) {
                    stringBuffer.append("...");
                    continue;
                }
                if (n2 + 1 >= arrayList.size()) continue;
                stringBuffer.append("<br>");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    private void updateBorders() {
        if (sDefaultBorder == null) {
            sDefaultBorder = UIManager.getBorder("TableHeader.cellBorder");
        }
        if (sHighlightBorder == null) {
            sHighlightBorder = new HighlightBevelBorder();
        }
        if (sLeadCellBorder == null) {
            sLeadCellBorder = BorderFactory.createEtchedBorder(1);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleDragTableColumnRenderer();
        }
        return this.accessibleContext;
    }

    protected class AccessibleDragTableColumnRenderer
    extends JLabel.AccessibleJLabel {
        protected AccessibleDragTableColumnRenderer() {
            super(IconTableHeaderColumnRenderer.this);
        }

        @Override
        public String getAccessibleName() {
            String string = super.getAccessibleName();
            String string2 = "<html><center>";
            String string3 = "</html>";
            if (string.startsWith(string2)) {
                string = string.substring(string2.length());
                string = string.substring(0, string.indexOf(string3));
                string = string.replace("<br>", "\n");
            }
            return string;
        }
    }

    static class HighlightBevelBorder
    extends BevelBorder {
        private Color mHighlightColor = new Color(156, 0, 0);
        private Stroke mStroke = new BasicStroke(1.0f);

        HighlightBevelBorder() {
            super(0);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            super.paintBorder(component, graphics, n, n2, n3, n4);
            if (graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Color color = graphics.getColor();
                Stroke stroke = graphics2D.getStroke();
                graphics.setColor(this.mHighlightColor);
                graphics2D.setStroke(this.mStroke);
                graphics.drawLine(n, n2, n, n2 + n4);
                graphics2D.setStroke(stroke);
                graphics.setColor(color);
            }
        }
    }
}

