/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.read_text_data;

import com.spss.java_client.core.documents.data.data_access.text.CaseDescriptor;
import com.spss.java_client.ui.DAC.DacMgrUICallback;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.dialogs.base.file.read_text_data.ReadTextDataWizardDlg;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SwingWorker;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;

public class AutoDetectProgressDailog
extends BaseDialog {
    private boolean mWasCancelSelected = false;
    JProgressBar mProgressBar;
    ReadTextDataWizardDlg mReadTextDataWizardDlg;
    CaseDescriptor mCaseDescriptor;
    int mNumLinesToScan = -1;
    boolean mEndOfFileReached = false;
    boolean mAllRecordsRead = false;
    MyLinesReadProgressListener mMyLinesReadProgressListener;
    FocusableTextArea mStatusText;
    SwingWorker mWorker;

    public AutoDetectProgressDailog(ReadTextDataWizardDlg readTextDataWizardDlg, int n, CaseDescriptor caseDescriptor) throws HeadlessException {
        super((BaseDialog)readTextDataWizardDlg, "", true, readTextDataWizardDlg.getResourceBundle(), readTextDataWizardDlg.getImageFilePath());
        this.setTitle(this.getResString("IDS_TEXT_IMPORT_WIZARD_AUTO_FORMAT_TYPES_DLG_TITLE"));
        this.mReadTextDataWizardDlg = readTextDataWizardDlg;
        this.mCaseDescriptor = caseDescriptor;
        this.mNumLinesToScan = n;
        this.mMyLinesReadProgressListener = new MyLinesReadProgressListener();
        this.initPanel();
        this.pack();
        this.setTabTraversalOrder();
        this.setLocationRelativeTo((Component)((Object)this.mReadTextDataWizardDlg));
        this.startReadingCases();
        this.setVisible(true);
    }

    private void startReadingCases() {
        this.mWorker = new SwingWorker<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Object construct() {
                DacMgrUICallback.updateTextDacData(AutoDetectProgressDailog.this.mReadTextDataWizardDlg.getDataAccessContainer(), AutoDetectProgressDailog.this.mNumLinesToScan, true, false, AutoDetectProgressDailog.this.mMyLinesReadProgressListener);
                AutoDetectProgressDailog.this.dispose();
                return true;
            }
        };
        this.mWorker.start();
    }

    public String getDialogHelpID() {
        return "idh_tcm_scenarios_scenarioperiod";
    }

    public String getNextProcDlgActionKey() {
        return "";
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, this.getDialogHelpID());
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        JButton jButton = new JButton(new CancelAction());
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 0, 0, 1, 1, n2, null);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    public void initPanel() {
        this.initVars();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n2, n2);
        JPanel jPanel = this.getViewPanel();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mProgressBar, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(this.mStatusText);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.setTabPolicy();
    }

    private void initVars() {
        this.mProgressBar = new JProgressBar(0, this.mNumLinesToScan);
        this.mProgressBar.setPreferredSize(new Dimension(400, 60));
        this.mProgressBar.setValue(0);
        this.mStatusText = new FocusableTextArea("");
    }

    private void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mProgressBar);
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void setTabPolicy() {
    }

    public boolean wasCancelSelected() {
        return this.mWasCancelSelected;
    }

    public boolean isAllRecordsRead() {
        return this.mEndOfFileReached || this.mAllRecordsRead;
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AutoDetectProgressDailog.this.mWasCancelSelected = true;
            DacMgrUICallback.killUpdateTextDacData();
        }
    }

    class MyLinesReadProgressListener
    implements DacMgrUICallback.LinesReadProgressListener {
        MyLinesReadProgressListener() {
        }

        @Override
        public void linesReadProgressProgress(int n, int n2, int n3) {
            AutoDetectProgressDailog.this.mProgressBar.setValue(n);
            String string = " {0}\\{1} ({2}%)";
            String string2 = MessageFormat.format(string, n, n2, n3);
            AutoDetectProgressDailog.this.mStatusText.setText(string2);
        }

        @Override
        public void endOfFileReached() {
            AutoDetectProgressDailog.this.mEndOfFileReached = true;
        }

        @Override
        public void allLinesReadSuccessfully() {
            AutoDetectProgressDailog.this.mAllRecordsRead = true;
        }

        @Override
        public void updateStopped() {
            AutoDetectProgressDailog.this.mWasCancelSelected = true;
        }
    }
}

