/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.welcome;

import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.IDialogCallback;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.data_access.ODBC.ODBCDacProxy;
import com.spss.java_client.core.error_handler.ErrorDispatcher;
import com.spss.java_client.core.error_handler.ErrorEventMsg;
import com.spss.java_client.core.error_handler.IErrorHandler;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.core.server.IServerComm;
import com.spss.java_client.core.server.messages.DataAccess.DataSourceInfo;
import com.spss.java_client.core.server.messages.DataAccess.OleDbDataSourceInfo;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.ODBCWizardCapabilities;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.base.file.DialogCallbackImpl;
import com.spss.java_client.ui.dialogs.base.file.OleDbConnectInfoDlg;
import com.spss.java_client.ui.dialogs.base.file.openquery.AbstractDBWizardCommonPage;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBData;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBWizardDlgType;
import com.spss.java_client.ui.dialogs.base.file.openquery.NewQueryDlg;
import com.spss.java_client.ui.dialogs.base.file.openquery.UIData;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.JoinData;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBListCellRenderer;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBListEntry;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBWizardUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBC;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.SPSSUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.Selected;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.winutils.LaunchOLEDB;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;

public class WelcomePage
extends AbstractDBWizardCommonPage
implements WindowListener,
ItemListener,
ListSelectionListener,
MouseListener,
FocusListener,
IErrorHandler {
    private static int DSN_REFRESH_PERIOD = 1000;
    private DialogFocusTraversalPolicy mPolicy;
    private JList mList;
    private JList mOleList;
    private DefaultListModel mOleListModel;
    private JButton mDataSourceButton;
    private JButton mOleDataSourceButton;
    private boolean mUseODBC = true;
    private boolean mOleDbInstalled;
    private String mOledbConnectionString;
    private HashMap<String, String> mOledbConnStr;
    private JScrollPane mScrollPane;
    private JScrollPane mOlePane;
    private boolean mInWindowActivated = false;
    private boolean mHandledODBCFailure = false;
    private LaunchOLEDB mOledbDialog = null;
    private Long mLastTimeUpdate = 0L;
    private JCheckBox mTablesCheck;
    private JCheckBox mViewsCheck;
    private JCheckBox mSynonymsCheck;
    private JCheckBox mSystemTablesCheck;
    private boolean mGroupAuthorizationModeActive = false;

    public WelcomePage(BaseWizardDialog baseWizardDialog) {
        super("WelcomePage", baseWizardDialog.getResString("IDS_DB_WEL_TITLE"), baseWizardDialog, true);
        ErrorDispatcher.getErrorDispatcher().addListener((IErrorHandler)this);
        IServerComm iServerComm = DataServerProxy.getDataProxy().getServerConnection();
        this.mGroupAuthorizationModeActive = false;
        if (iServerComm != null) {
            String string = iServerComm.GetValueFromAppRegistry("group-auth-service-name", "");
            String string2 = iServerComm.GetValueFromAppRegistry("group-auth-service-url", "");
            this.mGroupAuthorizationModeActive = string.length() > 0 && string2.length() > 0;
        }
    }

    @Override
    public void init() {
        DBWizardUtil.setDialog(this.mWizardDialog);
        this.mWizardDialog.addWindowListener(this);
        this.mOleDbInstalled = ODBCDacProxy.getODBCDacProxy().isIsOleDbInstalledOnServer();
        super.init();
    }

    @Override
    public String getNextPage() {
        DBWizardUtil.setDialog(this.mWizardDialog);
        if (this.setTableData()) {
            if (ODBC.getODBC().getTables().size() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_EX2DB_WELCOME_NO_TABLES_PRESENT"), this.mWizardDialog.getResString("IDS_DB_RESULTS_OPTION_PANE_TITLE"));
                return "WelcomePage";
            }
            this.setUIData();
            DBWizardUtil.setDBWizardPreviousPage(DBWizardUtil.DBWizardPreviousPage.eWelcome);
            return "SelectDataPage";
        }
        return "WelcomePage";
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Border border = UIManager.getBorder("Table.focusCellHighlightBorder");
        if (focusEvent.getSource().equals(this.mList)) {
            this.mScrollPane.setBorder(border);
        } else if (focusEvent.getSource().equals(this.mOleList)) {
            this.mOlePane.setBorder(border);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        LineBorder lineBorder = new LineBorder(Color.GRAY);
        if (focusEvent.getSource().equals(this.mList)) {
            this.mScrollPane.setBorder(lineBorder);
        } else if (focusEvent.getSource().equals(this.mOleList)) {
            this.mOlePane.setBorder(lineBorder);
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_tablewizard";
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        this.mInWindowActivated = true;
        if (this.mWizardDialog.getWizardModel().getCurrentPage() == this) {
            this.updateDSNlist();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource().equals(this.mList)) {
            if (this.mList.getSelectedIndex() != -1 && this.mOleDbInstalled) {
                this.mOleList.clearSelection();
            }
            this.mWizardDialog.enableNext(this.mList.getSelectedIndex() > -1);
        } else if (this.mOleDbInstalled && listSelectionEvent.getSource().equals(this.mOleList)) {
            if (this.mOleList.getSelectedIndex() != -1) {
                this.mList.clearSelection();
            }
            this.mWizardDialog.enableNext(this.mOleList.getSelectedIndex() > -1);
        }
        this.mUseODBC = this.mList.getSelectedIndex() >= 0 || !this.mOleDbInstalled;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.mList)) {
            if (this.mOleList != null && this.mOleList.getModel().getSize() > 0) {
                this.mOleList.removeSelectionInterval(0, this.mOleList.getModel().getSize() - 1);
            }
            if (this.mList.getModel().getSize() == 0) {
                this.mList.clearSelection();
                this.mWizardDialog.enableNext(false);
            } else {
                this.mWizardDialog.enableNext(this.mList.getSelectedIndex() > -1);
            }
        } else if (mouseEvent.getSource().equals(this.mOleList)) {
            if (this.mList.getModel().getSize() > 0) {
                this.mList.removeSelectionInterval(0, this.mList.getModel().getSize() - 1);
            }
            if (this.mOleList.getModel().getSize() == 0) {
                this.mOleList.clearSelection();
                this.mWizardDialog.enableNext(false);
            } else {
                this.mWizardDialog.enableNext(this.mOleList.getSelectedIndex() > -1);
            }
        }
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
            this.mWizardDialog.showWizardPage(this.mWizardDialog.getWizardModel().getCurrentPage(), this.mWizardDialog.getWizardModel().getNextPage());
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mTablesCheck || itemEvent.getSource() == this.mSynonymsCheck || itemEvent.getSource() == this.mSystemTablesCheck || itemEvent.getSource() == this.mViewsCheck) {
            this.doItemStateChange();
        }
    }

    private void doItemStateChange() {
        boolean bl = this.mTablesCheck.isSelected();
        boolean bl2 = this.mSynonymsCheck.isSelected();
        boolean bl3 = this.mSystemTablesCheck.isSelected();
        boolean bl4 = this.mViewsCheck.isSelected();
        boolean bl5 = bl || bl2 || bl3 || bl4;
        this.mWizardDialog.enableNext(true);
        if (!bl5) {
            this.mWizardDialog.enableNext(false);
        }
        String string = bl ? "User," : "";
        string = string + (bl4 ? "View," : "");
        string = string + (bl2 ? "Synonym," : "");
        string = string + (bl3 ? "System" : "");
        Selected.getSelected().setSelectedTableTypes(string);
    }

    @Override
    public boolean validate() {
        return super.validate();
    }

    public void handleError(ErrorEventMsg errorEventMsg) {
        if (OSInfo.getOSType().equals((Object)OSInfo.OSType.LINUX) && (errorEventMsg.getErrorCode() == -14 || errorEventMsg.getErrorCode() == -12)) {
            if (this.mInWindowActivated && !this.mHandledODBCFailure) {
                this.mHandledODBCFailure = true;
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_DB_WELCOME_NO_ODBC_PRESENT"), this.mWizardDialog.getResString("IDS_DB_RESULTS_OPTION_PANE_TITLE"));
                this.mWizardDialog.dispose();
            }
            errorEventMsg.setErrorHandled(true);
            errorEventMsg.setUserNotified(true);
        }
    }

    @Override
    protected void aboutToShowPanel() {
        super.aboutToShowPanel();
        this.mWizardDialog.enableFinish(false);
        this.mWizardDialog.enableBack(false);
        this.mWizardDialog.setDefaultButton(BaseWizardDialog.WizardButton.eNext);
        this.readUIData();
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        if (DBWizardUtil.getDBWizardPreviousPage().equals((Object)DBWizardUtil.DBWizardPreviousPage.eSelectData)) {
            ODBC.getODBC().disconnect();
            if (DBWizardDlgType.isEditQuery()) {
                this.updateDSNlist();
            }
            if (this.mList.getSelectedIndex() > -1) {
                this.mList.requestFocusInWindow();
            }
            if (this.mOleList != null && this.mOleList.getSelectedIndex() > -1) {
                this.mOleList.requestFocusInWindow();
            }
        }
        if (OSInfo.getOSType().equals((Object)OSInfo.OSType.LINUX) && this.mList.getModel().getSize() < 1) {
            this.updateDSNlist();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!(WelcomePage.this.mList.getModel().getSize() >= 1 || WelcomePage.this.mOleList != null && WelcomePage.this.mOleList.getModel().getSize() >= 1 || WelcomePage.this.mDataSourceButton.isEnabled() || WelcomePage.this.mOleDataSourceButton.isEnabled())) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)WelcomePage.this.mWizardDialog), WelcomePage.this.mWizardDialog.getResString("ERR_DB_WELCOME_NO_ODBC_PRESENT_DW"), WelcomePage.this.mWizardDialog.getResString("IDS_DB_RESULTS_OPTION_PANE_TITLE"));
                    WelcomePage.this.mWizardDialog.dispose();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateDSNlist() {
        Long l = this.mLastTimeUpdate;
        synchronized (l) {
            long l2 = System.currentTimeMillis() - this.mLastTimeUpdate;
            if (l2 < (long)DSN_REFRESH_PERIOD) {
                return;
            }
            try {
                ((DefaultListModel)this.mList.getModel()).clear();
                this.doPopulateDSNList();
                int n = this.getIndexToSelect(true);
                boolean bl = this.mUseODBC = n >= 0 || !this.mOleDbInstalled;
                if (this.mOleDbInstalled && !this.mUseODBC) {
                    if (this.mOleList.getModel().getSize() > 0) {
                        this.mOleList.setSelectedIndex(0);
                    }
                    this.mWizardDialog.enableNext(this.mOleList.getSelectedIndex() > -1);
                    this.mOleList.requestFocusInWindow();
                } else {
                    this.mList.setSelectedIndex(n);
                    if (n > 0) {
                        Rectangle rectangle = this.mList.getCellBounds(n - 1, n + 2);
                        if (rectangle != null) {
                            this.mList.scrollRectToVisible(rectangle);
                        } else {
                            this.mList.ensureIndexIsVisible(n);
                        }
                    }
                    this.mWizardDialog.enableNext(this.mList.getSelectedIndex() > -1);
                    this.mList.requestFocusInWindow();
                }
            }
            finally {
                this.mLastTimeUpdate = System.currentTimeMillis();
            }
        }
    }

    @Override
    protected void aboutToHidePanel() {
        super.aboutToHidePanel();
        JoinData.getJoinData().clear();
        DBWizardDlgType.setDBWizardDlgType(DBWizardDlgType.DBWizardDialogTypeEnum.eNewQueryDlg);
    }

    @Override
    protected void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mList);
        if (this.mOleDbInstalled) {
            vector.add(this.mOleList);
        }
        vector.add(this.mDataSourceButton);
        if (this.mOleDbInstalled) {
            vector.add(this.mOleDataSourceButton);
        }
        vector.add(this.mTablesCheck);
        vector.add(this.mViewsCheck);
        vector.add(this.mSynonymsCheck);
        vector.add(this.mSystemTablesCheck);
        Vector<Object> vector2 = ((NewQueryDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    @Override
    protected JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 4;
        Insets insets = new Insets(n2, n2, 0, n2);
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString("IDS_DB_WEL_WELCOME"));
        jLabel.setFont(jLabel.getFont().deriveFont(1, 18.0f));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        JLabel jLabel2 = new JLabel(this.mWizardDialog.getResString("IDS_DB_WEL_WELCOME_1"));
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 2, 1, n, insets);
        JTextArea jTextArea = new JTextArea(this.mWizardDialog.getResString("IDS_DB_WEL_WELCOME_2"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 2, 2, 1, n, insets);
        gridBagConstraints.fill = 0;
        JLabel jLabel3 = new JLabel(this.mWizardDialog.getResString("IDS_DB_WEL_WELCOME_3"));
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 3, 2, 1, n, insets);
        return jPanel;
    }

    @Override
    protected void initVars() {
        this.mOledbConnStr = new HashMap();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_DB_ADD_DATA_SOURCE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (OSInfo.getOSType().equals((Object)OSInfo.OSType.WIN)) {
                    if (!OSInfo.isWindowsXP()) {
                        WelcomePage.this.setOleDbToNativeClass();
                        ConnectionHandler connectionHandler = new ConnectionHandler(OleDbLaunchType.admin);
                        connectionHandler.start();
                    } else {
                        try {
                            Runtime.getRuntime().exec(System.getenv("windir") + WelcomePage.this.mWizardDialog.getResString("IDS_DB_ODBC_EXE_PATH"));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                } else if (OSInfo.getOSType().equals((Object)OSInfo.OSType.MAC)) {
                    try {
                        String[] stringArray;
                        String string = "/Applications/Utilities/ODBC Administrator.app";
                        File file = new File(string);
                        if (!file.exists() && (string = (stringArray = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options").node("data")).get("mac_odbc_app", null)) == null) {
                            File file2;
                            JFileChooser jFileChooser = new JFileChooser();
                            jFileChooser.setDialogTitle(WelcomePage.this.mWizardDialog.getResString("IDS_DB_WELCOME_MAC_ODBC_PROMPT"));
                            File file3 = new File("/Applications/Utilities");
                            jFileChooser.setCurrentDirectory(file3);
                            int n = jFileChooser.showOpenDialog(this.mMainDialog.getRootPane());
                            if (n == 0 && (string = (file2 = jFileChooser.getSelectedFile()).getCanonicalPath()) != null & string.length() > 0) {
                                stringArray.put("mac_odbc_app", string);
                            }
                        }
                        if (string != null) {
                            stringArray = new String[]{"open", string};
                            Runtime.getRuntime().exec(stringArray);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        };
        this.mDataSourceButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_DB_ADD_OLEDB_DATA_SOURCE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WelcomePage.this.mOledbConnectionString = "";
                WelcomePage.this.setOleDbToNativeClass();
                WelcomePage.this.mWizardDialog.setEnabled(false);
                ConnectionHandler connectionHandler = new ConnectionHandler(OleDbLaunchType.load);
                connectionHandler.start();
            }
        };
        this.mOleDataSourceButton = new JButton(toggleButtonAction);
        this.mList = new JList();
        this.mList.setModel(new DefaultListModel());
        this.mList.setSelectionMode(0);
        this.mList.setSelectedIndex(0);
        this.mList.addListSelectionListener(this);
        this.mList.requestFocus();
        this.mList.addMouseListener(this);
        this.mList.addFocusListener(this);
        this.mList.setBorder(new EmptyBorder(1, 1, 1, 1));
        if (this.mOleDbInstalled) {
            this.doPopulateOleDbList();
            this.mOleList.addListSelectionListener(this);
            this.mOleList.addMouseListener(this);
            this.mOleList.setSelectionMode(0);
            this.mOleList.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.mOleList.addFocusListener(this);
        }
        if (StringUtils.isBlank((String)Selected.getSelected().getSelectedTableTypes())) {
            if (DBWizardDlgType.getDBWizardDlgType().equals((Object)DBWizardDlgType.DBWizardDialogTypeEnum.eEditQueryDlg)) {
                Selected.getSelected().setSelectedTableTypes("User,View,Synonym,System");
            } else {
                Selected.getSelected().setSelectedTableTypes("User");
            }
        }
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_DB_WEL_TABLE_CHECK_LABEL");
        this.mTablesCheck = new JCheckBox(toggleButtonAction);
        this.mTablesCheck.setSelected(Selected.getSelected().getSelectedTableTypes().contains("User"));
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_DB_WEL_VIEWS_CHECK_LABEL");
        this.mViewsCheck = new JCheckBox(toggleButtonAction);
        this.mViewsCheck.setSelected(Selected.getSelected().getSelectedTableTypes().contains("View"));
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_DB_WEL_SYNONYMS_CHECK_LABEL");
        this.mSynonymsCheck = new JCheckBox(toggleButtonAction);
        this.mSynonymsCheck.setSelected(Selected.getSelected().getSelectedTableTypes().contains("Synonym"));
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_DB_WEL_SYSTEM_TABLES_CHECK_LABEL");
        this.mSystemTablesCheck = new JCheckBox(toggleButtonAction);
        this.mSystemTablesCheck.setSelected(Selected.getSelected().getSelectedTableTypes().contains("System"));
        this.mTablesCheck.addItemListener(this);
        this.mViewsCheck.addItemListener(this);
        this.mSynonymsCheck.addItemListener(this);
        this.mSystemTablesCheck.addItemListener(this);
    }

    protected void showOdbcAdminMessage() {
        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_DB_ODBC_ADMIN_LAUNCH"), this.mWizardDialog.getResString("IDS_DB_WEL_TITLE"));
    }

    @Override
    protected JPanel setupPageBody() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(5, n, 3, 0);
        int n2 = 23;
        this.mScrollPane = new JScrollPane(this.mList);
        this.mScrollPane.setMinimumSize(new Dimension(n * 2 + 7, n * 8 + 4));
        this.mScrollPane.setPreferredSize(new Dimension(n * 2 + 7, n * 8 + 4));
        this.mOlePane = new JScrollPane(this.mOleList);
        this.mOlePane.setMinimumSize(new Dimension(n * 2 + 7, n * 8 + 4));
        this.mOlePane.setPreferredSize(new Dimension(n * 2 + 7, n * 8 + 4));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_DB_WEL_WELCOME_DATA_SOURCE_LABEL");
        insets.left = n + 3;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 2, 2, 2, 1, n2, insets);
        jLabel.setLabelFor(this.mList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.left = n;
        DialogUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 2, 3, 2, 2, n2, insets);
        boolean bl = false;
        if (OSInfo.getOSType().equals((Object)OSInfo.OSType.WIN) || OSInfo.getOSType().equals((Object)OSInfo.OSType.MAC)) {
            if (!DataServerProxy.getDataProxy().isRemoteConnection()) {
                bl = true;
            }
        } else if (OSInfo.getOSType().equals((Object)OSInfo.OSType.LINUX)) {
            // empty if block
        }
        if (bl) {
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            n2 = 10;
            DialogUtil.addUsingGBL(jPanel, this.mDataSourceButton, gridBagConstraints, 2, 5, 1, 1, n2, insets);
        } else {
            this.mDataSourceButton.setEnabled(false);
            this.mDataSourceButton.setVisible(false);
        }
        ImageIcon imageIcon = new ImageIcon(this.mWizardDialog.getResImageURL("IDS_DB_WEL_WELCOME_IMG"));
        JLabel jLabel2 = new JLabel();
        jLabel2.setIcon(imageIcon);
        JLabel jLabel3 = DialogUtil.createLabel(this.mWizardDialog, "IDS_DB_WEL_WELCOME_OLE_DATA_SOURCE_LABEL");
        jLabel3.setLabelFor(this.mOleList);
        if (this.mOleDbInstalled && !DataServerProxy.getDataProxy().isRemoteConnection()) {
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            n2 = 23;
            insets.left = n + 3;
            DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 2, 2, 1, n2, insets);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            insets.left = n;
            DialogUtil.addUsingGBL(jPanel, this.mOlePane, gridBagConstraints, 0, 3, 2, 2, n2, insets);
            n2 = 10;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mOleDataSourceButton, gridBagConstraints, 0, 5, 1, 1, n2, insets);
        } else if (this.mOleDbInstalled && DataServerProxy.getDataProxy().isRemoteConnection()) {
            this.mOleDataSourceButton.setEnabled(false);
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            n2 = 23;
            insets.top = 5;
            insets.left = n + 3;
            DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 2, 2, 1, n2, insets);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            insets.left = n;
            DialogUtil.addUsingGBL(jPanel, this.mOlePane, gridBagConstraints, 0, 3, 1, 2, n2, insets);
        } else if (!this.mOleDbInstalled) {
            this.mOleDataSourceButton.setEnabled(false);
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            n2 = 23;
            insets.top = n;
            DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 3, 2, 1, n2, insets);
        }
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.mWizardDialog.getResString("IDS_DB_WEL_TABLE_TYPES_LABEL")));
        n2 = 23;
        insets.top = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mTablesCheck, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mViewsCheck, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mSynonymsCheck, gridBagConstraints, 2, 0, 1, 1, n2, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mSystemTablesCheck, gridBagConstraints, 3, 0, 1, 1, n2, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n2 = 23;
        insets.top = 20;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 6, 4, 1, n2, insets);
        return jPanel;
    }

    private void setUIData() {
        UIData uIData = UIData.getUIData();
        uIData.putObject("WP_IS_ODBC", this.mUseODBC);
        uIData.putObject("WP_DATABASE_NAME", DBData.getDBData().getDBName());
        uIData.putObject("WP_CONNECTION_STRING", DBData.getDBData().getConnectionString());
        uIData.putObject("WP_SELECTED_TABLE_TYPES", Selected.getSelected().getSelectedTableTypes());
    }

    private void readUIData() {
        UIData uIData = UIData.getUIData();
        uIData.getObject("WP_IS_ODBC");
    }

    private boolean isOledbEntryExist(String string) {
        return this.mOledbConnStr.keySet().contains(string);
    }

    private void updateConnStrForOledb(String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            if (!this.isOledbEntryExist(string)) {
                this.mOledbConnStr.put(string, string2);
            } else {
                this.mOledbConnStr.remove(string);
                this.mOledbConnStr.put(string, string2);
            }
        }
    }

    private void updateOledbDataSourceList() {
        this.mOleListModel.clear();
        int n = this.mOledbConnStr.keySet().size();
        DBListEntry[] dBListEntryArray = new DBListEntry[n];
        int n2 = 0;
        Set<String> set = this.mOledbConnStr.keySet();
        if (set.size() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>(set);
            Collections.sort(arrayList, new ListComparator());
            for (String string : arrayList) {
                dBListEntryArray[n2] = new DBListEntry(string, null, null, this.mWizardDialog.getResImageURL("IDS_DB_WEL_WELCOME_DB_IMG"));
                this.mOleListModel.addElement(dBListEntryArray[n2]);
                ++n2;
            }
        }
        this.mOleList.setModel(this.mOleListModel);
    }

    private boolean setTableData() {
        Object object;
        ODBC oDBC = ODBC.getODBC();
        DBData dBData = DBData.getDBData();
        dBData.clear();
        ODBCDacProxy oDBCDacProxy = ODBCDacProxy.getODBCDacProxy();
        String string = "";
        String string2 = "";
        if (this.mUseODBC) {
            string = ((DBListEntry)this.mList.getSelectedValue()).getText();
            object = ((DBListEntry)this.mList.getSelectedValue()).getTypeName();
            string2 = ((DBListEntry)this.mList.getSelectedValue()).getDesc();
            if (string2 != null && (string2.contains("Excel") || string2.contains("Access"))) {
                oDBCDacProxy.setConnectString("");
                dBData.setConnectionString("");
                dBData.saveDriverLoginInfo(string, "");
            }
        } else {
            string = ((DBListEntry)this.mOleList.getSelectedValue()).getText();
            object = oDBC.getOleDBDataSource(string);
            if (object != null) {
                String string3 = object.getConn();
                oDBC.setOleDBConnectString(string3);
            }
        }
        dBData.setDBName(string);
        boolean bl = true;
        if (this.mGroupAuthorizationModeActive) {
            // empty if block
        }
        if (bl) {
            this.mWizardDialog.setCursor(Cursor.getPredefinedCursor(3));
            bl = oDBC.connect(this.mUseODBC, false, string, string2);
            if (bl) {
                bl = oDBC.loadTables(this.mWizardDialog, Selected.getSelected().getSelectedTableTypes());
                SPSSUtil.clearSelected();
            }
            this.mWizardDialog.setCursor(Cursor.getDefaultCursor());
            if (!bl) {
                if (this.mUseODBC) {
                    this.mList.requestFocus();
                } else {
                    this.mOleList.requestFocus();
                }
            }
        }
        return bl;
    }

    private int getIndexToSelect(boolean bl) {
        String string;
        int n = 0;
        if (bl && (string = ODBC.getODBC().getLastDataSourceName()) != null && string.length() > 0) {
            for (int i = 0; i < this.mList.getModel().getSize(); ++i) {
                DBListEntry dBListEntry = (DBListEntry)this.mList.getModel().getElementAt(i);
                if (!dBListEntry.getText().equals(string)) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    private void doPopulateDSNList() {
        Vector vector = new Vector();
        ODBCDacProxy oDBCDacProxy = ODBCDacProxy.getODBCDacProxy();
        ODBCDacProxy.SqlReturnCode sqlReturnCode = new ODBCDacProxy.SqlReturnCode(oDBCDacProxy);
        ODBCDacProxy.getODBCDacProxy().getDataSources(vector, sqlReturnCode);
        int n = vector.size();
        ArrayList<DataSourceInfo> arrayList = new ArrayList<DataSourceInfo>();
        for (DataSourceInfo dataSourceInfo : vector) {
            arrayList.add(dataSourceInfo);
        }
        Collections.sort(arrayList, new ListComparator());
        DBListEntry[] dBListEntryArray = new DBListEntry[n];
        int n2 = 0;
        for (DataSourceInfo dataSourceInfo : arrayList) {
            dBListEntryArray[n2] = new DBListEntry(dataSourceInfo.getName(), dataSourceInfo.getDesc(), "", this.mWizardDialog.getResImageURL("IDS_DB_WEL_WELCOME_DB_IMG"));
            ((DefaultListModel)this.mList.getModel()).addElement(dBListEntryArray[n2]);
            ++n2;
        }
        this.mList.setCellRenderer(new DBListCellRenderer());
    }

    private void doPopulateOleDbList() {
        int n;
        Vector vector = new Vector();
        ODBCDacProxy oDBCDacProxy = ODBCDacProxy.getODBCDacProxy();
        ODBCDacProxy.SqlReturnCode sqlReturnCode = new ODBCDacProxy.SqlReturnCode(oDBCDacProxy);
        ODBCWizardCapabilities oDBCWizardCapabilities = new ODBCWizardCapabilities();
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        DialogCallbackImpl dialogCallbackImpl = new DialogCallbackImpl(spssFrame);
        ODBCDacProxy.getODBCDacProxy().setOleDbConnectionString(this.mOledbConnectionString, (IDialogCallback)dialogCallbackImpl, oDBCWizardCapabilities, sqlReturnCode);
        this.mOleListModel = new DefaultListModel();
        if (ODBCDacProxy.getODBCDacProxy().getOleDbDataSources(vector, sqlReturnCode) == ODBCDacProxy.ProxyReturnCode.PROXY_OK && (n = vector.size()) > 0) {
            DBListEntry[] dBListEntryArray = new DBListEntry[n];
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = 0;
            for (OleDbDataSourceInfo object : vector) {
                this.updateConnStrForOledb(object.getName(), object.getConn());
                arrayList.add(object.getName());
            }
            Collections.sort(arrayList, new ListComparator());
            for (String string : arrayList) {
                dBListEntryArray[n2] = new DBListEntry(string, null, null, this.mWizardDialog.getResImageURL("IDS_DB_WEL_WELCOME_DB_IMG"));
                this.mOleListModel.addElement(dBListEntryArray[n2]);
                ++n2;
            }
        }
        this.mOleList = new JList(this.mOleListModel);
        this.mOleList.setCellRenderer(new DBListCellRenderer());
    }

    private void setOleDbToNativeClass() {
        if (this.mOledbDialog == null) {
            this.mOledbDialog = new LaunchOLEDB();
        }
    }

    private boolean validateOleDbSourceName(String string) {
        if (this.isOledbEntryExist(string)) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), String.format(this.mWizardDialog.getResString("ERR_OLEDB_DUPLICATE"), string), this.mWizardDialog.getResString("IDS_DB_WEL_WELCOME_OLE_DATA_SOURCE_LABEL"));
            return false;
        }
        if (string.indexOf(92) > -1 || string.indexOf(47) > -1 || string.indexOf(58) > -1 || string.indexOf(42) > -1 || string.indexOf(63) > -1 || string.indexOf(34) > -1 || string.indexOf(60) > -1 || string.indexOf(62) > -1 || string.indexOf(124) > -1) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_OLEDB_INVALID_CHAR"), this.mWizardDialog.getResString("IDS_DB_WEL_WELCOME_OLE_DATA_SOURCE_LABEL"));
            return false;
        }
        return true;
    }

    private void oleDbConnectInitiated(String string) {
        try {
            this.mOledbConnectionString = string;
            this.mWizardDialog.setEnabled(true);
            this.mWizardDialog.setVisible(true);
            this.mWizardDialog.requestFocusInWindow();
            this.mWizardDialog.getOwner().toFront();
            if (this.mOledbConnectionString.length() > 0) {
                boolean bl;
                do {
                    OleDbConnectInfoDlg oleDbConnectInfoDlg = this.mWizardDialog.getParent() instanceof SpssFrame ? new OleDbConnectInfoDlg((SpssFrame)this.mWizardDialog.getParent()) : new OleDbConnectInfoDlg(SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame());
                    oleDbConnectInfoDlg.setVisible(true);
                    if (oleDbConnectInfoDlg.isOkSelected()) {
                        String string2 = oleDbConnectInfoDlg.getInfoName();
                        if (string2.length() > 0) {
                            if (this.validateOleDbSourceName(string2)) {
                                bl = false;
                                this.setOleDbToNativeClass();
                                if (!this.mOledbDialog.saveOleDbDataSource(string2, this.mOledbConnectionString)) continue;
                                this.updateConnStrForOledb(string2, this.mOledbConnectionString);
                                this.updateOledbDataSourceList();
                                continue;
                            }
                            bl = true;
                            continue;
                        }
                        bl = false;
                        continue;
                    }
                    bl = false;
                } while (bl);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void adminLaunchComplete(boolean bl) {
        if (!bl) {
            this.showOdbcAdminMessage();
        }
    }

    class ConnectionHandler
    extends Thread {
        private OleDbLaunchType mLaunchType;
        private String mOledbConnectString;

        ConnectionHandler(OleDbLaunchType oleDbLaunchType) {
            this.mLaunchType = oleDbLaunchType;
        }

        @Override
        public void run() {
            if (this.mLaunchType == OleDbLaunchType.load) {
                this.mOledbConnectString = WelcomePage.this.mOledbDialog.loadOLEDB();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WelcomePage.this.oleDbConnectInitiated(ConnectionHandler.this.mOledbConnectString);
                    }
                });
            } else if (this.mLaunchType == OleDbLaunchType.admin) {
                try {
                    final boolean bl = WelcomePage.this.mOledbDialog.launchOdbcAdministrator();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WelcomePage.this.adminLaunchComplete(bl);
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    static enum OleDbLaunchType {
        admin,
        load,
        save;

    }

    private class ListComparator
    implements Comparator<Object> {
        private ListComparator() {
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object instanceof String && object2 instanceof String) {
                String string = (String)object;
                String string2 = (String)object2;
                return string.compareToIgnoreCase(string2);
            }
            if (object instanceof DataSourceInfo && object2 instanceof DataSourceInfo) {
                String string = ((DataSourceInfo)object).getName();
                String string3 = ((DataSourceInfo)object2).getName();
                return string.compareToIgnoreCase(string3);
            }
            return -1;
        }
    }
}

