/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.AggregatePageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.ComputeNewFieldsPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.DefineVariablesPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.LimitPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.RelationshipPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.ResultsPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.Selected;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.SortCasesPageInfo;

public class SPSSUtil {
    public static final boolean MAGIC_SHOW_ALL_PANELS = false;

    public static String generateValidSpssName(String string) {
        String string2 = SPSSUtil.getValidName(string);
        if (!ComponentState.isUnicodeServer()) {
            char[] cArray = string2.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            for (char c : cArray) {
                char[] cArray2 = new char[]{c};
                if (VarNameValidator.validateAgainstCurCharSet((String)new String(cArray2))) {
                    stringBuffer.append("_");
                    bl = true;
                    continue;
                }
                stringBuffer.append(c);
            }
            if (bl) {
                string2 = stringBuffer.toString();
                string2 = SPSSUtil.generateValidSpssName(string2);
            }
        }
        return string2;
    }

    public static String getValidName(String string) {
        VarNameValidator.ValidNameCode validNameCode;
        boolean bl;
        int n = 1;
        String string2 = string;
        boolean bl2 = true;
        for (int i = 0; i < string2.length(); ++i) {
            if (!Character.isLetter(string2.charAt(i)) && Character.isLetterOrDigit(string2.charAt(i))) continue;
            bl2 = false;
            break;
        }
        if (bl2 || Character.isDigit(string2.charAt(0))) {
            string2 = "@" + string2;
        }
        string2 = string2.replaceAll(" ", "_");
        block10: do {
            validNameCode = VarNameValidator.validateSPSSName((String)string2, (boolean)true);
            bl = false;
            switch (validNameCode) {
                case SPSSNAME_STANDARD: {
                    break;
                }
                case SPSSNAME_SCRATCH: 
                case SPSSNAME_SYSTEM: 
                case SPSSNAME_RESERVED: {
                    string2 = "@" + string2;
                    bl = true;
                    break;
                }
                case SPSSNAME_BADFIRST: {
                    if (string2.charAt(0) == '\'' || string2.charAt(0) == '\"') {
                        string2 = string2.replaceAll("'", "");
                        if ((string2 = string2.replaceAll("\"", "")).length() == 0) break;
                        bl = true;
                        break;
                    }
                    char c = string2.charAt(0);
                    if ((string2 = c == '_' ? "@" + string2 : string2.replaceAll("\\" + c, "")).length() == 0) continue block10;
                    bl = true;
                    break;
                }
                case SPSSNAME_BADLAST: {
                    if (string2.length() <= 1) break;
                    string2 = string2.substring(0, string2.length() - 1);
                    bl = true;
                    break;
                }
                case SPSSNAME_WARN_UNDERSCORE: {
                    validNameCode = VarNameValidator.ValidNameCode.SPSSNAME_STANDARD;
                    break;
                }
                case SPSSNAME_BADLTH: {
                    string2 = string2.substring(0, 64);
                    bl = true;
                }
                case SPSSNAME_BADCHAR: {
                    if (string2.length() == 0) break;
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < string2.length(); ++i) {
                        char c = string2.charAt(i);
                        if (Character.isLowerCase(c)) {
                            stringBuffer.append(c);
                            continue;
                        }
                        if (Character.isLetter(c)) {
                            stringBuffer.append(c);
                            continue;
                        }
                        if (Character.isDigit(c)) {
                            stringBuffer.append(c);
                            continue;
                        }
                        if (c == '@') {
                            stringBuffer.append(c);
                            continue;
                        }
                        if (c == '#') {
                            stringBuffer.append(c);
                            continue;
                        }
                        if (c == '$') {
                            stringBuffer.append(c);
                            continue;
                        }
                        if (c == '_') {
                            stringBuffer.append(c);
                            continue;
                        }
                        if (c != '.') continue;
                        stringBuffer.append(c);
                    }
                    string2 = stringBuffer.toString();
                    bl = true;
                }
            }
        } while (bl);
        if (validNameCode != VarNameValidator.ValidNameCode.SPSSNAME_STANDARD) {
            string2 = "V" + n;
        }
        return string2;
    }

    public static void clearSelected() {
        Selected selected = Selected.getSelected();
        selected.clear();
        SPSSUtil.clearRelationShipPage();
    }

    public static void clearRelationShipPage() {
        RelationshipPageInfo relationshipPageInfo = RelationshipPageInfo.getRelationshipPageInfo();
        relationshipPageInfo.clear();
        SPSSUtil.clearComputeNewFieldPage();
    }

    public static void clearComputeNewFieldPage() {
        ComputeNewFieldsPageInfo computeNewFieldsPageInfo = ComputeNewFieldsPageInfo.getNewFieldsInfo();
        computeNewFieldsPageInfo.clear();
        SPSSUtil.clearLimitPage();
    }

    public static void clearLimitPage() {
        LimitPageInfo limitPageInfo = LimitPageInfo.getLimitPageInfo();
        limitPageInfo.clear();
        SPSSUtil.clearAggregatePage();
    }

    public static void clearAggregatePage() {
        AggregatePageInfo aggregatePageInfo = AggregatePageInfo.getAggregatePageInfo();
        aggregatePageInfo.clear();
        SPSSUtil.clearDefineVariablesPage();
    }

    public static void clearDefineVariablesPage() {
        DefineVariablesPageInfo defineVariablesPageInfo = DefineVariablesPageInfo.getDefineVariablesPageInfo();
        defineVariablesPageInfo.clear();
        SPSSUtil.clearSortPage();
    }

    public static void clearSortPage() {
        SortCasesPageInfo sortCasesPageInfo = SortCasesPageInfo.getSortCasesPageInfo();
        sortCasesPageInfo.clear();
        SPSSUtil.clearResultsPage();
    }

    public static void clearResultsPage() {
        ResultsPageInfo resultsPageInfo = ResultsPageInfo.getResultsPageInfo();
        resultsPageInfo.clear();
    }
}

