/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss;

import com.spss.java_client.core.comp_util.PassEncrypt;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.dialogs.base.file.openquery.limit_retrieved_cases.PromptValuesData;
import com.spss.java_client.ui.dialogs.base.file.openquery.results.SetPromptValueDialog;
import com.spss.java_client.ui.dialogs.base.file.openquery.sort_cases.SortDataClass;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.JoinType;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBC;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCTable;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.AggregateColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.AggregatePageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.ComputeNewFieldsPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.ComputedColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.DefineVariablesPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.LimitPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.RelationshipPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.ResultsPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.SPSSColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.SampleCases;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.Selected;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.SortCasesPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.TableJoin;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.WhereLimitEntry;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.util.CharacterUtil;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GenerateSyntax {
    private static String[] sValidODBCDateFormats = new String[]{"yyyy-mm-dd hh:mm:ss", "yyyy-mm-dd", "hh:mm:ss"};
    private static final String[] SUPPORTED_COMPARISON_OPERATORS = new String[]{">=", "<=", "<>", "!=", ">", "<", "="};
    private List<ODBCColumn> allColumns = null;
    private static GenerateSyntax instance = null;
    private Map<String, String> tableAlias = null;

    private GenerateSyntax() {
        this.clear();
    }

    public static GenerateSyntax getGenerateSyntax() {
        if (instance == null) {
            instance = new GenerateSyntax();
        }
        return instance;
    }

    public void clear() {
        this.tableAlias = null;
    }

    public String generateSPSSSyntax() {
        Object object;
        ODBC oDBC = ODBC.getODBC();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GET DATA");
        stringBuffer.append("\n  /TYPE=");
        if (oDBC.isUseODBC()) {
            stringBuffer.append("ODBC");
        } else {
            stringBuffer.append("OLEDB");
        }
        PassEncrypt passEncrypt = new PassEncrypt();
        String string = oDBC.getLastConnectString();
        String string2 = passEncrypt.odbcEncryptPassword(string, true, oDBC.isUseODBC());
        string2 = "\n  /CONNECT=" + CharacterUtil.smartQuote((String)string2, (boolean)true);
        stringBuffer.append(string2);
        stringBuffer.append("\n  /SQL=");
        ResultsPageInfo resultsPageInfo = ResultsPageInfo.getResultsPageInfo();
        String string3 = resultsPageInfo.getSql();
        if (string3.length() > 0) {
            stringBuffer.append(CharacterUtil.smartQuote((String)string3, (boolean)true));
        } else {
            stringBuffer.append(CharacterUtil.smartQuote((String)this.generateSQL(), (boolean)true));
        }
        DefineVariablesPageInfo defineVariablesPageInfo = DefineVariablesPageInfo.getDefineVariablesPageInfo();
        stringBuffer.append("\n  /ASSUMEDSTRWIDTH=");
        stringBuffer.append(defineVariablesPageInfo.getAssumedStringWidth());
        stringBuffer.append('.');
        LimitPageInfo limitPageInfo = LimitPageInfo.getLimitPageInfo();
        if (limitPageInfo.isUseSampling() && ((SampleCases)(object = limitPageInfo.getSampleCases())).getSampleMethod() == 0) {
            if (((SampleCases)object).getSampleSizeMethod() == 0) {
                DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(ResUtil.getLocale());
                decimalFormat.applyPattern("0.00");
                stringBuffer.append("\nSAMPLE " + decimalFormat.format((float)((SampleCases)object).getPercentageOfCases() / 100.0f));
            } else {
                stringBuffer.append("\nSAMPLE ");
                stringBuffer.append(((SampleCases)object).getNumberOfCases());
                stringBuffer.append(" FROM ");
                stringBuffer.append(((SampleCases)object).getFromFirstCases());
            }
            stringBuffer.append(".");
        }
        stringBuffer.append("\n");
        stringBuffer.append(this.getLabelNamePhrase());
        stringBuffer.append("\nCACHE.");
        stringBuffer.append("\nEXECUTE.");
        if (defineVariablesPageInfo.isMinimizeStrings()) {
            stringBuffer.append("\nALTER TYPE ALL(A=AMIN).");
        }
        stringBuffer.append(this.getAutoRecodeSyntax());
        object = SpssMgr.getSpssMgr().getNextFreeDatasetName();
        stringBuffer.append("\nDATASET NAME ");
        stringBuffer.append((String)object);
        stringBuffer.append(" WINDOW=FRONT.");
        return stringBuffer.toString();
    }

    private String getAutoRecodeSyntax() {
        DefineVariablesPageInfo defineVariablesPageInfo = DefineVariablesPageInfo.getDefineVariablesPageInfo();
        List<SPSSColumn> list = defineVariablesPageInfo.getRecodeColumns();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        int n = 1;
        if (list.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (SPSSColumn sPSSColumn : list) {
                arrayList.add(sPSSColumn.getUserName());
                arrayList2.add("tm" + n);
                ++n;
            }
            stringBuffer.append("\nAUTORECODE ");
            stringBuffer.append(this.makeSeparatedList(arrayList, " "));
            stringBuffer.append("\n /INTO ");
            stringBuffer.append(this.makeSeparatedList(arrayList2, " "));
            stringBuffer.append('.');
            stringBuffer.append("\nDELETE VARIABLES ");
            stringBuffer.append(this.makeSeparatedList(arrayList, " "));
            stringBuffer.append('.');
            stringBuffer.append("\nRENAME VARIABLES (");
            for (int i = 0; i < arrayList.size(); ++i) {
                arrayList3.add((String)arrayList2.get(i) + "=" + (String)arrayList.get(i));
            }
            stringBuffer.append(this.makeSeparatedList(arrayList3, ")("));
            stringBuffer.append(").");
            return stringBuffer.toString();
        }
        return "";
    }

    public String generateSQL() {
        this.setupTableAliases();
        this.getColumnsInSelectedTables();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getSelectPhrase());
        stringBuffer.append(this.getFromPhrase());
        stringBuffer.append(this.getWherePhrase());
        stringBuffer.append(this.getGroupByPhrase());
        stringBuffer.append(this.getSamplePhrase());
        stringBuffer.append(this.getOrderByPhrase());
        return stringBuffer.toString();
    }

    private String getSelectPhrase() {
        Selected selected = Selected.getSelected();
        AggregatePageInfo aggregatePageInfo = AggregatePageInfo.getAggregatePageInfo();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (aggregatePageInfo.getBreakColumns().size() == 0) {
            Comparable<StringBuffer> comparable;
            List<SPSSColumn> list = selected.getSelectedColumns();
            for (SPSSColumn object2 : list) {
                comparable = new StringBuffer();
                ((StringBuffer)comparable).append(this.getNormalizedColumnName(object2));
                if (object2.isAliased() && ODBC.getODBC().isUseODBC()) {
                    ((StringBuffer)comparable).append(" AS ");
                    ((StringBuffer)comparable).append(object2.getQuotedUserName());
                }
                arrayList.add(((StringBuffer)comparable).toString());
            }
            List<ComputedColumn> list2 = ComputeNewFieldsPageInfo.getNewFieldsInfo().getNewColumns();
            Iterator object3 = list2.iterator();
            while (object3.hasNext()) {
                comparable = (ComputedColumn)object3.next();
                StringBuffer stringBuffer = new StringBuffer();
                String string = this.translateComputeExpression(((ComputedColumn)comparable).getExpression());
                stringBuffer.append(this.fixQualifiedColumnNames(string));
                stringBuffer.append(" AS ");
                stringBuffer.append(((SPSSColumn)comparable).getQuotedUserName());
                arrayList.add(stringBuffer.toString());
            }
        } else {
            String string;
            Comparable<ODBCColumn> comparable;
            Comparable<StringBuffer> comparable2;
            List<SPSSColumn> list = aggregatePageInfo.getBreakColumns();
            for (SPSSColumn sPSSColumn : list) {
                comparable2 = new StringBuffer();
                if (sPSSColumn instanceof ComputedColumn) {
                    comparable = (ComputedColumn)sPSSColumn;
                    string = this.replaceComputedColumnNameWithExpr(((ODBCColumn)comparable).getColumnName());
                    ((StringBuffer)comparable2).append(this.fixQualifiedColumnNames(string));
                } else {
                    ((StringBuffer)comparable2).append(this.getNormalizedColumnName(sPSSColumn));
                }
                if (sPSSColumn.isAliased()) {
                    ((StringBuffer)comparable2).append(" AS ");
                    ((StringBuffer)comparable2).append(sPSSColumn.getQuotedUserName());
                }
                arrayList.add(((StringBuffer)comparable2).toString());
            }
            List<AggregateColumn> list3 = aggregatePageInfo.getAggregateColumns();
            Iterator iterator = list3.iterator();
            while (iterator.hasNext()) {
                comparable2 = (AggregateColumn)iterator.next();
                comparable = new StringBuffer();
                if (((AggregateColumn)comparable2).isComputedColumn()) {
                    string = this.getNormalizedColumnName((SPSSColumn)comparable2);
                    string = this.replaceComputedColumnNameWithExpr(string);
                    ((StringBuffer)comparable).append(this.fixQualifiedColumnNames(string));
                } else {
                    ((StringBuffer)comparable).append(this.getNormalizedColumnName((SPSSColumn)comparable2));
                }
                if (((SPSSColumn)comparable2).isAliased()) {
                    ((StringBuffer)comparable).append(" AS ");
                    ((StringBuffer)comparable).append(((SPSSColumn)comparable2).getQuotedUserName());
                }
                arrayList.add(((StringBuffer)comparable).toString());
            }
            if (aggregatePageInfo.isIncludeNumberOfCases()) {
                arrayList.add("count(*) AS N_BREAK");
            }
        }
        return "SELECT " + this.makeSeparatedList(arrayList, ", ");
    }

    private String getNormalizedColumnName(SPSSColumn sPSSColumn) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        AggregateColumn aggregateColumn = null;
        if (sPSSColumn instanceof AggregateColumn) {
            bl = true;
            aggregateColumn = (AggregateColumn)sPSSColumn;
        }
        if (bl) {
            stringBuffer.append(aggregateColumn.getFunction());
            stringBuffer.append('(');
        }
        if (bl && aggregateColumn.isComputedColumn() || sPSSColumn instanceof ComputedColumn) {
            stringBuffer.append(sPSSColumn.getColumnName());
        } else {
            if (this.tableAlias.size() > 1) {
                stringBuffer.append(this.tableAlias.get(sPSSColumn.getTable().getQualifiedName(false)));
                stringBuffer.append('.');
            }
            stringBuffer.append(sPSSColumn.getQuotedColumnName());
        }
        if (bl) {
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    private String getFromPhrase() {
        Selected selected = Selected.getSelected();
        if (this.tableAlias.size() == 1) {
            String string = ODBC.getODBC().getCapabilities().getStrDBMSName();
            if (string.toUpperCase().contains("INFORMIX")) {
                return " FROM " + selected.getSelectedTables().get(0).getOwner() + "." + selected.getSelectedTables().get(0).getName();
            }
            if (string.toUpperCase().contains("POSTGRESQL")) {
                if (selected.getSelectedTables().get(0).getQualifier().length() == 0) {
                    return " FROM " + selected.getSelectedTables().get(0).getOwner() + "." + selected.getSelectedTables().get(0).getQuotedName();
                }
                return " FROM " + selected.getSelectedTables().get(0).getQualifier() + "." + selected.getSelectedTables().get(0).getOwner() + "." + selected.getSelectedTables().get(0).getQuotedName();
            }
            return " FROM " + selected.getSelectedTables().get(0).getQualifiedName(true);
        }
        List<ODBCTable> list = selected.getSelectedTables();
        ArrayList<String> arrayList = new ArrayList<String>();
        RelationshipPageInfo relationshipPageInfo = RelationshipPageInfo.getRelationshipPageInfo();
        TableJoin tableJoin = relationshipPageInfo.getOuterJoin();
        if (tableJoin == null) {
            for (ODBCTable oDBCTable : list) {
                String string = oDBCTable.getQualifiedName(true) + " " + this.tableAlias.get(oDBCTable.getQualifiedName());
                arrayList.add(string);
            }
            return " FROM " + this.makeSeparatedList(arrayList, ", ");
        }
        ODBCColumn oDBCColumn = tableJoin.getLeft();
        ODBCColumn oDBCColumn2 = tableJoin.getRight();
        String string = oDBCColumn.getTable().getQualifiedName(true);
        String string2 = oDBCColumn2.getTable().getQualifiedName(true);
        String string3 = this.tableAlias.get(oDBCColumn.getTable().getQualifiedName());
        String string4 = this.tableAlias.get(oDBCColumn2.getTable().getQualifiedName());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ oj ");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(string3);
        if (tableJoin.getJoinType() == JoinType.LEFT_JOIN) {
            stringBuffer.append(" LEFT OUTER JOIN ");
        } else {
            stringBuffer.append(" RIGHT OUTER JOIN ");
        }
        stringBuffer.append(string2);
        stringBuffer.append(" ");
        stringBuffer.append(string4);
        stringBuffer.append(" ON ");
        stringBuffer.append(string3);
        stringBuffer.append('.');
        stringBuffer.append(oDBCColumn.getQuotedColumnName());
        stringBuffer.append(" = ");
        stringBuffer.append(string4);
        stringBuffer.append('.');
        stringBuffer.append(oDBCColumn2.getQuotedColumnName());
        stringBuffer.append(" }");
        return " FROM " + stringBuffer.toString();
    }

    private String getWherePhrase() {
        String string;
        Object object;
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = new StringBuffer();
        RelationshipPageInfo relationshipPageInfo = RelationshipPageInfo.getRelationshipPageInfo();
        List<TableJoin> list = relationshipPageInfo.getTableJoins();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TableJoin object42 : list) {
            if (object42.getJoinType() != JoinType.INNER_JOIN) continue;
            stringBuffer = new StringBuffer();
            object = object42.getLeft();
            ODBCColumn oDBCColumn = object42.getRight();
            Object object2 = this.tableAlias.get(((ODBCColumn)object).getTable().getQualifiedName());
            string = this.tableAlias.get(oDBCColumn.getTable().getQualifiedName());
            stringBuffer.append((String)object2);
            stringBuffer.append('.');
            stringBuffer.append(((ODBCColumn)object).getQuotedColumnName());
            stringBuffer.append(" = ");
            stringBuffer.append(string);
            stringBuffer.append('.');
            stringBuffer.append(oDBCColumn.getQuotedColumnName());
            arrayList.add(stringBuffer.toString());
        }
        stringBuffer2.append(this.makeSeparatedList(arrayList, " AND "));
        LimitPageInfo limitPageInfo = LimitPageInfo.getLimitPageInfo();
        List<WhereLimitEntry> list2 = limitPageInfo.getWhereLimitList();
        if (list2.size() > 0) {
            stringBuffer = new StringBuffer();
            if (stringBuffer2.length() > 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append("(");
            object = ComputeNewFieldsPageInfo.getNewFieldsInfo().getNewColumns();
            Collections.sort(object, new ComputedColumn.ComputedColumnComparator());
            for (Object object2 : list2) {
                Object object3;
                Object object4;
                Object object5;
                string = ((WhereLimitEntry)object2).getConnector();
                if (string.length() > 0) {
                    stringBuffer.append(' ');
                    stringBuffer.append(string);
                    stringBuffer.append(' ');
                }
                String string2 = ((WhereLimitEntry)object2).getLeftSide();
                if (object.size() > 0) {
                    object5 = object.iterator();
                    while (object5.hasNext()) {
                        object4 = (ComputedColumn)object5.next();
                        object3 = this.translateComputeExpression(((ComputedColumn)object4).getExpression());
                        string2 = string2.replace(((ODBCColumn)object4).getColumnName(), (CharSequence)object3);
                    }
                }
                string2 = this.fixQualifiedColumnNames(string2);
                stringBuffer.append(string2);
                stringBuffer.append(' ');
                stringBuffer.append(((WhereLimitEntry)object2).getRelation());
                stringBuffer.append(' ');
                object5 = ((WhereLimitEntry)object2).getRightSide();
                if (object.size() > 0) {
                    object4 = object.iterator();
                    while (object4.hasNext()) {
                        object3 = (ComputedColumn)object4.next();
                        String string3 = this.translateComputeExpression(((ComputedColumn)object3).getExpression());
                        object5 = ((String)object5).replace(((ODBCColumn)object3).getColumnName(), string3);
                    }
                }
                object5 = this.fixQualifiedColumnNames((String)object5);
                stringBuffer.append((String)object5);
            }
            stringBuffer.append(")");
            stringBuffer2.append(stringBuffer);
        }
        if (stringBuffer2.length() > 0) {
            return " WHERE " + stringBuffer2.toString();
        }
        return "";
    }

    private String getGroupByPhrase() {
        AggregatePageInfo aggregatePageInfo = AggregatePageInfo.getAggregatePageInfo();
        List<SPSSColumn> list = aggregatePageInfo.getBreakColumns();
        if (list.size() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (SPSSColumn sPSSColumn : list) {
                if (sPSSColumn instanceof ComputedColumn) {
                    ComputedColumn computedColumn = (ComputedColumn)sPSSColumn;
                    String string = this.translateComputeExpression(computedColumn.getExpression());
                    arrayList.add(this.fixQualifiedColumnNames(string));
                    continue;
                }
                arrayList.add(this.getNormalizedColumnName(sPSSColumn));
            }
            return " GROUP BY " + this.makeSeparatedList(arrayList, ", ");
        }
        return "";
    }

    private String getOrderByPhrase() {
        SortCasesPageInfo sortCasesPageInfo = SortCasesPageInfo.getSortCasesPageInfo();
        List<SortDataClass> list = sortCasesPageInfo.getSortData();
        if (list.size() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (SortDataClass sortDataClass : list) {
                String string = null;
                SPSSColumn sPSSColumn = sortDataClass.getColumn();
                if (sPSSColumn instanceof AggregateColumn && ((AggregateColumn)sPSSColumn).isComputedColumn() || sPSSColumn instanceof ComputedColumn) {
                    String string2 = this.getNormalizedColumnName(sPSSColumn);
                    string2 = this.replaceComputedColumnNameWithExpr(string2);
                    string = this.fixQualifiedColumnNames(string2);
                } else {
                    string = this.getNormalizedColumnName(sortDataClass.getColumn());
                }
                string = sortDataClass.getSortType() == 1 ? string + " ASC" : string + " DESC";
                arrayList.add(string);
            }
            return " ORDER BY " + this.makeSeparatedList(arrayList, ", ");
        }
        return "";
    }

    private String getSamplePhrase() {
        LimitPageInfo limitPageInfo = LimitPageInfo.getLimitPageInfo();
        if (!limitPageInfo.isUseSampling()) {
            return "";
        }
        SampleCases sampleCases = limitPageInfo.getSampleCases();
        if (sampleCases.getSampleMethod() == 1) {
            String string = ODBC.getODBC().getCapabilities().getStrDBMSName();
            if (string.toUpperCase().contains("ORACLE")) {
                return " SAMPLE(" + sampleCases.getPercentageOfCases() + ")";
            }
            return " SAMPLE " + sampleCases.getPercentageOfCases();
        }
        return "";
    }

    private String getLabelNamePhrase() {
        Selected selected = Selected.getSelected();
        AggregatePageInfo aggregatePageInfo = AggregatePageInfo.getAggregatePageInfo();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (aggregatePageInfo.getBreakColumns().size() == 0) {
            List<SPSSColumn> list = selected.getSelectedColumns();
            for (SPSSColumn sPSSColumn : list) {
                StringBuffer stringBuffer = new StringBuffer();
                if (!sPSSColumn.isAliased()) continue;
                stringBuffer.append("VARIABLE LABELS ");
                stringBuffer.append(sPSSColumn.getUserName());
                stringBuffer.append(" '");
                stringBuffer.append(sPSSColumn.getColumnName());
                stringBuffer.append("'.");
                arrayList.add(stringBuffer.toString());
            }
        } else {
            List<AggregateColumn> list = aggregatePageInfo.getAggregateColumns();
            for (AggregateColumn aggregateColumn : list) {
                StringBuffer stringBuffer = new StringBuffer();
                if (!aggregateColumn.isAliased()) continue;
                stringBuffer.append("VARIABLE LABELS ");
                stringBuffer.append(aggregateColumn.getUserName());
                stringBuffer.append(" '");
                stringBuffer.append(aggregateColumn.getColumnName());
                stringBuffer.append("'.");
                arrayList.add(stringBuffer.toString());
            }
        }
        return this.makeSeparatedList(arrayList, "\n");
    }

    private String makeSeparatedList(List<String> list, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl = false;
        for (String string2 : list) {
            if (bl) {
                stringBuffer.append(string);
            }
            stringBuffer.append(string2);
            bl = true;
        }
        return stringBuffer.toString();
    }

    private String translateComputeExpression(String string) {
        String string2 = ODBC.getODBC().getCapabilities().getStrDBMSName();
        for (int i = 0; i < SUPPORTED_COMPARISON_OPERATORS.length; ++i) {
            if (!string.contains(SUPPORTED_COMPARISON_OPERATORS[i]) || string2.toUpperCase().contains("ACCESS") || string2.toUpperCase().contains("EXCEL") || string2.toUpperCase().contains("MYSQL") || string2.toUpperCase().contains("GREENPLUM") || string2.toUpperCase().contains("INFORMIX") || string2.toUpperCase().contains("NETEZZA")) continue;
            return "(CASE WHEN (" + string + ") THEN 1 ELSE 0 END)";
        }
        return "(" + string + ")";
    }

    private String replaceComputedColumnNameWithExpr(String string) {
        List<ComputedColumn> list = ComputeNewFieldsPageInfo.getNewFieldsInfo().getNewColumns();
        String string2 = string;
        if (list != null && list.size() > 0) {
            Collections.sort(list, new ComputedColumn.ComputedColumnComparator());
            for (ComputedColumn computedColumn : list) {
                String string3 = this.translateComputeExpression(computedColumn.getExpression());
                string2 = string2.replace(computedColumn.getColumnName(), string3);
            }
        }
        return string2;
    }

    private String fixQualifiedColumnNames(String string) {
        String string2 = ODBC.getODBC().getCapabilities().getStrDBMSName();
        if (this.tableAlias.size() <= 1) {
            for (ODBCColumn oDBCColumn : this.allColumns) {
                if (!string.contains(oDBCColumn.getQuotedQualifiedColumnName())) continue;
                string = string.replace(oDBCColumn.getQuotedQualifiedColumnName(), oDBCColumn.getQuotedColumnName());
            }
            return string;
        }
        Selected selected = Selected.getSelected();
        List<ODBCTable> list = selected.getSelectedTables();
        String string3 = string;
        for (ODBCTable oDBCTable : list) {
            String string4 = oDBCTable.getQualifiedName();
            String string5 = this.tableAlias.get(string4);
            if (string2.toUpperCase().contains("GREENPLUM") || string2.toUpperCase().contains("NETEZZASQL")) {
                string5 = "\"" + string5 + "\"";
            }
            string3 = string3.replace(string4, string5);
        }
        return string3;
    }

    private void setupTableAliases() {
        this.tableAlias = new HashMap<String, String>();
        Selected selected = Selected.getSelected();
        List<ODBCTable> list = selected.getSelectedTables();
        if (list.size() == 1) {
            ODBCTable oDBCTable = list.get(0);
            this.tableAlias.put(oDBCTable.getQualifiedName(), oDBCTable.getName());
        } else {
            int n = 0;
            for (ODBCTable oDBCTable : list) {
                this.tableAlias.put(oDBCTable.getQualifiedName(), "T" + n);
                ++n;
            }
        }
    }

    private void getColumnsInSelectedTables() {
        this.allColumns = new ArrayList<ODBCColumn>();
        Selected selected = Selected.getSelected();
        List<ODBCTable> list = selected.getSelectedTables();
        for (ODBCTable oDBCTable : list) {
            List<ODBCColumn> list2 = ODBC.getODBC().getColumns(oDBCTable.getQualifiedName());
            this.allColumns.addAll(list2);
        }
        Collections.sort(this.allColumns, new Comparator<ODBCColumn>(){

            @Override
            public int compare(ODBCColumn oDBCColumn, ODBCColumn oDBCColumn2) {
                return oDBCColumn2.getQuotedQualifiedColumnName().length() - oDBCColumn.getQuotedQualifiedColumnName().length();
            }
        });
    }

    public String handlePrompts(String string) {
        Object object;
        String string2 = string;
        string2 = string2.replaceAll("''", "'");
        String string3 = ResultsPageInfo.getResultsPageInfo().getSql();
        if (string3.length() == 0) {
            string3 = this.generateSQL();
        }
        LimitPageInfo limitPageInfo = LimitPageInfo.getLimitPageInfo();
        List<WhereLimitEntry> list = limitPageInfo.getWhereLimitList();
        for (WhereLimitEntry object22 : list) {
            String string4;
            object = object22.getLeftSidePrompt();
            if (object != null && (string4 = this.getPromptValue((PromptValuesData)object)) != null) {
                string2 = string2.replace(object22.getLeftSide(), string4);
                string3 = string3.replace(object22.getLeftSide(), string4);
            }
            if ((object = object22.getRightSidePrompt()) == null || (string4 = this.getPromptValue((PromptValuesData)object)) == null) continue;
            string2 = string2.replace(object22.getRightSide(), string4);
            string3 = string3.replace(object22.getRightSide(), string4);
        }
        int n = string2.indexOf(string3);
        String string5 = string2.substring(0, n - 1);
        object = string2.substring(n + string3.length() + 1);
        string2 = string5 + CharacterUtil.smartQuote((String)string3, (boolean)true) + (String)object;
        return string2;
    }

    private String getPromptValue(PromptValuesData promptValuesData) {
        SetPromptValueDialog.setPromptValuesData(promptValuesData);
        SetPromptValueDialog setPromptValueDialog = new SetPromptValueDialog(SpssFrameMgr.getSpssFrameMgr().getLastActiveFrame());
        if (setPromptValueDialog.getSelectedValue() != null) {
            if (promptValuesData.getDataType().equals((Object)PromptValuesData.PromptValuesDataType.eString)) {
                return "'" + setPromptValueDialog.getSelectedValue() + "'";
            }
            if (promptValuesData.getDataType().equals((Object)PromptValuesData.PromptValuesDataType.eNumber)) {
                return setPromptValueDialog.getSelectedValue();
            }
            if (promptValuesData.getDataType().equals((Object)PromptValuesData.PromptValuesDataType.eDate) && this.isValidDateString(setPromptValueDialog.getSelectedValue())) {
                String string = setPromptValueDialog.getSelectedValue();
                if ((string.startsWith("{d '") || string.startsWith("{t '") || string.startsWith("{ts '")) && string.endsWith("'}")) {
                    return setPromptValueDialog.getSelectedValue();
                }
                for (int i = 0; i < sValidODBCDateFormats.length; ++i) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sValidODBCDateFormats[i]);
                    try {
                        simpleDateFormat.parse(string);
                        switch (i) {
                            case 0: {
                                return "{ts '" + setPromptValueDialog.getSelectedValue() + "'}";
                            }
                            case 1: {
                                return "{d '" + setPromptValueDialog.getSelectedValue() + "'}";
                            }
                            case 2: {
                                return "{t '" + setPromptValueDialog.getSelectedValue() + "'}";
                            }
                        }
                        return "{d '" + setPromptValueDialog.getSelectedValue() + "'}";
                    }
                    catch (ParseException parseException) {
                        continue;
                    }
                }
            }
        }
        return null;
    }

    private boolean isValidDateString(String string) {
        boolean bl = false;
        String string2 = string;
        if ((string.startsWith("{d '") || string.startsWith("{t '") || string.startsWith("{ts '")) && string.endsWith("'}")) {
            string2 = string.substring(string.indexOf("'") + 1, string.lastIndexOf("'"));
        }
        for (int i = 0; i < sValidODBCDateFormats.length; ++i) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sValidODBCDateFormats[i]);
            bl = false;
            try {
                simpleDateFormat.parse(string2);
                bl = true;
                break;
            }
            catch (ParseException parseException) {
                bl = false;
                continue;
            }
        }
        return bl;
    }
}

