/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.ODBCWizardCapabilities;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBC;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ODBCUtil {
    private static ODBCUtil instance = null;
    private Set<String> keywords = new HashSet<String>();
    private Set<String> stringentDBMS = null;
    private static String[] odbcKeywords = new String[]{"ABSOLUTE", "ACTION", "ADA", "ADD", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIT", "BIT_LENGTH", "BOTH", "BY", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR", "CHAR_LENGTH", "CHARACTER", "CHARACTER_LENGTH", "CHECK", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CONVERT", "CORRESPONDING", "COUNT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DESCRIPTOR", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOMAIN", "DOUBLE", "DROP", "ELSE", "END", "ENDEXEC", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FORTRAN", "FOUND", "FROM", "FULL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HAVING", "HOUR", "IDENTITY", "IMMEDIATE", "IN", "INCLUDE", "INDEX", "INDICATOR", "INITIALLY", "INNER", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LANGUAGE", "LAST", "LEADING", "LEFT", "LEVEL", "LIKE", "LOCAL", "LOWER", "MATCH", "MAX", "MIN", "MINUTE", "MODULE", "MONTH", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NONE", "NOT", "NULL", "NULLIF", "NUMERIC", "OCTET_LENGTH", "OF", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUTER", "OUTPUT", "OVERLAPS", "PAD", "PARTIAL", "PASCAL", "PLAN", "PLI", "POSITION", "PRECISION", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RESTRICT", "REVOKE", "RIGHT", "ROLLBACK", "ROWSSCHEMA", "SCROLL", "SECOND", "SECTION", "SELECT", "SESSION", "SESSION_USER", "SET", "SIZE", "SMALLINT", "SOME", "SPACE", "SQL", "SQLCA", "SQLCODE", "SQLERROR", "SQLSTATE", "SQLWARNING", "SUBSTRING", "SUM", "SYSTEM_USER", "TABLE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRIM", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "UPPER", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WITH", "WORK", "WRITE", "YEAR", "ZONE"};
    private static String[] sqlKeywords = new String[]{"ALPHANUMERIC", "AUTOINCREMENT", "BINARY", "BYTE", "COUNTER", "CURRENCY", "DATABASE", "DATABASENAME", "DATETIME", "DISALLOW", "DISTINCTROW", "DOUBLEFLOAT", "FLOAT4", "FLOAT8", "GENERAL", "IEEEDOUBLE", "IEEESINGLE", "IGNORE", "INT", "INTEGER1", "INTEGER2", "INTEGER4", "LEVEL", "LOGICAL", "LOGICAL1", "LONG", "LONGBINARY", "LONGCHAR", "LONGTEXT", "MEMO", "MOD", "MONEY", "NOTE", "NUMBER", "OLEOBJECT", "OPTION", "OWNERACCESS", "PARAMETERS", "PERCENT", "PIVOT", "SHORT", "SINGLE", "SINGLEFLOAT", "SMALLINT", "STDEV", "STDEVP", "STRING", "TABLEID", "TEXT", "TOP", "TRANSFORM", "UNSIGNEDBYTE", "VALUES", "VAR", "VARBINARY", "VARP", "YESNO"};
    private static String[] stringentDBMSInit = new String[]{"ORACLE", "DB2", "OPENACCESS", "AS", "NETEZZA", "XML"};
    public static String[][] sStringFunctions = new String[][]{{"ASCII(strexpr)", "{fn ASCII(?)}"}, {"CHAR(asciicode)", "{fn CHAR(?)}"}, {"CONCAT(strexpr,strexpr)", "{fn CONCAT(?,?)}"}, {"DIFFERENCE(strexpr, strexpr)", "{fn DIFFERENCE(?, ?)}"}, {"INSERT(strexpr,pos,len,new)", "{fn INSERT(?,?,?,?)}"}, {"LCASE(strexpr)", "{fn LCASE(?)}"}, {"LEFT(strexpr,count)", "{fn LEFT(?,?)}"}, {"LENGTH(strexpr)", "{fn LENGTH(?)}"}, {"LOCATE(haystack,needle)", "{fn LOCATE(?,?)}"}, {"LOCATE(haystack,needle, pos)", "{fn LOCATE(?,?,?)}"}, {"LTRIM(strexpr)", "{fn LTRIM(?)}"}, {"REPEAT(strexpr,count)", "{fn REPEAT(?,?)}"}, {"REPLACE(target,old,new)", "{fn REPLACE(?,?,?)}"}, {"RIGHT(strexpr,count)", "{fn RIGHT(?,?)}"}, {"RTRIM(strexpr)", "{fn RTRIM(?)}"}, {"SOUNDEX(strexpr)", "{fn SOUNDEX(?)}"}, {"SPACE(count)", "{fn SPACE(?)}"}, {"SUBSTRING(strexpr,pos,len)", "{fn SUBSTRING(?,?,?)}"}, {"UCASE(strexpr)", "{fn UCASE(?)}"}};
    public static int[] sStringFunctionMasks = new int[]{ODBCWizardCapabilities.SQL_FN_STR_ASCII, ODBCWizardCapabilities.SQL_FN_STR_CHAR, ODBCWizardCapabilities.SQL_FN_STR_CONCAT, ODBCWizardCapabilities.SQL_FN_STR_DIFFERENCE, ODBCWizardCapabilities.SQL_FN_STR_INSERT, ODBCWizardCapabilities.SQL_FN_STR_LCASE, ODBCWizardCapabilities.SQL_FN_STR_LEFT, ODBCWizardCapabilities.SQL_FN_STR_LENGTH, ODBCWizardCapabilities.SQL_FN_STR_LOCATE, ODBCWizardCapabilities.SQL_FN_STR_LOCATE_2, ODBCWizardCapabilities.SQL_FN_STR_LTRIM, ODBCWizardCapabilities.SQL_FN_STR_REPEAT, ODBCWizardCapabilities.SQL_FN_STR_REPLACE, ODBCWizardCapabilities.SQL_FN_STR_RIGHT, ODBCWizardCapabilities.SQL_FN_STR_RTRIM, ODBCWizardCapabilities.SQL_FN_STR_SOUNDEX, ODBCWizardCapabilities.SQL_FN_STR_SPACE, ODBCWizardCapabilities.SQL_FN_STR_SUBSTRING, ODBCWizardCapabilities.SQL_FN_STR_UCASE};
    public static String[][] sNumericFunctions = new String[][]{{"ABS(numexpr)", "{fn ABS(?)}"}, {"ACOS(numexpr)", "{fn ACOS(?)}"}, {"ASIN(numexpr)", "{fn ASIN(?)}"}, {"ATAN(numexpr)", "{fn ATAN(?)}"}, {"ATAN2(xcoord,ycoord)", "{fn ATAN2(?,?)}"}, {"CEILING(numexpr)", "{fn CEILING(?)}"}, {"COS(radians)", "{fn COS(?)}"}, {"COT(radians)", "{fn COT(?)}"}, {"DEGREES(radians)", "{fn DEGREES(?)}"}, {"EXP(numexpr)", "{fn EXP(?)}"}, {"FLOOR(numexpr)", "{fn FLOOR(?)}"}, {"LOG(numexpr)", "{fn LOG(?)}"}, {"LOG10(numexpr)", "{fn LOG10(?)}"}, {"MOD(numexpr,modulus)", "{fn MOD(?,?)}"}, {"PI()", "{fn PI()}"}, {"POWER(numexpr, expon)", "{fn POWER(?,?)}"}, {"RADIANS(degrees)", "{fn RADIANS(?)}"}, {"RAND(intexpr)", "{fn RAND(?)}"}, {"ROUND(numexpr, places)", "{fn ROUND(?,?)}"}, {"SIGN(numexpr)", "{fn SIGN(?)}"}, {"SIN(radians)", "{fn SIN(?)}"}, {"SQRT(numexpr)", "{fn SQRT(?)}"}, {"TAN(radians)", "{fn TAN(?)}"}, {"TRUNCATE(numexpr, places)", "{fn TRUNCATE(?,?)}"}};
    public static int[] sNumericFunctionMasks = new int[]{ODBCWizardCapabilities.SQL_FN_NUM_ABS, ODBCWizardCapabilities.SQL_FN_NUM_ACOS, ODBCWizardCapabilities.SQL_FN_NUM_ASIN, ODBCWizardCapabilities.SQL_FN_NUM_ATAN, ODBCWizardCapabilities.SQL_FN_NUM_ATAN2, ODBCWizardCapabilities.SQL_FN_NUM_CEILING, ODBCWizardCapabilities.SQL_FN_NUM_COS, ODBCWizardCapabilities.SQL_FN_NUM_COT, ODBCWizardCapabilities.SQL_FN_NUM_DEGREES, ODBCWizardCapabilities.SQL_FN_NUM_EXP, ODBCWizardCapabilities.SQL_FN_NUM_FLOOR, ODBCWizardCapabilities.SQL_FN_NUM_LOG, ODBCWizardCapabilities.SQL_FN_NUM_LOG10, ODBCWizardCapabilities.SQL_FN_NUM_MOD, ODBCWizardCapabilities.SQL_FN_NUM_PI, ODBCWizardCapabilities.SQL_FN_NUM_POWER, ODBCWizardCapabilities.SQL_FN_NUM_RADIANS, ODBCWizardCapabilities.SQL_FN_NUM_RAND, ODBCWizardCapabilities.SQL_FN_NUM_ROUND, ODBCWizardCapabilities.SQL_FN_NUM_SIGN, ODBCWizardCapabilities.SQL_FN_NUM_SIN, ODBCWizardCapabilities.SQL_FN_NUM_SQRT, ODBCWizardCapabilities.SQL_FN_NUM_TAN, ODBCWizardCapabilities.SQL_FN_NUM_TRUNCATE};
    public static String[][] sDateTimeFunctions = new String[][]{{"CURDATE()", "{fn CURDATE()}"}, {"CURTIME()", "{fn CURTIME()}"}, {"DAYNAME(dateexpr)", "{fn DAYNAME(?)}"}, {"DAYOFMONTH(dateexpr)", "{fn DAYOFMONTH(?)}"}, {"DAYOFWEEK(dateexpr)", "{fn DAYOFWEEK(?)}"}, {"DAYOFYEAR(dateexpr)", "{fn DAYOFYEAR(?)}"}, {"HOUR(timeexpr)", "{fn HOUR(?)}"}, {"MINUTE(timeexpr)", "{fn MINUTE(?)}"}, {"MONTH(dateexpr)", "{fn MONTH(?)}"}, {"MONTHNAME(dateexpr)", "{fn MONTHNAME(?)}"}, {"NOW()", "{fn NOW()}"}, {"QUARTER(dateexpr)", "{fn QUARTER(?)}"}, {"SECOND(timeexpr)", "{fn SECOND(?)}"}, {"TIMESTAMPADD(per,int,timeexpr)", "{fn TIMESTAMPADD(?,?,?)}"}, {"TIMESTAMPDIFF(per,timeexpr,timeexpr)", "{fn TIMESTAMPDIFF(?,?,?)}"}, {"WEEK(dateexpr)", "{fn WEEK(?)}"}, {"YEAR(dateexpr)", "{fn YEAR(?)}"}};
    public static int[] sDateTimeFunctionMasks = new int[]{ODBCWizardCapabilities.SQL_FN_TD_CURDATE, ODBCWizardCapabilities.SQL_FN_TD_CURTIME, ODBCWizardCapabilities.SQL_FN_TD_DAYNAME, ODBCWizardCapabilities.SQL_FN_TD_DAYOFMONTH, ODBCWizardCapabilities.SQL_FN_TD_DAYOFWEEK, ODBCWizardCapabilities.SQL_FN_TD_DAYOFYEAR, ODBCWizardCapabilities.SQL_FN_TD_HOUR, ODBCWizardCapabilities.SQL_FN_TD_MINUTE, ODBCWizardCapabilities.SQL_FN_TD_MONTH, ODBCWizardCapabilities.SQL_FN_TD_MONTHNAME, ODBCWizardCapabilities.SQL_FN_TD_NOW, ODBCWizardCapabilities.SQL_FN_TD_QUARTER, ODBCWizardCapabilities.SQL_FN_TD_SECOND, ODBCWizardCapabilities.SQL_FN_TD_TIMESTAMPADD, ODBCWizardCapabilities.SQL_FN_TD_TIMESTAMPDIFF, ODBCWizardCapabilities.SQL_FN_TD_WEEK, ODBCWizardCapabilities.SQL_FN_TD_YEAR};
    public static String[][] sSystemFunctions = new String[][]{{"USER()", "{fn USER()}"}, {"DATABASE()", "{fn DATABASE()}"}, {"IFNULL(expr,retvalue)", "{fn IFNULL(?,?)}"}};
    public static int[] sSystemFunctionMasks = new int[]{ODBCWizardCapabilities.SQL_FN_SYS_USERNAME, ODBCWizardCapabilities.SQL_FN_SYS_DBNAME, ODBCWizardCapabilities.SQL_FN_SYS_IFNULL};
    public static String[][] sConvertFunctions = new String[][]{{"CONVERT(expr,datatype)", "{fn CONVERT(?,?)}"}};
    public static int[] sConvertFunctionMasks = new int[]{ODBCWizardCapabilities.SQL_FN_CVT_CONVERT};
    private static HashMap<String, String> invalidFieldsMap;

    private ODBCUtil() {
        this.keywords.addAll(Arrays.asList(odbcKeywords));
        this.keywords.addAll(Arrays.asList(sqlKeywords));
        this.stringentDBMS = new HashSet<String>();
        this.stringentDBMS.addAll(Arrays.asList(stringentDBMSInit));
    }

    public static ODBCUtil getODBCUtil() {
        if (instance == null) {
            instance = new ODBCUtil();
        }
        return instance;
    }

    public static String generateValidSpssName(ODBCColumn oDBCColumn) {
        if (invalidFieldsMap.containsKey(oDBCColumn.getQualifiedColumnName())) {
            return invalidFieldsMap.get(oDBCColumn.getQualifiedColumnName());
        }
        String string = ODBCUtil.getValidName(oDBCColumn.getColumnName());
        if (!ComponentState.isUnicodeServer()) {
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            for (char c : cArray) {
                char[] cArray2 = new char[]{c};
                if (VarNameValidator.validateAgainstCurCharSet((String)new String(cArray2))) {
                    stringBuffer.append("_");
                    bl = true;
                    continue;
                }
                stringBuffer.append(c);
            }
            if (bl) {
                string = stringBuffer.toString();
                string = ODBCUtil.getValidName(string);
            }
        }
        invalidFieldsMap.put(oDBCColumn.getQualifiedColumnName(), string);
        return string;
    }

    public static String getValidName(String string) {
        VarNameValidator.ValidNameCode validNameCode;
        boolean bl;
        int n = 1;
        String string2 = string;
        boolean bl2 = true;
        for (int i = 0; i < string2.length(); ++i) {
            if (!Character.isLetter(string2.charAt(i)) && Character.isLetterOrDigit(string2.charAt(i))) continue;
            bl2 = false;
            break;
        }
        if (bl2 || Character.isDigit(string2.charAt(0))) {
            string2 = "@" + string2;
        }
        string2 = string2.replaceAll(" ", "_");
        block10: do {
            validNameCode = VarNameValidator.validateSPSSName((String)string2, (boolean)true);
            bl = false;
            switch (validNameCode) {
                case SPSSNAME_STANDARD: {
                    break;
                }
                case SPSSNAME_SCRATCH: 
                case SPSSNAME_SYSTEM: 
                case SPSSNAME_RESERVED: {
                    string2 = "@" + string2;
                    bl = true;
                    break;
                }
                case SPSSNAME_BADFIRST: {
                    if (string2.charAt(0) == '\'' || string2.charAt(0) == '\"') {
                        string2 = string2.replaceAll("'", "");
                        if ((string2 = string2.replaceAll("\"", "")).length() == 0) break;
                        bl = true;
                        break;
                    }
                    char c = string2.charAt(0);
                    if ((string2 = c == '_' ? "@" + string2 : string2.replaceAll("\\" + c, "")).length() == 0) continue block10;
                    bl = true;
                    break;
                }
                case SPSSNAME_BADLAST: {
                    if (string2.length() <= 1) break;
                    string2 = string2.substring(0, string2.length() - 1);
                    bl = true;
                    break;
                }
                case SPSSNAME_WARN_UNDERSCORE: {
                    validNameCode = VarNameValidator.ValidNameCode.SPSSNAME_STANDARD;
                    break;
                }
                case SPSSNAME_BADLTH: {
                    string2 = string2.substring(0, 64);
                    bl = true;
                }
                case SPSSNAME_BADCHAR: {
                    if (string2.length() == 0) break;
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < string2.length(); ++i) {
                        char c = string2.charAt(i);
                        if (Character.isLowerCase(c)) {
                            stringBuffer.append(c);
                            continue;
                        }
                        if (Character.isLetter(c)) {
                            stringBuffer.append(c);
                            continue;
                        }
                        if (Character.isDigit(c)) {
                            stringBuffer.append(c);
                            continue;
                        }
                        if (c == '@') {
                            stringBuffer.append(c);
                            continue;
                        }
                        if (c == '#') {
                            stringBuffer.append(c);
                            continue;
                        }
                        if (c == '$') {
                            stringBuffer.append(c);
                            continue;
                        }
                        if (c == '_') {
                            stringBuffer.append(c);
                            continue;
                        }
                        if (c != '.') continue;
                        stringBuffer.append(c);
                    }
                    string2 = stringBuffer.toString();
                    bl = true;
                }
            }
        } while (bl);
        if (validNameCode != VarNameValidator.ValidNameCode.SPSSNAME_STANDARD) {
            string2 = "V" + n;
        }
        return string2;
    }

    public boolean isKeyWord(String string) {
        return this.keywords.contains(string.toUpperCase());
    }

    public static String qualifyName(String string, String string2, String string3, boolean bl) {
        String string4;
        StringBuffer stringBuffer = new StringBuffer();
        ODBCUtil oDBCUtil = ODBCUtil.getODBCUtil();
        String string5 = ODBC.getODBC().getCapabilities().getStrDBMSName();
        if (string != null && string.length() > 0 && (!string5.contains("EXCEL") && !string5.contains("ACCESS") || string5.contains("OPENACCESS"))) {
            string4 = string;
            if (bl) {
                string4 = oDBCUtil.quoteName(string);
            }
            stringBuffer.append(string4);
        }
        if (string2 != null && string2.length() > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('.');
            }
            string4 = string2;
            if (bl) {
                string4 = oDBCUtil.quoteName(string2);
            }
            stringBuffer.append(string4);
        }
        if (string3 != null && string3.length() > 0) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('.');
            }
            string4 = string3;
            if (bl) {
                string4 = oDBCUtil.quoteName(string3);
            }
            stringBuffer.append(string4);
        }
        return stringBuffer.toString();
    }

    public String quoteName(String string) {
        char c;
        ODBCWizardCapabilities oDBCWizardCapabilities;
        String string2;
        boolean bl = false;
        if (this.isKeyWord(string)) {
            bl = true;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (Character.isLetterOrDigit(c2) || c2 == '_') continue;
            bl = true;
            break;
        }
        if (this.stringentDBMS.contains(string2 = (oDBCWizardCapabilities = ODBC.getODBC().getCapabilities()).getStrDBMSName().toUpperCase())) {
            if (!string2.equals("XML") && oDBCWizardCapabilities.getODBCInUnicode()) {
                bl = true;
            } else if (!string.toUpperCase().equals(string)) {
                bl = true;
            }
        }
        if (string2.contains("SQL SERVER") && string.length() > 0 && Character.isDigit(c = string.charAt(0))) {
            bl = true;
        }
        if ((string2.contains("EXCEL") || string2.contains("ACCESS")) && string.length() > 0 && Character.isDigit(c = string.charAt(0))) {
            bl = true;
        }
        if (string2.toUpperCase().contains("DB2") || string2.toUpperCase().contains("NETEZZA") || string2.toUpperCase().contains("GREENPLUM") || string2.toUpperCase().contains("POSTGRESQL") || string2.toUpperCase().contains("HDB")) {
            if (!string.toUpperCase().equals(string)) {
                bl = true;
            } else if (ODBC.getODBC().getCapabilities().getODBCInUnicode()) {
                bl = true;
            }
        }
        String string3 = ODBC.getODBC().getCapabilities().getStrIdentifierQuoteCharacter();
        String string4 = ODBC.getODBC().getCapabilities().getStrIdentifierQuoteSuffixCharacter();
        if (string2.toUpperCase().contains("SQL SERVER") && string3.length() == 0 && string4.length() == 0) {
            string3 = "[";
            string4 = "]";
        }
        if (bl && string.length() > 0) {
            return string3 + string + string4;
        }
        return string;
    }

    public static String[][] getFunctions() {
        int n;
        ODBCWizardCapabilities oDBCWizardCapabilities = ODBC.getODBC().getCapabilities();
        int n2 = oDBCWizardCapabilities.getStringFunctions();
        int n3 = oDBCWizardCapabilities.getNumericFunctions();
        int n4 = oDBCWizardCapabilities.getTimeDateFunctions();
        int n5 = oDBCWizardCapabilities.getSystemFunctions();
        int n6 = oDBCWizardCapabilities.getConvertFunctions();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        assert (sStringFunctions.length == sStringFunctionMasks.length);
        for (n = 0; n < sStringFunctions.length; ++n) {
            if ((n2 & sStringFunctionMasks[n]) == 0) continue;
            arrayList.add(sStringFunctions[n]);
        }
        assert (sNumericFunctions.length == sNumericFunctionMasks.length);
        for (n = 0; n < sNumericFunctions.length; ++n) {
            if ((n3 & sNumericFunctionMasks[n]) == 0) continue;
            arrayList.add(sNumericFunctions[n]);
        }
        assert (sDateTimeFunctions.length == sDateTimeFunctionMasks.length);
        for (n = 0; n < sDateTimeFunctions.length; ++n) {
            if ((n4 & sDateTimeFunctionMasks[n]) == 0) continue;
            arrayList.add(sDateTimeFunctions[n]);
        }
        assert (sSystemFunctions.length == sSystemFunctionMasks.length);
        for (n = 0; n < sSystemFunctions.length; ++n) {
            if ((n5 & sSystemFunctionMasks[n]) == 0) continue;
            arrayList.add(sSystemFunctions[n]);
        }
        assert (sConvertFunctions.length == sConvertFunctionMasks.length);
        for (n = 0; n < sConvertFunctions.length; ++n) {
            if ((n6 & sConvertFunctionMasks[n]) == 0) continue;
            arrayList.add(sConvertFunctions[n]);
        }
        Collections.sort(arrayList, new FunctionComparator());
        String[][] stringArray = new String[arrayList.size()][2];
        return (String[][])arrayList.toArray((T[])stringArray);
    }

    private static class FunctionComparator
    implements Comparator<String[]> {
        private FunctionComparator() {
        }

        @Override
        public int compare(String[] stringArray, String[] stringArray2) {
            return stringArray[0].compareTo(stringArray2[0]);
        }
    }
}

