/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc;

import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCTable;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCUtil;
import com.spss.java_client.ui.dialogs.base.file.res.FileResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import java.util.ResourceBundle;

public class ODBCColumn
implements Comparable<ODBCColumn> {
    private ODBCTable table;
    private String qualifier;
    private String owner;
    private String tableName;
    private String columnName;
    private short dataType;
    private String typeName;
    private int precision;
    private int length;
    private short scale;
    private short radix;
    private short nullable;
    private String remarks;
    private boolean hasTranscodingErrors;

    public ODBCColumn(ODBCTable oDBCTable, String string, String string2, String string3, String string4, short s, String string5, int n, int n2, short s2, short s3, short s4, String string6, boolean bl) {
        this.table = oDBCTable;
        this.qualifier = string;
        this.owner = string2;
        this.tableName = string3;
        this.columnName = string4;
        this.dataType = s;
        this.typeName = string5;
        this.typeName = string5.length() > 0 ? string5 : "varchar";
        this.precision = n;
        this.length = n2;
        this.scale = s2;
        this.radix = s3;
        this.nullable = s4;
        this.remarks = string6;
        this.hasTranscodingErrors = bl;
    }

    public ODBCColumn(ODBCColumn oDBCColumn) {
        this(oDBCColumn.table, oDBCColumn.qualifier, oDBCColumn.owner, oDBCColumn.tableName, oDBCColumn.columnName, oDBCColumn.dataType, oDBCColumn.typeName, oDBCColumn.precision, oDBCColumn.length, oDBCColumn.scale, oDBCColumn.radix, oDBCColumn.nullable, oDBCColumn.remarks, oDBCColumn.hasTranscodingErrors);
    }

    public ODBCTable getTable() {
        return this.table;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getQuotedColumnName() {
        ODBCUtil oDBCUtil = ODBCUtil.getODBCUtil();
        return oDBCUtil.quoteName(this.columnName);
    }

    public String getQualifiedColumnName() {
        return this.table.getQualifiedName() + "." + this.columnName;
    }

    public String getQuotedQualifiedColumnName() {
        return this.table.getQualifiedName() + "." + this.getQuotedColumnName();
    }

    public short getDataType() {
        return this.dataType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getSPSSDataType() {
        short s = this.getDataType();
        if (s == 1 || s == 12 || s == -96 || s == -9 || s == -8) {
            return 1;
        }
        if (s == -1 || s == -97) {
            return -1;
        }
        if (s == 9 || s == 10 || s == 11) {
            return 9;
        }
        return s;
    }

    public String getStrDataType() {
        int n = this.getSPSSDataType();
        ResourceBundle resourceBundle = ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        if (n == 1 || n == -1) {
            return ResUtil.getString(resourceBundle, "IDS_DB_COMMON_STRING");
        }
        if (n == 9) {
            return ResUtil.getString(resourceBundle, "IDS_DB_COMMON_DATE");
        }
        return ResUtil.getString(resourceBundle, "IDS_DB_COMMON_NUMERIC");
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getLength() {
        return this.length;
    }

    public short getScale() {
        return this.scale;
    }

    public short getRadix() {
        return this.radix;
    }

    public short getNullable() {
        return this.nullable;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public boolean hasTranscodingErrors() {
        return this.hasTranscodingErrors;
    }

    @Override
    public int compareTo(ODBCColumn oDBCColumn) {
        return this.getColumnName().compareTo(oDBCColumn.getColumnName());
    }
}

