/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc;

import com.spss.java_client.core.comp_util.IDialogCallback;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.data_access.ODBC.ODBCDacProxy;
import com.spss.java_client.core.server.messages.DataAccess.OleDbDataSourceInfo;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.ColumnsInfo;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.ForeignKeysInfo;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.ODBCWizardCapabilities;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.TablesInfo;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.base.file.DialogCallbackImpl;
import com.spss.java_client.ui.dialogs.base.file.ProgressFrame;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBWizardUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCForeignKey;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCTable;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCUtil;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.doc_types.SpssFrame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ODBC {
    private static ODBC instance = null;
    ODBCDacProxy proxy = null;
    private boolean connected;
    private boolean isUseODBC = true;
    private String oleDBConnectString;
    private String lastConnectionString;
    private String lastDataSourceName;
    private ODBCWizardCapabilities odbcCapabilities;
    private List<ODBCTable> odbcTables = null;
    private Map<String, ODBCTable> odbcTableCache = null;
    private Map<String, List<ODBCColumn>> odbcColumnCache = new HashMap<String, List<ODBCColumn>>();

    private ODBC() {
        this.proxy = ODBCDacProxy.getODBCDacProxy();
        this.clearCaches();
    }

    public static ODBC getODBC() {
        if (instance == null) {
            instance = new ODBC();
        }
        return instance;
    }

    public Vector<OleDbDataSourceInfo> getOleDBDataSources() {
        ODBCDacProxy.SqlReturnCode sqlReturnCode = new ODBCDacProxy.SqlReturnCode(this.proxy);
        Vector<OleDbDataSourceInfo> vector = new Vector<OleDbDataSourceInfo>();
        ODBCDacProxy.ProxyReturnCode proxyReturnCode = this.proxy.getOleDbDataSources(vector, sqlReturnCode);
        return vector;
    }

    public OleDbDataSourceInfo getOleDBDataSource(String string) {
        Vector<OleDbDataSourceInfo> vector = this.getOleDBDataSources();
        for (OleDbDataSourceInfo oleDbDataSourceInfo : vector) {
            if (!oleDbDataSourceInfo.getName().trim().equalsIgnoreCase(string.trim())) continue;
            return oleDbDataSourceInfo;
        }
        return null;
    }

    public void setOleDBConnectString(String string) {
        this.oleDBConnectString = string;
    }

    public boolean connectFromConnectionString(boolean bl, boolean bl2, String string, String string2) {
        if (bl) {
            this.lastDataSourceName = string;
            this.lastConnectionString = string2;
        } else {
            this.oleDBConnectString = string2;
        }
        return this.connect(bl, bl2, string, "");
    }

    public boolean connect(boolean bl, boolean bl2, String string, String string2) {
        ODBCDacProxy.ProxyReturnCode proxyReturnCode;
        if (this.connected) {
            this.disconnect();
        }
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        ODBCDacProxy.SqlReturnCode sqlReturnCode = new ODBCDacProxy.SqlReturnCode(this.proxy);
        DialogCallbackImpl dialogCallbackImpl = new DialogCallbackImpl(spssFrame);
        String string3 = "";
        ODBCWizardCapabilities oDBCWizardCapabilities = new ODBCWizardCapabilities();
        if (bl) {
            if (!bl2) {
                if (string2.contains("Excel") || string2.contains("Access")) {
                    this.proxy.setConnectString("");
                } else {
                    string3 = this.getLastConnectString(string);
                    this.proxy.setConnectString(string3);
                }
            }
            this.proxy.setDsnDriverName(string2);
            proxyReturnCode = this.proxy.connectToDataSource(string, (IDialogCallback)dialogCallbackImpl, oDBCWizardCapabilities, sqlReturnCode);
        } else {
            proxyReturnCode = this.proxy.setOleDbConnectionString(this.oleDBConnectString, (IDialogCallback)dialogCallbackImpl, oDBCWizardCapabilities, sqlReturnCode);
        }
        boolean bl3 = sqlReturnCode.getSqlCode() == -1 || sqlReturnCode.getSqlCode() == 100 || proxyReturnCode == ODBCDacProxy.ProxyReturnCode.NETWORK_ERROR || proxyReturnCode == ODBCDacProxy.ProxyReturnCode.UI_CANCELLED ? false : proxyReturnCode == ODBCDacProxy.ProxyReturnCode.PROXY_OK;
        this.connected = bl3;
        if (bl3) {
            this.isUseODBC = bl;
            this.lastConnectionString = this.proxy.getConnectString();
            this.lastDataSourceName = string;
            this.odbcCapabilities = oDBCWizardCapabilities;
            String string4 = oDBCWizardCapabilities.getStrDBMSName().toUpperCase();
            if (string4.contains("ACCESS") && !string4.contains("OPENACCESS")) {
                oDBCWizardCapabilities.setStrIdentifierQuoteCharacter("[");
                oDBCWizardCapabilities.setStrIdentifierQuoteSuffixCharacter("]");
            }
        }
        return bl3;
    }

    public void disconnect() {
        if (!this.connected) {
            return;
        }
        String string = this.odbcCapabilities.getStrDBMSName().toUpperCase();
        if (!string.contains("OPENACCESS")) {
            this.proxy.disconnect();
            this.connected = false;
        }
        this.clearCaches();
    }

    private void clearCaches() {
        this.odbcTables = new ArrayList<ODBCTable>();
        this.odbcTableCache = new HashMap<String, ODBCTable>();
        this.odbcColumnCache = new HashMap<String, List<ODBCColumn>>();
    }

    public boolean isRemoteConnection() {
        return this.proxy.isRemoteConnection();
    }

    public boolean isUseODBC() {
        return this.isUseODBC;
    }

    public boolean loadTables(BaseWizardDialog baseWizardDialog) {
        return this.loadTables(baseWizardDialog, null);
    }

    public boolean loadTables(BaseWizardDialog baseWizardDialog, String string) {
        if (!this.connected) {
            return false;
        }
        ODBCDacProxy.SqlReturnCode sqlReturnCode = new ODBCDacProxy.SqlReturnCode(this.proxy);
        if (!this.isUseODBC) {
            this.proxy.setConnectString(this.oleDBConnectString);
        }
        TablesInfo tablesInfo = new TablesInfo();
        ODBCDacProxy.ProxyReturnCode proxyReturnCode = this.proxy.getTables(tablesInfo, sqlReturnCode, this.isUseODBC, string);
        if (sqlReturnCode.getSqlCode() == -1) {
            return false;
        }
        tablesInfo.sort();
        int n = tablesInfo.getTableCols().size();
        if (n > 0) {
            ProgressFrame progressFrame = null;
            if (baseWizardDialog != null) {
                progressFrame = new ProgressFrame(baseWizardDialog);
                progressFrame.setVisible(true);
                progressFrame.setAlwaysOnTop(true);
                progressFrame.setLabelText(String.format(DBWizardUtil.getDialog().getResString("IDS_DB_WELCOME_PROGRESS_LABEL"), this.lastDataSourceName));
                progressFrame.setProgressValue(0);
            }
            int n2 = 0;
            int n3 = 0;
            this.odbcTables = new ArrayList<ODBCTable>(n);
            this.odbcTableCache = new HashMap<String, ODBCTable>(n);
            this.odbcColumnCache = new HashMap<String, List<ODBCColumn>>(n);
            String string2 = this.odbcCapabilities.getStrDBMSName().toUpperCase();
            for (TablesInfo.InternalTableInfo internalTableInfo : tablesInfo.getTableCols()) {
                int n4;
                ++n3;
                ODBCTable oDBCTable = (string2.contains("EXCEL") || string2.contains("ACCESS")) && !string2.contains("OPENACCESS") ? new ODBCTable("", internalTableInfo.getOwner(), internalTableInfo.getName(), internalTableInfo.getType(), internalTableInfo.getDescription()) : new ODBCTable(internalTableInfo.getQualifier(), internalTableInfo.getOwner(), internalTableInfo.getName(), internalTableInfo.getType(), internalTableInfo.getDescription());
                this.odbcTables.add(oDBCTable);
                this.odbcTableCache.put(oDBCTable.getQualifiedName(), oDBCTable);
                if (progressFrame == null || (n4 = n3 * 100 / n) == n2) continue;
                n2 = n4;
                progressFrame.setProgressValue(n2);
                progressFrame.update(progressFrame.getGraphics());
            }
            if (progressFrame != null) {
                progressFrame.dispose();
            }
        }
        return true;
    }

    public List<ODBCTable> getTables() {
        return Collections.unmodifiableList(this.odbcTables);
    }

    public ODBCTable getTable(String string) {
        return this.odbcTableCache.get(string);
    }

    public List<ODBCColumn> getColumns(String string) {
        if (!this.connected) {
            return null;
        }
        if (this.odbcColumnCache.containsKey(string)) {
            return Collections.unmodifiableList(this.odbcColumnCache.get(string));
        }
        ODBCTable oDBCTable = this.getTable(string);
        if (oDBCTable == null) {
            return null;
        }
        assert (string != null);
        ODBCDacProxy.SqlReturnCode sqlReturnCode = new ODBCDacProxy.SqlReturnCode(this.proxy);
        ColumnsInfo columnsInfo = new ColumnsInfo();
        String string2 = oDBCTable.getQuotedName();
        String string3 = oDBCTable.getQuotedOwner();
        String string4 = oDBCTable.getQuotedQualifier();
        String string5 = this.odbcCapabilities.getStrDBMSName().toUpperCase();
        if (string5.contains("EXCEL") || string5.contains("POSTGRESQL") || string5.contains("ORACLE") || string5.contains("DB2") || string5.contains("HDB") || string5.contains("MYSQL") || string5.contains("SQL SERVER") || string5.contains("ACCESS") && !string5.contains("OPENACCESS") || string5.contains("REDSHIFT")) {
            string2 = oDBCTable.getName();
            if (string5.contains("POSTGRESQL") || string5.contains("DB2")) {
                string3 = oDBCTable.getOwner();
            }
            if (string5.contains("REDSHIFT")) {
                string2 = oDBCTable.getName();
                string3 = oDBCTable.getOwner();
                string4 = oDBCTable.getQualifier();
            }
        }
        this.proxy.getColumns(string2, string3, string4, oDBCTable.getName(), columnsInfo, sqlReturnCode, this.isUseODBC);
        ArrayList<ODBCColumn> arrayList = new ArrayList<ODBCColumn>(columnsInfo.getColInfos().size());
        for (ColumnsInfo.InternalColumnInfo internalColumnInfo : columnsInfo.getColInfos()) {
            ODBCColumn oDBCColumn = new ODBCColumn(oDBCTable, internalColumnInfo.getStrQualifier(), internalColumnInfo.getStrOwner(), internalColumnInfo.getStrTableName(), internalColumnInfo.getStrColumnName(), internalColumnInfo.getIDataType(), internalColumnInfo.getStrTypeName(), internalColumnInfo.getIPrecision(), internalColumnInfo.getILength(), internalColumnInfo.getIScale(), internalColumnInfo.getIRadix(), internalColumnInfo.getINullable(), internalColumnInfo.getStrRemarks(), internalColumnInfo.hasTrascodingErrors());
            arrayList.add(oDBCColumn);
        }
        this.odbcColumnCache.put(oDBCTable.getQualifiedName(), arrayList);
        return Collections.unmodifiableList(arrayList);
    }

    public ODBCForeignKey getForeignKey(ODBCTable oDBCTable, ODBCTable oDBCTable2) {
        if (!this.isConnected()) {
            return null;
        }
        ODBCDacProxy oDBCDacProxy = ODBCDacProxy.getODBCDacProxy();
        ODBCDacProxy.SqlReturnCode sqlReturnCode = new ODBCDacProxy.SqlReturnCode(oDBCDacProxy);
        ForeignKeysInfo foreignKeysInfo = new ForeignKeysInfo();
        ODBCDacProxy.ProxyReturnCode proxyReturnCode = ODBCDacProxy.getODBCDacProxy().getPrimeJoins(oDBCTable.getQuotedName(), oDBCTable.getQuotedOwner(), oDBCTable.getQuotedQualifier(), oDBCTable.getName(), oDBCTable2.getQuotedName(), oDBCTable2.getQuotedOwner(), oDBCTable2.getQuotedQualifier(), oDBCTable2.getName(), foreignKeysInfo, sqlReturnCode);
        if (!proxyReturnCode.equals((Object)ODBCDacProxy.ProxyReturnCode.PROXY_OK)) {
            return null;
        }
        int n = foreignKeysInfo.getOutcome();
        if (n != 1 && n != 2) {
            return null;
        }
        String string = ODBCUtil.qualifyName(foreignKeysInfo.getStrQualityP(), foreignKeysInfo.getStrOwnerP(), foreignKeysInfo.getStrTableNameP(), false);
        List<ODBCColumn> list = this.getColumns(string);
        ODBCColumn oDBCColumn = this.findColumn(list, foreignKeysInfo.getStrColNameP());
        String string2 = ODBCUtil.qualifyName(foreignKeysInfo.getStrQualityF(), foreignKeysInfo.getStrOwnerF(), foreignKeysInfo.getStrTableNameF(), false);
        List<ODBCColumn> list2 = this.getColumns(string2);
        ODBCColumn oDBCColumn2 = this.findColumn(list2, foreignKeysInfo.getStrColNameF());
        return new ODBCForeignKey(oDBCColumn, oDBCColumn2, n);
    }

    private ODBCColumn findColumn(List<ODBCColumn> list, String string) {
        for (ODBCColumn oDBCColumn : list) {
            if (!oDBCColumn.getColumnName().equals(string)) continue;
            return oDBCColumn;
        }
        return null;
    }

    public ODBCWizardCapabilities getCapabilities() {
        if (!this.connected) {
            return null;
        }
        return this.odbcCapabilities;
    }

    public String getLastDataSourceName() {
        return this.lastDataSourceName;
    }

    public boolean isConnected() {
        return this.connected;
    }

    private String getLastConnectString(String string) {
        if (string != null && string.length() > 0 && string.equals(this.lastDataSourceName)) {
            return this.lastConnectionString;
        }
        return "";
    }

    public String getLastConnectString() {
        if (!this.isUseODBC) {
            return this.oleDBConnectString;
        }
        return this.getLastConnectString(this.getLastDataSourceName());
    }

    public String getDBMSName() {
        return this.odbcCapabilities.getStrDBMSName().toUpperCase();
    }
}

