/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.utilities;

import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.ColumnsInfo;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.ODBCWizardCapabilities;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.TablesInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBData;
import com.spss.java_client.ui.dialogs.base.file.openquery.DefineVarDataOG;
import com.spss.java_client.ui.dialogs.base.file.openquery.UIData;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBWizardSyntaxUtil;
import com.spss.java_client.ui.dialogs.base.file.res.FileResBundle;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.Component;
import java.io.Serializable;
import java.text.StringCharacterIterator;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class DBWizardUtil {
    private static DBWizardPreviousPage sPreviousPage = DBWizardPreviousPage.eNone;
    private static LinkedHashMap<DefaultMutableTreeNode, ArrayList<DefaultMutableTreeNode>> sSortedTreeNodeHashMap = new LinkedHashMap();
    private static JPanel sPanel;
    private static BaseWizardDialog sWizardDialog;
    private static boolean sSelectDataModified;
    private static LinkedList<String> sSelectDataTargetLinkedList;
    private static String sOpenQuoteChar;
    private static String sCloseQuoteChar;
    private static String sOwnerNameSeperator;
    private static String sTableColNameSeperatorForWhereClause;
    private static int sSelectedDSN;

    public static DBWizardPreviousPage getDBWizardPreviousPage() {
        return sPreviousPage;
    }

    public static void setDBWizardPreviousPage(DBWizardPreviousPage dBWizardPreviousPage) {
        sPreviousPage = dBWizardPreviousPage;
    }

    public static void setSelectDataLinkedList(LinkedList<String> linkedList) {
        sSelectDataTargetLinkedList.clear();
        for (String string : linkedList) {
            sSelectDataTargetLinkedList.add(string);
        }
    }

    public static LinkedList<String> getSelectDataLinkedList() {
        return sSelectDataTargetLinkedList;
    }

    public static JComponent getComponentAt(int n) {
        Component[] componentArray = sPanel.getComponents();
        return (JComponent)componentArray[n];
    }

    public static void setPanel(JPanel jPanel) {
        sPanel = jPanel;
    }

    public static DefaultTreeModel sortTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        Serializable serializable;
        Object object;
        sSortedTreeNodeHashMap.clear();
        if (defaultMutableTreeNode.getChildCount() > 0) {
            object = defaultMutableTreeNode.children();
            while (object.hasMoreElements()) {
                serializable = new ArrayList();
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)object.nextElement();
                if (defaultMutableTreeNode2.getChildCount() > 0) {
                    int n;
                    int n2 = 0;
                    DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[defaultMutableTreeNode2.getChildCount()];
                    Enumeration<TreeNode> object2 = defaultMutableTreeNode2.children();
                    while (object2.hasMoreElements()) {
                        defaultMutableTreeNodeArray[n2] = (DefaultMutableTreeNode)object2.nextElement();
                        ++n2;
                    }
                    for (int i = 0; i < defaultMutableTreeNodeArray.length - 1; ++i) {
                        for (n = i + 1; n < defaultMutableTreeNodeArray.length; ++n) {
                            if (((DefaultMutableTreeNode)defaultMutableTreeNodeArray[i]).toString().compareToIgnoreCase(((DefaultMutableTreeNode)defaultMutableTreeNodeArray[n]).toString()) <= 0) continue;
                            Object object3 = defaultMutableTreeNodeArray[n];
                            defaultMutableTreeNodeArray[n] = defaultMutableTreeNodeArray[i];
                            defaultMutableTreeNodeArray[i] = object3;
                        }
                    }
                    DefaultMutableTreeNode[] defaultMutableTreeNodeArray2 = defaultMutableTreeNodeArray;
                    n = defaultMutableTreeNodeArray2.length;
                    for (int i = 0; i < n; ++i) {
                        Object object4 = defaultMutableTreeNodeArray2[i];
                        defaultMutableTreeNode2.add((MutableTreeNode)object4);
                        ((ArrayList)serializable).add(object4);
                    }
                }
                sSortedTreeNodeHashMap.put(defaultMutableTreeNode2, (ArrayList<DefaultMutableTreeNode>)serializable);
            }
        }
        object = new DefaultMutableTreeNode();
        serializable = new DefaultTreeModel((TreeNode)object);
        for (DefaultMutableTreeNode defaultMutableTreeNode3 : sSortedTreeNodeHashMap.keySet()) {
            ((DefaultMutableTreeNode)object).add(defaultMutableTreeNode3);
            for (DefaultMutableTreeNode defaultMutableTreeNode2 : sSortedTreeNodeHashMap.get(defaultMutableTreeNode3)) {
                defaultMutableTreeNode3.add(defaultMutableTreeNode2);
            }
        }
        return serializable;
    }

    public static boolean isViewTable(String string) {
        return DBData.getDBData().getViewsData().contains(string);
    }

    public static boolean isSystemTable(String string) {
        return DBData.getDBData().getSystemTablesData().contains(string);
    }

    public static boolean isUserTable(String string) {
        return DBData.getDBData().getTablesData().contains(string);
    }

    public static boolean isSynonymsTable(String string) {
        return DBData.getDBData().getSynonymsData().contains(string);
    }

    public static LinkedHashMap<TablesInfo.InternalTableInfo, ArrayList<ColumnsInfo.InternalColumnInfo>> getTableWiseColum() {
        LinkedHashMap<TablesInfo.InternalTableInfo, ArrayList<ColumnsInfo.InternalColumnInfo>> linkedHashMap = new LinkedHashMap<TablesInfo.InternalTableInfo, ArrayList<ColumnsInfo.InternalColumnInfo>>();
        DBData dBData = DBData.getDBData();
        TablesInfo tablesInfo = dBData.getFilteredTablesInfo();
        HashMap<String, ColumnsInfo> hashMap = DBData.getDBData().getColumnsInfo();
        for (TablesInfo.InternalTableInfo internalTableInfo : tablesInfo.getTableCols()) {
            ArrayList<ColumnsInfo.InternalColumnInfo> arrayList = new ArrayList<ColumnsInfo.InternalColumnInfo>();
            for (ColumnsInfo.InternalColumnInfo internalColumnInfo : hashMap.get(internalTableInfo.getQualifiedName()).getColInfos()) {
                arrayList.add(internalColumnInfo);
            }
            linkedHashMap.put(internalTableInfo, arrayList);
        }
        return linkedHashMap;
    }

    public static int getClassifiedDataType(int n) {
        if (n == 1 || n == 12 || n == -96 || n == -9 || n == -8) {
            return 1;
        }
        if (n == -1 || n == -97) {
            return -1;
        }
        if (n == 9 || n == 10 || n == 11) {
            return 9;
        }
        return n;
    }

    public static String getStrDataType(int n) {
        ResourceBundle resourceBundle = ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        if (n == 1 || n == -1) {
            return ResUtil.getString(resourceBundle, "IDS_DB_COMMON_STRING");
        }
        if (n == 9) {
            return ResUtil.getString(resourceBundle, "IDS_DB_COMMON_DATE");
        }
        return ResUtil.getString(resourceBundle, "IDS_DB_COMMON_NUMERIC");
    }

    public static void setDialog(BaseWizardDialog baseWizardDialog) {
        sWizardDialog = baseWizardDialog;
    }

    public static BaseWizardDialog getDialog() {
        return sWizardDialog;
    }

    public static String getQuoteChar() {
        if (sOpenQuoteChar.length() > 0) {
            return sOpenQuoteChar;
        }
        return "\"";
    }

    public static String getOpenQuoteChar() {
        if (DBWizardUtil.getDBMSName().toUpperCase().contains("ACCESS") && !DBWizardUtil.getDBMSName().toUpperCase().contains("OPENACCESS")) {
            return "[";
        }
        if (sOpenQuoteChar.length() > 0) {
            return sOpenQuoteChar;
        }
        return "\"";
    }

    public static String getCloseQuoteChar() {
        if (DBWizardUtil.getDBMSName().toUpperCase().contains("ACCESS") && !DBWizardUtil.getDBMSName().toUpperCase().contains("OPENACCESS")) {
            return "]";
        }
        if (sCloseQuoteChar.length() > 0) {
            return sCloseQuoteChar;
        }
        return "\"";
    }

    public static Integer getSelectedDSN() {
        return sSelectedDSN;
    }

    public static void setSelectedDSN(Integer n) {
        sSelectedDSN = n;
    }

    public static void setSelectDataModified(boolean bl) {
        sSelectDataModified = bl;
        if (sSelectDataModified) {
            DBWizardUtil.resetPages();
        }
    }

    public static void setOpenQuoteChar(String string) {
        sOpenQuoteChar = string;
    }

    public static void setCloseQuoteChar(String string) {
        sCloseQuoteChar = string;
    }

    public static boolean isSelectDataModified() {
        return sSelectDataModified;
    }

    public static String getOwnerNameSeperator() {
        return sOwnerNameSeperator;
    }

    public static String getTableColNameSeperator() {
        return ": ";
    }

    public static String getTableColNameSeperatorForWhereClause() {
        return sTableColNameSeperatorForWhereClause;
    }

    public static void setOwnerNameSeperator(String string) {
        sOwnerNameSeperator = string;
    }

    private static void resetPages() {
        UIData uIData = UIData.getUIData();
        uIData.putObject("CNFP_TRANS_EXPR_TABLE", new ArrayList());
        uIData.putObject("LRCP_USE_RANDOM_SAMPLING_CHECK", false);
        uIData.putObject("LRCP_NATIVE_RANDOM_SAMPLING_RADIO", false);
        uIData.putObject("LRCP_EXACTLY_TEXTFIELD1", "100");
        uIData.putObject("LRCP_EXACTLY_TEXTFIELD2", "1000");
        uIData.putObject("LRCP_APPROXIMATELY_RADIO", true);
        uIData.putObject("LRCP_APPROXIMATELY_SPINNER", 10);
        uIData.putObject("LRCP_CRITERIA_TABLE_MODEL", new ArrayList());
        uIData.putObject("ADP_SOURCE_LIST", new TreeMap());
        uIData.putObject("ADP_BREAK_VARAIBLE_LIST", new TreeMap());
        uIData.putObject("ADP_SUMMARIES_VARIABLE_TABLE", new ArrayList());
        uIData.putObject("ADP_NUMBER_CASES_CHECK", false);
        uIData.putObject("SDP_SOURCE_LIST", new ArrayList());
        uIData.putObject("SDP_TARGET_TABLE", new ArrayList());
        DBData.getDBData().getDefineVarDataList().clear();
    }

    public static String checkForApostopes(String string, boolean bl) {
        return DBWizardUtil.checkForApostrophes(string, bl, true);
    }

    public static String checkForApostrophes(String string, boolean bl, boolean bl2) {
        ODBCWizardCapabilities oDBCWizardCapabilities = DBData.getDBData().getWizardCapabities();
        DBData dBData = DBData.getDBData();
        String string2 = oDBCWizardCapabilities.getStrDBMSName();
        String string3 = DBWizardUtil.getOpenQuoteChar();
        String string4 = DBWizardUtil.getCloseQuoteChar();
        int n = 0;
        if (bl2) {
            n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
        }
        boolean bl3 = false;
        if (n > 1 && n < 8) {
            bl3 = true;
        } else if (DBWizardSyntaxUtil.isODBCSqlKeyWords(string) || DBWizardSyntaxUtil.isSqlKeyWords(string)) {
            bl3 = true;
        } else if (string.startsWith("@")) {
            bl3 = true;
        } else if (string2.toUpperCase().contains("ORACLE") || string2.toUpperCase().contains("DB2") || string2.toUpperCase().contains("OPENACCESS") || string2.toUpperCase().equals("AS")) {
            if (!string.toUpperCase().equals(string)) {
                bl3 = true;
            } else if (dBData.getWizardCapabities().getODBCInUnicode()) {
                bl3 = true;
            }
        } else if (string2.toUpperCase().contains("NETEZZA")) {
            if (!string.toUpperCase().equals(string)) {
                bl3 = true;
            } else if (dBData.getWizardCapabities().getODBCInUnicode()) {
                bl3 = true;
            }
        } else if (string2.toUpperCase().contains("XML")) {
            bl3 = true;
        } else if (!string2.toUpperCase().contains("SQL SERVER") && bl && (string.contains("$") || string.contains("%") || string.contains("@") || string.contains("#"))) {
            bl3 = true;
        }
        if (bl3 && !string.contains(string3) && !string.contains(string4)) {
            string = string3 + string + string4;
        }
        return string;
    }

    public static String checkForApostopes(String string) {
        return DBWizardUtil.checkForApostopes(string, true);
    }

    public static String getDBMSName() {
        ODBCWizardCapabilities oDBCWizardCapabilities = DBData.getDBData().getWizardCapabities();
        return oDBCWizardCapabilities != null ? oDBCWizardCapabilities.getStrDBMSName() : "";
    }

    public static void loadDataFromQuery() {
        DBData dBData = DBData.getDBData();
        AbstractSequentialList abstractSequentialList = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        for (DefineVarDataOG defineVarDataOG : abstractSequentialList) {
            linkedList.add(defineVarDataOG.getQualifiedNameInfo());
        }
        DBWizardUtil.setSelectDataLinkedList(linkedList);
        DBWizardUtil.setOpenQuoteChar(dBData.getWizardCapabities().getStrIdentifierQuoteCharacter());
        DBWizardUtil.setCloseQuoteChar(dBData.getWizardCapabities().getStrIdentifierQuoteSuffixCharacter());
        DBWizardSyntaxUtil.generateSyntaxStrings();
    }

    public static String quoteMe(String string) {
        return DBWizardUtil.quoteMe(string, false);
    }

    public static String quoteMe(String string, boolean bl) {
        if (DBWizardSyntaxUtil.isODBCSqlKeyWords(string) || DBWizardSyntaxUtil.isSqlKeyWords(string)) {
            return DBWizardUtil.quoteIdentifier(string, bl);
        }
        if (DBWizardUtil.isWrongCase(string)) {
            return DBWizardUtil.quoteIdentifier(string, bl);
        }
        DBData dBData = DBData.getDBData();
        if (dBData.getWizardCapabities().getODBCInUnicode()) {
            return DBWizardUtil.quoteIdentifier(string, bl);
        }
        String string2 = DBData.getDBData().getWizardCapabities().getStrDBMSName();
        if (string2.toUpperCase().contains("XML")) {
            return DBWizardUtil.quoteIdentifier(string, bl);
        }
        if (DBWizardUtil.containsInvalidCharacters(string)) {
            return DBWizardUtil.quoteIdentifier(string, bl);
        }
        return string;
    }

    private static boolean isWrongCase(String string) {
        String string2 = DBData.getDBData().getWizardCapabities().getStrDBMSName();
        return string2.toUpperCase().contains("ORACLE") || string2.toUpperCase().contains("DB2") || string2.toUpperCase().contains("OPENACCESS") || string2.toUpperCase().equals("AS") ? !string.toUpperCase().equals(string) : string2.toUpperCase().contains("NETEZZA") && !string.toLowerCase().equals(string);
    }

    private static boolean containsInvalidCharacters(String string) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (!Character.isDigit(c) && !Character.isLetter(c) && c != '_') {
                return true;
            }
            c = stringCharacterIterator.next();
        }
        return false;
    }

    private static String quoteIdentifier(String string, boolean bl) {
        if (!bl) {
            return DBWizardUtil.getOpenQuoteChar() + string + DBWizardUtil.getCloseQuoteChar();
        }
        return "\"" + string + "\"";
    }

    public static String quotedQualifiedColumnName(ColumnsInfo.InternalColumnInfo internalColumnInfo) {
        String string = "";
        LinkedHashMap<String, String> linkedHashMap = DBWizardSyntaxUtil.getTempTableNameMap();
        if (linkedHashMap != null && linkedHashMap.size() > 1) {
            string = string + linkedHashMap.get(internalColumnInfo.getQualifiedTableName());
            string = string + ".";
        } else {
            if (internalColumnInfo.getStrOwner() != null && internalColumnInfo.getStrOwner().length() != 0) {
                string = string + DBWizardUtil.quoteMe(internalColumnInfo.getStrOwner());
                string = string + ".";
            }
            string = string + DBWizardUtil.quoteMe(internalColumnInfo.getStrTableName());
            string = string + ".";
        }
        string = string + DBWizardUtil.quoteMe(internalColumnInfo.getStrColumnName());
        return string;
    }

    public static String quotedQualifiedColumnName(String string, String string2, String string3) {
        String string4 = "";
        LinkedHashMap<String, String> linkedHashMap = DBWizardSyntaxUtil.getTempTableNameMap();
        if (linkedHashMap != null && linkedHashMap.size() > 1) {
            string4 = string4 + linkedHashMap.get(DBData.createQualifiedTablename(string, string2));
            string4 = string4 + ".";
        } else {
            if (string != null && string.length() != 0) {
                string4 = string4 + DBWizardUtil.quoteMe(string);
                string4 = string4 + ".";
            }
            string4 = string4 + DBWizardUtil.quoteMe(string2);
            string4 = string4 + ".";
        }
        string4 = string4 + DBWizardUtil.quoteMe(string3);
        return string4;
    }

    public static String quotedQualifiedTableName(String string) {
        int n;
        Object object;
        String string2 = string;
        String string3 = "";
        if (string != null) {
            object = DBData.getDBData().getTablesInfo();
            n = string.indexOf(DBWizardUtil.getOwnerNameSeperator());
            string3 = n > 0 ? string.substring(0, n) : "";
            string = string.substring(n + 1);
            for (Object object2 : object.getTableCols()) {
                String string4;
                if (!string.endsWith(DBWizardUtil.getOwnerNameSeperator() + object2.getName()) || !object2.getOwner().startsWith(string3) || !(string4 = string3 + DBWizardUtil.getOwnerNameSeperator() + string.substring(0, string.lastIndexOf(DBWizardUtil.getOwnerNameSeperator() + object2.getName()))).equals(object2.getOwner())) continue;
                string = object2.getName();
                string3 = object2.getOwner();
                break;
            }
        }
        if (string3.length() > 0) {
            string = DBWizardUtil.checkForApostopes(string, true);
            string3 = DBWizardUtil.checkForApostrophes(string3, true, false);
            string2 = string3 + DBWizardUtil.getOwnerNameSeperator() + string;
        } else {
            if (string2 != null && string2.contains(DBWizardUtil.getOwnerNameSeperator())) {
                Object object2;
                n = string2.indexOf(DBWizardUtil.getOwnerNameSeperator());
                String string5 = string2.substring(0, n);
                string = string2.substring(n + 1);
                object = DBWizardUtil.checkForApostopes(string, true);
                object2 = DBWizardUtil.checkForApostopes(string5, true);
                object = (String)object2 + DBWizardUtil.getOwnerNameSeperator() + (String)object;
            } else {
                object = DBWizardUtil.checkForApostopes(string2, true);
            }
            string2 = object;
        }
        string2 = DBWizardUtil.checkForApostrophes(string2, true, false);
        return string2;
    }

    static {
        sSelectDataTargetLinkedList = new LinkedList();
        sOwnerNameSeperator = ".";
        sTableColNameSeperatorForWhereClause = ".";
        sSelectedDSN = 0;
    }

    public static enum DBWizardPreviousPage {
        eNone,
        eWelcome,
        eSelectData,
        eSpecifyRelationship,
        eCompuateNewFieldsPage,
        eLimitRetrivedCases,
        eAggregateData,
        eDefineVariables,
        eSortCases,
        eResult;

    }
}

