/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.utilities;

import com.spss.java_client.core.comp_util.PassEncrypt;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.ColumnsInfo;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.TablesInfo;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBData;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBWizardDlgType;
import com.spss.java_client.ui.dialogs.base.file.openquery.DefineVarDataOG;
import com.spss.java_client.ui.dialogs.base.file.openquery.UIData;
import com.spss.java_client.ui.dialogs.base.file.openquery.limit_retrieved_cases.CriteriaTableData;
import com.spss.java_client.ui.dialogs.base.file.openquery.limit_retrieved_cases.PromptValuesData;
import com.spss.java_client.ui.dialogs.base.file.openquery.results.SetPromptValueDialog;
import com.spss.java_client.ui.dialogs.base.file.openquery.sort_cases.SortDataClass;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.JoinType;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.SerializedJoinInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBWizardUtil;
import com.spss.java_client.ui.dialogs.base.file.res.FileResBundle;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.util.CharacterUtil;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class DBWizardSyntaxUtil {
    private static StringBuffer sAllSyntax;
    private static String sConnectionStr;
    private static String sDefineVarPageSyntax;
    private static String sLimitRetrivedCasesPageSyntax;
    private static String sResultsPageSyntax;
    private static String sSelectDataPageSyntax;
    private static String sAggregateDataPageSyntax;
    private static String sSortCasesPageSyntax;
    private static LinkedHashMap<String, String> sTempTableNameMap;
    private static boolean sUseODBC;
    private static String sSelectSyntaxStr;
    private static String sFromSyntaxStr;
    private static String sWhereSyntaxStr;
    private static boolean sNativeSmaplingEnabled;
    private static String sDVPSyntaxTextField;
    private static String sGroupBySyntaxStr;
    private static boolean mListValues;
    private static LinkedHashMap<String, String> sDefineVarSyntaxMap;
    private static String[] sODBCSqlKeyWords;
    private static String[] sSqlKeyWords;
    private static String[] sValidODBCDateFormats;
    private static ArrayList<String> mWhereClauseList;
    private static HashMap<String, Integer> mSuffixMap;
    private static HashMap<String, ColumnsInfo.InternalColumnInfo> mExpressionColMap;
    private static ArrayList<String> mExpressionList;
    private static SerializedJoinInfo mOuterJoin;
    private static ArrayList<SerializedJoinInfo> mInnerJoins;

    public static String getAllAyntax(String string) {
        String string2;
        sAllSyntax = SyntaxUtil.startSyntax();
        sAllSyntax.append("GET DATA");
        sAllSyntax.append("\n  /TYPE=");
        if (sUseODBC) {
            sAllSyntax.append("ODBC");
        } else {
            sAllSyntax.append("OLEDB");
        }
        PassEncrypt passEncrypt = new PassEncrypt();
        String string3 = passEncrypt.odbcEncryptPassword(sConnectionStr, true, sUseODBC);
        string3 = "\n  /CONNECT=" + CharacterUtil.smartQuote((String)string3, (boolean)true);
        sAllSyntax.append(string3);
        sAllSyntax.append("\n  /SQL=");
        if (string.equals("ResultsPage")) {
            string2 = sResultsPageSyntax;
        } else {
            String string4 = sSelectSyntaxStr;
            String string5 = sFromSyntaxStr;
            if (sNativeSmaplingEnabled && sLimitRetrivedCasesPageSyntax != null && sLimitRetrivedCasesPageSyntax.length() > 0) {
                string5 = string5 + " " + sLimitRetrivedCasesPageSyntax;
            }
            String string6 = sWhereSyntaxStr;
            string2 = string4 + string5 + string6;
            if (sGroupBySyntaxStr != null && sGroupBySyntaxStr.length() > 0) {
                string2 = string2 + " " + sGroupBySyntaxStr;
            }
            if (sSortCasesPageSyntax != null && sSortCasesPageSyntax.length() > 0) {
                string2 = string2 + " " + sSortCasesPageSyntax;
            }
        }
        string2 = CharacterUtil.smartQuote((String)string2, (boolean)true);
        sAllSyntax.append(string2);
        sAllSyntax.append("\n");
        if (sDVPSyntaxTextField != null && sDVPSyntaxTextField.length() > 0) {
            sAllSyntax.append(sDVPSyntaxTextField);
        } else {
            sAllSyntax.append("  /ASSUMEDSTRWIDTH=255");
        }
        sAllSyntax.append(".");
        if (!sNativeSmaplingEnabled && sLimitRetrivedCasesPageSyntax != null && sLimitRetrivedCasesPageSyntax.length() > 0) {
            sAllSyntax.append("\n").append(sLimitRetrivedCasesPageSyntax);
        }
        sAllSyntax.append("\nCACHE.\nEXECUTE.");
        if (sDefineVarPageSyntax != null && sDefineVarPageSyntax.length() > 0) {
            sAllSyntax.append(sDefineVarPageSyntax);
        }
        sAllSyntax.append("\nDATASET NAME ").append(DBWizardSyntaxUtil.getNextDataSetName()).append(" WINDOW=FRONT");
        sAllSyntax.append(SyntaxUtil.terminateSyntax());
        return sAllSyntax.toString();
    }

    public static void reset() {
        sAggregateDataPageSyntax = "";
        if (sAllSyntax != null) {
            sAllSyntax.setLength(0);
        }
        sConnectionStr = "";
        sDefineVarPageSyntax = "";
        sDefineVarSyntaxMap.clear();
        sDVPSyntaxTextField = "";
        sFromSyntaxStr = "";
        sGroupBySyntaxStr = "";
        sLimitRetrivedCasesPageSyntax = "";
        sNativeSmaplingEnabled = false;
        sResultsPageSyntax = "";
        sSelectDataPageSyntax = "";
        sSortCasesPageSyntax = "";
        if (sTempTableNameMap != null) {
            sTempTableNameMap.clear();
        }
        sUseODBC = false;
        sWhereSyntaxStr = "";
    }

    public static String getConnectionStr() {
        return sConnectionStr;
    }

    public static String getGroupBySyntaxStr() {
        if (sGroupBySyntaxStr != null) {
            return sGroupBySyntaxStr;
        }
        return "";
    }

    public static void setGroupBySyntaxStr(String string) {
        sGroupBySyntaxStr = string;
    }

    public static String getDefineVarPageSyntax() {
        return sDefineVarPageSyntax;
    }

    public static String getLimitRetrivedCasesPageSyntax() {
        return sLimitRetrivedCasesPageSyntax;
    }

    public static String getNextDataSetName() {
        String string = SpssMgr.getSpssMgr().getNextFreeDatasetName();
        return string;
    }

    public static String parsePrompt(String string, LinkedList<String> linkedList) {
        String string2;
        Object object;
        String string3 = "";
        String string4 = "";
        String string5 = "SQL=";
        if (string.contains(string5)) {
            object = string.split(string5);
            string4 = object[0];
        }
        if (string.contains("ASSUMEDSTRWIDTH")) {
            object = string.split("ASSUMEDSTRWIDTH");
            string = object[0];
            string3 = object[1];
        }
        if (string.contains("ORDER BY")) {
            object = string.split("ORDER BY");
            string = object[0].substring(0, object[0].length() - 1);
        }
        object = new Scanner(string);
        Pattern pattern = Pattern.compile("PROMPT");
        ((Scanner)object).useDelimiter(pattern);
        int n = 0;
        String string6 = "";
        while (((Scanner)object).hasNext()) {
            string2 = ((Scanner)object).next();
            if (n != 0) {
                String[] stringArray = string2.split("\\)");
                string6 = string6 + linkedList.get(n - 1);
                if (stringArray.length == 3) {
                    string6 = string6 + stringArray[1];
                } else if (stringArray.length == 2) {
                    string6 = string6 + stringArray[1];
                } else if (stringArray.length == 4) {
                    string6 = string6 + stringArray[2];
                }
            } else {
                string6 = string6 + string2;
            }
            ++n;
        }
        int n2 = string6.indexOf(string5) + string5.length() + 1;
        string2 = string6.substring(n2) + ")";
        if (sGroupBySyntaxStr != null && sGroupBySyntaxStr.length() > 0) {
            string2 = string2 + " " + sGroupBySyntaxStr;
        }
        if (sSortCasesPageSyntax != null && sSortCasesPageSyntax.length() > 0) {
            string2 = string2 + " " + sSortCasesPageSyntax;
        }
        string2 = CharacterUtil.smartQuote((String)string2, (boolean)true);
        string6 = string4 + string5 + string2;
        string6 = SyntaxMgr.getSyntaxMgr().wrapSyntaxForPaste(string6);
        if (string3.length() > 0) {
            string6 = string6 + "\n  /ASSUMEDSTRWIDTH" + string3;
        }
        return string6;
    }

    public static void setSelectSyntaxStr(String string) {
        sSelectSyntaxStr = string;
    }

    public static String getSelectSyntaxStr() {
        return sSelectSyntaxStr;
    }

    public static void setFromSyntaxStr(String string) {
        sFromSyntaxStr = string;
    }

    public static String getFromSyntaxStr() {
        return sFromSyntaxStr;
    }

    public static void setWhereSyntaxStr(String string) {
        sWhereSyntaxStr = string;
    }

    public static String getWhereSyntaxStr() {
        return sWhereSyntaxStr;
    }

    public static String[] getODBCSqlKeyWords() {
        return sODBCSqlKeyWords;
    }

    public static String getResultsPageSyntax() {
        return sResultsPageSyntax;
    }

    public static String getSelectDataPageSyntax() {
        return sSelectDataPageSyntax;
    }

    public static String getSortCasesPageSyntax() {
        return sSortCasesPageSyntax;
    }

    public static String[] getSQLKeyWord() {
        return sSqlKeyWords;
    }

    public static String getSqlSyntax() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(DBWizardSyntaxUtil.getSelectDataPageSyntax()).append(DBWizardSyntaxUtil.getWhereSyntaxStr());
        return stringBuffer.toString();
    }

    public static LinkedHashMap<String, String> getTempTableNameMap() {
        return sTempTableNameMap;
    }

    public static boolean isODBCSqlKeyWords(String string) {
        for (String string2 : sODBCSqlKeyWords) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSqlKeyWords(String string) {
        for (String string2 : sSqlKeyWords) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUseODBC() {
        return sUseODBC;
    }

    public static boolean isListValues() {
        return mListValues;
    }

    public static void setConnectionString(String string) {
        sConnectionStr = string.replaceAll("\r", "").replaceAll("\n", "");
        if (!(sConnectionStr = sConnectionStr.replace("QuotedId=No", "QuotedId=Yes")).contains("QuotedId")) {
            sConnectionStr = sConnectionStr + ";QuotedId=Yes";
        }
    }

    public static void setDefineVarPageSyntax(String string) {
        sDefineVarPageSyntax = string;
    }

    public static void setLimitRetrivedCasesPageSyntax(String string) {
        sLimitRetrivedCasesPageSyntax = string;
    }

    public static void setResultsPageSyntax(String string) {
        sResultsPageSyntax = string;
    }

    public static void setSelectDataPageSyntax(String string) {
        sSelectDataPageSyntax = string;
    }

    public static void setSortCasesPageSyntax(String string) {
        sSortCasesPageSyntax = string;
    }

    public static String getAggregateDataPageSyntax() {
        return sAggregateDataPageSyntax;
    }

    public static void setAggregateDataPageSyntax(String string) {
        sAggregateDataPageSyntax = string;
    }

    public static void setTempTableNameMap(HashMap<String, String> hashMap) {
        sTempTableNameMap = new LinkedHashMap();
        for (String string : hashMap.keySet()) {
            sTempTableNameMap.put(string, hashMap.get(string));
        }
    }

    public static void setUseODBC(boolean bl) {
        sUseODBC = bl;
    }

    public static void setNativeSmaplingEnabled(boolean bl) {
        sNativeSmaplingEnabled = bl;
    }

    public static LinkedHashMap<String, String> getDefineVarSyntaxMap() {
        return sDefineVarSyntaxMap;
    }

    public static void setDefineVarSyntaxMap(LinkedHashMap<String, String> linkedHashMap) {
        sDefineVarSyntaxMap = linkedHashMap;
    }

    public static String getDVPSyntaxTextField() {
        return sDVPSyntaxTextField;
    }

    public static void setDVPSyntaxTextField(String string) {
        sDVPSyntaxTextField = string;
    }

    private static String getNextName(String string) {
        String string2;
        if (mSuffixMap.containsKey(string)) {
            int n = mSuffixMap.get(string);
            string2 = string + n;
            mSuffixMap.remove(string);
            mSuffixMap.put(string, ++n);
        } else {
            string2 = string;
            mSuffixMap.put(string, 1);
        }
        return string2;
    }

    private static String getValidFieldName(String string) {
        int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
        String string2 = DBWizardUtil.getOpenQuoteChar();
        String string3 = DBWizardUtil.getCloseQuoteChar();
        if (string.contains(" ") || n > 1 && n < 8) {
            if (!string.contains(string2) && !string.contains(string3)) {
                return string2 + string + string3;
            }
            return string;
        }
        return string;
    }

    public static void generateSyntaxStrings() {
        DBWizardSyntaxUtil.generateSyntaxForSelectDataPage();
        DBWizardSyntaxUtil.generateSyntaxForSpecifyRelationshipsPage();
        DBWizardSyntaxUtil.generateSyntaxForLimitRetrievedCasesPage();
        if (DataServerProxy.getDataProxy().isRemoteConnection() && DBData.getDBData().isODBC()) {
            DBWizardSyntaxUtil.generateSyntaxForAggregateDataPage();
        }
        DBWizardSyntaxUtil.generateSyntaxForDefineVariablesPage();
        if (DataServerProxy.getDataProxy().isRemoteConnection()) {
            DBWizardSyntaxUtil.generateSyntaxForSortCasesPage();
        }
    }

    public static void generateSyntaxForAggregateDataPage() {
    }

    public static String getSQLFunctionName(String string) {
        ResourceBundle resourceBundle = DBWizardSyntaxUtil.getResBundle();
        if (string.equals(ResUtil.getString(resourceBundle, "IDS_DB_AD_FUNCTION_COUNT"))) {
            return "count";
        }
        if (string.equals(ResUtil.getString(resourceBundle, "IDS_DB_AD_FUNCTION_SUM"))) {
            return "sum";
        }
        if (string.equals(ResUtil.getString(resourceBundle, "IDS_DB_AD_FUNCTION_MEAN"))) {
            return "avg";
        }
        if (string.equals(ResUtil.getString(resourceBundle, "IDS_DB_AD_FUNCTION_MAX"))) {
            return "max";
        }
        if (string.equals(ResUtil.getString(resourceBundle, "IDS_DB_AD_FUNCTION_MIN"))) {
            return "min";
        }
        return string.toLowerCase();
    }

    public static String localizeFunctionName(String string) {
        ResourceBundle resourceBundle = DBWizardSyntaxUtil.getResBundle();
        if (string.equals("count")) {
            return ResUtil.getString(resourceBundle, "IDS_DB_AD_FUNCTION_COUNT");
        }
        if (string.equals("sum")) {
            return ResUtil.getString(resourceBundle, "IDS_DB_AD_FUNCTION_SUM");
        }
        if (string.equals("avg")) {
            return ResUtil.getString(resourceBundle, "IDS_DB_AD_FUNCTION_MEAN");
        }
        if (string.equals("max")) {
            return ResUtil.getString(resourceBundle, "IDS_DB_AD_FUNCTION_MAX");
        }
        if (string.equals("min")) {
            return ResUtil.getString(resourceBundle, "IDS_DB_AD_FUNCTION_MIN");
        }
        return string.toLowerCase();
    }

    /*
     * WARNING - void declaration
     */
    public static void generateSyntaxForDefineVariablesPage() {
        StringBuffer stringBuffer = new StringBuffer();
        LinkedHashMap<String, String> linkedHashMap = DBWizardSyntaxUtil.getTempTableNameMap();
        LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>();
        String string = "";
        String string2 = ResUtil.getString(DBWizardSyntaxUtil.getResBundle(), "IDS_DB_AD_N_BREAK");
        UIData uIData = UIData.getUIData();
        HashMap<String, ColumnsInfo.InternalColumnInfo> hashMap = DBData.getDBData().getSelectedColumnsMap();
        stringBuffer.append("SELECT");
        boolean bl = false;
        LinkedList<DefineVarDataOG> linkedList = DBData.getDBData().getDefineVarDataList();
        boolean bl2 = DBData.getDBData().isODBC();
        for (DefineVarDataOG serializable2 : linkedList) {
            int n;
            Object n2 = "";
            if (bl) {
                stringBuffer.append(",");
            } else {
                bl = true;
            }
            if (serializable2.isBreakVar()) {
                stringBuffer.append(" ");
                if (linkedHashMap.size() > 1) {
                    n2 = (String)n2 + linkedHashMap.get(serializable2.getTableName());
                    n2 = (String)n2 + ".";
                }
                ColumnsInfo.InternalColumnInfo internalColumnInfo = hashMap.get(serializable2.getQualifiedNameInfo());
                String string3 = internalColumnInfo.getStrColumnName();
                n2 = (String)n2 + DBWizardUtil.checkForApostopes(string3, true);
                stringBuffer.append((String)n2);
                if (!string3.equals(serializable2.getResultNameInfo()) && bl2) {
                    stringBuffer.append(" AS ");
                    stringBuffer.append(DBWizardUtil.checkForApostopes(serializable2.getResultNameInfo(), true));
                }
                linkedHashMap2.put(serializable2.getResultNameInfo(), (String)n2);
                continue;
            }
            if (serializable2.getResultNameInfo().equals(string2) && bl2) {
                string = serializable2.getQualifiedNameInfo() + " AS " + DBWizardUtil.checkForApostopes(serializable2.getResultNameInfo(), true);
                linkedHashMap2.put(serializable2.getResultNameInfo(), serializable2.getQualifiedNameInfo());
                continue;
            }
            String string4 = serializable2.getQualifiedNameInfo();
            String string5 = string4.substring(0, n = string4.indexOf("("));
            if (string5.equals("mean")) {
                string5 = "avg";
            }
            stringBuffer.append(" ");
            n2 = (String)n2 + string5 + "(";
            if (linkedHashMap.size() > 1) {
                n2 = (String)n2 + linkedHashMap.get(serializable2.getTableName());
                n2 = (String)n2 + ".";
            }
            n = string4.indexOf(DBWizardUtil.getTableColNameSeperator());
            String string6 = string4.substring(n + 1);
            String string7 = "";
            if (!bl2 && string6.equals("count(*)")) {
                n2 = string6;
            } else {
                string7 = string6.substring(1, string6.length() - 1);
                n2 = (String)n2 + DBWizardUtil.checkForApostopes(string7, true);
                n2 = (String)n2 + ")";
            }
            stringBuffer.append((String)n2);
            if (!string7.equals(serializable2.getResultNameInfo()) && bl2) {
                stringBuffer.append(" AS ");
                stringBuffer.append(DBWizardUtil.checkForApostopes(serializable2.getResultNameInfo(), true));
            }
            linkedHashMap2.put(serializable2.getResultNameInfo(), (String)n2);
        }
        if (!string.equals("")) {
            stringBuffer.append(" ").append(string);
        }
        DBWizardSyntaxUtil.setSelectSyntaxStr(stringBuffer.toString());
        DBWizardSyntaxUtil.setDVPSyntaxTextField("  /ASSUMEDSTRWIDTH=" + uIData.getObject("DVP_VARIABLE_WIDTH_TEXT").toString());
        StringBuffer stringBuffer2 = new StringBuffer();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DefineVarDataOG defineVarDataOG : linkedList) {
            if (!defineVarDataOG.getAutoRecodeInfo()) continue;
            arrayList.add(defineVarDataOG.getResultNameInfo());
        }
        int n = arrayList.size();
        if (n > 0) {
            void var13_27;
            void var13_25;
            void var13_23;
            void var13_21;
            stringBuffer2.append("\nAUTORECODE");
            boolean bl3 = false;
            while (var13_21 < n) {
                stringBuffer2.append(" ").append((String)arrayList.get((int)var13_21));
                ++var13_21;
            }
            stringBuffer2.append("\n /INTO");
            boolean bl4 = false;
            while (var13_23 < n) {
                stringBuffer2.append(" tm").append((int)(var13_23 + true));
                ++var13_23;
            }
            stringBuffer2.append(".");
            stringBuffer2.append("\nDELETE VARIABLES");
            boolean bl5 = false;
            while (var13_25 < n) {
                stringBuffer2.append(" ").append((String)arrayList.get((int)var13_25));
                ++var13_25;
            }
            stringBuffer2.append(".");
            stringBuffer2.append("\nRENAME VARIABLES");
            boolean bl6 = false;
            while (var13_27 < n) {
                stringBuffer2.append("(tm").append((int)(var13_27 + true)).append("=").append((String)arrayList.get((int)var13_27)).append(")");
                ++var13_27;
            }
            stringBuffer2.append(".");
        }
        if (uIData.getObject("DVP_MINIMIZE_STRING_WIDTHS") != null && ((Boolean)uIData.getObject("DVP_MINIMIZE_STRING_WIDTHS")).booleanValue()) {
            stringBuffer2.append("\nALTER TYPE ALL(A=AMIN).");
        }
        DBWizardSyntaxUtil.setDefineVarPageSyntax(stringBuffer2.toString());
        DBWizardSyntaxUtil.setDefineVarSyntaxMap(linkedHashMap2);
    }

    public static void generateSyntaxForSortCasesPage() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList = (ArrayList)UIData.getUIData().getObject("SDP_TARGET_TABLE");
        boolean bl = false;
        if (arrayList.size() > 0) {
            string = ResUtil.getString(DBWizardSyntaxUtil.getResBundle(), "IDS_SORT_CASES_COMBO_VALUE1");
            stringBuffer.append(" ORDER BY");
            LinkedHashMap<String, String> linkedHashMap = DBWizardSyntaxUtil.getDefineVarSyntaxMap();
            for (SortDataClass sortDataClass : arrayList) {
                if (bl) {
                    stringBuffer.append(",");
                } else {
                    bl = true;
                }
                String string2 = null;
                Object var8_8 = null;
                stringBuffer.append(" ").append(linkedHashMap.get(var8_8));
                if (string2.equals(string)) {
                    stringBuffer.append(" ASC");
                    continue;
                }
                stringBuffer.append(" DESC");
            }
        }
        DBWizardSyntaxUtil.setSortCasesPageSyntax(stringBuffer.toString());
        string = DBWizardSyntaxUtil.getSelectSyntaxStr() + DBWizardSyntaxUtil.getFromSyntaxStr() + DBWizardSyntaxUtil.getWhereSyntaxStr() + DBWizardSyntaxUtil.getGroupBySyntaxStr() + stringBuffer.toString();
        UIData.getUIData().putObject("RP_SQL_QUERY", string.trim());
    }

    public static void populateJoinInfo(ArrayList<SerializedJoinInfo> arrayList) {
        for (SerializedJoinInfo serializedJoinInfo : arrayList) {
            if (serializedJoinInfo.getJoinType() == JoinType.INNER_JOIN) {
                mInnerJoins.add(serializedJoinInfo);
                continue;
            }
            mOuterJoin = serializedJoinInfo;
        }
    }

    public static void generateSyntaxForSpecifyRelationshipsPage() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        CharSequence charSequence;
        StringBuffer stringBuffer = new StringBuffer();
        LinkedHashMap<String, String> linkedHashMap = DBWizardSyntaxUtil.getTempTableNameMap();
        DBData dBData = DBData.getDBData();
        mOuterJoin = new SerializedJoinInfo();
        mInnerJoins = new ArrayList();
        DBWizardSyntaxUtil.populateJoinInfo(dBData.getSerializableAutoJoinList());
        DBWizardSyntaxUtil.populateJoinInfo(dBData.getSerializableSysJoinList());
        DBWizardSyntaxUtil.populateJoinInfo(dBData.getSerializableUserJoinList());
        if (mOuterJoin.getJoinType() != null) {
            String string6 = mOuterJoin.getSrcColumnInfo().getStrColumnName();
            charSequence = mOuterJoin.getTargetColumnInfo().getStrColumnName();
            string5 = mOuterJoin.getSrcTableInfo().getName();
            string4 = mOuterJoin.getSrcTableInfo().getOwner();
            if (!string4.equals("")) {
                string5 = string4 + DBWizardUtil.getOwnerNameSeperator() + string5;
            }
            string3 = mOuterJoin.getTargetTableInfo().getName();
            string4 = mOuterJoin.getTargetTableInfo().getOwner();
            if (!string4.equals("")) {
                string3 = string4 + DBWizardUtil.getOwnerNameSeperator() + string3;
            }
            string2 = linkedHashMap.get(string5);
            string = linkedHashMap.get(string3);
            string5 = DBWizardUtil.quotedQualifiedTableName(string5);
            string3 = DBWizardUtil.quotedQualifiedTableName(string3);
            JoinType joinType = mOuterJoin.getJoinType();
            String object = DBWizardUtil.getOwnerNameSeperator();
            if (joinType.equals((Object)JoinType.LEFT_JOIN)) {
                stringBuffer.append(" FROM { oj");
                stringBuffer.append(" ").append(string5).append(" ").append(string2);
                stringBuffer.append(" LEFT OUTER JOIN ");
                stringBuffer.append(string3).append(" ").append(string);
                stringBuffer.append(" ON ");
                stringBuffer.append(string2).append(object).append(DBWizardUtil.checkForApostopes(string6, true));
                stringBuffer.append(" = ");
                stringBuffer.append(string).append(object).append(DBWizardUtil.checkForApostopes((String)charSequence, true));
                stringBuffer.append(" }");
            } else if (joinType.equals((Object)JoinType.RIGHT_JOIN)) {
                stringBuffer.append(" FROM { oj ");
                stringBuffer.append(string3).append(" ").append(string);
                stringBuffer.append(" LEFT OUTER JOIN ");
                stringBuffer.append(string5).append(" ").append(string2);
                stringBuffer.append(" ON ");
                stringBuffer.append(string).append(object).append(DBWizardUtil.checkForApostopes((String)charSequence, false));
                stringBuffer.append(" = ");
                stringBuffer.append(string2).append(object).append(DBWizardUtil.checkForApostopes(string6, false));
                stringBuffer.append(" }");
            }
            DBWizardSyntaxUtil.setFromSyntaxStr(stringBuffer.toString());
        }
        boolean bl = false;
        charSequence = new StringBuffer();
        if (mInnerJoins.size() > 0) {
            ((StringBuffer)charSequence).append(" WHERE");
            for (SerializedJoinInfo serializedJoinInfo : mInnerJoins) {
                String string6 = serializedJoinInfo.getSrcColumnInfo().getStrColumnName();
                String string7 = serializedJoinInfo.getTargetColumnInfo().getStrColumnName();
                string5 = serializedJoinInfo.getSrcTableInfo().getName();
                string4 = serializedJoinInfo.getSrcTableInfo().getOwner();
                if (!string4.equals("")) {
                    string5 = string4 + DBWizardUtil.getOwnerNameSeperator() + string5;
                }
                string3 = serializedJoinInfo.getTargetTableInfo().getName();
                string4 = serializedJoinInfo.getTargetTableInfo().getOwner();
                if (!string4.equals("")) {
                    string3 = string4 + DBWizardUtil.getOwnerNameSeperator() + string3;
                }
                string2 = linkedHashMap.get(string5);
                string = linkedHashMap.get(string3);
                if (bl) {
                    ((StringBuffer)charSequence).append(" and");
                } else {
                    bl = true;
                }
                ((StringBuffer)charSequence).append(" ").append(string2).append(DBWizardUtil.getOwnerNameSeperator()).append(DBWizardUtil.checkForApostopes(string6, true));
                ((StringBuffer)charSequence).append(" = ");
                ((StringBuffer)charSequence).append(string).append(DBWizardUtil.getOwnerNameSeperator()).append(DBWizardUtil.checkForApostopes(string7, true));
            }
        }
        DBWizardSyntaxUtil.setWhereSyntaxStr(((StringBuffer)charSequence).toString());
    }

    private static String generateSamplingSyntax(boolean bl, Integer n, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            try {
                Float f = Float.valueOf(n.floatValue());
                DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(ResUtil.getLocale());
                decimalFormat.applyPattern("0.000000");
                stringBuffer.append(decimalFormat.format(f.floatValue() / 100.0f));
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        } else {
            stringBuffer.append(string).append(" FROM ").append(string2);
        }
        return stringBuffer.toString();
    }

    public static void generateSyntaxForLimitRetrievedCasesPage() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String string = DBWizardSyntaxUtil.getWhereSyntaxStr();
        String string2 = "";
        UIData uIData = UIData.getUIData();
        boolean bl = (Boolean)uIData.getObject("LRCP_USE_RANDOM_SAMPLING_CHECK");
        boolean bl2 = (Boolean)uIData.getObject("LRCP_NATIVE_RANDOM_SAMPLING_RADIO");
        String string3 = uIData.getObject("LRCP_EXACTLY_TEXTFIELD1").toString();
        String string4 = uIData.getObject("LRCP_EXACTLY_TEXTFIELD2").toString();
        boolean bl3 = (Boolean)uIData.getObject("LRCP_APPROXIMATELY_RADIO");
        int n2 = (Integer)uIData.getObject("LRCP_APPROXIMATELY_SPINNER");
        ArrayList arrayList = (ArrayList)uIData.getObject("LRCP_CRITERIA_TABLE_MODEL");
        boolean bl4 = false;
        DBWizardSyntaxUtil.buildTable();
        if (bl) {
            if (bl4 && bl2) {
                string2 = " SAMPLE(" + n2 + ")";
                DBWizardSyntaxUtil.setNativeSmaplingEnabled(true);
                DBWizardSyntaxUtil.setFromSyntaxStr(DBWizardSyntaxUtil.getFromSyntaxStr() + string2);
            } else if (!bl2) {
                string2 = "  SAMPLE " + DBWizardSyntaxUtil.generateSamplingSyntax(bl3, n2, string3, string4) + ".";
            }
        }
        if ((n = arrayList.size()) > 0 && ((CriteriaTableData)arrayList.get(0)).getExpression1().length() > 0) {
            CriteriaTableData criteriaTableData;
            if (string.replace("WHERE", "").trim().length() > 0) {
                stringBuffer.append(string).append(" and (");
            } else {
                stringBuffer.append(" WHERE (");
            }
            for (int i = 0; i < n && (criteriaTableData = (CriteriaTableData)arrayList.get(i)).getExpression1().length() > 0; ++i) {
                for (int j = 1; j <= 4; ++j) {
                    int n3;
                    ColumnsInfo.InternalColumnInfo internalColumnInfo;
                    String string5;
                    String string6 = j == 1 ? criteriaTableData.getConnector() : (j == 2 ? criteriaTableData.getExpression1() : (j == 3 ? criteriaTableData.getRelation() : criteriaTableData.getExpression2()));
                    if (string6.length() <= 0) continue;
                    stringBuffer.append(" ");
                    String string7 = string6;
                    if (mExpressionList.contains(string7)) {
                        int n4 = DBData.getDBData().getFilteredTablesInfo().getTableCols().size();
                        String[] stringArray = string7.split(DBWizardUtil.getTableColNameSeperator());
                        if (stringArray.length > 0 && (string7 = DBWizardSyntaxUtil.getTempTableNameMap().get(stringArray[0])) != null) {
                            string7 = n4 > 1 ? string7 + "." + DBWizardUtil.checkForApostopes(stringArray[1], true) : DBWizardUtil.checkForApostopes(stringArray[1], true);
                        }
                    } else if (!(j != 2 && j != 4 || !mExpressionList.contains(string5 = j == 2 ? criteriaTableData.getExpression2() : criteriaTableData.getExpression1()) || (internalColumnInfo = mExpressionColMap.get(string5)) == null || (n3 = DBWizardUtil.getClassifiedDataType(internalColumnInfo.getIDataType())) != 1 && n3 != -1 || string7.startsWith("PROMPT(") || string7.startsWith("'"))) {
                        string7 = "'" + string7 + "'";
                    }
                    stringBuffer.append(string7);
                }
            }
            stringBuffer.append(")");
            string = stringBuffer.toString().replace("( ", "(");
        }
        DBWizardSyntaxUtil.setWhereSyntaxStr(string);
        if (bl4 && bl2) {
            DBWizardSyntaxUtil.setLimitRetrivedCasesPageSyntax("");
        } else if (!bl2) {
            DBWizardSyntaxUtil.setLimitRetrivedCasesPageSyntax(string2);
        }
    }

    public static void generateSyntaxForSelectDataPage() {
    }

    private static void getWhereClauseList() {
        TablesInfo tablesInfo = DBData.getDBData().getFilteredTablesInfo();
        mWhereClauseList = new ArrayList();
        for (int i = 0; i < tablesInfo.getTableCols().size(); ++i) {
            for (int j = i; j < tablesInfo.getTableCols().size(); ++j) {
                if (((TablesInfo.InternalTableInfo)tablesInfo.getTableCols().get(i)).equals(tablesInfo.getTableCols().get(j))) continue;
                DBWizardSyntaxUtil.retrieveWhereInfo((TablesInfo.InternalTableInfo)tablesInfo.getTableCols().get(i), (TablesInfo.InternalTableInfo)tablesInfo.getTableCols().get(j));
            }
        }
    }

    private static void retrieveWhereInfo(TablesInfo.InternalTableInfo internalTableInfo, TablesInfo.InternalTableInfo internalTableInfo2) {
        ColumnsInfo columnsInfo;
        ColumnsInfo columnsInfo2 = DBData.getDBData().getColumnsInfo().get(internalTableInfo.getName());
        if (columnsInfo2 == null) {
            columnsInfo2 = DBData.getDBData().getColumnsInfo().get(internalTableInfo.getQualifiedName());
        }
        if ((columnsInfo = DBData.getDBData().getColumnsInfo().get(internalTableInfo2.getName())) == null) {
            columnsInfo = DBData.getDBData().getColumnsInfo().get(internalTableInfo2.getQualifiedName());
        }
        String string = internalTableInfo.getName();
        String string2 = internalTableInfo2.getName();
        for (int i = 0; i < columnsInfo2.getColInfos().size(); ++i) {
            for (int j = 0; j < columnsInfo.getColInfos().size(); ++j) {
                ColumnsInfo.InternalColumnInfo internalColumnInfo = (ColumnsInfo.InternalColumnInfo)columnsInfo2.getColInfos().get(i);
                ColumnsInfo.InternalColumnInfo internalColumnInfo2 = (ColumnsInfo.InternalColumnInfo)columnsInfo.getColInfos().get(j);
                if (!internalColumnInfo.getStrColumnName().equals(internalColumnInfo2.getStrColumnName()) || internalColumnInfo.getIDataType() != internalColumnInfo2.getIDataType()) continue;
                String string3 = DBWizardSyntaxUtil.validateNameForSyntax(internalColumnInfo.getStrColumnName());
                String string4 = DBWizardSyntaxUtil.validateNameForSyntax(internalColumnInfo2.getStrColumnName());
                if (internalColumnInfo.getStrOwner().length() > 0) {
                    string = internalColumnInfo.getStrOwner() + DBWizardUtil.getOwnerNameSeperator() + internalTableInfo;
                }
                if (internalColumnInfo2.getStrOwner().length() > 0) {
                    string2 = internalColumnInfo2.getStrOwner() + DBWizardUtil.getOwnerNameSeperator() + internalTableInfo2;
                }
                if (DBWizardSyntaxUtil.getTempTableNameMap().get(string) != null) {
                    string = DBWizardSyntaxUtil.getTempTableNameMap().get(string);
                }
                if (DBWizardSyntaxUtil.getTempTableNameMap().get(string2) != null) {
                    string2 = DBWizardSyntaxUtil.getTempTableNameMap().get(string2);
                }
                string = DBWizardSyntaxUtil.validateNameForSyntax(string);
                string2 = DBWizardSyntaxUtil.validateNameForSyntax(string2);
                String string5 = string + DBWizardUtil.getOwnerNameSeperator() + string3 + "=" + string2 + DBWizardUtil.getOwnerNameSeperator() + string4;
                mWhereClauseList.add(string5);
            }
        }
    }

    private static String validateNameForSyntax(String string) {
        int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
        String string2 = DBWizardUtil.getOpenQuoteChar();
        String string3 = DBWizardUtil.getCloseQuoteChar();
        String string4 = string;
        if (n > 1 && n < 8) {
            string4 = string2 + string + string3;
        }
        return string4;
    }

    public static LinkedList<String> setPromptValues(SpssFrame spssFrame) {
        LinkedList<String> linkedList = new LinkedList<String>();
        TreeMap treeMap = DBWizardDlgType.getDBWizardDlgType().equals((Object)DBWizardDlgType.DBWizardDialogTypeEnum.eRunQueryDlg) || DBWizardDlgType.getDBWizardDlgType().equals((Object)DBWizardDlgType.DBWizardDialogTypeEnum.eEditQueryDlg) || DBWizardDlgType.getDBWizardDlgType().equals((Object)DBWizardDlgType.DBWizardDialogTypeEnum.eEditQueryFromMFCDlg) ? (TreeMap)UIData.getUIData().getObject("LRCP_PROMPT_DATA_VALUES_MAP") : null;
        if (treeMap != null) {
            block7: for (String string : treeMap.keySet()) {
                PromptValuesData promptValuesData = (PromptValuesData)treeMap.get(string);
                mListValues = promptValuesData.getValuesList().size() > 0;
                SetPromptValueDialog setPromptValueDialog = new SetPromptValueDialog(spssFrame);
                if (setPromptValueDialog.getSelectedValue() == null) {
                    return null;
                }
                if (((PromptValuesData)treeMap.get(string)).getDataType().equals((Object)PromptValuesData.PromptValuesDataType.eString)) {
                    linkedList.add("'" + setPromptValueDialog.getSelectedValue() + "'");
                    continue;
                }
                if (((PromptValuesData)treeMap.get(string)).getDataType().equals((Object)PromptValuesData.PromptValuesDataType.eNumber)) {
                    linkedList.add(setPromptValueDialog.getSelectedValue());
                    continue;
                }
                if (!((PromptValuesData)treeMap.get(string)).getDataType().equals((Object)PromptValuesData.PromptValuesDataType.eDate) || !DBWizardSyntaxUtil.isValidDateString(setPromptValueDialog.getSelectedValue())) continue;
                String string2 = setPromptValueDialog.getSelectedValue();
                if ((string2.startsWith("{d '") || string2.startsWith("{t '") || string2.startsWith("{ts '")) && string2.endsWith("'}")) {
                    linkedList.add(setPromptValueDialog.getSelectedValue());
                    continue;
                }
                for (int i = 0; i < sValidODBCDateFormats.length; ++i) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sValidODBCDateFormats[i]);
                    try {
                        simpleDateFormat.parse(string2);
                        switch (i) {
                            case 0: {
                                linkedList.add("{ts '" + setPromptValueDialog.getSelectedValue() + "'}");
                                break;
                            }
                            case 1: {
                                linkedList.add("{d '" + setPromptValueDialog.getSelectedValue() + "'}");
                                break;
                            }
                            case 2: {
                                linkedList.add("{t '" + setPromptValueDialog.getSelectedValue() + "'}");
                                break;
                            }
                            default: {
                                linkedList.add("{d '" + setPromptValueDialog.getSelectedValue() + "'}");
                                break;
                            }
                        }
                        continue block7;
                    }
                    catch (ParseException parseException) {
                        continue;
                    }
                }
            }
        }
        return linkedList;
    }

    public static boolean isValidDateString(String string) {
        boolean bl = false;
        String string2 = string;
        if ((string.startsWith("{d '") || string.startsWith("{t '") || string.startsWith("{ts '")) && string.endsWith("'}")) {
            string2 = string.substring(string.indexOf("'") + 1, string.lastIndexOf("'"));
        }
        for (int i = 0; i < sValidODBCDateFormats.length; ++i) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(sValidODBCDateFormats[i]);
            bl = false;
            try {
                simpleDateFormat.parse(string2);
                bl = true;
                break;
            }
            catch (ParseException parseException) {
                bl = false;
                continue;
            }
        }
        return bl;
    }

    private static void buildTable() {
        TablesInfo tablesInfo = DBData.getDBData().getFilteredTablesInfo();
        HashMap<String, ColumnsInfo> hashMap = DBData.getDBData().getColumnsInfo();
        mExpressionColMap = new HashMap();
        mExpressionList = new ArrayList();
        for (TablesInfo.InternalTableInfo internalTableInfo : tablesInfo.getTableCols()) {
            String string = internalTableInfo.getOwner();
            ColumnsInfo columnsInfo = hashMap.get(internalTableInfo.getName());
            if (columnsInfo == null) {
                columnsInfo = hashMap.get(internalTableInfo.getQualifiedName());
            }
            if (columnsInfo == null) continue;
            for (ColumnsInfo.InternalColumnInfo internalColumnInfo : columnsInfo.getColInfos()) {
                String string2 = string.length() > 0 ? string + DBWizardUtil.getOwnerNameSeperator() + internalTableInfo.getName() + DBWizardUtil.getTableColNameSeperator() + internalColumnInfo.getStrColumnName() : internalTableInfo.getName() + DBWizardUtil.getTableColNameSeperator() + internalColumnInfo.getStrColumnName();
                mExpressionList.add(string2);
                mExpressionColMap.put(string2, internalColumnInfo);
            }
        }
    }

    private DBWizardSyntaxUtil() {
        this.initVars();
    }

    private void initVars() {
        sAllSyntax = SyntaxUtil.startSyntax();
        sTempTableNameMap = new LinkedHashMap();
        sNativeSmaplingEnabled = false;
    }

    private static ResourceBundle getResBundle() {
        return ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
    }

    static {
        sDefineVarSyntaxMap = new LinkedHashMap();
        sODBCSqlKeyWords = new String[]{"ABSOLUTE ACTION", "ADA", "ADD", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIT", "BIT_LENGTH", "BOTH", "BY", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR", "CHAR_LENGTH", "CHARACTER", "CHARACTER_LENGTH", "CHECK", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CONVERT", "CORRESPONDING", "COUNT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DESCRIPTOR", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOMAIN", "DOUBLE", "DROP", "ELSE", "END", "ENDEXEC", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FORTRAN", "FOUND", "FROM", "FULL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HAVING", "HOUR", "IDENTITY", "IMMEDIATE", "IN", "INCLUDE", "INDEX", "INDICATOR", "INITIALLY", "INNER", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LANGUAGE", "LAST", "LEADING", "LEFT", "LEVEL", "LIKE", "LOCAL", "LOWER", "MATCH", "MAX", "MIN", "MINUTE", "MODULE", "MONTH", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NONE", "NOT", "NULL", "NULLIF", "NUMERIC", "OCTET_LENGTH", "OF", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUTER", "OUTPUT", "OVERLAPS", "PAD", "PARTIAL", "PASCAL", "PLAN", "PLI", "POSITION", "PRECISION", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RESTRICT", "REVOKE", "RIGHT", "ROLLBACK", "ROWSSCHEMA", "SCROLL", "SECOND", "SECTION", "SELECT", "SESSION", "SESSION_USER", "SET", "SIZE", "SMALLINT", "SOME", "SPACE", "SQL", "SQLCA", "SQLCODE", "SQLERROR", "SQLSTATE", "SQLWARNING", "SUBSTRING", "SUM", "SYSTEM_USER", "TABLE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRIM", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "UPPER", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WITH", "WORK", "WRITE", "YEAR", "ZONE"};
        sSqlKeyWords = new String[]{"ALPHANUMERIC", "AUTOINCREMENT", "BINARY", "BYTE", "COUNTER", "CURRENCY", "DATABASE", "DATABASENAME", "DATETIME", "DISALLOW", "DISTINCTROW", "DOUBLEFLOAT", "FLOAT4", "FLOAT8", "GENERAL", "IEEEDOUBLE", "IEEESINGLE", "IGNORE", "INT", "INTEGER1", "INTEGER2", "INTEGER4", "LEVEL", "LOGICAL", "LOGICAL1", "LONG", "LONGBINARY", "LONGCHAR", "LONGTEXT", "MEMO", "MOD", "MONEY", "NOTE", "NUMBER", "OLEOBJECT", "OPTION", "OWNERACCESS", "PARAMETERS", "PERCENT", "PIVOT", "SHORT", "SINGLE", "SINGLEFLOAT", "SMALLINT", "STDEV", "STDEVP", "STRING", "TABLEID", "TEXT", "TOP", "TRANSFORM", "UNSIGNEDBYTE", "VALUES", "VAR", "VARBINARY", "VARP", "YESNO"};
        sValidODBCDateFormats = new String[]{"yyyy-mm-dd hh:mm:ss", "yyyy-mm-dd", "hh:mm:ss"};
    }
}

