/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.utilities;

import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.SPSSColumn;
import java.net.URL;
import javax.swing.ImageIcon;

public class DBListEntry
implements Comparable {
    private String mText;
    private String mDesc;
    private String mTypeName;
    private URL mImagePath;
    private ImageIcon mImageIcon;
    private ODBCColumn column;
    private boolean useUserName = false;

    public DBListEntry(String string, String string2, String string3, URL uRL) {
        this.mText = string;
        this.mDesc = string2;
        this.mTypeName = string3;
        this.mImagePath = uRL;
    }

    public DBListEntry(ODBCColumn oDBCColumn, URL uRL) {
        this.column = oDBCColumn;
        this.mImagePath = uRL;
    }

    public ODBCColumn getColumn() {
        return this.column;
    }

    public String getText() {
        if (this.column == null) {
            if (this.mText != null) {
                return this.mText;
            }
            return "";
        }
        if (this.column instanceof SPSSColumn && this.useUserName) {
            return ((SPSSColumn)this.column).getUserName();
        }
        return this.column.getQualifiedColumnName();
    }

    public String getTypeName() {
        if (this.column != null) {
            return this.column.getTypeName();
        }
        if (this.mTypeName != null) {
            return this.mTypeName;
        }
        return "";
    }

    public String getDesc() {
        return this.mDesc;
    }

    public String getImagePath() {
        return this.mImagePath.toString();
    }

    public ImageIcon getImage() {
        if (this.mImageIcon == null) {
            this.mImageIcon = new ImageIcon(this.mImagePath);
        }
        return this.mImageIcon;
    }

    public String toString() {
        return this.getText();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof DBListEntry) {
            DBListEntry dBListEntry = (DBListEntry)object;
            return dBListEntry.getText().equals(this.mText) && dBListEntry.getImagePath().equals(this.mImagePath.toString());
        }
        return false;
    }

    public int compareTo(Object object) {
        return this.getText().compareTo(((DBListEntry)object).getText());
    }

    public boolean isUseUserName() {
        return this.useUserName;
    }

    public void setUseUserName(boolean bl) {
        this.useUserName = bl;
    }
}

