/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships;

import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.ColumnsInfo;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.ODBCWizardCapabilities;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.TablesInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.AbstractDBWizardCommonPage;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBData;
import com.spss.java_client.ui.dialogs.base.file.openquery.NewQueryDlg;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.JConnector;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.JoinData;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.JoinInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.JoinOrigin;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.JoinType;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.MDIDesktopPane;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.RelationShipData;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.RelationShipTable;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.RelationShipTableDropListener;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.RelationshipDeskTopPane;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.RelationshipPageUtils;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.RelationshipTableModel;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.SRPageFocusPolicy;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.SerializedJoinInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBWizardUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBC;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCTable;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.RelationshipPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.SPSSUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.TableJoin;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;

public class SpecifyRelationshipsPage
extends AbstractDBWizardCommonPage
implements ItemListener,
ActionListener,
KeyListener {
    public static JButton sJoinButton;
    public static JoinType sJoinType;
    ArrayList<Component> mFocusComplist;
    private static final String AUTO_JOIN_TABLES_CHACK_BOX = "IDS_AUTO_JOIN_TABLE_CHECK_BOX";
    private static MDIDesktopPane sDesktop;
    private static JoinInfo mExistingJoinInfo;
    private RelationshipDeskTopPane mDesktopSample;
    private JCheckBox mAutoJoinCheckBox;
    private JScrollPane mScroll;
    private boolean mDisplayAutoJoin;
    private JComboBox mJoinCombo;
    private boolean mChanged;
    private boolean mInnerOuterAllowed;
    private DragPane mDragPane = (DragPane)this.mWizardDialog.getGlassPane();
    private ArrayList<RelationShipTableDropListener> mAllDropListeners;
    private boolean mIsModified = false;

    public SpecifyRelationshipsPage(BaseWizardDialog baseWizardDialog) {
        super("SpecifyRelationshipsPage", baseWizardDialog, true);
        this.setTabTraversalOrder();
    }

    public static LinkedList<RelationShipTable> getAllSelectedColumns() {
        LinkedList<RelationShipTable> linkedList = new LinkedList<RelationShipTable>();
        JInternalFrame[] jInternalFrameArray = sDesktop.getAllFrames();
        if (jInternalFrameArray != null) {
            for (int i = 0; i < jInternalFrameArray.length; ++i) {
                RelationShipTable relationShipTable = RelationshipPageUtils.getRelationTable(jInternalFrameArray[i]);
                if (relationShipTable.getSelectedRow() == -1) continue;
                linkedList.add(relationShipTable);
            }
        }
        return linkedList;
    }

    @Override
    public String getNextPage() {
        boolean bl = DataServerProxy.getDataProxy().isRemoteConnection();
        if (bl) {
            return "ComputeNewFieldsPage";
        }
        return "LimitRetrievedCasesPage";
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_tablejoins";
    }

    @Override
    public boolean validate() {
        if (MDIDesktopPane.getAllConnectors().size() == 0) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_NO_JOINS_SPECIFIED"), this.mWizardDialog.getResString("IDS_ERR_DLG_TITLE"));
            return false;
        }
        this.saveJoinInfo();
        if (this.mIsModified) {
            SPSSUtil.clearLimitPage();
        }
        return super.validate();
    }

    @Override
    public boolean validateOnBack() {
        this.saveJoinInfo();
        return super.validateOnBack();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().equals(this.mAutoJoinCheckBox)) {
            this.mDisplayAutoJoin = this.mAutoJoinCheckBox.isSelected();
            MDIDesktopPane mDIDesktopPane = this.mDesktopSample.getDesktopPaneWithApplicableJoins(this.mDisplayAutoJoin, false);
            JViewport jViewport = this.mScroll.getViewport();
            if (jViewport.getComponentCount() > 0) {
                jViewport.removeAll();
            }
            jViewport.add(mDIDesktopPane);
        } else if (itemEvent.getSource().equals(this.mJoinCombo)) {
            this.setJoinType();
            this.updateConnectorType();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 127) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mWizardDialog), "Delete key pressed...", "");
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 127) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mWizardDialog), "Delete key pressed...", "");
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = true;
        if (SpecifyRelationshipsPage.getAllSelectedColumns().size() == 2) {
            LinkedList<RelationShipTable> linkedList = SpecifyRelationshipsPage.getAllSelectedColumns();
            RelationShipTable relationShipTable = linkedList.getLast();
            RelationShipTable relationShipTable2 = linkedList.getFirst();
            JoinInfo joinInfo = new JoinInfo();
            joinInfo.setSrcFrame(RelationshipPageUtils.getRelationFrame(relationShipTable, sDesktop));
            joinInfo.setTargetFrame(RelationshipPageUtils.getRelationFrame(relationShipTable2, sDesktop));
            joinInfo.setJoinType(sJoinType);
            int n = relationShipTable.getSelectedRow();
            int n2 = relationShipTable2.getSelectedRow();
            joinInfo.setSrcField(((RelationshipTableModel)relationShipTable.getModel()).getDataAt(n));
            joinInfo.setTargetField(((RelationshipTableModel)relationShipTable2.getModel()).getDataAt(n2));
            String string = relationShipTable.getModel().getValueAt(n, 2).toString();
            String string2 = relationShipTable2.getModel().getValueAt(n2, 2).toString();
            String string3 = relationShipTable.getModel().getValueAt(n, 1).toString();
            String string4 = relationShipTable2.getModel().getValueAt(n2, 1).toString();
            if (!string.equals(string2) && !string3.equals(string4)) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_FIELDS_DO_NOT_MATCH_MSG"), this.mWizardDialog.getResString("IDS_ERR_DLG_TITLE"));
                RelationshipPageUtils.getRelationTable(joinInfo.getTargetFrame()).clearSelection();
            } else {
                JConnector jConnector = new JConnector(joinInfo.getSrcFrame(), joinInfo.getTargetFrame(), joinInfo.getSrcField(), joinInfo.getTargetField(), sJoinType, sDesktop);
                ArrayList<JoinInfo> arrayList = JoinData.getJoinData().getUserJoinList();
                ArrayList<JoinInfo> arrayList2 = JoinData.getJoinData().getAutoJoinList();
                boolean bl2 = false;
                JConnector jConnector2 = null;
                if (arrayList2 != null && arrayList2.size() > 0 && (bl2 = this.joinAlreadyExists(joinInfo, arrayList2))) {
                    jConnector2 = this.mDesktopSample.getConnector(mExistingJoinInfo);
                    JoinData.getJoinData().getAutoJoinList().remove(mExistingJoinInfo);
                }
                if (!bl2 && arrayList != null && arrayList.size() > 0 && (bl2 = this.joinAlreadyExists(joinInfo, arrayList))) {
                    jConnector2 = this.mDesktopSample.getConnector(mExistingJoinInfo);
                    JoinData.getJoinData().getUserJoinList().remove(mExistingJoinInfo);
                }
                if (!this.mInnerOuterAllowed && RelationshipDeskTopPane.hasOuterJoins(jConnector)) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_INNER_AND_OUTER_NOT_ALLOWED"), this.mWizardDialog.getResString("IDS_ERR_DLG_TITLE"));
                    bl = false;
                }
                if (bl2 && bl) {
                    if (jConnector2 != null) {
                        this.mDesktopSample.removeConnectorFromList(jConnector2);
                        sDesktop.remove(jConnector2);
                        this.mDesktopSample.repaint();
                    }
                    bl2 = false;
                }
                if (!bl2 && bl) {
                    if (this.checkForConversion(jConnector)) {
                        JoinData.getJoinData().getUserJoinList().add(joinInfo);
                        jConnector.setSelected(true);
                        sDesktop.add(jConnector);
                    } else {
                        RelationshipPageUtils.getRelationTable(joinInfo.getSrcFrame()).clearSelection();
                        RelationshipPageUtils.getRelationTable(joinInfo.getTargetFrame()).clearSelection();
                        this.mJoinCombo.requestFocus();
                    }
                }
            }
        } else {
            this.updateConnectorType();
        }
    }

    protected void updateConnectorType() {
        Serializable serializable;
        Serializable serializable2;
        ArrayList<JConnector> arrayList = MDIDesktopPane.getActiveConnectors();
        boolean bl = true;
        if (this.mJoinCombo.getSelectedIndex() == 1 || this.mJoinCombo.getSelectedIndex() == 2) {
            if (sDesktop.getAllFrames().length > 2) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_HAS_MORE_THAN_TWO_TABLES"), this.mWizardDialog.getResString("IDS_ERR_DLG_TITLE"));
                bl = false;
            } else if (arrayList != null && arrayList.size() > 1) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_ONLY_ONE_OUTER_JOIN_ALLOWED"), this.mWizardDialog.getResString("IDS_ERR_DLG_TITLE"));
                this.mJoinCombo.requestFocus();
                bl = false;
            } else if (!this.mInnerOuterAllowed && MDIDesktopPane.getAllConnectors().size() > 1) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_INNER_AND_OUTER_NOT_ALLOWED"), this.mWizardDialog.getResString("IDS_ERR_DLG_TITLE"));
                bl = false;
            }
        }
        if (bl && arrayList != null && arrayList.size() == 1) {
            serializable2 = JoinData.getJoinData().getUserJoinList();
            if (serializable2 != null && ((ArrayList)serializable2).size() > 0) {
                JoinData.getJoinData().setUserJoinList(this.changeJoinType((ArrayList<JoinInfo>)serializable2));
            }
            serializable = JoinData.getJoinData().getAutoJoinList();
            if (!this.mChanged && serializable != null && ((ArrayList)serializable).size() > 0) {
                JoinData.getJoinData().setAutoJoinList(this.changeJoinType((ArrayList<JoinInfo>)serializable));
            }
        }
        if (((Container)(serializable2 = this.mScroll.getViewport())).getComponentCount() > 0) {
            ((Container)serializable2).removeAll();
        }
        serializable = this.mDesktopSample.getDesktopPaneWithApplicableJoins(this.mDisplayAutoJoin, true);
        ((Container)serializable2).add((Component)serializable);
    }

    @Override
    protected void aboutToShowPanel() {
        if (!this.useExistingJoinInfo()) {
            this.addDropListeners();
            this.mAutoJoinCheckBox.addItemListener(this);
            RelationshipPageUtils.getAllDropListeners().clear();
            RelationshipPageUtils.removeAllDropListeners(this.mDragPane);
            this.getNewDesktop();
            sJoinType = JoinType.INNER_JOIN;
        }
        if (MDIDesktopPane.getAllConnectors().size() > 0) {
            this.mWizardDialog.enableFinish(MDIDesktopPane.getAllConnectors().size() > 0);
        }
        this.checkOuterCaps();
        sJoinButton.setEnabled(SpecifyRelationshipsPage.getAllSelectedColumns().size() == 2);
        if (sJoinType == JoinType.INNER_JOIN) {
            this.mJoinCombo.setSelectedIndex(0);
        }
        this.setTabTraversalOrder();
        sDesktop.setFocusTraversalPolicy(new SRPageFocusPolicy(this.mFocusComplist));
        this.mDesktopSample.addKeySupport();
        Component component = this.mWizardDialog.getFocusTraversalPolicy().getFirstComponent((Container)((Object)this.mWizardDialog));
        component.requestFocus();
        this.addMouseListener(this.mWizardDialog.getBackButton());
        this.addMouseListener(this.mWizardDialog.getNextButton());
        this.addMouseListener(this.mWizardDialog.getFinishButton());
        this.addMouseListener(this.mWizardDialog.getCancelButton());
        this.addMouseListener(this.mWizardDialog.getHelpButton());
    }

    private boolean useExistingJoinInfo() {
        RelationshipPageInfo relationshipPageInfo = RelationshipPageInfo.getRelationshipPageInfo();
        List<TableJoin> list = relationshipPageInfo.getTableJoins();
        if (list.size() > 0) {
            MDIDesktopPane mDIDesktopPane = MDIDesktopPane.getMDIDesktopPane();
            for (int i = 0; i < mDIDesktopPane.getComponentCount(); ++i) {
                if (!(mDIDesktopPane.getComponent(i) instanceof JConnector)) continue;
                mDIDesktopPane.remove(mDIDesktopPane.getComponent(i));
            }
            JoinData joinData = JoinData.getJoinData();
            ArrayList<JoinInfo> arrayList = joinData.getUserJoinList();
            ArrayList<JoinInfo> arrayList2 = joinData.getAutoJoinList();
            ArrayList<JoinInfo> arrayList3 = joinData.getSysJoinList();
            arrayList.clear();
            arrayList2.clear();
            arrayList3.clear();
            for (TableJoin tableJoin : list) {
                JoinInfo joinInfo;
                JInternalFrame jInternalFrame;
                JInternalFrame jInternalFrame2;
                if (tableJoin.getJoinOrigin() == JoinOrigin.USER_JOIN) {
                    jInternalFrame2 = this.createInternalFrame(tableJoin.getLeft().getTable());
                    jInternalFrame = this.createInternalFrame(tableJoin.getRight().getTable());
                    joinInfo = new JoinInfo();
                    joinInfo.setSrcField(tableJoin.getLeft());
                    joinInfo.setTargetField(tableJoin.getRight());
                    joinInfo.setJoinType(tableJoin.getJoinType());
                    joinInfo.setSrcFrame(jInternalFrame2);
                    joinInfo.setTargetFrame(jInternalFrame);
                    arrayList.add(joinInfo);
                    continue;
                }
                if (tableJoin.getJoinOrigin() == JoinOrigin.AUTO_JOIN) {
                    jInternalFrame2 = this.createInternalFrame(tableJoin.getLeft().getTable());
                    jInternalFrame = this.createInternalFrame(tableJoin.getRight().getTable());
                    joinInfo = new JoinInfo();
                    joinInfo.setSrcField(tableJoin.getLeft());
                    joinInfo.setTargetField(tableJoin.getRight());
                    joinInfo.setJoinType(tableJoin.getJoinType());
                    joinInfo.setSrcFrame(jInternalFrame2);
                    joinInfo.setTargetFrame(jInternalFrame);
                    arrayList2.add(joinInfo);
                    continue;
                }
                jInternalFrame2 = this.createInternalFrame(tableJoin.getLeft().getTable());
                jInternalFrame = this.createInternalFrame(tableJoin.getRight().getTable());
                joinInfo = new JoinInfo();
                joinInfo.setSrcField(tableJoin.getLeft());
                joinInfo.setTargetField(tableJoin.getRight());
                joinInfo.setJoinType(tableJoin.getJoinType());
                joinInfo.setSrcFrame(jInternalFrame2);
                joinInfo.setTargetFrame(jInternalFrame);
                arrayList3.add(joinInfo);
            }
            this.createFramesAndJoins();
            return true;
        }
        return false;
    }

    protected void addMouseListener(final JButton jButton) {
        jButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1) {
                    ActionEvent actionEvent = new ActionEvent(jButton, 0, "event");
                    jButton.getAction().actionPerformed(actionEvent);
                }
            }
        });
    }

    protected void removeMouseListener(JButton jButton) {
        MouseListener[] mouseListenerArray = jButton.getMouseListeners();
        MouseListener mouseListener = mouseListenerArray[mouseListenerArray.length - 1];
        jButton.removeMouseListener(mouseListener);
    }

    @Override
    protected void aboutToHidePanel() {
        this.SerializeJoinInfo();
        DBWizardUtil.setDBWizardPreviousPage(DBWizardUtil.DBWizardPreviousPage.eSpecifyRelationship);
        ArrayList<RelationShipTableDropListener> arrayList = RelationshipPageUtils.getAllDropListeners();
        this.mAllDropListeners.clear();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.mAllDropListeners.add(arrayList.get(i));
        }
        RelationshipPageUtils.removeAllDropListeners(this.mDragPane);
        this.mDesktopSample.removeKeySupport();
        this.removeMouseListener(this.mWizardDialog.getBackButton());
        this.removeMouseListener(this.mWizardDialog.getNextButton());
        this.removeMouseListener(this.mWizardDialog.getFinishButton());
        this.removeMouseListener(this.mWizardDialog.getCancelButton());
        this.removeMouseListener(this.mWizardDialog.getHelpButton());
    }

    @Override
    protected void setTabTraversalOrder() {
        this.mFocusComplist = new ArrayList();
        this.mFocusComplist.add(this.mJoinCombo);
        this.mFocusComplist.add(sJoinButton);
        this.mFocusComplist.add(this.mAutoJoinCheckBox);
        Vector<Object> vector = new Vector<Object>();
        Vector<Object> vector2 = ((NewQueryDlg)this.mWizardDialog).getTabTraversal(vector);
        Vector<Component> vector3 = new Vector<Component>();
        for (Object object : vector2) {
            vector3.add((Component)object);
        }
        this.mFocusComplist.addAll(vector3);
        this.mWizardDialog.setFocusTraversalPolicy(new SRPageFocusPolicy(this.mFocusComplist));
    }

    @Override
    protected JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString("IDS_SPECIFY_RELATION_LABEL"));
        jLabel.setFont(jLabel.getFont().deriveFont(1, 18.0f));
        JTextArea jTextArea = new JTextArea(this.mWizardDialog.getResString("IDS_SPECIFY_RELATION_LABEL2"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    @Override
    protected JPanel setupPageBody() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mScroll, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.setupAutoJoinPanel(), gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    @Override
    protected void initVars() {
        this.mDesktopSample = new RelationshipDeskTopPane();
        this.mDesktopSample.addKeyListener(this);
        this.mScroll = new JScrollPane();
        MDIDesktopPane.resetMDIDesktopPane();
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, AUTO_JOIN_TABLES_CHACK_BOX);
        this.mAutoJoinCheckBox = new JCheckBox(toggleButtonAction);
        this.mJoinCombo = new JComboBox<String>(this.mWizardDialog.getResStringArray("IDS_AUTO_JOIN_COMBOBOX_ITEMS"));
        this.mJoinCombo.setRenderer(new DBComboBoxRenderer());
        this.mJoinCombo.addItemListener(this);
        sJoinButton = new JButton();
        sJoinButton.setAction(new ToggleButtonAction(this.mWizardDialog, "IDS_JOIN_BUTTON"));
        sJoinButton.addActionListener(this);
        sJoinButton.addItemListener(this);
        sJoinButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 1) {
                    ActionEvent actionEvent = new ActionEvent(sJoinButton, 0, "event");
                    SpecifyRelationshipsPage.this.actionPerformed(actionEvent);
                }
            }
        });
        this.setDefaults();
        this.mAllDropListeners = new ArrayList();
    }

    private void createFramesAndJoins() {
        MDIDesktopPane mDIDesktopPane;
        JViewport jViewport = this.mScroll.getViewport();
        if (jViewport.getComponentCount() > 0) {
            jViewport.removeAll();
        }
        sDesktop = mDIDesktopPane = this.mDesktopSample.getDesktopPane();
        this.mDesktopSample.initDesktopPane(this.mWizardDialog, this.mDisplayAutoJoin, true, this.mDragPane);
        jViewport.add(mDIDesktopPane);
        ArrayList<JoinInfo> arrayList = JoinData.getJoinData().getAutoJoinList();
        ArrayList<JoinInfo> arrayList2 = JoinData.getJoinData().getSysJoinList();
        ArrayList<JoinInfo> arrayList3 = JoinData.getJoinData().getUserJoinList();
        if (arrayList != null && arrayList.size() > 0) {
            for (JoinInfo object2 : arrayList) {
                this.addConnector(object2);
            }
        }
        if (arrayList2 != null && arrayList2.size() > 0) {
            for (JoinInfo joinInfo : arrayList2) {
                this.addConnector(joinInfo);
            }
        }
        if (arrayList3 != null && arrayList3.size() > 0) {
            for (JoinInfo joinInfo : arrayList3) {
                this.addConnector(joinInfo);
            }
        }
        JInternalFrame[] jInternalFrameArray = sDesktop.getAllFrames();
        RelationShipTable relationShipTable = RelationshipPageUtils.getRelationTable((JInternalFrame)jInternalFrameArray[0]);
        relationShipTable.setRowSelectionInterval(0, 0);
        relationShipTable.setColumnSelectionInterval(0, 0);
    }

    private void addConnector(JoinInfo joinInfo) {
        JInternalFrame jInternalFrame = this.getFrame(joinInfo.getSrcFrame());
        JInternalFrame jInternalFrame2 = this.getFrame(joinInfo.getTargetFrame());
        JConnector jConnector = new JConnector(jInternalFrame, jInternalFrame2, joinInfo.getSrcField(), joinInfo.getTargetField(), joinInfo.getJoinType(), sDesktop);
        sDesktop.add(jConnector);
    }

    private void addDropListeners() {
        RelationshipPageUtils.getAllDropListeners().clear();
        for (int i = 0; i < this.mAllDropListeners.size(); ++i) {
            RelationshipPageUtils.addDropListeners(this.mAllDropListeners.get(i));
            this.mDragPane.addDropListener((IDropListener)this.mAllDropListeners.get(i));
        }
    }

    private JInternalFrame getFrame(JInternalFrame jInternalFrame) {
        JInternalFrame[] jInternalFrameArray = sDesktop.getAllFrames();
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            String string = jInternalFrameArray[i].getTitle();
            String string2 = jInternalFrame.getTitle();
            if (!jInternalFrameArray[i].getTitle().equals(jInternalFrame.getTitle())) continue;
            return jInternalFrameArray[i];
        }
        return null;
    }

    private void getNewDesktop() {
        MDIDesktopPane mDIDesktopPane;
        JViewport jViewport = this.mScroll.getViewport();
        if (jViewport.getComponentCount() > 0) {
            jViewport.removeAll();
        }
        sDesktop = mDIDesktopPane = this.mDesktopSample.getDesktopPane();
        this.mDesktopSample.initDesktopPane(this.mWizardDialog, this.mDisplayAutoJoin, false, this.mDragPane);
        jViewport.add(mDIDesktopPane);
        JInternalFrame[] jInternalFrameArray = sDesktop.getAllFrames();
        RelationShipTable relationShipTable = RelationshipPageUtils.getRelationTable(jInternalFrameArray[0]);
        relationShipTable.setRowSelectionInterval(0, 0);
        relationShipTable.setColumnSelectionInterval(0, 0);
    }

    private boolean checkForConversion(JConnector jConnector) {
        if ((jConnector.getJoinType().equals((Object)JoinType.LEFT_JOIN) || jConnector.getJoinType().equals((Object)JoinType.RIGHT_JOIN)) && RelationshipDeskTopPane.hasOuterJoins(jConnector)) {
            int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_HAS_OUTER_JOIN_CONVERT_JOIN"), this.mWizardDialog.getResString("IDS_ERR_DLG_TITLE"), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            if (n == 3 || n == -1) {
                return false;
            }
            RelationshipDeskTopPane.convertJoin();
            return true;
        }
        return true;
    }

    private boolean joinAlreadyExists(JoinInfo joinInfo, ArrayList<JoinInfo> arrayList) {
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            JInternalFrame jInternalFrame = arrayList.get(i).getSrcFrame();
            JInternalFrame jInternalFrame2 = arrayList.get(i).getTargetFrame();
            String string = arrayList.get(i).getSrcField().getColumnName();
            String string2 = arrayList.get(i).getTargetField().getColumnName();
            if (!jInternalFrame.equals(joinInfo.getSrcFrame()) && !jInternalFrame.equals(joinInfo.getTargetFrame()) || !jInternalFrame2.equals(joinInfo.getSrcFrame()) && !jInternalFrame2.equals(joinInfo.getTargetFrame()) || !string.equals(joinInfo.getSrcField()) && !string.equals(joinInfo.getTargetField()) || !string2.equals(joinInfo.getSrcField()) && !string2.equals(joinInfo.getTargetField())) continue;
            bl = true;
            mExistingJoinInfo = arrayList.get(i);
            break;
        }
        return bl;
    }

    private ArrayList<JoinInfo> changeJoinType(ArrayList<JoinInfo> arrayList) {
        this.mChanged = false;
        ArrayList<JConnector> arrayList2 = MDIDesktopPane.getActiveConnectors();
        JConnector jConnector = arrayList2.get(0);
        for (int i = 0; i < arrayList.size() && !this.mChanged; ++i) {
            JInternalFrame jInternalFrame = arrayList.get(i).getSrcFrame();
            JInternalFrame jInternalFrame2 = arrayList.get(i).getTargetFrame();
            String string = arrayList.get(i).getSrcField().getColumnName();
            String string2 = arrayList.get(i).getTargetField().getColumnName();
            if (!jInternalFrame.equals(jConnector.getComp1()) && !jInternalFrame.equals(jConnector.getComp2()) || !jInternalFrame2.equals(jConnector.getComp1()) && !jInternalFrame2.equals(jConnector.getComp2()) || !string.equals(jConnector.getSrcColumn().getColumnName()) || !string2.equals(jConnector.getTargetColumn().getColumnName())) continue;
            if (RelationshipDeskTopPane.hasOuterJoins(jConnector) && (sJoinType.equals((Object)JoinType.LEFT_JOIN) || sJoinType.equals((Object)JoinType.RIGHT_JOIN))) {
                int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_HAS_OUTER_JOIN_CONVERT_JOIN"), this.mWizardDialog.getResString("IDS_ERR_DLG_TITLE"), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
                if (n == 3 || n == -1) {
                    return null;
                }
                this.mChanged = true;
                RelationshipDeskTopPane.convertJoin();
            }
            arrayList.get(i).setJoinType(sJoinType);
        }
        return arrayList;
    }

    private JPanel setupAutoJoinPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_JOIN_TYPE_LABEL");
        jLabel.setLabelFor(this.mJoinCombo);
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(jLabel);
        jPanel2.add(Box.createHorizontalStrut(insets.left));
        jPanel2.add(this.mJoinCombo);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        n = 10;
        DialogUtil.addUsingGBL(jPanel, sJoinButton, gridBagConstraints, 1, 0, 1, 1, n, null);
        n = 22;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mAutoJoinCheckBox, gridBagConstraints, 2, 0, 2, 1, n, null);
        return jPanel;
    }

    private void setDefaults() {
        this.mJoinCombo.setSelectedIndex(0);
        this.mAutoJoinCheckBox.setSelected(true);
        this.mDisplayAutoJoin = this.mAutoJoinCheckBox.isSelected();
        sJoinButton.setEnabled(false);
        this.mInnerOuterAllowed = false;
    }

    private void saveJoinInfo() {
        TableJoin tableJoin;
        JoinData joinData = JoinData.getJoinData();
        ArrayList<JoinInfo> arrayList = joinData.getUserJoinList();
        ArrayList<JoinInfo> arrayList2 = joinData.getAutoJoinList();
        ArrayList<JoinInfo> arrayList3 = joinData.getSysJoinList();
        ArrayList<TableJoin> arrayList4 = new ArrayList<TableJoin>();
        for (JoinInfo joinInfo : arrayList) {
            tableJoin = new TableJoin(joinInfo.getSrcField(), joinInfo.getTargetField(), joinInfo.getJoinType(), JoinOrigin.USER_JOIN);
            if (arrayList4.contains(tableJoin)) continue;
            arrayList4.add(tableJoin);
        }
        for (JoinInfo joinInfo : arrayList2) {
            tableJoin = new TableJoin(joinInfo.getSrcField(), joinInfo.getTargetField(), joinInfo.getJoinType(), JoinOrigin.AUTO_JOIN);
            if (arrayList4.contains(tableJoin)) continue;
            arrayList4.add(tableJoin);
        }
        for (JoinInfo joinInfo : arrayList3) {
            tableJoin = new TableJoin(joinInfo.getSrcField(), joinInfo.getTargetField(), joinInfo.getJoinType(), JoinOrigin.SYSTEM_JOIN);
            if (arrayList4.contains(tableJoin)) continue;
            arrayList4.add(tableJoin);
        }
        RelationshipPageInfo relationshipPageInfo = RelationshipPageInfo.getRelationshipPageInfo();
        if (!relationshipPageInfo.getTableJoins().equals(arrayList4)) {
            SPSSUtil.clearLimitPage();
        }
        this.mIsModified = !relationshipPageInfo.getTableJoins().equals(arrayList4);
        relationshipPageInfo.setTableJoins(arrayList4);
    }

    private void checkOuterCaps() {
        ODBCWizardCapabilities oDBCWizardCapabilities = DBData.getDBData().getWizardCapabities();
        if (oDBCWizardCapabilities.getOuterJoins()) {
            this.mInnerOuterAllowed = ((long)oDBCWizardCapabilities.getOuterJoinCaps() & 0x20L) > 0L;
        }
    }

    private void SerializeJoinInfo() {
        JoinData joinData = JoinData.getJoinData();
        ArrayList<JoinInfo> arrayList = joinData.getAutoJoinList();
        ArrayList<JoinInfo> arrayList2 = joinData.getUserJoinList();
        ArrayList<JoinInfo> arrayList3 = joinData.getSysJoinList();
        ArrayList<SerializedJoinInfo> arrayList4 = DBData.getDBData().getSerializableAutoJoinList();
        ArrayList<SerializedJoinInfo> arrayList5 = DBData.getDBData().getSerializableUserJoinList();
        ArrayList<SerializedJoinInfo> arrayList6 = DBData.getDBData().getSerializableSysJoinList();
        this.SerializeJoins(arrayList, arrayList4);
        this.SerializeJoins(arrayList2, arrayList5);
        this.SerializeJoins(arrayList3, arrayList6);
    }

    private void SerializeJoins(ArrayList<JoinInfo> arrayList, ArrayList<SerializedJoinInfo> arrayList2) {
        if (arrayList2.size() > 0) {
            arrayList2.clear();
        }
        LinkedHashMap<TablesInfo.InternalTableInfo, ArrayList<ColumnsInfo.InternalColumnInfo>> linkedHashMap = DBWizardUtil.getTableWiseColum();
        if (arrayList != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                JoinInfo joinInfo = arrayList.get(i);
                SerializedJoinInfo serializedJoinInfo = new SerializedJoinInfo();
                for (TablesInfo.InternalTableInfo internalTableInfo : linkedHashMap.keySet()) {
                    ArrayList<ColumnsInfo.InternalColumnInfo> arrayList3;
                    String string = internalTableInfo.getOwner();
                    String string2 = internalTableInfo.getName();
                    if (!string.equals("")) {
                        string2 = string + DBWizardUtil.getOwnerNameSeperator() + string2;
                    }
                    if (string2.equals(joinInfo.getSrcFrame().getTitle())) {
                        serializedJoinInfo.setSrcTableInfo(internalTableInfo);
                        arrayList3 = linkedHashMap.get(internalTableInfo);
                        for (ColumnsInfo.InternalColumnInfo internalColumnInfo : arrayList3) {
                            if (!internalColumnInfo.getStrColumnName().equals(joinInfo.getSrcField())) continue;
                            serializedJoinInfo.setSrcColumnInfo(internalColumnInfo);
                        }
                        continue;
                    }
                    if (!string2.equals(joinInfo.getTargetFrame().getTitle())) continue;
                    serializedJoinInfo.setTargetTableInfo(internalTableInfo);
                    arrayList3 = linkedHashMap.get(internalTableInfo);
                    for (ColumnsInfo.InternalColumnInfo internalColumnInfo : arrayList3) {
                        if (!internalColumnInfo.getStrColumnName().equals(joinInfo.getTargetField())) continue;
                        serializedJoinInfo.setTargetColumnInfo(internalColumnInfo);
                    }
                }
                serializedJoinInfo.setJoinType(joinInfo.getJoinType());
                arrayList2.add(serializedJoinInfo);
            }
        }
    }

    private ArrayList<JoinInfo> fillJoinList(ArrayList<SerializedJoinInfo> arrayList) {
        ArrayList<JoinInfo> arrayList2 = new ArrayList<JoinInfo>();
        MDIDesktopPane mDIDesktopPane = MDIDesktopPane.getMDIDesktopPane();
        for (int i = 0; i < mDIDesktopPane.getComponentCount(); ++i) {
            if (!(mDIDesktopPane.getComponent(i) instanceof JConnector)) continue;
            mDIDesktopPane.remove(mDIDesktopPane.getComponent(i));
        }
        for (SerializedJoinInfo serializedJoinInfo : arrayList) {
            JInternalFrame jInternalFrame = this.createInternalFrame(serializedJoinInfo.getSrcTableInfo());
            JInternalFrame jInternalFrame2 = this.createInternalFrame(serializedJoinInfo.getTargetTableInfo());
            JoinInfo joinInfo = new JoinInfo();
            joinInfo.setJoinType(serializedJoinInfo.getJoinType());
            joinInfo.setSrcFrame(jInternalFrame);
            joinInfo.setTargetFrame(jInternalFrame2);
            arrayList2.add(joinInfo);
        }
        return arrayList2;
    }

    private JInternalFrame createInternalFrame(ODBCTable oDBCTable) {
        JInternalFrame jInternalFrame = new JInternalFrame(oDBCTable.getQualifiedName(), true);
        MDIDesktopPane mDIDesktopPane = MDIDesktopPane.getMDIDesktopPane();
        ArrayList<RelationShipData> arrayList = new ArrayList<RelationShipData>();
        List<ODBCColumn> list = ODBC.getODBC().getColumns(oDBCTable.getQualifiedName());
        for (ODBCColumn object2 : list) {
            RelationShipData relationShipData = new RelationShipData(object2);
            arrayList.add(relationShipData);
        }
        RelationShipTable relationShipTable = new RelationShipTable(arrayList, oDBCTable.getQualifiedName(), this.mDragPane).getTable();
        JScrollPane jScrollPane = new JScrollPane(relationShipTable);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        jScrollPane.getViewport().setBackground(Color.white);
        jInternalFrame.add(jScrollPane);
        jInternalFrame.setMinimumSize(new Dimension(100, 100));
        mDIDesktopPane.add(jInternalFrame);
        return jInternalFrame;
    }

    private JInternalFrame createInternalFrame(TablesInfo.InternalTableInfo internalTableInfo) {
        Object object2;
        String string = internalTableInfo.getName();
        String string2 = internalTableInfo.getOwner();
        if (!string2.equals("")) {
            string = string2 + DBWizardUtil.getOwnerNameSeperator() + string;
        }
        JInternalFrame jInternalFrame = new JInternalFrame(string, true);
        MDIDesktopPane mDIDesktopPane = MDIDesktopPane.getMDIDesktopPane();
        ArrayList<RelationShipData> arrayList = new ArrayList<RelationShipData>();
        ColumnsInfo columnsInfo = DBData.getDBData().getFilteredColumnsInfo().get(string);
        for (Object object2 : columnsInfo.getColInfos()) {
            Object e = null;
            arrayList.add((RelationShipData)e);
        }
        RelationShipTable relationShipTable = new RelationShipTable(arrayList, string, this.mDragPane).getTable();
        object2 = new JScrollPane(relationShipTable);
        ((JScrollPane)object2).setHorizontalScrollBarPolicy(32);
        ((JScrollPane)object2).getViewport().setBackground(Color.white);
        jInternalFrame.add((Component)object2);
        jInternalFrame.setMinimumSize(new Dimension(100, 100));
        mDIDesktopPane.add(jInternalFrame);
        return jInternalFrame;
    }

    private void setJoinType() {
        switch (this.mJoinCombo.getSelectedIndex()) {
            case 0: {
                sJoinType = JoinType.INNER_JOIN;
                break;
            }
            case 1: {
                sJoinType = JoinType.RIGHT_JOIN;
                break;
            }
            case 2: {
                sJoinType = JoinType.LEFT_JOIN;
            }
        }
    }

    static {
        sJoinType = JoinType.INNER_JOIN;
        mExistingJoinInfo = null;
    }

    private class DBComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        private DBComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String[] stringArray = SpecifyRelationshipsPage.this.mWizardDialog.getResStringArray("IDS_AUTO_JOIN_COMBOBOX_ITEMS");
            this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            if (object.equals(stringArray[0])) {
                ImageIcon imageIcon = new ImageIcon(SpecifyRelationshipsPage.this.mWizardDialog.getResImageURL("IDS_SPECIFY_REALTION_INNER_JOIN_IMG"));
                this.setIcon(imageIcon);
                this.setText(object.toString());
                this.setToolTipText(SpecifyRelationshipsPage.this.mWizardDialog.getResString("INNER_JOIN_TOOL_TIP"));
            } else if (object.equals(stringArray[1])) {
                ImageIcon imageIcon = new ImageIcon(SpecifyRelationshipsPage.this.mWizardDialog.getResImageURL("IDS_SPECIFY_REALTION_RIGHT_JOIN_IMG"));
                this.setIcon(imageIcon);
                this.setText(object.toString());
                this.setToolTipText(SpecifyRelationshipsPage.this.mWizardDialog.getResString("RIGHT_OUTER_JOIN_TOOL_TIP"));
            } else if (object.equals(stringArray[2])) {
                ImageIcon imageIcon = new ImageIcon(SpecifyRelationshipsPage.this.mWizardDialog.getResImageURL("IDS_SPECIFY_REALTION_LEFT_JOIN_IMG"));
                this.setIcon(imageIcon);
                this.setText(object.toString());
                this.setToolTipText(SpecifyRelationshipsPage.this.mWizardDialog.getResString("LEFT_OUTER_JOIN_TOOL_TIP"));
            }
            this.setBounds(0, 0, this.getWidth(), this.getHeight());
            this.setIconTextGap(10);
            this.setOpaque(true);
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }
}

