/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships;

import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.JConnector;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.MDIDesktopPane;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.RelationShipTable;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.RelationshipPageUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SRPageFocusPolicy
extends FocusTraversalPolicy {
    private List<Component> mOtherComponents = new ArrayList<Component>();
    private List<Component> mComponents = new ArrayList<Component>();
    private RelationShipTable[] mRelationshipTables;

    public SRPageFocusPolicy(List<Component> list) {
        this.mOtherComponents.addAll(list);
        this.mRelationshipTables = RelationshipPageUtils.getAllRelationshipTables(MDIDesktopPane.getMDIDesktopPane());
        this.buildComponentList();
    }

    public SRPageFocusPolicy() {
    }

    @Override
    public Component getComponentAfter(Container container, Component component) {
        this.buildComponentList();
        int n = component instanceof JConnector ? this.indexOfJConnector() : this.mComponents.indexOf(component);
        n = n == this.mComponents.size() - 1 ? 0 : ++n;
        Component component2 = this.mComponents.get(n);
        if (component2.isEnabled()) {
            if (component2 instanceof JConnector) {
                MDIDesktopPane.getMDIDesktopPane().requestFocus();
            }
            return component2;
        }
        return this.getComponentAfter(container, component2);
    }

    private int indexOfJConnector() {
        int n = 0;
        for (Component component : this.mComponents) {
            if (component instanceof JConnector) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public Component getComponentBefore(Container container, Component component) {
        this.buildComponentList();
        int n = component instanceof JConnector ? this.indexOfJConnector() : this.mComponents.indexOf(component);
        n = n == 0 ? this.mComponents.size() - 1 : --n;
        Component component2 = this.mComponents.get(n);
        if (component2.isEnabled()) {
            if (component2 instanceof JConnector) {
                MDIDesktopPane.getMDIDesktopPane().requestFocus();
            }
            return component2;
        }
        return this.getComponentAfter(container, component2);
    }

    @Override
    public Component getFirstComponent(Container container) {
        this.buildComponentList();
        return this.mComponents.get(0);
    }

    @Override
    public Component getLastComponent(Container container) {
        this.buildComponentList();
        return this.mComponents.get(this.mComponents.size());
    }

    @Override
    public Component getDefaultComponent(Container container) {
        this.buildComponentList();
        return this.mComponents.get(0);
    }

    private void buildComponentList() {
        this.mComponents.clear();
        this.mComponents = new ArrayList<Component>();
        this.mComponents.addAll(Arrays.asList(this.mRelationshipTables));
        ArrayList<JConnector> arrayList = MDIDesktopPane.getAllConnectors();
        if (arrayList != null && arrayList.size() > 0) {
            boolean bl = false;
            for (JConnector jConnector : arrayList) {
                if (!jConnector.isSelected()) continue;
                this.mComponents.add(jConnector);
                bl = true;
            }
            if (!bl) {
                this.mComponents.add(arrayList.get(0));
            }
        }
        this.mComponents.addAll(this.mOtherComponents);
    }
}

