/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships;

import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.JConnector;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.JoinData;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.JoinInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.MDIDesktopManager;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.RelationshipPageUtils;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.SpecifyRelationshipsPage;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBWizardUtil;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Line2D;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;

public class MDIDesktopPane
extends JDesktopPane
implements MouseListener,
ComponentListener,
ContainerListener {
    private static final int FRAME_OFFSET = 70;
    private static MDIDesktopPane sDesktopPane = null;
    private static ArrayList<JConnector> sConnectorList;
    private MDIDesktopManager mManager = new MDIDesktopManager(this);

    public MDIDesktopPane() {
        this.setDesktopManager(this.mManager);
        this.setDragMode(1);
        this.addMouseListener(this);
        this.addContainerListener(this);
    }

    public static ArrayList<JConnector> getAllConnectors() {
        MDIDesktopPane mDIDesktopPane = MDIDesktopPane.getMDIDesktopPane();
        sConnectorList = new ArrayList();
        for (int i = 0; i < mDIDesktopPane.getComponentCount(); ++i) {
            if (!(mDIDesktopPane.getComponent(i) instanceof JConnector)) continue;
            sConnectorList.add((JConnector)mDIDesktopPane.getComponent(i));
        }
        return sConnectorList;
    }

    public static ArrayList<JConnector> getActiveConnectors() {
        MDIDesktopPane.getAllConnectors();
        ArrayList<JConnector> arrayList = new ArrayList<JConnector>();
        if (sConnectorList != null) {
            for (JConnector jConnector : sConnectorList) {
                if (!jConnector.isSelected()) continue;
                arrayList.add(jConnector);
            }
        }
        return arrayList;
    }

    public static void resetMDIDesktopPane() {
        sDesktopPane = null;
    }

    public static MDIDesktopPane getMDIDesktopPane() {
        if (sDesktopPane == null) {
            sDesktopPane = new MDIDesktopPane();
            String string = UIManager.getLookAndFeel().getName();
            if (string.contains("Windows")) {
                sDesktopPane.setBackground(new Color(198, 211, 214));
            }
        }
        return sDesktopPane;
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.checkDesktopSize();
    }

    public Component add(JInternalFrame jInternalFrame) {
        Point point;
        JInternalFrame[] jInternalFrameArray = this.getAllFrames();
        this.checkDesktopSize();
        int n = jInternalFrameArray.length;
        if (n > 0) {
            int n2 = RelationshipPageUtils.getRelationTable((JInternalFrame)jInternalFrameArray[n - 1]).getSize().height;
            int n3 = RelationshipPageUtils.getRelationTable((JInternalFrame)jInternalFrameArray[n - 1]).getSize().width;
            point = jInternalFrameArray[n - 1].getLocation();
            int n4 = 400;
            point.x = point.x + n3 + 70;
            point.y = 0;
            if (point.x > n4) {
                point.x = 0;
                point.y = n2 + 70;
            }
        } else {
            point = new Point(0, 0);
        }
        jInternalFrame.setLocation(point.x, point.y);
        this.moveToFront(jInternalFrame);
        jInternalFrame.setSize(RelationshipPageUtils.getRelationTable(jInternalFrame).getSize());
        jInternalFrame.setVisible(true);
        jInternalFrame.setResizable(true);
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            jInternalFrame.toBack();
        }
        super.add(jInternalFrame);
        return jInternalFrame;
    }

    @Override
    public void remove(Component component) {
        super.remove(component);
        this.checkDesktopSize();
    }

    public void setAllSize(Dimension dimension) {
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setPreferredSize(dimension);
    }

    public void setAllSize(int n, int n2) {
        this.setAllSize(new Dimension(n, n2));
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        boolean bl = (mouseEvent.getModifiers() & 0x41) != 0;
        ArrayList<JConnector> arrayList = MDIDesktopPane.getAllConnectors();
        double d = 2.0;
        int n = -1;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            Line2D line2D = arrayList.get(i).getLine();
            double d2 = line2D.ptLineDist(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            if (!(d2 < d)) continue;
            d = d2;
            n = i;
        }
        if (n >= 0) {
            if (!bl) {
                MDIDesktopPane.unSelectAllJoins(arrayList);
            }
            arrayList.get(n).setSelected(true);
            MDIDesktopPane.unFocusAllJoins(arrayList);
            arrayList.get(n).setFocused(true);
            this.requestFocus();
        }
    }

    public static void unSelectAllJoins(ArrayList<JConnector> arrayList) {
        for (JConnector jConnector : arrayList) {
            jConnector.setSelected(false);
        }
    }

    public static void unFocusAllJoins(ArrayList<JConnector> arrayList) {
        for (JConnector jConnector : arrayList) {
            jConnector.setFocused(false);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void checkDesktopSize() {
        if (this.getParent() != null && this.isVisible()) {
            this.mManager.resizeDesktop();
        }
    }

    protected void removeConnectorFromList(JConnector jConnector) {
        ArrayList<JoinInfo> arrayList = JoinData.getJoinData().getUserJoinList();
        ArrayList<JoinInfo> arrayList2 = JoinData.getJoinData().getAutoJoinList();
        ArrayList<JoinInfo> arrayList3 = new ArrayList<JoinInfo>();
        ArrayList<JoinInfo> arrayList4 = new ArrayList<JoinInfo>();
        if (arrayList2 != null && arrayList2.size() > 0) {
            arrayList4.addAll(arrayList2);
        }
        if (arrayList != null && arrayList.size() > 0) {
            arrayList3.addAll(arrayList);
        }
        boolean bl = false;
        JoinInfo joinInfo = new JoinInfo();
        joinInfo.setSrcFrame(jConnector.getComp1());
        joinInfo.setTargetFrame(jConnector.getComp2());
        joinInfo.setSrcField(jConnector.getSrcColumn());
        joinInfo.setTargetField(jConnector.getTargetColumn());
        joinInfo.setJoinType(jConnector.getJoinType());
        if (arrayList4.size() > 0 && arrayList2 != null) {
            for (JoinInfo joinInfo2 : arrayList2) {
                if (!joinInfo2.equals(joinInfo)) continue;
                arrayList4.remove(joinInfo2);
                bl = true;
            }
        }
        if (!bl && arrayList3.size() > 0 && arrayList != null) {
            for (JoinInfo joinInfo2 : arrayList) {
                if (!joinInfo2.equals(joinInfo)) continue;
                arrayList3.remove(joinInfo2);
            }
        }
        JoinData.getJoinData().setAutoJoinList(arrayList4);
        JoinData.getJoinData().setUserJoinList(arrayList3);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        boolean bl = MDIDesktopPane.getAllConnectors().size() > 0;
        BaseWizardDialog baseWizardDialog = DBWizardUtil.getDialog();
        baseWizardDialog.enableFinish(bl);
        bl = MDIDesktopPane.getActiveConnectors().size() > 0;
        SpecifyRelationshipsPage.sJoinButton.setEnabled(bl);
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        boolean bl = MDIDesktopPane.getAllConnectors().size() > 0;
        BaseWizardDialog baseWizardDialog = DBWizardUtil.getDialog();
        baseWizardDialog.enableFinish(bl);
        bl = MDIDesktopPane.getActiveConnectors().size() > 0;
        SpecifyRelationshipsPage.sJoinButton.setEnabled(bl);
    }
}

