/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships;

import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.JoinType;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.MDIDesktopPane;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.RelationShipTable;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.RelationshipPageUtils;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.RelationshipTableModel;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.SpecifyRelationshipsPage;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCColumn;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class JConnector
extends JComponent
implements ComponentListener,
AdjustmentListener,
FocusListener {
    private static final int s_Dir_1 = 1;
    private static final int s_Dir_2 = 2;
    private static final int s_Dir_3 = 3;
    private static final int s_Dir_4 = 4;
    private JInternalFrame mComp1;
    private JInternalFrame mComp2;
    private JInternalFrame mSource;
    private JInternalFrame mTarget;
    private ODBCColumn mSrcColumn;
    private ODBCColumn mTargetColumn;
    private Point mPtOrigin;
    private Point mPtTarget;
    private Point mPoint1;
    private Point mPoint2;
    private Point mPoint3;
    private Point mPoint4;
    private Point mPoint5;
    private Point mPoint6;
    private transient Line2D mLinUnion;
    private transient Line2D mConLine1;
    private transient boolean mSelected;
    private transient boolean mFocused;
    private int m_LineDirection;
    private JoinType mJointype;
    private MDIDesktopPane mReDskTop;

    public JConnector(JInternalFrame jInternalFrame, JInternalFrame jInternalFrame2, ODBCColumn oDBCColumn, ODBCColumn oDBCColumn2, JoinType joinType, MDIDesktopPane mDIDesktopPane) {
        this.mComp1 = jInternalFrame;
        this.mComp2 = jInternalFrame2;
        this.mSrcColumn = oDBCColumn;
        this.mTargetColumn = oDBCColumn2;
        this.mReDskTop = mDIDesktopPane;
        this.mJointype = joinType;
        this.init();
    }

    public JoinType getJoinType() {
        return this.mJointype;
    }

    public ODBCColumn getSrcColumn() {
        return this.mSrcColumn;
    }

    public ODBCColumn getTargetColumn() {
        return this.mTargetColumn;
    }

    public JInternalFrame getComp1() {
        return this.mComp1;
    }

    public JInternalFrame getComp2() {
        return this.mComp2;
    }

    public MDIDesktopPane getReDskTop() {
        return this.mReDskTop;
    }

    public void setReDskTop(MDIDesktopPane mDIDesktopPane) {
        this.mReDskTop = mDIDesktopPane;
    }

    public void setJointype(JoinType joinType) {
        this.mJointype = joinType;
    }

    public boolean isSelected() {
        return this.mSelected;
    }

    public void setSelected(boolean bl) {
        this.mSelected = bl;
        this.paintImmediately(this.getBounds());
        if (bl) {
            LinkedList<RelationShipTable> linkedList = SpecifyRelationshipsPage.getAllSelectedColumns();
            for (int i = 0; i < linkedList.size(); ++i) {
                linkedList.get(i).clearSelection();
            }
        }
        this.mReDskTop.repaint();
    }

    public void setFocused(boolean bl) {
        this.mFocused = bl;
    }

    public boolean isFocused() {
        return this.mFocused;
    }

    public Line2D getLine() {
        return new Line2D.Float(this.mPtOrigin, this.mPtTarget);
    }

    public boolean equals(JConnector jConnector) {
        return !(!this.getComp1().equals(jConnector.getComp1()) && !this.getComp1().equals(jConnector.getComp2()) || !this.getComp2().equals(jConnector.getComp1()) && !this.getComp2().equals(jConnector.getComp2()) || !this.getSrcColumn().getColumnName().equals(jConnector.getSrcColumn().getColumnName()) && !this.getSrcColumn().getColumnName().equals(jConnector.getTargetColumn().getColumnName()) || !this.getTargetColumn().getColumnName().equals(jConnector.getSrcColumn().getColumnName()) && !this.getTargetColumn().getColumnName().equals(jConnector.getTargetColumn().getColumnName()));
    }

    public void init() {
        this.mPtOrigin = null;
        this.mPtTarget = null;
        this.mLinUnion = new Line2D.Float();
        this.mConLine1 = new Line2D.Float();
        this.mPoint1 = new Point(0, 0);
        this.mPoint2 = new Point(0, 0);
        this.mPoint3 = new Point(0, 0);
        this.mPoint4 = new Point(0, 0);
        this.mPoint5 = new Point(0, 0);
        this.mPoint6 = new Point(0, 0);
        this.selectOnlyMe();
        this.mFocused = false;
        this.setOpaque(false);
        this.calculate();
        this.mComp1.addComponentListener(this);
        this.mComp2.addComponentListener(this);
        JScrollPane jScrollPane = RelationshipPageUtils.getScrollPane(this.mComp1);
        jScrollPane.getVerticalScrollBar().addAdjustmentListener(this);
        JScrollPane jScrollPane2 = RelationshipPageUtils.getScrollPane(this.mComp2);
        jScrollPane2.getVerticalScrollBar().addAdjustmentListener(this);
        this.addFocusListener(this);
    }

    private void selectOnlyMe() {
        ArrayList<JConnector> arrayList = MDIDesktopPane.getAllConnectors();
        MDIDesktopPane.unSelectAllJoins(arrayList);
        this.setSelected(true);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.calculate();
        this.paintImmediately(this.getBounds());
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(Color.black);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.calculate();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.mFocused ? Color.blue : Color.black);
        graphics2D.setStroke(new BasicStroke(this.mSelected ? 2.0f : 1.0f));
        graphics2D.draw(this.mLinUnion);
        if (this.mJointype.equals((Object)JoinType.INNER_JOIN)) {
            int[] nArray = new int[]{(int)this.mPoint1.getX(), (int)this.mPoint2.getX(), (int)this.mPoint3.getX()};
            int[] nArray2 = new int[]{(int)this.mPoint1.getY(), (int)this.mPoint2.getY(), (int)this.mPoint3.getY()};
            graphics2D.fillPolygon(nArray, nArray2, 3);
            nArray = new int[]{(int)this.mPoint4.getX(), (int)this.mPoint5.getX(), (int)this.mPoint6.getX()};
            nArray2 = new int[]{(int)this.mPoint4.getY(), (int)this.mPoint5.getY(), (int)this.mPoint6.getY()};
            graphics2D.fillPolygon(nArray, nArray2, 3);
        } else if (this.mJointype.equals((Object)JoinType.LEFT_JOIN)) {
            if (this.mSource.equals(this.mComp1)) {
                int[] nArray = new int[]{(int)this.mPoint4.getX(), (int)this.mPoint5.getX(), (int)this.mPoint6.getX()};
                int[] nArray3 = new int[]{(int)this.mPoint4.getY(), (int)this.mPoint5.getY(), (int)this.mPoint6.getY()};
                graphics2D.fillPolygon(nArray, nArray3, 3);
            } else {
                int[] nArray = new int[]{(int)this.mPoint1.getX(), (int)this.mPoint2.getX(), (int)this.mPoint3.getX()};
                int[] nArray4 = new int[]{(int)this.mPoint1.getY(), (int)this.mPoint2.getY(), (int)this.mPoint3.getY()};
                graphics2D.fillPolygon(nArray, nArray4, 3);
            }
            graphics2D.setStroke(new BasicStroke(6.0f));
            graphics2D.draw(this.mConLine1);
        } else if (this.mJointype.equals((Object)JoinType.RIGHT_JOIN)) {
            if (this.mSource.equals(this.mComp1)) {
                int[] nArray = new int[]{(int)this.mPoint1.getX(), (int)this.mPoint2.getX(), (int)this.mPoint3.getX()};
                int[] nArray5 = new int[]{(int)this.mPoint1.getY(), (int)this.mPoint2.getY(), (int)this.mPoint3.getY()};
                graphics2D.fillPolygon(nArray, nArray5, 3);
            } else {
                int[] nArray = new int[]{(int)this.mPoint4.getX(), (int)this.mPoint5.getX(), (int)this.mPoint6.getX()};
                int[] nArray6 = new int[]{(int)this.mPoint4.getY(), (int)this.mPoint5.getY(), (int)this.mPoint6.getY()};
                graphics2D.fillPolygon(nArray, nArray6, 3);
            }
            graphics2D.setStroke(new BasicStroke(6.0f));
            graphics2D.draw(this.mConLine1);
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        this.calculate();
        this.paintImmediately(this.getBounds());
        this.mReDskTop.repaint();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.calculate();
        this.paintImmediately(this.getBounds());
        this.mReDskTop.repaint();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        JConnector jConnector = (JConnector)focusEvent.getComponent();
        ArrayList<JConnector> arrayList = MDIDesktopPane.getAllConnectors();
        MDIDesktopPane.unFocusAllJoins(arrayList);
        jConnector.setForeground(Color.blue);
        jConnector.setFocused(true);
        jConnector.paintImmediately(this.getBounds());
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        JConnector jConnector = (JConnector)focusEvent.getComponent();
        ArrayList<JConnector> arrayList = MDIDesktopPane.getAllConnectors();
        MDIDesktopPane.unFocusAllJoins(arrayList);
        jConnector.setForeground(Color.black);
        jConnector.setFocused(false);
        jConnector.paintImmediately(this.getBounds());
    }

    private void calculate() {
        this.initPoints();
        if (this.m_LineDirection == 1 || this.m_LineDirection == 2) {
            this.initBounds(this.mPtOrigin, this.mPtTarget);
        } else if (this.m_LineDirection == 4 || this.m_LineDirection == 3) {
            this.mPtOrigin = new Point((int)this.mPtOrigin.getX() + 8, (int)this.mPtOrigin.getY());
            this.mPtTarget = new Point((int)this.mPtTarget.getX() - 8, (int)this.mPtTarget.getY());
            this.initBounds(this.mPtOrigin, this.mPtTarget);
        }
        if (this.mJointype.equals((Object)JoinType.INNER_JOIN)) {
            this.initLine1();
        } else if (this.mJointype.equals((Object)JoinType.LEFT_JOIN)) {
            if (this.mSource.equals(this.mComp1)) {
                this.initLine3();
            } else {
                this.initLine2();
            }
        }
        if (this.mJointype.equals((Object)JoinType.RIGHT_JOIN)) {
            if (this.mSource.equals(this.mComp1)) {
                this.initLine2();
            } else {
                this.initLine3();
            }
        }
    }

    private void initLine1() {
        Point point;
        Point point2;
        this.resetPoints();
        if (this.m_LineDirection == 1) {
            this.mLinUnion.setLine(4.0, 4.0, this.getWidth() - 4, this.getHeight() - 4);
            point2 = new Point(0, 4);
            point = new Point(this.getWidth(), this.getHeight() - 4);
            this.initLeftTrianglePoints(point2);
            this.initRightTrianglePoints(point);
        }
        if (this.m_LineDirection == 2) {
            this.mLinUnion.setLine(4.0, this.getHeight() - 4, this.getWidth() - 4, 4.0);
            point2 = new Point(0, this.getHeight() - 4);
            point = new Point(this.getWidth(), 4);
            this.initLeftTrianglePoints(point2);
            this.initRightTrianglePoints(point);
        }
        if (this.m_LineDirection == 4) {
            this.mLinUnion.setLine(this.getWidth() - 4, this.getHeight() - 4, 4.0, 4.0);
            point2 = new Point(8, 4);
            this.initRightTrianglePoints(point2);
            point = new Point(this.getWidth() - 8, this.getHeight() - 4);
            this.initLeftTrianglePoints(point);
        }
        if (this.m_LineDirection == 3) {
            this.mLinUnion.setLine(this.getWidth() - 4, 4.0, 4.0, this.getHeight() - 4);
            point2 = new Point(this.getWidth() - 8, 4);
            this.initLeftTrianglePoints(point2);
            point = new Point(8, this.getHeight() - 4);
            this.initRightTrianglePoints(point);
        }
    }

    private void initLine2() {
        Point point;
        this.resetPoints();
        if (this.m_LineDirection == 1) {
            this.mLinUnion.setLine(4.0, 4.0, this.getWidth() - 4, this.getHeight() - 4);
            this.mConLine1.setLine(this.getWidth() - 4, this.getHeight() - 4, this.getWidth(), this.getHeight() - 4);
            point = new Point(0, 4);
            this.initLeftTrianglePoints(point);
        }
        if (this.m_LineDirection == 2) {
            this.mLinUnion.setLine(4.0, this.getHeight() - 4, this.getWidth() - 4, 4.0);
            this.mConLine1.setLine(this.getWidth() - 4, 4.0, this.getWidth(), 4.0);
            point = new Point(0, this.getHeight() - 4);
            this.initLeftTrianglePoints(point);
        }
        if (this.m_LineDirection == 4) {
            this.mLinUnion.setLine(0.0, 4.0, this.getWidth() - 4, this.getHeight() - 4);
            this.mConLine1.setLine(0.0, 4.0, 4.0, 4.0);
            point = new Point(this.getWidth() - 8, this.getHeight() - 4);
            this.initLeftTrianglePoints(point);
        }
        if (this.m_LineDirection == 3) {
            this.mLinUnion.setLine(this.getWidth() - 4, 4.0, 0.0, this.getHeight() - 4);
            this.mConLine1.setLine(0.0, this.getHeight() - 4, 4.0, this.getHeight() - 4);
            point = new Point(this.getWidth() - 8, 4);
            this.initLeftTrianglePoints(point);
        }
    }

    private void resetPoints() {
        this.mPoint1 = new Point(0, 0);
        this.mPoint2 = new Point(0, 0);
        this.mPoint3 = new Point(0, 0);
        this.mPoint4 = new Point(0, 0);
        this.mPoint5 = new Point(0, 0);
        this.mPoint6 = new Point(0, 0);
        this.mConLine1.setLine(0.0, 0.0, 0.0, 0.0);
    }

    private void initLine3() {
        Point point;
        this.resetPoints();
        if (this.m_LineDirection == 1) {
            this.mLinUnion.setLine(4.0, 4.0, this.getWidth() - 4, this.getHeight() - 4);
            this.mConLine1.setLine(0.0, 4.0, 4.0, 4.0);
            point = new Point(this.getWidth(), this.getHeight() - 4);
            this.initRightTrianglePoints(point);
        }
        if (this.m_LineDirection == 2) {
            this.mLinUnion.setLine(4.0, this.getHeight() - 4, this.getWidth() - 4, 4.0);
            this.mConLine1.setLine(0.0, this.getHeight() - 4, 4.0, this.getHeight() - 4);
            point = new Point(this.getWidth(), 4);
            this.initRightTrianglePoints(point);
        }
        if (this.m_LineDirection == 4) {
            this.mLinUnion.setLine(this.getWidth(), this.getHeight(), 4.0, 4.0);
            this.mConLine1.setLine(this.getWidth(), this.getHeight() - 4, this.getWidth() - 4, this.getHeight() - 4);
            point = new Point(8, 4);
            this.initRightTrianglePoints(point);
        }
        if (this.m_LineDirection == 3) {
            this.mLinUnion.setLine(this.getWidth(), 4.0, 4.0, this.getHeight() - 4);
            this.mConLine1.setLine(this.getWidth(), 4.0, this.getWidth() - 4, 4.0);
            point = new Point(8, this.getHeight() - 4);
            this.initRightTrianglePoints(point);
        }
    }

    private void initLeftTrianglePoints(Point point) {
        this.mPoint1 = point;
        int n = (int)(point.getX() + 4.0);
        int n2 = (int)(point.getY() - Math.sqrt(20.0));
        this.mPoint2 = new Point(n, n2);
        n = (int)(point.getX() + 4.0);
        n2 = (int)(point.getY() + Math.sqrt(20.0));
        this.mPoint3 = new Point(n, n2);
    }

    private void initRightTrianglePoints(Point point) {
        this.mPoint4 = point;
        int n = (int)(point.getX() - 4.0);
        int n2 = (int)(point.getY() - Math.sqrt(20.0));
        this.mPoint5 = new Point(n, n2);
        n = (int)(point.getX() - 4.0);
        n2 = (int)(point.getY() + Math.sqrt(20.0));
        this.mPoint6 = new Point(n, n2);
    }

    private void initBounds(Point point, Point point2) {
        Rectangle rectangle = new Rectangle();
        rectangle.x = (int)Math.min(point.getX(), point2.getX());
        rectangle.y = (int)Math.min(point.getY(), point2.getY());
        rectangle.height = (int)Math.max(point.getY(), point2.getY()) - rectangle.y;
        if (rectangle.height < 10) {
            rectangle.height = 10;
        }
        rectangle.width = (int)Math.max(point.getX(), point2.getX()) - rectangle.x;
        if (rectangle.width == 0) {
            rectangle.width = 5;
        }
        this.setBounds(rectangle);
    }

    private void initPoints() {
        Point point = this.mComp1.getLocation();
        Point point2 = this.mComp2.getLocation();
        if (point.getX() <= point2.getX()) {
            this.mSource = this.mComp1;
            this.mTarget = this.mComp2;
        } else {
            this.mSource = this.mComp2;
            this.mTarget = this.mComp1;
        }
        point = this.mSource.getLocation();
        point2 = this.mTarget.getLocation();
        RelationShipTable relationShipTable = RelationshipPageUtils.getRelationTable(this.mComp1);
        RelationShipTable relationShipTable2 = RelationshipPageUtils.getRelationTable(this.mComp2);
        int n = ((RelationshipTableModel)relationShipTable.getModel()).getIndexOfCol(this.mSrcColumn.getColumnName());
        int n2 = ((RelationshipTableModel)relationShipTable2.getModel()).getIndexOfCol(this.mTargetColumn.getColumnName());
        if (this.mSource.equals(this.mComp1)) {
            this.mPtOrigin = new Point((int)(point.getX() + (double)this.mSource.getWidth()), this.mSource.getY() + 16 * n + 4);
            this.mPtTarget = new Point((int)point2.getX(), this.mTarget.getY() + 16 * n2 + 4);
            this.mPtOrigin = SwingUtilities.convertPoint(relationShipTable, this.mPtOrigin, RelationshipPageUtils.getScrollPane(this.mSource).getViewport());
            this.mPtTarget = SwingUtilities.convertPoint(relationShipTable2, this.mPtTarget, RelationshipPageUtils.getScrollPane(this.mTarget).getViewport());
            if (this.mPtOrigin.getY() - (double)this.mSource.getY() > (double)this.mSource.getBounds().height) {
                this.mPtOrigin = new Point((int)this.mPtOrigin.getX(), this.mSource.getY() + this.mSource.getBounds().height - 8);
            }
            if (this.mPtTarget.getY() - (double)this.mTarget.getY() > (double)this.mTarget.getBounds().height) {
                this.mPtTarget = new Point((int)this.mPtTarget.getX(), this.mTarget.getY() + this.mTarget.getBounds().height - 8);
            }
            if (this.mPtOrigin.getY() < this.mSource.getBounds().getY()) {
                this.mPtOrigin = new Point((int)(point.getX() + (double)this.mSource.getWidth()), this.mSource.getY() + 8);
            }
            if (this.mPtTarget.getY() < this.mTarget.getBounds().getY()) {
                this.mPtTarget = new Point((int)point2.getX(), this.mTarget.getY() + 8);
            }
        } else {
            this.mPtOrigin = new Point((int)(point.getX() + (double)this.mSource.getWidth()), this.mSource.getY() + 16 * n2 + 4);
            this.mPtTarget = new Point((int)point2.getX(), this.mTarget.getY() + 16 * n + 4);
            this.mPtOrigin = SwingUtilities.convertPoint(relationShipTable2, this.mPtOrigin, RelationshipPageUtils.getScrollPane(this.mSource).getViewport());
            this.mPtTarget = SwingUtilities.convertPoint(relationShipTable, this.mPtTarget, RelationshipPageUtils.getScrollPane(this.mTarget).getViewport());
            if (this.mPtOrigin.getY() - (double)this.mSource.getY() > (double)(this.mSource.getBounds().height + 10)) {
                this.mPtOrigin = new Point((int)(point.getX() + (double)this.mSource.getWidth()), this.mSource.getY() + this.mSource.getBounds().height - 8);
            }
            if (this.mPtTarget.getY() - (double)this.mTarget.getY() > (double)(this.mTarget.getBounds().height + 10)) {
                this.mPtTarget = new Point((int)point2.getX(), this.mTarget.getY() + this.mTarget.getBounds().height - 8);
            }
            if (this.mPtOrigin.getY() < this.mSource.getBounds().getY()) {
                this.mPtOrigin = new Point((int)(point.getX() + (double)this.mSource.getWidth()), this.mSource.getY() + 8);
            }
            if (this.mPtTarget.getY() < this.mTarget.getBounds().getY()) {
                this.mPtTarget = new Point((int)point2.getX(), this.mTarget.getY() + 8);
            }
        }
        if (this.mPtOrigin.getX() - (double)this.mSource.getX() != (double)this.mSource.getBounds().width) {
            this.mPtOrigin = new Point(this.mSource.getX() + this.mSource.getBounds().width, (int)this.mPtOrigin.getY());
        }
        if (this.mPtTarget.getX() - (double)this.mTarget.getX() != (double)this.mTarget.getBounds().width) {
            this.mPtTarget = new Point(this.mTarget.getX(), (int)this.mPtTarget.getY());
        }
        this.m_LineDirection = this.mPtOrigin.getY() >= this.mPtTarget.getY() ? 2 : 1;
        if (this.mPtOrigin.getX() > this.mPtTarget.getX()) {
            this.m_LineDirection = this.m_LineDirection == 2 ? 4 : 3;
        }
    }
}

