/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.sort_cases;

import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.drag_drop.ListDragAdapter;
import com.spss.java_client.ui.dialogs.base.file.openquery.AbstractDBWizardCommonPage;
import com.spss.java_client.ui.dialogs.base.file.openquery.NewQueryDlg;
import com.spss.java_client.ui.dialogs.base.file.openquery.define_variables.DefineVarLabelCellRenderer;
import com.spss.java_client.ui.dialogs.base.file.openquery.sort_cases.SortCasesArrowButton;
import com.spss.java_client.ui.dialogs.base.file.openquery.sort_cases.SortCasesListDropListener;
import com.spss.java_client.ui.dialogs.base.file.openquery.sort_cases.SortCasesListModel;
import com.spss.java_client.ui.dialogs.base.file.openquery.sort_cases.SortCasesTableDragAdapter;
import com.spss.java_client.ui.dialogs.base.file.openquery.sort_cases.SortCasesTableDropListener;
import com.spss.java_client.ui.dialogs.base.file.openquery.sort_cases.SortCasesTableModel;
import com.spss.java_client.ui.dialogs.base.file.openquery.sort_cases.SortDataClass;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBListCellRenderer;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBListEntry;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBWizardUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.AggregateColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.AggregatePageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.ComputeNewFieldsPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.ComputedColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.SPSSColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.SPSSUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.Selected;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.SortCasesPageInfo;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public class SortCasesPage
extends AbstractDBWizardCommonPage
implements ActionListener,
ListSelectionListener,
TableModelListener,
FocusListener {
    private DialogFocusTraversalPolicy mPolicy;
    private PlainList mSrcList;
    private PlainTable mSortCasesTable;
    private JScrollPane mTableScroll;
    private ArrayList<String> mDataList;
    private SortCasesArrowButton mListArrow;
    private JButton mUpArrow;
    private JButton mDownArrow;
    private DragPane mDragPane;
    private ListDragAdapter mListAdapter;
    private SortCasesListDropListener mListDropListener;
    private SortCasesTableDragAdapter mTableAdapter;
    private SortCasesTableDropListener mTableDropListener;
    private boolean mIsModified = false;

    public SortCasesPage(BaseWizardDialog baseWizardDialog) {
        super("SortCasesPage", baseWizardDialog, true);
    }

    @Override
    public String getNextPage() {
        return "ResultsPage";
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_sort_cases";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SortCasesTableModel sortCasesTableModel = (SortCasesTableModel)this.mSortCasesTable.getModel();
        int n = this.mSortCasesTable.getSelectedRow();
        if (actionEvent.getActionCommand().equalsIgnoreCase(this.mWizardDialog.getResString("IDS_SORT_CASES_UP_ARROW"))) {
            if (n != 0 && n != -1) {
                SortDataClass sortDataClass = sortCasesTableModel.getValueAtRow(n);
                SortDataClass sortDataClass2 = sortCasesTableModel.getValueAtRow(n - 1);
                sortCasesTableModel.setValueAtRow(n, sortDataClass2);
                sortCasesTableModel.setValueAtRow(n - 1, sortDataClass);
                int n2 = this.mSortCasesTable.getSelectionModel().getMaxSelectionIndex();
                this.mSortCasesTable.getSelectionModel().setSelectionInterval(n2 - 1, n2 - 1);
                sortCasesTableModel.fireTableRowsUpdated(n - 1, n);
            }
        } else if (actionEvent.getActionCommand().equalsIgnoreCase(this.mWizardDialog.getResString("IDS_SORT_CASES_DOWN_ARROW")) && n < sortCasesTableModel.getRowCount() - 1 && n != -1) {
            SortDataClass sortDataClass = sortCasesTableModel.getValueAtRow(n);
            SortDataClass sortDataClass3 = sortCasesTableModel.getValueAtRow(n + 1);
            sortCasesTableModel.setValueAtRow(n, sortDataClass3);
            sortCasesTableModel.setValueAtRow(n + 1, sortDataClass);
            int n3 = this.mSortCasesTable.getSelectionModel().getMaxSelectionIndex();
            this.mSortCasesTable.getSelectionModel().setSelectionInterval(n3 + 1, n3 + 1);
            sortCasesTableModel.fireTableRowsUpdated(n, n + 1);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.mSortCasesTable.getRowCount() > 1) {
            this.mUpArrow.setEnabled(this.mSortCasesTable.getSelectedRow() != 0);
            this.mDownArrow.setEnabled(this.mSortCasesTable.getSelectedRow() != this.mSortCasesTable.getModel().getRowCount() - 1);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.mSortCasesTable.getRowCount() == 0 || this.mSortCasesTable.getRowCount() == 1 || this.mSortCasesTable.getSelectedRow() == -1) {
            this.mUpArrow.setEnabled(false);
            this.mDownArrow.setEnabled(false);
        } else {
            this.mUpArrow.setEnabled(this.mSortCasesTable.getSelectedRow() != 0);
            this.mDownArrow.setEnabled(this.mSortCasesTable.getSelectedRow() != this.mSortCasesTable.getRowCount() - 1);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mSortCasesTable)) {
            this.mTableScroll.setBorder(BorderFactory.createLineBorder(DialogUtil.getFocusBorderColor()));
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mSortCasesTable)) {
            this.mTableScroll.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        }
    }

    @Override
    public boolean validate() {
        this.saveSortData();
        if (this.mIsModified) {
            SPSSUtil.clearResultsPage();
        }
        return super.validate();
    }

    @Override
    public boolean validateOnBack() {
        this.saveSortData();
        return super.validateOnBack();
    }

    private void saveSortData() {
        SortCasesPageInfo sortCasesPageInfo = SortCasesPageInfo.getSortCasesPageInfo();
        SortCasesTableModel sortCasesTableModel = (SortCasesTableModel)this.mSortCasesTable.getModel();
        int n = sortCasesTableModel.getRowCount();
        ArrayList<SortDataClass> arrayList = new ArrayList<SortDataClass>(n);
        for (int i = 0; i < n; ++i) {
            SortDataClass sortDataClass = sortCasesTableModel.getValueAtRow(i);
            arrayList.add(sortDataClass);
        }
        if (!sortCasesPageInfo.getSortData().equals(arrayList)) {
            this.mIsModified = true;
        }
        sortCasesPageInfo.setSortData(arrayList);
    }

    @Override
    protected void aboutToShowPanel() {
        try {
            this.loadData();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!this.useExistingSortPageInfo()) {
            SortCasesTableModel sortCasesTableModel = (SortCasesTableModel)this.mSortCasesTable.getModel();
            ArrayList<SortDataClass> arrayList = sortCasesTableModel.getRows();
            for (SortDataClass sortDataClass : arrayList) {
                sortCasesTableModel.removeElement(sortDataClass);
            }
        }
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mWizardDialog.enableFinish(true);
        this.mSortCasesTable.getColumnModel().getColumn(1).setCellRenderer(new ComboBoxRenderer());
        if (this.mSortCasesTable.getRowCount() > 0) {
            this.mSortCasesTable.setRowSelectionInterval(0, 0);
        }
        this.mSrcList.requestFocus();
        this.mSrcList.setSelectedIndex(0);
        this.addDragAdapters();
    }

    @Override
    protected void aboutToHidePanel() {
        DBWizardUtil.setDBWizardPreviousPage(DBWizardUtil.DBWizardPreviousPage.eSortCases);
        this.removeDragDropListeners();
    }

    @Override
    protected void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcList);
        vector.add(this.mListArrow);
        vector.add(this.mSortCasesTable);
        vector.add(this.mUpArrow);
        vector.add(this.mDownArrow);
        Vector<Object> vector2 = ((NewQueryDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    @Override
    protected JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, n2, 0, n2);
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString("IDS_SORT_CASES_LABEL"));
        jLabel.setFont(jLabel.getFont().deriveFont(1, 18.0f));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JLabel jLabel2 = new JLabel(this.mWizardDialog.getResString("IDS_SORT_CASES_NOTE1"));
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    @Override
    protected void initVars() {
        this.mSrcList = new PlainList("SortCasesPageList", PlainList.DragType.eAutoDragMove);
        this.mSrcList.setDragEnabled(true);
        this.mSrcList.setCellRenderer(new DBListCellRenderer());
        this.mSortCasesTable = new PlainTable();
        this.mSortCasesTable.setModel(new SortCasesTableModel());
        this.mSortCasesTable.getTableHeader().setReorderingAllowed(false);
        this.mSortCasesTable.setSelectionMode(2);
        this.mSortCasesTable.setColumnSelectionAllowed(false);
        this.mSortCasesTable.setRowSelectionAllowed(true);
        String[] stringArray = new String[]{this.mWizardDialog.getResString("IDS_SORT_CASES_TABLE_COLUMN1"), this.mWizardDialog.getResString("IDS_SORT_CASES_TABLE_COLUMN2")};
        ((SortCasesTableModel)this.mSortCasesTable.getModel()).setColumnName(stringArray);
        this.mSortCasesTable.getColumnModel().getColumn(0).setHeaderValue(stringArray[0]);
        this.mSortCasesTable.getColumnModel().getColumn(1).setHeaderValue(stringArray[1]);
        JTableHeader jTableHeader = this.mSortCasesTable.getTableHeader();
        jTableHeader.setFont(jTableHeader.getFont().deriveFont(1, 12.0f));
        this.mSortCasesTable.getColumnModel().getColumn(0).setCellRenderer(new DefineVarLabelCellRenderer());
        Object[] objectArray = new Object[]{this.mWizardDialog.getResString("IDS_SORT_CASES_COMBO_VALUE1"), this.mWizardDialog.getResString("IDS_SORT_CASES_COMBO_VALUE2")};
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        jComboBox.setSelectedIndex(0);
        jComboBox.setBackground(Color.white);
        this.mSortCasesTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(jComboBox));
        this.mListArrow = new SortCasesArrowButton(this.mWizardDialog, SpssArrowButton.ButtonOrientation.right, this.mSrcList, this.mSortCasesTable);
        this.mSortCasesTable.getModel().addTableModelListener(this);
        this.mSortCasesTable.getSelectionModel().addListSelectionListener(this);
        this.mSortCasesTable.getColumnModel().getColumn(0).setPreferredWidth(180);
        this.mSortCasesTable.getColumnModel().getColumn(1).setPreferredWidth(180);
        this.mSortCasesTable.setRowHeight(jComboBox.getMinimumSize().height - 3);
        this.mSortCasesTable.setAutoResizeMode(0);
        this.mSortCasesTable.addFocusListener(this);
        this.mDataList = new ArrayList();
        this.InitButtons();
        this.mDragPane = (DragPane)this.mWizardDialog.getGlassPane();
        this.createDragAdapters(this.mSrcList);
        this.createDragAdapters(this.mSortCasesTable);
    }

    @Override
    protected JPanel setupPageBody() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, n2, 0, n2);
        JScrollPane jScrollPane = new JScrollPane(this.mSrcList);
        jScrollPane.setPreferredSize(this.mSrcList.getMinimumSize());
        jScrollPane.setHorizontalScrollBarPolicy(30);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 0, 1, 4, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.mListArrow, gridBagConstraints, 1, 1, 1, 1, n, null);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.setupTablePanel(), gridBagConstraints, 2, 0, 1, 2, n, insets);
        DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 2, 2, 1, 2, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 10;
        DialogUtil.addUsingGBL(jPanel, this.setupButtonPanel(), gridBagConstraints, 3, 1, 1, 1, n, null);
        n = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.setupNotePanel(), gridBagConstraints, 0, 5, 4, 1, n, insets);
        return jPanel;
    }

    private JPanel setupTablePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_SORT_BEFORE_RETRIEVAL_LABEL");
        jLabel.setLabelFor(this.mSortCasesTable);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mTableScroll = new JScrollPane(this.mSortCasesTable);
        this.mTableScroll.setPreferredSize(new Dimension(300, 200));
        this.mTableScroll.setHorizontalScrollBarPolicy(30);
        DialogUtil.addUsingGBL(jPanel, this.mTableScroll, gridBagConstraints, 0, 1, 1, 4, n, null);
        return jPanel;
    }

    private JPanel setupButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 10;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, this.mUpArrow, gridBagConstraints, 1, 3, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mDownArrow, gridBagConstraints, 1, 4, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupNotePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        JTextArea jTextArea = new JTextArea(this.mWizardDialog.getResString("IDS_SORT_CASES_NOTE2"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        jTextArea.setMinimumSize(new Dimension(400, 50));
        jTextArea.setPreferredSize(new Dimension(400, 50));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void InitButtons() {
        String string = ResUtil.getCommonDlgString("IDS_UP_ARROW_IMAGE");
        URL uRL = ResUtil.getCommonDlgImageResource(string);
        this.mUpArrow = new JButton(new ImageIcon(uRL));
        string = ResUtil.getCommonDlgString("IDS_UP_ARROW_DISABLED_IMAGE");
        uRL = ResUtil.getCommonDlgImageResource(string);
        this.mUpArrow.setDisabledIcon(new ImageIcon(uRL));
        this.mUpArrow.setActionCommand(this.mWizardDialog.getResString("IDS_SORT_CASES_UP_ARROW"));
        this.mUpArrow.setEnabled(this.mSortCasesTable.getModel().getRowCount() > 2);
        this.mUpArrow.setPreferredSize(DialogUtil.getArrowButtonSize());
        this.mUpArrow.addActionListener(this);
        string = ResUtil.getCommonDlgString("IDS_DOWN_ARROW_IMAGE");
        uRL = ResUtil.getCommonDlgImageResource(string);
        this.mDownArrow = new JButton(new ImageIcon(uRL));
        string = ResUtil.getCommonDlgString("IDS_DOWN_ARROW_DISABLED_IMAGE");
        uRL = ResUtil.getCommonDlgImageResource(string);
        this.mDownArrow.setDisabledIcon(new ImageIcon(uRL));
        this.mDownArrow.setActionCommand(this.mWizardDialog.getResString("IDS_SORT_CASES_DOWN_ARROW"));
        this.mDownArrow.setEnabled(this.mSortCasesTable.getModel().getRowCount() > 2);
        this.mDownArrow.setPreferredSize(DialogUtil.getArrowButtonSize());
        this.mDownArrow.addActionListener(this);
    }

    private void loadData() {
        Object object;
        boolean bl;
        ArrayList<DBListEntry> arrayList = new ArrayList<DBListEntry>();
        AggregatePageInfo aggregatePageInfo = AggregatePageInfo.getAggregatePageInfo();
        List<AggregateColumn> list = aggregatePageInfo.getAggregateColumns();
        List<SPSSColumn> list2 = aggregatePageInfo.getBreakColumns();
        boolean bl2 = bl = list.size() > 0 || list2.size() > 0;
        if (bl) {
            DBListEntry dBListEntry;
            for (SPSSColumn sPSSColumn : list2) {
                dBListEntry = new DBListEntry(sPSSColumn, this.mWizardDialog.getResImageURL("IDS_DB_SELECT_DATA_TABLES_IMG"));
                dBListEntry.setUseUserName(true);
                arrayList.add(dBListEntry);
            }
            for (AggregateColumn aggregateColumn : list) {
                dBListEntry = new DBListEntry(aggregateColumn, this.mWizardDialog.getResImageURL("IDS_DB_SELECT_DATA_TABLES_IMG"));
                dBListEntry.setUseUserName(true);
                arrayList.add(dBListEntry);
            }
        } else {
            Comparable comparable;
            object = Selected.getSelected();
            List<SPSSColumn> list3 = ((Selected)object).getSelectedColumns();
            for (SPSSColumn sPSSColumn : list3) {
                comparable = new DBListEntry(sPSSColumn, this.mWizardDialog.getResImageURL("IDS_DB_SELECT_DATA_TABLES_IMG"));
                ((DBListEntry)comparable).setUseUserName(true);
                arrayList.add((DBListEntry)comparable);
            }
            List<ComputedColumn> list4 = ComputeNewFieldsPageInfo.getNewFieldsInfo().getNewColumns();
            Iterator iterator = list4.iterator();
            while (iterator.hasNext()) {
                comparable = (ComputedColumn)iterator.next();
                DBListEntry dBListEntry = new DBListEntry((ODBCColumn)comparable, this.mWizardDialog.getResImageURL("IDS_DB_SELECT_DATA_TABLES_IMG"));
                dBListEntry.setUseUserName(true);
                arrayList.add(dBListEntry);
            }
        }
        object = new SortCasesListModel(arrayList, this.mWizardDialog);
        this.mSrcList.setModel(object);
    }

    private boolean useExistingSortPageInfo() {
        SortCasesPageInfo sortCasesPageInfo = SortCasesPageInfo.getSortCasesPageInfo();
        if (sortCasesPageInfo.isExisting()) {
            SortCasesTableModel sortCasesTableModel = (SortCasesTableModel)this.mSortCasesTable.getModel();
            SortCasesListModel sortCasesListModel = (SortCasesListModel)this.mSrcList.getModel();
            sortCasesTableModel.clear();
            ArrayList<DBListEntry> arrayList = sortCasesListModel.getDataList();
            List<SortDataClass> list = sortCasesPageInfo.getSortData();
            block0: for (SortDataClass sortDataClass : list) {
                sortCasesTableModel.addElement(sortDataClass.getColumn(), sortDataClass.getSortType());
                for (DBListEntry dBListEntry : arrayList) {
                    if (!dBListEntry.getColumn().equals(sortDataClass.getColumn())) continue;
                    arrayList.remove(dBListEntry);
                    continue block0;
                }
            }
            return true;
        }
        return false;
    }

    private void createDragAdapters(Component component) {
        if (component instanceof PlainList) {
            this.mListAdapter = new ListDragAdapter(this.mSrcList, this.mDragPane, "SortCasesPageList");
            DialogUtil.modifyMouseInputListeners(this.mSrcList, this.mListAdapter);
            this.mListDropListener = new SortCasesListDropListener(this.mSrcList, this.mListArrow);
        } else if (component instanceof PlainTable) {
            this.mTableAdapter = new SortCasesTableDragAdapter(this.mSortCasesTable, this.mDragPane, "SortCasesPlainTable");
            DialogUtil.modifyMouseInputListeners(this.mSortCasesTable, this.mTableAdapter);
            this.mTableDropListener = new SortCasesTableDropListener(this.mSortCasesTable, this.mSrcList, this.mListArrow);
        }
    }

    private void addDragAdapters() {
        this.mDragPane.addDropListener((IDropListener)this.mListDropListener);
        this.mDragPane.addDropListener((IDropListener)this.mTableDropListener);
    }

    private void removeDragDropListeners() {
        this.mDragPane.removeDropListener((IDropListener)this.mListDropListener);
        this.mDragPane.removeDropListener((IDropListener)this.mTableDropListener);
    }

    private class ComboBoxRenderer
    extends DefaultTableCellRenderer {
        private ComboBoxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String[] stringArray = new String[]{object.toString()};
            JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
            jComboBox.setEditable(true);
            if (bl) {
                Border border = UIManager.getBorder("Table.focusCellHighlightBorder");
                jComboBox.setBorder(border);
            } else {
                LineBorder lineBorder = new LineBorder(Color.GRAY);
                jComboBox.setBorder(lineBorder);
            }
            return jComboBox;
        }
    }
}

