/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.sort_cases;

import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.drag_drop.ListDragAdapter;
import com.spss.java_client.ui.dialogs.base.file.openquery.sort_cases.SortCasesArrowButton;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class SortCasesListDropListener
implements IDropListener,
ActionListener {
    private static final int AUTOSCROLL_INSET = 10;
    protected static Cursor sSwapCursor = null;
    private PlainList mDropTarget = null;
    private Timer mTimer = null;
    private Point mLastPosition = null;
    private Rectangle mOuterRect = new Rectangle();
    private Rectangle mInnerRect = new Rectangle();
    private int mHysteresis = 10;
    private boolean mCanImport = false;
    private SortCasesArrowButton mArrowButton;

    public SortCasesListDropListener(PlainList plainList, SortCasesArrowButton sortCasesArrowButton) {
        this.mDropTarget = plainList;
        this.mArrowButton = sortCasesArrowButton;
    }

    public Cursor dragItemOver(Point point, DragDropAdapter dragDropAdapter) {
        Cursor cursor = null;
        if (!(dragDropAdapter instanceof ListDragAdapter)) {
            return cursor;
        }
        Point point2 = (Point)point.clone();
        SwingUtilities.convertPointFromScreen(point2, this.mDropTarget);
        if (this.contains(point)) {
            this.mCanImport = this.canDrop(dragDropAdapter);
            if (this.mCanImport) {
                cursor = Cursor.getPredefinedCursor(12);
            } else {
                this.mDropTarget.showDropFeedback(null);
                cursor = DragPane.getNoDropCursor();
            }
        } else {
            this.mDropTarget.showDropFeedback(null);
        }
        if (this.mCanImport) {
            this.checkAutoScroll(point2);
        }
        return cursor;
    }

    public boolean contains(Point point) {
        Point point2 = (Point)point.clone();
        SwingUtilities.convertPointFromScreen(point2, this.mDropTarget);
        return this.mDropTarget.getVisibleRect().contains(point2);
    }

    public boolean canDrop(DragDropAdapter dragDropAdapter) {
        PlainList.TransferData transferData;
        Object[] objectArray;
        boolean bl = false;
        if (!(this.mDropTarget.isEnabled() && this.mDropTarget.isShowing() && this.mDropTarget.isDragSupported())) {
            return bl;
        }
        Object object = dragDropAdapter.getTransferData();
        if (object instanceof PlainTable.TransferData) {
            PlainTable.TransferData transferData2 = (PlainTable.TransferData)object;
            Vector<Object[]> vector = transferData2.getVectorData();
            if (vector != null && vector.size() > 0 && this.mDropTarget instanceof PlainList) {
                bl = true;
            }
        } else if (object instanceof PlainList.TransferData && (objectArray = (transferData = (PlainList.TransferData)object).getVariables()) != null && objectArray.length > 0) {
            bl = true;
        }
        return bl;
    }

    public void itemDropped(DropEvent dropEvent) {
        boolean bl;
        Component component = dropEvent.getSource();
        boolean bl2 = bl = this.contains(dropEvent.getDropLocation()) && this.canDrop(dropEvent.getDragSourceAdapter());
        if (bl && this.mDropTarget != null && component instanceof PlainTable) {
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            this.mArrowButton.doClick();
        }
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        this.updateAutoscrollRegion(this.mDropTarget);
        Rectangle rectangle = (Rectangle)this.mInnerRect.clone();
        rectangle.grow(-this.mHysteresis, -this.mHysteresis);
        if (this.mLastPosition != null && this.pointWithin(this.mLastPosition, this.mOuterRect) && !this.pointWithin(this.mLastPosition, rectangle)) {
            this.autoscroll(this.mDropTarget, this.mLastPosition);
        }
    }

    void updateAutoscrollRegion(JComponent jComponent) {
        int n;
        Rectangle rectangle = jComponent.getVisibleRect();
        this.mInnerRect.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Insets insets = new Insets(0, 0, 0, 0);
        if (jComponent instanceof Scrollable) {
            n = 20;
            if (rectangle.width >= n) {
                insets.right = 10;
                insets.left = 10;
            }
            if (rectangle.height >= n) {
                insets.bottom = 10;
                insets.top = 10;
            }
        }
        n = rectangle.x;
        int n2 = rectangle.y;
        this.mOuterRect.setBounds(rectangle.x - insets.left, rectangle.y - insets.top, n + rectangle.width + insets.right, n2 + rectangle.height + insets.bottom);
    }

    void autoscroll(JComponent jComponent, Point point) {
        if (jComponent instanceof Scrollable) {
            int n;
            Rectangle rectangle;
            Scrollable scrollable = (Scrollable)((Object)jComponent);
            if (point.y < this.mInnerRect.y + this.mHysteresis) {
                rectangle = this.mDropTarget.getVisibleRect();
                n = scrollable.getScrollableUnitIncrement(rectangle, 1, -1);
                Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y - n, rectangle.width, n);
                jComponent.scrollRectToVisible(rectangle2);
                this.mLastPosition.y -= n;
            } else if (point.y > this.mInnerRect.y + this.mInnerRect.height - this.mHysteresis) {
                rectangle = this.mDropTarget.getVisibleRect();
                n = scrollable.getScrollableUnitIncrement(rectangle, 1, 1);
                Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y + rectangle.height, rectangle.width, n);
                jComponent.scrollRectToVisible(rectangle3);
                this.mLastPosition.y += n;
            }
            if (point.x < this.mInnerRect.x) {
                int n2 = scrollable.getScrollableUnitIncrement(this.mInnerRect, 0, -1);
                Rectangle rectangle4 = new Rectangle(this.mInnerRect.x - n2, this.mInnerRect.y, n2, this.mInnerRect.height);
                jComponent.scrollRectToVisible(rectangle4);
                this.mLastPosition.x -= n2;
            } else if (point.x > this.mInnerRect.x + this.mInnerRect.width) {
                int n3 = scrollable.getScrollableUnitIncrement(this.mInnerRect, 0, 1);
                Rectangle rectangle5 = new Rectangle(this.mInnerRect.x + this.mInnerRect.width, this.mInnerRect.y, n3, this.mInnerRect.height);
                jComponent.scrollRectToVisible(rectangle5);
                this.mLastPosition.x += n3;
            }
        }
    }

    private boolean pointWithin(Point point, Rectangle rectangle) {
        return point.x > rectangle.x && point.y > rectangle.y && point.x < rectangle.width && point.y < rectangle.height;
    }

    private boolean dropOnSource(PlainList plainList, int n, int[] nArray, Point point) {
        boolean bl;
        boolean bl2 = bl = plainList == this.mDropTarget && nArray != null;
        if (bl) {
            boolean bl3;
            boolean bl4 = bl3 = n >= nArray[0] && n <= nArray[nArray.length - 1];
            if (!bl3) {
                boolean bl5 = this.mDropTarget.itemInUpperHalf(point);
                if (n == nArray[0] - 1) {
                    bl3 = !bl5;
                } else if (n == nArray[nArray.length - 1] + 1) {
                    bl3 = bl5;
                }
            }
            if (bl3) {
                return true;
            }
        }
        return false;
    }

    private void importData(Object[] objectArray, PlainList plainList, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAutoScroll(Point point) {
        if (this.mDropTarget instanceof PlainList || !this.mDropTarget.getAutoscrolls()) {
            return;
        }
        if (this.mLastPosition == null) {
            if (this.mDropTarget.contains(point)) {
                this.mLastPosition = point.getLocation();
                this.updateAutoscrollRegion(this.mDropTarget);
                this.initPropertiesIfNecessary();
            }
        } else {
            SortCasesListDropListener sortCasesListDropListener = this;
            synchronized (sortCasesListDropListener) {
                if (Math.abs(point.x - this.mLastPosition.x) > this.mHysteresis || Math.abs(point.y - this.mLastPosition.y) > this.mHysteresis) {
                    if (this.mTimer.isRunning()) {
                        this.mTimer.stop();
                    }
                    this.mLastPosition = null;
                } else {
                    if (!this.mTimer.isRunning()) {
                        this.mTimer.start();
                    }
                    this.mLastPosition = point;
                }
            }
        }
    }

    private void initPropertiesIfNecessary() {
        if (this.mTimer == null) {
            Integer n = 100;
            Integer n2 = 100;
            this.mTimer = new Timer(n2, this);
            this.mTimer.setCoalesce(true);
            this.mTimer.setInitialDelay(n);
        }
    }

    private void finish(PlainList plainList, int n, int[] nArray, int n2) {
        try {
            int n3;
            DefaultListModel defaultListModel = (DefaultListModel)plainList.getModel();
            if (n > 0 && this.mDropTarget == plainList) {
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    if (nArray[n3] <= n2) continue;
                    int n4 = n3;
                    nArray[n4] = nArray[n4] + n;
                }
            }
            if (this.mDropTarget == plainList) {
                if (this.mDropTarget instanceof PlainList || this.mDropTarget.isDataSource()) {
                    return;
                }
                for (n3 = nArray.length - 1; n3 >= 0; --n3) {
                    defaultListModel.removeElementAt(nArray[n3]);
                }
            } else if (plainList instanceof PlainList && !plainList.isDataSource()) {
                for (n3 = nArray.length - 1; n3 >= 0; --n3) {
                    defaultListModel.removeElementAt(nArray[n3]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

