/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.sort_cases;

import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.dialogs.base.file.openquery.sort_cases.SortCasesListModel;
import com.spss.java_client.ui.dialogs.base.file.openquery.sort_cases.SortCasesTableModel;
import com.spss.java_client.ui.dialogs.base.file.openquery.sort_cases.SortDataClass;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBListEntry;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.SPSSColumn;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import javax.swing.JList;
import javax.swing.JTable;

public class SortCasesArrowButton
extends SpssArrowButton
implements FocusListener {
    private JList mList = new JList();
    private JTable mTable = null;
    private BaseWizardDialog mParent;

    public SortCasesArrowButton(BaseWizardDialog baseWizardDialog, SpssArrowButton.ButtonOrientation buttonOrientation, JList jList, JTable jTable) {
        super(buttonOrientation);
        this.mList = jList;
        this.mTable = jTable;
        this.mList.setModel(jList.getModel());
        this.mList.addFocusListener(this);
        this.mTable.addFocusListener(this);
        this.mParent = baseWizardDialog;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SortCasesTableModel sortCasesTableModel = (SortCasesTableModel)this.mTable.getModel();
        SortCasesListModel sortCasesListModel = (SortCasesListModel)this.mList.getModel();
        if (this.mArrowOrientation == SpssArrowButton.ButtonOrientation.right) {
            Object[] objectArray = this.mList.getSelectedValues();
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    SPSSColumn sPSSColumn = (SPSSColumn)((DBListEntry)objectArray[i]).getColumn();
                    sortCasesTableModel.addElement(sPSSColumn, 1);
                    sortCasesListModel.removeElement(objectArray[i]);
                    this.mTable.requestFocus();
                    this.mTable.getSelectionModel().setSelectionInterval(sortCasesTableModel.getRowCount() - 1, sortCasesTableModel.getRowCount() - 1);
                    this.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
                }
            }
        } else if (this.mArrowOrientation == SpssArrowButton.ButtonOrientation.left) {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int[] nArray = new int[]{};
            int n = 0;
            if (this.mTable.getSelectedRowCount() > 0) {
                int[] nArray2 = this.mTable.getSelectedRows();
                nArray = new int[nArray2.length];
                for (int i = 0; i < nArray2.length; ++i) {
                    SortDataClass sortDataClass = sortCasesTableModel.getValueAtRow(nArray2[i]);
                    object = new SortDataClass(sortDataClass.getColumn(), sortDataClass.getSortType());
                    arrayList.add(object);
                }
            }
            for (SortDataClass sortDataClass : arrayList) {
                sortCasesTableModel.removeElement(sortDataClass);
                object = sortDataClass.getColumn();
                sortCasesListModel.addElement((SPSSColumn)object);
                nArray[n++] = sortCasesListModel.indexOf(object);
            }
            this.mList.setSelectedIndices(nArray);
            if (sortCasesTableModel.getRowCount() != 0) {
                this.mTable.getSelectionModel().setSelectionInterval(sortCasesTableModel.getRowCount() - 1, sortCasesTableModel.getRowCount() - 1);
            }
            this.mList.requestFocus();
            this.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        }
    }

    public void setArrowButtonOrientation(SpssArrowButton.ButtonOrientation buttonOrientation) {
        this.mArrowOrientation = buttonOrientation;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            if (focusEvent.getComponent() instanceof JList && this.getArrowOrientation().equals((Object)SpssArrowButton.ButtonOrientation.left)) {
                this.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            } else if (focusEvent.getComponent() instanceof JTable && this.getArrowOrientation().equals((Object)SpssArrowButton.ButtonOrientation.right)) {
                this.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            }
        }
    }

    @Override
    protected void updateEnable(SpssArrowButton.SrcDestHolder srcDestHolder) {
    }
}

