/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.select_data;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.ArrowButton;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.file.openquery.AbstractDBWizardCommonPage;
import com.spss.java_client.ui.dialogs.base.file.openquery.NewQueryDlg;
import com.spss.java_client.ui.dialogs.base.file.openquery.select_data.DBSelectDataTransferable;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.MDIDesktopPane;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBListEntry;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBSelectDataListFocusRenderer;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBTreeRenderer;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBWizardUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.gui.ColumnWrapper;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.gui.TableWrapper;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBC;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCTable;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.SPSSColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.SPSSUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.Selected;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SelectDataPage
extends AbstractDBWizardCommonPage
implements TreeSelectionListener,
ItemListener,
TreeExpansionListener,
KeyListener,
MouseListener,
FocusListener,
ActionListener,
ListDataListener,
ListSelectionListener {
    private static String IDS_UP_STR = "UP";
    private static String IDS_DOWN_STR = "DOWN";
    private DialogFocusTraversalPolicy mPolicy;
    private JScrollPane mTreePane;
    private JTree mTree;
    private DefaultTreeModel mTreeModel;
    private DefaultMutableTreeNode mTreeNode;
    private PlainList mTargetList;
    private DefaultListModel mListModel;
    private DBSelectDataTransferable mTransferable;
    private DBTreeTransferHandler mTransferHandler;
    private JCheckBox mSortFields;
    private JCheckBox mTablesCheck;
    private JCheckBox mViewsCheck;
    private JCheckBox mSynonymsCheck;
    private JCheckBox mSystemTablesCheck;
    private DropTarget mListTarget;
    private DropTarget mTreeTarget;
    private ArrayList<DefaultMutableTreeNode> mRemovedTreeNodeList;
    private ArrayList<String> mExpandedNodes;
    private ArrowButton mArrowButton;
    private JButton mUpArrow;
    private JButton mDownArrow;
    private BufferedImage mDragImage;
    private Point mOffsetPoint;
    private boolean mIsModified;
    private JScrollPane mListScroll;
    private ArrayList<String> mSupportSelection;
    private boolean bTableLoaded = false;

    public SelectDataPage(BaseWizardDialog baseWizardDialog) {
        super("SelectDataPage", baseWizardDialog, true);
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTree.getLastSelectedPathComponent();
        if (itemEvent.getSource().equals(this.mSortFields)) {
            this.doSortSelected();
        } else if (itemEvent.getSource().equals(this.mTablesCheck) || itemEvent.getSource().equals(this.mViewsCheck) || itemEvent.getSource().equals(this.mSynonymsCheck) || itemEvent.getSource().equals(this.mSystemTablesCheck)) {
            this.doItemStateChange();
            if (this.mSortFields.isSelected()) {
                this.doSortSelected();
            }
            if (((DefaultMutableTreeNode)this.mTree.getModel().getRoot()).getChildCount() > 0) {
                this.mTree.setSelectionInterval(0, 0);
            }
        }
        if (defaultMutableTreeNode != null && defaultMutableTreeNode.toString().length() > 0) {
            int n = 0;
            boolean bl = false;
            for (String string : this.mSupportSelection) {
                if (string.equals(defaultMutableTreeNode.toString())) {
                    bl = true;
                    break;
                }
                ++n;
            }
            this.mTree.removeTreeSelectionListener(this);
            this.mTree.removeTreeExpansionListener(this);
            if (bl) {
                this.mTree.setSelectionRow(n);
            } else {
                this.mTree.setSelectionRow(0);
            }
            this.mTree.addTreeSelectionListener(this);
            this.mTree.addTreeExpansionListener(this);
        }
        this.mWizardDialog.enableNext(this.mTargetList.getModel().getSize() > 0);
        this.mWizardDialog.enableFinish(this.mTargetList.getModel().getSize() > 0);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        int n = this.mTree.getRowForPath(treeExpansionEvent.getPath());
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
        ODBCTable oDBCTable = ((TableWrapper)defaultMutableTreeNode.getUserObject()).getTable();
        this.mExpandedNodes.add(oDBCTable.getQualifiedName());
        ODBC oDBC = ODBC.getODBC();
        List<ODBCColumn> list = oDBC.getColumns(oDBCTable.getQualifiedName());
        if (defaultMutableTreeNode.getLevel() > 1) {
            return;
        }
        if (list.size() <= 0 && defaultMutableTreeNode.getLevel() == 1) {
            String string = oDBCTable.getName().contains("?") ? this.mWizardDialog.getResString("ERR_DB_SELECT_DATA_BAD_TRANSCODE") : String.format(this.mWizardDialog.getResString("ERR_DB_SELECT_DATA_TABLE_HAS_NO_CHILDRENS_MSG"), defaultMutableTreeNode.toString());
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), string, this.mWizardDialog.getResString("IDS_DB_SELECT_DATA_WARNING_TITLE"));
            this.mRemovedTreeNodeList.add(defaultMutableTreeNode);
            this.removeTablesWithoutChildrens();
            this.expandSelectedNodes();
        }
        this.getChildrenForNode(defaultMutableTreeNode);
        this.mTree.setSelectionRow(n);
    }

    private ODBCTable nodeToTable(DefaultMutableTreeNode defaultMutableTreeNode) {
        return ((TableWrapper)defaultMutableTreeNode.getUserObject()).getTable();
    }

    private List<ODBCColumn> nodeToColumns(DefaultMutableTreeNode defaultMutableTreeNode) {
        ODBC oDBC = ODBC.getODBC();
        ODBCTable oDBCTable = this.nodeToTable(defaultMutableTreeNode);
        return oDBC.getColumns(oDBCTable.getQualifiedName());
    }

    private void getChildrenForNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i));
        }
        this.addColumnsToNode(this.nodeToColumns(defaultMutableTreeNode), defaultMutableTreeNode);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.mTree.getModel();
        for (DefaultMutableTreeNode defaultMutableTreeNode2 : arrayList) {
            defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode2);
        }
    }

    private void addColumnsToNode(List<ODBCColumn> list, DefaultMutableTreeNode defaultMutableTreeNode) {
        ArrayList<ODBCColumn> arrayList = new ArrayList<ODBCColumn>(list);
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.mTree.getModel();
        if (this.mSortFields.isSelected()) {
            Collections.sort(arrayList);
        }
        for (ODBCColumn oDBCColumn : arrayList) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new ColumnWrapper(oDBCColumn));
            defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeExpansionEvent.getPath().getLastPathComponent();
        assert (defaultMutableTreeNode.getLevel() == 1);
        this.mExpandedNodes.remove(this.nodeToTable(defaultMutableTreeNode).getQualifiedName());
        this.mTree.collapsePath(treeExpansionEvent.getPath());
    }

    @Override
    public String getNextPage() {
        Selected selected = Selected.getSelected();
        if (selected.getSelectedTables().size() > 1) {
            return "SpecifyRelationshipsPage";
        }
        boolean bl = DataServerProxy.getDataProxy().isRemoteConnection();
        if (bl) {
            return "ComputeNewFieldsPage";
        }
        return "LimitRetrievedCasesPage";
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public boolean validateOnBack() {
        this.mTree.setModel(null);
        return true;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_tableselect";
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.getSource().equals(this.mTree)) {
            this.mTargetList.removeSelectionInterval(0, this.mTargetList.getModel().getSize() - 1);
        }
        this.mTree.setSelectionPath(treeSelectionEvent.getNewLeadSelectionPath());
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            if (keyEvent.getSource().equals(this.mTree)) {
                this.moveNodesToList(null);
            } else if (keyEvent.getSource().equals(this.mTargetList)) {
                this.removeElementFromList();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
            if (mouseEvent.getSource().equals(this.mTree)) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode != null) {
                    if (defaultMutableTreeNode.getLevel() == 1) {
                        this.moveNodesToList(null);
                    }
                    if (defaultMutableTreeNode.getLevel() == 2) {
                        this.moveNodesToList(null);
                    }
                }
            } else if (mouseEvent.getSource().equals(this.mTargetList)) {
                this.removeElementFromList();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Border border = UIManager.getBorder("Table.focusCellHighlightBorder");
        if (focusEvent.getSource().equals(this.mTree)) {
            this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTree.getLastSelectedPathComponent();
            if (defaultMutableTreeNode != null) {
                if (defaultMutableTreeNode.getLevel() > 0) {
                    this.mArrowButton.setEnabled(true);
                    this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
                } else {
                    this.mArrowButton.setEnabled(false);
                }
            }
            this.mTreePane.setBorder(border);
        } else if (focusEvent.getSource().equals(this.mTargetList)) {
            this.mTargetList.setCellRenderer(new DBSelectDataListFocusRenderer());
            if (this.mTargetList.getModel().getSize() == 0) {
                this.mArrowButton.setEnabled(false);
            } else {
                this.mArrowButton.setEnabled(true);
                this.mArrowButton.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            }
            this.mTargetList.setSelectedIndices(this.mTargetList.getSelectedIndices());
            this.mListScroll.setBorder(border);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        LineBorder lineBorder = new LineBorder(Color.GRAY);
        if (focusEvent.getSource().equals(this.mTargetList)) {
            this.mListScroll.setBorder(lineBorder);
        } else if (focusEvent.getSource().equals(this.mTree)) {
            this.mTreePane.setBorder(lineBorder);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        DefaultListModel defaultListModel = (DefaultListModel)this.mTargetList.getModel();
        int[] nArray = this.mTargetList.getSelectedIndices();
        int n2 = nArray.length;
        boolean bl = false;
        if (actionEvent.getActionCommand().equalsIgnoreCase(IDS_UP_STR)) {
            for (n = 0; n < n2; ++n) {
                DBListEntry dBListEntry = (DBListEntry)defaultListModel.getElementAt(nArray[n]);
                defaultListModel.removeElementAt(nArray[n]);
                defaultListModel.insertElementAt(dBListEntry, nArray[n] - 1);
                nArray[n] = nArray[n] - 1;
            }
            this.mTargetList.setSelectedIndices(nArray);
            if (nArray[0] > 0) {
                this.mUpArrow.requestFocus();
            } else {
                this.mTargetList.requestFocus();
            }
            bl = true;
        } else if (actionEvent.getActionCommand().equalsIgnoreCase(IDS_DOWN_STR)) {
            for (n = n2 - 1; n >= 0; --n) {
                DBListEntry dBListEntry = (DBListEntry)defaultListModel.getElementAt(nArray[n]);
                defaultListModel.removeElementAt(nArray[n]);
                defaultListModel.insertElementAt(dBListEntry, nArray[n] + 1);
                nArray[n] = nArray[n] + 1;
            }
            this.mTargetList.setSelectedIndices(nArray);
            if (nArray[n2 - 1] + 1 < this.mTargetList.getModel().getSize()) {
                this.mDownArrow.requestFocus();
            } else {
                this.mTargetList.requestFocus();
            }
            bl = true;
        }
        if (bl) {
            Rectangle rectangle = this.mTargetList.getCellBounds(nArray[0] - 1, nArray[n2 - 1] + 2);
            if (rectangle != null) {
                this.mTargetList.scrollRectToVisible(rectangle);
            } else {
                this.mTargetList.ensureIndexIsVisible(nArray[0]);
            }
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.enableArrowButtons(listDataEvent);
        this.enableCmdPanelButtons();
        this.mIsModified = true;
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableArrowButtons(listDataEvent);
        this.enableCmdPanelButtons();
        this.mIsModified = true;
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableArrowButtons(listDataEvent);
        this.enableCmdPanelButtons();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.mTargetList.equals(listSelectionEvent.getSource())) {
            int[] nArray = this.mTargetList.getSelectedIndices();
            int n = nArray.length;
            this.mUpArrow.setEnabled(true);
            this.mDownArrow.setEnabled(true);
            if (n > 0 && n == nArray[n - 1] - nArray[0] + 1) {
                if (nArray[0] == 0) {
                    this.mUpArrow.setEnabled(false);
                }
                if (nArray[n - 1] + 1 == this.mTargetList.getModel().getSize()) {
                    this.mDownArrow.setEnabled(false);
                }
            } else {
                this.mUpArrow.setEnabled(false);
                this.mDownArrow.setEnabled(false);
            }
        }
    }

    @Override
    public boolean validate() {
        this.doFiltering();
        if (!DBWizardUtil.getDBWizardPreviousPage().equals((Object)DBWizardUtil.DBWizardPreviousPage.eWelcome) && this.mIsModified) {
            SPSSUtil.clearRelationShipPage();
        }
        return super.validate();
    }

    @Override
    protected JPanel setupPageBody() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, n2, 0, n2);
        insets.left = 0;
        DialogUtil.addUsingGBL(jPanel, this.treePanel(), gridBagConstraints, 0, 0, 6, 5, n, insets);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        insets.left = n2;
        gridBagConstraints.fill = 0;
        insets.top = n2 / 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mSortFields, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.left = n2 * 2;
        insets.top = n2 / 2 + 1;
        DialogUtil.addUsingGBL(jPanel2, new JLabel(this.mWizardDialog.getResString("IDS_DB_SELECT_DATA_SHOW_LABEL")), gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.left = n2;
        insets.top = n2 / 2;
        DialogUtil.addUsingGBL(jPanel2, this.mTablesCheck, gridBagConstraints, 2, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mViewsCheck, gridBagConstraints, 3, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mSynonymsCheck, gridBagConstraints, 4, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel2, this.mSystemTablesCheck, gridBagConstraints, 5, 0, 1, 1, n, insets);
        gridBagConstraints = new GridBagConstraints();
        insets = new Insets(n2, n2, 0, n2);
        insets.left = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 5, 1, 1, n, insets);
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        if (DataServerProxy.getDataProxy().isRemoteConnection()) {
            jLabel.setText(this.mWizardDialog.getResString("IDS_DB_SELECT_DATA_SERVER_BOTTOM_TIP1"));
            jLabel2.setText(this.mWizardDialog.getResString("IDS_DB_SELECT_DATA_SERVER_BOTTOM_TIP2"));
        } else {
            jLabel.setText("");
            jLabel2.setText("");
        }
        insets.left = n2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 6, 5, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 7, 5, 1, n, insets);
        return jPanel;
    }

    @Override
    protected void aboutToShowPanel() {
        super.aboutToShowPanel();
        ODBC oDBC = ODBC.getODBC();
        this.mTree.removeAll();
        this.buildTree();
        this.setTableTypes();
        if (this.mSortFields.isSelected()) {
            this.doSortSelected();
        }
        this.removeTablesWithoutChildrens();
        this.expandSelectedNodes();
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        boolean bl = true;
        if (DBWizardUtil.getDBWizardPreviousPage().equals((Object)DBWizardUtil.DBWizardPreviousPage.eWelcome)) {
            this.mExpandedNodes.clear();
            this.mTreeModel.reload();
            this.mListModel.removeAllElements();
            this.mTargetList.setModel(this.mListModel);
            bl = false;
        }
        if (((DefaultMutableTreeNode)this.mTree.getModel().getRoot()).getChildCount() > 0) {
            this.mTree.setSelectionInterval(0, 0);
        }
        this.mIsModified = false;
        DBWizardUtil.setDBWizardPreviousPage(DBWizardUtil.DBWizardPreviousPage.eSelectData);
        this.enableCmdPanelButtons();
        this.enableFinishButton(bl);
        this.mTree.requestFocus();
    }

    @Override
    protected void aboutToHidePanel() {
        super.aboutToHidePanel();
        DBWizardUtil.setDBWizardPreviousPage(DBWizardUtil.DBWizardPreviousPage.eSelectData);
    }

    @Override
    protected void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mTree);
        vector.add(this.mArrowButton);
        vector.add(this.mTargetList);
        vector.add(this.mUpArrow);
        vector.add(this.mDownArrow);
        vector.add(this.mSortFields);
        vector.add(this.mTablesCheck);
        vector.add(this.mViewsCheck);
        vector.add(this.mSynonymsCheck);
        vector.add(this.mSystemTablesCheck);
        Vector<Object> vector2 = ((NewQueryDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    @Override
    protected JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 4;
        Insets insets = new Insets(n2, n2, 0, n2);
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString("IDS_DB_SELECT_DATA_HEAD_LABEL"));
        jLabel.setFont(jLabel.getFont().deriveFont(1, 18.0f));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JTextArea jTextArea = new JTextArea(this.mWizardDialog.getResString("IDS_DB_SELECT_DATA_LABEL"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        jTextArea.setMinimumSize(new Dimension(400, 30));
        jTextArea.setPreferredSize(new Dimension(400, 30));
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JLabel jLabel2 = new JLabel(this.mWizardDialog.getResString("IDS_DB_SELECT_DATA_TIP_LABEL"));
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        jPanel.setTransferHandler(this.mTransferHandler);
        return jPanel;
    }

    @Override
    protected void initVars() {
        this.mTransferHandler = new DBTreeTransferHandler();
        this.mWizardPage.setTransferHandler(this.mTransferHandler);
        DropTarget dropTarget = new DropTarget(this.mWizardPage, this.mTransferHandler);
        this.mWizardPage.setDropTarget(dropTarget);
        this.mTargetList = new PlainList("SelectDataPlainList");
        this.mOffsetPoint = new Point();
        this.mTargetList.setTransferHandler(this.mTransferHandler);
        this.mListModel = new DefaultListModel();
        this.mListModel.addListDataListener(this);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_DB_SELECT_DATA_SORT_FIELD_NAME_CHECK");
        this.mSortFields = new JCheckBox(toggleButtonAction);
        this.mSortFields.addItemListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_DB_SELECT_DATA_TABLE_CHECK");
        this.mTablesCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_DB_SELECT_DATA_VIEWS_CHECK");
        this.mViewsCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_DB_SELECT_DATA_SYNONYMS_CHECK");
        this.mSynonymsCheck = new JCheckBox(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_DB_SELECT_DATA_SYSTEM_TABLES_CHECK");
        this.mSystemTablesCheck = new JCheckBox(toggleButtonAction);
        this.mTablesCheck.addItemListener(this);
        this.mViewsCheck.addItemListener(this);
        this.mSynonymsCheck.addItemListener(this);
        this.mSystemTablesCheck.addItemListener(this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mTablesCheck);
        spssButtonGroup.add(this.mViewsCheck);
        spssButtonGroup.add(this.mSynonymsCheck);
        spssButtonGroup.add(this.mSystemTablesCheck);
        this.mTargetList.setModel(this.mListModel);
        this.mTargetList.setDragEnabled(true);
        this.mListTarget = new DropTarget(this.mTargetList, this.mTransferHandler);
        this.mTargetList.setDropTarget(this.mListTarget);
        this.mTargetList.addKeyListener(this);
        this.mTargetList.addMouseListener(this);
        this.mTargetList.addFocusListener(this);
        this.mTargetList.addListSelectionListener(this);
        this.mTree = new JTree();
        this.mTree.setModel(null);
        ToolTipManager.sharedInstance().registerComponent(this.mTree);
        this.mTreeTarget = new DropTarget(this.mTree, this.mTransferHandler);
        this.mTree.setDropTarget(this.mTreeTarget);
        this.mTree.addTreeSelectionListener(this);
        this.mTree.addTreeExpansionListener(this);
        this.mTree.addKeyListener(this);
        this.mTree.addMouseListener(this);
        this.mTree.addFocusListener(this);
        this.mTree.setToggleClickCount(100);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setOpenIcon(new ImageIcon(this.mWizardDialog.getResImageURL("IDS_DB_SELECT_DATA_TABLES_IMG")));
        defaultTreeCellRenderer.setClosedIcon(new ImageIcon(this.mWizardDialog.getResImageURL("IDS_DB_SELECT_DATA_TABLES_IMG")));
        defaultTreeCellRenderer.setLeafIcon(new ImageIcon(this.mWizardDialog.getResImageURL("IDS_DB_SELECT_DATA_COLUMNS_IMG")));
        this.mTree.setCellRenderer(new DBTreeRenderer(this.mWizardDialog));
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(1);
        this.mTree.setSelectionModel(defaultTreeSelectionModel);
        this.mRemovedTreeNodeList = new ArrayList();
        this.mExpandedNodes = new ArrayList();
        this.mIsModified = false;
        this.mArrowButton = new ArrowButton(SpssArrowButton.ButtonOrientation.right){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                if (this.getArrowOrientation().equals((Object)SpssArrowButton.ButtonOrientation.left)) {
                    SelectDataPage.this.removeElementFromList();
                } else if (this.getArrowOrientation().equals((Object)SpssArrowButton.ButtonOrientation.right) && ((DefaultMutableTreeNode)(object = (DefaultMutableTreeNode)SelectDataPage.this.mTree.getLastSelectedPathComponent())).getLevel() > 0) {
                    SelectDataPage.this.moveNodesToList(null);
                }
                object = this.getArrowOrientation() == SpssArrowButton.ButtonOrientation.left ? SpssArrowButton.ButtonOrientation.right : SpssArrowButton.ButtonOrientation.left;
                this.setArrowOrientation((SpssArrowButton.ButtonOrientation)((Object)object));
            }
        };
        this.initButtons();
    }

    private void setTableTypes() {
        this.mTablesCheck.setSelected(false);
        this.mTablesCheck.setEnabled(false);
        this.mViewsCheck.setSelected(false);
        this.mViewsCheck.setEnabled(false);
        this.mSynonymsCheck.setSelected(false);
        this.mSynonymsCheck.setEnabled(false);
        this.mSystemTablesCheck.setSelected(false);
        this.mSystemTablesCheck.setEnabled(false);
        String string = Selected.getSelected().getSelectedTableTypes();
        if (string.contains("User")) {
            this.mTablesCheck.setEnabled(true);
            this.mTablesCheck.setSelected(true);
        }
        if (string.contains("View")) {
            this.mViewsCheck.setEnabled(true);
            this.mViewsCheck.setSelected(true);
        }
        if (string.contains("Synonym")) {
            this.mSynonymsCheck.setEnabled(true);
            this.mSynonymsCheck.setSelected(true);
        }
        if (string.contains("System")) {
            this.mSystemTablesCheck.setEnabled(true);
            this.mSystemTablesCheck.setSelected(true);
        }
    }

    private void expandSelectedNodes() {
        this.mTree.removeTreeExpansionListener(this);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTree.getModel().getRoot();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!this.mExpandedNodes.contains(this.nodeToTable(defaultMutableTreeNode2).getQualifiedName())) continue;
            this.getChildrenForNode(defaultMutableTreeNode2);
            TreePath treePath = new TreePath(defaultMutableTreeNode2.getPath());
            this.mTree.expandPath(treePath);
        }
        this.mTree.addTreeExpansionListener(this);
    }

    private void doItemStateChange() {
        boolean bl = this.mTablesCheck.isSelected();
        boolean bl2 = this.mSynonymsCheck.isSelected();
        boolean bl3 = this.mSystemTablesCheck.isSelected();
        boolean bl4 = this.mViewsCheck.isSelected();
        boolean bl5 = bl || bl2 || bl3 || bl4;
        this.buildTree();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTreeModel.getRoot();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        HashSet<Object> hashSet = new HashSet<Object>();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            assert (defaultMutableTreeNode2.getLevel() == 1);
            Object object = this.nodeToTable(defaultMutableTreeNode2);
            if (!bl && ((ODBCTable)object).isUserType()) {
                hashSet.add(defaultMutableTreeNode2);
            }
            if (!bl4 && ((ODBCTable)object).isViewType()) {
                hashSet.add(defaultMutableTreeNode2);
            }
            if (!bl3 && ((ODBCTable)object).isSystemType()) {
                hashSet.add(defaultMutableTreeNode2);
            }
            if (!bl2 && ((ODBCTable)object).isSynonymType()) {
                hashSet.add(defaultMutableTreeNode2);
            }
            for (DefaultMutableTreeNode defaultMutableTreeNode3 : this.mRemovedTreeNodeList) {
                if (!this.nodeToTable(defaultMutableTreeNode3).getQualifiedName().equals(((ODBCTable)object).getQualifiedName())) continue;
                hashSet.add(defaultMutableTreeNode2);
            }
        }
        for (Object object : hashSet) {
            this.mTreeModel.removeNodeFromParent((MutableTreeNode)object);
            this.mExpandedNodes.remove(this.nodeToTable((DefaultMutableTreeNode)object).getQualifiedName());
        }
        this.mTree.setModel(this.mTreeModel);
        if (!bl5) {
            this.mTree.removeAll();
        }
        this.mArrowButton.setEnabled(bl5 && ((DefaultMutableTreeNode)this.mTree.getModel().getRoot()).getChildCount() > 0);
        this.expandSelectedNodes();
    }

    private void doSortSelected() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTree.getModel().getRoot();
        int n = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            boolean bl = this.mTree.isExpanded(this.nodeToPath(defaultMutableTreeNode2));
            if (!bl) continue;
            this.getChildrenForNode(defaultMutableTreeNode2);
        }
    }

    private TreePath nodeToPath(DefaultMutableTreeNode defaultMutableTreeNode) {
        return new TreePath(defaultMutableTreeNode.getPath());
    }

    private JPanel treePanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_DB_SELECT_DATA_AVAILABEL_LABEL");
        JLabel jLabel2 = DialogUtil.createLabel(this.mWizardDialog, "IDS_DB_SELECT_DATA_FIELD_ORDER_LABEL");
        this.mTree.setRootVisible(false);
        this.mTree.setShowsRootHandles(true);
        jLabel.setLabelFor(this.mTree);
        jLabel2.setLabelFor(this.mTargetList);
        this.mListScroll = new JScrollPane(this.mTargetList);
        this.mListScroll.setMinimumSize(new Dimension(200, 150));
        this.mListScroll.setPreferredSize(new Dimension(200, 150));
        this.mTreePane = new JScrollPane(this.mTree);
        this.mTreePane.setMinimumSize(new Dimension(200, 150));
        this.mTreePane.setPreferredSize(new Dimension(200, 150));
        Insets insets = new Insets(0, n2, 0, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 4, 0, 1, 1, n, insets);
        insets.bottom = n2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTreePane, gridBagConstraints, 0, 1, 3, 3, n, insets);
        gridBagConstraints.fill = 0;
        insets.top = -2;
        insets.left = n2;
        insets.right = n2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mArrowButton, gridBagConstraints, 3, 3, 1, 1, n, insets);
        insets.top = 0;
        insets.right = 3;
        insets.left = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mListScroll, gridBagConstraints, 4, 1, 3, 3, n, insets);
        insets.top = n2 * 5;
        insets.left = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mUpArrow, gridBagConstraints, 7, 2, 1, 1, n, insets);
        insets.top = n2 + 2;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mDownArrow, gridBagConstraints, 7, 3, 1, 1, n, insets);
        return jPanel;
    }

    private boolean isUnimportableType(String string) {
        return string != null && (string.equalsIgnoreCase("LONGBINARY") || string.equalsIgnoreCase("image"));
    }

    private void doFiltering() {
        Selected selected = Selected.getSelected();
        StringBuffer stringBuffer = new StringBuffer();
        List<ODBCColumn> list = this.getColumnsFromTargetList(stringBuffer);
        ArrayList<SPSSColumn> arrayList = new ArrayList<SPSSColumn>(list.size());
        HashSet<String> hashSet = new HashSet<String>(list.size());
        for (ODBCColumn oDBCColumn : list) {
            String string = SPSSUtil.generateValidSpssName(oDBCColumn.getColumnName());
            int n = 1;
            while (!hashSet.add(string)) {
                string = SPSSUtil.generateValidSpssName(oDBCColumn.getColumnName() + n);
                ++n;
            }
            SPSSColumn sPSSColumn = new SPSSColumn(oDBCColumn, string);
            arrayList.add(sPSSColumn);
        }
        selected.setSelectedColumns(arrayList);
        if (stringBuffer.length() > 0) {
            String string = String.format(this.mWizardDialog.getResString("ERR_DB_FIELDS_UNKNOWN_TYPE"), stringBuffer.toString());
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), string, this.mWizardDialog.getResString("IDS_DBWIZARD_WARNING_TITLE"));
        }
    }

    private List<ODBCColumn> getColumnsFromTargetList(StringBuffer stringBuffer) {
        int n = this.mListModel.getSize();
        ArrayList<ODBCColumn> arrayList = new ArrayList<ODBCColumn>(n);
        for (int i = 0; i < n; ++i) {
            DBListEntry dBListEntry = (DBListEntry)this.mListModel.getElementAt(i);
            ODBCColumn oDBCColumn = dBListEntry.getColumn();
            String string = oDBCColumn.getColumnName();
            if (this.isUnimportableType(dBListEntry.getTypeName())) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(string);
                this.mListModel.removeElementAt(i);
                --n;
                --i;
                continue;
            }
            arrayList.add(oDBCColumn);
        }
        return arrayList;
    }

    private void buildTree() {
        this.mTree.setDragEnabled(true);
        this.mTree.setTransferHandler(this.mTransferHandler);
        this.mTreeNode = new DefaultMutableTreeNode("ROOT");
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("LEAF");
        this.mTreeNode.add(defaultMutableTreeNode);
        this.mTreeModel = new DefaultTreeModel(this.mTreeNode);
        this.mTree.getSelectionModel().setSelectionMode(4);
        DragSource dragSource = DragSource.getDefaultDragSource();
        DragGestureRecognizer dragGestureRecognizer = dragSource.createDefaultDragGestureRecognizer(this.mTree, 3, this.mTransferHandler);
        DragGestureRecognizer dragGestureRecognizer2 = dragSource.createDefaultDragGestureRecognizer(this.mTargetList, 3, this.mTransferHandler);
        DragGestureRecognizer dragGestureRecognizer3 = dragSource.createDefaultDragGestureRecognizer(this.mWizardPage, 0, this.mTransferHandler);
        dragGestureRecognizer.setSourceActions(dragGestureRecognizer.getSourceActions() & 0xFFFFFFFB);
        dragGestureRecognizer2.setSourceActions(dragGestureRecognizer.getSourceActions() & 0xFFFFFFFB);
        dragGestureRecognizer3.setSourceActions(dragGestureRecognizer.getSourceActions() & 0xFFFFFFFB);
        this.mTree.setModel(this.mTreeModel);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode();
        this.mSupportSelection = new ArrayList();
        ODBC oDBC = ODBC.getODBC();
        List<ODBCTable> list = oDBC.getTables();
        for (ODBCTable oDBCTable : list) {
            if (oDBCTable.isUserType()) {
                if (!this.mTablesCheck.isSelected()) continue;
                this.addNewNode(defaultMutableTreeNode2, oDBCTable);
                continue;
            }
            if (oDBCTable.isViewType()) {
                if (!this.mViewsCheck.isSelected()) continue;
                this.addNewNode(defaultMutableTreeNode2, oDBCTable);
                continue;
            }
            if (oDBCTable.isSynonymType()) {
                if (!this.mSynonymsCheck.isSelected()) continue;
                this.addNewNode(defaultMutableTreeNode2, oDBCTable);
                continue;
            }
            if (!oDBCTable.isSystemType() || !this.mSystemTablesCheck.isSelected()) continue;
            this.addNewNode(defaultMutableTreeNode2, oDBCTable);
        }
        Collections.sort(this.mSupportSelection, new ListComparator());
        this.mTreeModel = new DefaultTreeModel(defaultMutableTreeNode2);
        this.mTree.setModel(this.mTreeModel);
        this.mTree.setLargeModel(true);
        Graphics graphics = this.mTree.getGraphics();
        int n = graphics.getFontMetrics().getHeight();
        this.mTree.setRowHeight(n + 3);
        this.mTree.requestFocus();
    }

    private void addNewNode(DefaultMutableTreeNode defaultMutableTreeNode, ODBCTable oDBCTable) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new TableWrapper(oDBCTable));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode());
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.mSupportSelection.add(oDBCTable.getQualifiedName());
    }

    private boolean isElementExistinList(ODBCColumn oDBCColumn) {
        return this.findElementinList(oDBCColumn) != -1;
    }

    private int findElementinList(ODBCColumn oDBCColumn) {
        for (int i = 0; i < this.mListModel.getSize(); ++i) {
            DBListEntry dBListEntry = (DBListEntry)this.mListModel.elementAt(i);
            if (dBListEntry.getColumn() != oDBCColumn) continue;
            return i;
        }
        return -1;
    }

    private boolean isSameTableNodeinList(String string) {
        for (int i = 0; i < this.mListModel.getSize(); ++i) {
            DBListEntry dBListEntry = (DBListEntry)this.mListModel.elementAt(i);
            if (!dBListEntry.getColumn().getTable().getQualifiedName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private void removeTablesWithoutChildrens() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTreeModel.getRoot();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        int[] nArray = this.mTree.getSelectionRows();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!this.mRemovedTreeNodeList.contains(defaultMutableTreeNode2)) continue;
            defaultMutableTreeNode.remove(defaultMutableTreeNode2);
        }
        this.mTreeModel.setRoot(defaultMutableTreeNode);
        this.mTree.setModel(this.mTreeModel);
        if (nArray != null) {
            this.mTree.setSelectionInterval(nArray[0], nArray[0]);
        }
    }

    private Object[] findNode(String string, String string2) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTree.getModel().getRoot();
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            ODBCTable oDBCTable = this.nodeToTable(defaultMutableTreeNode2);
            String string3 = oDBCTable.getQualifiedName();
            if (!string3.equals(string)) continue;
            Object[] objectArray = defaultMutableTreeNode2.getPath();
            if (!this.mTree.isExpanded(new TreePath(objectArray))) {
                return defaultMutableTreeNode2.getPath();
            }
            Enumeration<TreeNode> enumeration2 = defaultMutableTreeNode2.children();
            while (enumeration2.hasMoreElements()) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration2.nextElement();
                ODBCColumn oDBCColumn = ((ColumnWrapper)defaultMutableTreeNode3.getUserObject()).getColumn();
                String string4 = oDBCColumn.getColumnName();
                if (!string4.equals(string2)) continue;
                return defaultMutableTreeNode3.getPath();
            }
        }
        return null;
    }

    private void removeElementFromList() {
        int n = 0;
        Object[] objectArray = this.mTargetList.getSelectedValues();
        TreePath[] treePathArray = new TreePath[objectArray.length];
        for (Object object : objectArray) {
            DBListEntry dBListEntry = (DBListEntry)object;
            this.mListModel.removeElement(object);
            treePathArray[n] = new TreePath(this.findNode(dBListEntry.getColumn().getTable().getQualifiedName(), dBListEntry.getColumn().getColumnName()));
            ++n;
        }
        this.enableFinishButton(false);
        if (n > 0) {
            this.mTree.requestFocus();
            this.mTree.setSelectionPaths(treePathArray);
        }
    }

    private void moveAllChildrens(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        Object object;
        if (this.removeTablesWithoutColumns(defaultMutableTreeNode)) {
            return;
        }
        assert (defaultMutableTreeNode.getLevel() == 1);
        List<ODBCColumn> list = this.nodeToColumns(defaultMutableTreeNode);
        ArrayList<ODBCColumn> arrayList = new ArrayList<ODBCColumn>(list.size());
        boolean bl = false;
        for (ODBCColumn oDBCColumn : list) {
            if (oDBCColumn.hasTranscodingErrors()) {
                bl = true;
                continue;
            }
            arrayList.add(oDBCColumn);
        }
        if (bl && !ComponentState.isUnicodeServer()) {
            object = this.mWizardDialog.getResString("ERR_DB_SELECT_DATA_BAD_TRANSCODE");
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), (String)object, this.mWizardDialog.getResString("IDS_DB_SELECT_DATA_WARNING_TITLE"));
        }
        object = new int[arrayList.size()];
        int n2 = 0;
        for (ODBCColumn oDBCColumn : arrayList) {
            DBListEntry dBListEntry = new DBListEntry(oDBCColumn, this.mWizardDialog.getResImageURL("IDS_DB_SELECT_DATA_COLUMNS_IMG"));
            if (!this.isElementExistinList(oDBCColumn)) {
                this.mListModel.insertElementAt(dBListEntry, n++);
            }
            object[n2] = this.mListModel.indexOf(dBListEntry);
            ++n2;
        }
        this.enableFinishButton(false);
        this.mTargetList.setSelectedIndices((int[])object);
        this.mTargetList.setCellRenderer(new DBSelectDataListFocusRenderer());
        this.mTargetList.requestFocus();
    }

    private void moveLeafNode(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        assert (defaultMutableTreeNode.getLevel() == 2);
        ODBCColumn oDBCColumn = ((ColumnWrapper)defaultMutableTreeNode.getUserObject()).getColumn();
        if (oDBCColumn.hasTranscodingErrors()) {
            String string = this.mWizardDialog.getResString("ERR_DB_SELECT_DATA_BAD_TRANSCODE");
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), string, this.mWizardDialog.getResString("IDS_DB_SELECT_DATA_WARNING_TITLE"));
            return;
        }
        DBListEntry dBListEntry = new DBListEntry(oDBCColumn, this.mWizardDialog.getResImageURL("IDS_DB_SELECT_DATA_COLUMNS_IMG"));
        if (!this.isElementExistinList(oDBCColumn)) {
            this.mListModel.insertElementAt(dBListEntry, n);
            this.mTargetList.setSelectedIndex(this.findElementinList(oDBCColumn));
            this.enableFinishButton(false);
        } else {
            this.mTargetList.setSelectedIndex(this.findElementinList(oDBCColumn));
        }
        this.mTargetList.setCellRenderer(new DBSelectDataListFocusRenderer());
        this.mTargetList.requestFocus();
    }

    private void initButtons() {
        String string = ResUtil.getCommonDlgString("IDS_UP_ARROW_IMAGE");
        URL uRL = ResUtil.getCommonDlgImageResource(string);
        this.mUpArrow = new JButton(new ImageIcon(uRL));
        string = ResUtil.getCommonDlgString("IDS_UP_ARROW_DISABLED_IMAGE");
        uRL = ResUtil.getCommonDlgImageResource(string);
        this.mUpArrow.setDisabledIcon(new ImageIcon(uRL));
        this.mUpArrow.setActionCommand(IDS_UP_STR);
        this.mUpArrow.setEnabled(this.mTargetList.getModel().getSize() > 2);
        this.mUpArrow.setPreferredSize(DialogUtil.getArrowButtonSize());
        this.mUpArrow.addActionListener(this);
        string = ResUtil.getCommonDlgString("IDS_DOWN_ARROW_IMAGE");
        uRL = ResUtil.getCommonDlgImageResource(string);
        this.mDownArrow = new JButton(new ImageIcon(uRL));
        string = ResUtil.getCommonDlgString("IDS_DOWN_ARROW_DISABLED_IMAGE");
        uRL = ResUtil.getCommonDlgImageResource(string);
        this.mDownArrow.setDisabledIcon(new ImageIcon(uRL));
        this.mDownArrow.setActionCommand(IDS_DOWN_STR);
        this.mDownArrow.setEnabled(this.mTargetList.getModel().getSize() > 2);
        this.mDownArrow.setPreferredSize(DialogUtil.getArrowButtonSize());
        this.mDownArrow.addActionListener(this);
    }

    private void moveNodesToList(Point point) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mTree.getLastSelectedPathComponent();
        this.mTargetList.setCellRenderer(new DBSelectDataListFocusRenderer());
        if (defaultMutableTreeNode == null) {
            return;
        }
        ODBC oDBC = ODBC.getODBC();
        if (defaultMutableTreeNode.isLeaf()) {
            if (defaultMutableTreeNode.getParent() != null) {
                if (!oDBC.isUseODBC()) {
                    if (this.mTargetList.getModel().getSize() > 0) {
                        if (this.isSameTableNodeinList(defaultMutableTreeNode.getParent().toString())) {
                            int n = point != null ? this.mTargetList.locationToIndex(point) : this.mTargetList.getModel().getSize();
                            int n2 = this.mTargetList.getModel().getSize();
                            if (n < 0) {
                                n = n2;
                            } else {
                                if (point != null && !this.mTargetList.itemInUpperHalf(point)) {
                                    ++n;
                                }
                                if (n > n2) {
                                    n = n2;
                                }
                            }
                            this.moveLeafNode(defaultMutableTreeNode, n);
                        }
                    } else {
                        ODBCColumn oDBCColumn = ((ColumnWrapper)defaultMutableTreeNode.getUserObject()).getColumn();
                        DBListEntry dBListEntry = new DBListEntry(oDBCColumn, this.mWizardDialog.getResImageURL("IDS_DB_SELECT_DATA_COLUMNS_IMG"));
                        this.mListModel.addElement(dBListEntry);
                        this.mTargetList.setSelectedIndex(this.findElementinList(oDBCColumn));
                    }
                } else {
                    int n = point != null ? this.mTargetList.locationToIndex(point) : this.mTargetList.getModel().getSize();
                    int n3 = this.mTargetList.getModel().getSize();
                    if (n < 0) {
                        n = n3;
                    } else {
                        if (point != null && !this.mTargetList.itemInUpperHalf(point)) {
                            ++n;
                        }
                        if (n > n3) {
                            n = n3;
                        }
                    }
                    this.moveLeafNode(defaultMutableTreeNode, n);
                }
            }
        } else {
            int n = point != null ? this.mTargetList.locationToIndex(point) : this.mTargetList.getModel().getSize();
            int n4 = this.mTargetList.getModel().getSize();
            if (n < 0) {
                n = n4;
            } else {
                if (point != null && !this.mTargetList.itemInUpperHalf(point)) {
                    ++n;
                }
                if (n > n4) {
                    n = n4;
                }
            }
            if (ODBC.getODBC().isUseODBC()) {
                this.moveAllChildrens(defaultMutableTreeNode, n);
            } else if (this.mTargetList.getModel().getSize() > 0) {
                if (this.isSameTableNodeinList(defaultMutableTreeNode.toString())) {
                    this.moveAllChildrens(defaultMutableTreeNode, n);
                }
            } else {
                this.moveAllChildrens(defaultMutableTreeNode, n);
            }
        }
    }

    private void enableArrowButtons(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mListModel)) {
            int[] nArray = this.mTargetList.getSelectedIndices();
            int n = nArray.length;
            this.mUpArrow.setEnabled(true);
            this.mDownArrow.setEnabled(true);
            if (n > 0 && n == nArray[n - 1] - nArray[0] + 1) {
                if (nArray[0] == 0) {
                    this.mUpArrow.setEnabled(false);
                }
                if (nArray[n - 1] + 1 == this.mTargetList.getModel().getSize()) {
                    this.mDownArrow.setEnabled(false);
                }
            } else {
                this.mUpArrow.setEnabled(false);
                this.mDownArrow.setEnabled(false);
            }
        }
    }

    private void enableCmdPanelButtons() {
        boolean bl = this.mTargetList.getModel().getSize() > 0;
        this.mWizardDialog.enableNext(bl);
    }

    private void enableFinishButton(boolean bl) {
        if (this.mTargetList.getModel().getSize() < 1) {
            this.mWizardDialog.enableFinish(false);
            return;
        }
        List<ODBCColumn> list = this.getColumnsFromTargetList(new StringBuffer());
        List<ODBCTable> list2 = this.getTablesFromColumns(list);
        if (list2.size() == 1) {
            this.mWizardDialog.enableFinish(true);
            return;
        }
        if (bl) {
            this.mWizardDialog.enableFinish(MDIDesktopPane.getAllConnectors().size() > 0);
            return;
        }
        if (this.canJoinTables(list2)) {
            this.mWizardDialog.enableFinish(true);
            return;
        }
        this.mWizardDialog.enableFinish(false);
    }

    private List<ODBCTable> getTablesFromColumns(List<ODBCColumn> list) {
        ArrayList<ODBCTable> arrayList = new ArrayList<ODBCTable>();
        for (ODBCColumn oDBCColumn : list) {
            if (arrayList.contains(oDBCColumn.getTable())) continue;
            arrayList.add(oDBCColumn.getTable());
        }
        return arrayList;
    }

    private boolean canJoinTables(List<ODBCTable> list) {
        for (int i = 0; i < list.size(); ++i) {
            for (int j = i + 1; j < list.size(); ++j) {
                boolean bl = this.checkSimilarColumns(list.get(i), list.get(j));
                if (bl) continue;
                return false;
            }
        }
        this.mWizardDialog.enableFinish(true);
        return true;
    }

    private boolean checkSimilarColumns(ODBCTable oDBCTable, ODBCTable oDBCTable2) {
        ODBC oDBC = ODBC.getODBC();
        List<ODBCColumn> list = oDBC.getColumns(oDBCTable.getQualifiedName());
        List<ODBCColumn> list2 = oDBC.getColumns(oDBCTable2.getQualifiedName());
        int n = list.size();
        int n2 = list2.size();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (list.get(i).getDataType() != list2.get(j).getDataType()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean removeTablesWithoutColumns(DefaultMutableTreeNode defaultMutableTreeNode) {
        List<ODBCColumn> list;
        if (defaultMutableTreeNode.getLevel() == 1 && (list = this.nodeToColumns(defaultMutableTreeNode)).size() == 0) {
            ODBCTable oDBCTable = this.nodeToTable(defaultMutableTreeNode);
            String string = oDBCTable.getQualifiedName().contains("?") ? this.mWizardDialog.getResString("ERR_DB_SELECT_DATA_BAD_TRANSCODE") : String.format(this.mWizardDialog.getResString("ERR_DB_SELECT_DATA_TABLE_HAS_NO_CHILDRENS_MSG"), oDBCTable.getQualifiedName());
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), string, this.mWizardDialog.getResString("IDS_DB_SELECT_DATA_WARNING_TITLE"));
            this.mTree.removeTreeSelectionListener(this);
            this.mRemovedTreeNodeList.add(defaultMutableTreeNode);
            this.removeTablesWithoutChildrens();
            this.mTree.addTreeSelectionListener(this);
            return true;
        }
        return false;
    }

    private class ListComparator
    implements Comparator<String> {
        private ListComparator() {
        }

        @Override
        public int compare(String string, String string2) {
            if (string != null && string2 != null) {
                if (string.startsWith("'")) {
                    string = string.substring(1);
                }
                if (string2.startsWith("'")) {
                    string2 = string2.substring(1);
                }
                return string.compareToIgnoreCase(string2);
            }
            if (string == null && string2 == null) {
                return 0;
            }
            return -1;
        }
    }

    class DBTreeTransferHandler
    extends TransferHandler
    implements DropTargetListener,
    DragGestureListener,
    DragSourceListener {
        private TreePath mTreePathLast = null;
        private Rectangle2D mRectDragImage = new Rectangle2D.Float();

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 2;
        }

        @Override
        public boolean importData(JComponent jComponent, Transferable transferable) {
            return true;
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            Point point = dropTargetDragEvent.getLocation();
            if (dropTargetDragEvent.getSource().equals(SelectDataPage.this.mTreeTarget) && SelectDataPage.this.mTree.contains(point)) {
                TreePath treePath;
                Graphics2D graphics2D = (Graphics2D)SelectDataPage.this.mTree.getGraphics();
                if (!DragSource.isDragImageSupported()) {
                    SelectDataPage.this.mTree.paintImmediately(this.mRectDragImage.getBounds());
                    this.mRectDragImage.setRect(point.x - ((SelectDataPage)SelectDataPage.this).mOffsetPoint.x, point.y - ((SelectDataPage)SelectDataPage.this).mOffsetPoint.y, SelectDataPage.this.mDragImage.getWidth(), SelectDataPage.this.mDragImage.getHeight());
                    graphics2D.drawImage(SelectDataPage.this.mDragImage, AffineTransform.getTranslateInstance(this.mRectDragImage.getX(), this.mRectDragImage.getY()), null);
                }
                if ((treePath = SelectDataPage.this.mTree.getClosestPathForLocation(point.x, point.y)) != this.mTreePathLast) {
                    this.mTreePathLast = treePath;
                }
            } else if (dropTargetDragEvent.getSource().equals(SelectDataPage.this.mListTarget) && SelectDataPage.this.mTargetList.contains(point)) {
                Graphics2D graphics2D = (Graphics2D)SelectDataPage.this.mTargetList.getGraphics();
                if (!DragSource.isDragImageSupported()) {
                    SelectDataPage.this.mTargetList.validate();
                    SelectDataPage.this.mTargetList.paintImmediately(this.mRectDragImage.getBounds());
                    this.mRectDragImage.setRect(point.x - ((SelectDataPage)SelectDataPage.this).mOffsetPoint.x, point.y - ((SelectDataPage)SelectDataPage.this).mOffsetPoint.y, SelectDataPage.this.mDragImage.getWidth(), SelectDataPage.this.mDragImage.getHeight());
                    graphics2D.drawImage(SelectDataPage.this.mDragImage, AffineTransform.getTranslateInstance(this.mRectDragImage.getX(), this.mRectDragImage.getY()), null);
                }
            } else {
                Graphics2D graphics2D = (Graphics2D)SelectDataPage.this.mWizardPage.getGraphics();
                if (!DragSource.isDragImageSupported()) {
                    SelectDataPage.this.mWizardPage.paintImmediately(this.mRectDragImage.getBounds());
                    this.mRectDragImage.setRect(point.x - ((SelectDataPage)SelectDataPage.this).mOffsetPoint.x, point.y - ((SelectDataPage)SelectDataPage.this).mOffsetPoint.y, SelectDataPage.this.mDragImage.getWidth(), SelectDataPage.this.mDragImage.getHeight());
                    graphics2D.drawImage(SelectDataPage.this.mDragImage, AffineTransform.getTranslateInstance(this.mRectDragImage.getX(), this.mRectDragImage.getY()), null);
                }
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
            if (!DragSource.isDragImageSupported()) {
                SelectDataPage.this.mTree.repaint(this.mRectDragImage.getBounds());
                SelectDataPage.this.mTargetList.repaint(this.mRectDragImage.getBounds());
                SelectDataPage.this.mWizardPage.repaint(this.mRectDragImage.getBounds());
            }
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (dropTargetDropEvent.getDropTargetContext().getDropTarget().equals(SelectDataPage.this.mListTarget)) {
                SelectDataPage.this.moveNodesToList(dropTargetDropEvent.getLocation());
            } else if (dropTargetDropEvent.getDropTargetContext().getDropTarget().equals(SelectDataPage.this.mTreeTarget)) {
                SelectDataPage.this.removeElementFromList();
            } else {
                SelectDataPage.this.mWizardPage.repaint(this.mRectDragImage.getBounds());
            }
            dropTargetDropEvent.dropComplete(true);
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            Object object;
            Point point = dragGestureEvent.getDragOrigin();
            boolean bl = dragGestureEvent.getComponent().equals(SelectDataPage.this.mTree);
            boolean bl2 = dragGestureEvent.getComponent().equals(SelectDataPage.this.mTargetList);
            if (bl) {
                object = SelectDataPage.this.mTree.getPathForLocation(point.x, point.y);
                if (object == null) {
                    return;
                }
                Rectangle rectangle = SelectDataPage.this.mTree.getPathBounds((TreePath)object);
                SelectDataPage.this.mOffsetPoint.setLocation(point.x - rectangle.x, point.y - rectangle.y);
                JLabel jLabel = (JLabel)SelectDataPage.this.mTree.getCellRenderer().getTreeCellRendererComponent(SelectDataPage.this.mTree, ((TreePath)object).getLastPathComponent(), false, SelectDataPage.this.mTree.isExpanded((TreePath)object), SelectDataPage.this.mTree.getModel().isLeaf(((TreePath)object).getLastPathComponent()), 0, false);
                jLabel.setSize((int)rectangle.getWidth(), (int)rectangle.getHeight());
                SelectDataPage.this.mDragImage = new BufferedImage((int)rectangle.getWidth(), (int)rectangle.getHeight(), 3);
                Graphics2D graphics2D = SelectDataPage.this.mDragImage.createGraphics();
                graphics2D.setComposite(AlphaComposite.getInstance(2, 0.5f));
                jLabel.paint(graphics2D);
                Icon icon = jLabel.getIcon();
                int n = icon == null ? 0 : icon.getIconWidth() + jLabel.getIconTextGap();
                graphics2D.setComposite(AlphaComposite.getInstance(4, 0.5f));
                graphics2D.setPaint(new GradientPaint(n, 0.0f, SystemColor.controlShadow, SelectDataPage.this.mTree.getWidth(), 0.0f, new Color(255, 255, 255, 0)));
                graphics2D.fillRect(n, 0, SelectDataPage.this.mTree.getWidth(), SelectDataPage.this.mDragImage.getHeight());
                graphics2D.dispose();
                SelectDataPage.this.mTree.setSelectionPath((TreePath)object);
                SelectDataPage.this.mTransferable = new DBSelectDataTransferable(SelectDataPage.this.mTreeNode.getUserObject().toString());
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)SelectDataPage.this.mTree.getLastSelectedPathComponent();
                if (defaultMutableTreeNode.getLevel() == 1 && SelectDataPage.this.removeTablesWithoutColumns(defaultMutableTreeNode)) {
                    return;
                }
            } else if (bl2) {
                object = SelectDataPage.this.mTargetList.getSelectedIndices();
                Rectangle rectangle = SelectDataPage.this.mTargetList.getCellBounds((int)object[0], (int)object[((Object)object).length - 1]);
                SelectDataPage.this.mOffsetPoint.setLocation(point.x - rectangle.x, point.y - rectangle.y);
                Object[] objectArray = SelectDataPage.this.mTargetList.getSelectedValues();
                Dimension dimension = new Dimension(((SelectDataPage)SelectDataPage.this).mTargetList.getCellBounds((int)object[0], (int)object[((Object)object).length - 1]).width, SelectDataPage.this.mTargetList.getFixedCellHeight());
                boolean bl3 = ((Object)object).length > 10;
                int n = !bl3 ? ((Object)object).length : 10;
                Dimension dimension2 = new Dimension(dimension.width, dimension.height * n);
                if (bl3) {
                    dimension2.height += dimension.height;
                }
                SelectDataPage.this.mTargetList.getSelectedValue();
                SelectDataPage.this.mDragImage = new BufferedImage(dimension2.width, dimension2.height, 3);
                Graphics2D graphics2D = SelectDataPage.this.mDragImage.createGraphics();
                graphics2D.setClip(0, 0, dimension2.width, dimension2.height);
                Point point2 = new Point(0, 0);
                for (int i = 0; i < n; ++i) {
                    JLabel jLabel = (JLabel)SelectDataPage.this.mTargetList.getCellRenderer().getListCellRendererComponent(SelectDataPage.this.mTargetList, objectArray[i], (int)object[i], false, false);
                    jLabel.setLocation(new Point(0, 0));
                    jLabel.setSize(dimension.width, dimension.height);
                    graphics2D.setComposite(AlphaComposite.getInstance(2, 0.5f));
                    boolean bl4 = jLabel.isOpaque();
                    jLabel.setOpaque(false);
                    jLabel.paint(graphics2D);
                    jLabel.setOpaque(bl4);
                    graphics2D.translate(0, dimension.height);
                    point2.y += dimension.height;
                }
                if (bl3) {
                    String string = ResUtil.getCommonDlgString("IDS_MORE_ELLIPSIS");
                    graphics2D.setFont(SelectDataPage.this.mTargetList.getFont());
                    graphics2D.drawString(string, 2, 14);
                }
                graphics2D.dispose();
                SelectDataPage.this.mTargetList.setSelectedIndices((int[])object);
                SelectDataPage.this.mTransferable = new DBSelectDataTransferable(((DBListEntry)SelectDataPage.this.mTargetList.getSelectedValue()).getText());
            }
            object = Cursor.getPredefinedCursor(12);
            try {
                dragGestureEvent.startDrag((Cursor)object, SelectDataPage.this.mDragImage, new Point(5, 5), SelectDataPage.this.mTransferable, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            if (dragSourceDragEvent.getDragSourceContext().getComponent().equals(SelectDataPage.this.mTree) && (defaultMutableTreeNode = (DefaultMutableTreeNode)SelectDataPage.this.mTree.getLastSelectedPathComponent()) != null && defaultMutableTreeNode.getLevel() == 1) {
                SelectDataPage.this.removeTablesWithoutColumns(defaultMutableTreeNode);
            }
        }

        @Override
        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            Point point = dragSourceDragEvent.getLocation();
            Component component = dragSourceDragEvent.getDragSourceContext().getComponent();
            Point point2 = SelectDataPage.this.mTargetList.getLocationOnScreen();
            Point point3 = SelectDataPage.this.mTree.getLocationOnScreen();
            if (point.getX() >= point2.getX() && point.getX() <= point2.getX() + (double)SelectDataPage.this.mTargetList.getWidth() && point.getY() >= point2.getY() && point.getY() <= point2.getY() + (double)SelectDataPage.this.mTargetList.getHeight() || point.getX() >= point3.getX() && point.getX() <= point3.getX() + (double)SelectDataPage.this.mTree.getWidth() && point.getY() >= point3.getY() && point.getY() <= point3.getY() + (double)SelectDataPage.this.mTree.getHeight()) {
                dragSourceDragEvent.getDragSourceContext().setCursor(Cursor.getPredefinedCursor(12));
                component.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultCopyNoDrop);
                component.setCursor(DragSource.DefaultCopyNoDrop);
            }
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }

        @Override
        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            if (dragSourceDropEvent.getDropSuccess()) {
                SelectDataPage.this.mTree.getParent().repaint();
            }
        }
    }
}

