/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.results;

import com.spss.java_client.ui.dialogs.base.file.openquery.limit_retrieved_cases.PromptValuesData;
import com.spss.java_client.ui.dialogs.base.file.res.FileResBundle;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class SetPromptValueDialog
extends BaseDialog
implements ActionListener {
    private JButton mOkButton;
    private JButton mCancelButton;
    private JComboBox mComboBox;
    private JTextField mValueEditField;
    private JLabel mPromptLabel;
    private String mSelectedString;
    private String mDefaultValue;
    private boolean mListValues;
    private static PromptValuesData mPromptValuesData;

    public SetPromptValueDialog(SpssFrame spssFrame) {
        super((JFrame)spssFrame, true, ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), FileResBundle.getImageFolder());
        this.setLocationRelativeTo(spssFrame);
        this.setVisible(true);
    }

    public String getSelectedValue() {
        return this.mSelectedString;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.mCancelButton)) {
            this.mSelectedString = null;
            this.dispose();
        } else if (actionEvent.getSource().equals(this.mOkButton)) {
            this.mSelectedString = this.mListValues ? (String)this.mComboBox.getSelectedItem() : this.mValueEditField.getText();
            if (this.mSelectedString == null) {
                this.mSelectedString = this.mDefaultValue;
            }
            this.dispose();
        }
    }

    public void setValues() {
        this.mListValues = mPromptValuesData.getValuesList().size() > 0;
        this.mDefaultValue = mPromptValuesData.getDefaultValue();
        this.setPromptString(mPromptValuesData.getPromptString());
        if (this.mListValues) {
            for (String string : mPromptValuesData.getValuesList()) {
                this.mComboBox.addItem(string);
            }
            this.mComboBox.setSelectedItem(this.mDefaultValue);
        } else {
            this.mValueEditField.setText(this.mDefaultValue);
        }
    }

    public void setPromptString(String string) {
        this.mPromptLabel.setText(string);
    }

    public void doHelp() {
    }

    protected void init() {
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        this.mOkButton = new JButton(ResUtil.getString(resourceBundle, "IDS_CONTINUE"));
        this.mOkButton.addActionListener(this);
        this.mCancelButton = new JButton(ResUtil.getString(resourceBundle, "IDS_CANCEL"));
        this.mCancelButton.addActionListener(this);
        super.init();
        this.initVars();
        this.generateLayout();
        this.pack();
    }

    protected void generateLayout() {
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        insets.bottom = DialogUtil.getGroupBoxInnerMargin();
        DialogUtil.addUsingGBL(jPanel, this.setupViewPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mCmdButtonPanel.requestFocus();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SetPromptValueDialog.this.mSelectedString = SetPromptValueDialog.this.mDefaultValue;
                SetPromptValueDialog.this.dispose();
            }
        });
    }

    protected void initVars() {
        this.mComboBox = new JComboBox();
        Dimension dimension = new Dimension(250, this.mComboBox.getPreferredSize().height);
        this.mComboBox.setMinimumSize(dimension);
        this.mComboBox.setPreferredSize(dimension);
        this.mValueEditField = new JTextField();
        this.mValueEditField.setMinimumSize(dimension);
        this.mValueEditField.setPreferredSize(dimension);
        this.mPromptLabel = new JLabel();
        this.mPromptLabel.setMinimumSize(dimension);
        this.mPromptLabel.setPreferredSize(dimension);
        this.setValues();
        ResourceBundle resourceBundle = ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        if (this.mListValues) {
            this.setTitle(ResUtil.getString(resourceBundle, "IDS_DB_SELECT_VALUE_DLG"));
        } else {
            this.setTitle(ResUtil.getString(resourceBundle, "IDS_DB_ENTER_VALUE_DLG"));
        }
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        if (DialogUtil.areCommandButtonsBelow()) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                FlowLayout flowLayout = new FlowLayout(2, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mCancelButton);
                jPanel.add(this.mOkButton);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mOkButton);
                jPanel.add(this.mCancelButton);
            }
            this.getRootPane().setDefaultButton(this.mCancelButton);
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(this.mOkButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mCancelButton);
            this.getRootPane().setDefaultButton(this.mCancelButton);
        }
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private JComponent setupViewPanel() {
        int n = 30;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        insets.right = n;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mPromptLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weighty = 1.0;
        if (this.mListValues) {
            DialogUtil.addUsingGBL(jPanel, this.mComboBox, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        } else {
            DialogUtil.addUsingGBL(jPanel, this.mValueEditField, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        }
        return jPanel;
    }

    public static void setPromptValuesData(PromptValuesData promptValuesData) {
        mPromptValuesData = promptValuesData;
    }
}

