/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.results;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.resources.CoreResUtil;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.file.openquery.AbstractDBWizardCommonPage;
import com.spss.java_client.ui.dialogs.base.file.openquery.NewQueryDlg;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBWizardUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.GenerateSyntax;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.ResultsPageInfo;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.controls.ContextEnabledTextArea;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class ResultsPage
extends AbstractDBWizardCommonPage
implements KeyListener,
FocusListener {
    private DialogFocusTraversalPolicy mPolicy;
    private static ContextEnabledTextArea mSyntaxArea;
    private JRadioButton mRetrieveRadio;
    private JRadioButton mPasteRadio;
    private JButton mBrowseButton;
    private FileTextField mFileTextField;
    private String mBrowserFilePath = "";
    private SpssButtonGroup mButtonGroup;
    private JScrollPane mScrollPane;
    private static final int MAX_LINE_LENGTH = 88;
    private static boolean sIsNext;
    private String mSyntax = "";
    private String mInitialSyntax = "";
    private int mFileOverrideOption;

    public ResultsPage(BaseWizardDialog baseWizardDialog) {
        super("ResultsPage", baseWizardDialog, true);
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public String getNextPage() {
        return null;
    }

    @Override
    public boolean isLastPage() {
        return true;
    }

    @Override
    public boolean hasNextPage() {
        return false;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_resultdestination";
    }

    public boolean isPasteRadioButtonSelected() {
        return this.mPasteRadio != null && this.mPasteRadio.isSelected();
    }

    public boolean isRetrieveRadioButtonSelected() {
        return this.mRetrieveRadio == null || this.mRetrieveRadio.isSelected();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource().equals(mSyntaxArea) && keyEvent.getKeyCode() == 9) {
            mSyntaxArea.selectAll();
            Component component = keyEvent.isShiftDown() ? this.mWizardDialog.getFocusTraversalPolicy().getComponentBefore((Container)((Object)this.mWizardDialog), (Component)keyEvent.getSource()) : this.mWizardDialog.getFocusTraversalPolicy().getComponentAfter((Container)((Object)this.mWizardDialog), (Component)keyEvent.getSource());
            mSyntaxArea.setText(mSyntaxArea.getText().trim());
            component.requestFocus();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public String getFileName() {
        return this.mFileTextField.getText();
    }

    @Override
    public boolean validate() {
        sIsNext = true;
        this.mFileOverrideOption = this.validateFilePath();
        if (this.mFileOverrideOption != 1) {
            return false;
        }
        this.saveResultsPageInfo();
        return super.validate();
    }

    private void saveResultsPageInfo() {
        ResultsPageInfo resultsPageInfo = ResultsPageInfo.getResultsPageInfo();
        resultsPageInfo.setSql(mSyntaxArea.getText().replaceAll("\n", ""));
        if (VersionInfo.allowSyntax()) {
            resultsPageInfo.setRetrive(this.mRetrieveRadio.isSelected());
        }
        resultsPageInfo.setFileName(this.mFileTextField.getText());
    }

    @Override
    public boolean validateOnBack() {
        this.saveResultsPageInfo();
        return true;
    }

    public static JTextArea getSyntaxTextArea() {
        return mSyntaxArea;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mScrollPane)) {
            mSyntaxArea.requestFocus();
            mSyntaxArea.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    public boolean isNext() {
        return sIsNext;
    }

    public int getFileOverrideOption() {
        return this.mFileOverrideOption;
    }

    @Override
    protected void aboutToShowPanel() {
        this.mWizardDialog.setDefaultButton(BaseWizardDialog.WizardButton.eFinish);
        super.aboutToShowPanel();
        if (!this.useExistingResultsPageInfo()) {
            GenerateSyntax generateSyntax = GenerateSyntax.getGenerateSyntax();
            mSyntaxArea.setText(generateSyntax.generateSQL());
            if (VersionInfo.allowSyntax()) {
                this.mRetrieveRadio.setSelected(true);
            }
            this.mFileTextField.setText("");
        }
        this.mSyntax = mSyntaxArea.getText();
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        sIsNext = false;
        if (DBWizardUtil.getDBWizardPreviousPage() != DBWizardUtil.DBWizardPreviousPage.eResult) {
            this.mScrollPane.requestFocus();
        }
        this.mWizardDialog.enableBack(true);
        this.mWizardDialog.enableNext(false);
        this.mScrollPane.addFocusListener(this);
        this.mInitialSyntax = mSyntaxArea.getText();
    }

    private boolean useExistingResultsPageInfo() {
        ResultsPageInfo resultsPageInfo = ResultsPageInfo.getResultsPageInfo();
        if (resultsPageInfo.isExisting()) {
            mSyntaxArea.setText(resultsPageInfo.getSql());
            this.mFileTextField.setText(resultsPageInfo.getFileName());
            if (!resultsPageInfo.getRetrive()) {
                this.mPasteRadio.setSelected(true);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void aboutToHidePanel() {
        this.mWizardDialog.setDefaultButton(BaseWizardDialog.WizardButton.eNext);
        super.aboutToHidePanel();
    }

    @Override
    protected void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mScrollPane);
        vector.add(this.mButtonGroup);
        vector.add(this.mFileTextField);
        vector.add(this.mBrowseButton);
        Vector<Object> vector2 = ((NewQueryDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    @Override
    protected void initVars() {
        ToggleButtonAction toggleButtonAction;
        mSyntaxArea = new ContextEnabledTextArea(ComponentState.getCurrentCharset());
        mSyntaxArea.setColumns(88);
        mSyntaxArea.setWrapStyleWord(true);
        mSyntaxArea.setLineWrap(true);
        mSyntaxArea.setDocument((Document)new NoTabDocument());
        mSyntaxArea.addKeyListener((KeyListener)this);
        this.mScrollPane = new JScrollPane((Component)mSyntaxArea);
        this.mScrollPane.setMinimumSize(new Dimension(150, 150));
        this.mScrollPane.setPreferredSize(new Dimension(150, 150));
        this.mScrollPane.addFocusListener(this);
        if (VersionInfo.allowSyntax()) {
            toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_DB_RESULT_RETRIEVE");
            this.mRetrieveRadio = new JRadioButton(toggleButtonAction);
            toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_DB_RESULT_PASTE");
            this.mPasteRadio = new JRadioButton(toggleButtonAction);
        }
        toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_DB_RESULT_BROWSE");
        this.mBrowseButton = new JButton(toggleButtonAction);
        this.mBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.GenericWithoutPES, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
                RefFileFilter refFileFilter = new RefFileFilter(ResultsPage.this.mWizardDialog.getResString("IDS_DB_RESULT_FILE_FILTER_DESC"), ResultsPage.this.mWizardDialog.getResString("IDS_DB_RESULT_FILE_FILTER_ETN"));
                remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
                remoteFileChooser.setAcceptAllFileFilterUsed(false);
                remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
                remoteFileChooser.setDialogTitle(ResultsPage.this.mWizardDialog.getResString("IDS_DB_RESULTS_FILE_CHOOSER_TITLE"));
                int n = remoteFileChooser.showSaveDialog((Component)((Object)ResultsPage.this.mWizardDialog));
                if (n == 0) {
                    FileLocationsUtil.setDataFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                    String string = remoteFileChooser.getSelectedFilePath();
                    if (!string.endsWith(ResultsPage.this.mWizardDialog.getResString("IDS_DB_RESULT_FILE_FILTER_ETN"))) {
                        string = string + ResultsPage.this.mWizardDialog.getResString("IDS_DB_RESULT_FILE_FILTER_ETN");
                    }
                    ResultsPage.this.mFileTextField.setText(string);
                    ResultsPage.this.mBrowserFilePath = string;
                } else {
                    ResultsPage.this.mBrowserFilePath = "";
                }
            }
        });
        this.mFileTextField = new FileTextField();
        this.mFileTextField.setColumns(30);
        this.mFileTextField.setEditable(true);
        this.mFileTextField.setEnabled(true);
        if (VersionInfo.allowSyntax()) {
            this.mButtonGroup = new SpssButtonGroup();
            this.mButtonGroup.add(this.mRetrieveRadio);
            this.mButtonGroup.add(this.mPasteRadio);
            this.mRetrieveRadio.setSelected(true);
        }
    }

    @Override
    protected JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, n2, 0, n2);
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString("IDS_DB_RESULTS_LABEL"));
        jLabel.setFont(jLabel.getFont().deriveFont(1, 18.0f));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JLabel jLabel2 = new JLabel(this.mWizardDialog.getResString("IDS_DB_RESULT_SELECTION_LABEL"));
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    @Override
    protected JPanel setupPageBody() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = 4;
        Insets insets = new Insets(n2, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 0, 0, 3, 3, n, insets);
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel2 = this.setupQueryPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 3, 1, 1, n, insets);
        jPanel2 = this.setupBrowsePanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 4, 3, 1, n, insets);
        return jPanel;
    }

    @Override
    protected boolean isLowerHorizontalBarPresent() {
        return true;
    }

    @Override
    protected boolean isTopHorizontalBarPresent() {
        return false;
    }

    private JPanel setupQueryPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        if (VersionInfo.allowSyntax()) {
            jPanel.setBorder(BorderFactory.createTitledBorder(this.mWizardDialog.getResString("IDS_DB_RESULT_QUERY_TITLE")));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            int n = 23;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            int n2 = DialogUtil.getComponentGroupGap();
            Insets insets = new Insets(n2, n2, 0, n2);
            DialogUtil.addUsingGBL(jPanel, this.mRetrieveRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
            insets.top = n2 / 2;
            insets.bottom = n2;
            DialogUtil.addUsingGBL(jPanel, this.mPasteRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        }
        return jPanel;
    }

    private JPanel setupBrowsePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mWizardDialog.getResString("IDS_DB_RESULT_SAVE_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileTextField), gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }

    private int validateFilePath() {
        int n = 1;
        String string = this.mFileTextField.getText();
        String string2 = this.mWizardDialog.getResString("IDS_DB_RESULT_FILE_FILTER_ETN");
        if (string.length() > 0 && !string.endsWith(string2)) {
            string = string + string2;
        }
        if (string.length() > 0) {
            String string3;
            if (string.equals(this.mBrowserFilePath)) {
                return n;
            }
            File file = new File(string);
            if (!file.isDirectory() && file.exists() && (n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), string3 = String.format(CoreResUtil.getString((String)"ERR_FILE_EXISTS_WARNING"), string), this.mWizardDialog.getResString("IDS_EX2DB_RESULTS_OPTION_PANE_TITLE"), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.YES_NO_OPTION)) != 1) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ResultsPage.this.mFileTextField.requestFocus();
                    }
                });
                return n;
            }
        }
        return n;
    }

    static {
        sIsNext = false;
    }

    class NoTabDocument
    extends PlainDocument {
        NoTabDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (!string.equals("\t")) {
                super.insertString(n, string, attributeSet);
            }
        }
    }
}

