/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.limit_retrieved_cases;

import com.spss.java_client.ui.dialogs.base.file.res.FileResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import java.io.Serializable;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.ResourceBundle;

public class PromptValuesData
implements Serializable {
    private String mPromptString;
    private String mDefaultValue;
    private boolean mAllowListSelection;
    private ArrayList<String> mValuesList;
    private PromptValuesDataType mDataType;
    private int mSelectedValueIndex;
    private String mFinalValue;
    private static final long serialVersionUID = 1004L;

    public PromptValuesData() {
        ResourceBundle resourceBundle = ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        this.mPromptString = ResUtil.getString(resourceBundle, "IDS_DB_PRV_ENTER_VALUE");
        this.mDefaultValue = "";
        this.mAllowListSelection = false;
        this.mValuesList = new ArrayList();
        this.mDataType = PromptValuesDataType.eString;
        this.mSelectedValueIndex = -1;
    }

    public PromptValuesData(String string, String string2, boolean bl, ArrayList<String> arrayList, PromptValuesDataType promptValuesDataType, int n) {
        this.mPromptString = string;
        this.mDefaultValue = string2;
        this.mAllowListSelection = bl;
        this.mValuesList = arrayList;
        this.mDataType = promptValuesDataType;
        this.mSelectedValueIndex = n;
    }

    public int getSelectedValue() {
        return this.mSelectedValueIndex;
    }

    public void setSelectedValue(int n) {
        this.mSelectedValueIndex = n;
    }

    public boolean isAllowListSelection() {
        return this.mAllowListSelection;
    }

    public void setAllowListSelection(boolean bl) {
        this.mAllowListSelection = bl;
    }

    public PromptValuesDataType getDataType() {
        return this.mDataType;
    }

    public void setDataType(PromptValuesDataType promptValuesDataType) {
        this.mDataType = promptValuesDataType;
    }

    public String getDefaultValue() {
        return this.mDefaultValue;
    }

    public void setDefaultValue(String string) {
        this.mDefaultValue = string;
    }

    public String getPromptString() {
        return this.mPromptString;
    }

    public void setPromptString(String string) {
        this.mPromptString = string;
    }

    public ArrayList<String> getValuesList() {
        return this.mValuesList;
    }

    public void setValuesList(ArrayList<String> arrayList) {
        this.mValuesList = arrayList;
    }

    public String generateString() {
        if (this.mDefaultValue.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        ResourceBundle resourceBundle = ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        String string = ResUtil.getString(resourceBundle, "IDS_DBWIZARD_LRC_PROMPT");
        stringBuffer.append(string).append("(");
        stringBuffer.append("'").append(this.mPromptString).append("'");
        stringBuffer.append(", '").append(this.mDefaultValue).append("'");
        int n = this.mValuesList.size();
        if (this.mAllowListSelection && n > 0) {
            string = ResUtil.getString(resourceBundle, "IDS_DBWIZARD_LRC_LIST");
            stringBuffer.append(", ").append(string).append("(");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("\"").append(this.mValuesList.get(i)).append("\"");
                if (i == n - 1) {
                    stringBuffer.append(")");
                    continue;
                }
                stringBuffer.append(", ");
            }
        }
        if (this.mDataType == PromptValuesDataType.eDate) {
            string = ResUtil.getString(resourceBundle, "IDS_DB_COMMON_DATE");
            stringBuffer.append(", ").append(string).append(")");
        } else if (this.mDataType == PromptValuesDataType.eNumber) {
            string = ResUtil.getString(resourceBundle, "IDS_DB_PRV_DATA_TYPE_NUMBER");
            stringBuffer.append(", ").append(string).append(")");
        } else {
            string = ResUtil.getString(resourceBundle, "IDS_DB_COMMON_STRING");
            stringBuffer.append(", ").append(string).append(")");
        }
        return stringBuffer.toString();
    }

    public PromptValuesData parse(String string) {
        Object object;
        ArrayList<String> arrayList = this.getTokensList(string);
        boolean bl = true;
        int n = arrayList.size();
        ResourceBundle resourceBundle = ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        String string2 = ResUtil.getString(resourceBundle, "IDS_DB_PRV_ENTER_VALUE");
        String string3 = "";
        ArrayList<String> arrayList2 = new ArrayList<String>();
        PromptValuesDataType promptValuesDataType = PromptValuesDataType.eString;
        int n2 = -1;
        boolean bl2 = false;
        if (n > 3) {
            if (!arrayList.get(0).equals(ResUtil.getString(resourceBundle, "IDS_DBWIZARD_LRC_PROMPT"))) {
                bl = false;
            } else {
                string2 = arrayList.get(1);
                string3 = arrayList.get(2);
                object = arrayList.get(3);
                if (((String)object).equals(ResUtil.getString(resourceBundle, "IDS_DBWIZARD_LRC_LIST"))) {
                    boolean bl3 = false;
                    bl2 = true;
                    for (int i = 4; i < n - 1; ++i) {
                        object = arrayList.get(i);
                        if (((String)object).equals(string3)) {
                            bl3 = true;
                            n2 = i - 4;
                        }
                        arrayList2.add((String)object);
                    }
                    if (!bl3) {
                        bl = false;
                    }
                    object = arrayList.get(n - 1);
                }
                if (((String)object).equals(ResUtil.getString(resourceBundle, "IDS_DB_COMMON_STRING"))) {
                    promptValuesDataType = PromptValuesDataType.eString;
                } else if (((String)object).equals(ResUtil.getString(resourceBundle, "IDS_DB_PRV_DATA_TYPE_NUMBER"))) {
                    promptValuesDataType = PromptValuesDataType.eNumber;
                } else if (((String)object).equals(ResUtil.getString(resourceBundle, "IDS_DB_COMMON_DATE"))) {
                    promptValuesDataType = PromptValuesDataType.eDate;
                } else {
                    bl = false;
                }
            }
        } else {
            bl = false;
        }
        object = bl ? new PromptValuesData(string2, string3, bl2, arrayList2, promptValuesDataType, n2) : new PromptValuesData();
        return object;
    }

    public boolean isValidPromptDataString(String string) {
        ArrayList<String> arrayList = this.getTokensList(string);
        boolean bl = true;
        int n = arrayList.size();
        if (n > 3) {
            ResourceBundle resourceBundle = ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
            if (!arrayList.get(0).equals(ResUtil.getString(resourceBundle, "IDS_DBWIZARD_LRC_PROMPT"))) {
                bl = false;
            } else {
                String string2 = arrayList.get(2);
                String string3 = arrayList.get(3);
                if (string3.equals(ResUtil.getString(resourceBundle, "IDS_DBWIZARD_LRC_LIST"))) {
                    boolean bl2 = false;
                    for (int i = 4; i < n - 1; ++i) {
                        string3 = arrayList.get(i);
                        if (!string3.equals(string2)) continue;
                        bl2 = true;
                    }
                    if (!bl2) {
                        bl = false;
                    }
                    string3 = arrayList.get(n - 1);
                }
                if (!(string3.equals(ResUtil.getString(resourceBundle, "IDS_DB_COMMON_STRING")) || string3.equals(ResUtil.getString(resourceBundle, "IDS_DB_PRV_DATA_TYPE_NUMBER")) || string3.equals(ResUtil.getString(resourceBundle, "IDS_DB_COMMON_DATE")))) {
                    bl = false;
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private ArrayList<String> getTokensList(String string) {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (Character.isLetterOrDigit(c)) {
                stringBuffer.append(c);
            } else {
                switch (c) {
                    case '(': {
                        String string2;
                        if (n == 0) {
                            string2 = stringBuffer.toString();
                            if (string2.length() > 0) {
                                arrayList.add(stringBuffer.toString());
                            }
                            stringBuffer = new StringBuffer();
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case ')': {
                        String string2;
                        if (n == 0) {
                            string2 = stringBuffer.toString();
                            if (string2.length() > 0) {
                                arrayList.add(stringBuffer.toString());
                            }
                            stringBuffer = new StringBuffer();
                            break;
                        }
                        stringBuffer.append(c);
                        break;
                    }
                    case '\'': {
                        if (n == 0) {
                            ++n;
                            break;
                        }
                        n = 0;
                        String string2 = stringBuffer.toString();
                        if (string2.length() > 0) {
                            arrayList.add(stringBuffer.toString());
                        }
                        stringBuffer = new StringBuffer();
                        break;
                    }
                    case ',': {
                        if (n != 1) break;
                        stringBuffer.append(c);
                        break;
                    }
                    case ' ': {
                        if (n != 1) break;
                        stringBuffer.append(c);
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
            }
            c = stringCharacterIterator.next();
        }
        return arrayList;
    }

    public String getFinalValue() {
        return this.mFinalValue;
    }

    public void setFinalValue(String string) {
        this.mFinalValue = string;
    }

    public static enum PromptValuesDataType {
        eDate,
        eNumber,
        eString;


        public static PromptValuesDataType fromInt(int n) {
            switch (n) {
                case 0: {
                    return eDate;
                }
                default: {
                    return eNumber;
                }
                case 2: 
            }
            return eString;
        }
    }
}

