/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.limit_retrieved_cases;

import com.spss.uitools.controls.drag_drop.ComponentDragAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class LRCTreeDragAdapter
extends ComponentDragAdapter {
    protected MouseEvent mDndArmedEvent = null;
    private JTree mSourceTree;

    public LRCTreeDragAdapter(JTree jTree, DragPane dragPane, String string) {
        super(dragPane, string);
        this.mSourceTree = jTree;
    }

    protected void acquireTransferData() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        TreePath treePath;
        if (this.mSourceTree != null && (treePath = this.mSourceTree.getSelectionPath()) != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).isLeaf()) {
            this.mTransferData = defaultMutableTreeNode;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mDndArmedEvent = null;
        if (mouseEvent.isConsumed() || mouseEvent.getButton() != 1 && mouseEvent.getButton() != 2) {
            return;
        }
        Component component = mouseEvent.getComponent();
        if (!(component instanceof JTree)) {
            assert (false);
            return;
        }
        JTree jTree = (JTree)component;
        assert (this.mSourceTree == jTree);
        if (!jTree.isEnabled()) {
            return;
        }
        TreePath treePath = jTree.getPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        if (treePath != null) {
            super.mousePressed(mouseEvent);
            jTree.setSelectionPath(treePath);
        }
    }

    protected void startDrag(MouseEvent mouseEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Component component = mouseEvent.getComponent();
        JTree jTree = (JTree)component;
        TreePath treePath = this.mSourceTree.getSelectionPath();
        if (treePath != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).isLeaf()) {
            BufferedImage bufferedImage = this.getDragImage(jTree);
            if (this.mTransferData == null) {
                this.acquireTransferData();
            }
            Point point = (Point)mouseEvent.getPoint().clone();
            SwingUtilities.convertPointToScreen(point, component);
            SwingUtilities.convertPointFromScreen(point, (Component)this.mDragPane);
            this.mDragPane.setDragImage(bufferedImage, false);
            this.mDragPane.setDragPoint(point);
            this.mDragPane.setVisible(true);
            this.mDragPane.repaint();
        }
    }

    protected BufferedImage getDragImage(Component component) {
        JTree jTree = (JTree)component;
        TreePath treePath = this.mSourceTree.getSelectionPath();
        JLabel jLabel = (JLabel)jTree.getCellRenderer().getTreeCellRendererComponent(jTree, treePath.getLastPathComponent(), false, jTree.isExpanded(treePath), jTree.getModel().isLeaf(treePath.getLastPathComponent()), 0, false);
        int n = jTree.getRowHeight();
        if (n <= 0) {
            n = (int)jLabel.getPreferredSize().getHeight();
        }
        Rectangle rectangle = new Rectangle(jTree.getWidth() - 10, n);
        jLabel.setLocation(new Point(0, 20));
        jLabel.setSize(rectangle.width, rectangle.height);
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setClip(0, 0, rectangle.width, rectangle.height);
        graphics2D.setComposite(AlphaComposite.getInstance(2, 0.5f));
        jLabel.paint(graphics2D);
        graphics2D.translate(0, rectangle.height);
        component.paint(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }
}

