/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.define_variables;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssStaticText;
import com.spss.java_client.ui.dialogs.base.file.openquery.AbstractDBWizardCommonPage;
import com.spss.java_client.ui.dialogs.base.file.openquery.DefineVarData;
import com.spss.java_client.ui.dialogs.base.file.openquery.NewQueryDlg;
import com.spss.java_client.ui.dialogs.base.file.openquery.define_variables.DefineVarLabelCellRenderer;
import com.spss.java_client.ui.dialogs.base.file.openquery.define_variables.DefineVarTableModel;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBWizardUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBC;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.AggregateColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.AggregatePageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.ComputeNewFieldsPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.ComputedColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.DefineVariablesPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.SPSSColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.SPSSUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.Selected;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.GBC;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;

public class DefineVariablesPage
extends AbstractDBWizardCommonPage
implements DocumentListener {
    private static final int MAX_LIMIT = Short.MAX_VALUE;
    private DialogFocusTraversalPolicy mPolicy;
    private ContextEnabledTextField mVariableWidthTextField;
    private JCheckBox mMinimizeStringWidthsCheckbox;
    private PlainTable mDefineVarTable;
    private List<DefineVarData> mDefineData = null;
    private ArrayList<String> mResultVarNames = new ArrayList();
    private HashMap<String, Integer> mInvalidFieldsMap;
    private JList mComputedFieldlist;
    private boolean mIsModified = false;

    public DefineVariablesPage(BaseWizardDialog baseWizardDialog) {
        super("DefineVariablesPage", baseWizardDialog, true);
    }

    @Override
    public String getNextPage() {
        boolean bl = DataServerProxy.getDataProxy().isRemoteConnection();
        if (bl) {
            return "SortCasesPage";
        }
        return "ResultsPage";
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_definevariables";
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableButtons();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public boolean validate() {
        if (this.mDefineVarTable.getColumnModel().getColumn(1).getCellEditor().stopCellEditing()) {
            String string = this.checkDuplicateNames();
            if (!string.equals("")) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), MessageFormat.format(this.mWizardDialog.getResString("ERR_SAME_VARNAME"), string), this.mWizardDialog.getResString("IDS_DBWIZARD_WARNING_TITLE"));
                return false;
            }
        } else {
            return false;
        }
        this.saveDefineData();
        if (this.mIsModified) {
            SPSSUtil.clearSortPage();
        }
        return true;
    }

    @Override
    public boolean validateOnBack() {
        this.saveDefineData();
        return super.validateOnBack();
    }

    @Override
    protected void aboutToHidePanel() {
        DBWizardUtil.setDBWizardPreviousPage(DBWizardUtil.DBWizardPreviousPage.eDefineVariables);
        this.mInvalidFieldsMap.clear();
    }

    protected void saveDefineData() {
        int n;
        DefineVariablesPageInfo defineVariablesPageInfo = DefineVariablesPageInfo.getDefineVariablesPageInfo();
        this.mIsModified = false;
        DefineVarTableModel defineVarTableModel = (DefineVarTableModel)this.mDefineVarTable.getModel();
        ArrayList<SPSSColumn> arrayList = new ArrayList<SPSSColumn>();
        List<SPSSColumn> list = defineVariablesPageInfo.getRecodeColumns();
        for (n = 0; n < defineVarTableModel.getRowCount(); ++n) {
            String string = (String)defineVarTableModel.getValueAt(n, 1);
            boolean bl = (Boolean)defineVarTableModel.getValueAt(n, 3);
            SPSSColumn sPSSColumn = defineVarTableModel.getSPSSColumn(n);
            if (string.length() > 0) {
                if (!string.equals(sPSSColumn.getUserName())) {
                    this.mIsModified = true;
                }
                sPSSColumn.setUserName(string);
            }
            if (bl) {
                arrayList.add(sPSSColumn);
                if (list.contains(sPSSColumn)) continue;
                this.mIsModified = true;
                continue;
            }
            if (!list.contains(sPSSColumn)) continue;
            this.mIsModified = true;
        }
        defineVariablesPageInfo.setRecodeColumns(arrayList);
        n = Integer.parseInt(this.mVariableWidthTextField.getText());
        if (n != defineVariablesPageInfo.getAssumedStringWidth()) {
            this.mIsModified = true;
        }
        defineVariablesPageInfo.setAssumedStringWidth(n);
        boolean bl = this.mMinimizeStringWidthsCheckbox.isSelected();
        if (bl != defineVariablesPageInfo.isMinimizeStrings()) {
            this.mIsModified = true;
        }
        defineVariablesPageInfo.setMinimizeStrings(bl);
    }

    @Override
    protected void aboutToShowPanel() {
        this.loadData();
        this.setupDefineVarTable();
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
    }

    @Override
    protected JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 4;
        Insets insets = new Insets(n2, n2, 0, n2);
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString("IDS_DEFINE_VARIABLE_LABEL"));
        jLabel.setFont(jLabel.getFont().deriveFont(1, 18.0f));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JLabel jLabel2 = new JLabel(this.mWizardDialog.getResString("IDS_DEFINE_VARIABLE_NOTE1"));
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        JLabel jLabel3 = new JLabel(this.mWizardDialog.getResString("IDS_DEFINE_VARIABLE_NOTE2"));
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 4, 1, 1, n, insets);
        SpssStaticText spssStaticText = new SpssStaticText(this.mWizardDialog.getResString("IDS_DEFINE_VARIABLE_NOTE3"));
        jPanel.add((Component)spssStaticText, new GBC(0, 6).template(gridBagConstraints).fill(2));
        boolean bl = ODBC.getODBC().isRemoteConnection();
        if (bl) {
            JTextArea jTextArea = new JTextArea(this.mWizardDialog.getResString("IDS_DEFINE_VARIABLE_NOTE4"));
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setBorder(null);
            jTextArea.setOpaque(false);
            jTextArea.setFocusable(false);
            gridBagConstraints.fill = 1;
            DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 8, 1, 1, n, insets);
        }
        return jPanel;
    }

    @Override
    protected JPanel setupPageBody() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = 0;
        JScrollPane jScrollPane = new JScrollPane(this.mDefineVarTable);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setPreferredSize(this.mDefineVarTable.getPreferredSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, n2++, 2, 1, n, null);
        boolean bl = ODBC.getODBC().isRemoteConnection();
        if (bl) {
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            int n3 = DialogUtil.getComponentGroupGap();
            Insets insets = new Insets(n3, 0, 0, 0);
            JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_DEFINE_VARIABLE_COMPUTED_FIELD_LABEL");
            jLabel.setLabelFor(this.mComputedFieldlist);
            DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, n2++, 2, 1, n, insets);
            jScrollPane = new JScrollPane(this.mComputedFieldlist);
            jScrollPane.setHorizontalScrollBarPolicy(30);
            jScrollPane.setVerticalScrollBarPolicy(20);
            jScrollPane.setPreferredSize(new Dimension(600, 60));
            jScrollPane.setEnabled(false);
            jScrollPane.setFocusable(false);
            DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, n2++, 2, 1, n, null);
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.setupVarWidthPanel(), gridBagConstraints, 0, n2++, 1, 1, n, null);
        return jPanel;
    }

    @Override
    protected void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mDefineVarTable);
        vector.add(this.mVariableWidthTextField);
        vector.add(this.mMinimizeStringWidthsCheckbox);
        Vector<Object> vector2 = ((NewQueryDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    @Override
    protected void initVars() {
        this.mMinimizeStringWidthsCheckbox = new JCheckBox(this.mWizardDialog.getResString("IDS_MIN_STRING_WIDTHS"));
        this.mMinimizeStringWidthsCheckbox.setMnemonic(this.mWizardDialog.getDlgAccessKey("IDK_MIN_STRING_WIDTHS_KEY"));
        this.mVariableWidthTextField = new ContextEnabledTextField();
        this.mVariableWidthTextField.setDocument((Document)new FixedLengthNumericDocument(9, true, false));
        this.mVariableWidthTextField.getDocument().addDocumentListener(this);
        this.mInvalidFieldsMap = new HashMap();
        this.mDefineVarTable = new PlainTable(){

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                if (n2 == 3) {
                    if (this.getValueAt(n, n2 - 1).equals(DefineVariablesPage.this.mWizardDialog.getResString("IDS_DB_COMMON_STRING"))) {
                        return new DefVarBooleanRenderer();
                    }
                    return new DefaultTableCellRenderer(){

                        @Override
                        public void setText(String string) {
                            super.setText("");
                        }
                    };
                }
                return super.getCellRenderer(n, n2);
            }

            @Override
            public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                if (n2 == 0) {
                    return;
                }
                super.changeSelection(n, n2, bl, bl2);
            }
        };
        this.mDefineVarTable.setDefaultRenderer(Object.class, new CellRenderer());
        this.mDefineVarTable.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                DefineVariablesPage.this.mDefineVarTable.changeSelection(0, 1, false, false);
            }
        });
        this.setupDefineVarTable();
        this.setDefaults();
        this.mComputedFieldlist = new PlainList("COMPUTED_FIELD_LIST");
        this.mComputedFieldlist.setModel(new DefaultListModel());
        this.mComputedFieldlist.setEnabled(false);
    }

    private String checkDuplicateNames() {
        String string;
        int n;
        String string2 = "";
        this.mInvalidFieldsMap.clear();
        if (this.mComputedFieldlist.getModel().getSize() > 0) {
            for (n = 0; n < this.mComputedFieldlist.getModel().getSize(); ++n) {
                string = (String)this.mComputedFieldlist.getModel().getElementAt(n);
                this.mInvalidFieldsMap.put(string, 0);
            }
        }
        for (n = 0; n < this.mDefineData.size(); ++n) {
            string = this.mDefineData.get(n).getResultNameInfo();
            if (string.length() < 1) {
                string = this.mResultVarNames.get(n);
            }
            if (this.mInvalidFieldsMap.size() > 0) {
                if (this.mInvalidFieldsMap.containsKey(string)) {
                    string2 = string;
                    break;
                }
                this.mInvalidFieldsMap.put(string, 0);
                continue;
            }
            this.mInvalidFieldsMap.put(string, 0);
        }
        return string2;
    }

    private void setDefaults() {
        this.mVariableWidthTextField.setColumns(4);
    }

    private JPanel setupVarWidthPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_DEFINE_VARIABLE_TEXTFIELD_LABEL");
        jLabel.setLabelFor((Component)this.mVariableWidthTextField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        int n = 24;
        Insets insets = UIToolDialogUtil.getStandardDialogInsets();
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mVariableWidthTextField, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.7;
        n = 13;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, this.mMinimizeStringWidthsCheckbox, gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }

    private void setupDefineVarTable() {
        DefineVarTableModel defineVarTableModel = new DefineVarTableModel(this.mDefineData);
        this.mDefineVarTable.setModel(defineVarTableModel);
        String[] stringArray = new String[]{"", this.mWizardDialog.getResString("IDS_DEFINE_VAR_TABLE_COLUMN1"), this.mWizardDialog.getResString("IDS_DEFINE_VAR_TABLE_COLUMN2"), "<HTML>" + this.mWizardDialog.getResString("IDS_DEFINE_VAR_TABLE_COLUMN3") + "</HTML>"};
        defineVarTableModel.setColumnName(stringArray);
        this.mDefineVarTable.getColumnModel().getColumn(0).setHeaderValue(stringArray[0]);
        this.mDefineVarTable.getColumnModel().getColumn(1).setHeaderValue(stringArray[1]);
        this.mDefineVarTable.getColumnModel().getColumn(2).setHeaderValue(stringArray[2]);
        this.mDefineVarTable.getColumnModel().getColumn(3).setHeaderValue(stringArray[3]);
        JTableHeader jTableHeader = this.mDefineVarTable.getTableHeader();
        jTableHeader.setFont(jTableHeader.getFont().deriveFont(1, 12.0f));
        this.mDefineVarTable.getTableHeader().setReorderingAllowed(false);
        this.mDefineVarTable.getTableHeader().setPreferredSize(new Dimension(this.mDefineVarTable.getPreferredSize().width * 10, 40));
        this.mDefineVarTable.getColumnModel().getColumn(0).setPreferredWidth(240);
        this.mDefineVarTable.getColumnModel().getColumn(1).setPreferredWidth(170);
        this.mDefineVarTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.mDefineVarTable.getColumnModel().getColumn(3).setPreferredWidth(100);
        this.mDefineVarTable.setColumnSelectionAllowed(true);
        this.mDefineVarTable.setRowHeight(this.mDefineVarTable.getRowHeight() + 4);
        for (int i = 0; i < 4; ++i) {
            TableColumn tableColumn = this.mDefineVarTable.getColumnModel().getColumn(i);
            if (i == 0) {
                tableColumn.setCellRenderer(new DefineVarLabelCellRenderer());
                continue;
            }
            if (i != 1) continue;
            JTextField jTextField = new JTextField();
            tableColumn.setCellEditor(new DefineVarCellEditor(jTextField, this.mWizardDialog));
            this.mDefineVarTable.getColumnModel().getColumn(1).getCellEditor().stopCellEditing();
        }
    }

    private void loadData() {
        DefineVariablesPageInfo defineVariablesPageInfo = DefineVariablesPageInfo.getDefineVariablesPageInfo();
        List<SPSSColumn> list = defineVariablesPageInfo.getRecodeColumns();
        ArrayList<DefineVarData> arrayList = new ArrayList<DefineVarData>();
        AggregatePageInfo aggregatePageInfo = AggregatePageInfo.getAggregatePageInfo();
        List<AggregateColumn> list2 = aggregatePageInfo.getAggregateColumns();
        List<SPSSColumn> list3 = aggregatePageInfo.getBreakColumns();
        boolean bl = list2.size() > 0 || list3.size() > 0;
        List<ComputedColumn> list4 = ComputeNewFieldsPageInfo.getNewFieldsInfo().getNewColumns();
        DefaultListModel defaultListModel = (DefaultListModel)this.mComputedFieldlist.getModel();
        defaultListModel.clear();
        if (bl) {
            DefineVarData defineVarData;
            for (SPSSColumn sPSSColumn : list3) {
                if (sPSSColumn instanceof ComputedColumn) {
                    defaultListModel.addElement(sPSSColumn.getUserName());
                    continue;
                }
                defineVarData = new DefineVarData();
                defineVarData.setSpssColumn(sPSSColumn);
                defineVarData.setResultNameInfo(sPSSColumn.getUserName());
                if (defineVariablesPageInfo.isExisting() && list.contains(sPSSColumn)) {
                    defineVarData.setAutoRecodeInfo(true);
                } else {
                    defineVarData.setAutoRecodeInfo(false);
                }
                arrayList.add(defineVarData);
            }
            for (AggregateColumn aggregateColumn : list2) {
                if (aggregateColumn.isComputedColumn()) {
                    defaultListModel.addElement(aggregateColumn.getUserName());
                    continue;
                }
                defineVarData = new DefineVarData();
                defineVarData.setSpssColumn(aggregateColumn);
                defineVarData.setResultNameInfo(aggregateColumn.getUserName());
                if (defineVariablesPageInfo.isExisting() && list.contains(aggregateColumn)) {
                    defineVarData.setAutoRecodeInfo(true);
                } else {
                    defineVarData.setAutoRecodeInfo(false);
                }
                arrayList.add(defineVarData);
            }
        } else {
            Selected selected = Selected.getSelected();
            List<SPSSColumn> list5 = selected.getSelectedColumns();
            for (SPSSColumn sPSSColumn : list5) {
                DefineVarData defineVarData = new DefineVarData();
                defineVarData.setSpssColumn(sPSSColumn);
                defineVarData.setResultNameInfo(sPSSColumn.getUserName());
                if (defineVariablesPageInfo.isExisting() && list.contains(sPSSColumn)) {
                    defineVarData.setAutoRecodeInfo(true);
                } else {
                    defineVarData.setAutoRecodeInfo(false);
                }
                arrayList.add(defineVarData);
            }
            for (ComputedColumn computedColumn : list4) {
                defaultListModel.addElement(computedColumn.getUserName());
            }
        }
        this.mDefineData = this.mDefineData != null && this.mDefineData.size() > 0 ? this.loadCheckBoxState1(arrayList) : arrayList;
        this.getValidResultVarNames();
        this.mVariableWidthTextField.setText("" + defineVariablesPageInfo.getAssumedStringWidth());
        this.mMinimizeStringWidthsCheckbox.setSelected(defineVariablesPageInfo.isMinimizeStrings());
    }

    private List<DefineVarData> loadCheckBoxState1(List<DefineVarData> list) {
        for (DefineVarData defineVarData : list) {
            int n = -1;
            boolean bl = false;
            for (DefineVarData defineVarData2 : this.mDefineData) {
                if (defineVarData2.getQualifiedNameInfo().equals(defineVarData.getQualifiedNameInfo())) {
                    bl = true;
                }
                ++n;
                if (!bl) continue;
                break;
            }
            if (!bl) continue;
            defineVarData.setAutoRecodeInfo(this.mDefineData.get(n).getAutoRecodeInfo());
        }
        return list;
    }

    private void loadCheckBoxState2() {
        int n = -1;
        for (DefineVarData defineVarData : this.mDefineData) {
            boolean bl = false;
            if (defineVarData.getResultNameInfo().equals("")) {
                bl = true;
            }
            ++n;
            if (!bl) continue;
            this.mDefineData.get(n).setAutoRecodeInfo(false);
        }
    }

    private void getValidResultVarNames() {
        int n;
        Vector<String> vector = new Vector<String>();
        this.mResultVarNames.clear();
        this.mResultVarNames.ensureCapacity(this.mDefineData.size() + 1);
        for (n = 0; n < this.mDefineData.size(); ++n) {
            String string = this.mDefineData.get(n).getResultNameInfo();
            vector.add(n, string);
            this.mResultVarNames.add(n, string);
        }
        if (VarNameValidator.generateSPSSNameForDac(vector, (boolean)false)) {
            this.mResultVarNames.clear();
            for (n = 0; n < vector.size(); ++n) {
                this.mDefineData.get(n).setResultNameInfo((String)vector.get(n));
                this.mResultVarNames.add(n, (String)vector.get(n));
            }
        }
    }

    private void enableButtons() {
        String string = this.mVariableWidthTextField.getText();
        if (string.equals("")) {
            this.mWizardDialog.enableFinish(false);
            this.mWizardDialog.enableNext(false);
        } else {
            int n = Integer.parseInt(string);
            if (n < 1 || n > Short.MAX_VALUE) {
                this.mWizardDialog.enableFinish(false);
                this.mWizardDialog.enableNext(false);
            } else {
                this.mWizardDialog.enableFinish(true);
                this.mWizardDialog.enableNext(true);
            }
        }
    }

    class CellRenderer
    extends DefaultTableCellRenderer {
        CellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = null;
            component = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n2 > 0) {
                component.setFont(jTable.getFont());
                component.setForeground(jTable.getForeground());
                component.setBackground(jTable.getBackground());
            }
            return component;
        }
    }

    public class DefineVarCellEditor
    extends DefaultCellEditor {
        private BaseDialog mParentDlg;

        public DefineVarCellEditor(JTextField jTextField, BaseDialog baseDialog) {
            super(jTextField);
            this.mParentDlg = baseDialog;
        }

        @Override
        public boolean stopCellEditing() {
            String string = this.getCellEditorValue().toString();
            if (string.length() > 0) {
                if (VarNameValidator.validateAgainstCurCharSet((String)string)) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParentDlg, UIToolResUtil.getString((String)"ERR_STRING_UNMAPPABLE_MSG"), this.mParentDlg.getResString("IDS_DBWIZARD_WARNING_TITLE"));
                    return false;
                }
                int n = VarNameValidator.validateSPSSName((String)string.toUpperCase(), (boolean)true).asInt();
                if (n == 4 || n > 5 && n < 8) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParentDlg, MessageFormat.format(this.mParentDlg.getResString("ERR_VAR_NAME_INVALID_CHARACTER"), string), this.mParentDlg.getResString("IDS_DBWIZARD_WARNING_TITLE"));
                    return false;
                }
                if (n == 1 || n == 2 || n == 5) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParentDlg, MessageFormat.format(this.mParentDlg.getResString("ERR_VAR_NAME_NOT_VALID"), string), this.mParentDlg.getResString("IDS_DBWIZARD_WARNING_TITLE"));
                    return false;
                }
                if (n == 3) {
                    SpssAlertOptionPane.showWarningMessageDialog((Window)this.mParentDlg, MessageFormat.format(this.mParentDlg.getResString("ERR_LONG_VARNAME"), string), this.mParentDlg.getResString("IDS_DBWIZARD_WARNING_TITLE"));
                    return false;
                }
            }
            return super.stopCellEditing();
        }
    }

    public class DefVarBooleanRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        private Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public DefVarBooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setSelected(object != null && (Boolean)object != false);
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(this.noFocusBorder);
            }
            return this;
        }
    }
}

