/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.compute_new_fields;

import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.drag_drop.PlainListDragAdapter;
import com.spss.java_client.ui.dialogs.base.file.openquery.AbstractDBWizardCommonPage;
import com.spss.java_client.ui.dialogs.base.file.openquery.NewQueryDlg;
import com.spss.java_client.ui.dialogs.base.file.openquery.compute_new_fields.CNFExpressionTable;
import com.spss.java_client.ui.dialogs.base.file.openquery.compute_new_fields.CNFTableDropListener;
import com.spss.java_client.ui.dialogs.base.file.openquery.compute_new_fields.CNFTreeDragAdapter;
import com.spss.java_client.ui.dialogs.base.file.openquery.compute_new_fields.ColumnCalcWidget;
import com.spss.java_client.ui.dialogs.base.file.openquery.compute_new_fields.ComputedFieldTableData;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBTreeRenderer;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBWizardToolTipRenderer;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.gui.ColumnWrapper;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.gui.TableWrapper;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBC;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCTable;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.ComputeNewFieldsPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.ComputedColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.SPSSUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.Selected;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.StringUtils;

public class ComputeNewFieldsPage
extends AbstractDBWizardCommonPage
implements FocusListener {
    public static final String PAGE_ID = "ComputeNewFieldsPage";
    private DialogFocusTraversalPolicy mPolicy;
    private JLabel mHeadLabel1;
    private JLabel mHeadLabel2;
    private String[][] mFunctions;
    private PlainList mFunctionsList;
    private ColumnCalcWidget mOperatorsPanel;
    private JTree mFieldsTree;
    private JScrollPane mFieldsTreePane;
    private CNFExpressionTable mExpresssionTable;
    private JScrollPane mExpresssionPane;
    private Set<String> mColNamesInUse;
    protected boolean mIsShowWarning;
    private CNFTableDropListener mTableDropListener;
    private boolean mIsModified;

    public ComputeNewFieldsPage(BaseWizardDialog baseWizardDialog) {
        super(PAGE_ID, baseWizardDialog, true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_database_wizard_compute_new_fields";
    }

    @Override
    protected JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = 4;
        Insets insets = new Insets(n2, n2, 0, n2);
        this.mHeadLabel1 = new JLabel(this.mWizardDialog.getResString("IDS_DB_CNF_HEADING1"));
        this.mHeadLabel1.setFont(this.mHeadLabel1.getFont().deriveFont(1, 18.0f));
        DialogUtil.addUsingGBL(jPanel, this.mHeadLabel1, gridBagConstraints, 0, 0, 2, 1, n, insets);
        this.mHeadLabel2 = new JLabel(this.mWizardDialog.getResString("IDS_DB_CNF_HEADING2"));
        DialogUtil.addUsingGBL(jPanel, this.mHeadLabel2, gridBagConstraints, 0, 1, 2, 1, n, insets);
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString("IDS_DB_CNF_HEADING3"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 3, 2, 1, n, insets);
        return jPanel;
    }

    @Override
    protected JPanel setupPageBody() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, n2, n3, n2);
        JPanel jPanel2 = this.setupExpressionTablePanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 3, 1, n, insets);
        jPanel2 = this.setupFieldsPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        jPanel2 = this.setupOperatorsPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 1, 1, 1, n, insets);
        jPanel2 = this.setupFunctionsPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 2, 1, 1, 1, n, insets);
        return jPanel;
    }

    @Override
    protected void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mExpresssionTable);
        vector.add(this.mFieldsTree);
        vector.add(this.mOperatorsPanel.getDefaultFocusButton());
        vector.add(this.mFunctionsList);
        Vector<Object> vector2 = ((NewQueryDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    @Override
    protected void initVars() {
        this.mIsModified = false;
        this.mIsShowWarning = false;
        this.mColNamesInUse = new HashSet<String>();
        this.buildExprTable();
        this.mFieldsTree = new JTree();
        ToolTipManager.sharedInstance().registerComponent(this.mFieldsTree);
        this.mFieldsTree.setCellRenderer(new DBTreeRenderer(this.mWizardDialog));
        this.mFieldsTree.setToggleClickCount(100);
        this.mFieldsTree.getSelectionModel().setSelectionMode(1);
        this.mFieldsTree.setRootVisible(false);
        this.mFieldsTree.setShowsRootHandles(true);
        this.mFieldsTree.setDragEnabled(true);
        this.mFieldsTree.addFocusListener(this);
        this.mFieldsTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    TreePath treePath = ComputeNewFieldsPage.this.mFieldsTree.getSelectionPath();
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    if (defaultMutableTreeNode.isLeaf()) {
                        int n = ComputeNewFieldsPage.this.mExpresssionTable.getSelectionModel().getLeadSelectionIndex();
                        int n2 = ComputeNewFieldsPage.this.mExpresssionTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                        ODBCColumn oDBCColumn = ((ColumnWrapper)defaultMutableTreeNode.getUserObject()).getColumn();
                        String string = oDBCColumn.getQuotedQualifiedColumnName();
                        ComputeNewFieldsPage.this.mExpresssionTable.updateExpressionAt(string, n, n2);
                    } else if (ComputeNewFieldsPage.this.mFieldsTree.isExpanded(treePath)) {
                        ComputeNewFieldsPage.this.mFieldsTree.collapsePath(treePath);
                    } else {
                        ComputeNewFieldsPage.this.mFieldsTree.expandPath(treePath);
                    }
                }
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JButton jButton = (JButton)actionEvent.getSource();
                String string = jButton.getText();
                int n = ComputeNewFieldsPage.this.mExpresssionTable.getSelectionModel().getLeadSelectionIndex();
                int n2 = ComputeNewFieldsPage.this.mExpresssionTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                ComputeNewFieldsPage.this.mExpresssionTable.updateExpressionAt(" " + string + " ", n, n2);
            }
        };
        this.mOperatorsPanel = new ColumnCalcWidget(abstractAction, ColumnCalcWidget.CalcType.eRelationalOperator);
        this.mOperatorsPanel.addFocusListener(this);
        this.mFunctionsList = new PlainList("CNF_FUNCTION_LIST");
        this.mFunctionsList.setModel(new DefaultListModel());
        this.mFunctionsList.setSelectionMode(0);
        this.mFunctionsList.setCellRenderer(new DBWizardToolTipRenderer());
        this.mFunctionsList.setDragEnabled(true);
        this.buildFunctionsListModel();
        this.mFunctionsList.addFocusListener(this);
        this.mFunctionsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    int n = ComputeNewFieldsPage.this.mExpresssionTable.getSelectionModel().getLeadSelectionIndex();
                    int n2 = ComputeNewFieldsPage.this.mExpresssionTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                    int n3 = ComputeNewFieldsPage.this.mFunctionsList.getSelectedIndex();
                    if (n3 >= 0) {
                        String string = ComputeNewFieldsPage.this.mFunctions[n3][1];
                        ComputeNewFieldsPage.this.mExpresssionTable.updateExpressionAt(string, n, n2);
                    }
                }
            }
        });
        DialogUtil.modifyMouseInputListeners(this.mFieldsTree, new CNFTreeDragAdapter(this.mFieldsTree, (DragPane)this.mWizardDialog.getGlassPane(), "CNFSourceList"));
        DialogUtil.modifyMouseInputListeners(this.mFunctionsList, new CNFFunctionDragAdapter(this.mFunctionsList, (DragPane)this.mWizardDialog.getGlassPane(), "CNF_FUNCTION_LIST"));
        this.mTableDropListener = new CNFTableDropListener(this.mExpresssionTable, (Component)this.mFunctionsList);
    }

    @Override
    public String getNextPage() {
        return "LimitRetrievedCasesPage";
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    protected void aboutToShowPanel() {
        super.aboutToShowPanel();
        this.mFunctions = ODBCUtil.getFunctions();
        this.buildFieldsTree();
        this.buildFunctionsListModel();
        if (!this.useExistingData()) {
            this.setDefault();
        }
        ((DragPane)this.mWizardDialog.getGlassPane()).addDropListener((IDropListener)this.mTableDropListener);
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mWizardDialog.enableFinish(true);
        this.mExpresssionTable.requestFocusInWindow();
    }

    private void setDefault() {
        CNFExpressionTable.NewFieldsTableModel newFieldsTableModel = (CNFExpressionTable.NewFieldsTableModel)this.mExpresssionTable.getModel();
        newFieldsTableModel.clear();
        newFieldsTableModel.fillWithDefualtRows();
    }

    private boolean useExistingData() {
        ComputeNewFieldsPageInfo computeNewFieldsPageInfo = ComputeNewFieldsPageInfo.getNewFieldsInfo();
        List<ComputedColumn> list = computeNewFieldsPageInfo.getNewColumns();
        if (computeNewFieldsPageInfo.isExisting() && list != null && list.size() > 0) {
            CNFExpressionTable.NewFieldsTableModel newFieldsTableModel = (CNFExpressionTable.NewFieldsTableModel)this.mExpresssionTable.getModel();
            newFieldsTableModel.clear();
            int n = 0;
            for (ComputedColumn computedColumn : list) {
                newFieldsTableModel.addNewElement();
                newFieldsTableModel.setValueAt(computedColumn.getColumnName(), n, 1);
                newFieldsTableModel.setValueAt(computedColumn.getExpression(), n, 2);
                ++n;
            }
            newFieldsTableModel.fillWithDefualtRows();
            newFieldsTableModel.fireTableDataChanged();
            return true;
        }
        return false;
    }

    @Override
    protected void aboutToHidePanel() {
        ((DragPane)this.mWizardDialog.getGlassPane()).removeDropListener((IDropListener)this.mTableDropListener);
        super.aboutToHidePanel();
    }

    @Override
    public boolean validate() {
        if (this.mIsShowWarning) {
            return false;
        }
        CNFExpressionTable.NewFieldsTableModel newFieldsTableModel = (CNFExpressionTable.NewFieldsTableModel)this.mExpresssionTable.getModel();
        for (int i = 0; i < newFieldsTableModel.getRowCount(); ++i) {
            ComputedFieldTableData computedFieldTableData = newFieldsTableModel.getRow(i);
            if (!StringUtils.isNotBlank((String)computedFieldTableData.getFieldName()) && !StringUtils.isNotBlank((String)computedFieldTableData.getExpression())) continue;
            String string = computedFieldTableData.getFieldName();
            if (StringUtils.isBlank((String)string)) {
                this.mExpresssionTable.changeSelectionAndEdit(i, 1);
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_INCOMPLETE_EXPRESSION"), this.mWizardDialog.getResString("IDS_DBWIZARD_WARNING_TITLE"));
                return false;
            }
            if (this.isDuplicateName(string)) {
                this.mExpresssionTable.changeSelectionAndEdit(i, 1);
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), MessageFormat.format(this.mWizardDialog.getResString("ERR_FIELDNAME_USED"), string), this.mWizardDialog.getResString("IDS_DBWIZARD_WARNING_TITLE"));
                return false;
            }
            if (VarNameValidator.validateAgainstCurCharSet((String)string)) {
                this.mExpresssionTable.changeSelectionAndEdit(i, 1);
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), UIToolResUtil.getString((String)"ERR_STRING_UNMAPPABLE_MSG"), this.mWizardDialog.getResString("IDS_DBWIZARD_WARNING_TITLE"));
                return false;
            }
            VarNameValidator.ValidNameCode validNameCode = VarNameValidator.validateSPSSName((String)string.toUpperCase(), (boolean)true);
            String string2 = "";
            switch (validNameCode) {
                case SPSSNAME_SCRATCH: {
                    string2 = MessageFormat.format(this.mWizardDialog.getResString("ERR_FIELDNAME_SCRATCH"), string);
                    break;
                }
                case SPSSNAME_SYSTEM: {
                    string2 = MessageFormat.format(this.mWizardDialog.getResString("ERR_FIELDNAME_SYSTEM"), string);
                    break;
                }
                case SPSSNAME_BADLTH: {
                    string2 = this.mWizardDialog.getResString("ERR_FIELDNAME_LONG");
                    break;
                }
                case SPSSNAME_BADCHAR: {
                    string2 = MessageFormat.format(this.mWizardDialog.getResString("ERR_FIELDNAME_INVALID_CHARACTER"), string);
                    break;
                }
                case SPSSNAME_RESERVED: {
                    string2 = MessageFormat.format(this.mWizardDialog.getResString("ERR_FIELDNAME_RESERVED_WORD"), string);
                    break;
                }
                case SPSSNAME_BADFIRST: {
                    string2 = MessageFormat.format(this.mWizardDialog.getResString("ERR_FIELDNAME_IVD_FIRST"), string);
                    break;
                }
                case SPSSNAME_BADLAST: {
                    string2 = MessageFormat.format(this.mWizardDialog.getResString("ERR_FIELDNAME_IVD_LAST"), string);
                    break;
                }
            }
            if (StringUtils.isNotBlank((String)string2)) {
                this.mExpresssionTable.changeSelectionAndEdit(i, 1);
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), string2, this.mWizardDialog.getResString("IDS_DBWIZARD_WARNING_TITLE"));
                return false;
            }
            String string3 = computedFieldTableData.getExpression();
            if (StringUtils.isBlank((String)string3)) {
                this.mExpresssionTable.changeSelectionAndEdit(i, 2);
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_INCOMPLETE_EXPRESSION"), this.mWizardDialog.getResString("IDS_DBWIZARD_WARNING_TITLE"));
                return false;
            }
            Stack<Character> stack = new Stack<Character>();
            boolean bl = false;
            for (int j = 0; j < string3.length(); ++j) {
                char c = string3.charAt(j);
                switch (c) {
                    case '(': 
                    case '{': {
                        stack.push(Character.valueOf(c));
                        break;
                    }
                    case ')': {
                        if (!stack.isEmpty() && ((Character)stack.pop()).charValue() == '(') break;
                        bl = true;
                        break;
                    }
                    case '}': {
                        if (!stack.isEmpty() && ((Character)stack.pop()).charValue() == '{') break;
                        bl = true;
                        break;
                    }
                }
                if (bl) break;
            }
            if (!bl && stack.isEmpty()) continue;
            this.mExpresssionTable.changeSelectionAndEdit(i, 2);
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_INCOMPLETE_EXPRESSION"), this.mWizardDialog.getResString("IDS_DBWIZARD_WARNING_TITLE"));
            return false;
        }
        this.saveComputedFields();
        if (this.mIsModified) {
            SPSSUtil.clearLimitPage();
        }
        return super.validate();
    }

    @Override
    public boolean validateOnBack() {
        this.saveComputedFields();
        return super.validateOnBack();
    }

    private void saveComputedFields() {
        this.mIsModified = false;
        ComputeNewFieldsPageInfo computeNewFieldsPageInfo = ComputeNewFieldsPageInfo.getNewFieldsInfo();
        ArrayList<ComputedColumn> arrayList = new ArrayList<ComputedColumn>();
        CNFExpressionTable.NewFieldsTableModel newFieldsTableModel = (CNFExpressionTable.NewFieldsTableModel)this.mExpresssionTable.getModel();
        for (int i = 0; i < newFieldsTableModel.getRowCount(); ++i) {
            ComputedFieldTableData computedFieldTableData = newFieldsTableModel.getRow(i);
            if (!computedFieldTableData.isAvailableData()) continue;
            ComputedColumn computedColumn = new ComputedColumn(new ODBCColumn(null, "", "", "", computedFieldTableData.getFieldName(), 0, "", 0, 0, 0, 0, 0, "", false), computedFieldTableData.getFieldName(), computedFieldTableData.getExpression());
            arrayList.add(computedColumn);
        }
        if (!computeNewFieldsPageInfo.getNewColumns().equals(arrayList)) {
            this.mIsModified = true;
        }
        computeNewFieldsPageInfo.setNewColumns(arrayList);
    }

    private void buildExprTable() {
        this.mExpresssionTable = new CNFExpressionTable(this.mWizardDialog, this);
        this.mExpresssionTable.buildExprTable();
    }

    private void buildFunctionsListModel() {
        DefaultListModel defaultListModel = (DefaultListModel)this.mFunctionsList.getModel();
        defaultListModel.clear();
        if (this.mFunctions != null) {
            for (String[] stringArray : this.mFunctions) {
                defaultListModel.addElement(stringArray[0]);
            }
        }
    }

    private void buildFieldsTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("");
        this.mColNamesInUse = new HashSet<String>();
        ODBC oDBC = ODBC.getODBC();
        Selected selected = Selected.getSelected();
        List<ODBCTable> list = selected.getSelectedTables();
        for (ODBCTable oDBCTable : list) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new TableWrapper(oDBCTable));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            this.mColNamesInUse.add(oDBCTable.getName().toUpperCase());
            List<ODBCColumn> list2 = oDBC.getColumns(oDBCTable.getQualifiedName());
            for (ODBCColumn oDBCColumn : list2) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new ColumnWrapper(oDBCColumn));
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                this.mColNamesInUse.add(oDBCColumn.getColumnName().toUpperCase());
            }
        }
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(defaultMutableTreeNode);
        this.mFieldsTree.setModel(defaultTreeModel);
        this.expandTree(this.mFieldsTree, defaultTreeModel, defaultMutableTreeNode, 0, -1);
    }

    private void expandTree(JTree jTree, DefaultTreeModel defaultTreeModel, Object object, int n, int n2) {
        if (object != null && !defaultTreeModel.isLeaf(object)) {
            jTree.expandRow(n);
            if (n2 != 0) {
                for (int i = 1; n + 1 < jTree.getRowCount() && i < defaultTreeModel.getChildCount(object); ++i) {
                    TreePath treePath;
                    ++n;
                    Object object2 = defaultTreeModel.getChild(object, i);
                    if (object2 == null) break;
                    while ((treePath = jTree.getPathForRow(n)) != null && treePath.getLastPathComponent() != object2) {
                        ++n;
                    }
                    if (treePath == null) break;
                    this.expandTree(jTree, defaultTreeModel, object2, n, n2 - 1);
                }
            }
        }
    }

    private JPanel setupExpressionTablePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_DB_CNF_TABLE_LABEL");
        jLabel.setLabelFor(this.mExpresssionTable);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mExpresssionTable.setMinimumSize(new Dimension(200, 50));
        Dimension dimension = new Dimension(this.mExpresssionTable.getMinimumSize().width, 50);
        this.mExpresssionPane = new JScrollPane(this.mExpresssionTable);
        this.mExpresssionTable.setPreferredScrollableViewportSize(dimension);
        this.mExpresssionPane.setPreferredSize(dimension);
        this.mExpresssionPane.setHorizontalScrollBarPolicy(30);
        this.mExpresssionPane.setVerticalScrollBarPolicy(20);
        DialogUtil.addUsingGBL(jPanel, this.mExpresssionPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupFieldsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_DB_CNF_FIELDS_LABEL");
        jLabel.setLabelFor(this.mFieldsTree);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mFieldsTreePane = new JScrollPane(this.mFieldsTree);
        this.mFieldsTreePane.setHorizontalScrollBarPolicy(30);
        this.mFieldsTreePane.setVerticalScrollBarPolicy(20);
        this.mFieldsTreePane.setMinimumSize(new Dimension(80, 100));
        this.mFieldsTreePane.setPreferredSize(new Dimension(80, 100));
        DialogUtil.addUsingGBL(jPanel, this.mFieldsTreePane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupOperatorsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_DB_CNF_OPERATORS_LABEL");
        jLabel.setLabelFor(this.mOperatorsPanel);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mOperatorsPanel.setMinimumSize(new Dimension(80, 100));
        this.mOperatorsPanel.setPreferredSize(new Dimension(80, 100));
        DialogUtil.addUsingGBL(jPanel, this.mOperatorsPanel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupFunctionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_DB_CNF_FUNCTIONS_LABEL");
        jLabel.setLabelFor(this.mFunctionsList);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mFunctionsList);
        jScrollPane.setMinimumSize(new Dimension(80, 100));
        jScrollPane.setPreferredSize(new Dimension(80, 100));
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 3, 1, 1, n, insets);
        return jPanel;
    }

    private boolean isDuplicateName(String string) {
        if (StringUtils.isNotBlank((String)string) && !this.mColNamesInUse.contains(string.toUpperCase().trim())) {
            CNFExpressionTable.NewFieldsTableModel newFieldsTableModel = (CNFExpressionTable.NewFieldsTableModel)this.mExpresssionTable.getModel();
            int n = 0;
            for (int i = 0; i < newFieldsTableModel.getRowCount(); ++i) {
                String string2 = newFieldsTableModel.getRow(i).getFieldName();
                if (!string.trim().equalsIgnoreCase(string2.trim())) continue;
                ++n;
            }
            return n > 1;
        }
        return true;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof JTextField || object instanceof PlainTable) {
            if (this.mExpresssionTable.getFocusCell() == null) {
                this.mExpresssionTable.changeSelection(0, 1, false, false);
            }
            this.mExpresssionPane.setBorder(BorderFactory.createLineBorder(Color.BLUE));
        } else if (object instanceof JTree) {
            this.mFieldsTreePane.setBorder(BorderFactory.createLineBorder(Color.BLUE));
            if (this.mFieldsTree.getSelectionRows() == null) {
                this.mFieldsTree.setSelectionRow(0);
            }
        } else if (object instanceof ColumnCalcWidget) {
            this.mOperatorsPanel.setBorder(BorderFactory.createLineBorder(Color.BLUE));
        } else if (object instanceof PlainList && this.mFunctionsList.getSelectedIndex() == -1) {
            this.mFunctionsList.setSelectedIndex(0);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof JTextField || object instanceof PlainTable) {
            this.mExpresssionPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        } else if (object instanceof JTree) {
            this.mFieldsTreePane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        } else if (object instanceof ColumnCalcWidget) {
            this.mOperatorsPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        }
    }

    private class CNFFunctionDragAdapter
    extends PlainListDragAdapter {
        private PlainList mSourceList;

        public CNFFunctionDragAdapter(PlainList plainList, DragPane dragPane, String string) {
            super(plainList, dragPane, string);
            this.mSourceList = null;
            this.mSourceList = plainList;
        }

        @Override
        public Object getTransferData() {
            int n = this.mSourceList.getSelectedIndex();
            if (n >= 0) {
                int[] nArray = new int[]{n};
                Object[] objectArray = new String[]{ComputeNewFieldsPage.this.mFunctions[n][1]};
                PlainList plainList = this.mSourceList;
                plainList.getClass();
                return plainList.new PlainList.TransferData(objectArray, nArray, this.mSourceList);
            }
            return null;
        }
    }
}

