/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.compute_new_fields;

import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

class ColumnCalcWidget
extends JPanel {
    protected static Map<Integer, String> operatorMap;
    protected static final int OPERATOR_PLUS = 1;
    protected static final int OPERATOR_MINUS = 2;
    protected static final int OPERATOR_MULTIPLICATION = 3;
    protected static final int OPERATOR_DIVISION = 4;
    protected static final int OPERATOR_DOUBLE_CROSS = 5;
    private static final int OPERATOR_LESS_THAN = 6;
    private static final int OPERATOR_LESS_THAN_EQUAL = 7;
    private static final int OPERATOR_GREATER_THAN = 8;
    private static final int OPERATOR_GREATER_THAN_EQUAL = 9;
    private static final int OPERATOR_EQUAL = 10;
    private static final int OPERATOR_AND = 11;
    private static final int OPERATOR_OR = 12;
    private static final int OPERATOR_NEGATION = 13;
    private static final int OPERATOR_NEGATION_EQUAL = 14;
    private static final int OPERATOR_POWER = 15;
    protected static final int KEY_SETS_GAP = 9;
    protected static final int BUTTON_HORIZONTAL_GAP = 4;
    protected static final int BUTTON_VERTICAL_GAP = 4;
    protected CalcType mCalcType;
    protected Action mAction;
    protected Vector<AbstractButton> mButtonsGroup = new Vector();
    protected ButtonGroupKeylistener mArrowKeyListener = new ButtonGroupKeylistener();
    protected JButton mPlusButton;
    protected JButton mMinusButton;
    protected JButton mMultiplicationButton;
    protected JButton mDivisionButton;
    private JButton mLessThanButton;
    private JButton mLessThanEqualsButton;
    private JButton mEqualButton;
    private JButton mGreaterThanButton;
    private JButton mGreaterThanEqualsButton;
    private JButton mCapNegationEqualsButton;
    protected JButton mRoundBracketButton;

    public ColumnCalcWidget(Action action) {
        this(action, CalcType.eNoRelationalOperator);
    }

    public ColumnCalcWidget(Action action, CalcType calcType) {
        this.mAction = action;
        this.setCalcType(calcType);
        if (null == operatorMap) {
            this.initOperatorMap();
        }
        this.init();
    }

    public void setCalcType(CalcType calcType) {
        this.mCalcType = calcType;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.recursiveEnableDisable(this, bl);
    }

    public JButton getDefaultFocusButton() {
        return this.mPlusButton;
    }

    private void recursiveEnableDisable(Container container, boolean bl) {
        for (Component component : container.getComponents()) {
            if (component instanceof JButton) {
                component.setEnabled(bl);
            }
            if (!(component instanceof Container)) continue;
            this.recursiveEnableDisable((Container)component, bl);
        }
    }

    protected void initOperatorMap() {
        operatorMap = new HashMap<Integer, String>();
        operatorMap.put(1, "+");
        operatorMap.put(2, "-");
        operatorMap.put(3, "*");
        operatorMap.put(4, "/");
        operatorMap.put(5, "**");
        operatorMap.put(6, "<");
        operatorMap.put(7, "<=");
        operatorMap.put(10, "=");
        operatorMap.put(8, ">");
        operatorMap.put(9, ">=");
        operatorMap.put(14, "!=");
    }

    protected void init() {
        this.setupCalcPanel();
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.populateButtonGroupVector();
    }

    protected void setupCalcPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 10;
        int n2 = 1;
        Insets insets = new Insets(0, 0, 0, 9);
        DialogUtil.addUsingGBL(this, this.setupOperatorPanel(), gridBagConstraints, n2++, 0, 1, 1, n, insets);
        if (this.mCalcType == CalcType.eRelationalOperator) {
            DialogUtil.addUsingGBL(this, this.setupRelationalPanel(), gridBagConstraints, n2, 0, 2, 1, n, insets);
            n2 += 2;
        }
        Dimension dimension = this.mCalcType == CalcType.eRelationalOperator ? new Dimension(190, 165) : new Dimension(131, 165);
        this.setMinimumSize(dimension);
    }

    protected JPanel setupRelationalPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 10;
        Insets insets = new Insets(0, 0, 0, 4);
        this.mLessThanButton = this.createButtonWithAction(operatorMap.get(6));
        DialogUtil.addUsingGBL(jPanel, this.mLessThanButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mGreaterThanButton = this.createButtonWithAction(operatorMap.get(8));
        DialogUtil.addUsingGBL(jPanel, this.mGreaterThanButton, gridBagConstraints, 1, 0, 1, 1, n, null);
        insets = new Insets(4, 0, 0, 4);
        Insets insets2 = new Insets(4, 0, 0, 0);
        this.mLessThanEqualsButton = this.createButtonWithAction(operatorMap.get(7));
        DialogUtil.addUsingGBL(jPanel, this.mLessThanEqualsButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mGreaterThanEqualsButton = this.createButtonWithAction(operatorMap.get(9));
        DialogUtil.addUsingGBL(jPanel, this.mGreaterThanEqualsButton, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        this.mEqualButton = this.createButtonWithAction(operatorMap.get(10));
        DialogUtil.addUsingGBL(jPanel, this.mEqualButton, gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.mCapNegationEqualsButton = this.createButtonWithAction(operatorMap.get(14));
        DialogUtil.addUsingGBL(jPanel, this.mCapNegationEqualsButton, gridBagConstraints, 1, 2, 1, 1, n, insets2);
        this.mRoundBracketButton = this.createButtonWithAction("( )");
        DialogUtil.addUsingGBL(jPanel, this.mRoundBracketButton, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        return jPanel;
    }

    protected JPanel setupOperatorPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 10;
        Insets insets = new Insets(4, 0, 0, 0);
        this.mPlusButton = this.createButtonWithAction(operatorMap.get(1));
        DialogUtil.addUsingGBL(jPanel, this.mPlusButton, gridBagConstraints, 0, 0, 1, 1, n, null);
        this.mMinusButton = this.createButtonWithAction(operatorMap.get(2));
        DialogUtil.addUsingGBL(jPanel, this.mMinusButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        this.mMultiplicationButton = this.createButtonWithAction(operatorMap.get(3));
        DialogUtil.addUsingGBL(jPanel, this.mMultiplicationButton, gridBagConstraints, 0, 2, 1, 1, n, insets);
        this.mDivisionButton = this.createButtonWithAction(operatorMap.get(4));
        DialogUtil.addUsingGBL(jPanel, this.mDivisionButton, gridBagConstraints, 0, 3, 1, 1, n, insets);
        return jPanel;
    }

    protected JButton createButtonWithAction(String string) {
        JButton jButton = new JButton(this.mAction);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        int n = 35;
        int n2 = 30;
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            n = 35;
            n2 = 30;
            jButton.putClientProperty("JButton.buttonType", "square");
        }
        jButton.setPreferredSize(new Dimension(n, n2));
        jButton.setText(string);
        jButton.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ColumnCalcWidget.this.setBorder(BorderFactory.createLineBorder(Color.BLUE));
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ColumnCalcWidget.this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            }
        });
        return jButton;
    }

    protected void populateButtonGroupVector() {
        this.mButtonsGroup.addElement(this.mPlusButton);
        this.mButtonsGroup.addElement(this.mMinusButton);
        this.mButtonsGroup.addElement(this.mMultiplicationButton);
        this.mButtonsGroup.addElement(this.mDivisionButton);
        this.mPlusButton.addKeyListener(this.mArrowKeyListener);
        this.mMinusButton.addKeyListener(this.mArrowKeyListener);
        this.mMultiplicationButton.addKeyListener(this.mArrowKeyListener);
        this.mDivisionButton.addKeyListener(this.mArrowKeyListener);
        if (this.mCalcType == CalcType.eRelationalOperator) {
            this.mButtonsGroup.addElement(this.mLessThanButton);
            this.mButtonsGroup.addElement(this.mLessThanEqualsButton);
            this.mButtonsGroup.addElement(this.mEqualButton);
            this.mButtonsGroup.addElement(this.mGreaterThanButton);
            this.mButtonsGroup.addElement(this.mGreaterThanEqualsButton);
            this.mButtonsGroup.addElement(this.mCapNegationEqualsButton);
            this.mButtonsGroup.addElement(this.mRoundBracketButton);
            this.mLessThanButton.addKeyListener(this.mArrowKeyListener);
            this.mLessThanEqualsButton.addKeyListener(this.mArrowKeyListener);
            this.mEqualButton.addKeyListener(this.mArrowKeyListener);
            this.mGreaterThanButton.addKeyListener(this.mArrowKeyListener);
            this.mGreaterThanEqualsButton.addKeyListener(this.mArrowKeyListener);
            this.mCapNegationEqualsButton.addKeyListener(this.mArrowKeyListener);
            this.mRoundBracketButton.addKeyListener(this.mArrowKeyListener);
        }
    }

    private class ButtonGroupKeylistener
    extends KeyAdapter {
        private ButtonGroupKeylistener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            AbstractButton abstractButton = (AbstractButton)keyEvent.getComponent();
            if (keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 39) {
                AbstractButton abstractButton2;
                int n = ColumnCalcWidget.this.mButtonsGroup.indexOf(abstractButton) + 1;
                do {
                    if (n != ColumnCalcWidget.this.mButtonsGroup.size()) continue;
                    n = 0;
                } while (!(abstractButton2 = ColumnCalcWidget.this.mButtonsGroup.elementAt(n++)).isEnabled());
                this.focusButton(abstractButton2);
            } else if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 37) {
                AbstractButton abstractButton3;
                int n = ColumnCalcWidget.this.mButtonsGroup.indexOf(abstractButton) - 1;
                do {
                    if (n != -1) continue;
                    n += ColumnCalcWidget.this.mButtonsGroup.size();
                } while (!(abstractButton3 = ColumnCalcWidget.this.mButtonsGroup.elementAt(n--)).isEnabled());
                this.focusButton(abstractButton3);
            }
        }

        private void focusButton(AbstractButton abstractButton) {
            abstractButton.requestFocusInWindow();
        }
    }

    public static enum CalcType {
        eRelationalOperator,
        eNoRelationalOperator;

    }
}

