/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.compute_new_fields;

import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.drag_drop.AbstractTableDropListener;
import com.spss.java_client.ui.dialogs.base.file.openquery.compute_new_fields.CNFExpressionTable;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.gui.ColumnWrapper;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCColumn;
import com.spss.uitools.controls.drag_drop.DragDropAdapter;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.DropEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

class CNFTableDropListener
extends AbstractTableDropListener {
    public CNFTableDropListener(CNFExpressionTable cNFExpressionTable, Component component) {
        super(cNFExpressionTable, component);
    }

    @Override
    public Cursor dragItemOver(Point point, DragDropAdapter dragDropAdapter) {
        Cursor cursor = null;
        Point point2 = (Point)point.clone();
        SwingUtilities.convertPointFromScreen(point2, this.mDropTarget);
        if (!(this.mDropTarget instanceof CNFExpressionTable)) {
            return DragPane.getNoDropCursor();
        }
        CNFExpressionTable cNFExpressionTable = (CNFExpressionTable)this.mDropTarget;
        int n = cNFExpressionTable.rowAtPoint(point2);
        int n2 = cNFExpressionTable.columnAtPoint(point2);
        if (n2 != 2) {
            return DragPane.getNoDropCursor();
        }
        if (!cNFExpressionTable.isCellEditable(n, n2)) {
            return DragPane.getNoDropCursor();
        }
        boolean bl = false;
        if (this.contains(point) || this.mDropTarget instanceof JTable && ((JTable)this.mDropTarget).getRowCount() == 0) {
            this.mCanImport = this.canDrop(dragDropAdapter);
            if (this.mCanImport) {
                bl = true;
                cursor = Cursor.getPredefinedCursor(12);
            } else {
                this.showDropFeedback(null);
                cursor = DragPane.getNoDropCursor();
            }
        } else {
            this.showDropFeedback(null);
        }
        this.setHighlightBorder(bl);
        return cursor;
    }

    @Override
    public void itemDropped(DropEvent dropEvent) {
        if (!(this.mDropTarget instanceof CNFExpressionTable)) {
            return;
        }
        Point point = (Point)dropEvent.getDropLocation().clone();
        SwingUtilities.convertPointFromScreen(point, this.mDropTarget);
        final CNFExpressionTable cNFExpressionTable = (CNFExpressionTable)this.mDropTarget;
        final int n = cNFExpressionTable.rowAtPoint(point);
        final int n2 = cNFExpressionTable.columnAtPoint(point);
        if (n < 0 || n2 != 2 || !cNFExpressionTable.isCellEditable(n, n2)) {
            return;
        }
        Object object = dropEvent.getTransferData();
        if (object instanceof PlainList.TransferData) {
            Object[] objectArray;
            PlainList.TransferData transferData = (PlainList.TransferData)object;
            for (final Object object2 : objectArray = transferData.getVariables()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        cNFExpressionTable.updateExpressionAt(object2.toString(), n, n2);
                    }
                });
            }
        } else if (object instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            assert (defaultMutableTreeNode.isLeaf());
            ODBCColumn oDBCColumn = ((ColumnWrapper)defaultMutableTreeNode.getUserObject()).getColumn();
            final String string = oDBCColumn.getQuotedQualifiedColumnName();
            if (cNFExpressionTable.isEditing()) {
                cNFExpressionTable.getCellEditor().stopCellEditing();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    cNFExpressionTable.updateExpressionAt(string, n, n2);
                }
            });
        }
    }

    @Override
    public boolean canDrop(DragDropAdapter dragDropAdapter) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        boolean bl = false;
        if (!(this.mDropTarget.isEnabled() && this.mDropTarget.isShowing() && ((CNFExpressionTable)this.mDropTarget).isDragSupported())) {
            return bl;
        }
        Object object = dragDropAdapter.getTransferData();
        if (object != null && object instanceof PlainList.TransferData) {
            PlainList.TransferData transferData = (PlainList.TransferData)object;
            if (transferData.getSource() != null && this.getRegisteredSource() != transferData.getSource()) {
                return bl;
            }
            Object[] objectArray = transferData.getVariables();
            if (objectArray != null && objectArray.length > 0) {
                bl = true;
            }
        } else if (object != null && object instanceof DefaultMutableTreeNode && (defaultMutableTreeNode = (DefaultMutableTreeNode)object).isLeaf()) {
            bl = true;
        }
        return bl;
    }

    @Override
    protected void importData(Object object, JComponent jComponent, int n) {
    }
}

