/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.compute_new_fields;

import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.dialogs.base.file.openquery.compute_new_fields.ComputeNewFieldsPage;
import com.spss.java_client.ui.dialogs.base.file.openquery.compute_new_fields.ComputedFieldTableData;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Component;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.DefaultCaret;
import org.apache.commons.lang.StringUtils;

class CNFExpressionTable
extends PlainTable {
    private BaseWizardDialog mWizardDialog;
    private ComputeNewFieldsPage mPage;

    CNFExpressionTable(BaseWizardDialog baseWizardDialog, ComputeNewFieldsPage computeNewFieldsPage) {
        this.mWizardDialog = baseWizardDialog;
        this.mPage = computeNewFieldsPage;
    }

    void buildExprTable() {
        NewFieldsTableModel newFieldsTableModel = new NewFieldsTableModel();
        newFieldsTableModel.fillWithDefualtRows();
        this.setModel(newFieldsTableModel);
        TableColumn tableColumn = this.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                component.setBackground(jTable.getTableHeader().getBackground());
                component.setFont(jTable.getTableHeader().getFont());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return component;
            }
        });
        ExpressionTextFieldCellRender expressionTextFieldCellRender = new ExpressionTextFieldCellRender();
        JTextField jTextField = new JTextField();
        jTextField.addFocusListener(this.mPage);
        DefaultCellEditor defaultCellEditor = new FieldNameEditor(jTextField);
        defaultCellEditor.setClickCountToStart(2);
        TableColumn tableColumn2 = this.getColumnModel().getColumn(1);
        tableColumn2.setCellEditor(defaultCellEditor);
        tableColumn2.setCellRenderer(expressionTextFieldCellRender);
        jTextField = new JTextField();
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            jTextField.setCaret(new DefaultCaret());
        }
        jTextField.addFocusListener(this.mPage);
        defaultCellEditor = new DefaultCellEditor(jTextField);
        defaultCellEditor.setClickCountToStart(2);
        TableColumn tableColumn3 = this.getColumnModel().getColumn(2);
        tableColumn3.setCellEditor(defaultCellEditor);
        tableColumn3.setCellRenderer(expressionTextFieldCellRender);
        this.getTableHeader().setReorderingAllowed(false);
        this.setRowHeight(this.getRowHeight() + 4);
        this.addFocusListener(this.mPage);
        tableColumn.setPreferredWidth(30);
        tableColumn2.setPreferredWidth(100);
        tableColumn3.setPreferredWidth(400);
        this.setRowHeight(jTextField.getMinimumSize().height - 2);
        this.changeSelection(0, 1, false, false);
        this.requestFocusInWindow();
    }

    void updateExpressionAt(String string, int n, int n2) {
        if (StringUtils.isBlank((String)string) || n < 0 || n2 != 2) {
            return;
        }
        if (this.getSelectedRow() != n) {
            this.editCellAt(n, n2);
        }
        JTextField jTextField = (JTextField)((DefaultCellEditor)this.getCellEditor(n, n2)).getComponent();
        int n3 = jTextField.getSelectionStart();
        int n4 = jTextField.getSelectionEnd();
        String string2 = jTextField.getSelectedText();
        String string3 = jTextField.getText();
        boolean bl = "?".equals(string2);
        if (StringUtils.isNotBlank((String)string2)) {
            string = string.replaceFirst("\\?", Matcher.quoteReplacement(string2));
            bl = true;
        } else if (string.contains("?")) {
            bl = true;
        }
        if ("( )".equals(string.trim())) {
            string = "(" + (StringUtils.isBlank((String)string2) ? "" : string2) + ")";
        }
        String string4 = string3.substring(0, n3) + string + string3.substring(n4);
        jTextField.setText(string4);
        this.setValueAt(string4, n, n2);
        NewFieldsTableModel newFieldsTableModel = (NewFieldsTableModel)this.getModel();
        newFieldsTableModel.fireTableDataChanged();
        this.changeSelection(n, n2, false, false);
        this.editCellAt(n, n2);
        Component component = this.getEditorComponent();
        ((JComponent)component).requestFocusInWindow();
        int n5 = string4.substring(n3).indexOf("?");
        if (n5 > -1 && bl) {
            jTextField.setSelectionStart(n3 + n5);
            jTextField.setSelectionEnd(n3 + n5 + 1);
        } else {
            jTextField.setCaretPosition(n3 + string.length());
        }
    }

    public void changeSelectionAndEdit(int n, int n2) {
        this.changeSelection(n, n2, false, false);
        this.editCellAt(n, n2);
    }

    private class FieldNameEditor
    extends DefaultCellEditor {
        public FieldNameEditor(JTextField jTextField) {
            super(jTextField);
        }

        @Override
        public boolean stopCellEditing() {
            ((CNFExpressionTable)CNFExpressionTable.this).mPage.mIsShowWarning = false;
            String string = this.getCellEditorValue().toString();
            if (string.length() > 0) {
                if (VarNameValidator.validateAgainstCurCharSet((String)string)) {
                    ((CNFExpressionTable)CNFExpressionTable.this).mPage.mIsShowWarning = true;
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)CNFExpressionTable.this.mWizardDialog), UIToolResUtil.getString((String)"ERR_STRING_UNMAPPABLE_MSG"), CNFExpressionTable.this.mWizardDialog.getResString("IDS_DBWIZARD_WARNING_TITLE"));
                    return false;
                }
                VarNameValidator.ValidNameCode validNameCode = VarNameValidator.validateSPSSName((String)string.toUpperCase(), (boolean)true);
                String string2 = "";
                switch (validNameCode) {
                    case SPSSNAME_SCRATCH: {
                        string2 = MessageFormat.format(CNFExpressionTable.this.mWizardDialog.getResString("ERR_FIELDNAME_SCRATCH"), string);
                        break;
                    }
                    case SPSSNAME_SYSTEM: {
                        string2 = MessageFormat.format(CNFExpressionTable.this.mWizardDialog.getResString("ERR_FIELDNAME_SYSTEM"), string);
                        break;
                    }
                    case SPSSNAME_BADLTH: {
                        string2 = CNFExpressionTable.this.mWizardDialog.getResString("ERR_FIELDNAME_LONG");
                        break;
                    }
                    case SPSSNAME_BADCHAR: {
                        string2 = MessageFormat.format(CNFExpressionTable.this.mWizardDialog.getResString("ERR_FIELDNAME_INVALID_CHARACTER"), string);
                        break;
                    }
                    case SPSSNAME_RESERVED: {
                        string2 = MessageFormat.format(CNFExpressionTable.this.mWizardDialog.getResString("ERR_FIELDNAME_RESERVED_WORD"), string);
                        break;
                    }
                    case SPSSNAME_BADFIRST: {
                        string2 = MessageFormat.format(CNFExpressionTable.this.mWizardDialog.getResString("ERR_FIELDNAME_IVD_FIRST"), string);
                        break;
                    }
                    case SPSSNAME_BADLAST: {
                        string2 = MessageFormat.format(CNFExpressionTable.this.mWizardDialog.getResString("ERR_FIELDNAME_IVD_LAST"), string);
                        break;
                    }
                }
                if (StringUtils.isNotBlank((String)string2)) {
                    ((CNFExpressionTable)CNFExpressionTable.this).mPage.mIsShowWarning = true;
                    SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)CNFExpressionTable.this.mWizardDialog), string2, CNFExpressionTable.this.mWizardDialog.getResString("IDS_DBWIZARD_WARNING_TITLE"));
                    return false;
                }
            }
            return super.stopCellEditing();
        }
    }

    private class ExpressionTextFieldCellRender
    extends JLabel
    implements TableCellRenderer {
        Border mEmptyBorder = BorderFactory.createEmptyBorder();
        Border mHighLightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");

        private ExpressionTextFieldCellRender() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground(jTable.getBackground());
            if (object == null) {
                this.setText("");
            } else {
                this.setText(object.toString());
            }
            if (jTable.getColumnModel().getSelectionModel().getLeadSelectionIndex() == n2 && jTable.getSelectionModel().getLeadSelectionIndex() == n) {
                this.setBorder(this.mHighLightBorder);
            } else {
                this.setBorder(this.mEmptyBorder);
            }
            return this;
        }
    }

    protected class NewFieldsTableModel
    extends AbstractTableModel {
        private String[] mColNames;
        private List<ComputedFieldTableData> mDataRows;
        public static final int DEFAULT_EXPRESSION_NUM = 10;
        public static final int SERIAL_NUM_COLUMN = 0;
        public static final int FIELD_NAME_COLUMN = 1;
        public static final int EXPRESSION_COLUMN = 2;

        public NewFieldsTableModel() {
            this.mColNames = new String[]{" ", CNFExpressionTable.this.mWizardDialog.getResString("IDS_DB_CNF_TABLE_LABEL_FIELD"), CNFExpressionTable.this.mWizardDialog.getResString("IDS_DB_CNF_TABLE_LABEL_EXPRESSION")};
            this.mDataRows = new ArrayList<ComputedFieldTableData>();
        }

        public boolean addNewElement() {
            int n = this.mDataRows.size() + 1;
            ComputedFieldTableData computedFieldTableData = new ComputedFieldTableData(n);
            return this.mDataRows.add(computedFieldTableData);
        }

        @Override
        public int getRowCount() {
            return this.mDataRows.size();
        }

        public ComputedFieldTableData getRow(int n) {
            return this.mDataRows.get(n);
        }

        @Override
        public int getColumnCount() {
            return this.mColNames.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ComputedFieldTableData computedFieldTableData = this.mDataRows.get(n);
            switch (n2) {
                case 0: {
                    return computedFieldTableData.getSerialNumber();
                }
                case 1: {
                    return computedFieldTableData.getFieldName();
                }
                case 2: {
                    return computedFieldTableData.getExpression();
                }
            }
            return "";
        }

        @Override
        public String getColumnName(int n) {
            return this.mColNames[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return false;
            }
            if (n == 0) {
                return true;
            }
            if (n > 0) {
                ComputedFieldTableData computedFieldTableData = this.mDataRows.get(n);
                if (!computedFieldTableData.isBlankData()) {
                    return true;
                }
                ComputedFieldTableData computedFieldTableData2 = this.mDataRows.get(n - 1);
                return computedFieldTableData2.isAvailableData();
            }
            return true;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ComputedFieldTableData computedFieldTableData = this.mDataRows.get(n);
            switch (n2) {
                case 0: {
                    return;
                }
                case 1: {
                    computedFieldTableData.setFieldName(object.toString());
                    break;
                }
                case 2: {
                    computedFieldTableData.setExpression(object.toString());
                }
            }
            if (computedFieldTableData.isAvailableData() && computedFieldTableData == this.mDataRows.get(this.mDataRows.size() - 1)) {
                this.mDataRows.add(new ComputedFieldTableData(this.mDataRows.size() + 1));
            }
        }

        public void fillWithDefualtRows() {
            int n = this.mDataRows.size();
            for (int i = 0; i < 10 - n; ++i) {
                this.addNewElement();
            }
        }

        public void clear() {
            this.mDataRows.clear();
        }
    }
}

