/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.aggregate_data;

import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.ColumnsInfo;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.TablesInfo;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.PlainList;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.SpssArrowButton;
import com.spss.java_client.ui.controls.drag_drop.PlainListDragAdapter;
import com.spss.java_client.ui.controls.drag_drop.PlainListDropListener;
import com.spss.java_client.ui.dialogs.base.file.openquery.AbstractDBWizardCommonPage;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBData;
import com.spss.java_client.ui.dialogs.base.file.openquery.NewQueryDlg;
import com.spss.java_client.ui.dialogs.base.file.openquery.aggregate_data.ADPSrcListDropListener;
import com.spss.java_client.ui.dialogs.base.file.openquery.aggregate_data.ADPTableDragAdapter;
import com.spss.java_client.ui.dialogs.base.file.openquery.aggregate_data.ADPTableDropListener;
import com.spss.java_client.ui.dialogs.base.file.openquery.aggregate_data.AggregatedVariables;
import com.spss.java_client.ui.dialogs.base.file.openquery.aggregate_data.BreakVariableArrowButton;
import com.spss.java_client.ui.dialogs.base.file.openquery.aggregate_data.SummariesVariableArrowButton;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBListCellRenderer;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBListEntry;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBWizardSyntaxUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBWizardUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.AggregateColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.AggregatePageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.ComputeNewFieldsPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.ComputedColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.SPSSColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.SPSSUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.Selected;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.IPlainListVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class AggregateDataPage
extends AbstractDBWizardCommonPage
implements TableModelListener,
ListDataListener,
ItemListener,
FocusListener,
IPlainListVarMoveHandler {
    private static final String IDS_DB_AD_NUMBER_CASES_CHECK = "IDS_DB_AD_NUMBER_CASES_CHECK";
    private DialogFocusTraversalPolicy mPolicy;
    private PlainList mSourceVariableList;
    private PlainList mBreakVariableList;
    private JCheckBox mNumberCasesCheck;
    private BreakVariableArrowButton mBreakVarArrow;
    private SummariesVariableArrowButton mAggreagatedVarArrow;
    private SummariesVariablesTable mSummariesVarsTable;
    private JScrollPane mTableScroll;
    private DefaultCellEditor mStringEditor;
    private DefaultCellEditor mNumericEditor;
    private TreeMap<String, ColumnsInfo.InternalColumnInfo> mSourceListObjectsMap;
    private TreeMap<String, ColumnsInfo.InternalColumnInfo> mBreakVarListObjectsMap;
    private DefaultListModel mSourceListModel;
    private DefaultListModel mBreakVariableListModel;
    private ArrayList<AggregatedVariables> mAggregateVarRows;
    private boolean mFromLRCPage;
    private HashSet<String> mTableColumnSet;
    private LinkedList<String> mSelectDataListOrder;
    private DragPane mGlassPane;
    private PlainListDropListener mBreakVarListDropListener;
    private PlainListDropListener mSrcVarListDropListener;
    private ADPSrcListDropListener mSrcListTableDropListener;
    private ADPTableDropListener mTableDropListenr;
    private ADPTableDragAdapter mTableAdapter;
    private boolean mIsModified = false;

    public AggregateDataPage(BaseWizardDialog baseWizardDialog) {
        super("AggregateDataPage", baseWizardDialog, true);
        this.mWizardDialog = baseWizardDialog;
    }

    @Override
    public String getNextPage() {
        return "DefineVariablesPage";
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_aggregate_data";
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.enableNext();
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.mBreakVariableList.getModel())) {
            Object[] objectArray;
            for (Object object : objectArray = this.mSourceVariableList.getSelectedValues()) {
                String string = ((DBListEntry)object).getText();
                ColumnsInfo.InternalColumnInfo internalColumnInfo = this.mSourceListObjectsMap.get(string);
                if (internalColumnInfo == null) continue;
                this.mBreakVarListObjectsMap.put(string, internalColumnInfo);
                this.mSourceListObjectsMap.remove(string);
            }
        } else if (listDataEvent.getSource().equals(this.mSourceVariableList.getModel())) {
            Object[] objectArray;
            for (Object object : objectArray = this.mBreakVariableList.getSelectedValues()) {
                String string = ((DBListEntry)object).getText();
                ColumnsInfo.InternalColumnInfo internalColumnInfo = this.mBreakVarListObjectsMap.get(string);
                if (internalColumnInfo == null) continue;
                this.mSourceListObjectsMap.put(string, internalColumnInfo);
                this.mBreakVarListObjectsMap.remove(string);
            }
        }
        this.arrangeSourceList();
        this.enableNext();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.enableNext();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.enableNext();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            int n = this.mSummariesVarsTable.getSelectedRow();
            ((SummariesVarsTableModel)this.mSummariesVarsTable.getModel()).updateRow(itemEvent.getItem().toString());
            if (n > -1 && n < this.mSummariesVarsTable.getModel().getRowCount()) {
                this.mSummariesVarsTable.setRowSelectionInterval(n, n);
            }
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mSummariesVarsTable)) {
            this.mTableScroll.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.mSummariesVarsTable)) {
            this.mAggreagatedVarArrow.setEnabled(true);
            this.mAggreagatedVarArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            this.mBreakVarArrow.setEnabled(false);
            this.mTableScroll.setBorder(BorderFactory.createLineBorder(DialogUtil.getFocusBorderColor()));
            return;
        }
        if (this.mSummariesVarsTable.getCellEditor() != null) {
            this.mSummariesVarsTable.getCellEditor().stopCellEditing();
        }
        if (focusEvent.getSource().equals(this.mSourceVariableList)) {
            this.mBreakVarArrow.setEnabled(true);
            this.mAggreagatedVarArrow.setEnabled(true);
            this.mBreakVarArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
            this.mAggreagatedVarArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.right);
        } else if (focusEvent.getSource().equals(this.mBreakVariableList)) {
            this.mBreakVarArrow.setEnabled(true);
            this.mBreakVarArrow.setArrowOrientation(SpssArrowButton.ButtonOrientation.left);
            this.mAggreagatedVarArrow.setEnabled(true);
        }
    }

    @Override
    public boolean isDragAllowed(JList jList, JList jList2, Object[] objectArray) {
        return true;
    }

    @Override
    public boolean preMoveVariables(Object[] objectArray, PlainList plainList) {
        return true;
    }

    @Override
    public Object[] getModifiedData(Object[] objectArray, JList jList, PlainList plainList) {
        return null;
    }

    @Override
    public boolean validate() {
        this.saveAggregatedDataInfo();
        if (this.mIsModified) {
            SPSSUtil.clearDefineVariablesPage();
        }
        this.mFromLRCPage = false;
        return true;
    }

    @Override
    public boolean validateOnBack() {
        this.saveAggregatedDataInfo();
        return super.validateOnBack();
    }

    @Override
    protected void initVars() {
        this.mSourceListObjectsMap = new TreeMap();
        this.mBreakVarListObjectsMap = new TreeMap();
        SummariesVarsTableModel summariesVarsTableModel = new SummariesVarsTableModel();
        this.mSummariesVarsTable = new SummariesVariablesTable(summariesVarsTableModel);
        this.setupTable();
        this.mSummariesVarsTable.getModel().addTableModelListener(this);
        this.mSourceListModel = new DefaultListModel();
        this.mBreakVariableListModel = new DefaultListModel();
        this.mSourceVariableList = new PlainList("ADP_SOURCE_LIST");
        this.mSourceVariableList.setDragEnabled(true);
        this.mSourceVariableList.setModel(this.mSourceListModel);
        this.mSourceVariableList.showDropFeedback(null);
        this.mBreakVariableList = new PlainList("ADP_BREAK_VAR_LIST");
        this.mBreakVariableList.setModel(this.mBreakVariableListModel);
        this.mBreakVariableList.setDragEnabled(true);
        this.mBreakVariableList.setCellRenderer(new DBListCellRenderer());
        this.mBreakVariableList.showDropFeedback(null);
        this.mSourceListModel.addListDataListener(this);
        this.mSourceVariableList.setCellRenderer(new DBListCellRenderer());
        this.mBreakVariableListModel.addListDataListener(this);
        this.mSummariesVarsTable.setRowSelectionAllowed(true);
        this.mSummariesVarsTable.setColumnSelectionAllowed(false);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, IDS_DB_AD_NUMBER_CASES_CHECK){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AggregateDataPage.this.enableNext();
            }
        };
        this.mNumberCasesCheck = new JCheckBox(toggleButtonAction);
        this.mBreakVarArrow = new BreakVariableArrowButton(SpssArrowButton.ButtonOrientation.right, this.mSourceVariableList, this.mBreakVariableList);
        this.mAggreagatedVarArrow = new SummariesVariableArrowButton(SpssArrowButton.ButtonOrientation.right, this.mSourceVariableList, this.mSummariesVarsTable);
        this.mFromLRCPage = true;
        this.mTableColumnSet = new HashSet();
        this.mSelectDataListOrder = new LinkedList();
        this.mBreakVariableList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                    AggregateDataPage.this.mBreakVarArrow.doClick();
                }
            }
        });
        this.mSourceVariableList.addFocusListener(this);
        this.mBreakVariableList.addFocusListener(this);
        this.mSummariesVarsTable.addFocusListener(this);
        this.mGlassPane = (DragPane)this.mWizardDialog.getGlassPane();
        this.createDragDropListeners();
    }

    @Override
    protected void aboutToShowPanel() {
        super.aboutToShowPanel();
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        if (this.mSelectDataListOrder.size() == 0) {
            this.mSelectDataListOrder = DBWizardUtil.getSelectDataLinkedList();
        }
        this.buildLists();
        if (!this.useExistingAggregateData()) {
            this.mAggregateVarRows.clear();
            SummariesVarsTableModel summariesVarsTableModel = (SummariesVarsTableModel)this.mSummariesVarsTable.getModel();
            summariesVarsTableModel.fireTableDataChanged();
            this.mNumberCasesCheck.setSelected(false);
        }
        this.mTableColumnSet.clear();
        this.enableNext();
        this.addDropListeners();
        this.mSourceVariableList.requestFocus();
        this.mSourceVariableList.setSelectedIndex(0);
    }

    @Override
    protected void aboutToHidePanel() {
        super.aboutToHidePanel();
        DBWizardUtil.setDBWizardPreviousPage(DBWizardUtil.DBWizardPreviousPage.eAggregateData);
        this.removeDropListeners();
    }

    @Override
    protected void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSourceVariableList);
        vector.add(this.mBreakVarArrow);
        vector.add(this.mAggreagatedVarArrow);
        vector.add(this.mBreakVariableList);
        vector.add(this.mSummariesVarsTable);
        vector.add(this.mNumberCasesCheck);
        Vector<Object> vector2 = ((NewQueryDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    @Override
    protected JPanel setupPageBody() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, insets.left, n2, insets.right);
        JScrollPane jScrollPane = new JScrollPane(this.mSourceVariableList);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setMinimumSize(this.mSourceVariableList.getPreferredSize());
        jScrollPane.setPreferredSize(this.mSourceVariableList.getPreferredSize());
        jScrollPane.setMaximumSize(this.mSourceVariableList.getPreferredSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 0, 1, 2, n, insets2);
        insets2.bottom = insets.bottom;
        JPanel jPanel2 = this.setupBreakVariablePanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        jPanel2 = this.setupAggregatedVariablePanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 1, 1, 1, n, insets2);
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString("IDS_DB_AD_AGGREGATION_AVAILABLE_LABEL"));
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 2, 2, 1, n, insets2);
        return jPanel;
    }

    @Override
    protected JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, insets.left, n2, insets.right);
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString("IDS_DB_AD_AGGREGATE_DATA_HEADING1"));
        jLabel.setFont(jLabel.getFont().deriveFont(1, 18.0f));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        JTextArea jTextArea = new JTextArea(this.mWizardDialog.getResString("IDS_DB_AD_AGGREGATE_DATA_HEADING2"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void arrangeSourceList() {
        int n = this.mSourceListModel.getSize();
        if (n > 0) {
            String string = ((DBListEntry)this.mSourceListModel.get(n - 1)).getText();
            int n2 = this.mSelectDataListOrder.indexOf(string);
            for (int i = 0; i < n - 1; ++i) {
                String string2 = ((DBListEntry)this.mSourceListModel.get(i)).getText();
                int n3 = this.mSelectDataListOrder.indexOf(string2);
                if (n2 >= n3 || i == n - 1) continue;
                this.mSourceListModel.add(i, this.mSourceListModel.remove(n - 1));
                break;
            }
        }
    }

    private void addDropListeners() {
        this.mGlassPane.addDropListener((IDropListener)this.mBreakVarListDropListener);
        this.mGlassPane.addDropListener((IDropListener)this.mSrcVarListDropListener);
        this.mGlassPane.addDropListener((IDropListener)this.mSrcListTableDropListener);
        this.mGlassPane.addDropListener((IDropListener)this.mTableDropListenr);
    }

    private void removeDropListeners() {
        this.mGlassPane.removeDropListener((IDropListener)this.mBreakVarListDropListener);
        this.mGlassPane.removeDropListener((IDropListener)this.mSrcVarListDropListener);
        this.mGlassPane.removeDropListener((IDropListener)this.mSrcListTableDropListener);
        this.mGlassPane.removeDropListener((IDropListener)this.mTableDropListenr);
    }

    private void createDragDropListeners() {
        PlainListDragAdapter plainListDragAdapter = new PlainListDragAdapter(this.mSourceVariableList, this.mGlassPane, "ADP_SOURCE_LIST");
        DialogUtil.modifyMouseInputListeners(this.mSourceVariableList, plainListDragAdapter);
        this.mSrcVarListDropListener = new PlainListDropListener(this.mSourceVariableList, this);
        plainListDragAdapter = new PlainListDragAdapter(this.mBreakVariableList, this.mGlassPane, "ADP_BREAK_VAR_LIST");
        DialogUtil.modifyMouseInputListeners(this.mBreakVariableList, plainListDragAdapter);
        this.mBreakVarListDropListener = new PlainListDropListener(this.mBreakVariableList, this);
        this.mTableDropListenr = new ADPTableDropListener((PlainTable)this.mSummariesVarsTable, this.mSourceVariableList, this.mAggreagatedVarArrow);
        this.mTableAdapter = new ADPTableDragAdapter(this.mSummariesVarsTable, this.mGlassPane, "ADPPlainTable");
        this.mSrcListTableDropListener = new ADPSrcListDropListener(this.mSourceVariableList, this, this.mAggreagatedVarArrow);
        DialogUtil.modifyMouseInputListeners(this.mSummariesVarsTable, this.mTableAdapter);
    }

    private void saveAggregatedDataInfo() {
        Object object;
        AggregatePageInfo aggregatePageInfo = AggregatePageInfo.getAggregatePageInfo();
        this.mIsModified = false;
        ListModel listModel = this.mBreakVariableList.getModel();
        ArrayList<SPSSColumn> arrayList = new ArrayList<SPSSColumn>(listModel.getSize());
        for (int i = 0; i < listModel.getSize(); ++i) {
            object = ((DBListEntry)listModel.getElementAt(i)).getColumn();
            if (!(object instanceof SPSSColumn)) continue;
            arrayList.add((SPSSColumn)object);
        }
        if (!aggregatePageInfo.getBreakColumns().equals(arrayList)) {
            this.mIsModified = true;
            aggregatePageInfo.setBreakColumns(arrayList);
        }
        TableModel tableModel = this.mSummariesVarsTable.getModel();
        object = new ArrayList(tableModel.getRowCount());
        ArrayList<AggregatedVariables> arrayList2 = ((SummariesVarsTableModel)this.mSummariesVarsTable.getModel()).getAggregateVarRows();
        for (AggregatedVariables aggregatedVariables : arrayList2) {
            String string = DBWizardSyntaxUtil.getSQLFunctionName(aggregatedVariables.getFunction());
            String string2 = aggregatedVariables.getVarName();
            AggregateColumn aggregateColumn = null;
            aggregateColumn = aggregatedVariables.getSourceColumn() instanceof ComputedColumn || aggregatedVariables.getSourceColumn() instanceof AggregateColumn && ((AggregateColumn)aggregatedVariables.getSourceColumn()).isComputedColumn() ? new AggregateColumn(aggregatedVariables.getSourceColumn(), string2, string, true) : new AggregateColumn(aggregatedVariables.getSourceColumn(), string2, string);
            object.add(aggregateColumn);
        }
        if (!aggregatePageInfo.getAggregateColumns().equals(object)) {
            this.mIsModified = true;
            aggregatePageInfo.setAggregateColumns((List<AggregateColumn>)object);
        }
        boolean bl = this.mNumberCasesCheck.isSelected();
        if (aggregatePageInfo.isIncludeNumberOfCases() != bl) {
            this.mIsModified = true;
            aggregatePageInfo.setIncludeNumberOfCases(bl);
        }
    }

    private boolean useExistingAggregateData() {
        AggregatePageInfo aggregatePageInfo = AggregatePageInfo.getAggregatePageInfo();
        if (aggregatePageInfo.isExisting()) {
            Object object;
            List<SPSSColumn> list = aggregatePageInfo.getBreakColumns();
            DefaultListModel defaultListModel = (DefaultListModel)this.mSourceVariableList.getModel();
            DefaultListModel defaultListModel2 = (DefaultListModel)this.mBreakVariableList.getModel();
            for (int i = 0; i < defaultListModel.size(); ++i) {
                object = (DBListEntry)defaultListModel.getElementAt(i);
                if (!list.contains((SPSSColumn)((DBListEntry)object).getColumn())) continue;
                defaultListModel.removeElement(object);
                defaultListModel2.addElement(object);
                --i;
            }
            this.mAggregateVarRows.clear();
            SummariesVarsTableModel summariesVarsTableModel = (SummariesVarsTableModel)this.mSummariesVarsTable.getModel();
            object = aggregatePageInfo.getAggregateColumns();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                AggregateColumn aggregateColumn = (AggregateColumn)iterator.next();
                boolean bl = false;
                if (aggregateColumn.getSPSSDataType() == 1) {
                    bl = true;
                }
                AggregatedVariables aggregatedVariables = new AggregatedVariables(aggregateColumn, aggregateColumn.getSPSSDataType(), aggregateColumn.getSpssName(), DBWizardSyntaxUtil.localizeFunctionName(aggregateColumn.getFunction()), bl);
                this.mAggregateVarRows.add(aggregatedVariables);
                summariesVarsTableModel.fireTableDataChanged();
            }
            this.mNumberCasesCheck.setSelected(aggregatePageInfo.isIncludeNumberOfCases());
            return true;
        }
        return false;
    }

    private void enableNext() {
        boolean bl;
        boolean bl2 = this.mSummariesVarsTable.getModel().getRowCount() == 0;
        boolean bl3 = bl = this.mBreakVariableList.getModel().getSize() == 0;
        boolean bl4 = this.mNumberCasesCheck.isSelected() ? !bl : (bl2 ? bl : !bl);
        this.mWizardDialog.enableNext(bl4);
        this.mWizardDialog.enableFinish(bl4);
    }

    private JPanel setupAggregatedVariablePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_DB_AD_SUMMARIES_VARS_LABEL");
        jLabel.setLabelFor(this.mSummariesVarsTable);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.mTableScroll = new JScrollPane(this.mSummariesVarsTable);
        this.mTableScroll.setPreferredSize(this.mSummariesVarsTable.getMinimumSize());
        this.mTableScroll.setHorizontalScrollBarPolicy(30);
        this.mTableScroll.setVerticalScrollBarPolicy(20);
        DialogUtil.addUsingGBL(jPanel, this.mTableScroll, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        n = 10;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        DialogUtil.addUsingGBL(jPanel, this.mAggreagatedVarArrow, gridBagConstraints, 0, 0, 1, 2, n, insets2);
        Insets insets3 = new Insets(insets.top, insets2.left + n2, insets.bottom, insets.right);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mNumberCasesCheck, gridBagConstraints, 0, 2, 2, 1, n, insets3);
        JTextArea jTextArea = new JTextArea(this.mWizardDialog.getResString("IDS_DB_AD_AGGREGATION_NOTE"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        jTextArea.setPreferredSize(new Dimension(150, 40));
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 3, 2, 1, n, insets);
        jLabel = new JLabel(this.mWizardDialog.getResString("IDS_DB_AD_AGGREGATED_VARS"));
        jPanel = PanelFactory.setupMnemonickey(jPanel, jLabel);
        return jPanel;
    }

    private JPanel setupBreakVariablePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_DB_AD_BREAK_VARS_LABEL");
        jLabel.setLabelFor(this.mBreakVariableList);
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, null);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        JScrollPane jScrollPane = new JScrollPane(this.mBreakVariableList);
        jScrollPane.setPreferredSize(this.mSourceVariableList.getPreferredSize());
        jScrollPane.setMinimumSize(this.mSourceVariableList.getPreferredSize());
        jScrollPane.setMaximumSize(this.mSourceVariableList.getPreferredSize());
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        DialogUtil.addUsingGBL(jPanel2, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, null);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n = 10;
        Insets insets2 = DialogUtil.getArrowButtonInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        DialogUtil.addUsingGBL(jPanel, this.mBreakVarArrow, gridBagConstraints, 0, 0, 1, 1, n, new Insets(insets2.top, insets2.left + n2, insets2.bottom, insets2.right));
        return jPanel;
    }

    private void buildLists() {
        TablesInfo tablesInfo = DBData.getDBData().getFilteredTablesInfo();
        this.mSourceListModel.clear();
        this.mBreakVariableListModel.clear();
        Selected selected = Selected.getSelected();
        List<SPSSColumn> list = selected.getSelectedColumns();
        for (SPSSColumn object : list) {
            DBListEntry dBListEntry = new DBListEntry(object, this.mWizardDialog.getResImageURL("IDS_DB_SELECT_DATA_COLUMNS_IMG"));
            this.mSourceListModel.addElement(dBListEntry);
        }
        List<ComputedColumn> list2 = ComputeNewFieldsPageInfo.getNewFieldsInfo().getNewColumns();
        if (list2.size() > 0) {
            for (ComputedColumn computedColumn : list2) {
                DBListEntry dBListEntry = new DBListEntry(computedColumn, this.mWizardDialog.getResImageURL("IDS_DB_SELECT_DATA_COLUMNS_IMG"));
                this.mSourceListModel.addElement(dBListEntry);
            }
        }
    }

    private void setupTable() {
        TableColumn tableColumn = this.mSummariesVarsTable.getColumnModel().getColumn(0);
        SummariesVaribleNameColumnRenderer summariesVaribleNameColumnRenderer = new SummariesVaribleNameColumnRenderer();
        tableColumn.setCellRenderer(summariesVaribleNameColumnRenderer);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItemListener(this);
        jComboBox.addItem(this.mWizardDialog.getResString("IDS_DB_AD_FUNCTION_COUNT"));
        jComboBox.addItem(this.mWizardDialog.getResString("IDS_DB_AD_FUNCTION_MAX"));
        jComboBox.addItem(this.mWizardDialog.getResString("IDS_DB_AD_FUNCTION_MEAN"));
        jComboBox.addItem(this.mWizardDialog.getResString("IDS_DB_AD_FUNCTION_MIN"));
        jComboBox.addItem(this.mWizardDialog.getResString("IDS_DB_AD_FUNCTION_SUM"));
        this.mNumericEditor = new DefaultCellEditor(jComboBox);
        tableColumn = this.mSummariesVarsTable.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new ComboBoxRenderer());
        jComboBox.setBackground(Color.WHITE);
        this.mSummariesVarsTable.setRowHeight(this.mSummariesVarsTable.getRowHeight() + 3);
        jComboBox = new JComboBox();
        jComboBox.addItemListener(this);
        jComboBox.addItem(this.mWizardDialog.getResString("IDS_DB_AD_FUNCTION_COUNT"));
        jComboBox.addItem(this.mWizardDialog.getResString("IDS_DB_AD_FUNCTION_MAX"));
        jComboBox.addItem(this.mWizardDialog.getResString("IDS_DB_AD_FUNCTION_MIN"));
        this.mStringEditor = new DefaultCellEditor(jComboBox);
        this.mSummariesVarsTable.setColumnSelectionAllowed(true);
        this.mSummariesVarsTable.setRowSelectionAllowed(true);
        this.mSummariesVarsTable.setSelectionMode(2);
        this.mSummariesVarsTable.getTableHeader().setReorderingAllowed(false);
        this.mSummariesVarsTable.getColumnModel().getColumn(0).setPreferredWidth(180);
        this.mSummariesVarsTable.getColumnModel().getColumn(1).setPreferredWidth(180);
        this.mSummariesVarsTable.setAutoResizeMode(3);
    }

    private String getFunctionSuffix(String string) {
        if (string.equals(this.mWizardDialog.getResString("IDS_DB_AD_FUNCTION_COUNT"))) {
            return this.mWizardDialog.getResString("IDS_DB_AD_FUNCTION_COUNT_SUFFIX");
        }
        if (string.equals(this.mWizardDialog.getResString("IDS_DB_AD_FUNCTION_SUM"))) {
            return this.mWizardDialog.getResString("IDS_DB_AD_FUNCTION_SUM_SUFFIX");
        }
        if (string.equals(this.mWizardDialog.getResString("IDS_DB_AD_FUNCTION_MEAN"))) {
            return this.mWizardDialog.getResString("IDS_DB_AD_FUNCTION_MEAN_SUFFIX");
        }
        if (string.equals(this.mWizardDialog.getResString("IDS_DB_AD_FUNCTION_MAX"))) {
            return this.mWizardDialog.getResString("IDS_DB_AD_FUNCTION_MAX_SUFFIX");
        }
        if (string.equals(this.mWizardDialog.getResString("IDS_DB_AD_FUNCTION_MIN"))) {
            return this.mWizardDialog.getResString("IDS_DB_AD_FUNCTION_MIN_SUFFIX");
        }
        return "";
    }

    private class ComboBoxRenderer
    extends DefaultTableCellRenderer {
        private ComboBoxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String[] stringArray = new String[]{object.toString()};
            JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
            jComboBox.setEditable(true);
            if (bl) {
                Border border = UIManager.getBorder("Table.focusCellHighlightBorder");
                jComboBox.setBorder(border);
            } else {
                LineBorder lineBorder = new LineBorder(Color.GRAY);
                jComboBox.setBorder(lineBorder);
            }
            return jComboBox;
        }
    }

    class SummariesVarsTableModel
    extends AbstractTableModel {
        private String[] mColNames;

        public SummariesVarsTableModel() {
            this.mColNames = new String[]{AggregateDataPage.this.mWizardDialog.getResString("IDS_DB_AD_NAME"), AggregateDataPage.this.mWizardDialog.getResString("IDS_DB_AD_FUNCTION")};
            AggregateDataPage.this.mAggregateVarRows = new ArrayList();
        }

        public ArrayList<AggregatedVariables> getAggregateVarRows() {
            return AggregateDataPage.this.mAggregateVarRows;
        }

        public void addRow(ODBCColumn oDBCColumn) {
            int n = oDBCColumn.getSPSSDataType();
            if (n == -1) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)AggregateDataPage.this.mWizardDialog), MessageFormat.format(AggregateDataPage.this.mWizardDialog.getResString("ERR_DB_AD_VARIABLE_SUMMARIZED"), oDBCColumn.getColumnName()), AggregateDataPage.this.mWizardDialog.getResString("IDS_DBWIZARD_WARNING_TITLE"));
                return;
            }
            boolean bl = false;
            if (n == 1) {
                bl = true;
            }
            String string = bl ? AggregateDataPage.this.mWizardDialog.getResString("IDS_DB_AD_FUNCTION_MAX") : AggregateDataPage.this.mWizardDialog.getResString("IDS_DB_AD_FUNCTION_SUM");
            String string2 = this.suggestAggregateName(oDBCColumn.getColumnName(), string);
            AggregatedVariables aggregatedVariables = new AggregatedVariables(oDBCColumn, oDBCColumn.getSPSSDataType(), string2, string, bl);
            AggregateDataPage.this.mAggregateVarRows.add(aggregatedVariables);
            this.fireTableDataChanged();
        }

        public void updateRow(String string) {
            int n = AggregateDataPage.this.mSummariesVarsTable.getSelectedRow();
            if (n >= 0 && n < AggregateDataPage.this.mAggregateVarRows.size()) {
                AggregatedVariables aggregatedVariables = (AggregatedVariables)AggregateDataPage.this.mAggregateVarRows.get(n);
                if (aggregatedVariables.getFunction().equals(string)) {
                    return;
                }
                String string2 = this.suggestAggregateName(aggregatedVariables.getColumnOriginalName(), string);
                aggregatedVariables.setVarName(string2);
                aggregatedVariables.setFunction(string);
                this.fireTableDataChanged();
            }
        }

        public String suggestAggregateName(String string, String string2) {
            boolean bl;
            String string3 = SPSSUtil.generateValidSpssName(string);
            String string4 = AggregateDataPage.this.getFunctionSuffix(string2);
            int n = 0;
            String string5 = string4;
            do {
                if (bl = this.isFullyQualifiedColumnNameUnique(string3 + "_" + string5)) continue;
                string5 = string4 + "_" + ++n;
            } while (!bl);
            return string3 + "_" + string5;
        }

        public void deleteRow(int n) {
            if (n >= 0 && n < AggregateDataPage.this.mAggregateVarRows.size()) {
                AggregateDataPage.this.mAggregateVarRows.remove(n);
            }
            this.fireTableRowsDeleted(n, n);
        }

        @Override
        public int getRowCount() {
            return AggregateDataPage.this.mAggregateVarRows.size();
        }

        @Override
        public int getColumnCount() {
            return this.mColNames.length;
        }

        public boolean isRowTypeString(int n) {
            if (n < AggregateDataPage.this.mAggregateVarRows.size()) {
                AggregatedVariables aggregatedVariables = (AggregatedVariables)AggregateDataPage.this.mAggregateVarRows.get(n);
                return aggregatedVariables.isStringType();
            }
            return false;
        }

        @Override
        public String getColumnName(int n) {
            return this.mColNames[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            AggregatedVariables aggregatedVariables = (AggregatedVariables)AggregateDataPage.this.mAggregateVarRows.get(n);
            switch (n2) {
                case 0: {
                    aggregatedVariables.setVarName(object.toString());
                }
                case 1: {
                    aggregatedVariables.setFunction(object.toString());
                }
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            AggregatedVariables aggregatedVariables = (AggregatedVariables)AggregateDataPage.this.mAggregateVarRows.get(n);
            switch (n2) {
                case 0: {
                    return aggregatedVariables.getVarName();
                }
                case 1: {
                    return aggregatedVariables.getFunction();
                }
            }
            return "";
        }

        private boolean isFullyQualifiedColumnNameUnique(String string) {
            for (AggregatedVariables aggregatedVariables : AggregateDataPage.this.mAggregateVarRows) {
                String string2 = aggregatedVariables.getVarName();
                if (!string.equals(string2)) continue;
                return false;
            }
            return true;
        }
    }

    class SummariesVaribleNameColumnRenderer
    extends DefaultTableCellRenderer {
        SummariesVaribleNameColumnRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n2 == 0) {
                component.setFont(jTable.getTableHeader().getFont());
                component.setForeground(jTable.getTableHeader().getForeground());
                component.setBackground(jTable.getTableHeader().getBackground());
            }
            if (bl) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            }
            return component;
        }
    }

    class SummariesVariablesTable
    extends PlainTable {
        AbstractTableModel mModel;

        public SummariesVariablesTable(SummariesVarsTableModel summariesVarsTableModel) {
            this.setModel(summariesVarsTableModel);
            this.mModel = summariesVarsTableModel;
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            SummariesVarsTableModel summariesVarsTableModel = (SummariesVarsTableModel)this.getModel();
            if (summariesVarsTableModel.isRowTypeString(n)) {
                return AggregateDataPage.this.mStringEditor;
            }
            return AggregateDataPage.this.mNumericEditor;
        }

        @Override
        public Vector<Object[]> getSelectedValues() {
            Vector<Object[]> vector = new Vector<Object[]>();
            AbstractTableModel abstractTableModel = this.mModel;
            if (abstractTableModel != null) {
                int[] nArray;
                for (int n : nArray = this.getSelectedRows()) {
                    Object[] objectArray = new Object[this.getColumnCount()];
                    for (int i = 0; i < this.getColumnCount(); ++i) {
                        objectArray[i] = abstractTableModel.getValueAt(n, i);
                    }
                    vector.add(objectArray);
                }
            }
            return vector;
        }
    }
}

