/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery.aggregate_data;

import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.controls.drag_drop.PlainTableDragAdapter;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.controls.drag_drop.DragPane;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class ADPTableDragAdapter
extends PlainTableDragAdapter {
    public static int sDraggedRow = -1;
    public static int sDraggedCol = -1;
    private static final int MAX_DRAG_IMAGE_ITEMS = 10;

    public ADPTableDragAdapter(PlainTable plainTable, DragPane dragPane, String string) {
        super(plainTable, dragPane, string);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Rectangle rectangle;
        this.mDndArmedEvent = null;
        if (mouseEvent.isConsumed() || mouseEvent.getButton() != 1 && mouseEvent.getButton() != 2) {
            return;
        }
        Component component = mouseEvent.getComponent();
        if (!(component instanceof PlainTable)) {
            assert (false);
            return;
        }
        PlainTable plainTable = (PlainTable)component;
        assert (this.mSourceTable == plainTable);
        if (!plainTable.isEnabled() || !plainTable.isDragSupported()) {
            return;
        }
        int n = this.mSourceTable.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.mSourceTable.columnAtPoint(mouseEvent.getPoint());
        Rectangle rectangle2 = rectangle = n > -1 ? this.mSourceTable.getCellRect(n, n2, false) : new Rectangle(0, 0, 0, 0);
        if (n > -1 && rectangle.contains(mouseEvent.getPoint())) {
            this.mSourceTable.setRowSelectionInterval(n, n);
            this.mDndArmedEvent = mouseEvent;
            mouseEvent.consume();
        }
    }

    @Override
    protected void startDrag(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        Component component = mouseEvent.getComponent();
        if (!(component instanceof PlainTable)) {
            assert (false);
            return;
        }
        PlainTable plainTable = (PlainTable)component;
        assert (this.mSourceTable == plainTable);
        Point point = (Point)mouseEvent.getPoint().clone();
        sDraggedRow = this.mSourceTable.rowAtPoint(point);
        sDraggedCol = this.mSourceTable.columnAtPoint(point);
        this.mSourceTable.getSelectedRow();
        this.mSourceTable.getSelectedValues();
        BufferedImage bufferedImage = this.getDragImage(this.mSourceTable);
        if (this.mTransferData == null) {
            this.acquireTransferData();
        }
        Point point2 = (Point)mouseEvent.getPoint().clone();
        SwingUtilities.convertPointToScreen(point2, component);
        SwingUtilities.convertPointFromScreen(point2, (Component)this.mDragPane);
        this.mDragPane.setDragImage(bufferedImage, false);
        this.mDragPane.setDragPoint(point);
        this.mDragPane.setVisible(true);
        this.mDragPane.repaint();
    }

    @Override
    protected BufferedImage getDragImage(Component component) {
        if (!(component instanceof PlainTable)) {
            assert (false);
            return null;
        }
        PlainTable plainTable = (PlainTable)component;
        int[] nArray = plainTable.getSelectedRows();
        if (nArray.length == 0) {
            return null;
        }
        Vector<Object[]> vector = plainTable.getSelectedValues();
        Dimension dimension = new Dimension(plainTable.getCellRect((int)nArray[0], (int)0, (boolean)false).width, plainTable.getRowHeight());
        boolean bl = nArray.length > 10;
        int n = !bl ? nArray.length : 10;
        Dimension dimension2 = new Dimension(dimension.width, dimension.height * n);
        if (bl) {
            dimension2.height += dimension.height;
        }
        BufferedImage bufferedImage = new BufferedImage(dimension2.width, dimension2.height, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setClip(0, 0, dimension2.width, dimension2.height);
        Point point = new Point(0, 0);
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = vector.get(i);
            Object object = null;
            if (objectArray instanceof Object[]) {
                object = objectArray[0];
            }
            JLabel jLabel = (JLabel)plainTable.getCellRenderer(nArray[i], 0).getTableCellRendererComponent(plainTable, object, false, false, nArray[i], 0);
            jLabel.setLocation(new Point(0, 0));
            jLabel.setSize(dimension.width, dimension.height);
            graphics2D.setComposite(AlphaComposite.getInstance(2, 0.5f));
            boolean bl2 = jLabel.isOpaque();
            jLabel.setOpaque(false);
            jLabel.paint(graphics2D);
            jLabel.setOpaque(bl2);
            graphics2D.translate(0, dimension.height);
            point.y += dimension.height;
        }
        if (bl) {
            String string = ResUtil.getCommonDlgString("IDS_MORE_ELLIPSIS");
            graphics2D.setFont(plainTable.getFont());
            graphics2D.drawString(string, 2, 14);
        }
        graphics2D.dispose();
        return bufferedImage;
    }
}

