/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery;

import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.ColumnsInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.IUIDataKeys;
import com.spss.java_client.ui.dialogs.base.file.openquery.aggregate_data.AggregatedVariablesOG;
import com.spss.java_client.ui.dialogs.base.file.openquery.compute_new_fields.ComputedFieldTableData;
import com.spss.java_client.ui.dialogs.base.file.openquery.limit_retrieved_cases.CriteriaTableData;
import com.spss.java_client.ui.dialogs.base.file.openquery.limit_retrieved_cases.PromptValuesData;
import com.spss.java_client.ui.dialogs.base.file.openquery.sort_cases.SortDataClassOG;
import com.spss.uitools.util.TraceSettings;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.tree.DefaultMutableTreeNode;

public class UIData
implements Serializable,
IUIDataKeys {
    private HashMap<String, Object> mUIControlSettingMap = new HashMap();
    private static UIData sInstance;
    private static final long serialVersionUID = 1008L;

    private UIData() {
    }

    public static UIData getUIData() {
        if (sInstance == null) {
            sInstance = new UIData();
        }
        return sInstance;
    }

    public Object getObject(String string) {
        return this.mUIControlSettingMap.get(string);
    }

    public void putObject(String string, Object object) {
        this.mUIControlSettingMap.put(string, object);
    }

    public void setUIData(UIData uIData) {
        sInstance = uIData;
    }

    public void clearMap() {
        this.mUIControlSettingMap.clear();
    }

    public void writeData(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.mUIControlSettingMap.size());
        for (Map.Entry<String, Object> entry : this.mUIControlSettingMap.entrySet()) {
            String string = entry.getKey();
            dataOutputStream.writeUTF(string);
            Class<?> clazz = this.getClassForKey(string);
            if (clazz == Boolean.class) {
                dataOutputStream.writeBoolean((Boolean)entry.getValue());
                continue;
            }
            if (clazz == String.class) {
                if (entry.getValue() instanceof Integer) {
                    dataOutputStream.writeUTF(((Integer)entry.getValue()).toString());
                    continue;
                }
                dataOutputStream.writeUTF((String)entry.getValue());
                continue;
            }
            if (clazz == Integer.class) {
                dataOutputStream.writeInt((Integer)entry.getValue());
                continue;
            }
            if (clazz == null) {
                this.writeSpecialData(dataOutputStream, string, entry.getValue());
                continue;
            }
            assert (false);
        }
    }

    public void readData(DataInputStream dataInputStream, int n) throws IOException {
        this.mUIControlSettingMap.clear();
        int n2 = dataInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            Object object;
            String string = dataInputStream.readUTF();
            Class<?> clazz = this.getClassForKey(string);
            if (clazz == Boolean.class) {
                object = dataInputStream.readBoolean();
            } else if (clazz == String.class) {
                object = dataInputStream.readUTF();
            } else if (clazz == Integer.class) {
                object = dataInputStream.readInt();
            } else if (clazz == null) {
                object = this.readSpecialData(dataInputStream, string);
            } else {
                TraceSettings.trace1((String)("!!! Bad ODBC file key:" + string), (int)15);
                continue;
            }
            if (object == null) continue;
            this.mUIControlSettingMap.put(string, object);
        }
    }

    private Class<?> getClassForKey(String string) {
        if ("WP_IS_ODBC".equals(string)) {
            return Boolean.class;
        }
        if ("WP_CONNECTION_STRING".equals(string)) {
            return String.class;
        }
        if ("WP_DATABASE_NAME".equals(string)) {
            return String.class;
        }
        if ("WP_SELECTED_TABLE_TYPES".equals(string)) {
            return String.class;
        }
        if ("SDP_SORT_FIELD_CHECK".equals(string)) {
            return Boolean.class;
        }
        if ("SDP_SHOW_TABLES_CHECK".equals(string)) {
            return Boolean.class;
        }
        if ("SDP_SHOW_VIEWS_CHECK".equals(string)) {
            return Boolean.class;
        }
        if ("SDP_SHOW_SYNONYM_CHECK".equals(string)) {
            return Boolean.class;
        }
        if ("SDP_SHOW_SYSTEM_TABLES_CHECK".equals(string)) {
            return Boolean.class;
        }
        if ("SRP_AUTO_JOIN_CHECK".equals(string)) {
            return Boolean.class;
        }
        if ("LRCP_USE_RANDOM_SAMPLING_CHECK".equals(string)) {
            return Boolean.class;
        }
        if ("LRCP_NATIVE_RANDOM_SAMPLING_RADIO".equals(string)) {
            return Boolean.class;
        }
        if ("LRCP_EXACTLY_TEXTFIELD1".equals(string)) {
            return String.class;
        }
        if ("LRCP_EXACTLY_TEXTFIELD2".equals(string)) {
            return String.class;
        }
        if ("LRCP_APPROXIMATELY_RADIO".equals(string)) {
            return Boolean.class;
        }
        if ("LRCP_APPROXIMATELY_SPINNER".equals(string)) {
            return Integer.class;
        }
        if ("ADP_NUMBER_CASES_CHECK".equals(string)) {
            return Boolean.class;
        }
        if ("DVP_VARIABLE_WIDTH_TEXT".equals(string)) {
            return String.class;
        }
        if ("DVP_MINIMIZE_STRING_WIDTHS".equals(string)) {
            return Boolean.class;
        }
        if ("RP_SQL_QUERY".equals(string)) {
            return String.class;
        }
        if ("RP_SAVE_FILENAME".equals(string)) {
            return String.class;
        }
        if ("RP_PASTE_RADIO".equals(string)) {
            return Boolean.class;
        }
        if ("RP_RETRIEVE_RADIO".equals(string)) {
            return Boolean.class;
        }
        if ("DBW_FINAL_SYNTAX".equals(string)) {
            return String.class;
        }
        if ("DBW_IS_REMOTE_CONNECTION".equals(string)) {
            return Boolean.class;
        }
        return null;
    }

    private Object readSpecialData(DataInputStream dataInputStream, String string) throws IOException {
        if (string.equals("DBW_DBDATA") || string.equals("DBW_UIDATA")) {
            return null;
        }
        Cloneable cloneable = null;
        if (string.equals("DBW_TEMP_TABLE_MAP")) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                hashMap.put(dataInputStream.readUTF(), dataInputStream.readUTF());
            }
            cloneable = hashMap;
        } else if (string.equals("SDP_EXPANDED_NODE")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                arrayList.add(dataInputStream.readUTF());
            }
            cloneable = arrayList;
        } else if (string.equals("SDP_REMOVE_TREE_NODE")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                arrayList.add(dataInputStream.readUTF());
            }
            cloneable = arrayList;
        } else if (string.equals("SDP_FILTERED_DATA_MAP")) {
            HashMap hashMap = new HashMap();
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                String string2 = dataInputStream.readUTF();
                ArrayList<String> arrayList = new ArrayList<String>();
                int n2 = dataInputStream.readInt();
                for (int j = 0; j < n2; ++j) {
                    arrayList.add(dataInputStream.readUTF());
                }
                hashMap.put(string2, arrayList);
            }
            cloneable = hashMap;
        } else if (string.equals("LRCP_CRITERIA_TABLE_MODEL")) {
            ArrayList<CriteriaTableData> arrayList = new ArrayList<CriteriaTableData>();
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                CriteriaTableData criteriaTableData = new CriteriaTableData();
                criteriaTableData.setConnector(dataInputStream.readUTF());
                criteriaTableData.setExpression1(dataInputStream.readUTF());
                criteriaTableData.setExpression2(dataInputStream.readUTF());
                criteriaTableData.setRelation(dataInputStream.readUTF());
                criteriaTableData.setSerialNumber(dataInputStream.readInt());
                arrayList.add(criteriaTableData);
            }
            cloneable = arrayList;
        } else if (string.equals("LRCP_PROMPT_DATA_VALUES_MAP")) {
            TreeMap<String, PromptValuesData> treeMap = new TreeMap<String, PromptValuesData>();
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                String string3 = dataInputStream.readUTF();
                PromptValuesData promptValuesData = new PromptValuesData();
                promptValuesData.setDefaultValue(dataInputStream.readUTF());
                promptValuesData.setPromptString(dataInputStream.readUTF());
                promptValuesData.setSelectedValue(dataInputStream.readInt());
                promptValuesData.setAllowListSelection(dataInputStream.readBoolean());
                promptValuesData.setDataType(PromptValuesData.PromptValuesDataType.fromInt(dataInputStream.readInt()));
                ArrayList<String> arrayList = new ArrayList<String>();
                int n3 = dataInputStream.readInt();
                for (int j = 0; j < n3; ++j) {
                    arrayList.add(dataInputStream.readUTF());
                }
                promptValuesData.setValuesList(arrayList);
                treeMap.put(string3, promptValuesData);
            }
            cloneable = treeMap;
        } else if (string.equals("ADP_SOURCE_LIST")) {
            ColumnsInfo columnsInfo = new ColumnsInfo();
            TreeMap<String, ColumnsInfo.InternalColumnInfo> treeMap = new TreeMap<String, ColumnsInfo.InternalColumnInfo>();
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                String string4 = dataInputStream.readUTF();
                ColumnsInfo.InternalColumnInfo internalColumnInfo = new ColumnsInfo.InternalColumnInfo(columnsInfo);
                this.readInternalColumnInfo(dataInputStream, internalColumnInfo);
                treeMap.put(string4, internalColumnInfo);
            }
            cloneable = treeMap;
        } else if (string.equals("ADP_BREAK_VARAIBLE_LIST")) {
            ColumnsInfo columnsInfo = new ColumnsInfo();
            TreeMap<String, ColumnsInfo.InternalColumnInfo> treeMap = new TreeMap<String, ColumnsInfo.InternalColumnInfo>();
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                String string5 = dataInputStream.readUTF();
                ColumnsInfo.InternalColumnInfo internalColumnInfo = new ColumnsInfo.InternalColumnInfo(columnsInfo);
                this.readInternalColumnInfo(dataInputStream, internalColumnInfo);
                treeMap.put(string5, internalColumnInfo);
            }
            cloneable = treeMap;
        } else if (string.equals("ADP_SUMMARIES_VARIABLE_TABLE")) {
            ArrayList<AggregatedVariablesOG> arrayList = new ArrayList<AggregatedVariablesOG>();
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                AggregatedVariablesOG aggregatedVariablesOG = new AggregatedVariablesOG();
                aggregatedVariablesOG.setColumnDisplayedName(dataInputStream.readUTF());
                aggregatedVariablesOG.setColumnOriginalName(dataInputStream.readUTF());
                aggregatedVariablesOG.setFunction(dataInputStream.readUTF());
                aggregatedVariablesOG.setFunctionSuffix(dataInputStream.readUTF());
                aggregatedVariablesOG.setOwnerName(dataInputStream.readUTF());
                aggregatedVariablesOG.setTableName(dataInputStream.readUTF());
                aggregatedVariablesOG.setColumnType(dataInputStream.readInt());
                aggregatedVariablesOG.setIsStringType(dataInputStream.readBoolean());
                arrayList.add(aggregatedVariablesOG);
            }
            cloneable = arrayList;
        } else if (string.equals("SDP_SOURCE_LIST")) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                arrayList.add(dataInputStream.readUTF());
            }
            cloneable = arrayList;
        } else if (string.equals("SDP_TARGET_TABLE")) {
            ArrayList<SortDataClassOG> arrayList = new ArrayList<SortDataClassOG>();
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                SortDataClassOG sortDataClassOG = new SortDataClassOG("", "");
                sortDataClassOG.setSortType(dataInputStream.readUTF());
                sortDataClassOG.setVariable(dataInputStream.readUTF());
                arrayList.add(sortDataClassOG);
            }
            cloneable = arrayList;
        } else if (string.equals("CNFP_TRANS_EXPR_TABLE")) {
            ArrayList<ComputedFieldTableData> arrayList = new ArrayList<ComputedFieldTableData>();
            int n = dataInputStream.readInt();
            for (int i = 0; i < n; ++i) {
                ComputedFieldTableData computedFieldTableData = new ComputedFieldTableData();
                computedFieldTableData.setFieldName(dataInputStream.readUTF());
                computedFieldTableData.setExpression(dataInputStream.readUTF());
                computedFieldTableData.setSerialNumber(dataInputStream.readInt());
                arrayList.add(computedFieldTableData);
            }
            cloneable = arrayList;
        } else {
            TraceSettings.trace1((String)("!!! Bad ODBC file key:" + string), (int)15);
        }
        return cloneable;
    }

    private void writeSpecialData(DataOutputStream dataOutputStream, String string, Object object) throws IOException {
        if (string.equals("DBW_DBDATA") || string.equals("DBW_UIDATA")) {
            return;
        }
        if (string.equals("DBW_TEMP_TABLE_MAP")) {
            HashMap hashMap = (HashMap)object;
            dataOutputStream.writeInt(hashMap.size());
            for (Map.Entry entry : hashMap.entrySet()) {
                dataOutputStream.writeUTF((String)entry.getKey());
                dataOutputStream.writeUTF((String)entry.getValue());
            }
        } else if (string.equals("SDP_EXPANDED_NODE")) {
            ArrayList arrayList = (ArrayList)object;
            dataOutputStream.writeInt(arrayList.size());
            for (String string2 : arrayList) {
                dataOutputStream.writeUTF(string2);
            }
        } else if (string.equals("SDP_REMOVE_TREE_NODE")) {
            ArrayList arrayList = (ArrayList)object;
            dataOutputStream.writeInt(arrayList.size());
            for (DefaultMutableTreeNode defaultMutableTreeNode : arrayList) {
                dataOutputStream.writeUTF((String)defaultMutableTreeNode.getUserObject());
            }
        } else if (string.equals("SDP_FILTERED_DATA_MAP")) {
            HashMap hashMap = (HashMap)object;
            dataOutputStream.writeInt(hashMap.size());
            for (Map.Entry entry : hashMap.entrySet()) {
                dataOutputStream.writeUTF((String)entry.getKey());
                ArrayList arrayList = (ArrayList)entry.getValue();
                dataOutputStream.writeInt(arrayList.size());
                for (String string3 : arrayList) {
                    dataOutputStream.writeUTF(string3);
                }
            }
        } else if (string.equals("LRCP_CRITERIA_TABLE_MODEL")) {
            ArrayList arrayList = (ArrayList)object;
            dataOutputStream.writeInt(arrayList.size());
            for (CriteriaTableData criteriaTableData : arrayList) {
                dataOutputStream.writeUTF(criteriaTableData.getConnector());
                dataOutputStream.writeUTF(criteriaTableData.getExpression1());
                dataOutputStream.writeUTF(criteriaTableData.getExpression2());
                dataOutputStream.writeUTF(criteriaTableData.getRelation());
                dataOutputStream.writeInt(criteriaTableData.getSerialNumber());
            }
        } else if (string.equals("LRCP_PROMPT_DATA_VALUES_MAP")) {
            TreeMap treeMap = (TreeMap)object;
            dataOutputStream.writeInt(treeMap.size());
            for (Map.Entry entry : treeMap.entrySet()) {
                dataOutputStream.writeUTF((String)entry.getKey());
                PromptValuesData promptValuesData = (PromptValuesData)entry.getValue();
                dataOutputStream.writeUTF(promptValuesData.getDefaultValue());
                dataOutputStream.writeUTF(promptValuesData.getPromptString());
                dataOutputStream.writeInt(promptValuesData.getSelectedValue());
                dataOutputStream.writeBoolean(promptValuesData.isAllowListSelection());
                dataOutputStream.writeInt(promptValuesData.getDataType().ordinal());
                ArrayList<String> arrayList = promptValuesData.getValuesList();
                dataOutputStream.writeInt(arrayList.size());
                for (String string4 : arrayList) {
                    dataOutputStream.writeUTF(string4);
                }
            }
        } else if (string.equals("ADP_SOURCE_LIST")) {
            TreeMap treeMap = (TreeMap)object;
            dataOutputStream.writeInt(treeMap.size());
            for (Map.Entry entry : treeMap.entrySet()) {
                dataOutputStream.writeUTF((String)entry.getKey());
                this.writeInternalColumnInfo(dataOutputStream, (ColumnsInfo.InternalColumnInfo)entry.getValue());
            }
        } else if (string.equals("ADP_BREAK_VARAIBLE_LIST")) {
            TreeMap treeMap = (TreeMap)object;
            dataOutputStream.writeInt(treeMap.size());
            for (Map.Entry entry : treeMap.entrySet()) {
                dataOutputStream.writeUTF((String)entry.getKey());
                this.writeInternalColumnInfo(dataOutputStream, (ColumnsInfo.InternalColumnInfo)entry.getValue());
            }
        } else if (string.equals("ADP_SUMMARIES_VARIABLE_TABLE")) {
            ArrayList arrayList = (ArrayList)object;
            dataOutputStream.writeInt(arrayList.size());
            for (AggregatedVariablesOG aggregatedVariablesOG : arrayList) {
                dataOutputStream.writeUTF(aggregatedVariablesOG.getColumnDisplayedName());
                dataOutputStream.writeUTF(aggregatedVariablesOG.getColumnOriginalName());
                dataOutputStream.writeUTF(aggregatedVariablesOG.getFunction());
                dataOutputStream.writeUTF(aggregatedVariablesOG.getFunctionSuffix());
                dataOutputStream.writeUTF(aggregatedVariablesOG.getOwnerName());
                dataOutputStream.writeUTF(aggregatedVariablesOG.getTableName());
                dataOutputStream.writeInt(aggregatedVariablesOG.getColumnType());
                dataOutputStream.writeBoolean(aggregatedVariablesOG.isStringType());
            }
        } else if (string.equals("SDP_SOURCE_LIST")) {
            ArrayList arrayList = (ArrayList)object;
            dataOutputStream.writeInt(arrayList.size());
            for (String string5 : arrayList) {
                dataOutputStream.writeUTF(string5);
            }
        } else if (string.equals("SDP_TARGET_TABLE")) {
            ArrayList arrayList = (ArrayList)object;
            dataOutputStream.writeInt(arrayList.size());
            for (SortDataClassOG sortDataClassOG : arrayList) {
                dataOutputStream.writeUTF(sortDataClassOG.getSortType());
                dataOutputStream.writeUTF(sortDataClassOG.getVariable());
            }
        } else if (string.equals("CNFP_TRANS_EXPR_TABLE")) {
            ArrayList arrayList = (ArrayList)object;
            dataOutputStream.writeInt(arrayList.size());
            for (ComputedFieldTableData computedFieldTableData : arrayList) {
                dataOutputStream.writeUTF(computedFieldTableData.getFieldName());
                dataOutputStream.writeUTF(computedFieldTableData.getExpression());
                dataOutputStream.writeInt(computedFieldTableData.getSerialNumber());
            }
        } else assert (false);
    }

    public String getString(String string) {
        return (String)this.getObject(string);
    }

    public Boolean getBoolean(String string) {
        return (Boolean)this.getObject(string);
    }

    public Integer getInteger(String string) {
        return (Integer)this.getObject(string);
    }

    private void writeInternalColumnInfo(DataOutputStream dataOutputStream, ColumnsInfo.InternalColumnInfo internalColumnInfo) throws IOException {
        dataOutputStream.writeUTF(internalColumnInfo.getStrColumnName());
        dataOutputStream.writeUTF(internalColumnInfo.getStrOwner());
        dataOutputStream.writeUTF(internalColumnInfo.getStrQualifier());
        dataOutputStream.writeUTF(internalColumnInfo.getStrRemarks());
        dataOutputStream.writeUTF(internalColumnInfo.getStrTableName());
        dataOutputStream.writeUTF(internalColumnInfo.getStrTypeName());
        dataOutputStream.writeInt(internalColumnInfo.getCBDataType());
        dataOutputStream.writeInt(internalColumnInfo.getCBLength());
        dataOutputStream.writeInt(internalColumnInfo.getCBNullable());
        dataOutputStream.writeInt(internalColumnInfo.getCBPrecision());
        dataOutputStream.writeInt(internalColumnInfo.getCBRadix());
        dataOutputStream.writeInt(internalColumnInfo.getCBScale());
        dataOutputStream.writeInt(internalColumnInfo.getILength());
        dataOutputStream.writeInt(internalColumnInfo.getIPrecision());
        dataOutputStream.writeShort(internalColumnInfo.getIDataType());
        dataOutputStream.writeShort(internalColumnInfo.getINullable());
        dataOutputStream.writeShort(internalColumnInfo.getIRadix());
        dataOutputStream.writeShort(internalColumnInfo.getIScale());
    }

    private void readInternalColumnInfo(DataInputStream dataInputStream, ColumnsInfo.InternalColumnInfo internalColumnInfo) throws IOException {
        internalColumnInfo.setStrColumnName(dataInputStream.readUTF());
        internalColumnInfo.setStrOwner(dataInputStream.readUTF());
        internalColumnInfo.setStrQualifier(dataInputStream.readUTF());
        internalColumnInfo.setStrRemarks(dataInputStream.readUTF());
        internalColumnInfo.setStrTableName(dataInputStream.readUTF());
        internalColumnInfo.setStrTypeName(dataInputStream.readUTF());
        internalColumnInfo.setCBDataType(dataInputStream.readInt());
        internalColumnInfo.setCBLength(dataInputStream.readInt());
        internalColumnInfo.setCBNullable(dataInputStream.readInt());
        internalColumnInfo.setCBPrecision(dataInputStream.readInt());
        internalColumnInfo.setCBRadix(dataInputStream.readInt());
        internalColumnInfo.setCBScale(dataInputStream.readInt());
        internalColumnInfo.setILength(dataInputStream.readInt());
        internalColumnInfo.setIPrecision(dataInputStream.readInt());
        internalColumnInfo.setIDataType(dataInputStream.readShort());
        internalColumnInfo.setINullable(dataInputStream.readShort());
        internalColumnInfo.setIRadix(dataInputStream.readShort());
        internalColumnInfo.setIScale(dataInputStream.readShort());
    }
}

