/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery;

import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.ColumnsInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBData;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBC;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.SPSSColumn;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ODBCSerializationContext {
    private DBData dbData = null;
    private Map<String, ODBCColumn> odbcColumnMap = null;
    private Map<String, ODBCColumn> odbcOGColumnMap = null;
    private Map<String, SPSSColumn> spssColumnMap = null;

    public ODBCSerializationContext(DBData dBData) {
        this.dbData = dBData;
        this.init();
    }

    private void init() {
        this.odbcColumnMap = new HashMap<String, ODBCColumn>();
        this.odbcOGColumnMap = new HashMap<String, ODBCColumn>();
        HashMap<String, ColumnsInfo> hashMap = this.dbData.getQualifiedColumnsInfo();
        Set<String> set = hashMap.keySet();
        for (String string : set) {
            ColumnsInfo columnsInfo = hashMap.get(string);
            Vector vector = columnsInfo.getColInfos();
            for (ColumnsInfo.InternalColumnInfo internalColumnInfo : vector) {
                String string2 = ODBCUtil.qualifyName(internalColumnInfo.getStrQualifier(), internalColumnInfo.getStrOwner(), internalColumnInfo.getStrTableName(), false);
                List<ODBCColumn> list = ODBC.getODBC().getColumns(string2);
                if (list == null) continue;
                for (ODBCColumn oDBCColumn : list) {
                    this.odbcColumnMap.put(oDBCColumn.getQualifiedColumnName(), oDBCColumn);
                    if (oDBCColumn.getOwner().length() > 0) {
                        this.odbcOGColumnMap.put(oDBCColumn.getOwner() + "." + oDBCColumn.getTableName() + ": " + oDBCColumn.getColumnName(), oDBCColumn);
                        continue;
                    }
                    this.odbcOGColumnMap.put(oDBCColumn.getTableName() + ": " + oDBCColumn.getColumnName(), oDBCColumn);
                }
            }
        }
    }

    public void setSPSSColumns(List<SPSSColumn> list) {
        this.spssColumnMap = new HashMap<String, SPSSColumn>(list.size());
        for (SPSSColumn sPSSColumn : list) {
            this.spssColumnMap.put(sPSSColumn.getQualifiedColumnName(), sPSSColumn);
        }
    }

    public ODBCColumn getODBCColumn(String string) {
        return this.odbcColumnMap.get(string);
    }

    public ODBCColumn getODBCColumnFromOldGenName(String string) {
        return this.odbcOGColumnMap.get(string);
    }

    public SPSSColumn getSPSSColumn(String string) {
        return this.spssColumnMap.get(string);
    }

    public SPSSColumn getUnqualifiedSPSSColumn(String string) {
        Collection<SPSSColumn> collection = this.spssColumnMap.values();
        for (SPSSColumn sPSSColumn : collection) {
            if (!sPSSColumn.getColumnName().equals(string)) continue;
            return sPSSColumn;
        }
        return null;
    }

    public static String getQualifiedTableName(ColumnsInfo.InternalColumnInfo internalColumnInfo) {
        return ODBCUtil.qualifyName(internalColumnInfo.getStrQualifier(), internalColumnInfo.getStrOwner(), internalColumnInfo.getStrTableName(), false);
    }

    public static String getQualifiedColumnName(ColumnsInfo.InternalColumnInfo internalColumnInfo) {
        return ODBCSerializationContext.getQualifiedTableName(internalColumnInfo) + '.' + internalColumnInfo.getStrColumnName();
    }
}

